static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Danny Robson <danny@blubinc.net>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description(_(\"Path of file to save.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_C_SOURCE save.c                                               \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"                                                                              \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationSink  parent_instance;                                         \n"
"  gpointer           properties;                                              \n"
"                                                                              \n"
"  GeglNode          *input;                                                   \n"
"  GeglNode          *save;                                                    \n"
"  gchar             *cached_path;                                             \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationSinkClass parent_class;                                        \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_SINK)                       \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_save_set_saver (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties  *o    = GEGL_PROPERTIES (operation);                        \n"
"  GeglOp   *self = GEGL_OP (operation);                                       \n"
"  const gchar *extension, *handler;                                           \n"
"                                                                              \n"
"  /* If prepare has already been invoked, bail out early */                   \n"
"  if (self->cached_path && !strcmp (o->path, self->cached_path))              \n"
"      return;                                                                 \n"
"  if (*o->path == '\\0')                                                      \n"
"    return;                                                                   \n"
"  g_free (self->cached_path);                                                 \n"
"                                                                              \n"
"  /* Find an extension handler and put it into the graph. The path can be     \n"
"   * empty, which indicates an error, but not null. Ideally we'd like to      \n"
"   * report an error here, but there's no way to pass it back to GEGL or the  \n"
"   * user in prepare()...                                                     \n"
"   */                                                                         \n"
"  g_assert (o->path);                                                         \n"
"  extension = strrchr (o->path, '.');                                         \n"
"  handler   = extension ? gegl_extension_handler_get_saver (extension) : NULL;\n"
"                                                                              \n"
"  if (handler)                                                                \n"
"    {                                                                         \n"
"      gegl_node_set (self->save,                                              \n"
"                     \"operation\", handler,                                  \n"
"                     \"path\",      o->path,                                  \n"
"                     NULL);                                                   \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      g_warning (\"Unable to find suitable save handler for path '%s'\", o->path);\n"
"      gegl_node_set (self->save,                                              \n"
"                     \"operation\", \"gegl:nop\",                             \n"
"                     NULL);                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  self->cached_path = g_strdup (o->path);                                     \n"
"  return;                                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* Create an input proxy, and temporary save operation, and link together.    \n"
" * These will be passed control when gegl_save_process is called later.       \n"
" */                                                                           \n"
"static void                                                                   \n"
"gegl_save_attach (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglOp   *self = GEGL_OP (operation);                                       \n"
"  /* const gchar *nodename; */                                                \n"
"  /* gchar       *childname; */                                               \n"
"                                                                              \n"
"  g_assert (!self->input);                                                    \n"
"  g_assert (!self->save);                                                     \n"
"  g_assert (!self->cached_path);                                              \n"
"                                                                              \n"
"  /* Initialise and attach child nodes */                                     \n"
"  self->input  = gegl_node_get_input_proxy (operation->node, \"input\");      \n"
"  self->save   = gegl_node_new_child (operation->node,                        \n"
"                                      \"operation\", \"gegl:nop\",            \n"
"                                      NULL);                                  \n"
"                                                                              \n"
"  /* Set some debug names for the child nodes */                              \n"
"  /*  nodename = gegl_node_get_debug_name (operation->node);                  \n"
"  g_assert (nodename);                                                        \n"
"                                                                              \n"
"  childname = g_strconcat (nodename, \"-save\", NULL);                        \n"
"  gegl_node_set_name (self->input, childname);                                \n"
"  g_free (childname);                                                         \n"
"                                                                              \n"
"  childname = g_strconcat (nodename, \"-input\", NULL);                       \n"
"  gegl_node_set_name (self->input, childname);                                \n"
"  g_free (childname);*/                                                       \n"
"                                                                              \n"
"  /* Link the saving node and attempt to set an appropriate save operation,   \n"
"   * might as well at least try to do this before prepare.                    \n"
"   */                                                                         \n"
"  gegl_node_link (self->input, self->save);                                   \n"
"  gegl_save_set_saver (operation);                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_save_set_property (GObject      *gobject,                                \n"
"                        guint         property_id,                            \n"
"                        const GValue *value,                                  \n"
"                        GParamSpec   *pspec)                                  \n"
"{                                                                             \n"
"  GeglOperation *operation = GEGL_OPERATION (gobject);                        \n"
"  GeglOp     *self = GEGL_OP (operation);                                     \n"
"                                                                              \n"
"  /* The set_property provided by the chant system does the                   \n"
"   * storing and reffing/unreffing of the input properties */                 \n"
"  set_property(gobject, property_id, value, pspec);                           \n"
"                                                                              \n"
"  if (self->save)                                                             \n"
"    gegl_save_set_saver (operation);                                          \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_save_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_pad,                          \n"
"                   const GeglRectangle  *roi,                                 \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (operation);                                         \n"
"                                                                              \n"
"  return gegl_operation_process (gegl_node_get_gegl_operation (self->save),   \n"
"                                 context,                                     \n"
"                                 output_pad,                                  \n"
"                                 roi,                                         \n"
"                                 level);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_save_dispose (GObject *object)                                           \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (object);                                            \n"
"                                                                              \n"
"  g_free (self->cached_path);                                                 \n"
"  self->cached_path = NULL;                                                   \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->dispose (object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass           *object_class    = G_OBJECT_CLASS (klass);           \n"
"  GeglOperationSinkClass *sink_class      = GEGL_OPERATION_SINK_CLASS (klass);\n"
"  GeglOperationClass     *operation_class = GEGL_OPERATION_CLASS (klass);     \n"
"                                                                              \n"
"  object_class->dispose      = gegl_save_dispose;                             \n"
"  object_class->set_property = gegl_save_set_property;                        \n"
"                                                                              \n"
"  operation_class->attach  = gegl_save_attach;                                \n"
"  operation_class->process = gegl_save_process;                               \n"
"                                                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:save\",                                           \n"
"    \"title\",       _(\"Save\"),                                             \n"
"    \"categories\" , \"meta:output\",                                         \n"
"    \"description\",                                                          \n"
"        _(\"Multipurpose file saver, that uses other native save handlers depending on extension, use the format specific save ops to specify additional parameters.\"),\n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
