/************************************************************/
/* THIS FILE IS GENERATED DO NOT EDIT */
/************************************************************/

/**
 * GAction:
 *
 * #GAction is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GAction:enabled:
 *
 * If @action is currently enabled.
 *
 * If the action is disabled then calls to g_action_activate() and
 * g_action_change_state() have no effect.
 *
 * Since: 2.28
 */


/**
 * GAction:name:
 *
 * The name of the action.  This is mostly meaningful for identifying
 * the action once it has been added to a #GActionGroup. It is immutable.
 *
 * Since: 2.28
 */


/**
 * GAction:parameter-type:
 *
 * The type of the parameter that must be given when activating the
 * action. This is immutable, and may be %NULL if no parameter is needed when
 * activating the action.
 *
 * Since: 2.28
 */


/**
 * GAction:state:
 *
 * The state of the action, or %NULL if the action is stateless.
 *
 * Since: 2.28
 */


/**
 * GAction:state-type:
 *
 * The #GVariantType of the state that the action has, or %NULL if the
 * action is stateless. This is immutable.
 *
 * Since: 2.28
 */


/**
 * GActionEntry:
 * @name: the name of the action
 * @activate: the callback to connect to the "activate" signal of the
 *            action.  Since GLib 2.40, this can be %NULL for stateful
 *            actions, in which case the default handler is used.  For
 *            boolean-stated actions with no parameter, this is a
 *            toggle.  For other state types (and parameter type equal
 *            to the state type) this will be a function that
 *            just calls @change_state (which you should provide).
 * @parameter_type: the type of the parameter that must be passed to the
 *                  activate function for this action, given as a single
 *                  GVariant type string (or %NULL for no parameter)
 * @state: the initial state for this action, given in
 *         [GVariant text format][gvariant-text].  The state is parsed
 *         with no extra type information, so type tags must be added to
 *         the string if they are necessary.  Stateless actions should
 *         give %NULL here.
 * @change_state: the callback to connect to the "change-state" signal
 *                of the action.  All stateful actions should provide a
 *                handler here; stateless actions should not.
 *
 * This struct defines a single action.  It is for use with
 * g_action_map_add_action_entries().
 *
 * The order of the items in the structure are intended to reflect
 * frequency of use.  It is permissible to use an incomplete initialiser
 * in order to leave some of the later values as %NULL.  All values
 * after @name are optional.  Additional optional fields may be added in
 * the future.
 *
 * See g_action_map_add_action_entries() for an example.
 */


/**
 * GActionGroup:
 *
 * #GActionGroup is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GActionGroup::action-added:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 *
 * Signals that a new action was just added to the group.
 * This signal is emitted after the action has been added
 * and is now visible.
 *
 * Since: 2.28
 */


/**
 * GActionGroup::action-enabled-changed:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 * @enabled: whether the action is enabled or not
 *
 * Signals that the enabled status of the named action has changed.
 *
 * Since: 2.28
 */


/**
 * GActionGroup::action-removed:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 *
 * Signals that an action is just about to be removed from the group.
 * This signal is emitted before the action is removed, so the action
 * is still visible and can be queried from the signal handler.
 *
 * Since: 2.28
 */


/**
 * GActionGroup::action-state-changed:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 * @value: the new value of the state
 *
 * Signals that the state of the named action has changed.
 *
 * Since: 2.28
 */


/**
 * GActionGroupInterface:
 * @has_action: the virtual function pointer for g_action_group_has_action()
 * @list_actions: the virtual function pointer for g_action_group_list_actions()
 * @get_action_parameter_type: the virtual function pointer for g_action_group_get_action_parameter_type()
 * @get_action_state_type: the virtual function pointer for g_action_group_get_action_state_type()
 * @get_action_state_hint: the virtual function pointer for g_action_group_get_action_state_hint()
 * @get_action_enabled: the virtual function pointer for g_action_group_get_action_enabled()
 * @get_action_state: the virtual function pointer for g_action_group_get_action_state()
 * @change_action_state: the virtual function pointer for g_action_group_change_action_state()
 * @query_action: the virtual function pointer for g_action_group_query_action()
 * @activate_action: the virtual function pointer for g_action_group_activate_action()
 * @action_added: the class closure for the #GActionGroup::action-added signal
 * @action_removed: the class closure for the #GActionGroup::action-removed signal
 * @action_enabled_changed: the class closure for the #GActionGroup::action-enabled-changed signal
 * @action_state_changed: the class closure for the #GActionGroup::action-enabled-changed signal
 *
 * The virtual function table for #GActionGroup.
 *
 * Since: 2.28
 */


/**
 * GActionInterface:
 * @get_name: the virtual function pointer for g_action_get_name()
 * @get_parameter_type: the virtual function pointer for g_action_get_parameter_type()
 * @get_state_type: the virtual function pointer for g_action_get_state_type()
 * @get_state_hint: the virtual function pointer for g_action_get_state_hint()
 * @get_enabled: the virtual function pointer for g_action_get_enabled()
 * @get_state: the virtual function pointer for g_action_get_state()
 * @change_state: the virtual function pointer for g_action_change_state()
 * @activate: the virtual function pointer for g_action_activate().  Note that #GAction does not have an
 *            'activate' signal but that implementations of it may have one.
 *
 * The virtual function table for #GAction.
 *
 * Since: 2.28
 */


/**
 * GActionMap:
 *
 * #GActionMap is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GActionMapInterface:
 * @lookup_action: the virtual function pointer for g_action_map_lookup_action()
 * @add_action: the virtual function pointer for g_action_map_add_action()
 * @remove_action: the virtual function pointer for g_action_map_remove_action()
 *
 * The virtual function table for #GActionMap.
 *
 * Since: 2.32
 */


/**
 * GAppInfoMonitor:
 *
 * The only thing you can do with this is to get it via
 * g_app_info_monitor_get() and connect to the "changed" signal.
 *
 * Since: 2.40
 */


/**
 * GAppInfoMonitor::changed:
 *
 * Signal emitted when the app info database changes, when applications are
 * installed or removed.
 *
 * Since: 2.40
 */


/**
 * GAppLaunchContext::launch-failed:
 * @context: the object emitting the signal
 * @startup_notify_id: the startup notification id for the failed launch
 *
 * The #GAppLaunchContext::launch-failed signal is emitted when a #GAppInfo launch
 * fails. The startup notification id is provided, so that the launcher
 * can cancel the startup notification.
 *
 * Because a launch operation may involve spawning multiple instances of the
 * target application, you should expect this signal to be emitted multiple
 * times, one for each spawned instance.
 *
 * Since: 2.36
 */


/**
 * GAppLaunchContext::launch-started:
 * @context: the object emitting the signal
 * @info: the #GAppInfo that is about to be launched
 * @platform_data: (nullable): additional platform-specific data for this launch
 *
 * The #GAppLaunchContext::launch-started signal is emitted when a #GAppInfo is
 * about to be launched. If non-null the @platform_data is an
 * GVariant dictionary mapping strings to variants (ie `a{sv}`), which
 * contains additional, platform-specific data about this launch. On
 * UNIX, at least the `startup-notification-id` keys will be
 * present.
 *
 * The value of the `startup-notification-id` key (type `s`) is a startup
 * notification ID corresponding to the format from the [startup-notification
 * specification](https://specifications.freedesktop.org/startup-notification-spec/startup-notification-0.1.txt).
 * It allows tracking the progress of the launchee through startup.
 *
 * It is guaranteed that this signal is followed by either a #GAppLaunchContext::launched or
 * #GAppLaunchContext::launch-failed signal.
 *
 * Because a launch operation may involve spawning multiple instances of the
 * target application, you should expect this signal to be emitted multiple
 * times, one for each spawned instance.
 *
 * Since: 2.72
 */


/**
 * GAppLaunchContext::launched:
 * @context: the object emitting the signal
 * @info: the #GAppInfo that was just launched
 * @platform_data: additional platform-specific data for this launch
 *
 * The #GAppLaunchContext::launched signal is emitted when a #GAppInfo is successfully
 * launched.
 *
 * Because a launch operation may involve spawning multiple instances of the
 * target application, you should expect this signal to be emitted multiple
 * times, one time for each spawned instance.
 *
 * The @platform_data is an GVariant dictionary mapping
 * strings to variants (ie `a{sv}`), which contains additional,
 * platform-specific data about this launch. On UNIX, at least the
 * `pid` and `startup-notification-id` keys will be present.
 *
 * Since 2.72 the `pid` may be 0 if the process id wasn't known (for
 * example if the process was launched via D-Bus). The `pid` may not be
 * set at all in subsequent releases.
 *
 * On Windows, `pid` is guaranteed to be valid only for the duration of the
 * #GAppLaunchContext::launched signal emission; after the signal is emitted,
 * GLib will call g_spawn_close_pid(). If you need to keep the #GPid after the
 * signal has been emitted, then you can duplicate `pid` using `DuplicateHandle()`.
 *
 * Since: 2.36
 */


/**
 * GApplication:
 *
 * #GApplication is an opaque data structure and can only be accessed
 * using the following functions.
 *
 * Since: 2.28
 */


/**
 * GApplication::activate:
 * @application: the application
 *
 * The ::activate signal is emitted on the primary instance when an
 * activation occurs. See g_application_activate().
 */


/**
 * GApplication::command-line:
 * @application: the application
 * @command_line: a #GApplicationCommandLine representing the
 *     passed commandline
 *
 * The ::command-line signal is emitted on the primary instance when
 * a commandline is not handled locally. See g_application_run() and
 * the #GApplicationCommandLine documentation for more information.
 *
 * Returns: An integer that is set as the exit status for the calling
 *   process. See g_application_command_line_set_exit_status().
 */


/**
 * GApplication::handle-local-options:
 * @application: the application
 * @options: the options dictionary
 *
 * The ::handle-local-options signal is emitted on the local instance
 * after the parsing of the commandline options has occurred.
 *
 * You can add options to be recognised during commandline option
 * parsing using g_application_add_main_option_entries() and
 * g_application_add_option_group().
 *
 * Signal handlers can inspect @options (along with values pointed to
 * from the @arg_data of an installed #GOptionEntrys) in order to
 * decide to perform certain actions, including direct local handling
 * (which may be useful for options like --version).
 *
 * In the event that the application is marked
 * %G_APPLICATION_HANDLES_COMMAND_LINE the "normal processing" will
 * send the @options dictionary to the primary instance where it can be
 * read with g_application_command_line_get_options_dict().  The signal
 * handler can modify the dictionary before returning, and the
 * modified dictionary will be sent.
 *
 * In the event that %G_APPLICATION_HANDLES_COMMAND_LINE is not set,
 * "normal processing" will treat the remaining uncollected command
 * line arguments as filenames or URIs.  If there are no arguments,
 * the application is activated by g_application_activate().  One or
 * more arguments results in a call to g_application_open().
 *
 * If you want to handle the local commandline arguments for yourself
 * by converting them to calls to g_application_open() or
 * g_action_group_activate_action() then you must be sure to register
 * the application first.  You should probably not call
 * g_application_activate() for yourself, however: just return -1 and
 * allow the default handler to do it for you.  This will ensure that
 * the `--gapplication-service` switch works properly (i.e. no activation
 * in that case).
 *
 * Note that this signal is emitted from the default implementation of
 * local_command_line().  If you override that function and don't
 * chain up then this signal will never be emitted.
 *
 * You can override local_command_line() if you need more powerful
 * capabilities than what is provided here, but this should not
 * normally be required.
 *
 * Returns: an exit code. If you have handled your options and want
 * to exit the process, return a non-negative option, 0 for success,
 * and a positive value for failure. To continue, return -1 to let
 * the default option processing continue.
 * Since: 2.40
 */


/**
 * GApplication::name-lost:
 * @application: the application
 *
 * The ::name-lost signal is emitted only on the registered primary instance
 * when a new instance has taken over. This can only happen if the application
 * is using the %G_APPLICATION_ALLOW_REPLACEMENT flag.
 *
 * The default handler for this signal calls g_application_quit().
 *
 * Returns: %TRUE if the signal has been handled
 * Since: 2.60
 */


/**
 * GApplication::open:
 * @application: the application
 * @files: (array length=n_files) (element-type GFile): an array of #GFiles
 * @n_files: the length of @files
 * @hint: a hint provided by the calling instance
 *
 * The ::open signal is emitted on the primary instance when there are
 * files to open. See g_application_open() for more information.
 */


/**
 * GApplication::shutdown:
 * @application: the application
 *
 * The ::shutdown signal is emitted only on the registered primary instance
 * immediately after the main loop terminates.
 */


/**
 * GApplication::startup:
 * @application: the application
 *
 * The ::startup signal is emitted on the primary instance immediately
 * after registration. See g_application_register().
 */


/**
 * GApplication:is-busy:
 *
 * Whether the application is currently marked as busy through
 * g_application_mark_busy() or g_application_bind_busy_property().
 *
 * Since: 2.44
 */


/**
 * GApplicationClass:
 * @startup: invoked on the primary instance immediately after registration
 * @shutdown: invoked only on the registered primary instance immediately
 *      after the main loop terminates
 * @activate: invoked on the primary instance when an activation occurs
 * @open: invoked on the primary instance when there are files to open
 * @command_line: invoked on the primary instance when a command-line is
 *   not handled locally
 * @local_command_line: invoked (locally). The virtual function has the chance
 *     to inspect (and possibly replace) command line arguments. See
 *     g_application_run() for more information. Also see the
 *     #GApplication::handle-local-options signal, which is a simpler
 *     alternative to handling some commandline options locally
 * @before_emit: invoked on the primary instance before 'activate', 'open',
 *     'command-line' or any action invocation, gets the 'platform data' from
 *     the calling instance
 * @after_emit: invoked on the primary instance after 'activate', 'open',
 *     'command-line' or any action invocation, gets the 'platform data' from
 *     the calling instance
 * @add_platform_data: invoked (locally) to add 'platform data' to be sent to
 *     the primary instance when activating, opening or invoking actions
 * @quit_mainloop: Used to be invoked on the primary instance when the use
 *     count of the application drops to zero (and after any inactivity
 *     timeout, if requested). Not used anymore since 2.32
 * @run_mainloop: Used to be invoked on the primary instance from
 *     g_application_run() if the use-count is non-zero. Since 2.32,
 *     GApplication is iterating the main context directly and is not
 *     using @run_mainloop anymore
 * @dbus_register: invoked locally during registration, if the application is
 *     using its D-Bus backend. You can use this to export extra objects on the
 *     bus, that need to exist before the application tries to own the bus name.
 *     The function is passed the #GDBusConnection to to session bus, and the
 *     object path that #GApplication will use to export is D-Bus API.
 *     If this function returns %TRUE, registration will proceed; otherwise
 *     registration will abort. Since: 2.34
 * @dbus_unregister: invoked locally during unregistration, if the application
 *     is using its D-Bus backend. Use this to undo anything done by
 *     the @dbus_register vfunc. Since: 2.34
 * @handle_local_options: invoked locally after the parsing of the commandline
 *  options has occurred. Since: 2.40
 * @name_lost: invoked when another instance is taking over the name. Since: 2.60
 *
 * Virtual function table for #GApplication.
 *
 * Since: 2.28
 */


/**
 * GApplicationCommandLine:
 *
 * #GApplicationCommandLine is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GApplicationCommandLineClass:
 *
 * The #GApplicationCommandLineClass-struct
 * contains private data only.
 *
 * Since: 2.28
 */


/**
 * GBytesIcon:bytes:
 *
 * The bytes containing the icon.
 */


/**
 * GCancellable::cancelled:
 * @cancellable: a #GCancellable.
 *
 * Emitted when the operation has been cancelled.
 *
 * Can be used by implementations of cancellable operations. If the
 * operation is cancelled from another thread, the signal will be
 * emitted in the thread that cancelled the operation, not the
 * thread that is running the operation.
 *
 * Note that disconnecting from this signal (or any signal) in a
 * multi-threaded program is prone to race conditions. For instance
 * it is possible that a signal handler may be invoked even after
 * a call to g_signal_handler_disconnect() for that handler has
 * already returned.
 *
 * There is also a problem when cancellation happens right before
 * connecting to the signal. If this happens the signal will
 * unexpectedly not be emitted, and checking before connecting to
 * the signal leaves a race condition where this is still happening.
 *
 * In order to make it safe and easy to connect handlers there
 * are two helper functions: g_cancellable_connect() and
 * g_cancellable_disconnect() which protect against problems
 * like this.
 *
 * An example of how to us this:
 * |[<!-- language="C" -->
 *     // Make sure we don't do unnecessary work if already cancelled
 *     if (g_cancellable_set_error_if_cancelled (cancellable, error))
 *       return;
 *
 *     // Set up all the data needed to be able to handle cancellation
 *     // of the operation
 *     my_data = my_data_new (...);
 *
 *     id = 0;
 *     if (cancellable)
 *       id = g_cancellable_connect (cancellable,
 *     			      G_CALLBACK (cancelled_handler)
 *     			      data, NULL);
 *
 *     // cancellable operation here...
 *
 *     g_cancellable_disconnect (cancellable, id);
 *
 *     // cancelled_handler is never called after this, it is now safe
 *     // to free the data
 *     my_data_free (my_data);
 * ]|
 *
 * Note that the cancelled signal is emitted in the thread that
 * the user cancelled from, which may be the main thread. So, the
 * cancellable signal should not do something that can block.
 */


/**
 * GCharsetConverter:
 *
 * Conversions between character sets.
 */


/**
 * GCredentials:
 *
 * The #GCredentials structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GCredentialsClass:
 *
 * Class structure for #GCredentials.
 *
 * Since: 2.26
 */


/**
 * GDBusActionGroup:
 *
 * #GDBusActionGroup is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GDBusAuthMechanism:credentials:
 *
 * If authenticating as a server, this property contains the
 * received credentials, if any.
 *
 * If authenticating as a client, the property contains the
 * credentials that were sent, if any.
 */


/**
 * GDBusAuthObserver:
 *
 * The #GDBusAuthObserver structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusAuthObserver::allow-mechanism:
 * @observer: The #GDBusAuthObserver emitting the signal.
 * @mechanism: The name of the mechanism, e.g. `DBUS_COOKIE_SHA1`.
 *
 * Emitted to check if @mechanism is allowed to be used.
 *
 * Returns: %TRUE if @mechanism can be used to authenticate the other peer, %FALSE if not.
 * Since: 2.34
 */


/**
 * GDBusAuthObserver::authorize-authenticated-peer:
 * @observer: The #GDBusAuthObserver emitting the signal.
 * @stream: A #GIOStream for the #GDBusConnection.
 * @credentials: (nullable): Credentials received from the peer or %NULL.
 *
 * Emitted to check if a peer that is successfully authenticated
 * is authorized.
 *
 * Returns: %TRUE if the peer is authorized, %FALSE if not.
 * Since: 2.26
 */


/**
 * GDBusAuthObserverClass:
 * @authorize_authenticated_peer: Signal class handler for the #GDBusAuthObserver::authorize-authenticated-peer signal.
 *
 * Class structure for #GDBusAuthObserverClass.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:
 *
 * The #GDBusConnection structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection::closed:
 * @connection: the #GDBusConnection emitting the signal
 * @remote_peer_vanished: %TRUE if @connection is closed because the
 *     remote peer closed its end of the connection
 * @error: (nullable): a #GError with more details about the event or %NULL
 *
 * Emitted when the connection is closed.
 *
 * The cause of this event can be
 *
 * - If g_dbus_connection_close() is called. In this case
 *   @remote_peer_vanished is set to %FALSE and @error is %NULL.
 *
 * - If the remote peer closes the connection. In this case
 *   @remote_peer_vanished is set to %TRUE and @error is set.
 *
 * - If the remote peer sends invalid or malformed data. In this
 *   case @remote_peer_vanished is set to %FALSE and @error is set.
 *
 * Upon receiving this signal, you should give up your reference to
 * @connection. You are guaranteed that this signal is emitted only
 * once.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:address:
 *
 * A D-Bus address specifying potential endpoints that can be used
 * when establishing the connection.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:authentication-observer:
 *
 * A #GDBusAuthObserver object to assist in the authentication process or %NULL.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:capabilities:
 *
 * Flags from the #GDBusCapabilityFlags enumeration
 * representing connection features negotiated with the other peer.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:closed:
 *
 * A boolean specifying whether the connection has been closed.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:exit-on-close:
 *
 * A boolean specifying whether the process will be terminated (by
 * calling `raise(SIGTERM)`) if the connection is closed by the
 * remote peer.
 *
 * Note that #GDBusConnection objects returned by g_bus_get_finish()
 * and g_bus_get_sync() will (usually) have this property set to %TRUE.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:flags:
 *
 * Flags from the #GDBusConnectionFlags enumeration.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:guid:
 *
 * The GUID of the peer performing the role of server when
 * authenticating.
 *
 * If you are constructing a #GDBusConnection and pass
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER in the
 * #GDBusConnection:flags property then you **must** also set this
 * property to a valid guid.
 *
 * If you are constructing a #GDBusConnection and pass
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT in the
 * #GDBusConnection:flags property you will be able to read the GUID
 * of the other peer here after the connection has been successfully
 * initialized.
 *
 * Note that the
 * [D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses)
 * uses the term ‘UUID’ to refer to this, whereas GLib consistently uses the
 * term ‘GUID’ for historical reasons.
 *
 * Despite its name, the format of #GDBusConnection:guid does not follow
 * [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122) or the Microsoft
 * GUID format.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:locked:
 *
 * A boolean specifying whether the message is locked.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:stream:
 *
 * The underlying #GIOStream used for I/O.
 *
 * If this is passed on construction and is a #GSocketConnection,
 * then the corresponding #GSocket will be put into non-blocking mode.
 *
 * While the #GDBusConnection is active, it will interact with this
 * stream from a worker thread, so it is not safe to interact with
 * the stream directly.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:unique-name:
 *
 * The unique name as assigned by the message bus or %NULL if the
 * connection is not open or not a message bus connection.
 *
 * Since: 2.26
 */


/**
 * GDBusConnectionClass:
 * @closed: Signal class handler for the #GDBusConnection::closed signal.
 *
 * Class structure for #GDBusConnection.
 *
 * Since: 2.26
 */


/**
 * GDBusInterfaceSkeleton::g-authorize-method:
 * @interface: The #GDBusInterfaceSkeleton emitting the signal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Emitted when a method is invoked by a remote caller and used to
 * determine if the method call is authorized.
 *
 * Note that this signal is emitted in a thread dedicated to
 * handling the method call so handlers are allowed to perform
 * blocking IO. This means that it is appropriate to call e.g.
 * [polkit_authority_check_authorization_sync()](http://hal.freedesktop.org/docs/polkit/PolkitAuthority.html#polkit-authority-check-authorization-sync)
 * with the
 * [POLKIT_CHECK_AUTHORIZATION_FLAGS_ALLOW_USER_INTERACTION](http://hal.freedesktop.org/docs/polkit/PolkitAuthority.html#POLKIT-CHECK-AUTHORIZATION-FLAGS-ALLOW-USER-INTERACTION:CAPS)
 * flag set.
 *
 * If %FALSE is returned then no further handlers are run and the
 * signal handler must take a reference to @invocation and finish
 * handling the call (e.g. return an error via
 * g_dbus_method_invocation_return_error()).
 *
 * Otherwise, if %TRUE is returned, signal emission continues. If no
 * handlers return %FALSE, then the method is dispatched. If
 * @interface has an enclosing #GDBusObjectSkeleton, then the
 * #GDBusObjectSkeleton::authorize-method signal handlers run before
 * the handlers for this signal.
 *
 * The default class handler just returns %TRUE.
 *
 * Please note that the common case is optimized: if no signals
 * handlers are connected and the default class handler isn't
 * overridden (for both @interface and the enclosing
 * #GDBusObjectSkeleton, if any) and #GDBusInterfaceSkeleton:g-flags does
 * not have the
 * %G_DBUS_INTERFACE_SKELETON_FLAGS_HANDLE_METHOD_INVOCATIONS_IN_THREAD
 * flags set, no dedicated thread is ever used and the call will be
 * handled in the same thread as the object that @interface belongs
 * to was exported in.
 *
 * Returns: %TRUE if the call is authorized, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * GDBusInterfaceSkeleton:g-flags:
 *
 * Flags from the #GDBusInterfaceSkeletonFlags enumeration.
 *
 * Since: 2.30
 */


/**
 * GDBusMenuModel:
 *
 * #GDBusMenuModel is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GDBusMessage:
 *
 * The #GDBusMessage structure contains only private data and should
 * only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusMessageClass:
 *
 * Class structure for #GDBusMessage.
 *
 * Since: 2.26
 */


/**
 * GDBusMethodInvocation:
 *
 * The #GDBusMethodInvocation structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusMethodInvocationClass:
 *
 * Class structure for #GDBusMethodInvocation.
 *
 * Since: 2.26
 */


/**
 * GDBusObject:
 *
 * #GDBusObject is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GDBusObject::interface-added:
 * @object: The #GDBusObject emitting the signal.
 * @interface: The #GDBusInterface that was added.
 *
 * Emitted when @interface is added to @object.
 *
 * Since: 2.30
 */


/**
 * GDBusObject::interface-removed:
 * @object: The #GDBusObject emitting the signal.
 * @interface: The #GDBusInterface that was removed.
 *
 * Emitted when @interface is removed from @object.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager:
 *
 * #GDBusObjectManager is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GDBusObjectManager::interface-added:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject on which an interface was added.
 * @interface: The #GDBusInterface that was added.
 *
 * Emitted when @interface is added to @object.
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all objects managed by @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::interface-removed:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject on which an interface was removed.
 * @interface: The #GDBusInterface that was removed.
 *
 * Emitted when @interface has been removed from @object.
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all objects managed by @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::object-added:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject that was added.
 *
 * Emitted when @object is added to @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::object-removed:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject that was removed.
 *
 * Emitted when @object is removed from @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient::interface-proxy-properties-changed:
 * @manager: The #GDBusObjectManagerClient emitting the signal.
 * @object_proxy: The #GDBusObjectProxy on which an interface has properties that are changing.
 * @interface_proxy: The #GDBusProxy that has properties that are changing.
 * @changed_properties: A #GVariant containing the properties that changed (type: `a{sv}`).
 * @invalidated_properties: (array zero-terminated=1) (element-type utf8): A %NULL terminated
 *   array of properties that were invalidated.
 *
 * Emitted when one or more D-Bus properties on proxy changes. The
 * local cache has already been updated when this signal fires. Note
 * that both @changed_properties and @invalidated_properties are
 * guaranteed to never be %NULL (either may be empty though).
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all interface proxies managed by @manager.
 *
 * This signal is emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * that @manager was constructed in.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient::interface-proxy-signal:
 * @manager: The #GDBusObjectManagerClient emitting the signal.
 * @object_proxy: The #GDBusObjectProxy on which an interface is emitting a D-Bus signal.
 * @interface_proxy: The #GDBusProxy that is emitting a D-Bus signal.
 * @sender_name: The sender of the signal or NULL if the connection is not a bus connection.
 * @signal_name: The signal name.
 * @parameters: A #GVariant tuple with parameters for the signal.
 *
 * Emitted when a D-Bus signal is received on @interface_proxy.
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all interface proxies managed by @manager.
 *
 * This signal is emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * that @manager was constructed in.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:bus-type:
 *
 * If this property is not %G_BUS_TYPE_NONE, then
 * #GDBusObjectManagerClient:connection must be %NULL and will be set to the
 * #GDBusConnection obtained by calling g_bus_get() with the value
 * of this property.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:connection:
 *
 * The #GDBusConnection to use.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:flags:
 *
 * Flags from the #GDBusObjectManagerClientFlags enumeration.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:get-proxy-type-destroy-notify:
 *
 * A #GDestroyNotify for the #gpointer user_data in #GDBusObjectManagerClient:get-proxy-type-user-data.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:get-proxy-type-func:
 *
 * The #GDBusProxyTypeFunc to use when determining what #GType to
 * use for interface proxies or %NULL.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:get-proxy-type-user-data:
 *
 * The #gpointer user_data to pass to #GDBusObjectManagerClient:get-proxy-type-func.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:name:
 *
 * The well-known name or unique name that the manager is for.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:name-owner:
 *
 * The unique name that owns #GDBusObjectManagerClient:name or %NULL if
 * no-one is currently owning the name. Connect to the
 * #GObject::notify signal to track changes to this property.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:object-path:
 *
 * The object path the manager is for.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerServer:connection:
 *
 * The #GDBusConnection to export objects on.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerServer:object-path:
 *
 * The object path to register the manager object at.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectProxy:g-connection:
 *
 * The connection of the proxy.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectProxy:g-object-path:
 *
 * The object path of the proxy.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectSkeleton::authorize-method:
 * @object: The #GDBusObjectSkeleton emitting the signal.
 * @interface: The #GDBusInterfaceSkeleton that @invocation is for.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Emitted when a method is invoked by a remote caller and used to
 * determine if the method call is authorized.
 *
 * This signal is like #GDBusInterfaceSkeleton's
 * #GDBusInterfaceSkeleton::g-authorize-method signal,
 * except that it is for the enclosing object.
 *
 * The default class handler just returns %TRUE.
 *
 * Returns: %TRUE if the call is authorized, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * GDBusObjectSkeleton:g-object-path:
 *
 * The object path where the object is exported.
 *
 * Since: 2.30
 */


/**
 * GDBusProxy::g-properties-changed:
 * @proxy: The #GDBusProxy emitting the signal.
 * @changed_properties: A #GVariant containing the properties that changed (type: `a{sv}`)
 * @invalidated_properties: A %NULL terminated array of properties that was invalidated
 *
 * Emitted when one or more D-Bus properties on @proxy changes. The
 * local cache has already been updated when this signal fires. Note
 * that both @changed_properties and @invalidated_properties are
 * guaranteed to never be %NULL (either may be empty though).
 *
 * If the proxy has the flag
 * %G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES set, then
 * @invalidated_properties will always be empty.
 *
 * This signal corresponds to the
 * `PropertiesChanged` D-Bus signal on the
 * `org.freedesktop.DBus.Properties` interface.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy::g-signal:
 * @proxy: The #GDBusProxy emitting the signal.
 * @sender_name: (nullable): The sender of the signal or %NULL if the connection is not a bus connection.
 * @signal_name: The name of the signal.
 * @parameters: A #GVariant tuple with parameters for the signal.
 *
 * Emitted when a signal from the remote object and interface that @proxy is for, has been received.
 *
 * Since 2.72 this signal supports detailed connections. You can connect to
 * the detailed signal `g-signal::x` in order to receive callbacks only when
 * signal `x` is received from the remote object.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-bus-type:
 *
 * If this property is not %G_BUS_TYPE_NONE, then
 * #GDBusProxy:g-connection must be %NULL and will be set to the
 * #GDBusConnection obtained by calling g_bus_get() with the value
 * of this property.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-connection:
 *
 * The #GDBusConnection the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-default-timeout:
 *
 * The timeout to use if -1 (specifying default timeout) is passed
 * as @timeout_msec in the g_dbus_proxy_call() and
 * g_dbus_proxy_call_sync() functions.
 *
 * This allows applications to set a proxy-wide timeout for all
 * remote method invocations on the proxy. If this property is -1,
 * the default timeout (typically 25 seconds) is used. If set to
 * %G_MAXINT, then no timeout is used.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-flags:
 *
 * Flags from the #GDBusProxyFlags enumeration.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-interface-info:
 *
 * Ensure that interactions with this proxy conform to the given
 * interface. This is mainly to ensure that malformed data received
 * from the other peer is ignored. The given #GDBusInterfaceInfo is
 * said to be the "expected interface".
 *
 * The checks performed are:
 * - When completing a method call, if the type signature of
 *   the reply message isn't what's expected, the reply is
 *   discarded and the #GError is set to %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * - Received signals that have a type signature mismatch are dropped and
 *   a warning is logged via g_warning().
 *
 * - Properties received via the initial `GetAll()` call or via the
 *   `::PropertiesChanged` signal (on the
 *   [org.freedesktop.DBus.Properties](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-properties)
 *   interface) or set using g_dbus_proxy_set_cached_property()
 *   with a type signature mismatch are ignored and a warning is
 *   logged via g_warning().
 *
 * Note that these checks are never done on methods, signals and
 * properties that are not referenced in the given
 * #GDBusInterfaceInfo, since extending a D-Bus interface on the
 * service-side is not considered an ABI break.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-interface-name:
 *
 * The D-Bus interface name the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-name:
 *
 * The well-known or unique name that the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-name-owner:
 *
 * The unique name that owns #GDBusProxy:g-name or %NULL if no-one
 * currently owns that name. You may connect to #GObject::notify signal to
 * track changes to this property.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-object-path:
 *
 * The object path the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:
 *
 * The #GDBusServer structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusServer::new-connection:
 * @server: The #GDBusServer emitting the signal.
 * @connection: A #GDBusConnection for the new connection.
 *
 * Emitted when a new authenticated connection has been made. Use
 * g_dbus_connection_get_peer_credentials() to figure out what
 * identity (if any), was authenticated.
 *
 * If you want to accept the connection, take a reference to the
 * @connection object and return %TRUE. When you are done with the
 * connection call g_dbus_connection_close() and give up your
 * reference. Note that the other peer may disconnect at any time -
 * a typical thing to do when accepting a connection is to listen to
 * the #GDBusConnection::closed signal.
 *
 * If #GDBusServer:flags contains %G_DBUS_SERVER_FLAGS_RUN_IN_THREAD
 * then the signal is emitted in a new thread dedicated to the
 * connection. Otherwise the signal is emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread that @server was constructed in.
 *
 * You are guaranteed that signal handlers for this signal runs
 * before incoming messages on @connection are processed. This means
 * that it's suitable to call g_dbus_connection_register_object() or
 * similar from the signal handler.
 *
 * Returns: %TRUE to claim @connection, %FALSE to let other handlers
 * run.
 * Since: 2.26
 */


/**
 * GDBusServer:active:
 *
 * Whether the server is currently active.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:address:
 *
 * The D-Bus address to listen on.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:authentication-observer:
 *
 * A #GDBusAuthObserver object to assist in the authentication process or %NULL.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:client-address:
 *
 * The D-Bus address that clients can use.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:flags:
 *
 * Flags from the #GDBusServerFlags enumeration.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:guid:
 *
 * The GUID of the server.
 *
 * See #GDBusConnection:guid for more details.
 *
 * Since: 2.26
 */


/**
 * GDBusServerClass:
 * @new_connection: Signal class handler for the #GDBusServer::new-connection signal.
 *
 * Class structure for #GDBusServer.
 *
 * Since: 2.26
 */


/**
 * GDataInputStream:byte-order:
 *
 * The :byte-order property determines the byte ordering that
 * is used when reading multi-byte entities (such as integers)
 * from the stream.
 */


/**
 * GDataInputStream:newline-type:
 *
 * The :newline-type property determines what is considered
 * as a line ending when reading complete lines from the stream.
 */


/**
 * GDataOutputStream:byte-order:
 *
 * Determines the byte ordering that is used when writing
 * multi-byte entities (such as integers) to the stream.
 */


/**
 * GDebugController:debug-enabled:
 *
 * %TRUE if debug output should be exposed (for example by forwarding it to
 * the journal), %FALSE otherwise.
 *
 * Since: 2.72
 */


/**
 * GDebugControllerDBus::authorize:
 * @controller: The #GDebugControllerDBus emitting the signal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Emitted when a D-Bus peer is trying to change the debug settings and used
 * to determine if that is authorized.
 *
 * This signal is emitted in a dedicated worker thread, so handlers are
 * allowed to perform blocking I/O. This means that, for example, it is
 * appropriate to call `polkit_authority_check_authorization_sync()` to check
 * authorization using polkit.
 *
 * If %FALSE is returned then no further handlers are run and the request to
 * change the debug settings is rejected.
 *
 * Otherwise, if %TRUE is returned, signal emission continues. If no handlers
 * return %FALSE, then the debug settings are allowed to be changed.
 *
 * Signal handlers must not modify @invocation, or cause it to return a value.
 *
 * The default class handler just returns %TRUE.
 *
 * Returns: %TRUE if the call is authorized, %FALSE otherwise.
 * Since: 2.72
 */


/**
 * GDebugControllerDBus:connection:
 *
 * The D-Bus connection to expose the debugging interface on.
 *
 * Typically this will be the same connection (to the system or session bus)
 * which the rest of the application or service’s D-Bus objects are registered
 * on.
 *
 * Since: 2.72
 */


/**
 * GDesktopAppInfo:
 *
 * Information about an installed application from a desktop file.
 */


/**
 * GDesktopAppInfo:filename:
 *
 * The origin filename of this #GDesktopAppInfo
 */


/**
 * GDesktopAppInfoLookup:
 *
 * #GDesktopAppInfoLookup is an opaque data structure and can only be accessed
 * using the following functions.
 *
 * Deprecated: 2.28: The #GDesktopAppInfoLookup interface is deprecated and
 *    unused by GIO.
 */


/**
 * GDrive::changed:
 * @drive: a #GDrive.
 *
 * Emitted when the drive's state has changed.
 */


/**
 * GDrive::disconnected:
 * @drive: a #GDrive.
 *
 * This signal is emitted when the #GDrive have been
 * disconnected. If the recipient is holding references to the
 * object they should release them so the object can be
 * finalized.
 */


/**
 * GDrive::eject-button:
 * @drive: a #GDrive.
 *
 * Emitted when the physical eject button (if any) of a drive has
 * been pressed.
 */


/**
 * GDrive::stop-button:
 * @drive: a #GDrive.
 *
 * Emitted when the physical stop button (if any) of a drive has
 * been pressed.
 *
 * Since: 2.22
 */


/**
 * GDtlsClientConnection:
 *
 * Abstract base class for the backend-specific client connection
 * type.
 *
 * Since: 2.48
 */


/**
 * GDtlsClientConnection:accepted-cas: (type GLib.List) (element-type GLib.ByteArray)
 *
 * A list of the distinguished names of the Certificate Authorities
 * that the server will accept client certificates signed by. If the
 * server requests a client certificate during the handshake, then
 * this property will be set after the handshake completes.
 *
 * Each item in the list is a #GByteArray which contains the complete
 * subject DN of the certificate authority.
 *
 * Since: 2.48
 */


/**
 * GDtlsClientConnection:server-identity:
 *
 * A #GSocketConnectable describing the identity of the server that
 * is expected on the other end of the connection.
 *
 * If the %G_TLS_CERTIFICATE_BAD_IDENTITY flag is set in
 * #GDtlsClientConnection:validation-flags, this object will be used
 * to determine the expected identify of the remote end of the
 * connection; if #GDtlsClientConnection:server-identity is not set,
 * or does not match the identity presented by the server, then the
 * %G_TLS_CERTIFICATE_BAD_IDENTITY validation will fail.
 *
 * In addition to its use in verifying the server certificate,
 * this is also used to give a hint to the server about what
 * certificate we expect, which is useful for servers that serve
 * virtual hosts.
 *
 * Since: 2.48
 */


/**
 * GDtlsClientConnection:validation-flags:
 *
 * What steps to perform when validating a certificate received from
 * a server. Server certificates that fail to validate in any of the
 * ways indicated here will be rejected unless the application
 * overrides the default via #GDtlsConnection::accept-certificate.
 *
 * GLib guarantees that if certificate verification fails, at least one
 * flag will be set, but it does not guarantee that all possible flags
 * will be set. Accordingly, you may not safely decide to ignore any
 * particular type of error. For example, it would be incorrect to mask
 * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired certificates,
 * because this could potentially be the only error flag set even if
 * other problems exist with the certificate. Therefore, there is no
 * safe way to use this property. This is not a horrible problem,
 * though, because you should not be attempting to ignore validation
 * errors anyway. If you really must ignore TLS certificate errors,
 * connect to #GDtlsConnection::accept-certificate.
 *
 * Since: 2.48
 * Deprecated: 2.74: Do not attempt to ignore validation errors.
 */


/**
 * GDtlsConnection:
 *
 * Abstract base class for the backend-specific #GDtlsClientConnection
 * and #GDtlsServerConnection types.
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection::accept-certificate:
 * @conn: a #GDtlsConnection
 * @peer_cert: the peer's #GTlsCertificate
 * @errors: the problems with @peer_cert.
 *
 * Emitted during the TLS handshake after the peer certificate has
 * been received. You can examine @peer_cert's certification path by
 * calling g_tls_certificate_get_issuer() on it.
 *
 * For a client-side connection, @peer_cert is the server's
 * certificate, and the signal will only be emitted if the
 * certificate was not acceptable according to @conn's
 * #GDtlsClientConnection:validation_flags. If you would like the
 * certificate to be accepted despite @errors, return %TRUE from the
 * signal handler. Otherwise, if no handler accepts the certificate,
 * the handshake will fail with %G_TLS_ERROR_BAD_CERTIFICATE.
 *
 * GLib guarantees that if certificate verification fails, this signal
 * will be emitted with at least one error will be set in @errors, but
 * it does not guarantee that all possible errors will be set.
 * Accordingly, you may not safely decide to ignore any particular
 * type of error. For example, it would be incorrect to ignore
 * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired
 * certificates, because this could potentially be the only error flag
 * set even if other problems exist with the certificate.
 *
 * For a server-side connection, @peer_cert is the certificate
 * presented by the client, if this was requested via the server's
 * #GDtlsServerConnection:authentication_mode. On the server side,
 * the signal is always emitted when the client presents a
 * certificate, and the certificate will only be accepted if a
 * handler returns %TRUE.
 *
 * Note that if this signal is emitted as part of asynchronous I/O
 * in the main thread, then you should not attempt to interact with
 * the user before returning from the signal handler. If you want to
 * let the user decide whether or not to accept the certificate, you
 * would have to return %FALSE from the signal handler on the first
 * attempt, and then after the connection attempt returns a
 * %G_TLS_ERROR_BAD_CERTIFICATE, you can interact with the user, and
 * if the user decides to accept the certificate, remember that fact,
 * create a new connection, and return %TRUE from the signal handler
 * the next time.
 *
 * If you are doing I/O in another thread, you do not
 * need to worry about this, and can simply block in the signal
 * handler until the UI thread returns an answer.
 *
 * Returns: %TRUE to accept @peer_cert (which will also
 * immediately end the signal emission). %FALSE to allow the signal
 * emission to continue, which will cause the handshake to fail if
 * no one else overrides it.
 * Since: 2.48
 */


/**
 * GDtlsConnection:advertised-protocols: (nullable)
 *
 * The list of application-layer protocols that the connection
 * advertises that it is willing to speak. See
 * g_dtls_connection_set_advertised_protocols().
 *
 * Since: 2.60
 */


/**
 * GDtlsConnection:base-socket:
 *
 * The #GDatagramBased that the connection wraps. Note that this may be any
 * implementation of #GDatagramBased, not just a #GSocket.
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection:certificate:
 *
 * The connection's certificate; see
 * g_dtls_connection_set_certificate().
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection:ciphersuite-name: (nullable)
 *
 * The name of the DTLS ciphersuite in use. See g_dtls_connection_get_ciphersuite_name().
 *
 * Since: 2.70
 */


/**
 * GDtlsConnection:database: (nullable)
 *
 * The certificate database to use when verifying this TLS connection.
 * If no certificate database is set, then the default database will be
 * used. See g_tls_backend_get_default_database().
 *
 * When using a non-default database, #GDtlsConnection must fall back to using
 * the #GTlsDatabase to perform certificate verification using
 * g_tls_database_verify_chain(), which means certificate verification will
 * not be able to make use of TLS session context. This may be less secure.
 * For example, if you create your own #GTlsDatabase that just wraps the
 * default #GTlsDatabase, you might expect that you have not changed anything,
 * but this is not true because you may have altered the behavior of
 * #GDtlsConnection by causing it to use g_tls_database_verify_chain(). See the
 * documentation of g_tls_database_verify_chain() for more details on specific
 * security checks that may not be performed. Accordingly, setting a
 * non-default database is discouraged except for specialty applications with
 * unusual security requirements.
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection:interaction: (nullable)
 *
 * A #GTlsInteraction object to be used when the connection or certificate
 * database need to interact with the user. This will be used to prompt the
 * user for passwords where necessary.
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection:negotiated-protocol:
 *
 * The application-layer protocol negotiated during the TLS
 * handshake. See g_dtls_connection_get_negotiated_protocol().
 *
 * Since: 2.60
 */


/**
 * GDtlsConnection:peer-certificate: (nullable)
 *
 * The connection's peer's certificate, after the TLS handshake has
 * completed or failed. Note in particular that this is not yet set
 * during the emission of #GDtlsConnection::accept-certificate.
 *
 * (You can watch for a #GObject::notify signal on this property to
 * detect when a handshake has occurred.)
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection:peer-certificate-errors:
 *
 * The errors noticed while verifying
 * #GDtlsConnection:peer-certificate. Normally this should be 0, but
 * it may not be if #GDtlsClientConnection:validation-flags is not
 * %G_TLS_CERTIFICATE_VALIDATE_ALL, or if
 * #GDtlsConnection::accept-certificate overrode the default
 * behavior.
 *
 * GLib guarantees that if certificate verification fails, at least
 * one error will be set, but it does not guarantee that all possible
 * errors will be set. Accordingly, you may not safely decide to
 * ignore any particular type of error. For example, it would be
 * incorrect to mask %G_TLS_CERTIFICATE_EXPIRED if you want to allow
 * expired certificates, because this could potentially be the only
 * error flag set even if other problems exist with the certificate.
 *
 * Since: 2.48
 */


/**
 * GDtlsConnection:protocol-version:
 *
 * The DTLS protocol version in use. See g_dtls_connection_get_protocol_version().
 *
 * Since: 2.70
 */


/**
 * GDtlsConnection:rehandshake-mode:
 *
 * The rehandshaking mode. See
 * g_dtls_connection_set_rehandshake_mode().
 *
 * Since: 2.48
 * Deprecated: 2.60: The rehandshake mode is ignored.
 */


/**
 * GDtlsConnection:require-close-notify:
 *
 * Whether or not proper TLS close notification is required.
 * See g_dtls_connection_set_require_close_notify().
 *
 * Since: 2.48
 */


/**
 * GDtlsServerConnection:authentication-mode:
 *
 * The #GTlsAuthenticationMode for the server. This can be changed
 * before calling g_dtls_connection_handshake() if you want to
 * rehandshake with a different mode from the initial handshake.
 *
 * Since: 2.48
 */


/**
 * GFileIcon:file:
 *
 * The file containing the icon.
 */


/**
 * GFileMonitor::changed:
 * @monitor: a #GFileMonitor.
 * @file: a #GFile.
 * @other_file: (nullable): a #GFile or #NULL.
 * @event_type: a #GFileMonitorEvent.
 *
 * Emitted when @file has been changed.
 *
 * If using %G_FILE_MONITOR_WATCH_MOVES on a directory monitor, and
 * the information is available (and if supported by the backend),
 * @event_type may be %G_FILE_MONITOR_EVENT_RENAMED,
 * %G_FILE_MONITOR_EVENT_MOVED_IN or %G_FILE_MONITOR_EVENT_MOVED_OUT.
 *
 * In all cases @file will be a child of the monitored directory.  For
 * renames, @file will be the old name and @other_file is the new
 * name.  For "moved in" events, @file is the name of the file that
 * appeared and @other_file is the old name that it was moved from (in
 * another directory).  For "moved out" events, @file is the name of
 * the file that used to be in this directory and @other_file is the
 * name of the file at its new location.
 *
 * It makes sense to treat %G_FILE_MONITOR_EVENT_MOVED_IN as
 * equivalent to %G_FILE_MONITOR_EVENT_CREATED and
 * %G_FILE_MONITOR_EVENT_MOVED_OUT as equivalent to
 * %G_FILE_MONITOR_EVENT_DELETED, with extra information.
 * %G_FILE_MONITOR_EVENT_RENAMED is equivalent to a delete/create
 * pair.  This is exactly how the events will be reported in the case
 * that the %G_FILE_MONITOR_WATCH_MOVES flag is not in use.
 *
 * If using the deprecated flag %G_FILE_MONITOR_SEND_MOVED flag and @event_type is
 * %G_FILE_MONITOR_EVENT_MOVED, @file will be set to a #GFile containing the
 * old path, and @other_file will be set to a #GFile containing the new path.
 *
 * In all the other cases, @other_file will be set to #NULL.
 */


/**
 * GFilenameCompleter::got-completion-data:
 *
 * Emitted when the file name completion information comes available.
 */


/**
 * GIOExtension:
 *
 * #GIOExtension is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GIOExtensionPoint:
 *
 * #GIOExtensionPoint is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GIOModuleScope:
 *
 * Represents a scope for loading IO modules. A scope can be used for blocking
 * duplicate modules, or blocking a module you don't want to load.
 *
 * The scope can be used with g_io_modules_load_all_in_directory_with_scope()
 * or g_io_modules_scan_all_in_directory_with_scope().
 *
 * Since: 2.30
 */


/**
 * GInetAddress:
 *
 * An IPv4 or IPv6 internet address.
 */


/**
 * GInetAddress:is-any:
 *
 * Whether this is the "any" address for its family.
 * See g_inet_address_get_is_any().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-link-local:
 *
 * Whether this is a link-local address.
 * See g_inet_address_get_is_link_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-loopback:
 *
 * Whether this is the loopback address for its family.
 * See g_inet_address_get_is_loopback().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-global:
 *
 * Whether this is a global multicast address.
 * See g_inet_address_get_is_mc_global().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-link-local:
 *
 * Whether this is a link-local multicast address.
 * See g_inet_address_get_is_mc_link_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-node-local:
 *
 * Whether this is a node-local multicast address.
 * See g_inet_address_get_is_mc_node_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-org-local:
 *
 * Whether this is an organization-local multicast address.
 * See g_inet_address_get_is_mc_org_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-site-local:
 *
 * Whether this is a site-local multicast address.
 * See g_inet_address_get_is_mc_site_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-multicast:
 *
 * Whether this is a multicast address.
 * See g_inet_address_get_is_multicast().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-site-local:
 *
 * Whether this is a site-local address.
 * See g_inet_address_get_is_loopback().
 *
 * Since: 2.22
 */


/**
 * GInetAddressMask:
 *
 * A combination of an IPv4 or IPv6 base address and a length,
 * representing a range of IP addresses.
 *
 * Since: 2.32
 */


/**
 * GInetSocketAddress:
 *
 * An IPv4 or IPv6 socket address, corresponding to a struct
 * sockaddr_in or struct sockaddr_in6.
 */


/**
 * GInetSocketAddress:flowinfo:
 *
 * The `sin6_flowinfo` field, for IPv6 addresses.
 *
 * Since: 2.32
 */


/**
 * GInetSocketAddress:scope_id:
 *
 * The `sin6_scope_id` field, for IPv6 addresses.
 *
 * Since: 2.32
 */


/**
 * GKeyfileSettingsBackend:default-dir:
 *
 * The directory where the system defaults and locks are located.
 *
 * Defaults to `/etc/glib-2.0/settings`.
 */


/**
 * GKeyfileSettingsBackend:filename:
 *
 * The location where the settings are stored on disk.
 *
 * Defaults to `$XDG_CONFIG_HOME/glib-2.0/settings/keyfile`.
 */


/**
 * GKeyfileSettingsBackend:root-group:
 *
 * If @root_group is non-%NULL then it specifies the name of the keyfile
 * group used for keys that are written directly below the root path.
 *
 * Defaults to NULL.
 */


/**
 * GKeyfileSettingsBackend:root-path:
 *
 * All settings read to or written from the backend must fall under the
 * path given in @root_path (which must start and end with a slash and
 * not contain two consecutive slashes).  @root_path may be "/".
 *
 * Defaults to "/".
 */


/**
 * GListModel:
 *
 * #GListModel is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GListModel::items-changed:
 * @list: the #GListModel that changed
 * @position: the position at which @list changed
 * @removed: the number of items removed
 * @added: the number of items added
 *
 * This signal is emitted whenever items were added to or removed
 * from @list. At @position, @removed items were removed and @added
 * items were added in their place.
 *
 * Note: If `removed != added`, the positions of all later items
 * in the model change.
 *
 * Since: 2.44
 */


/**
 * GListModelInterface:
 * @g_iface: parent #GTypeInterface
 * @get_item_type: the virtual function pointer for g_list_model_get_item_type()
 * @get_n_items: the virtual function pointer for g_list_model_get_n_items()
 * @get_item: the virtual function pointer for g_list_model_get_item()
 *
 * The virtual function table for #GListModel.
 *
 * Since: 2.44
 */


/**
 * GListModelInterface::get_item:
 * @list: a #GListModel
 * @position: the position of the item to fetch
 *
 * Get the item at @position. If @position is greater than the number of
 * items in @list, %NULL is returned.
 *
 * %NULL is never returned for an index that is smaller than the length
 * of the list.  See g_list_model_get_n_items().
 *
 * The same #GObject instance may not appear more than once in a #GListModel.
 *
 * Returns: (type GObject) (transfer full) (nullable): the object at @position.
 * Since: 2.44
 */


/**
 * GListStore:
 *
 * #GListStore is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GListStore:item-type:
 *
 * The type of items contained in this list store. Items must be
 * subclasses of #GObject.
 *
 * Since: 2.44
 */


/**
 * GListStore:n-items:
 *
 * The number of items contained in this list store.
 *
 * Since: 2.74
 */


/**
 * GMemoryMonitor:
 *
 * #GMemoryMonitor monitors system memory and indicates when
 * the system is low on memory.
 *
 * Since: 2.64
 */


/**
 * GMemoryMonitor::low-memory-warning:
 * @monitor: a #GMemoryMonitor
 * @level: the #GMemoryMonitorWarningLevel warning level
 *
 * Emitted when the system is running low on free memory. The signal
 * handler should then take the appropriate action depending on the
 * warning level. See the #GMemoryMonitorWarningLevel documentation for
 * details.
 *
 * Since: 2.64
 */


/**
 * GMemoryMonitorInterface:
 * @g_iface: The parent interface.
 * @low_memory_warning: the virtual function pointer for the
 *  #GMemoryMonitor::low-memory-warning signal.
 *
 * The virtual function table for #GMemoryMonitor.
 *
 * Since: 2.64
 */


/**
 * GMemoryOutputStream:data:
 *
 * Pointer to buffer where data will be written.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:data-size:
 *
 * Size of data written to the buffer.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:destroy-function: (skip)
 *
 * Function called with the buffer as argument when the stream is destroyed.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:realloc-function: (skip)
 *
 * Function with realloc semantics called to enlarge the buffer.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:size:
 *
 * Current size of the data buffer.
 *
 * Since: 2.24
 */


/**
 * GMenu:
 *
 * #GMenu is an opaque structure type.  You must access it using the
 * functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuAttributeIter:
 *
 * #GMenuAttributeIter is an opaque structure type.  You must access it
 * using the functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuItem:
 *
 * #GMenuItem is an opaque structure type.  You must access it using the
 * functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuLinkIter:
 *
 * #GMenuLinkIter is an opaque structure type.  You must access it using
 * the functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuModel:
 *
 * #GMenuModel is an opaque structure type.  You must access it using the
 * functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuModel::items-changed:
 * @model: the #GMenuModel that is changing
 * @position: the position of the change
 * @removed: the number of items removed
 * @added: the number of items added
 *
 * Emitted when a change has occurred to the menu.
 *
 * The only changes that can occur to a menu is that items are removed
 * or added.  Items may not change (except by being removed and added
 * back in the same location).  This signal is capable of describing
 * both of those changes (at the same time).
 *
 * The signal means that starting at the index @position, @removed
 * items were removed and @added items were added in their place.  If
 * @removed is zero then only items were added.  If @added is zero
 * then only items were removed.
 *
 * As an example, if the menu contains items a, b, c, d (in that
 * order) and the signal (2, 1, 3) occurs then the new composition of
 * the menu will be a, b, _, _, _, d (with each _ representing some
 * new item).
 *
 * Signal handlers may query the model (particularly the added items)
 * and expect to see the results of the modification that is being
 * reported.  The signal is emitted after the modification.
 */


/**
 * GMount::changed:
 * @mount: the object on which the signal is emitted
 *
 * Emitted when the mount has been changed.
 */


/**
 * GMount::pre-unmount:
 * @mount: the object on which the signal is emitted
 *
 * This signal may be emitted when the #GMount is about to be
 * unmounted.
 *
 * This signal depends on the backend and is only emitted if
 * GIO was used to unmount.
 *
 * Since: 2.22
 */


/**
 * GMount::unmounted:
 * @mount: the object on which the signal is emitted
 *
 * This signal is emitted when the #GMount have been
 * unmounted. If the recipient is holding references to the
 * object they should release them so the object can be
 * finalized.
 */


/**
 * GMountOperation::aborted:
 *
 * Emitted by the backend when e.g. a device becomes unavailable
 * while a mount operation is in progress.
 *
 * Implementations of GMountOperation should handle this signal
 * by dismissing open password dialogs.
 *
 * Since: 2.20
 */


/**
 * GMountOperation::ask-password:
 * @op: a #GMountOperation requesting a password.
 * @message: string containing a message to display to the user.
 * @default_user: string containing the default user name.
 * @default_domain: string containing the default domain.
 * @flags: a set of #GAskPasswordFlags.
 *
 * Emitted when a mount operation asks the user for a password.
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 */


/**
 * GMountOperation::ask-question:
 * @op: a #GMountOperation asking a question.
 * @message: string containing a message to display to the user.
 * @choices: an array of strings for each possible choice.
 *
 * Emitted when asking the user a question and gives a list of
 * choices for the user to choose from.
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 */


/**
 * GMountOperation::reply:
 * @op: a #GMountOperation.
 * @result: a #GMountOperationResult indicating how the request was handled
 *
 * Emitted when the user has replied to the mount operation.
 */


/**
 * GMountOperation::show-processes:
 * @op: a #GMountOperation.
 * @message: string containing a message to display to the user.
 * @processes: (element-type GPid): an array of #GPid for processes
 *   blocking the operation.
 * @choices: an array of strings for each possible choice.
 *
 * Emitted when one or more processes are blocking an operation
 * e.g. unmounting/ejecting a #GMount or stopping a #GDrive.
 *
 * Note that this signal may be emitted several times to update the
 * list of blocking processes as processes close files. The
 * application should only respond with g_mount_operation_reply() to
 * the latest signal (setting #GMountOperation:choice to the choice
 * the user made).
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 *
 * Since: 2.22
 */


/**
 * GMountOperation::show-unmount-progress:
 * @op: a #GMountOperation:
 * @message: string containing a message to display to the user
 * @time_left: the estimated time left before the operation completes,
 *     in microseconds, or -1
 * @bytes_left: the amount of bytes to be written before the operation
 *     completes (or -1 if such amount is not known), or zero if the operation
 *     is completed
 *
 * Emitted when an unmount operation has been busy for more than some time
 * (typically 1.5 seconds).
 *
 * When unmounting or ejecting a volume, the kernel might need to flush
 * pending data in its buffers to the volume stable storage, and this operation
 * can take a considerable amount of time. This signal may be emitted several
 * times as long as the unmount operation is outstanding, and then one
 * last time when the operation is completed, with @bytes_left set to zero.
 *
 * Implementations of GMountOperation should handle this signal by
 * showing an UI notification, and then dismiss it, or show another notification
 * of completion, when @bytes_left reaches zero.
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 *
 * Since: 2.34
 */


/**
 * GMountOperation:anonymous:
 *
 * Whether to use an anonymous user when authenticating.
 */


/**
 * GMountOperation:choice:
 *
 * The index of the user's choice when a question is asked during the
 * mount operation. See the #GMountOperation::ask-question signal.
 */


/**
 * GMountOperation:domain:
 *
 * The domain to use for the mount operation.
 */


/**
 * GMountOperation:is-tcrypt-hidden-volume:
 *
 * Whether the device to be unlocked is a TCRYPT hidden volume.
 * See [the VeraCrypt documentation](https://www.veracrypt.fr/en/Hidden%20Volume.html).
 *
 * Since: 2.58
 */


/**
 * GMountOperation:is-tcrypt-system-volume:
 *
 * Whether the device to be unlocked is a TCRYPT system volume.
 * In this context, a system volume is a volume with a bootloader
 * and operating system installed. This is only supported for Windows
 * operating systems. For further documentation, see
 * [the VeraCrypt documentation](https://www.veracrypt.fr/en/System%20Encryption.html).
 *
 * Since: 2.58
 */


/**
 * GMountOperation:password:
 *
 * The password that is used for authentication when carrying out
 * the mount operation.
 */


/**
 * GMountOperation:password-save:
 *
 * Determines if and how the password information should be saved.
 */


/**
 * GMountOperation:pim:
 *
 * The VeraCrypt PIM value, when unlocking a VeraCrypt volume. See
 * [the VeraCrypt documentation](https://www.veracrypt.fr/en/Personal%20Iterations%20Multiplier%20(PIM).html).
 *
 * Since: 2.58
 */


/**
 * GMountOperation:username:
 *
 * The user name that is used for authentication when carrying out
 * the mount operation.
 */


/**
 * GNativeSocketAddress:
 *
 * A socket address, corresponding to a general struct
 * sockadd address of a type not otherwise handled by glib.
 */


/**
 * GNetworkAddress:
 *
 * A #GSocketConnectable for resolving a hostname and connecting to
 * that host.
 */


/**
 * GNetworkMonitor:
 *
 * #GNetworkMonitor monitors the status of network connections and
 * indicates when a possibly-user-visible change has occurred.
 *
 * Since: 2.32
 */


/**
 * GNetworkMonitor::network-changed:
 * @monitor: a #GNetworkMonitor
 * @network_available: the current value of #GNetworkMonitor:network-available
 *
 * Emitted when the network configuration changes.
 *
 * Since: 2.32
 */


/**
 * GNetworkMonitor:connectivity:
 *
 * More detailed information about the host's network connectivity.
 * See g_network_monitor_get_connectivity() and
 * #GNetworkConnectivity for more details.
 *
 * Since: 2.44
 */


/**
 * GNetworkMonitor:network-available:
 *
 * Whether the network is considered available. That is, whether the
 * system has a default route for at least one of IPv4 or IPv6.
 *
 * Real-world networks are of course much more complicated than
 * this; the machine may be connected to a wifi hotspot that
 * requires payment before allowing traffic through, or may be
 * connected to a functioning router that has lost its own upstream
 * connectivity. Some hosts might only be accessible when a VPN is
 * active. Other hosts might only be accessible when the VPN is
 * not active. Thus, it is best to use g_network_monitor_can_reach()
 * or g_network_monitor_can_reach_async() to test for reachability
 * on a host-by-host basis. (On the other hand, when the property is
 * %FALSE, the application can reasonably expect that no remote
 * hosts at all are reachable, and should indicate this to the user
 * in its UI.)
 *
 * See also #GNetworkMonitor::network-changed.
 *
 * Since: 2.32
 */


/**
 * GNetworkMonitor:network-metered:
 *
 * Whether the network is considered metered.
 *
 * That is, whether the
 * system has traffic flowing through the default connection that is
 * subject to limitations set by service providers. For example, traffic
 * might be billed by the amount of data transmitted, or there might be a
 * quota on the amount of traffic per month. This is typical with tethered
 * connections (3G and 4G) and in such situations, bandwidth intensive
 * applications may wish to avoid network activity where possible if it will
 * cost the user money or use up their limited quota. Anything more than a
 * few hundreds of kilobytes of data usage per hour should be avoided without
 * asking permission from the user.
 *
 * If more information is required about specific devices then the
 * system network management API should be used instead (for example,
 * NetworkManager or ConnMan).
 *
 * If this information is not available then no networks will be
 * marked as metered.
 *
 * See also #GNetworkMonitor:network-available.
 *
 * Since: 2.46
 */


/**
 * GNetworkMonitorInterface:
 * @g_iface: The parent interface.
 * @network_changed: the virtual function pointer for the
 *  GNetworkMonitor::network-changed signal.
 * @can_reach: the virtual function pointer for g_network_monitor_can_reach()
 * @can_reach_async: the virtual function pointer for
 *  g_network_monitor_can_reach_async()
 * @can_reach_finish: the virtual function pointer for
 *  g_network_monitor_can_reach_finish()
 *
 * The virtual function table for #GNetworkMonitor.
 *
 * Since: 2.32
 */


/**
 * GNetworkService:
 *
 * A #GSocketConnectable for resolving a SRV record and connecting to
 * that service.
 */


/**
 * GNotification:
 *
 * This structure type is private and should only be accessed using the
 * public APIs.
 *
 * Since: 2.40
 */


/**
 * GPermission:
 *
 * #GPermission is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GPermission:allowed:
 *
 * %TRUE if the caller currently has permission to perform the action that
 * @permission represents the permission to perform.
 */


/**
 * GPermission:can-acquire:
 *
 * %TRUE if it is generally possible to acquire the permission by calling
 * g_permission_acquire().
 */


/**
 * GPermission:can-release:
 *
 * %TRUE if it is generally possible to release the permission by calling
 * g_permission_release().
 */


/**
 * GPowerProfileMonitor:
 *
 * #GPowerProfileMonitor monitors system power profile and notifies on
 * changes.
 *
 * Since: 2.70
 */


/**
 * GPowerProfileMonitor:power-saver-enabled:
 *
 * Whether “Power Saver” mode is enabled on the system.
 *
 * Since: 2.70
 */


/**
 * GPowerProfileMonitorInterface:
 * @g_iface: The parent interface.
 *
 * The virtual function table for #GPowerProfileMonitor.
 *
 * Since: 2.70
 */


/**
 * GPropertyAction:
 *
 * This type is opaque.
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:enabled:
 *
 * If @action is currently enabled.
 *
 * If the action is disabled then calls to g_action_activate() and
 * g_action_change_state() have no effect.
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:invert-boolean:
 *
 * If %TRUE, the state of the action will be the negation of the
 * property value, provided the property is boolean.
 *
 * Since: 2.46
 */


/**
 * GPropertyAction:name:
 *
 * The name of the action.  This is mostly meaningful for identifying
 * the action once it has been added to a #GActionMap.
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:object:
 *
 * The object to wrap a property on.
 *
 * The object must be a non-%NULL #GObject with properties.
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:parameter-type:
 *
 * The type of the parameter that must be given when activating the
 * action.
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:property-name:
 *
 * The name of the property to wrap on the object.
 *
 * The property must exist on the passed-in object and it must be
 * readable and writable (and not construct-only).
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:state:
 *
 * The state of the action, or %NULL if the action is stateless.
 *
 * Since: 2.38
 */


/**
 * GPropertyAction:state-type:
 *
 * The #GVariantType of the state that the action has, or %NULL if the
 * action is stateless.
 *
 * Since: 2.38
 */


/**
 * GProxyAddress:
 *
 * A #GInetSocketAddress representing a connection via a proxy server
 *
 * Since: 2.26
 */


/**
 * GProxyAddress:destination-protocol:
 *
 * The protocol being spoke to the destination host, or %NULL if
 * the #GProxyAddress doesn't know.
 *
 * Since: 2.34
 */


/**
 * GProxyAddress:uri:
 *
 * The URI string that the proxy was constructed from (or %NULL
 * if the creator didn't specify this).
 *
 * Since: 2.34
 */


/**
 * GProxyAddressClass:
 *
 * Class structure for #GProxyAddress.
 *
 * Since: 2.26
 */


/**
 * GProxyAddressEnumerator:default-port:
 *
 * The default port to use if #GProxyAddressEnumerator:uri does not
 * specify one.
 *
 * Since: 2.38
 */


/**
 * GProxyAddressEnumerator:proxy-resolver:
 *
 * The proxy resolver to use.
 *
 * Since: 2.36
 */


/**
 * GProxyResolverInterface:
 * @g_iface: The parent interface.
 * @is_supported: the virtual function pointer for g_proxy_resolver_is_supported()
 * @lookup: the virtual function pointer for g_proxy_resolver_lookup()
 * @lookup_async: the virtual function pointer for
 *  g_proxy_resolver_lookup_async()
 * @lookup_finish: the virtual function pointer for
 *  g_proxy_resolver_lookup_finish()
 *
 * The virtual function table for #GProxyResolver.
 */


/**
 * GRegistrySettingsBackend:registry-key:
 *
 * The location where settings are stored in the registry. Must
 * start with one of the following:
 * - `HKEY_CLASSES_ROOT`
 * - `HKEY_CURRENT_CONFIG`
 * - `HKEY_CURRENT_USER`
 * - `HKEY_LOCAL_MACHINE`
 * - `HKEY_USERS`
 *
 * Defaults to `HKEY_CURRENT_USER\Software\GSettings`.
 *
 * Since: 2.78
 */


/**
 * GRemoteActionGroup:
 *
 * #GRemoteActionGroup is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GRemoteActionGroupInterface:
 * @activate_action_full: the virtual function pointer for g_remote_action_group_activate_action_full()
 * @change_action_state_full: the virtual function pointer for g_remote_action_group_change_action_state_full()
 *
 * The virtual function table for #GRemoteActionGroup.
 *
 * Since: 2.32
 */


/**
 * GResolver:
 *
 * The object that handles DNS resolution. Use g_resolver_get_default()
 * to get the default resolver.
 *
 * This is an abstract type; subclasses of it implement different resolvers for
 * different platforms and situations.
 */


/**
 * GResolver::reload:
 * @resolver: a #GResolver
 *
 * Emitted when the resolver notices that the system resolver
 * configuration has changed.
 */


/**
 * GResolver:timeout:
 *
 * The timeout applied to all resolver lookups, in milliseconds.
 *
 * This may be changed through the lifetime of the #GResolver. The new value
 * will apply to any lookups started after the change, but not to any
 * already-ongoing lookups.
 *
 * If this is `0`, no timeout is applied to lookups.
 *
 * No timeout was applied to lookups before this property was added in
 * GLib 2.78.
 *
 * Since: 2.78
 */


/**
 * GSettings:
 *
 * #GSettings is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GSettings::change-event:
 * @settings: the object on which the signal was emitted
 * @keys: (array length=n_keys) (element-type GQuark) (nullable):
 *        an array of #GQuarks for the changed keys, or %NULL
 * @n_keys: the length of the @keys array, or 0
 *
 * The "change-event" signal is emitted once per change event that
 * affects this settings object.  You should connect to this signal
 * only if you are interested in viewing groups of changes before they
 * are split out into multiple emissions of the "changed" signal.
 * For most use cases it is more appropriate to use the "changed" signal.
 *
 * In the event that the change event applies to one or more specified
 * keys, @keys will be an array of #GQuark of length @n_keys.  In the
 * event that the change event applies to the #GSettings object as a
 * whole (ie: potentially every key has been changed) then @keys will
 * be %NULL and @n_keys will be 0.
 *
 * The default handler for this signal invokes the "changed" signal
 * for each affected key.  If any other connected handler returns
 * %TRUE then this default functionality will be suppressed.
 *
 * Returns: %TRUE to stop other handlers from being invoked for the
 *          event. FALSE to propagate the event further.
 */


/**
 * GSettings::changed:
 * @settings: the object on which the signal was emitted
 * @key: the name of the key that changed
 *
 * The "changed" signal is emitted when a key has potentially changed.
 * You should call one of the g_settings_get() calls to check the new
 * value.
 *
 * This signal supports detailed connections.  You can connect to the
 * detailed signal "changed::x" in order to only receive callbacks
 * when key "x" changes.
 *
 * Note that @settings only emits this signal if you have read @key at
 * least once while a signal handler was already connected for @key.
 */


/**
 * GSettings::writable-change-event:
 * @settings: the object on which the signal was emitted
 * @key: the quark of the key, or 0
 *
 * The "writable-change-event" signal is emitted once per writability
 * change event that affects this settings object.  You should connect
 * to this signal if you are interested in viewing groups of changes
 * before they are split out into multiple emissions of the
 * "writable-changed" signal.  For most use cases it is more
 * appropriate to use the "writable-changed" signal.
 *
 * In the event that the writability change applies only to a single
 * key, @key will be set to the #GQuark for that key.  In the event
 * that the writability change affects the entire settings object,
 * @key will be 0.
 *
 * The default handler for this signal invokes the "writable-changed"
 * and "changed" signals for each affected key.  This is done because
 * changes in writability might also imply changes in value (if for
 * example, a new mandatory setting is introduced).  If any other
 * connected handler returns %TRUE then this default functionality
 * will be suppressed.
 *
 * Returns: %TRUE to stop other handlers from being invoked for the
 *          event. FALSE to propagate the event further.
 */


/**
 * GSettings::writable-changed:
 * @settings: the object on which the signal was emitted
 * @key: the key
 *
 * The "writable-changed" signal is emitted when the writability of a
 * key has potentially changed.  You should call
 * g_settings_is_writable() in order to determine the new status.
 *
 * This signal supports detailed connections.  You can connect to the
 * detailed signal "writable-changed::x" in order to only receive
 * callbacks when the writability of "x" changes.
 */


/**
 * GSettings:backend:
 *
 * The name of the context that the settings are stored in.
 */


/**
 * GSettings:delay-apply:
 *
 * Whether the #GSettings object is in 'delay-apply' mode. See
 * g_settings_delay() for details.
 *
 * Since: 2.28
 */


/**
 * GSettings:has-unapplied:
 *
 * If this property is %TRUE, the #GSettings object has outstanding
 * changes that will be applied when g_settings_apply() is called.
 */


/**
 * GSettings:path:
 *
 * The path within the backend where the settings are stored.
 */


/**
 * GSettings:schema:
 *
 * The name of the schema that describes the types of keys
 * for this #GSettings object.
 *
 * The type of this property is *not* #GSettingsSchema.
 * #GSettingsSchema has only existed since version 2.32 and
 * unfortunately this name was used in previous versions to refer to
 * the schema ID rather than the schema itself.  Take care to use the
 * 'settings-schema' property if you wish to pass in a
 * #GSettingsSchema.
 *
 * Deprecated: 2.32: Use the 'schema-id' property instead.  In a future
 * version, this property may instead refer to a #GSettingsSchema.
 */


/**
 * GSettings:schema-id:
 *
 * The name of the schema that describes the types of keys
 * for this #GSettings object.
 */


/**
 * GSettings:settings-schema:
 *
 * The #GSettingsSchema describing the types of keys for this
 * #GSettings object.
 *
 * Ideally, this property would be called 'schema'.  #GSettingsSchema
 * has only existed since version 2.32, however, and before then the
 * 'schema' property was used to refer to the ID of the schema rather
 * than the schema itself.  Take care.
 */


/**
 * GSettingsSchema:
 *
 * This is an opaque structure type.  You may not access it directly.
 *
 * Since: 2.32
 */


/**
 * GSettingsSchemaKey:
 *
 * #GSettingsSchemaKey is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GSettingsSchemaSource:
 *
 * This is an opaque structure type.  You may not access it directly.
 *
 * Since: 2.32
 */


/**
 * GSimpleAction:
 *
 * #GSimpleAction is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GSimpleAction::activate:
 * @simple: the #GSimpleAction
 * @parameter: (nullable): the parameter to the activation, or %NULL if it has
 *   no parameter
 *
 * Indicates that the action was just activated.
 *
 * @parameter will always be of the expected type, i.e. the parameter type
 * specified when the action was created. If an incorrect type is given when
 * activating the action, this signal is not emitted.
 *
 * Since GLib 2.40, if no handler is connected to this signal then the
 * default behaviour for boolean-stated actions with a %NULL parameter
 * type is to toggle them via the #GSimpleAction::change-state signal.
 * For stateful actions where the state type is equal to the parameter
 * type, the default is to forward them directly to
 * #GSimpleAction::change-state.  This should allow almost all users
 * of #GSimpleAction to connect only one handler or the other.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction::change-state:
 * @simple: the #GSimpleAction
 * @value: (nullable): the requested value for the state
 *
 * Indicates that the action just received a request to change its
 * state.
 *
 * @value will always be of the correct state type, i.e. the type of the
 * initial state passed to g_simple_action_new_stateful(). If an incorrect
 * type is given when requesting to change the state, this signal is not
 * emitted.
 *
 * If no handler is connected to this signal then the default
 * behaviour is to call g_simple_action_set_state() to set the state
 * to the requested value. If you connect a signal handler then no
 * default action is taken. If the state should change then you must
 * call g_simple_action_set_state() from the handler.
 *
 * An example of a 'change-state' handler:
 * |[<!-- language="C" -->
 * static void
 * change_volume_state (GSimpleAction *action,
 *                      GVariant      *value,
 *                      gpointer       user_data)
 * {
 *   gint requested;
 *
 *   requested = g_variant_get_int32 (value);
 *
 *   // Volume only goes from 0 to 10
 *   if (0 <= requested && requested <= 10)
 *     g_simple_action_set_state (action, value);
 * }
 * ]|
 *
 * The handler need not set the state to the requested value.
 * It could set it to any value at all, or take some other action.
 *
 * Since: 2.30
 */


/**
 * GSimpleAction:enabled:
 *
 * If @action is currently enabled.
 *
 * If the action is disabled then calls to g_action_activate() and
 * g_action_change_state() have no effect.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:name:
 *
 * The name of the action. This is mostly meaningful for identifying
 * the action once it has been added to a #GSimpleActionGroup.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:parameter-type:
 *
 * The type of the parameter that must be given when activating the
 * action.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:state:
 *
 * The state of the action, or %NULL if the action is stateless.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:state-type:
 *
 * The #GVariantType of the state that the action has, or %NULL if the
 * action is stateless.
 *
 * Since: 2.28
 */


/**
 * GSimpleIOStream:
 *
 * A wrapper around a #GInputStream and a #GOutputStream.
 *
 * Since: 2.44
 */


/**
 * GSimpleIOStream:input-stream:
 *
 * Since: 2.44
 */


/**
 * GSimpleIOStream:output-stream:
 *
 * Since: 2.44
 */


/**
 * GSimplePermission:
 *
 * #GSimplePermission is an opaque data structure.  There are no methods
 * except for those defined by #GPermission.
 */


/**
 * GSimpleProxyResolver:default-proxy: (nullable)
 *
 * The default proxy URI that will be used for any URI that doesn't
 * match #GSimpleProxyResolver:ignore-hosts, and doesn't match any
 * of the schemes set with g_simple_proxy_resolver_set_uri_proxy().
 *
 * Note that as a special case, if this URI starts with
 * "socks://", #GSimpleProxyResolver will treat it as referring
 * to all three of the socks5, socks4a, and socks4 proxy types.
 */


/**
 * GSimpleProxyResolver:ignore-hosts:
 *
 * A list of hostnames and IP addresses that the resolver should
 * allow direct connections to.
 *
 * Entries can be in one of 4 formats:
 *
 * - A hostname, such as "example.com", ".example.com", or
 *   "*.example.com", any of which match "example.com" or
 *   any subdomain of it.
 *
 * - An IPv4 or IPv6 address, such as "192.168.1.1",
 *   which matches only that address.
 *
 * - A hostname or IP address followed by a port, such as
 *   "example.com:80", which matches whatever the hostname or IP
 *   address would match, but only for URLs with the (explicitly)
 *   indicated port. In the case of an IPv6 address, the address
 *   part must appear in brackets: "[::1]:443"
 *
 * - An IP address range, given by a base address and prefix length,
 *   such as "fe80::/10", which matches any address in that range.
 *
 * Note that when dealing with Unicode hostnames, the matching is
 * done against the ASCII form of the name.
 *
 * Also note that hostname exclusions apply only to connections made
 * to hosts identified by name, and IP address exclusions apply only
 * to connections made to hosts identified by address. That is, if
 * example.com has an address of 192.168.1.1, and the :ignore-hosts list
 * contains only "192.168.1.1", then a connection to "example.com"
 * (eg, via a #GNetworkAddress) will use the proxy, and a connection to
 * "192.168.1.1" (eg, via a #GInetSocketAddress) will not.
 *
 * These rules match the "ignore-hosts"/"noproxy" rules most
 * commonly used by other applications.
 */


/**
 * GSocket:broadcast:
 *
 * Whether the socket should allow sending to broadcast addresses.
 *
 * Since: 2.32
 */


/**
 * GSocket:multicast-loopback:
 *
 * Whether outgoing multicast packets loop back to the local host.
 *
 * Since: 2.32
 */


/**
 * GSocket:multicast-ttl:
 *
 * Time-to-live out outgoing multicast packets
 *
 * Since: 2.32
 */


/**
 * GSocket:timeout:
 *
 * The timeout in seconds on socket I/O
 *
 * Since: 2.26
 */


/**
 * GSocket:ttl:
 *
 * Time-to-live for outgoing unicast packets
 *
 * Since: 2.32
 */


/**
 * GSocketAddress:
 *
 * A socket endpoint address, corresponding to struct sockaddr
 * or one of its subtypes.
 */


/**
 * GSocketClient::event:
 * @client: the #GSocketClient
 * @event: the event that is occurring
 * @connectable: the #GSocketConnectable that @event is occurring on
 * @connection: (nullable): the current representation of the connection
 *
 * Emitted when @client's activity on @connectable changes state.
 * Among other things, this can be used to provide progress
 * information about a network connection in the UI. The meanings of
 * the different @event values are as follows:
 *
 * - %G_SOCKET_CLIENT_RESOLVING: @client is about to look up @connectable
 *   in DNS. @connection will be %NULL.
 *
 * - %G_SOCKET_CLIENT_RESOLVED:  @client has successfully resolved
 *   @connectable in DNS. @connection will be %NULL.
 *
 * - %G_SOCKET_CLIENT_CONNECTING: @client is about to make a connection
 *   to a remote host; either a proxy server or the destination server
 *   itself. @connection is the #GSocketConnection, which is not yet
 *   connected.  Since GLib 2.40, you can access the remote
 *   address via g_socket_connection_get_remote_address().
 *
 * - %G_SOCKET_CLIENT_CONNECTED: @client has successfully connected
 *   to a remote host. @connection is the connected #GSocketConnection.
 *
 * - %G_SOCKET_CLIENT_PROXY_NEGOTIATING: @client is about to negotiate
 *   with a proxy to get it to connect to @connectable. @connection is
 *   the #GSocketConnection to the proxy server.
 *
 * - %G_SOCKET_CLIENT_PROXY_NEGOTIATED: @client has negotiated a
 *   connection to @connectable through a proxy server. @connection is
 *   the stream returned from g_proxy_connect(), which may or may not
 *   be a #GSocketConnection.
 *
 * - %G_SOCKET_CLIENT_TLS_HANDSHAKING: @client is about to begin a TLS
 *   handshake. @connection is a #GTlsClientConnection.
 *
 * - %G_SOCKET_CLIENT_TLS_HANDSHAKED: @client has successfully completed
 *   the TLS handshake. @connection is a #GTlsClientConnection.
 *
 * - %G_SOCKET_CLIENT_COMPLETE: @client has either successfully connected
 *   to @connectable (in which case @connection is the #GSocketConnection
 *   that it will be returning to the caller) or has failed (in which
 *   case @connection is %NULL and the client is about to return an error).
 *
 * Each event except %G_SOCKET_CLIENT_COMPLETE may be emitted
 * multiple times (or not at all) for a given connectable (in
 * particular, if @client ends up attempting to connect to more than
 * one address). However, if @client emits the #GSocketClient::event
 * signal at all for a given connectable, then it will always emit
 * it with %G_SOCKET_CLIENT_COMPLETE when it is done.
 *
 * Note that there may be additional #GSocketClientEvent values in
 * the future; unrecognized @event values should be ignored.
 *
 * Since: 2.32
 */


/**
 * GSocketClient:proxy-resolver:
 *
 * The proxy resolver to use
 *
 * Since: 2.36
 */


/**
 * GSocketClient:tls-validation-flags:
 *
 * The TLS validation flags used when creating TLS connections. The
 * default value is %G_TLS_CERTIFICATE_VALIDATE_ALL.
 *
 * GLib guarantees that if certificate verification fails, at least one
 * flag will be set, but it does not guarantee that all possible flags
 * will be set. Accordingly, you may not safely decide to ignore any
 * particular type of error. For example, it would be incorrect to mask
 * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired certificates,
 * because this could potentially be the only error flag set even if
 * other problems exist with the certificate. Therefore, there is no
 * safe way to use this property. This is not a horrible problem,
 * though, because you should not be attempting to ignore validation
 * errors anyway. If you really must ignore TLS certificate errors,
 * connect to the #GSocketClient::event signal, wait for it to be
 * emitted with %G_SOCKET_CLIENT_TLS_HANDSHAKING, and use that to
 * connect to #GTlsConnection::accept-certificate.
 *
 * Deprecated: 2.72: Do not attempt to ignore validation errors.
 */


/**
 * GSocketListener::event:
 * @listener: the #GSocketListener
 * @event: the event that is occurring
 * @socket: the #GSocket the event is occurring on
 *
 * Emitted when @listener's activity on @socket changes state.
 * Note that when @listener is used to listen on both IPv4 and
 * IPv6, a separate set of signals will be emitted for each, and
 * the order they happen in is undefined.
 *
 * Since: 2.46
 */


/**
 * GSocketService::incoming:
 * @service: the #GSocketService
 * @connection: a new #GSocketConnection object
 * @source_object: (nullable): the source_object passed to
 *     g_socket_listener_add_address()
 *
 * The ::incoming signal is emitted when a new incoming connection
 * to @service needs to be handled. The handler must initiate the
 * handling of @connection, but may not block; in essence,
 * asynchronous operations must be used.
 *
 * @connection will be unreffed once the signal handler returns,
 * so you need to ref it yourself if you are planning to use it.
 *
 * Returns: %TRUE to stop other handlers from being called
 * Since: 2.22
 */


/**
 * GSocketService:active:
 *
 * Whether the service is currently accepting connections.
 *
 * Since: 2.46
 */


/**
 * GSrvTarget:
 *
 * A single target host/port that a network service is running on.
 */


/**
 * GStaticResource:
 *
 * #GStaticResource is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GTask:
 *
 * The opaque object representing a synchronous or asynchronous task
 * and its result.
 */


/**
 * GTask:completed:
 *
 * Whether the task has completed, meaning its callback (if set) has been
 * invoked. This can only happen after g_task_return_pointer(),
 * g_task_return_error() or one of the other return functions have been called
 * on the task.
 *
 * This property is guaranteed to change from %FALSE to %TRUE exactly once.
 *
 * The #GObject::notify signal for this change is emitted in the same main
 * context as the task’s callback, immediately after that callback is invoked.
 *
 * Since: 2.44
 */


/**
 * GTaskThreadFunc:
 * @task: the #GTask
 * @source_object: (type GObject): @task's source object
 * @task_data: @task's task data
 * @cancellable: @task's #GCancellable, or %NULL
 *
 * The prototype for a task function to be run in a thread via
 * g_task_run_in_thread() or g_task_run_in_thread_sync().
 *
 * If the return-on-cancel flag is set on @task, and @cancellable gets
 * cancelled, then the #GTask will be completed immediately (as though
 * g_task_return_error_if_cancelled() had been called), without
 * waiting for the task function to complete. However, the task
 * function will continue running in its thread in the background. The
 * function therefore needs to be careful about how it uses
 * externally-visible state in this case. See
 * g_task_set_return_on_cancel() for more details.
 *
 * Other than in that case, @task will be completed when the
 * #GTaskThreadFunc returns, not when it calls a
 * `g_task_return_` function.
 *
 * Since: 2.36
 */


/**
 * GTcpWrapperConnection:
 *
 * #GTcpWrapperConnection is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GTestDBus:
 *
 * The #GTestDBus structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.34
 */


/**
 * GTestDBus:flags:
 *
 * #GTestDBusFlags specifying the behaviour of the D-Bus session.
 *
 * Since: 2.34
 */


/**
 * GThemedIcon:name:
 *
 * The icon name.
 */


/**
 * GThemedIcon:names:
 *
 * A %NULL-terminated array of icon names.
 */


/**
 * GThemedIcon:use-default-fallbacks:
 *
 * Whether to use the default fallbacks found by shortening the icon name
 * at '-' characters. If the "names" array has more than one element,
 * ignores any past the first.
 *
 * For example, if the icon name was "gnome-dev-cdrom-audio", the array
 * would become
 * |[<!-- language="C" -->
 * {
 *   "gnome-dev-cdrom-audio",
 *   "gnome-dev-cdrom",
 *   "gnome-dev",
 *   "gnome",
 *   NULL
 * };
 * ]|
 */


/**
 * GThreadedSocketService::run:
 * @service: the #GThreadedSocketService.
 * @connection: a new #GSocketConnection object.
 * @source_object: (nullable): the source_object passed to g_socket_listener_add_address().
 *
 * The ::run signal is emitted in a worker thread in response to an
 * incoming connection. This thread is dedicated to handling
 * @connection and may perform blocking IO. The signal handler need
 * not return until the connection is closed.
 *
 * Returns: %TRUE to stop further signal handlers from being called
 */


/**
 * GTlsBackend:
 *
 * TLS (Transport Layer Security, aka SSL) and DTLS backend. This is an
 * internal type used to coordinate the different classes implemented
 * by a TLS backend.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:
 *
 * Abstract base class for TLS certificate types.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:certificate:
 *
 * The DER (binary) encoded representation of the certificate.
 * This property and the #GTlsCertificate:certificate-pem property
 * represent the same data, just in different forms.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:certificate-pem:
 *
 * The PEM (ASCII) encoded representation of the certificate.
 * This property and the #GTlsCertificate:certificate
 * property represent the same data, just in different forms.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:dns-names: (nullable) (element-type GBytes) (transfer container)
 *
 * The DNS names from the certificate's Subject Alternative Names (SANs),
 * %NULL if unavailable.
 *
 * Since: 2.70
 */


/**
 * GTlsCertificate:ip-addresses: (nullable) (element-type GInetAddress) (transfer container)
 *
 * The IP addresses from the certificate's Subject Alternative Names (SANs),
 * %NULL if unavailable.
 *
 * Since: 2.70
 */


/**
 * GTlsCertificate:issuer:
 *
 * A #GTlsCertificate representing the entity that issued this
 * certificate. If %NULL, this means that the certificate is either
 * self-signed, or else the certificate of the issuer is not
 * available.
 *
 * Beware the issuer certificate may not be the same as the
 * certificate that would actually be used to construct a valid
 * certification path during certificate verification.
 * [RFC 4158](https://datatracker.ietf.org/doc/html/rfc4158) explains
 * why an issuer certificate cannot be naively assumed to be part of the
 * the certification path (though GLib's TLS backends may not follow the
 * path building strategies outlined in this RFC). Due to the complexity
 * of certification path building, GLib does not provide any way to know
 * which certification path will actually be used. Accordingly, this
 * property cannot be used to make security-related decisions. Only
 * GLib itself should make security decisions about TLS certificates.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:issuer-name: (nullable)
 *
 * The issuer from the certificate,
 * %NULL if unavailable.
 *
 * Since: 2.70
 */


/**
 * GTlsCertificate:not-valid-after: (nullable)
 *
 * The time at which this cert is no longer valid,
 * %NULL if unavailable.
 *
 * Since: 2.70
 */


/**
 * GTlsCertificate:not-valid-before: (nullable)
 *
 * The time at which this cert is considered to be valid,
 * %NULL if unavailable.
 *
 * Since: 2.70
 */


/**
 * GTlsCertificate:password: (nullable)
 *
 * An optional password used when constructed with GTlsCertificate:pkcs12-data.
 *
 * Since: 2.72
 */


/**
 * GTlsCertificate:pkcs11-uri: (nullable)
 *
 * A URI referencing the [PKCS \#11](https://docs.oasis-open.org/pkcs11/pkcs11-base/v3.0/os/pkcs11-base-v3.0-os.html)
 * objects containing an X.509 certificate and optionally a private key.
 *
 * If %NULL, the certificate is either not backed by PKCS \#11 or the
 * #GTlsBackend does not support PKCS \#11.
 *
 * Since: 2.68
 */


/**
 * GTlsCertificate:pkcs12-data: (nullable)
 *
 * The PKCS #12 formatted data used to construct the object.
 *
 * See also: g_tls_certificate_new_from_pkcs12()
 *
 * Since: 2.72
 */


/**
 * GTlsCertificate:private-key: (nullable)
 *
 * The DER (binary) encoded representation of the certificate's
 * private key, in either [PKCS \#1 format](https://datatracker.ietf.org/doc/html/rfc8017)
 * or unencrypted [PKCS \#8 format.](https://datatracker.ietf.org/doc/html/rfc5208)
 * PKCS \#8 format is supported since 2.32; earlier releases only
 * support PKCS \#1. You can use the `openssl rsa` tool to convert
 * PKCS \#8 keys to PKCS \#1.
 *
 * This property (or the #GTlsCertificate:private-key-pem property)
 * can be set when constructing a key (for example, from a file).
 * Since GLib 2.70, it is now also readable; however, be aware that if
 * the private key is backed by a PKCS \#11 URI – for example, if it
 * is stored on a smartcard – then this property will be %NULL. If so,
 * the private key must be referenced via its PKCS \#11 URI,
 * #GTlsCertificate:private-key-pkcs11-uri. You must check both
 * properties to see if the certificate really has a private key.
 * When this property is read, the output format will be unencrypted
 * PKCS \#8.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:private-key-pem: (nullable)
 *
 * The PEM (ASCII) encoded representation of the certificate's
 * private key in either [PKCS \#1 format](https://datatracker.ietf.org/doc/html/rfc8017)
 * ("`BEGIN RSA PRIVATE KEY`") or unencrypted
 * [PKCS \#8 format](https://datatracker.ietf.org/doc/html/rfc5208)
 * ("`BEGIN PRIVATE KEY`"). PKCS \#8 format is supported since 2.32;
 * earlier releases only support PKCS \#1. You can use the `openssl rsa`
 * tool to convert PKCS \#8 keys to PKCS \#1.
 *
 * This property (or the #GTlsCertificate:private-key property)
 * can be set when constructing a key (for example, from a file).
 * Since GLib 2.70, it is now also readable; however, be aware that if
 * the private key is backed by a PKCS \#11 URI - for example, if it
 * is stored on a smartcard - then this property will be %NULL. If so,
 * the private key must be referenced via its PKCS \#11 URI,
 * #GTlsCertificate:private-key-pkcs11-uri. You must check both
 * properties to see if the certificate really has a private key.
 * When this property is read, the output format will be unencrypted
 * PKCS \#8.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:private-key-pkcs11-uri: (nullable)
 *
 * A URI referencing a [PKCS \#11](https://docs.oasis-open.org/pkcs11/pkcs11-base/v3.0/os/pkcs11-base-v3.0-os.html)
 * object containing a private key.
 *
 * Since: 2.68
 */


/**
 * GTlsCertificate:subject-name: (nullable)
 *
 * The subject from the cert,
 * %NULL if unavailable.
 *
 * Since: 2.70
 */


/**
 * GTlsClientConnection:
 *
 * Abstract base class for the backend-specific client connection
 * type.
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:accepted-cas: (type GLib.List) (element-type GLib.ByteArray)
 *
 * A list of the distinguished names of the Certificate Authorities
 * that the server will accept client certificates signed by. If the
 * server requests a client certificate during the handshake, then
 * this property will be set after the handshake completes.
 *
 * Each item in the list is a #GByteArray which contains the complete
 * subject DN of the certificate authority.
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:server-identity:
 *
 * A #GSocketConnectable describing the identity of the server that
 * is expected on the other end of the connection.
 *
 * If the %G_TLS_CERTIFICATE_BAD_IDENTITY flag is set in
 * #GTlsClientConnection:validation-flags, this object will be used
 * to determine the expected identify of the remote end of the
 * connection; if #GTlsClientConnection:server-identity is not set,
 * or does not match the identity presented by the server, then the
 * %G_TLS_CERTIFICATE_BAD_IDENTITY validation will fail.
 *
 * In addition to its use in verifying the server certificate,
 * this is also used to give a hint to the server about what
 * certificate we expect, which is useful for servers that serve
 * virtual hosts.
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:use-ssl3:
 *
 * SSL 3.0 is no longer supported. See
 * g_tls_client_connection_set_use_ssl3() for details.
 *
 * Since: 2.28
 * Deprecated: 2.56: SSL 3.0 is insecure.
 */


/**
 * GTlsClientConnection:validation-flags:
 *
 * What steps to perform when validating a certificate received from
 * a server. Server certificates that fail to validate in any of the
 * ways indicated here will be rejected unless the application
 * overrides the default via #GTlsConnection::accept-certificate.
 *
 * GLib guarantees that if certificate verification fails, at least one
 * flag will be set, but it does not guarantee that all possible flags
 * will be set. Accordingly, you may not safely decide to ignore any
 * particular type of error. For example, it would be incorrect to mask
 * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired certificates,
 * because this could potentially be the only error flag set even if
 * other problems exist with the certificate. Therefore, there is no
 * safe way to use this property. This is not a horrible problem,
 * though, because you should not be attempting to ignore validation
 * errors anyway. If you really must ignore TLS certificate errors,
 * connect to #GTlsConnection::accept-certificate.
 *
 * Since: 2.28
 * Deprecated: 2.72: Do not attempt to ignore validation errors.
 */


/**
 * GTlsConnection:
 *
 * Abstract base class for the backend-specific #GTlsClientConnection
 * and #GTlsServerConnection types.
 *
 * Since: 2.28
 */


/**
 * GTlsConnection::accept-certificate:
 * @conn: a #GTlsConnection
 * @peer_cert: the peer's #GTlsCertificate
 * @errors: the problems with @peer_cert.
 *
 * Emitted during the TLS handshake after the peer certificate has
 * been received. You can examine @peer_cert's certification path by
 * calling g_tls_certificate_get_issuer() on it.
 *
 * For a client-side connection, @peer_cert is the server's
 * certificate, and the signal will only be emitted if the
 * certificate was not acceptable according to @conn's
 * #GTlsClientConnection:validation_flags. If you would like the
 * certificate to be accepted despite @errors, return %TRUE from the
 * signal handler. Otherwise, if no handler accepts the certificate,
 * the handshake will fail with %G_TLS_ERROR_BAD_CERTIFICATE.
 *
 * GLib guarantees that if certificate verification fails, this signal
 * will be emitted with at least one error will be set in @errors, but
 * it does not guarantee that all possible errors will be set.
 * Accordingly, you may not safely decide to ignore any particular
 * type of error. For example, it would be incorrect to ignore
 * %G_TLS_CERTIFICATE_EXPIRED if you want to allow expired
 * certificates, because this could potentially be the only error flag
 * set even if other problems exist with the certificate.
 *
 * For a server-side connection, @peer_cert is the certificate
 * presented by the client, if this was requested via the server's
 * #GTlsServerConnection:authentication_mode. On the server side,
 * the signal is always emitted when the client presents a
 * certificate, and the certificate will only be accepted if a
 * handler returns %TRUE.
 *
 * Note that if this signal is emitted as part of asynchronous I/O
 * in the main thread, then you should not attempt to interact with
 * the user before returning from the signal handler. If you want to
 * let the user decide whether or not to accept the certificate, you
 * would have to return %FALSE from the signal handler on the first
 * attempt, and then after the connection attempt returns a
 * %G_TLS_ERROR_BAD_CERTIFICATE, you can interact with the user, and
 * if the user decides to accept the certificate, remember that fact,
 * create a new connection, and return %TRUE from the signal handler
 * the next time.
 *
 * If you are doing I/O in another thread, you do not
 * need to worry about this, and can simply block in the signal
 * handler until the UI thread returns an answer.
 *
 * Returns: %TRUE to accept @peer_cert (which will also
 * immediately end the signal emission). %FALSE to allow the signal
 * emission to continue, which will cause the handshake to fail if
 * no one else overrides it.
 * Since: 2.28
 */


/**
 * GTlsConnection:advertised-protocols: (nullable)
 *
 * The list of application-layer protocols that the connection
 * advertises that it is willing to speak. See
 * g_tls_connection_set_advertised_protocols().
 *
 * Since: 2.60
 */


/**
 * GTlsConnection:base-io-stream:
 *
 * The #GIOStream that the connection wraps. The connection holds a reference
 * to this stream, and may run operations on the stream from other threads
 * throughout its lifetime. Consequently, after the #GIOStream has been
 * constructed, application code may only run its own operations on this
 * stream when no #GIOStream operations are running.
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:certificate:
 *
 * The connection's certificate; see
 * g_tls_connection_set_certificate().
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:ciphersuite-name: (nullable)
 *
 * The name of the TLS ciphersuite in use. See g_tls_connection_get_ciphersuite_name().
 *
 * Since: 2.70
 */


/**
 * GTlsConnection:database: (nullable)
 *
 * The certificate database to use when verifying this TLS connection.
 * If no certificate database is set, then the default database will be
 * used. See g_tls_backend_get_default_database().
 *
 * When using a non-default database, #GTlsConnection must fall back to using
 * the #GTlsDatabase to perform certificate verification using
 * g_tls_database_verify_chain(), which means certificate verification will
 * not be able to make use of TLS session context. This may be less secure.
 * For example, if you create your own #GTlsDatabase that just wraps the
 * default #GTlsDatabase, you might expect that you have not changed anything,
 * but this is not true because you may have altered the behavior of
 * #GTlsConnection by causing it to use g_tls_database_verify_chain(). See the
 * documentation of g_tls_database_verify_chain() for more details on specific
 * security checks that may not be performed. Accordingly, setting a
 * non-default database is discouraged except for specialty applications with
 * unusual security requirements.
 *
 * Since: 2.30
 */


/**
 * GTlsConnection:interaction: (nullable)
 *
 * A #GTlsInteraction object to be used when the connection or certificate
 * database need to interact with the user. This will be used to prompt the
 * user for passwords where necessary.
 *
 * Since: 2.30
 */


/**
 * GTlsConnection:negotiated-protocol:
 *
 * The application-layer protocol negotiated during the TLS
 * handshake. See g_tls_connection_get_negotiated_protocol().
 *
 * Since: 2.60
 */


/**
 * GTlsConnection:peer-certificate: (nullable)
 *
 * The connection's peer's certificate, after the TLS handshake has
 * completed or failed. Note in particular that this is not yet set
 * during the emission of #GTlsConnection::accept-certificate.
 *
 * (You can watch for a #GObject::notify signal on this property to
 * detect when a handshake has occurred.)
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:peer-certificate-errors:
 *
 * The errors noticed while verifying
 * #GTlsConnection:peer-certificate. Normally this should be 0, but
 * it may not be if #GTlsClientConnection:validation-flags is not
 * %G_TLS_CERTIFICATE_VALIDATE_ALL, or if
 * #GTlsConnection::accept-certificate overrode the default
 * behavior.
 *
 * GLib guarantees that if certificate verification fails, at least
 * one error will be set, but it does not guarantee that all possible
 * errors will be set. Accordingly, you may not safely decide to
 * ignore any particular type of error. For example, it would be
 * incorrect to mask %G_TLS_CERTIFICATE_EXPIRED if you want to allow
 * expired certificates, because this could potentially be the only
 * error flag set even if other problems exist with the certificate.
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:protocol-version:
 *
 * The TLS protocol version in use. See g_tls_connection_get_protocol_version().
 *
 * Since: 2.70
 */


/**
 * GTlsConnection:rehandshake-mode:
 *
 * The rehandshaking mode. See
 * g_tls_connection_set_rehandshake_mode().
 *
 * Since: 2.28
 * Deprecated: 2.60: The rehandshake mode is ignored.
 */


/**
 * GTlsConnection:require-close-notify:
 *
 * Whether or not proper TLS close notification is required.
 * See g_tls_connection_set_require_close_notify().
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:use-system-certdb:
 *
 * Whether or not the system certificate database will be used to
 * verify peer certificates. See
 * g_tls_connection_set_use_system_certdb().
 *
 * Deprecated: 2.30: Use GTlsConnection:database instead
 */


/**
 * GTlsDatabase:
 *
 * Abstract base class for the backend-specific database types.
 *
 * Since: 2.30
 */


/**
 * GTlsDatabaseClass:
 * @verify_chain: Virtual method implementing
 *  g_tls_database_verify_chain().
 * @verify_chain_async: Virtual method implementing
 *  g_tls_database_verify_chain_async().
 * @verify_chain_finish: Virtual method implementing
 *  g_tls_database_verify_chain_finish().
 * @create_certificate_handle: Virtual method implementing
 *  g_tls_database_create_certificate_handle().
 * @lookup_certificate_for_handle: Virtual method implementing
 *  g_tls_database_lookup_certificate_for_handle().
 * @lookup_certificate_for_handle_async: Virtual method implementing
 *  g_tls_database_lookup_certificate_for_handle_async().
 * @lookup_certificate_for_handle_finish: Virtual method implementing
 *  g_tls_database_lookup_certificate_for_handle_finish().
 * @lookup_certificate_issuer: Virtual method implementing
 *  g_tls_database_lookup_certificate_issuer().
 * @lookup_certificate_issuer_async: Virtual method implementing
 *  g_tls_database_lookup_certificate_issuer_async().
 * @lookup_certificate_issuer_finish: Virtual method implementing
 *  g_tls_database_lookup_certificate_issuer_finish().
 * @lookup_certificates_issued_by: Virtual method implementing
 *  g_tls_database_lookup_certificates_issued_by().
 * @lookup_certificates_issued_by_async: Virtual method implementing
 *  g_tls_database_lookup_certificates_issued_by_async().
 * @lookup_certificates_issued_by_finish: Virtual method implementing
 *  g_tls_database_lookup_certificates_issued_by_finish().
 *
 * The class for #GTlsDatabase. Derived classes should implement the various
 * virtual methods. _async and _finish methods have a default
 * implementation that runs the corresponding sync method in a thread.
 *
 * Since: 2.30
 */


/**
 * GTlsFileDatabase:
 *
 * Implemented by a #GTlsDatabase which allows you to load certificates
 * from a file.
 *
 * Since: 2.30
 */


/**
 * GTlsFileDatabase:anchors:
 *
 * The path to a file containing PEM encoded certificate authority
 * root anchors. The certificates in this file will be treated as
 * root authorities for the purpose of verifying other certificates
 * via the g_tls_database_verify_chain() operation.
 *
 * Since: 2.30
 */


/**
 * GTlsInteraction:
 *
 * An object representing interaction that the TLS connection and database
 * might have with the user.
 *
 * Since: 2.30
 */


/**
 * GTlsInteractionClass:
 * @ask_password: ask for a password synchronously. If the implementation
 *     returns %G_TLS_INTERACTION_HANDLED, then the password argument should
 *     have been filled in by using g_tls_password_set_value() or a similar
 *     function.
 * @ask_password_async: ask for a password asynchronously.
 * @ask_password_finish: complete operation to ask for a password asynchronously.
 *     If the implementation returns %G_TLS_INTERACTION_HANDLED, then the
 *     password argument of the async method should have been filled in by using
 *     g_tls_password_set_value() or a similar function.
 * @request_certificate: ask for a certificate synchronously. If the
 *     implementation returns %G_TLS_INTERACTION_HANDLED, then the connection
 *     argument should have been filled in by using
 *     g_tls_connection_set_certificate().
 * @request_certificate_async: ask for a certificate asynchronously.
 * @request_certificate_finish: complete operation to ask for a certificate
 *     asynchronously. If the implementation returns %G_TLS_INTERACTION_HANDLED,
 *     then the connection argument of the async method should have been
 *     filled in by using g_tls_connection_set_certificate().
 *
 * The class for #GTlsInteraction. Derived classes implement the various
 * virtual interaction methods to handle TLS interactions.
 *
 * Derived classes can choose to implement whichever interactions methods they'd
 * like to support by overriding those virtual methods in their class
 * initialization function. If a derived class implements an async method,
 * it must also implement the corresponding finish method.
 *
 * The synchronous interaction methods should implement to display modal dialogs,
 * and the asynchronous methods to display modeless dialogs.
 *
 * If the user cancels an interaction, then the result should be
 * %G_TLS_INTERACTION_FAILED and the error should be set with a domain of
 * %G_IO_ERROR and code of %G_IO_ERROR_CANCELLED.
 *
 * Since: 2.30
 */


/**
 * GTlsPassword:
 *
 * An abstract interface representing a password used in TLS. Often used in
 * user interaction such as unlocking a key storage token.
 *
 * Since: 2.30
 */


/**
 * GTlsServerConnection:authentication-mode:
 *
 * The #GTlsAuthenticationMode for the server. This can be changed
 * before calling g_tls_connection_handshake() if you want to
 * rehandshake with a different mode from the initial handshake.
 *
 * Since: 2.28
 */


/**
 * GUnixConnection:
 *
 * #GUnixConnection is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GUnixCredentialsMessage:credentials:
 *
 * The credentials stored in the message.
 *
 * Since: 2.26
 */


/**
 * GUnixFDList:
 *
 * #GUnixFDList is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GUnixFDMessage:
 *
 * #GUnixFDMessage is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GUnixInputStream:close-fd:
 *
 * Whether to close the file descriptor when the stream is closed.
 *
 * Since: 2.20
 */


/**
 * GUnixInputStream:fd:
 *
 * The file descriptor that the stream reads from.
 *
 * Since: 2.20
 */


/**
 * GUnixMountMonitor::mountpoints-changed:
 * @monitor: the object on which the signal is emitted
 *
 * Emitted when the unix mount points have changed.
 */


/**
 * GUnixMountMonitor::mounts-changed:
 * @monitor: the object on which the signal is emitted
 *
 * Emitted when the unix mounts have changed.
 */


/**
 * GUnixMountType:
 * @G_UNIX_MOUNT_TYPE_UNKNOWN: Unknown UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_FLOPPY: Floppy disk UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_CDROM: CDROM UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_NFS: Network File System (NFS) UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_ZIP: ZIP UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_JAZ: JAZZ UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_MEMSTICK: Memory Stick UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_CF: Compact Flash UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_SM: Smart Media UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_SDMMC: SD/MMC UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_IPOD: iPod UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_CAMERA: Digital camera UNIX mount type.
 * @G_UNIX_MOUNT_TYPE_HD: Hard drive UNIX mount type.
 *
 * Types of UNIX mounts.
 */


/**
 * GUnixOutputStream:close-fd:
 *
 * Whether to close the file descriptor when the stream is closed.
 *
 * Since: 2.20
 */


/**
 * GUnixOutputStream:fd:
 *
 * The file descriptor that the stream writes to.
 *
 * Since: 2.20
 */


/**
 * GUnixSocketAddress:
 *
 * A UNIX-domain (local) socket address, corresponding to a
 * struct sockaddr_un.
 */


/**
 * GUnixSocketAddress:abstract:
 *
 * Whether or not this is an abstract address
 *
 * Deprecated: Use #GUnixSocketAddress:address-type, which
 * distinguishes between zero-padded and non-zero-padded
 * abstract addresses.
 */


/**
 * GVolume::changed:
 *
 * Emitted when the volume has been changed.
 */


/**
 * GVolume::removed:
 *
 * This signal is emitted when the #GVolume have been removed. If
 * the recipient is holding references to the object they should
 * release them so the object can be finalized.
 */


/**
 * GVolumeMonitor::drive-changed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: the drive that changed
 *
 * Emitted when a drive changes.
 */


/**
 * GVolumeMonitor::drive-connected:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: a #GDrive that was connected.
 *
 * Emitted when a drive is connected to the system.
 */


/**
 * GVolumeMonitor::drive-disconnected:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: a #GDrive that was disconnected.
 *
 * Emitted when a drive is disconnected from the system.
 */


/**
 * GVolumeMonitor::drive-eject-button:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: the drive where the eject button was pressed
 *
 * Emitted when the eject button is pressed on @drive.
 *
 * Since: 2.18
 */


/**
 * GVolumeMonitor::drive-stop-button:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: the drive where the stop button was pressed
 *
 * Emitted when the stop button is pressed on @drive.
 *
 * Since: 2.22
 */


/**
 * GVolumeMonitor::mount-added:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that was added.
 *
 * Emitted when a mount is added.
 */


/**
 * GVolumeMonitor::mount-changed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that changed.
 *
 * Emitted when a mount changes.
 */


/**
 * GVolumeMonitor::mount-pre-unmount:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that is being unmounted.
 *
 * May be emitted when a mount is about to be removed.
 *
 * This signal depends on the backend and is only emitted if
 * GIO was used to unmount.
 */


/**
 * GVolumeMonitor::mount-removed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that was removed.
 *
 * Emitted when a mount is removed.
 */


/**
 * GVolumeMonitor::volume-added:
 * @volume_monitor: The volume monitor emitting the signal.
 * @volume: a #GVolume that was added.
 *
 * Emitted when a mountable volume is added to the system.
 */


/**
 * GVolumeMonitor::volume-changed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @volume: a #GVolume that changed.
 *
 * Emitted when mountable volume is changed.
 */


/**
 * GVolumeMonitor::volume-removed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @volume: a #GVolume that was removed.
 *
 * Emitted when a mountable volume is removed from the system.
 */


/**
 * GWin32InputStream:close-handle:
 *
 * Whether to close the file handle when the stream is closed.
 *
 * Since: 2.26
 */


/**
 * GWin32InputStream:handle:
 *
 * The handle that the stream reads from.
 *
 * Since: 2.26
 */


/**
 * GWin32OutputStream:close-handle:
 *
 * Whether to close the file handle when the stream is closed.
 *
 * Since: 2.26
 */


/**
 * GWin32OutputStream:handle:
 *
 * The file handle that the stream writes to.
 *
 * Since: 2.26
 */


/**
 * GWin32RegistryKey:path:
 *
 * A path to the key in the registry, in UTF-8.
 *
 * Since: 2.46
 */


/**
 * GWin32RegistryKey:path-utf16:
 *
 * A path to the key in the registry, in UTF-16.
 *
 * Since: 2.46
 */


/**
 * GZlibCompressor:
 *
 * Zlib decompression
 */


/**
 * GZlibCompressor:file-info:
 *
 * If set to a non-%NULL #GFileInfo object, and #GZlibCompressor:format is
 * %G_ZLIB_COMPRESSOR_FORMAT_GZIP, the compressor will write the file name
 * and modification time from the file info to the GZIP header.
 *
 * Since: 2.26
 */


/**
 * GZlibDecompressor:
 *
 * Zlib decompression
 */


/**
 * GZlibDecompressor:file-info:
 *
 * A #GFileInfo containing the information found in the GZIP header
 * of the data stream processed, or %NULL if the header was not yet
 * fully processed, is not present at all, or the compressor's
 * #GZlibDecompressor:format property is not %G_ZLIB_COMPRESSOR_FORMAT_GZIP.
 *
 * Since: 2.26
 */


/**
 * G_TLS_DATABASE_PURPOSE_AUTHENTICATE_CLIENT:
 *
 * The purpose used to verify the client certificate in a TLS connection.
 * Used by TLS servers.
 */


/**
 * G_TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER:
 *
 * The purpose used to verify the server certificate in a TLS connection. This
 * is the most common purpose in use. Used by TLS clients.
 */


/**
 * G_TYPE_SETTINGS_SCHEMA:
 *
 * A boxed #GType corresponding to #GSettingsSchema.
 *
 * Since: 2.32
 */


/**
 * G_TYPE_SETTINGS_SCHEMA_SOURCE:
 *
 * A boxed #GType corresponding to #GSettingsSchemaSource.
 *
 * Since: 2.32
 */


/**
 * SECTION:extensionpoints
 * @short_description: Extension Points
 * @include: gio.h
 * @see_also: [Extending GIO][extending-gio]
 *
 * #GIOExtensionPoint provides a mechanism for modules to extend the
 * functionality of the library or application that loaded it in an
 * organized fashion.
 *
 * An extension point is identified by a name, and it may optionally
 * require that any implementation must be of a certain type (or derived
 * thereof). Use g_io_extension_point_register() to register an
 * extension point, and g_io_extension_point_set_required_type() to
 * set a required type.
 *
 * A module can implement an extension point by specifying the #GType
 * that implements the functionality. Additionally, each implementation
 * of an extension point has a name, and a priority. Use
 * g_io_extension_point_implement() to implement an extension point.
 *
 *  |[<!-- language="C" -->
 *  GIOExtensionPoint *ep;
 *
 *  // Register an extension point
 *  ep = g_io_extension_point_register ("my-extension-point");
 *  g_io_extension_point_set_required_type (ep, MY_TYPE_EXAMPLE);
 *  ]|
 *
 *  |[<!-- language="C" -->
 *  // Implement an extension point
 *  G_DEFINE_TYPE (MyExampleImpl, my_example_impl, MY_TYPE_EXAMPLE)
 *  g_io_extension_point_implement ("my-extension-point",
 *                                  my_example_impl_get_type (),
 *                                  "my-example",
 *                                  10);
 *  ]|
 *
 *  It is up to the code that registered the extension point how
 *  it uses the implementations that have been associated with it.
 *  Depending on the use case, it may use all implementations, or
 *  only the one with the highest priority, or pick a specific
 *  one by name.
 *
 *  To avoid opening all modules just to find out what extension
 *  points they implement, GIO makes use of a caching mechanism,
 *  see [gio-querymodules][gio-querymodules].
 *  You are expected to run this command after installing a
 *  GIO module.
 *
 *  The `GIO_EXTRA_MODULES` environment variable can be used to
 *  specify additional directories to automatically load modules
 *  from. This environment variable has the same syntax as the
 *  `PATH`. If two modules have the same base name in different
 *  directories, then the latter one will be ignored. If additional
 *  directories are specified GIO will load modules from the built-in
 *  directory last.
 */


/**
 * SECTION:gaction
 * @title: GAction
 * @short_description: An action interface
 * @include: gio/gio.h
 *
 * #GAction represents a single named action.
 *
 * The main interface to an action is that it can be activated with
 * g_action_activate().  This results in the 'activate' signal being
 * emitted.  An activation has a #GVariant parameter (which may be
 * %NULL).  The correct type for the parameter is determined by a static
 * parameter type (which is given at construction time).
 *
 * An action may optionally have a state, in which case the state may be
 * set with g_action_change_state().  This call takes a #GVariant.  The
 * correct type for the state is determined by a static state type
 * (which is given at construction time).
 *
 * The state may have a hint associated with it, specifying its valid
 * range.
 *
 * #GAction is merely the interface to the concept of an action, as
 * described above.  Various implementations of actions exist, including
 * #GSimpleAction.
 *
 * In all cases, the implementing class is responsible for storing the
 * name of the action, the parameter type, the enabled state, the
 * optional state type and the state and emitting the appropriate
 * signals when these change.  The implementor is responsible for filtering
 * calls to g_action_activate() and g_action_change_state() for type
 * safety and for the state being enabled.
 *
 * Probably the only useful thing to do with a #GAction is to put it
 * inside of a #GSimpleActionGroup.
 */


/**
 * SECTION:gactiongroup
 * @title: GActionGroup
 * @short_description: A group of actions
 * @include: gio/gio.h
 * @see_also: #GAction
 *
 * #GActionGroup represents a group of actions. Actions can be used to
 * expose functionality in a structured way, either from one part of a
 * program to another, or to the outside world. Action groups are often
 * used together with a #GMenuModel that provides additional
 * representation data for displaying the actions to the user, e.g. in
 * a menu.
 *
 * The main way to interact with the actions in a GActionGroup is to
 * activate them with g_action_group_activate_action(). Activating an
 * action may require a #GVariant parameter. The required type of the
 * parameter can be inquired with g_action_group_get_action_parameter_type().
 * Actions may be disabled, see g_action_group_get_action_enabled().
 * Activating a disabled action has no effect.
 *
 * Actions may optionally have a state in the form of a #GVariant. The
 * current state of an action can be inquired with
 * g_action_group_get_action_state(). Activating a stateful action may
 * change its state, but it is also possible to set the state by calling
 * g_action_group_change_action_state().
 *
 * As typical example, consider a text editing application which has an
 * option to change the current font to 'bold'. A good way to represent
 * this would be a stateful action, with a boolean state. Activating the
 * action would toggle the state.
 *
 * Each action in the group has a unique name (which is a string).  All
 * method calls, except g_action_group_list_actions() take the name of
 * an action as an argument.
 *
 * The #GActionGroup API is meant to be the 'public' API to the action
 * group.  The calls here are exactly the interaction that 'external
 * forces' (eg: UI, incoming D-Bus messages, etc.) are supposed to have
 * with actions.  'Internal' APIs (ie: ones meant only to be accessed by
 * the action group implementation) are found on subclasses.  This is
 * why you will find - for example - g_action_group_get_action_enabled()
 * but not an equivalent set() call.
 *
 * Signals are emitted on the action group in response to state changes
 * on individual actions.
 *
 * Implementations of #GActionGroup should provide implementations for
 * the virtual functions g_action_group_list_actions() and
 * g_action_group_query_action().  The other virtual functions should
 * not be implemented - their "wrappers" are actually implemented with
 * calls to g_action_group_query_action().
 */


/**
 * SECTION:gactiongroupexporter
 * @title: GActionGroup exporter
 * @include: gio/gio.h
 * @short_description: Export GActionGroups on D-Bus
 * @see_also: #GActionGroup, #GDBusActionGroup
 *
 * These functions support exporting a #GActionGroup on D-Bus.
 * The D-Bus interface that is used is a private implementation
 * detail.
 *
 * To access an exported #GActionGroup remotely, use
 * g_dbus_action_group_get() to obtain a #GDBusActionGroup.
 */


/**
 * SECTION:gactionmap
 * @title: GActionMap
 * @include: gio/gio.h
 * @short_description: Interface for action containers
 *
 * The GActionMap interface is implemented by #GActionGroup
 * implementations that operate by containing a number of
 * named #GAction instances, such as #GSimpleActionGroup.
 *
 * One useful application of this interface is to map the
 * names of actions from various action groups to unique,
 * prefixed names (e.g. by prepending "app." or "win.").
 * This is the motivation for the 'Map' part of the interface
 * name.
 *
 * Since: 2.32
 */


/**
 * SECTION:gappinfo
 * @short_description: Application information and launch contexts
 * @include: gio/gio.h
 * @see_also: #GAppInfoMonitor
 *
 * #GAppInfo and #GAppLaunchContext are used for describing and launching
 * applications installed on the system.
 *
 * As of GLib 2.20, URIs will always be converted to POSIX paths
 * (using g_file_get_path()) when using g_app_info_launch() even if
 * the application requested an URI and not a POSIX path. For example
 * for a desktop-file based application with Exec key `totem
 * %U` and a single URI, `sftp://foo/file.avi`, then
 * `/home/user/.gvfs/sftp on foo/file.avi` will be passed. This will
 * only work if a set of suitable GIO extensions (such as gvfs 2.26
 * compiled with FUSE support), is available and operational; if this
 * is not the case, the URI will be passed unmodified to the application.
 * Some URIs, such as `mailto:`, of course cannot be mapped to a POSIX
 * path (in gvfs there's no FUSE mount for it); such URIs will be
 * passed unmodified to the application.
 *
 * Specifically for gvfs 2.26 and later, the POSIX URI will be mapped
 * back to the GIO URI in the #GFile constructors (since gvfs
 * implements the #GVfs extension point). As such, if the application
 * needs to examine the URI, it needs to use g_file_get_uri() or
 * similar on #GFile. In other words, an application cannot assume
 * that the URI passed to e.g. g_file_new_for_commandline_arg() is
 * equal to the result of g_file_get_uri(). The following snippet
 * illustrates this:
 *
 * |[
 * GFile *f;
 * char *uri;
 *
 * file = g_file_new_for_commandline_arg (uri_from_commandline);
 *
 * uri = g_file_get_uri (file);
 * strcmp (uri, uri_from_commandline) == 0;
 * g_free (uri);
 *
 * if (g_file_has_uri_scheme (file, "cdda"))
 *   {
 *     // do something special with uri
 *   }
 * g_object_unref (file);
 * ]|
 *
 * This code will work when both `cdda://sr0/Track 1.wav` and
 * `/home/user/.gvfs/cdda on sr0/Track 1.wav` is passed to the
 * application. It should be noted that it's generally not safe
 * for applications to rely on the format of a particular URIs.
 * Different launcher applications (e.g. file managers) may have
 * different ideas of what a given URI means.
 */


/**
 * SECTION:gappinfomonitor
 * @short_description: Monitor application information for changes
 *
 * #GAppInfoMonitor is a very simple object used for monitoring the app
 * info database for changes (newly installed or removed applications).
 *
 * Call g_app_info_monitor_get() to get a #GAppInfoMonitor and connect
 * to the #GAppInfoMonitor::changed signal. The signal will be emitted once when
 * the app info database changes, and will not be emitted again until after the
 * next call to g_app_info_get_all() or another `g_app_info_*()` function. This
 * is because monitoring the app info database for changes is expensive.
 *
 * The following functions will re-arm the #GAppInfoMonitor::changed signal so
 * it can be emitted again:
 *  - g_app_info_get_all()
 *  - g_app_info_get_all_for_type()
 *  - g_app_info_get_default_for_type()
 *  - g_app_info_get_fallback_for_type()
 *  - g_app_info_get_recommended_for_type()
 *  - g_desktop_app_info_get_implementations()
 *  - g_desktop_app_info_new()
 *  - g_desktop_app_info_new_from_filename()
 *  - g_desktop_app_info_new_from_keyfile()
 *  - g_desktop_app_info_search()
 *
 * In the usual case, applications should try to make note of the change
 * (doing things like invalidating caches) but not act on it.  In
 * particular, applications should avoid making calls to #GAppInfo APIs
 * in response to the change signal, deferring these until the time that
 * the updated data is actually required.  The exception to this case is when
 * application information is actually being displayed on the screen
 * (for example, during a search or when the list of all applications is shown).
 * The reason for this is that changes to the list of installed
 * applications often come in groups (like during system updates) and
 * rescanning the list on every change is pointless and expensive.
 *
 * Since: 2.40
 */


/**
 * SECTION:gapplication
 * @title: GApplication
 * @short_description: Core application class
 * @include: gio/gio.h
 *
 * A #GApplication is the foundation of an application.  It wraps some
 * low-level platform-specific services and is intended to act as the
 * foundation for higher-level application classes such as
 * #GtkApplication or #MxApplication.  In general, you should not use
 * this class outside of a higher level framework.
 *
 * GApplication provides convenient life cycle management by maintaining
 * a "use count" for the primary application instance. The use count can
 * be changed using g_application_hold() and g_application_release(). If
 * it drops to zero, the application exits. Higher-level classes such as
 * #GtkApplication employ the use count to ensure that the application
 * stays alive as long as it has any opened windows.
 *
 * Another feature that GApplication (optionally) provides is process
 * uniqueness. Applications can make use of this functionality by
 * providing a unique application ID. If given, only one application
 * with this ID can be running at a time per session. The session
 * concept is platform-dependent, but corresponds roughly to a graphical
 * desktop login. When your application is launched again, its
 * arguments are passed through platform communication to the already
 * running program. The already running instance of the program is
 * called the "primary instance"; for non-unique applications this is
 * always the current instance. On Linux, the D-Bus session bus
 * is used for communication.
 *
 * The use of #GApplication differs from some other commonly-used
 * uniqueness libraries (such as libunique) in important ways. The
 * application is not expected to manually register itself and check
 * if it is the primary instance. Instead, the main() function of a
 * #GApplication should do very little more than instantiating the
 * application instance, possibly connecting signal handlers, then
 * calling g_application_run(). All checks for uniqueness are done
 * internally. If the application is the primary instance then the
 * startup signal is emitted and the mainloop runs. If the application
 * is not the primary instance then a signal is sent to the primary
 * instance and g_application_run() promptly returns. See the code
 * examples below.
 *
 * If used, the expected form of an application identifier is the
 * same as that of a
 * [D-Bus well-known bus name](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-bus).
 * Examples include: `com.example.MyApp`, `org.example.internal_apps.Calculator`,
 * `org._7_zip.Archiver`.
 * For details on valid application identifiers, see g_application_id_is_valid().
 *
 * On Linux, the application identifier is claimed as a well-known bus name
 * on the user's session bus.  This means that the uniqueness of your
 * application is scoped to the current session.  It also means that your
 * application may provide additional services (through registration of other
 * object paths) at that bus name.  The registration of these object paths
 * should be done with the shared GDBus session bus.  Note that due to the
 * internal architecture of GDBus, method calls can be dispatched at any time
 * (even if a main loop is not running).  For this reason, you must ensure that
 * any object paths that you wish to register are registered before #GApplication
 * attempts to acquire the bus name of your application (which happens in
 * g_application_register()).  Unfortunately, this means that you cannot use
 * g_application_get_is_remote() to decide if you want to register object paths.
 *
 * GApplication also implements the #GActionGroup and #GActionMap
 * interfaces and lets you easily export actions by adding them with
 * g_action_map_add_action(). When invoking an action by calling
 * g_action_group_activate_action() on the application, it is always
 * invoked in the primary instance. The actions are also exported on
 * the session bus, and GIO provides the #GDBusActionGroup wrapper to
 * conveniently access them remotely. GIO provides a #GDBusMenuModel wrapper
 * for remote access to exported #GMenuModels.
 *
 * Note: Due to the fact that actions are exported on the session bus,
 * using `maybe` parameters is not supported, since D-Bus does not support
 * `maybe` types.
 *
 * There is a number of different entry points into a GApplication:
 *
 * - via 'Activate' (i.e. just starting the application)
 *
 * - via 'Open' (i.e. opening some files)
 *
 * - by handling a command-line
 *
 * - via activating an action
 *
 * The #GApplication::startup signal lets you handle the application
 * initialization for all of these in a single place.
 *
 * Regardless of which of these entry points is used to start the
 * application, GApplication passes some ‘platform data’ from the
 * launching instance to the primary instance, in the form of a
 * #GVariant dictionary mapping strings to variants. To use platform
 * data, override the @before_emit or @after_emit virtual functions
 * in your #GApplication subclass. When dealing with
 * #GApplicationCommandLine objects, the platform data is
 * directly available via g_application_command_line_get_cwd(),
 * g_application_command_line_get_environ() and
 * g_application_command_line_get_platform_data().
 *
 * As the name indicates, the platform data may vary depending on the
 * operating system, but it always includes the current directory (key
 * "cwd"), and optionally the environment (ie the set of environment
 * variables and their values) of the calling process (key "environ").
 * The environment is only added to the platform data if the
 * %G_APPLICATION_SEND_ENVIRONMENT flag is set. #GApplication subclasses
 * can add their own platform data by overriding the @add_platform_data
 * virtual function. For instance, #GtkApplication adds startup notification
 * data in this way.
 *
 * To parse commandline arguments you may handle the
 * #GApplication::command-line signal or override the local_command_line()
 * vfunc, to parse them in either the primary instance or the local instance,
 * respectively.
 *
 * For an example of opening files with a GApplication, see
 * [gapplication-example-open.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-open.c).
 *
 * For an example of using actions with GApplication, see
 * [gapplication-example-actions.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-actions.c).
 *
 * For an example of using extra D-Bus hooks with GApplication, see
 * [gapplication-example-dbushooks.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-dbushooks.c).
 */


/**
 * SECTION:gapplicationcommandline
 * @title: GApplicationCommandLine
 * @short_description: A command-line invocation of an application
 * @include: gio/gio.h
 * @see_also: #GApplication
 *
 * #GApplicationCommandLine represents a command-line invocation of
 * an application.  It is created by #GApplication and emitted
 * in the #GApplication::command-line signal and virtual function.
 *
 * The class contains the list of arguments that the program was invoked
 * with.  It is also possible to query if the commandline invocation was
 * local (ie: the current process is running in direct response to the
 * invocation) or remote (ie: some other process forwarded the
 * commandline to this process).
 *
 * The GApplicationCommandLine object can provide the @argc and @argv
 * parameters for use with the #GOptionContext command-line parsing API,
 * with the g_application_command_line_get_arguments() function. See
 * [gapplication-example-cmdline3.c][gapplication-example-cmdline3]
 * for an example.
 *
 * The exit status of the originally-invoked process may be set and
 * messages can be printed to stdout or stderr of that process.  The
 * lifecycle of the originally-invoked process is tied to the lifecycle
 * of this object (ie: the process exits when the last reference is
 * dropped).
 *
 * The main use for #GApplicationCommandLine (and the
 * #GApplication::command-line signal) is 'Emacs server' like use cases:
 * You can set the `EDITOR` environment variable to have e.g. git use
 * your favourite editor to edit commit messages, and if you already
 * have an instance of the editor running, the editing will happen
 * in the running instance, instead of opening a new one. An important
 * aspect of this use case is that the process that gets started by git
 * does not return until the editing is done.
 *
 * Normally, the commandline is completely handled in the
 * #GApplication::command-line handler. The launching instance exits
 * once the signal handler in the primary instance has returned, and
 * the return value of the signal handler becomes the exit status
 * of the launching instance.
 * |[<!-- language="C" -->
 * static int
 * command_line (GApplication            *application,
 *               GApplicationCommandLine *cmdline)
 * {
 *   gchar **argv;
 *   gint argc;
 *   gint i;
 *
 *   argv = g_application_command_line_get_arguments (cmdline, &argc);
 *
 *   g_application_command_line_print (cmdline,
 *                                     "This text is written back\n"
 *                                     "to stdout of the caller\n");
 *
 *   for (i = 0; i < argc; i++)
 *     g_print ("argument %d: %s\n", i, argv[i]);
 *
 *   g_strfreev (argv);
 *
 *   return 0;
 * }
 * ]|
 * The complete example can be found here:
 * [gapplication-example-cmdline.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline.c)
 *
 * In more complicated cases, the handling of the commandline can be
 * split between the launcher and the primary instance.
 * |[<!-- language="C" -->
 * static gboolean
 *  test_local_cmdline (GApplication   *application,
 *                      gchar        ***arguments,
 *                      gint           *exit_status)
 * {
 *   gint i, j;
 *   gchar **argv;
 *
 *   argv = *arguments;
 *
 *   if (argv[0] == NULL)
 *     {
 *       *exit_status = 0;
 *       return FALSE;
 *     }
 *
 *   i = 1;
 *   while (argv[i])
 *     {
 *       if (g_str_has_prefix (argv[i], "--local-"))
 *         {
 *           g_print ("handling argument %s locally\n", argv[i]);
 *           g_free (argv[i]);
 *           for (j = i; argv[j]; j++)
 *             argv[j] = argv[j + 1];
 *         }
 *       else
 *         {
 *           g_print ("not handling argument %s locally\n", argv[i]);
 *           i++;
 *         }
 *     }
 *
 *   *exit_status = 0;
 *
 *   return FALSE;
 * }
 *
 * static void
 * test_application_class_init (TestApplicationClass *class)
 * {
 *   G_APPLICATION_CLASS (class)->local_command_line = test_local_cmdline;
 *
 *   ...
 * }
 * ]|
 * In this example of split commandline handling, options that start
 * with `--local-` are handled locally, all other options are passed
 * to the #GApplication::command-line handler which runs in the primary
 * instance.
 *
 * The complete example can be found here:
 * [gapplication-example-cmdline2.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline2.c)
 *
 * If handling the commandline requires a lot of work, it may
 * be better to defer it.
 * |[<!-- language="C" -->
 * static gboolean
 * my_cmdline_handler (gpointer data)
 * {
 *   GApplicationCommandLine *cmdline = data;
 *
 *   // do the heavy lifting in an idle
 *
 *   g_application_command_line_set_exit_status (cmdline, 0);
 *   g_object_unref (cmdline); // this releases the application
 *
 *   return G_SOURCE_REMOVE;
 * }
 *
 * static int
 * command_line (GApplication            *application,
 *               GApplicationCommandLine *cmdline)
 * {
 *   // keep the application running until we are done with this commandline
 *   g_application_hold (application);
 *
 *   g_object_set_data_full (G_OBJECT (cmdline),
 *                           "application", application,
 *                           (GDestroyNotify)g_application_release);
 *
 *   g_object_ref (cmdline);
 *   g_idle_add (my_cmdline_handler, cmdline);
 *
 *   return 0;
 * }
 * ]|
 * In this example the commandline is not completely handled before
 * the #GApplication::command-line handler returns. Instead, we keep
 * a reference to the #GApplicationCommandLine object and handle it
 * later (in this example, in an idle). Note that it is necessary to
 * hold the application until you are done with the commandline.
 *
 * The complete example can be found here:
 * [gapplication-example-cmdline3.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline3.c)
 */


/**
 * SECTION:gasyncinitable
 * @short_description: Asynchronously failable object initialization interface
 * @include: gio/gio.h
 * @see_also: #GInitable
 *
 * This is the asynchronous version of #GInitable; it behaves the same
 * in all ways except that initialization is asynchronous. For more details
 * see the descriptions on #GInitable.
 *
 * A class may implement both the #GInitable and #GAsyncInitable interfaces.
 *
 * Users of objects implementing this are not intended to use the interface
 * method directly; instead it will be used automatically in various ways.
 * For C applications you generally just call g_async_initable_new_async()
 * directly, or indirectly via a foo_thing_new_async() wrapper. This will call
 * g_async_initable_init_async() under the cover, calling back with %NULL and
 * a set %GError on failure.
 *
 * A typical implementation might look something like this:
 *
 * |[<!-- language="C" -->
 * enum {
 *    NOT_INITIALIZED,
 *    INITIALIZING,
 *    INITIALIZED
 * };
 *
 * static void
 * _foo_ready_cb (Foo *self)
 * {
 *   GList *l;
 *
 *   self->priv->state = INITIALIZED;
 *
 *   for (l = self->priv->init_results; l != NULL; l = l->next)
 *     {
 *       GTask *task = l->data;
 *
 *       if (self->priv->success)
 *         g_task_return_boolean (task, TRUE);
 *       else
 *         g_task_return_new_error (task, ...);
 *       g_object_unref (task);
 *     }
 *
 *   g_list_free (self->priv->init_results);
 *   self->priv->init_results = NULL;
 * }
 *
 * static void
 * foo_init_async (GAsyncInitable       *initable,
 *                 int                   io_priority,
 *                 GCancellable         *cancellable,
 *                 GAsyncReadyCallback   callback,
 *                 gpointer              user_data)
 * {
 *   Foo *self = FOO (initable);
 *   GTask *task;
 *
 *   task = g_task_new (initable, cancellable, callback, user_data);
 *   g_task_set_name (task, G_STRFUNC);
 *
 *   switch (self->priv->state)
 *     {
 *       case NOT_INITIALIZED:
 *         _foo_get_ready (self);
 *         self->priv->init_results = g_list_append (self->priv->init_results,
 *                                                   task);
 *         self->priv->state = INITIALIZING;
 *         break;
 *       case INITIALIZING:
 *         self->priv->init_results = g_list_append (self->priv->init_results,
 *                                                   task);
 *         break;
 *       case INITIALIZED:
 *         if (!self->priv->success)
 *           g_task_return_new_error (task, ...);
 *         else
 *           g_task_return_boolean (task, TRUE);
 *         g_object_unref (task);
 *         break;
 *     }
 * }
 *
 * static gboolean
 * foo_init_finish (GAsyncInitable       *initable,
 *                  GAsyncResult         *result,
 *                  GError              **error)
 * {
 *   g_return_val_if_fail (g_task_is_valid (result, initable), FALSE);
 *
 *   return g_task_propagate_boolean (G_TASK (result), error);
 * }
 *
 * static void
 * foo_async_initable_iface_init (gpointer g_iface,
 *                                gpointer data)
 * {
 *   GAsyncInitableIface *iface = g_iface;
 *
 *   iface->init_async = foo_init_async;
 *   iface->init_finish = foo_init_finish;
 * }
 * ]|
 */


/**
 * SECTION:gasyncresult
 * @short_description: Asynchronous Function Results
 * @include: gio/gio.h
 * @see_also: #GTask
 *
 * Provides a base class for implementing asynchronous function results.
 *
 * Asynchronous operations are broken up into two separate operations
 * which are chained together by a #GAsyncReadyCallback. To begin
 * an asynchronous operation, provide a #GAsyncReadyCallback to the
 * asynchronous function. This callback will be triggered when the
 * operation has completed, and must be run in a later iteration of
 * the [thread-default main context][g-main-context-push-thread-default]
 * from where the operation was initiated. It will be passed a
 * #GAsyncResult instance filled with the details of the operation's
 * success or failure, the object the asynchronous function was
 * started for and any error codes returned. The asynchronous callback
 * function is then expected to call the corresponding "_finish()"
 * function, passing the object the function was called for, the
 * #GAsyncResult instance, and (optionally) an @error to grab any
 * error conditions that may have occurred.
 *
 * The "_finish()" function for an operation takes the generic result
 * (of type #GAsyncResult) and returns the specific result that the
 * operation in question yields (e.g. a #GFileEnumerator for a
 * "enumerate children" operation). If the result or error status of the
 * operation is not needed, there is no need to call the "_finish()"
 * function; GIO will take care of cleaning up the result and error
 * information after the #GAsyncReadyCallback returns. You can pass
 * %NULL for the #GAsyncReadyCallback if you don't need to take any
 * action at all after the operation completes. Applications may also
 * take a reference to the #GAsyncResult and call "_finish()" later;
 * however, the "_finish()" function may be called at most once.
 *
 * Example of a typical asynchronous operation flow:
 * |[<!-- language="C" -->
 * void _theoretical_frobnitz_async (Theoretical         *t,
 *                                   GCancellable        *c,
 *                                   GAsyncReadyCallback  cb,
 *                                   gpointer             u);
 *
 * gboolean _theoretical_frobnitz_finish (Theoretical   *t,
 *                                        GAsyncResult  *res,
 *                                        GError       **e);
 *
 * static void
 * frobnitz_result_func (GObject      *source_object,
 * 		 GAsyncResult *res,
 * 		 gpointer      user_data)
 * {
 *   gboolean success = FALSE;
 *
 *   success = _theoretical_frobnitz_finish (source_object, res, NULL);
 *
 *   if (success)
 *     g_printf ("Hurray!\n");
 *   else
 *     g_printf ("Uh oh!\n");
 *
 *   ...
 *
 * }
 *
 * int main (int argc, void *argv[])
 * {
 *    ...
 *
 *    _theoretical_frobnitz_async (theoretical_data,
 *                                 NULL,
 *                                 frobnitz_result_func,
 *                                 NULL);
 *
 *    ...
 * }
 * ]|
 *
 * The callback for an asynchronous operation is called only once, and is
 * always called, even in the case of a cancelled operation. On cancellation
 * the result is a %G_IO_ERROR_CANCELLED error.
 *
 * ## I/O Priority # {#io-priority}
 *
 * Many I/O-related asynchronous operations have a priority parameter,
 * which is used in certain cases to determine the order in which
 * operations are executed. They are not used to determine system-wide
 * I/O scheduling. Priorities are integers, with lower numbers indicating
 * higher priority. It is recommended to choose priorities between
 * %G_PRIORITY_LOW and %G_PRIORITY_HIGH, with %G_PRIORITY_DEFAULT
 * as a default.
 */


/**
 * SECTION:gbufferedinputstream
 * @short_description: Buffered Input Stream
 * @include: gio/gio.h
 * @see_also: #GFilterInputStream, #GInputStream
 *
 * Buffered input stream implements #GFilterInputStream and provides
 * for buffered reads.
 *
 * By default, #GBufferedInputStream's buffer size is set at 4 kilobytes.
 *
 * To create a buffered input stream, use g_buffered_input_stream_new(),
 * or g_buffered_input_stream_new_sized() to specify the buffer's size at
 * construction.
 *
 * To get the size of a buffer within a buffered input stream, use
 * g_buffered_input_stream_get_buffer_size(). To change the size of a
 * buffered input stream's buffer, use
 * g_buffered_input_stream_set_buffer_size(). Note that the buffer's size
 * cannot be reduced below the size of the data within the buffer.
 */


/**
 * SECTION:gbufferedoutputstream
 * @short_description: Buffered Output Stream
 * @include: gio/gio.h
 * @see_also: #GFilterOutputStream, #GOutputStream
 *
 * Buffered output stream implements #GFilterOutputStream and provides
 * for buffered writes.
 *
 * By default, #GBufferedOutputStream's buffer size is set at 4 kilobytes.
 *
 * To create a buffered output stream, use g_buffered_output_stream_new(),
 * or g_buffered_output_stream_new_sized() to specify the buffer's size
 * at construction.
 *
 * To get the size of a buffer within a buffered input stream, use
 * g_buffered_output_stream_get_buffer_size(). To change the size of a
 * buffered output stream's buffer, use
 * g_buffered_output_stream_set_buffer_size(). Note that the buffer's
 * size cannot be reduced below the size of the data within the buffer.
 */


/**
 * SECTION:gbytesicon
 * @short_description: An icon stored in memory as a GBytes
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon, #GBytes
 *
 * #GBytesIcon specifies an image held in memory in a common format (usually
 * png) to be used as icon.
 *
 * Since: 2.38
 */


/**
 * SECTION:gcancellable
 * @short_description: Thread-safe Operation Cancellation Stack
 * @include: gio/gio.h
 *
 * GCancellable is a thread-safe operation cancellation stack used
 * throughout GIO to allow for cancellation of synchronous and
 * asynchronous operations.
 */


/**
 * SECTION:gcharsetconverter
 * @short_description: Convert between charsets
 * @include: gio/gio.h
 *
 * #GCharsetConverter is an implementation of #GConverter based on
 * GIConv.
 */


/**
 * SECTION:gcontenttype
 * @short_description: Platform-specific content typing
 * @include: gio/gio.h
 *
 * A content type is a platform specific string that defines the type
 * of a file. On UNIX it is a
 * [MIME type](http://www.wikipedia.org/wiki/Internet_media_type)
 * like `text/plain` or `image/png`.
 * On Win32 it is an extension string like `.doc`, `.txt` or a perceived
 * string like `audio`. Such strings can be looked up in the registry at
 * `HKEY_CLASSES_ROOT`.
 * On macOS it is a [Uniform Type Identifier](https://en.wikipedia.org/wiki/Uniform_Type_Identifier)
 * such as `com.apple.application`.
 */


/**
 * SECTION:gconverter
 * @short_description: Data conversion interface
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * #GConverter is implemented by objects that convert
 * binary data in various ways. The conversion can be
 * stateful and may fail at any place.
 *
 * Some example conversions are: character set conversion,
 * compression, decompression and regular expression
 * replace.
 *
 * Since: 2.24
 */


/**
 * SECTION:gconverterinputstream
 * @short_description: Converter Input Stream
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GConverter
 *
 * Converter input stream implements #GInputStream and allows
 * conversion of data of various types during reading.
 *
 * As of GLib 2.34, #GConverterInputStream implements
 * #GPollableInputStream.
 */


/**
 * SECTION:gconverteroutputstream
 * @short_description: Converter Output Stream
 * @include: gio/gio.h
 * @see_also: #GOutputStream, #GConverter
 *
 * Converter output stream implements #GOutputStream and allows
 * conversion of data of various types during reading.
 *
 * As of GLib 2.34, #GConverterOutputStream implements
 * #GPollableOutputStream.
 */


/**
 * SECTION:gcredentials
 * @short_description: An object containing credentials
 * @include: gio/gio.h
 *
 * The #GCredentials type is a reference-counted wrapper for native
 * credentials. This information is typically used for identifying,
 * authenticating and authorizing other processes.
 *
 * Some operating systems supports looking up the credentials of the
 * remote peer of a communication endpoint - see e.g.
 * g_socket_get_credentials().
 *
 * Some operating systems supports securely sending and receiving
 * credentials over a Unix Domain Socket, see
 * #GUnixCredentialsMessage, g_unix_connection_send_credentials() and
 * g_unix_connection_receive_credentials() for details.
 *
 * On Linux, the native credential type is a `struct ucred` - see the
 * unix(7) man page for details. This corresponds to
 * %G_CREDENTIALS_TYPE_LINUX_UCRED.
 *
 * On Apple operating systems (including iOS, tvOS, and macOS),
 * the native credential type is a `struct xucred`.
 * This corresponds to %G_CREDENTIALS_TYPE_APPLE_XUCRED.
 *
 * On FreeBSD, Debian GNU/kFreeBSD, and GNU/Hurd, the native
 * credential type is a `struct cmsgcred`. This corresponds
 * to %G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED.
 *
 * On NetBSD, the native credential type is a `struct unpcbid`.
 * This corresponds to %G_CREDENTIALS_TYPE_NETBSD_UNPCBID.
 *
 * On OpenBSD, the native credential type is a `struct sockpeercred`.
 * This corresponds to %G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED.
 *
 * On Solaris (including OpenSolaris and its derivatives), the native
 * credential type is a `ucred_t`. This corresponds to
 * %G_CREDENTIALS_TYPE_SOLARIS_UCRED.
 *
 * Since GLib 2.72, on Windows, the native credentials may contain the PID of a
 * process. This corresponds to %G_CREDENTIALS_TYPE_WIN32_PID.
 */


/**
 * SECTION:gdatagrambased
 * @short_description: Low-level datagram communications interface
 * @include: gio/gio.h
 * @see_also: #GSocket, [<gnetworking.h>][gio-gnetworking.h]
 *
 * A #GDatagramBased is a networking interface for representing datagram-based
 * communications. It is a more or less direct mapping of the core parts of the
 * BSD socket API in a portable GObject interface. It is implemented by
 * #GSocket, which wraps the UNIX socket API on UNIX and winsock2 on Windows.
 *
 * #GDatagramBased is entirely platform independent, and is intended to be used
 * alongside higher-level networking APIs such as #GIOStream.
 *
 * It uses vectored scatter/gather I/O by default, allowing for many messages
 * to be sent or received in a single call. Where possible, implementations of
 * the interface should take advantage of vectored I/O to minimise processing
 * or system calls. For example, #GSocket uses recvmmsg() and sendmmsg() where
 * possible. Callers should take advantage of scatter/gather I/O (the use of
 * multiple buffers per message) to avoid unnecessary copying of data to
 * assemble or disassemble a message.
 *
 * Each #GDatagramBased operation has a timeout parameter which may be negative
 * for blocking behaviour, zero for non-blocking behaviour, or positive for
 * timeout behaviour. A blocking operation blocks until finished or there is an
 * error. A non-blocking operation will return immediately with a
 * %G_IO_ERROR_WOULD_BLOCK error if it cannot make progress. A timeout operation
 * will block until the operation is complete or the timeout expires; if the
 * timeout expires it will return what progress it made, or
 * %G_IO_ERROR_TIMED_OUT if no progress was made. To know when a call would
 * successfully run you can call g_datagram_based_condition_check() or
 * g_datagram_based_condition_wait(). You can also use
 * g_datagram_based_create_source() and attach it to a #GMainContext to get
 * callbacks when I/O is possible.
 *
 * When running a non-blocking operation applications should always be able to
 * handle getting a %G_IO_ERROR_WOULD_BLOCK error even when some other function
 * said that I/O was possible. This can easily happen in case of a race
 * condition in the application, but it can also happen for other reasons. For
 * instance, on Windows a socket is always seen as writable until a write
 * returns %G_IO_ERROR_WOULD_BLOCK.
 *
 * As with #GSocket, #GDatagramBaseds can be either connection oriented (for
 * example, SCTP) or connectionless (for example, UDP). #GDatagramBaseds must be
 * datagram-based, not stream-based. The interface does not cover connection
 * establishment — use methods on the underlying type to establish a connection
 * before sending and receiving data through the #GDatagramBased API. For
 * connectionless socket types the target/source address is specified or
 * received in each I/O operation.
 *
 * Like most other APIs in GLib, #GDatagramBased is not inherently thread safe.
 * To use a #GDatagramBased concurrently from multiple threads, you must
 * implement your own locking.
 *
 * Since: 2.48
 */


/**
 * SECTION:gdatainputstream
 * @short_description: Data Input Stream
 * @include: gio/gio.h
 * @see_also: #GInputStream
 *
 * Data input stream implements #GInputStream and includes functions for
 * reading structured data directly from a binary input stream.
 */


/**
 * SECTION:gdataoutputstream
 * @short_description: Data Output Stream
 * @include: gio/gio.h
 * @see_also: #GOutputStream
 *
 * Data output stream implements #GOutputStream and includes functions for
 * writing data directly to an output stream.
 */


/**
 * SECTION:gdbusactiongroup
 * @title: GDBusActionGroup
 * @short_description: A D-Bus GActionGroup implementation
 * @include: gio/gio.h
 * @see_also: [GActionGroup exporter][gio-GActionGroup-exporter]
 *
 * #GDBusActionGroup is an implementation of the #GActionGroup
 * interface that can be used as a proxy for an action group
 * that is exported over D-Bus with g_dbus_connection_export_action_group().
 */


/**
 * SECTION:gdbusaddress
 * @title: D-Bus Addresses
 * @short_description: D-Bus connection endpoints
 * @include: gio/gio.h
 *
 * Routines for working with D-Bus addresses. A D-Bus address is a string
 * like `unix:tmpdir=/tmp/my-app-name`. The exact format of addresses
 * is explained in detail in the
 * [D-Bus specification](http://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * TCP D-Bus connections are supported, but accessing them via a proxy is
 * currently not supported.
 *
 * Since GLib 2.72, `unix:` addresses are supported on Windows with `AF_UNIX`
 * support (Windows 10).
 */


/**
 * SECTION:gdbusauthobserver
 * @short_description: Object used for authenticating connections
 * @include: gio/gio.h
 *
 * The #GDBusAuthObserver type provides a mechanism for participating
 * in how a #GDBusServer (or a #GDBusConnection) authenticates remote
 * peers. Simply instantiate a #GDBusAuthObserver and connect to the
 * signals you are interested in. Note that new signals may be added
 * in the future
 *
 * ## Controlling Authentication Mechanisms
 *
 * By default, a #GDBusServer or server-side #GDBusConnection will allow
 * any authentication mechanism to be used. If you only
 * want to allow D-Bus connections with the `EXTERNAL` mechanism,
 * which makes use of credentials passing and is the recommended
 * mechanism for modern Unix platforms such as Linux and the BSD family,
 * you would use a signal handler like this:
 *
 * |[<!-- language="C" -->
 * static gboolean
 * on_allow_mechanism (GDBusAuthObserver *observer,
 *                     const gchar       *mechanism,
 *                     gpointer           user_data)
 * {
 *   if (g_strcmp0 (mechanism, "EXTERNAL") == 0)
 *     {
 *       return TRUE;
 *     }
 *
 *   return FALSE;
 * }
 * ]|
 *
 * ## Controlling Authorization # {#auth-observer}
 *
 * By default, a #GDBusServer or server-side #GDBusConnection will accept
 * connections from any successfully authenticated user (but not from
 * anonymous connections using the `ANONYMOUS` mechanism). If you only
 * want to allow D-Bus connections from processes owned by the same uid
 * as the server, since GLib 2.68, you should use the
 * %G_DBUS_SERVER_FLAGS_AUTHENTICATION_REQUIRE_SAME_USER flag. It’s equivalent
 * to the following signal handler:
 *
 * |[<!-- language="C" -->
 * static gboolean
 * on_authorize_authenticated_peer (GDBusAuthObserver *observer,
 *                                  GIOStream         *stream,
 *                                  GCredentials      *credentials,
 *                                  gpointer           user_data)
 * {
 *   gboolean authorized;
 *
 *   authorized = FALSE;
 *   if (credentials != NULL)
 *     {
 *       GCredentials *own_credentials;
 *       own_credentials = g_credentials_new ();
 *       if (g_credentials_is_same_user (credentials, own_credentials, NULL))
 *         authorized = TRUE;
 *       g_object_unref (own_credentials);
 *     }
 *
 *   return authorized;
 * }
 * ]|
 */


/**
 * SECTION:gdbusconnection
 * @short_description: D-Bus Connections
 * @include: gio/gio.h
 *
 * The #GDBusConnection type is used for D-Bus connections to remote
 * peers such as a message buses. It is a low-level API that offers a
 * lot of flexibility. For instance, it lets you establish a connection
 * over any transport that can by represented as a #GIOStream.
 *
 * This class is rarely used directly in D-Bus clients. If you are writing
 * a D-Bus client, it is often easier to use the g_bus_own_name(),
 * g_bus_watch_name() or g_dbus_proxy_new_for_bus() APIs.
 *
 * As an exception to the usual GLib rule that a particular object must not
 * be used by two threads at the same time, #GDBusConnection's methods may be
 * called from any thread. This is so that g_bus_get() and g_bus_get_sync()
 * can safely return the same #GDBusConnection when called from any thread.
 *
 * Most of the ways to obtain a #GDBusConnection automatically initialize it
 * (i.e. connect to D-Bus): for instance, g_dbus_connection_new() and
 * g_bus_get(), and the synchronous versions of those methods, give you an
 * initialized connection. Language bindings for GIO should use
 * g_initable_new() or g_async_initable_new_async(), which also initialize the
 * connection.
 *
 * If you construct an uninitialized #GDBusConnection, such as via
 * g_object_new(), you must initialize it via g_initable_init() or
 * g_async_initable_init_async() before using its methods or properties.
 * Calling methods or accessing properties on a #GDBusConnection that has not
 * completed initialization successfully is considered to be invalid, and leads
 * to undefined behaviour. In particular, if initialization fails with a
 * #GError, the only valid thing you can do with that #GDBusConnection is to
 * free it with g_object_unref().
 *
 * ## An example D-Bus server # {#gdbus-server}
 *
 * Here is an example for a D-Bus server:
 * [gdbus-example-server.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-server.c)
 *
 * ## An example for exporting a subtree # {#gdbus-subtree-server}
 *
 * Here is an example for exporting a subtree:
 * [gdbus-example-subtree.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-subtree.c)
 *
 * ## An example for file descriptor passing # {#gdbus-unix-fd-client}
 *
 * Here is an example for passing UNIX file descriptors:
 * [gdbus-unix-fd-client.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-unix-fd-client.c)
 *
 * ## An example for exporting a GObject # {#gdbus-export}
 *
 * Here is an example for exporting a #GObject:
 * [gdbus-example-export.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-export.c)
 */


/**
 * SECTION:gdbuserror
 * @title: GDBusError
 * @short_description: Mapping D-Bus errors to and from GError
 * @include: gio/gio.h
 *
 * All facilities that return errors from remote methods (such as
 * g_dbus_connection_call_sync()) use #GError to represent both D-Bus
 * errors (e.g. errors returned from the other peer) and locally
 * in-process generated errors.
 *
 * To check if a returned #GError is an error from a remote peer, use
 * g_dbus_error_is_remote_error(). To get the actual D-Bus error name,
 * use g_dbus_error_get_remote_error(). Before presenting an error,
 * always use g_dbus_error_strip_remote_error().
 *
 * In addition, facilities used to return errors to a remote peer also
 * use #GError. See g_dbus_method_invocation_return_error() for
 * discussion about how the D-Bus error name is set.
 *
 * Applications can associate a #GError error domain with a set of D-Bus errors in order to
 * automatically map from D-Bus errors to #GError and back. This
 * is typically done in the function returning the #GQuark for the
 * error domain:
 * |[<!-- language="C" -->
 * // foo-bar-error.h:
 *
 * #define FOO_BAR_ERROR (foo_bar_error_quark ())
 * GQuark foo_bar_error_quark (void);
 *
 * typedef enum
 * {
 *   FOO_BAR_ERROR_FAILED,
 *   FOO_BAR_ERROR_ANOTHER_ERROR,
 *   FOO_BAR_ERROR_SOME_THIRD_ERROR,
 *   FOO_BAR_N_ERRORS / *< skip >* /
 * } FooBarError;
 *
 * // foo-bar-error.c:
 *
 * static const GDBusErrorEntry foo_bar_error_entries[] =
 * {
 *   {FOO_BAR_ERROR_FAILED,           "org.project.Foo.Bar.Error.Failed"},
 *   {FOO_BAR_ERROR_ANOTHER_ERROR,    "org.project.Foo.Bar.Error.AnotherError"},
 *   {FOO_BAR_ERROR_SOME_THIRD_ERROR, "org.project.Foo.Bar.Error.SomeThirdError"},
 * };
 *
 * // Ensure that every error code has an associated D-Bus error name
 * G_STATIC_ASSERT (G_N_ELEMENTS (foo_bar_error_entries) == FOO_BAR_N_ERRORS);
 *
 * GQuark
 * foo_bar_error_quark (void)
 * {
 *   static gsize quark = 0;
 *   g_dbus_error_register_error_domain ("foo-bar-error-quark",
 *                                       &quark,
 *                                       foo_bar_error_entries,
 *                                       G_N_ELEMENTS (foo_bar_error_entries));
 *   return (GQuark) quark;
 * }
 * ]|
 * With this setup, a D-Bus peer can transparently pass e.g. %FOO_BAR_ERROR_ANOTHER_ERROR and
 * other peers will see the D-Bus error name org.project.Foo.Bar.Error.AnotherError.
 *
 * If the other peer is using GDBus, and has registered the association with
 * g_dbus_error_register_error_domain() in advance (e.g. by invoking the %FOO_BAR_ERROR quark
 * generation itself in the previous example) the peer will see also %FOO_BAR_ERROR_ANOTHER_ERROR instead
 * of %G_IO_ERROR_DBUS_ERROR. Note that GDBus clients can still recover
 * org.project.Foo.Bar.Error.AnotherError using g_dbus_error_get_remote_error().
 *
 * Note that the %G_DBUS_ERROR error domain is intended only
 * for returning errors from a remote message bus process. Errors
 * generated locally in-process by e.g. #GDBusConnection should use the
 * %G_IO_ERROR domain.
 */


/**
 * SECTION:gdbusinterface
 * @short_description: Base type for D-Bus interfaces
 * @include: gio/gio.h
 *
 * The #GDBusInterface type is the base type for D-Bus interfaces both
 * on the service side (see #GDBusInterfaceSkeleton) and client side
 * (see #GDBusProxy).
 */


/**
 * SECTION:gdbusinterfaceskeleton
 * @short_description: Service-side D-Bus interface
 * @include: gio/gio.h
 *
 * Abstract base class for D-Bus interfaces on the service side.
 */


/**
 * SECTION:gdbusintrospection
 * @title: D-Bus Introspection Data
 * @short_description: Node and interface description data structures
 * @include: gio/gio.h
 *
 * Various data structures and convenience routines to parse and
 * generate D-Bus introspection XML. Introspection information is
 * used when registering objects with g_dbus_connection_register_object().
 *
 * The format of D-Bus introspection XML is specified in the
 * [D-Bus specification](http://dbus.freedesktop.org/doc/dbus-specification.html#introspection-format)
 */


/**
 * SECTION:gdbusmenumodel
 * @title: GDBusMenuModel
 * @short_description: A D-Bus GMenuModel implementation
 * @include: gio/gio.h
 * @see_also: [GMenuModel Exporter][gio-GMenuModel-exporter]
 *
 * #GDBusMenuModel is an implementation of #GMenuModel that can be used
 * as a proxy for a menu model that is exported over D-Bus with
 * g_dbus_connection_export_menu_model().
 */


/**
 * SECTION:gdbusmessage
 * @short_description: D-Bus Message
 * @include: gio/gio.h
 *
 * A type for representing D-Bus messages that can be sent or received
 * on a #GDBusConnection.
 */


/**
 * SECTION:gdbusmethodinvocation
 * @short_description: Object for handling remote calls
 * @include: gio/gio.h
 *
 * Instances of the #GDBusMethodInvocation class are used when
 * handling D-Bus method calls. It provides a way to asynchronously
 * return results and errors.
 *
 * The normal way to obtain a #GDBusMethodInvocation object is to receive
 * it as an argument to the handle_method_call() function in a
 * #GDBusInterfaceVTable that was passed to g_dbus_connection_register_object().
 */


/**
 * SECTION:gdbusnameowning
 * @title: Owning Bus Names
 * @short_description: Simple API for owning bus names
 * @include: gio/gio.h
 *
 * Convenience API for owning bus names.
 *
 * A simple example for owning a name can be found in
 * [gdbus-example-own-name.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-own-name.c)
 */


/**
 * SECTION:gdbusnamewatching
 * @title: Watching Bus Names
 * @short_description: Simple API for watching bus names
 * @include: gio/gio.h
 *
 * Convenience API for watching bus names.
 *
 * A simple example for watching a name can be found in
 * [gdbus-example-watch-name.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-watch-name.c)
 */


/**
 * SECTION:gdbusobject
 * @short_description: Base type for D-Bus objects
 * @include: gio/gio.h
 *
 * The #GDBusObject type is the base type for D-Bus objects on both
 * the service side (see #GDBusObjectSkeleton) and the client side
 * (see #GDBusObjectProxy). It is essentially just a container of
 * interfaces.
 */


/**
 * SECTION:gdbusobjectmanager
 * @short_description: Base type for D-Bus object managers
 * @include: gio/gio.h
 *
 * The #GDBusObjectManager type is the base type for service- and
 * client-side implementations of the standardized
 * [org.freedesktop.DBus.ObjectManager](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager)
 * interface.
 *
 * See #GDBusObjectManagerClient for the client-side implementation
 * and #GDBusObjectManagerServer for the service-side implementation.
 */


/**
 * SECTION:gdbusobjectmanagerclient
 * @short_description: Client-side object manager
 * @include: gio/gio.h
 *
 * #GDBusObjectManagerClient is used to create, monitor and delete object
 * proxies for remote objects exported by a #GDBusObjectManagerServer (or any
 * code implementing the
 * [org.freedesktop.DBus.ObjectManager](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager)
 * interface).
 *
 * Once an instance of this type has been created, you can connect to
 * the #GDBusObjectManager::object-added and
 * #GDBusObjectManager::object-removed signals and inspect the
 * #GDBusObjectProxy objects returned by
 * g_dbus_object_manager_get_objects().
 *
 * If the name for a #GDBusObjectManagerClient is not owned by anyone at
 * object construction time, the default behavior is to request the
 * message bus to launch an owner for the name. This behavior can be
 * disabled using the %G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_DO_NOT_AUTO_START
 * flag. It's also worth noting that this only works if the name of
 * interest is activatable in the first place. E.g. in some cases it
 * is not possible to launch an owner for the requested name. In this
 * case, #GDBusObjectManagerClient object construction still succeeds but
 * there will be no object proxies
 * (e.g. g_dbus_object_manager_get_objects() returns the empty list) and
 * the #GDBusObjectManagerClient:name-owner property is %NULL.
 *
 * The owner of the requested name can come and go (for example
 * consider a system service being restarted) – #GDBusObjectManagerClient
 * handles this case too; simply connect to the #GObject::notify
 * signal to watch for changes on the #GDBusObjectManagerClient:name-owner
 * property. When the name owner vanishes, the behavior is that
 * #GDBusObjectManagerClient:name-owner is set to %NULL (this includes
 * emission of the #GObject::notify signal) and then
 * #GDBusObjectManager::object-removed signals are synthesized
 * for all currently existing object proxies. Since
 * #GDBusObjectManagerClient:name-owner is %NULL when this happens, you can
 * use this information to disambiguate a synthesized signal from a
 * genuine signal caused by object removal on the remote
 * #GDBusObjectManager. Similarly, when a new name owner appears,
 * #GDBusObjectManager::object-added signals are synthesized
 * while #GDBusObjectManagerClient:name-owner is still %NULL. Only when all
 * object proxies have been added, the #GDBusObjectManagerClient:name-owner
 * is set to the new name owner (this includes emission of the
 * #GObject::notify signal).  Furthermore, you are guaranteed that
 * #GDBusObjectManagerClient:name-owner will alternate between a name owner
 * (e.g. `:1.42`) and %NULL even in the case where
 * the name of interest is atomically replaced
 *
 * Ultimately, #GDBusObjectManagerClient is used to obtain #GDBusProxy
 * instances. All signals (including the
 * org.freedesktop.DBus.Properties::PropertiesChanged signal)
 * delivered to #GDBusProxy instances are guaranteed to originate
 * from the name owner. This guarantee along with the behavior
 * described above, means that certain race conditions including the
 * "half the proxy is from the old owner and the other half is from
 * the new owner" problem cannot happen.
 *
 * To avoid having the application connect to signals on the returned
 * #GDBusObjectProxy and #GDBusProxy objects, the
 * #GDBusObject::interface-added,
 * #GDBusObject::interface-removed,
 * #GDBusProxy::g-properties-changed and
 * #GDBusProxy::g-signal signals
 * are also emitted on the #GDBusObjectManagerClient instance managing these
 * objects. The signals emitted are
 * #GDBusObjectManager::interface-added,
 * #GDBusObjectManager::interface-removed,
 * #GDBusObjectManagerClient::interface-proxy-properties-changed and
 * #GDBusObjectManagerClient::interface-proxy-signal.
 *
 * Note that all callbacks and signals are emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * that the #GDBusObjectManagerClient object was constructed
 * in. Additionally, the #GDBusObjectProxy and #GDBusProxy objects
 * originating from the #GDBusObjectManagerClient object will be created in
 * the same context and, consequently, will deliver signals in the
 * same main loop.
 */


/**
 * SECTION:gdbusobjectmanagerserver
 * @short_description: Service-side object manager
 * @include: gio/gio.h
 *
 * #GDBusObjectManagerServer is used to export #GDBusObject instances using
 * the standardized
 * [org.freedesktop.DBus.ObjectManager](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager)
 * interface. For example, remote D-Bus clients can get all objects
 * and properties in a single call. Additionally, any change in the
 * object hierarchy is broadcast using signals. This means that D-Bus
 * clients can keep caches up to date by only listening to D-Bus
 * signals.
 *
 * The recommended path to export an object manager at is the path form of the
 * well-known name of a D-Bus service, or below. For example, if a D-Bus service
 * is available at the well-known name `net.example.ExampleService1`, the object
 * manager should typically be exported at `/net/example/ExampleService1`, or
 * below (to allow for multiple object managers in a service).
 *
 * It is supported, but not recommended, to export an object manager at the root
 * path, `/`.
 *
 * See #GDBusObjectManagerClient for the client-side code that is
 * intended to be used with #GDBusObjectManagerServer or any D-Bus
 * object implementing the org.freedesktop.DBus.ObjectManager
 * interface.
 */


/**
 * SECTION:gdbusobjectproxy
 * @short_description: Client-side D-Bus object
 * @include: gio/gio.h
 *
 * A #GDBusObjectProxy is an object used to represent a remote object
 * with one or more D-Bus interfaces. Normally, you don't instantiate
 * a #GDBusObjectProxy yourself - typically #GDBusObjectManagerClient
 * is used to obtain it.
 *
 * Since: 2.30
 */


/**
 * SECTION:gdbusobjectskeleton
 * @short_description: Service-side D-Bus object
 * @include: gio/gio.h
 *
 * A #GDBusObjectSkeleton instance is essentially a group of D-Bus
 * interfaces. The set of exported interfaces on the object may be
 * dynamic and change at runtime.
 *
 * This type is intended to be used with #GDBusObjectManager.
 */


/**
 * SECTION:gdbusproxy
 * @short_description: Client-side D-Bus interface proxy
 * @include: gio/gio.h
 *
 * #GDBusProxy is a base class used for proxies to access a D-Bus
 * interface on a remote object. A #GDBusProxy can be constructed for
 * both well-known and unique names.
 *
 * By default, #GDBusProxy will cache all properties (and listen to
 * changes) of the remote object, and proxy all signals that get
 * emitted. This behaviour can be changed by passing suitable
 * #GDBusProxyFlags when the proxy is created. If the proxy is for a
 * well-known name, the property cache is flushed when the name owner
 * vanishes and reloaded when a name owner appears.
 *
 * The unique name owner of the proxy's name is tracked and can be read from
 * #GDBusProxy:g-name-owner. Connect to the #GObject::notify signal to
 * get notified of changes. Additionally, only signals and property
 * changes emitted from the current name owner are considered and
 * calls are always sent to the current name owner. This avoids a
 * number of race conditions when the name is lost by one owner and
 * claimed by another. However, if no name owner currently exists,
 * then calls will be sent to the well-known name which may result in
 * the message bus launching an owner (unless
 * %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START is set).
 *
 * If the proxy is for a stateless D-Bus service, where the name owner may
 * be started and stopped between calls, the #GDBusProxy:g-name-owner tracking
 * of #GDBusProxy will cause the proxy to drop signal and property changes from
 * the service after it has restarted for the first time. When interacting
 * with a stateless D-Bus service, do not use #GDBusProxy — use direct D-Bus
 * method calls and signal connections.
 *
 * The generic #GDBusProxy::g-properties-changed and
 * #GDBusProxy::g-signal signals are not very convenient to work with.
 * Therefore, the recommended way of working with proxies is to subclass
 * #GDBusProxy, and have more natural properties and signals in your derived
 * class. This [example][gdbus-example-gdbus-codegen] shows how this can
 * easily be done using the [gdbus-codegen][gdbus-codegen] tool.
 *
 * A #GDBusProxy instance can be used from multiple threads but note
 * that all signals (e.g. #GDBusProxy::g-signal, #GDBusProxy::g-properties-changed
 * and #GObject::notify) are emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread where the instance was constructed.
 *
 * An example using a proxy for a well-known name can be found in
 * [gdbus-example-watch-proxy.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-watch-proxy.c)
 */


/**
 * SECTION:gdbusserver
 * @short_description: Helper for accepting connections
 * @include: gio/gio.h
 *
 * #GDBusServer is a helper for listening to and accepting D-Bus
 * connections. This can be used to create a new D-Bus server, allowing two
 * peers to use the D-Bus protocol for their own specialized communication.
 * A server instance provided in this way will not perform message routing or
 * implement the org.freedesktop.DBus interface.
 *
 * To just export an object on a well-known name on a message bus, such as the
 * session or system bus, you should instead use g_bus_own_name().
 *
 * An example of peer-to-peer communication with GDBus can be found
 * in [gdbus-example-peer.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-example-peer.c).
 *
 * Note that a minimal #GDBusServer will accept connections from any
 * peer. In many use-cases it will be necessary to add a #GDBusAuthObserver
 * that only accepts connections that have successfully authenticated
 * as the same user that is running the #GDBusServer. Since GLib 2.68 this can
 * be achieved more simply by passing the
 * %G_DBUS_SERVER_FLAGS_AUTHENTICATION_REQUIRE_SAME_USER flag to the server.
 */


/**
 * SECTION:gdbusutils
 * @title: D-Bus Utilities
 * @short_description: Various utilities related to D-Bus
 * @include: gio/gio.h
 *
 * Various utility routines related to D-Bus.
 */


/**
 * SECTION:gdebugcontroller
 * @title: GDebugController
 * @short_description: Debugging controller
 * @include: gio/gio.h
 *
 * #GDebugController is an interface to expose control of debugging features and
 * debug output.
 *
 * It is implemented on Linux using #GDebugControllerDBus, which exposes a D-Bus
 * interface to allow authenticated peers to control debug features in this
 * process.
 *
 * Whether debug output is enabled is exposed as
 * #GDebugController:debug-enabled. This controls g_log_set_debug_enabled() by
 * default. Application code may connect to the #GObject::notify signal for it
 * to control other parts of its debug infrastructure as necessary.
 *
 * If your application or service is using the default GLib log writer function,
 * creating one of the built-in implementations of #GDebugController should be
 * all that’s needed to dynamically enable or disable debug output.
 *
 * Since: 2.72
 */


/**
 * SECTION:gdebugcontrollerdbus
 * @title: GDebugControllerDBus
 * @short_description: Debugging controller D-Bus implementation
 * @include: gio/gio.h
 *
 * #GDebugControllerDBus is an implementation of #GDebugController which exposes
 * debug settings as a D-Bus object.
 *
 * It is a #GInitable object, and will register an object at
 * `/org/gtk/Debugging` on the bus given as
 * #GDebugControllerDBus:connection once it’s initialized. The object will be
 * unregistered when the last reference to the #GDebugControllerDBus is dropped.
 *
 * This D-Bus object can be used by remote processes to enable or disable debug
 * output in this process. Remote processes calling
 * `org.gtk.Debugging.SetDebugEnabled()` will affect the value of
 * #GDebugController:debug-enabled and, by default, g_log_get_debug_enabled().
 * default.
 *
 * By default, no processes are allowed to call `SetDebugEnabled()` unless a
 * #GDebugControllerDBus::authorize signal handler is installed. This is because
 * the process may be privileged, or might expose sensitive information in its
 * debug output. You may want to restrict the ability to enable debug output to
 * privileged users or processes.
 *
 * One option is to install a D-Bus security policy which restricts access to
 * `SetDebugEnabled()`, installing something like the following in
 * `$datadir/dbus-1/system.d/`:
 * |[<!-- language="XML" -->
 * <?xml version="1.0"?> <!--*-nxml-*-->
 * <!DOCTYPE busconfig PUBLIC "-//freedesktop//DTD D-BUS Bus Configuration 1.0//EN"
 *      "http://www.freedesktop.org/standards/dbus/1.0/busconfig.dtd">
 * <busconfig>
 *   <policy user="root">
 *     <allow send_destination="com.example.MyService" send_interface="org.gtk.Debugging"/>
 *   </policy>
 *   <policy context="default">
 *     <deny send_destination="com.example.MyService" send_interface="org.gtk.Debugging"/>
 *   </policy>
 * </busconfig>
 * ]|
 *
 * This will prevent the `SetDebugEnabled()` method from being called by all
 * except root. It will not prevent the `DebugEnabled` property from being read,
 * as it’s accessed through the `org.freedesktop.DBus.Properties` interface.
 *
 * Another option is to use polkit to allow or deny requests on a case-by-case
 * basis, allowing for the possibility of dynamic authorisation. To do this,
 * connect to the #GDebugControllerDBus::authorize signal and query polkit in
 * it:
 * |[<!-- language="C" -->
 *   g_autoptr(GError) child_error = NULL;
 *   g_autoptr(GDBusConnection) connection = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, NULL);
 *   gulong debug_controller_authorize_id = 0;
 *
 *   // Set up the debug controller.
 *   debug_controller = G_DEBUG_CONTROLLER (g_debug_controller_dbus_new (priv->connection, NULL, &child_error));
 *   if (debug_controller == NULL)
 *     {
 *       g_error ("Could not register debug controller on bus: %s"),
 *                child_error->message);
 *     }
 *
 *   debug_controller_authorize_id = g_signal_connect (debug_controller,
 *                                                     "authorize",
 *                                                     G_CALLBACK (debug_controller_authorize_cb),
 *                                                     self);
 *
 *   static gboolean
 *   debug_controller_authorize_cb (GDebugControllerDBus  *debug_controller,
 *                                  GDBusMethodInvocation *invocation,
 *                                  gpointer               user_data)
 *   {
 *     g_autoptr(PolkitAuthority) authority = NULL;
 *     g_autoptr(PolkitSubject) subject = NULL;
 *     g_autoptr(PolkitAuthorizationResult) auth_result = NULL;
 *     g_autoptr(GError) local_error = NULL;
 *     GDBusMessage *message;
 *     GDBusMessageFlags message_flags;
 *     PolkitCheckAuthorizationFlags flags = POLKIT_CHECK_AUTHORIZATION_FLAGS_NONE;
 *
 *     message = g_dbus_method_invocation_get_message (invocation);
 *     message_flags = g_dbus_message_get_flags (message);
 *
 *     authority = polkit_authority_get_sync (NULL, &local_error);
 *     if (authority == NULL)
 *       {
 *         g_warning ("Failed to get polkit authority: %s", local_error->message);
 *         return FALSE;
 *       }
 *
 *     if (message_flags & G_DBUS_MESSAGE_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION)
 *       flags |= POLKIT_CHECK_AUTHORIZATION_FLAGS_ALLOW_USER_INTERACTION;
 *
 *     subject = polkit_system_bus_name_new (g_dbus_method_invocation_get_sender (invocation));
 *
 *     auth_result = polkit_authority_check_authorization_sync (authority,
 *                                                              subject,
 *                                                              "com.example.MyService.set-debug-enabled",
 *                                                              NULL,
 *                                                              flags,
 *                                                              NULL,
 *                                                              &local_error);
 *     if (auth_result == NULL)
 *       {
 *         g_warning ("Failed to get check polkit authorization: %s", local_error->message);
 *         return FALSE;
 *       }
 *
 *     return polkit_authorization_result_get_is_authorized (auth_result);
 *   }
 * ]|
 *
 * Since: 2.72
 */


/**
 * SECTION:gdesktopappinfo
 * @title: GDesktopAppInfo
 * @short_description: Application information from desktop files
 * @include: gio/gdesktopappinfo.h
 *
 * #GDesktopAppInfo is an implementation of #GAppInfo based on
 * desktop files.
 *
 * Note that `<gio/gdesktopappinfo.h>` belongs to the UNIX-specific
 * GIO interfaces, thus you have to use the `gio-unix-2.0.pc` pkg-config
 * file when using it.
 */


/**
 * SECTION:gdrive
 * @short_description: Drive management
 * @include: gio/gio.h
 *
 * #GDrive - this represent a piece of hardware connected to the machine.
 * It's generally only created for removable hardware or hardware with
 * removable media.
 *
 * #GDrive is a container class for #GVolume objects that stem from
 * the same piece of media. As such, #GDrive abstracts a drive with
 * (or without) removable media and provides operations for querying
 * whether media is available, determining whether media change is
 * automatically detected and ejecting the media.
 *
 * If the #GDrive reports that media isn't automatically detected, one
 * can poll for media; typically one should not do this periodically
 * as a poll for media operation is potentially expensive and may
 * spin up the drive creating noise.
 *
 * #GDrive supports starting and stopping drives with authentication
 * support for the former. This can be used to support a diverse set
 * of use cases including connecting/disconnecting iSCSI devices,
 * powering down external disk enclosures and starting/stopping
 * multi-disk devices such as RAID devices. Note that the actual
 * semantics and side-effects of starting/stopping a #GDrive may vary
 * according to implementation. To choose the correct verbs in e.g. a
 * file manager, use g_drive_get_start_stop_type().
 *
 * For porting from GnomeVFS note that there is no equivalent of
 * #GDrive in that API.
 */


/**
 * SECTION:gdtlsclientconnection
 * @short_description: DTLS client-side connection
 * @include: gio/gio.h
 *
 * #GDtlsClientConnection is the client-side subclass of
 * #GDtlsConnection, representing a client-side DTLS connection.
 *
 * Since: 2.48
 */


/**
 * SECTION:gdtlsconnection
 * @short_description: DTLS connection type
 * @include: gio/gio.h
 *
 * #GDtlsConnection is the base DTLS connection class type, which wraps
 * a #GDatagramBased and provides DTLS encryption on top of it. Its
 * subclasses, #GDtlsClientConnection and #GDtlsServerConnection,
 * implement client-side and server-side DTLS, respectively.
 *
 * For TLS support, see #GTlsConnection.
 *
 * As DTLS is datagram based, #GDtlsConnection implements #GDatagramBased,
 * presenting a datagram-socket-like API for the encrypted connection. This
 * operates over a base datagram connection, which is also a #GDatagramBased
 * (#GDtlsConnection:base-socket).
 *
 * To close a DTLS connection, use g_dtls_connection_close().
 *
 * Neither #GDtlsServerConnection or #GDtlsClientConnection set the peer address
 * on their base #GDatagramBased if it is a #GSocket — it is up to the caller to
 * do that if they wish. If they do not, and g_socket_close() is called on the
 * base socket, the #GDtlsConnection will not raise a %G_IO_ERROR_NOT_CONNECTED
 * error on further I/O.
 *
 * Since: 2.48
 */


/**
 * SECTION:gdtlsserverconnection
 * @short_description: DTLS server-side connection
 * @include: gio/gio.h
 *
 * #GDtlsServerConnection is the server-side subclass of #GDtlsConnection,
 * representing a server-side DTLS connection.
 *
 * Since: 2.48
 */


/**
 * SECTION:gemblem
 * @short_description: An object for emblems
 * @include: gio/gio.h
 * @see_also: #GIcon, #GEmblemedIcon, #GLoadableIcon, #GThemedIcon
 *
 * #GEmblem is an implementation of #GIcon that supports
 * having an emblem, which is an icon with additional properties.
 * It can than be added to a #GEmblemedIcon.
 *
 * Currently, only metainformation about the emblem's origin is
 * supported. More may be added in the future.
 */


/**
 * SECTION:gemblemedicon
 * @short_description: Icon with emblems
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon, #GThemedIcon, #GEmblem
 *
 * #GEmblemedIcon is an implementation of #GIcon that supports
 * adding an emblem to an icon. Adding multiple emblems to an
 * icon is ensured via g_emblemed_icon_add_emblem().
 *
 * Note that #GEmblemedIcon allows no control over the position
 * of the emblems. See also #GEmblem for more information.
 */


/**
 * SECTION:gfile
 * @short_description: File and Directory Handling
 * @include: gio/gio.h
 * @see_also: #GFileInfo, #GFileEnumerator
 *
 * #GFile is a high level abstraction for manipulating files on a
 * virtual file system. #GFiles are lightweight, immutable objects
 * that do no I/O upon creation. It is necessary to understand that
 * #GFile objects do not represent files, merely an identifier for a
 * file. All file content I/O is implemented as streaming operations
 * (see #GInputStream and #GOutputStream).
 *
 * To construct a #GFile, you can use:
 * - g_file_new_for_path() if you have a path.
 * - g_file_new_for_uri() if you have a URI.
 * - g_file_new_for_commandline_arg() for a command line argument.
 * - g_file_new_tmp() to create a temporary file from a template.
 * - g_file_new_tmp_async() to asynchronously create a temporary file.
 * - g_file_new_tmp_dir_async() to asynchronously create a temporary directory.
 * - g_file_parse_name() from a UTF-8 string gotten from g_file_get_parse_name().
 * - g_file_new_build_filename() or g_file_new_build_filenamev() to create a file from path elements.
 *
 * One way to think of a #GFile is as an abstraction of a pathname. For
 * normal files the system pathname is what is stored internally, but as
 * #GFiles are extensible it could also be something else that corresponds
 * to a pathname in a userspace implementation of a filesystem.
 *
 * #GFiles make up hierarchies of directories and files that correspond to
 * the files on a filesystem. You can move through the file system with
 * #GFile using g_file_get_parent() to get an identifier for the parent
 * directory, g_file_get_child() to get a child within a directory,
 * g_file_resolve_relative_path() to resolve a relative path between two
 * #GFiles. There can be multiple hierarchies, so you may not end up at
 * the same root if you repeatedly call g_file_get_parent() on two different
 * files.
 *
 * All #GFiles have a basename (get with g_file_get_basename()). These names
 * are byte strings that are used to identify the file on the filesystem
 * (relative to its parent directory) and there is no guarantees that they
 * have any particular charset encoding or even make any sense at all. If
 * you want to use filenames in a user interface you should use the display
 * name that you can get by requesting the
 * %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME attribute with g_file_query_info().
 * This is guaranteed to be in UTF-8 and can be used in a user interface.
 * But always store the real basename or the #GFile to use to actually
 * access the file, because there is no way to go from a display name to
 * the actual name.
 *
 * Using #GFile as an identifier has the same weaknesses as using a path
 * in that there may be multiple aliases for the same file. For instance,
 * hard or soft links may cause two different #GFiles to refer to the same
 * file. Other possible causes for aliases are: case insensitive filesystems,
 * short and long names on FAT/NTFS, or bind mounts in Linux. If you want to
 * check if two #GFiles point to the same file you can query for the
 * %G_FILE_ATTRIBUTE_ID_FILE attribute. Note that #GFile does some trivial
 * canonicalization of pathnames passed in, so that trivial differences in
 * the path string used at creation (duplicated slashes, slash at end of
 * path, "." or ".." path segments, etc) does not create different #GFiles.
 *
 * Many #GFile operations have both synchronous and asynchronous versions
 * to suit your application. Asynchronous versions of synchronous functions
 * simply have _async() appended to their function names. The asynchronous
 * I/O functions call a #GAsyncReadyCallback which is then used to finalize
 * the operation, producing a GAsyncResult which is then passed to the
 * function's matching _finish() operation.
 *
 * It is highly recommended to use asynchronous calls when running within a
 * shared main loop, such as in the main thread of an application. This avoids
 * I/O operations blocking other sources on the main loop from being dispatched.
 * Synchronous I/O operations should be performed from worker threads. See the
 * [introduction to asynchronous programming section][async-programming] for
 * more.
 *
 * Some #GFile operations almost always take a noticeable amount of time, and
 * so do not have synchronous analogs. Notable cases include:
 * - g_file_mount_mountable() to mount a mountable file.
 * - g_file_unmount_mountable_with_operation() to unmount a mountable file.
 * - g_file_eject_mountable_with_operation() to eject a mountable file.
 *
 * ## Entity Tags # {#gfile-etag}
 *
 * One notable feature of #GFiles are entity tags, or "etags" for
 * short. Entity tags are somewhat like a more abstract version of the
 * traditional mtime, and can be used to quickly determine if the file
 * has been modified from the version on the file system. See the
 * HTTP 1.1
 * [specification](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html)
 * for HTTP Etag headers, which are a very similar concept.
 */


/**
 * SECTION:gfileattribute
 * @short_description: Key-Value Paired File Attributes
 * @include: gio/gio.h
 * @see_also: #GFile, #GFileInfo
 *
 * File attributes in GIO consist of a list of key-value pairs.
 *
 * Keys are strings that contain a key namespace and a key name, separated
 * by a colon, e.g. "namespace::keyname". Namespaces are included to sort
 * key-value pairs by namespaces for relevance. Keys can be retrieved
 * using wildcards, e.g. "standard::*" will return all of the keys in the
 * "standard" namespace.
 *
 * The list of possible attributes for a filesystem (pointed to by a #GFile) is
 * available as a #GFileAttributeInfoList. This list is queryable by key names
 * as indicated earlier.
 *
 * Information is stored within the list in #GFileAttributeInfo structures.
 * The info structure can store different types, listed in the enum
 * #GFileAttributeType. Upon creation of a #GFileAttributeInfo, the type will
 * be set to %G_FILE_ATTRIBUTE_TYPE_INVALID.
 *
 * Classes that implement #GFileIface will create a #GFileAttributeInfoList and
 * install default keys and values for their given file system, architecture,
 * and other possible implementation details (e.g., on a UNIX system, a file
 * attribute key will be registered for the user id for a given file).
 *
 * ## Default Namespaces
 *
 * - `"standard"`: The "Standard" namespace. General file information that
 *   any application may need should be put in this namespace. Examples
 *   include the file's name, type, and size.
 * - `"etag`: The [Entity Tag][gfile-etag] namespace. Currently, the only key
 *   in this namespace is "value", which contains the value of the current
 *   entity tag.
 * - `"id"`: The "Identification" namespace. This namespace is used by file
 *   managers and applications that list directories to check for loops and
 *   to uniquely identify files.
 * - `"access"`: The "Access" namespace. Used to check if a user has the
 *   proper privileges to access files and perform file operations. Keys in
 *   this namespace are made to be generic and easily understood, e.g. the
 *   "can_read" key is %TRUE if the current user has permission to read the
 *   file. UNIX permissions and NTFS ACLs in Windows should be mapped to
 *   these values.
 * - `"mountable"`: The "Mountable" namespace. Includes simple boolean keys
 *   for checking if a file or path supports mount operations, e.g. mount,
 *   unmount, eject. These are used for files of type %G_FILE_TYPE_MOUNTABLE.
 * - `"time"`: The "Time" namespace. Includes file access, changed, created
 *   times.
 * - `"unix"`: The "Unix" namespace. Includes UNIX-specific information and
 *   may not be available for all files. Examples include the UNIX "UID",
 *   "GID", etc.
 * - `"dos"`: The "DOS" namespace. Includes DOS-specific information and may
 *   not be available for all files. Examples include "is_system" for checking
 *   if a file is marked as a system file, and "is_archive" for checking if a
 *   file is marked as an archive file.
 * - `"owner"`: The "Owner" namespace. Includes information about who owns a
 *   file. May not be available for all file systems. Examples include "user"
 *   for getting the user name of the file owner. This information is often
 *   mapped from some backend specific data such as a UNIX UID.
 * - `"thumbnail"`: The "Thumbnail" namespace. Includes information about file
 *   thumbnails and their location within the file system. Examples of keys in
 *   this namespace include "path" to get the location of a thumbnail, "failed"
 *   to check if thumbnailing of the file failed, and "is-valid" to check if
 *   the thumbnail is outdated.
 * - `"filesystem"`: The "Filesystem" namespace. Gets information about the
 *   file system where a file is located, such as its type, how much space is
 *   left available, and the overall size of the file system.
 * - `"gvfs"`: The "GVFS" namespace. Keys in this namespace contain information
 *   about the current GVFS backend in use.
 * - `"xattr"`: The "xattr" namespace. Gets information about extended
 *   user attributes. See attr(5). The "user." prefix of the extended user
 *   attribute name is stripped away when constructing keys in this namespace,
 *   e.g. "xattr::mime_type" for the extended attribute with the name
 *   "user.mime_type". Note that this information is only available if
 *   GLib has been built with extended attribute support.
 * - `"xattr-sys"`: The "xattr-sys" namespace. Gets information about
 *   extended attributes which are not user-specific. See attr(5). Note
 *   that this information is only available if GLib has been built with
 *   extended attribute support.
 * - `"selinux"`: The "SELinux" namespace. Includes information about the
 *   SELinux context of files. Note that this information is only available
 *   if GLib has been built with SELinux support.
 *
 * Please note that these are not all of the possible namespaces.
 * More namespaces can be added from GIO modules or by individual applications.
 * For more information about writing GIO modules, see #GIOModule.
 *
 * <!-- TODO: Implementation note about using extended attributes on supported
 * file systems -->
 *
 * ## Default Keys
 *
 * For a list of the built-in keys and their types, see the
 * [GFileInfo][GFileInfo] documentation.
 *
 * Note that there are no predefined keys in the "xattr" and "xattr-sys"
 * namespaces. Keys for the "xattr" namespace are constructed by stripping
 * away the "user." prefix from the extended user attribute, and prepending
 * "xattr::". Keys for the "xattr-sys" namespace are constructed by
 * concatenating "xattr-sys::" with the extended attribute name. All extended
 * attribute values are returned as hex-encoded strings in which bytes outside
 * the ASCII range are encoded as escape sequences of the form \x`nn`
 * where `nn` is a 2-digit hexadecimal number.
 */


/**
 * SECTION:gfiledescriptorbased
 * @short_description: Interface for file descriptor based IO
 * @include: gio/gfiledescriptorbased.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * #GFileDescriptorBased is implemented by streams (implementations of
 * #GInputStream or #GOutputStream) that are based on file descriptors.
 *
 * Note that `<gio/gfiledescriptorbased.h>` belongs to the UNIX-specific
 * GIO interfaces, thus you have to use the `gio-unix-2.0.pc` pkg-config
 * file when using it.
 *
 * Since: 2.24
 */


/**
 * SECTION:gfileenumerator
 * @short_description: Enumerated Files Routines
 * @include: gio/gio.h
 *
 * #GFileEnumerator allows you to operate on a set of #GFiles,
 * returning a #GFileInfo structure for each file enumerated (e.g.
 * g_file_enumerate_children() will return a #GFileEnumerator for each
 * of the children within a directory).
 *
 * To get the next file's information from a #GFileEnumerator, use
 * g_file_enumerator_next_file() or its asynchronous version,
 * g_file_enumerator_next_files_async(). Note that the asynchronous
 * version will return a list of #GFileInfos, whereas the
 * synchronous will only return the next file in the enumerator.
 *
 * The ordering of returned files is unspecified for non-Unix
 * platforms; for more information, see g_dir_read_name().  On Unix,
 * when operating on local files, returned files will be sorted by
 * inode number.  Effectively you can assume that the ordering of
 * returned files will be stable between successive calls (and
 * applications) assuming the directory is unchanged.
 *
 * If your application needs a specific ordering, such as by name or
 * modification time, you will have to implement that in your
 * application code.
 *
 * To close a #GFileEnumerator, use g_file_enumerator_close(), or
 * its asynchronous version, g_file_enumerator_close_async(). Once
 * a #GFileEnumerator is closed, no further actions may be performed
 * on it, and it should be freed with g_object_unref().
 */


/**
 * SECTION:gfileicon
 * @short_description: Icons pointing to an image file
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon
 *
 * #GFileIcon specifies an icon by pointing to an image file
 * to be used as icon.
 */


/**
 * SECTION:gfileinfo
 * @short_description: File Information and Attributes
 * @include: gio/gio.h
 * @see_also: #GFile, [GFileAttribute][gio-GFileAttribute]
 *
 * Functionality for manipulating basic metadata for files. #GFileInfo
 * implements methods for getting information that all files should
 * contain, and allows for manipulation of extended attributes.
 *
 * See [GFileAttribute][gio-GFileAttribute] for more information on how
 * GIO handles file attributes.
 *
 * To obtain a #GFileInfo for a #GFile, use g_file_query_info() (or its
 * async variant). To obtain a #GFileInfo for a file input or output
 * stream, use g_file_input_stream_query_info() or
 * g_file_output_stream_query_info() (or their async variants).
 *
 * To change the actual attributes of a file, you should then set the
 * attribute in the #GFileInfo and call g_file_set_attributes_from_info()
 * or g_file_set_attributes_async() on a GFile.
 *
 * However, not all attributes can be changed in the file. For instance,
 * the actual size of a file cannot be changed via g_file_info_set_size().
 * You may call g_file_query_settable_attributes() and
 * g_file_query_writable_namespaces() to discover the settable attributes
 * of a particular file at runtime.
 *
 * The direct accessors, such as g_file_info_get_name(), are slightly more
 * optimized than the generic attribute accessors, such as
 * g_file_info_get_attribute_byte_string().This optimization will matter
 * only if calling the API in a tight loop.
 *
 * It is an error to call these accessors without specifying their required file
 * attributes when creating the #GFileInfo. Use g_file_info_has_attribute() or
 * g_file_info_list_attributes() to check what attributes are specified for a
 * #GFileInfo.
 *
 * #GFileAttributeMatcher allows for searching through a #GFileInfo for
 * attributes.
 */


/**
 * SECTION:gfileinputstream
 * @short_description: File input streaming operations
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GDataInputStream, #GSeekable
 *
 * GFileInputStream provides input streams that take their
 * content from a file.
 *
 * GFileInputStream implements #GSeekable, which allows the input
 * stream to jump to arbitrary positions in the file, provided the
 * filesystem of the file allows it. To find the position of a file
 * input stream, use g_seekable_tell(). To find out if a file input
 * stream supports seeking, use g_seekable_can_seek().
 * To position a file input stream, use g_seekable_seek().
 */


/**
 * SECTION:gfileiostream
 * @short_description: File read and write streaming operations
 * @include: gio/gio.h
 * @see_also: #GIOStream, #GFileInputStream, #GFileOutputStream, #GSeekable
 *
 * GFileIOStream provides io streams that both read and write to the same
 * file handle.
 *
 * GFileIOStream implements #GSeekable, which allows the io
 * stream to jump to arbitrary positions in the file and to truncate
 * the file, provided the filesystem of the file supports these
 * operations.
 *
 * To find the position of a file io stream, use
 * g_seekable_tell().
 *
 * To find out if a file io stream supports seeking, use g_seekable_can_seek().
 * To position a file io stream, use g_seekable_seek().
 * To find out if a file io stream supports truncating, use
 * g_seekable_can_truncate(). To truncate a file io
 * stream, use g_seekable_truncate().
 *
 * The default implementation of all the #GFileIOStream operations
 * and the implementation of #GSeekable just call into the same operations
 * on the output stream.
 *
 * Since: 2.22
 */


/**
 * SECTION:gfilemonitor
 * @short_description: File Monitor
 * @include: gio/gio.h
 *
 * Monitors a file or directory for changes.
 *
 * To obtain a #GFileMonitor for a file or directory, use
 * g_file_monitor(), g_file_monitor_file(), or
 * g_file_monitor_directory().
 *
 * To get informed about changes to the file or directory you are
 * monitoring, connect to the #GFileMonitor::changed signal. The
 * signal will be emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread that the monitor was created in
 * (though if the global default main context is blocked, this may
 * cause notifications to be blocked even if the thread-default
 * context is still running).
 */


/**
 * SECTION:gfilenamecompleter
 * @short_description: Filename Completer
 * @include: gio/gio.h
 *
 * Completes partial file and directory names given a partial string by
 * looking in the file system for clues. Can return a list of possible
 * completion strings for widget implementations.
 */


/**
 * SECTION:gfileoutputstream
 * @short_description: File output streaming operations
 * @include: gio/gio.h
 * @see_also: #GOutputStream, #GDataOutputStream, #GSeekable
 *
 * GFileOutputStream provides output streams that write their
 * content to a file.
 *
 * GFileOutputStream implements #GSeekable, which allows the output
 * stream to jump to arbitrary positions in the file and to truncate
 * the file, provided the filesystem of the file supports these
 * operations.
 *
 * To find the position of a file output stream, use g_seekable_tell().
 * To find out if a file output stream supports seeking, use
 * g_seekable_can_seek().To position a file output stream, use
 * g_seekable_seek(). To find out if a file output stream supports
 * truncating, use g_seekable_can_truncate(). To truncate a file output
 * stream, use g_seekable_truncate().
 */


/**
 * SECTION:gfilterinputstream
 * @short_description: Filter Input Stream
 * @include: gio/gio.h
 *
 * Base class for input stream implementations that perform some
 * kind of filtering operation on a base stream. Typical examples
 * of filtering operations are character set conversion, compression
 * and byte order flipping.
 */


/**
 * SECTION:gfilteroutputstream
 * @short_description: Filter Output Stream
 * @include: gio/gio.h
 *
 * Base class for output stream implementations that perform some
 * kind of filtering operation on a base stream. Typical examples
 * of filtering operations are character set conversion, compression
 * and byte order flipping.
 */


/**
 * SECTION:gicon
 * @short_description: Interface for icons
 * @include: gio/gio.h
 *
 * #GIcon is a very minimal interface for icons. It provides functions
 * for checking the equality of two icons, hashing of icons and
 * serializing an icon to and from strings.
 *
 * #GIcon does not provide the actual pixmap for the icon as this is out
 * of GIO's scope, however implementations of #GIcon may contain the name
 * of an icon (see #GThemedIcon), or the path to an icon (see #GLoadableIcon).
 *
 * To obtain a hash of a #GIcon, see g_icon_hash().
 *
 * To check if two #GIcons are equal, see g_icon_equal().
 *
 * For serializing a #GIcon, use g_icon_serialize() and
 * g_icon_deserialize().
 *
 * If you want to consume #GIcon (for example, in a toolkit) you must
 * be prepared to handle at least the three following cases:
 * #GLoadableIcon, #GThemedIcon and #GEmblemedIcon.  It may also make
 * sense to have fast-paths for other cases (like handling #GdkPixbuf
 * directly, for example) but all compliant #GIcon implementations
 * outside of GIO must implement #GLoadableIcon.
 *
 * If your application or library provides one or more #GIcon
 * implementations you need to ensure that your new implementation also
 * implements #GLoadableIcon.  Additionally, you must provide an
 * implementation of g_icon_serialize() that gives a result that is
 * understood by g_icon_deserialize(), yielding one of the built-in icon
 * types.
 */


/**
 * SECTION:ginetaddress
 * @short_description: An IPv4/IPv6 address
 * @include: gio/gio.h
 *
 * #GInetAddress represents an IPv4 or IPv6 internet address. Use
 * g_resolver_lookup_by_name() or g_resolver_lookup_by_name_async() to
 * look up the #GInetAddress for a hostname. Use
 * g_resolver_lookup_by_address() or
 * g_resolver_lookup_by_address_async() to look up the hostname for a
 * #GInetAddress.
 *
 * To actually connect to a remote host, you will need a
 * #GInetSocketAddress (which includes a #GInetAddress as well as a
 * port number).
 */


/**
 * SECTION:ginetaddressmask
 * @short_description: An IPv4/IPv6 address mask
 * @include: gio/gio.h
 *
 * #GInetAddressMask represents a range of IPv4 or IPv6 addresses
 * described by a base address and a length indicating how many bits
 * of the base address are relevant for matching purposes. These are
 * often given in string form. Eg, "10.0.0.0/8", or "fe80::/10".
 */


/**
 * SECTION:ginetsocketaddress
 * @short_description: Internet GSocketAddress
 * @include: gio/gio.h
 *
 * An IPv4 or IPv6 socket address; that is, the combination of a
 * #GInetAddress and a port number.
 */


/**
 * SECTION:ginitable
 * @short_description: Failable object initialization interface
 * @include: gio/gio.h
 * @see_also: #GAsyncInitable
 *
 * #GInitable is implemented by objects that can fail during
 * initialization. If an object implements this interface then
 * it must be initialized as the first thing after construction,
 * either via g_initable_init() or g_async_initable_init_async()
 * (the latter is only available if it also implements #GAsyncInitable).
 *
 * If the object is not initialized, or initialization returns with an
 * error, then all operations on the object except g_object_ref() and
 * g_object_unref() are considered to be invalid, and have undefined
 * behaviour. They will often fail with g_critical() or g_warning(), but
 * this must not be relied on.
 *
 * Users of objects implementing this are not intended to use
 * the interface method directly, instead it will be used automatically
 * in various ways. For C applications you generally just call
 * g_initable_new() directly, or indirectly via a foo_thing_new() wrapper.
 * This will call g_initable_init() under the cover, returning %NULL and
 * setting a #GError on failure (at which point the instance is
 * unreferenced).
 *
 * For bindings in languages where the native constructor supports
 * exceptions the binding could check for objects implementing %GInitable
 * during normal construction and automatically initialize them, throwing
 * an exception on failure.
 */


/**
 * SECTION:ginputstream
 * @short_description: Base class for implementing streaming input
 * @include: gio/gio.h
 *
 * #GInputStream has functions to read from a stream (g_input_stream_read()),
 * to close a stream (g_input_stream_close()) and to skip some content
 * (g_input_stream_skip()).
 *
 * To copy the content of an input stream to an output stream without
 * manually handling the reads and writes, use g_output_stream_splice().
 *
 * See the documentation for #GIOStream for details of thread safety of
 * streaming APIs.
 *
 * All of these functions have async variants too.
 */


/**
 * SECTION:gioerror
 * @short_description: Error helper functions
 * @include: gio/gio.h
 *
 * Contains helper functions for reporting errors to the user.
 */


/**
 * SECTION:giomodule
 * @short_description: Loadable GIO Modules
 * @include: gio/gio.h
 *
 * Provides an interface and default functions for loading and unloading
 * modules. This is used internally to make GIO extensible, but can also
 * be used by others to implement module loading.
 */


/**
 * SECTION:gioscheduler
 * @short_description: I/O Scheduler
 * @include: gio/gio.h
 *
 * As of GLib 2.36, #GIOScheduler is deprecated in favor of
 * #GThreadPool and #GTask.
 *
 * Schedules asynchronous I/O operations. #GIOScheduler integrates
 * into the main event loop (#GMainLoop) and uses threads.
 */


/**
 * SECTION:giostream
 * @short_description: Base class for implementing read/write streams
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * GIOStream represents an object that has both read and write streams.
 * Generally the two streams act as separate input and output streams,
 * but they share some common resources and state. For instance, for
 * seekable streams, both streams may use the same position.
 *
 * Examples of #GIOStream objects are #GSocketConnection, which represents
 * a two-way network connection; and #GFileIOStream, which represents a
 * file handle opened in read-write mode.
 *
 * To do the actual reading and writing you need to get the substreams
 * with g_io_stream_get_input_stream() and g_io_stream_get_output_stream().
 *
 * The #GIOStream object owns the input and the output streams, not the other
 * way around, so keeping the substreams alive will not keep the #GIOStream
 * object alive. If the #GIOStream object is freed it will be closed, thus
 * closing the substreams, so even if the substreams stay alive they will
 * always return %G_IO_ERROR_CLOSED for all operations.
 *
 * To close a stream use g_io_stream_close() which will close the common
 * stream object and also the individual substreams. You can also close
 * the substreams themselves. In most cases this only marks the
 * substream as closed, so further I/O on it fails but common state in the
 * #GIOStream may still be open. However, some streams may support
 * "half-closed" states where one direction of the stream is actually shut down.
 *
 * Operations on #GIOStreams cannot be started while another operation on the
 * #GIOStream or its substreams is in progress. Specifically, an application can
 * read from the #GInputStream and write to the #GOutputStream simultaneously
 * (either in separate threads, or as asynchronous operations in the same
 * thread), but an application cannot start any #GIOStream operation while there
 * is a #GIOStream, #GInputStream or #GOutputStream operation in progress, and
 * an application can’t start any #GInputStream or #GOutputStream operation
 * while there is a #GIOStream operation in progress.
 *
 * This is a product of individual stream operations being associated with a
 * given #GMainContext (the thread-default context at the time the operation was
 * started), rather than entire streams being associated with a single
 * #GMainContext.
 *
 * GIO may run operations on #GIOStreams from other (worker) threads, and this
 * may be exposed to application code in the behaviour of wrapper streams, such
 * as #GBufferedInputStream or #GTlsConnection. With such wrapper APIs,
 * application code may only run operations on the base (wrapped) stream when
 * the wrapper stream is idle. Note that the semantics of such operations may
 * not be well-defined due to the state the wrapper stream leaves the base
 * stream in (though they are guaranteed not to crash).
 *
 * Since: 2.22
 */


/**
 * SECTION:glistmodel
 * @title: GListModel
 * @short_description: An interface describing a dynamic list of objects
 * @include: gio/gio.h
 * @see_also: #GListStore
 *
 * #GListModel is an interface that represents a mutable list of
 * #GObjects. Its main intention is as a model for various widgets in
 * user interfaces, such as list views, but it can also be used as a
 * convenient method of returning lists of data, with support for
 * updates.
 *
 * Each object in the list may also report changes in itself via some
 * mechanism (normally the #GObject::notify signal).  Taken together
 * with the #GListModel::items-changed signal, this provides for a list
 * that can change its membership, and in which the members can change
 * their individual properties.
 *
 * A good example would be the list of visible wireless network access
 * points, where each access point can report dynamic properties such as
 * signal strength.
 *
 * It is important to note that the #GListModel itself does not report
 * changes to the individual items.  It only reports changes to the list
 * membership.  If you want to observe changes to the objects themselves
 * then you need to connect signals to the objects that you are
 * interested in.
 *
 * All items in a #GListModel are of (or derived from) the same type.
 * g_list_model_get_item_type() returns that type.  The type may be an
 * interface, in which case all objects in the list must implement it.
 *
 * The semantics are close to that of an array:
 * g_list_model_get_n_items() returns the number of items in the list and
 * g_list_model_get_item() returns an item at a (0-based) position. In
 * order to allow implementations to calculate the list length lazily,
 * you can also iterate over items: starting from 0, repeatedly call
 * g_list_model_get_item() until it returns %NULL.
 *
 * An implementation may create objects lazily, but must take care to
 * return the same object for a given position until all references to
 * it are gone.
 *
 * On the other side, a consumer is expected only to hold references on
 * objects that are currently "user visible", in order to facilitate the
 * maximum level of laziness in the implementation of the list and to
 * reduce the required number of signal connections at a given time.
 *
 * This interface is intended only to be used from a single thread.  The
 * thread in which it is appropriate to use it depends on the particular
 * implementation, but typically it will be from the thread that owns
 * the [thread-default main context][g-main-context-push-thread-default]
 * in effect at the time that the model was created.
 *
 * Over time, it has established itself as good practice for listmodel
 * implementations to provide properties `item-type` and `n-items` to
 * ease working with them. While it is not required, it is recommended
 * that implementations provide these two properties. They should return
 * the values of g_list_model_get_item_type() and g_list_model_get_n_items()
 * respectively and be defined as such:
 * |[<!-- language="C" -->
 * properties[PROP_ITEM_TYPE] =
 *   g_param_spec_gtype ("item-type", "", "", G_TYPE_OBJECT,
 *                       G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
 * properties[PROP_N_ITEMS] =
 *   g_param_spec_uint ("n-items", "", "", 0, G_MAXUINT, 0,
 *                      G_PARAM_READABLE | G_PARAM_STATIC_STRINGS);
 * ]|
 */


/**
 * SECTION:gliststore
 * @title: GListStore
 * @short_description: A simple implementation of #GListModel
 * @include: gio/gio.h
 *
 * #GListStore is a simple implementation of #GListModel that stores all
 * items in memory.
 *
 * It provides insertions, deletions, and lookups in logarithmic time
 * with a fast path for the common case of iterating the list linearly.
 */


/**
 * SECTION:gloadableicon
 * @short_description: Loadable Icons
 * @include: gio/gio.h
 * @see_also: #GIcon, #GThemedIcon
 *
 * Extends the #GIcon interface and adds the ability to
 * load icons from streams.
 */


/**
 * SECTION:gmemoryinputstream
 * @short_description: Streaming input operations on memory chunks
 * @include: gio/gio.h
 * @see_also: #GMemoryOutputStream
 *
 * #GMemoryInputStream is a class for using arbitrary
 * memory chunks as input for GIO streaming input operations.
 *
 * As of GLib 2.34, #GMemoryInputStream implements
 * #GPollableInputStream.
 */


/**
 * SECTION:gmemorymonitor
 * @title: GMemoryMonitor
 * @short_description: Memory usage monitor
 * @include: gio/gio.h
 *
 * #GMemoryMonitor will monitor system memory and suggest to the application
 * when to free memory so as to leave more room for other applications.
 * It is implemented on Linux using the [Low Memory Monitor](https://gitlab.freedesktop.org/hadess/low-memory-monitor/)
 * ([API documentation](https://hadess.pages.freedesktop.org/low-memory-monitor/)).
 *
 * There is also an implementation for use inside Flatpak sandboxes.
 *
 * Possible actions to take when the signal is received are:
 *
 *  - Free caches
 *  - Save files that haven't been looked at in a while to disk, ready to be reopened when needed
 *  - Run a garbage collection cycle
 *  - Try and compress fragmented allocations
 *  - Exit on idle if the process has no reason to stay around
 *  - Call [`malloc_trim(3)`](man:malloc_trim) to return cached heap pages to
 *    the kernel (if supported by your libc)
 *
 * Note that some actions may not always improve system performance, and so
 * should be profiled for your application. `malloc_trim()`, for example, may
 * make future heap allocations slower (due to releasing cached heap pages back
 * to the kernel).
 *
 * See #GMemoryMonitorWarningLevel for details on the various warning levels.
 *
 * |[<!-- language="C" -->
 * static void
 * warning_cb (GMemoryMonitor *m, GMemoryMonitorWarningLevel level)
 * {
 *   g_debug ("Warning level: %d", level);
 *   if (warning_level > G_MEMORY_MONITOR_WARNING_LEVEL_LOW)
 *     drop_caches ();
 * }
 *
 * static GMemoryMonitor *
 * monitor_low_memory (void)
 * {
 *   GMemoryMonitor *m;
 *   m = g_memory_monitor_dup_default ();
 *   g_signal_connect (G_OBJECT (m), "low-memory-warning",
 *                     G_CALLBACK (warning_cb), NULL);
 *   return m;
 * }
 * ]|
 *
 * Don't forget to disconnect the #GMemoryMonitor::low-memory-warning
 * signal, and unref the #GMemoryMonitor itself when exiting.
 *
 * Since: 2.64
 */


/**
 * SECTION:gmemoryoutputstream
 * @short_description: Streaming output operations on memory chunks
 * @include: gio/gio.h
 * @see_also: #GMemoryInputStream
 *
 * #GMemoryOutputStream is a class for using arbitrary
 * memory chunks as output for GIO streaming output operations.
 *
 * As of GLib 2.34, #GMemoryOutputStream trivially implements
 * #GPollableOutputStream: it always polls as ready.
 */


/**
 * SECTION:gmenu
 * @title: GMenu
 * @short_description: A simple implementation of GMenuModel
 * @include: gio/gio.h
 *
 * #GMenu is a simple implementation of #GMenuModel.
 * You populate a #GMenu by adding #GMenuItem instances to it.
 *
 * There are some convenience functions to allow you to directly
 * add items (avoiding #GMenuItem) for the common cases. To add
 * a regular item, use g_menu_insert(). To add a section, use
 * g_menu_insert_section(). To add a submenu, use
 * g_menu_insert_submenu().
 */


/**
 * SECTION:gmenuexporter
 * @title: GMenuModel exporter
 * @short_description: Export GMenuModels on D-Bus
 * @include: gio/gio.h
 * @see_also: #GMenuModel, #GDBusMenuModel
 *
 * These functions support exporting a #GMenuModel on D-Bus.
 * The D-Bus interface that is used is a private implementation
 * detail.
 *
 * To access an exported #GMenuModel remotely, use
 * g_dbus_menu_model_get() to obtain a #GDBusMenuModel.
 */


/**
 * SECTION:gmenumodel
 * @title: GMenuModel
 * @short_description: An abstract class representing the contents of a menu
 * @include: gio/gio.h
 * @see_also: #GActionGroup
 *
 * #GMenuModel represents the contents of a menu -- an ordered list of
 * menu items. The items are associated with actions, which can be
 * activated through them. Items can be grouped in sections, and may
 * have submenus associated with them. Both items and sections usually
 * have some representation data, such as labels or icons. The type of
 * the associated action (ie whether it is stateful, and what kind of
 * state it has) can influence the representation of the item.
 *
 * The conceptual model of menus in #GMenuModel is hierarchical:
 * sections and submenus are again represented by #GMenuModels.
 * Menus themselves do not define their own roles. Rather, the role
 * of a particular #GMenuModel is defined by the item that references
 * it (or, in the case of the 'root' menu, is defined by the context
 * in which it is used).
 *
 * As an example, consider the visible portions of this menu:
 *
 * ## An example menu # {#menu-example}
 *
 * ![](menu-example.png)
 *
 * There are 8 "menus" visible in the screenshot: one menubar, two
 * submenus and 5 sections:
 *
 * - the toplevel menubar (containing 4 items)
 * - the View submenu (containing 3 sections)
 * - the first section of the View submenu (containing 2 items)
 * - the second section of the View submenu (containing 1 item)
 * - the final section of the View submenu (containing 1 item)
 * - the Highlight Mode submenu (containing 2 sections)
 * - the Sources section (containing 2 items)
 * - the Markup section (containing 2 items)
 *
 * The [example][menu-model] illustrates the conceptual connection between
 * these 8 menus. Each large block in the figure represents a menu and the
 * smaller blocks within the large block represent items in that menu. Some
 * items contain references to other menus.
 *
 * ## A menu example # {#menu-model}
 *
 * ![](menu-model.png)
 *
 * Notice that the separators visible in the [example][menu-example]
 * appear nowhere in the [menu model][menu-model]. This is because
 * separators are not explicitly represented in the menu model. Instead,
 * a separator is inserted between any two non-empty sections of a menu.
 * Section items can have labels just like any other item. In that case,
 * a display system may show a section header instead of a separator.
 *
 * The motivation for this abstract model of application controls is
 * that modern user interfaces tend to make these controls available
 * outside the application. Examples include global menus, jumplists,
 * dash boards, etc. To support such uses, it is necessary to 'export'
 * information about actions and their representation in menus, which
 * is exactly what the [GActionGroup exporter][gio-GActionGroup-exporter]
 * and the [GMenuModel exporter][gio-GMenuModel-exporter] do for
 * #GActionGroup and #GMenuModel. The client-side counterparts to
 * make use of the exported information are #GDBusActionGroup and
 * #GDBusMenuModel.
 *
 * The API of #GMenuModel is very generic, with iterators for the
 * attributes and links of an item, see g_menu_model_iterate_item_attributes()
 * and g_menu_model_iterate_item_links(). The 'standard' attributes and
 * link types have predefined names: %G_MENU_ATTRIBUTE_LABEL,
 * %G_MENU_ATTRIBUTE_ACTION, %G_MENU_ATTRIBUTE_TARGET, %G_MENU_LINK_SECTION
 * and %G_MENU_LINK_SUBMENU.
 *
 * Items in a #GMenuModel represent active controls if they refer to
 * an action that can get activated when the user interacts with the
 * menu item. The reference to the action is encoded by the string id
 * in the %G_MENU_ATTRIBUTE_ACTION attribute. An action id uniquely
 * identifies an action in an action group. Which action group(s) provide
 * actions depends on the context in which the menu model is used.
 * E.g. when the model is exported as the application menu of a
 * #GtkApplication, actions can be application-wide or window-specific
 * (and thus come from two different action groups). By convention, the
 * application-wide actions have names that start with "app.", while the
 * names of window-specific actions start with "win.".
 *
 * While a wide variety of stateful actions is possible, the following
 * is the minimum that is expected to be supported by all users of exported
 * menu information:
 * - an action with no parameter type and no state
 * - an action with no parameter type and boolean state
 * - an action with string parameter type and string state
 *
 * ## Stateless
 *
 * A stateless action typically corresponds to an ordinary menu item.
 *
 * Selecting such a menu item will activate the action (with no parameter).
 *
 * ## Boolean State
 *
 * An action with a boolean state will most typically be used with a "toggle"
 * or "switch" menu item. The state can be set directly, but activating the
 * action (with no parameter) results in the state being toggled.
 *
 * Selecting a toggle menu item will activate the action. The menu item should
 * be rendered as "checked" when the state is true.
 *
 * ## String Parameter and State
 *
 * Actions with string parameters and state will most typically be used to
 * represent an enumerated choice over the items available for a group of
 * radio menu items. Activating the action with a string parameter is
 * equivalent to setting that parameter as the state.
 *
 * Radio menu items, in addition to being associated with the action, will
 * have a target value. Selecting that menu item will result in activation
 * of the action with the target value as the parameter. The menu item should
 * be rendered as "selected" when the state of the action is equal to the
 * target value of the menu item.
 */


/**
 * SECTION:gmount
 * @short_description: Mount management
 * @include: gio/gio.h
 * @see_also: GVolume, GUnixMountEntry, GUnixMountPoint
 *
 * The #GMount interface represents user-visible mounts. Note, when
 * porting from GnomeVFS, #GMount is the moral equivalent of #GnomeVFSVolume.
 *
 * #GMount is a "mounted" filesystem that you can access. Mounted is in
 * quotes because it's not the same as a unix mount, it might be a gvfs
 * mount, but you can still access the files on it if you use GIO. Might or
 * might not be related to a volume object.
 *
 * Unmounting a #GMount instance is an asynchronous operation. For
 * more information about asynchronous operations, see #GAsyncResult
 * and #GTask. To unmount a #GMount instance, first call
 * g_mount_unmount_with_operation() with (at least) the #GMount instance and a
 * #GAsyncReadyCallback.  The callback will be fired when the
 * operation has resolved (either with success or failure), and a
 * #GAsyncResult structure will be passed to the callback.  That
 * callback should then call g_mount_unmount_with_operation_finish() with the #GMount
 * and the #GAsyncResult data to see if the operation was completed
 * successfully.  If an @error is present when g_mount_unmount_with_operation_finish()
 * is called, then it will be filled with any error information.
 */


/**
 * SECTION:gmountoperation
 * @short_description: Object used for authentication and user interaction
 * @include: gio/gio.h
 *
 * #GMountOperation provides a mechanism for interacting with the user.
 * It can be used for authenticating mountable operations, such as loop
 * mounting files, hard drive partitions or server locations. It can
 * also be used to ask the user questions or show a list of applications
 * preventing unmount or eject operations from completing.
 *
 * Note that #GMountOperation is used for more than just #GMount
 * objects – for example it is also used in g_drive_start() and
 * g_drive_stop().
 *
 * Users should instantiate a subclass of this that implements all the
 * various callbacks to show the required dialogs, such as
 * #GtkMountOperation. If no user interaction is desired (for example
 * when automounting filesystems at login time), usually %NULL can be
 * passed, see each method taking a #GMountOperation for details.
 *
 * The term ‘TCRYPT’ is used to mean ‘compatible with TrueCrypt and VeraCrypt’.
 * [TrueCrypt](https://en.wikipedia.org/wiki/TrueCrypt) is a discontinued system for
 * encrypting file containers, partitions or whole disks, typically used with Windows.
 * [VeraCrypt](https://www.veracrypt.fr/) is a maintained fork of TrueCrypt with various
 * improvements and auditing fixes.
 */


/**
 * SECTION:gnativesocketaddress
 * @short_description: Native GSocketAddress
 * @include: gio/gio.h
 *
 * A socket address of some unknown native type.
 */


/**
 * SECTION:gnetworkaddress
 * @short_description: A GSocketConnectable for resolving hostnames
 * @include: gio/gio.h
 *
 * #GNetworkAddress provides an easy way to resolve a hostname and
 * then attempt to connect to that host, handling the possibility of
 * multiple IP addresses and multiple address families.
 *
 * The enumeration results of resolved addresses *may* be cached as long
 * as this object is kept alive which may have unexpected results if
 * alive for too long.
 *
 * See #GSocketConnectable for an example of using the connectable
 * interface.
 */


/**
 * SECTION:gnetworking
 * @title: gnetworking.h
 * @short_description: System networking includes
 * @include: gio/gnetworking.h
 *
 * The `<gio/gnetworking.h>` header can be included to get
 * various low-level networking-related system headers, automatically
 * taking care of certain portability issues for you.
 *
 * This can be used, for example, if you want to call setsockopt()
 * on a #GSocket.
 *
 * Note that while WinSock has many of the same APIs as the
 * traditional UNIX socket API, most of them behave at least slightly
 * differently (particularly with respect to error handling). If you
 * want your code to work under both UNIX and Windows, you will need
 * to take these differences into account.
 *
 * Also, under GNU libc, certain non-portable functions are only visible
 * in the headers if you define %_GNU_SOURCE before including them. Note
 * that this symbol must be defined before including any headers, or it
 * may not take effect.
 */


/**
 * SECTION:gnetworkmonitor
 * @title: GNetworkMonitor
 * @short_description: Network status monitor
 * @include: gio/gio.h
 *
 * #GNetworkMonitor provides an easy-to-use cross-platform API
 * for monitoring network connectivity. On Linux, the available
 * implementations are based on the kernel's netlink interface and
 * on NetworkManager.
 *
 * There is also an implementation for use inside Flatpak sandboxes.
 */


/**
 * SECTION:gnetworkservice
 * @short_description: A GSocketConnectable for resolving SRV records
 * @include: gio/gio.h
 *
 * Like #GNetworkAddress does with hostnames, #GNetworkService
 * provides an easy way to resolve a SRV record, and then attempt to
 * connect to one of the hosts that implements that service, handling
 * service priority/weighting, multiple IP addresses, and multiple
 * address families.
 *
 * See #GSrvTarget for more information about SRV records, and see
 * #GSocketConnectable for an example of using the connectable
 * interface.
 */


/**
 * SECTION:gnotification
 * @short_description: User Notifications (pop up messages)
 * @include: gio/gio.h
 *
 * #GNotification is a mechanism for creating a notification to be shown
 * to the user -- typically as a pop-up notification presented by the
 * desktop environment shell.
 *
 * The key difference between #GNotification and other similar APIs is
 * that, if supported by the desktop environment, notifications sent
 * with #GNotification will persist after the application has exited,
 * and even across system reboots.
 *
 * Since the user may click on a notification while the application is
 * not running, applications using #GNotification should be able to be
 * started as a D-Bus service, using #GApplication.
 *
 * In order for #GNotification to work, the application must have installed
 * a `.desktop` file. For example:
 * |[
 *  [Desktop Entry]
 *   Name=Test Application
 *   Comment=Description of what Test Application does
 *   Exec=gnome-test-application
 *   Icon=org.gnome.TestApplication
 *   Terminal=false
 *   Type=Application
 *   Categories=GNOME;GTK;TestApplication Category;
 *   StartupNotify=true
 *   DBusActivatable=true
 *   X-GNOME-UsesNotifications=true
 * ]|
 *
 * The `X-GNOME-UsesNotifications` key indicates to GNOME Control Center
 * that this application uses notifications, so it can be listed in the
 * Control Center’s ‘Notifications’ panel.
 *
 * The `.desktop` file must be named as `org.gnome.TestApplication.desktop`,
 * where `org.gnome.TestApplication` is the ID passed to g_application_new().
 *
 * User interaction with a notification (either the default action, or
 * buttons) must be associated with actions on the application (ie:
 * "app." actions).  It is not possible to route user interaction
 * through the notification itself, because the object will not exist if
 * the application is autostarted as a result of a notification being
 * clicked.
 *
 * A notification can be sent with g_application_send_notification().
 *
 * Since: 2.40
 */


/**
 * SECTION:goutputstream
 * @short_description: Base class for implementing streaming output
 * @include: gio/gio.h
 *
 * #GOutputStream has functions to write to a stream (g_output_stream_write()),
 * to close a stream (g_output_stream_close()) and to flush pending writes
 * (g_output_stream_flush()).
 *
 * To copy the content of an input stream to an output stream without
 * manually handling the reads and writes, use g_output_stream_splice().
 *
 * See the documentation for #GIOStream for details of thread safety of
 * streaming APIs.
 *
 * All of these functions have async variants too.
 */


/**
 * SECTION:gpermission
 * @title: GPermission
 * @short_description: An object representing the permission
 *     to perform a certain action
 * @include: gio/gio.h
 *
 * A #GPermission represents the status of the caller's permission to
 * perform a certain action.
 *
 * You can query if the action is currently allowed and if it is
 * possible to acquire the permission so that the action will be allowed
 * in the future.
 *
 * There is also an API to actually acquire the permission and one to
 * release it.
 *
 * As an example, a #GPermission might represent the ability for the
 * user to write to a #GSettings object.  This #GPermission object could
 * then be used to decide if it is appropriate to show a "Click here to
 * unlock" button in a dialog and to provide the mechanism to invoke
 * when that button is clicked.
 */


/**
 * SECTION:gpollableinputstream
 * @short_description: Interface for pollable input streams
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GPollableOutputStream, #GFileDescriptorBased
 *
 * #GPollableInputStream is implemented by #GInputStreams that
 * can be polled for readiness to read. This can be used when
 * interfacing with a non-GIO API that expects
 * UNIX-file-descriptor-style asynchronous I/O rather than GIO-style.
 *
 * Some classes may implement #GPollableInputStream but have only certain
 * instances of that class be pollable. If g_pollable_input_stream_can_poll()
 * returns %FALSE, then the behavior of other #GPollableInputStream methods is
 * undefined.
 *
 * Since: 2.28
 */


/**
 * SECTION:gpollableoutputstream
 * @short_description: Interface for pollable output streams
 * @include: gio/gio.h
 * @see_also: #GOutputStream, #GFileDescriptorBased, #GPollableInputStream
 *
 * #GPollableOutputStream is implemented by #GOutputStreams that
 * can be polled for readiness to write. This can be used when
 * interfacing with a non-GIO API that expects
 * UNIX-file-descriptor-style asynchronous I/O rather than GIO-style.
 *
 * Some classes may implement #GPollableOutputStream but have only certain
 * instances of that class be pollable. If g_pollable_output_stream_can_poll()
 * returns %FALSE, then the behavior of other #GPollableOutputStream methods is
 * undefined.
 *
 * Since: 2.28
 */


/**
 * SECTION:gpollableutils
 * @short_description: Utilities for pollable streams
 * @include: gio/gio.h
 *
 * Utility functions for #GPollableInputStream and
 * #GPollableOutputStream implementations.
 */


/**
 * SECTION:gpowerprofilemonitor
 * @title: GPowerProfileMonitor
 * @short_description: Power profile monitor
 * @include: gio/gio.h
 *
 * #GPowerProfileMonitor makes it possible for applications as well as OS components
 * to monitor system power profiles and act upon them. It currently only exports
 * whether the system is in “Power Saver” mode (known as “Low Power” mode on
 * some systems).
 *
 * When in “Low Power” mode, it is recommended that applications:
 * - disable automatic downloads;
 * - reduce the rate of refresh from online sources such as calendar or
 *   email synchronisation;
 * - reduce the use of expensive visual effects.
 *
 * It is also likely that OS components providing services to applications will
 * lower their own background activity, for the sake of the system.
 *
 * There are a variety of tools that exist for power consumption analysis, but those
 * usually depend on the OS and hardware used. On Linux, one could use `upower` to
 * monitor the battery discharge rate, `powertop` to check on the background activity
 * or activity at all), `sysprof` to inspect CPU usage, and `intel_gpu_time` to
 * profile GPU usage.
 *
 * Don't forget to disconnect the #GPowerProfileMonitor::notify::power-saver-enabled
 * signal, and unref the #GPowerProfileMonitor itself when exiting.
 *
 * Since: 2.70
 */


/**
 * SECTION:gpropertyaction
 * @title: GPropertyAction
 * @short_description: A GAction reflecting a GObject property
 * @include: gio/gio.h
 *
 * A #GPropertyAction is a way to get a #GAction with a state value
 * reflecting and controlling the value of a #GObject property.
 *
 * The state of the action will correspond to the value of the property.
 * Changing it will change the property (assuming the requested value
 * matches the requirements as specified in the #GParamSpec).
 *
 * Only the most common types are presently supported.  Booleans are
 * mapped to booleans, strings to strings, signed/unsigned integers to
 * int32/uint32 and floats and doubles to doubles.
 *
 * If the property is an enum then the state will be string-typed and
 * conversion will automatically be performed between the enum value and
 * "nick" string as per the #GEnumValue table.
 *
 * Flags types are not currently supported.
 *
 * Properties of object types, boxed types and pointer types are not
 * supported and probably never will be.
 *
 * Properties of #GVariant types are not currently supported.
 *
 * If the property is boolean-valued then the action will have a NULL
 * parameter type, and activating the action (with no parameter) will
 * toggle the value of the property.
 *
 * In all other cases, the parameter type will correspond to the type of
 * the property.
 *
 * The general idea here is to reduce the number of locations where a
 * particular piece of state is kept (and therefore has to be synchronised
 * between). #GPropertyAction does not have a separate state that is kept
 * in sync with the property value -- its state is the property value.
 *
 * For example, it might be useful to create a #GAction corresponding to
 * the "visible-child-name" property of a #GtkStack so that the current
 * page can be switched from a menu.  The active radio indication in the
 * menu is then directly determined from the active page of the
 * #GtkStack.
 *
 * An anti-example would be binding the "active-id" property on a
 * #GtkComboBox.  This is because the state of the combobox itself is
 * probably uninteresting and is actually being used to control
 * something else.
 *
 * Another anti-example would be to bind to the "visible-child-name"
 * property of a #GtkStack if this value is actually stored in
 * #GSettings.  In that case, the real source of the value is
 * #GSettings.  If you want a #GAction to control a setting stored in
 * #GSettings, see g_settings_create_action() instead, and possibly
 * combine its use with g_settings_bind().
 *
 * Since: 2.38
 */


/**
 * SECTION:gproxy
 * @short_description: Interface for proxy handling
 * @include: gio/gio.h
 *
 * A #GProxy handles connecting to a remote host via a given type of
 * proxy server. It is implemented by the 'gio-proxy' extension point.
 * The extensions are named after their proxy protocol name. As an
 * example, a SOCKS5 proxy implementation can be retrieved with the
 * name 'socks5' using the function
 * g_io_extension_point_get_extension_by_name().
 *
 * Since: 2.26
 */


/**
 * SECTION:gproxyaddress
 * @short_description: An internet address with proxy information
 * @include: gio/gio.h
 *
 * Support for proxied #GInetSocketAddress.
 */


/**
 * SECTION:gproxyaddressenumerator
 * @short_description: Proxy wrapper enumerator for socket addresses
 * @include: gio/gio.h
 *
 * #GProxyAddressEnumerator is a wrapper around #GSocketAddressEnumerator which
 * takes the #GSocketAddress instances returned by the #GSocketAddressEnumerator
 * and wraps them in #GProxyAddress instances, using the given
 * #GProxyAddressEnumerator:proxy-resolver.
 *
 * This enumerator will be returned (for example, by
 * g_socket_connectable_enumerate()) as appropriate when a proxy is configured;
 * there should be no need to manually wrap a #GSocketAddressEnumerator instance
 * with one.
 */


/**
 * SECTION:gproxyresolver
 * @short_description: Asynchronous and cancellable network proxy resolver
 * @include: gio/gio.h
 *
 * #GProxyResolver provides synchronous and asynchronous network proxy
 * resolution. #GProxyResolver is used within #GSocketClient through
 * the method g_socket_connectable_proxy_enumerate().
 *
 * Implementations of #GProxyResolver based on libproxy and GNOME settings can
 * be found in glib-networking. GIO comes with an implementation for use inside
 * Flatpak portals.
 */


/**
 * SECTION:gremoteactiongroup
 * @title: GRemoteActionGroup
 * @short_description: A GActionGroup that interacts with other processes
 * @include: gio/gio.h
 *
 * The GRemoteActionGroup interface is implemented by #GActionGroup
 * instances that either transmit action invocations to other processes
 * or receive action invocations in the local process from other
 * processes.
 *
 * The interface has `_full` variants of the two
 * methods on #GActionGroup used to activate actions:
 * g_action_group_activate_action() and
 * g_action_group_change_action_state(). These variants allow a
 * "platform data" #GVariant to be specified: a dictionary providing
 * context for the action invocation (for example: timestamps, startup
 * notification IDs, etc).
 *
 * #GDBusActionGroup implements #GRemoteActionGroup.  This provides a
 * mechanism to send platform data for action invocations over D-Bus.
 *
 * Additionally, g_dbus_connection_export_action_group() will check if
 * the exported #GActionGroup implements #GRemoteActionGroup and use the
 * `_full` variants of the calls if available.  This
 * provides a mechanism by which to receive platform data for action
 * invocations that arrive by way of D-Bus.
 *
 * Since: 2.32
 */


/**
 * SECTION:gresolver
 * @short_description: Asynchronous and cancellable DNS resolver
 * @include: gio/gio.h
 *
 * #GResolver provides cancellable synchronous and asynchronous DNS
 * resolution, for hostnames (g_resolver_lookup_by_address(),
 * g_resolver_lookup_by_name() and their async variants) and SRV
 * (service) records (g_resolver_lookup_service()).
 *
 * #GNetworkAddress and #GNetworkService provide wrappers around
 * #GResolver functionality that also implement #GSocketConnectable,
 * making it easy to connect to a remote host/service.
 *
 * The default resolver (see g_resolver_get_default()) has a timeout of 30s set
 * on it since GLib 2.78. Earlier versions of GLib did not support resolver
 * timeouts.
 */


/**
 * SECTION:gresource
 * @short_description: Resource framework
 * @include: gio/gio.h
 *
 * Applications and libraries often contain binary or textual data that is
 * really part of the application, rather than user data. For instance
 * #GtkBuilder .ui files, splashscreen images, GMenu markup XML, CSS files,
 * icons, etc. These are often shipped as files in `$datadir/appname`, or
 * manually included as literal strings in the code.
 *
 * The #GResource API and the [glib-compile-resources][glib-compile-resources] program
 * provide a convenient and efficient alternative to this which has some nice properties. You
 * maintain the files as normal files, so its easy to edit them, but during the build the files
 * are combined into a binary bundle that is linked into the executable. This means that loading
 * the resource files are efficient (as they are already in memory, shared with other instances) and
 * simple (no need to check for things like I/O errors or locate the files in the filesystem). It
 * also makes it easier to create relocatable applications.
 *
 * Resource files can also be marked as compressed. Such files will be included in the resource bundle
 * in a compressed form, but will be automatically uncompressed when the resource is used. This
 * is very useful e.g. for larger text files that are parsed once (or rarely) and then thrown away.
 *
 * Resource files can also be marked to be preprocessed, by setting the value of the
 * `preprocess` attribute to a comma-separated list of preprocessing options.
 * The only options currently supported are:
 *
 * `xml-stripblanks` which will use the xmllint command
 * to strip ignorable whitespace from the XML file. For this to work,
 * the `XMLLINT` environment variable must be set to the full path to
 * the xmllint executable, or xmllint must be in the `PATH`; otherwise
 * the preprocessing step is skipped.
 *
 * `to-pixdata` (deprecated since gdk-pixbuf 2.32) which will use the
 * `gdk-pixbuf-pixdata` command to convert images to the #GdkPixdata format,
 * which allows you to create pixbufs directly using the data inside the
 * resource file, rather than an (uncompressed) copy of it. For this, the
 * `gdk-pixbuf-pixdata` program must be in the `PATH`, or the
 * `GDK_PIXBUF_PIXDATA` environment variable must be set to the full path to the
 * `gdk-pixbuf-pixdata` executable; otherwise the resource compiler will abort.
 * `to-pixdata` has been deprecated since gdk-pixbuf 2.32, as #GResource
 * supports embedding modern image formats just as well. Instead of using it,
 * embed a PNG or SVG file in your #GResource.
 *
 * `json-stripblanks` which will use the `json-glib-format` command to strip
 * ignorable whitespace from the JSON file. For this to work, the
 * `JSON_GLIB_FORMAT` environment variable must be set to the full path to the
 * `json-glib-format` executable, or it must be in the `PATH`;
 * otherwise the preprocessing step is skipped. In addition, at least version
 * 1.6 of `json-glib-format` is required.
 *
 * Resource files will be exported in the GResource namespace using the
 * combination of the given `prefix` and the filename from the `file` element.
 * The `alias` attribute can be used to alter the filename to expose them at a
 * different location in the resource namespace. Typically, this is used to
 * include files from a different source directory without exposing the source
 * directory in the resource namespace, as in the example below.
 *
 * Resource bundles are created by the [glib-compile-resources][glib-compile-resources] program
 * which takes an XML file that describes the bundle, and a set of files that the XML references. These
 * are combined into a binary resource bundle.
 *
 * An example resource description:
 * |[
 * <?xml version="1.0" encoding="UTF-8"?>
 * <gresources>
 *   <gresource prefix="/org/gtk/Example">
 *     <file>data/splashscreen.png</file>
 *     <file compressed="true">dialog.ui</file>
 *     <file preprocess="xml-stripblanks">menumarkup.xml</file>
 *     <file alias="example.css">data/example.css</file>
 *   </gresource>
 * </gresources>
 * ]|
 *
 * This will create a resource bundle with the following files:
 * |[
 * /org/gtk/Example/data/splashscreen.png
 * /org/gtk/Example/dialog.ui
 * /org/gtk/Example/menumarkup.xml
 * /org/gtk/Example/example.css
 * ]|
 *
 * Note that all resources in the process share the same namespace, so use Java-style
 * path prefixes (like in the above example) to avoid conflicts.
 *
 * You can then use [glib-compile-resources][glib-compile-resources] to compile the XML to a
 * binary bundle that you can load with g_resource_load(). However, its more common to use the --generate-source and
 * --generate-header arguments to create a source file and header to link directly into your application.
 * This will generate `get_resource()`, `register_resource()` and
 * `unregister_resource()` functions, prefixed by the `--c-name` argument passed
 * to [glib-compile-resources][glib-compile-resources]. `get_resource()` returns
 * the generated #GResource object. The register and unregister functions
 * register the resource so its files can be accessed using
 * g_resources_lookup_data().
 *
 * Once a #GResource has been created and registered all the data in it can be accessed globally in the process by
 * using API calls like g_resources_open_stream() to stream the data or g_resources_lookup_data() to get a direct pointer
 * to the data. You can also use URIs like "resource:///org/gtk/Example/data/splashscreen.png" with #GFile to access
 * the resource data.
 *
 * Some higher-level APIs, such as #GtkApplication, will automatically load
 * resources from certain well-known paths in the resource namespace as a
 * convenience. See the documentation for those APIs for details.
 *
 * There are two forms of the generated source, the default version uses the compiler support for constructor
 * and destructor functions (where available) to automatically create and register the #GResource on startup
 * or library load time. If you pass `--manual-register`, two functions to register/unregister the resource are created
 * instead. This requires an explicit initialization call in your application/library, but it works on all platforms,
 * even on the minor ones where constructors are not supported. (Constructor support is available for at least Win32, Mac OS and Linux.)
 *
 * Note that resource data can point directly into the data segment of e.g. a library, so if you are unloading libraries
 * during runtime you need to be very careful with keeping around pointers to data from a resource, as this goes away
 * when the library is unloaded. However, in practice this is not generally a problem, since most resource accesses
 * are for your own resources, and resource data is often used once, during parsing, and then released.
 *
 * When debugging a program or testing a change to an installed version, it is often useful to be able to
 * replace resources in the program or library, without recompiling, for debugging or quick hacking and testing
 * purposes. Since GLib 2.50, it is possible to use the `G_RESOURCE_OVERLAYS` environment variable to selectively overlay
 * resources with replacements from the filesystem.  It is a %G_SEARCHPATH_SEPARATOR-separated list of substitutions to perform
 * during resource lookups. It is ignored when running in a setuid process.
 *
 * A substitution has the form
 *
 * |[
 *    /org/gtk/libgtk=/home/desrt/gtk-overlay
 * ]|
 *
 * The part before the `=` is the resource subpath for which the overlay applies.  The part after is a
 * filesystem path which contains files and subdirectories as you would like to be loaded as resources with the
 * equivalent names.
 *
 * In the example above, if an application tried to load a resource with the resource path
 * `/org/gtk/libgtk/ui/gtkdialog.ui` then GResource would check the filesystem path
 * `/home/desrt/gtk-overlay/ui/gtkdialog.ui`.  If a file was found there, it would be used instead.  This is an
 * overlay, not an outright replacement, which means that if a file is not found at that path, the built-in
 * version will be used instead.  Whiteouts are not currently supported.
 *
 * Substitutions must start with a slash, and must not contain a trailing slash before the '='.  The path after
 * the slash should ideally be absolute, but this is not strictly required.  It is possible to overlay the
 * location of a single resource with an individual file.
 *
 * Since: 2.32
 */


/**
 * SECTION:gseekable
 * @short_description: Stream seeking interface
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * #GSeekable is implemented by streams (implementations of
 * #GInputStream or #GOutputStream) that support seeking.
 *
 * Seekable streams largely fall into two categories: resizable and
 * fixed-size.
 *
 * #GSeekable on fixed-sized streams is approximately the same as POSIX
 * lseek() on a block device (for example: attempting to seek past the
 * end of the device is an error).  Fixed streams typically cannot be
 * truncated.
 *
 * #GSeekable on resizable streams is approximately the same as POSIX
 * lseek() on a normal file.  Seeking past the end and writing data will
 * usually cause the stream to resize by introducing zero bytes.
 */


/**
 * SECTION:gsettings
 * @short_description: High-level API for application settings
 * @include: gio/gio.h
 *
 * The #GSettings class provides a convenient API for storing and retrieving
 * application settings.
 *
 * Reads and writes can be considered to be non-blocking.  Reading
 * settings with #GSettings is typically extremely fast: on
 * approximately the same order of magnitude (but slower than) a
 * #GHashTable lookup.  Writing settings is also extremely fast in terms
 * of time to return to your application, but can be extremely expensive
 * for other threads and other processes.  Many settings backends
 * (including dconf) have lazy initialisation which means in the common
 * case of the user using their computer without modifying any settings
 * a lot of work can be avoided.  For dconf, the D-Bus service doesn't
 * even need to be started in this case.  For this reason, you should
 * only ever modify #GSettings keys in response to explicit user action.
 * Particular care should be paid to ensure that modifications are not
 * made during startup -- for example, when setting the initial value
 * of preferences widgets.  The built-in g_settings_bind() functionality
 * is careful not to write settings in response to notify signals as a
 * result of modifications that it makes to widgets.
 *
 * When creating a GSettings instance, you have to specify a schema
 * that describes the keys in your settings and their types and default
 * values, as well as some other information.
 *
 * Normally, a schema has a fixed path that determines where the settings
 * are stored in the conceptual global tree of settings. However, schemas
 * can also be '[relocatable][gsettings-relocatable]', i.e. not equipped with
 * a fixed path. This is
 * useful e.g. when the schema describes an 'account', and you want to be
 * able to store a arbitrary number of accounts.
 *
 * Paths must start with and end with a forward slash character ('/')
 * and must not contain two sequential slash characters.  Paths should
 * be chosen based on a domain name associated with the program or
 * library to which the settings belong.  Examples of paths are
 * "/org/gtk/settings/file-chooser/" and "/ca/desrt/dconf-editor/".
 * Paths should not start with "/apps/", "/desktop/" or "/system/" as
 * they often did in GConf.
 *
 * Unlike other configuration systems (like GConf), GSettings does not
 * restrict keys to basic types like strings and numbers. GSettings stores
 * values as #GVariant, and allows any #GVariantType for keys. Key names
 * are restricted to lowercase characters, numbers and '-'. Furthermore,
 * the names must begin with a lowercase character, must not end
 * with a '-', and must not contain consecutive dashes.
 *
 * Similar to GConf, the default values in GSettings schemas can be
 * localized, but the localized values are stored in gettext catalogs
 * and looked up with the domain that is specified in the
 * `gettext-domain` attribute of the <schemalist> or <schema>
 * elements and the category that is specified in the `l10n` attribute of
 * the <default> element. The string which is translated includes all text in
 * the <default> element, including any surrounding quotation marks.
 *
 * The `l10n` attribute must be set to `messages` or `time`, and sets the
 * [locale category for
 * translation](https://www.gnu.org/software/gettext/manual/html_node/Aspects.html#index-locale-categories-1).
 * The `messages` category should be used by default; use `time` for
 * translatable date or time formats. A translation comment can be added as an
 * XML comment immediately above the <default> element — it is recommended to
 * add these comments to aid translators understand the meaning and
 * implications of the default value. An optional translation `context`
 * attribute can be set on the <default> element to disambiguate multiple
 * defaults which use the same string.
 *
 * For example:
 * |[
 *  <!-- Translators: A list of words which are not allowed to be typed, in
 *       GVariant serialization syntax.
 *       See: https://developer.gnome.org/glib/stable/gvariant-text.html -->
 *  <default l10n='messages' context='Banned words'>['bad', 'words']</default>
 * ]|
 *
 * Translations of default values must remain syntactically valid serialized
 * #GVariants (e.g. retaining any surrounding quotation marks) or runtime
 * errors will occur.
 *
 * GSettings uses schemas in a compact binary form that is created
 * by the [glib-compile-schemas][glib-compile-schemas]
 * utility. The input is a schema description in an XML format.
 *
 * A DTD for the gschema XML format can be found here:
 * [gschema.dtd](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/gschema.dtd)
 *
 * The [glib-compile-schemas][glib-compile-schemas] tool expects schema
 * files to have the extension `.gschema.xml`.
 *
 * At runtime, schemas are identified by their id (as specified in the
 * id attribute of the <schema> element). The convention for schema
 * ids is to use a dotted name, similar in style to a D-Bus bus name,
 * e.g. "org.gnome.SessionManager". In particular, if the settings are
 * for a specific service that owns a D-Bus bus name, the D-Bus bus name
 * and schema id should match. For schemas which deal with settings not
 * associated with one named application, the id should not use
 * StudlyCaps, e.g. "org.gnome.font-rendering".
 *
 * In addition to #GVariant types, keys can have types that have
 * enumerated types. These can be described by a <choice>,
 * <enum> or <flags> element, as seen in the
 * [example][schema-enumerated]. The underlying type of such a key
 * is string, but you can use g_settings_get_enum(), g_settings_set_enum(),
 * g_settings_get_flags(), g_settings_set_flags() access the numeric values
 * corresponding to the string value of enum and flags keys.
 *
 * An example for default value:
 * |[
 * <schemalist>
 *   <schema id="org.gtk.Test" path="/org/gtk/Test/" gettext-domain="test">
 *
 *     <key name="greeting" type="s">
 *       <default l10n="messages">"Hello, earthlings"</default>
 *       <summary>A greeting</summary>
 *       <description>
 *         Greeting of the invading martians
 *       </description>
 *     </key>
 *
 *     <key name="box" type="(ii)">
 *       <default>(20,30)</default>
 *     </key>
 *
 *     <key name="empty-string" type="s">
 *       <default>""</default>
 *       <summary>Empty strings have to be provided in GVariant form</summary>
 *     </key>
 *
 *   </schema>
 * </schemalist>
 * ]|
 *
 * An example for ranges, choices and enumerated types:
 * |[
 * <schemalist>
 *
 *   <enum id="org.gtk.Test.myenum">
 *     <value nick="first" value="1"/>
 *     <value nick="second" value="2"/>
 *   </enum>
 *
 *   <flags id="org.gtk.Test.myflags">
 *     <value nick="flag1" value="1"/>
 *     <value nick="flag2" value="2"/>
 *     <value nick="flag3" value="4"/>
 *   </flags>
 *
 *   <schema id="org.gtk.Test">
 *
 *     <key name="key-with-range" type="i">
 *       <range min="1" max="100"/>
 *       <default>10</default>
 *     </key>
 *
 *     <key name="key-with-choices" type="s">
 *       <choices>
 *         <choice value='Elisabeth'/>
 *         <choice value='Annabeth'/>
 *         <choice value='Joe'/>
 *       </choices>
 *       <aliases>
 *         <alias value='Anna' target='Annabeth'/>
 *         <alias value='Beth' target='Elisabeth'/>
 *       </aliases>
 *       <default>'Joe'</default>
 *     </key>
 *
 *     <key name='enumerated-key' enum='org.gtk.Test.myenum'>
 *       <default>'first'</default>
 *     </key>
 *
 *     <key name='flags-key' flags='org.gtk.Test.myflags'>
 *       <default>["flag1","flag2"]</default>
 *     </key>
 *   </schema>
 * </schemalist>
 * ]|
 *
 * ## Vendor overrides
 *
 * Default values are defined in the schemas that get installed by
 * an application. Sometimes, it is necessary for a vendor or distributor
 * to adjust these defaults. Since patching the XML source for the schema
 * is inconvenient and error-prone,
 * [glib-compile-schemas][glib-compile-schemas] reads so-called vendor
 * override' files. These are keyfiles in the same directory as the XML
 * schema sources which can override default values. The schema id serves
 * as the group name in the key file, and the values are expected in
 * serialized GVariant form, as in the following example:
 * |[
 *     [org.gtk.Example]
 *     key1='string'
 *     key2=1.5
 * ]|
 *
 * glib-compile-schemas expects schema files to have the extension
 * `.gschema.override`.
 *
 * ## Binding
 *
 * A very convenient feature of GSettings lets you bind #GObject properties
 * directly to settings, using g_settings_bind(). Once a GObject property
 * has been bound to a setting, changes on either side are automatically
 * propagated to the other side. GSettings handles details like mapping
 * between GObject and GVariant types, and preventing infinite cycles.
 *
 * This makes it very easy to hook up a preferences dialog to the
 * underlying settings. To make this even more convenient, GSettings
 * looks for a boolean property with the name "sensitivity" and
 * automatically binds it to the writability of the bound setting.
 * If this 'magic' gets in the way, it can be suppressed with the
 * %G_SETTINGS_BIND_NO_SENSITIVITY flag.
 *
 * ## Relocatable schemas # {#gsettings-relocatable}
 *
 * A relocatable schema is one with no `path` attribute specified on its
 * <schema> element. By using g_settings_new_with_path(), a #GSettings object
 * can be instantiated for a relocatable schema, assigning a path to the
 * instance. Paths passed to g_settings_new_with_path() will typically be
 * constructed dynamically from a constant prefix plus some form of instance
 * identifier; but they must still be valid GSettings paths. Paths could also
 * be constant and used with a globally installed schema originating from a
 * dependency library.
 *
 * For example, a relocatable schema could be used to store geometry information
 * for different windows in an application. If the schema ID was
 * `org.foo.MyApp.Window`, it could be instantiated for paths
 * `/org/foo/MyApp/main/`, `/org/foo/MyApp/document-1/`,
 * `/org/foo/MyApp/document-2/`, etc. If any of the paths are well-known
 * they can be specified as <child> elements in the parent schema, e.g.:
 * |[
 * <schema id="org.foo.MyApp" path="/org/foo/MyApp/">
 *   <child name="main" schema="org.foo.MyApp.Window"/>
 * </schema>
 * ]|
 *
 * ## Build system integration # {#gsettings-build-system}
 *
 * GSettings comes with autotools integration to simplify compiling and
 * installing schemas. To add GSettings support to an application, add the
 * following to your `configure.ac`:
 * |[
 * GLIB_GSETTINGS
 * ]|
 *
 * In the appropriate `Makefile.am`, use the following snippet to compile and
 * install the named schema:
 * |[
 * gsettings_SCHEMAS = org.foo.MyApp.gschema.xml
 * EXTRA_DIST = $(gsettings_SCHEMAS)
 *
 * @GSETTINGS_RULES@
 * ]|
 *
 * No changes are needed to the build system to mark a schema XML file for
 * translation. Assuming it sets the `gettext-domain` attribute, a schema may
 * be marked for translation by adding it to `POTFILES.in`, assuming gettext
 * 0.19 is in use (the preferred method for translation):
 * |[
 * data/org.foo.MyApp.gschema.xml
 * ]|
 *
 * Alternatively, if intltool 0.50.1 is in use:
 * |[
 * [type: gettext/gsettings]data/org.foo.MyApp.gschema.xml
 * ]|
 *
 * GSettings will use gettext to look up translations for the <summary> and
 * <description> elements, and also any <default> elements which have a `l10n`
 * attribute set. Translations must not be included in the `.gschema.xml` file
 * by the build system, for example by using intltool XML rules with a
 * `.gschema.xml.in` template.
 *
 * If an enumerated type defined in a C header file is to be used in a GSettings
 * schema, it can either be defined manually using an <enum> element in the
 * schema XML, or it can be extracted automatically from the C header. This
 * approach is preferred, as it ensures the two representations are always
 * synchronised. To do so, add the following to the relevant `Makefile.am`:
 * |[
 * gsettings_ENUM_NAMESPACE = org.foo.MyApp
 * gsettings_ENUM_FILES = my-app-enums.h my-app-misc.h
 * ]|
 *
 * `gsettings_ENUM_NAMESPACE` specifies the schema namespace for the enum files,
 * which are specified in `gsettings_ENUM_FILES`. This will generate a
 * `org.foo.MyApp.enums.xml` file containing the extracted enums, which will be
 * automatically included in the schema compilation, install and uninstall
 * rules. It should not be committed to version control or included in
 * `EXTRA_DIST`.
 */


/**
 * SECTION:gsettingsbackend
 * @title: GSettingsBackend
 * @short_description: Interface for settings backend implementations
 * @include: gio/gsettingsbackend.h
 * @see_also: #GSettings, #GIOExtensionPoint
 *
 * The #GSettingsBackend interface defines a generic interface for
 * non-strictly-typed data that is stored in a hierarchy. To implement
 * an alternative storage backend for #GSettings, you need to implement
 * the #GSettingsBackend interface and then make it implement the
 * extension point %G_SETTINGS_BACKEND_EXTENSION_POINT_NAME.
 *
 * The interface defines methods for reading and writing values, a
 * method for determining if writing of certain values will fail
 * (lockdown) and a change notification mechanism.
 *
 * The semantics of the interface are very precisely defined and
 * implementations must carefully adhere to the expectations of
 * callers that are documented on each of the interface methods.
 *
 * Some of the #GSettingsBackend functions accept or return a #GTree.
 * These trees always have strings as keys and #GVariant as values.
 * g_settings_backend_create_tree() is a convenience function to create
 * suitable trees.
 *
 * The #GSettingsBackend API is exported to allow third-party
 * implementations, but does not carry the same stability guarantees
 * as the public GIO API. For this reason, you have to define the
 * C preprocessor symbol %G_SETTINGS_ENABLE_BACKEND before including
 * `gio/gsettingsbackend.h`.
 */


/**
 * SECTION:gsettingsschema
 * @short_description: Introspecting and controlling the loading
 *     of GSettings schemas
 * @include: gio/gio.h
 *
 * The #GSettingsSchemaSource and #GSettingsSchema APIs provide a
 * mechanism for advanced control over the loading of schemas and a
 * mechanism for introspecting their content.
 *
 * Plugin loading systems that wish to provide plugins a way to access
 * settings face the problem of how to make the schemas for these
 * settings visible to GSettings.  Typically, a plugin will want to ship
 * the schema along with itself and it won't be installed into the
 * standard system directories for schemas.
 *
 * #GSettingsSchemaSource provides a mechanism for dealing with this by
 * allowing the creation of a new 'schema source' from which schemas can
 * be acquired.  This schema source can then become part of the metadata
 * associated with the plugin and queried whenever the plugin requires
 * access to some settings.
 *
 * Consider the following example:
 *
 * |[<!-- language="C" -->
 * typedef struct
 * {
 *    ...
 *    GSettingsSchemaSource *schema_source;
 *    ...
 * } Plugin;
 *
 * Plugin *
 * initialise_plugin (const gchar *dir)
 * {
 *   Plugin *plugin;
 *
 *   ...
 *
 *   plugin->schema_source =
 *     g_settings_schema_source_new_from_directory (dir,
 *       g_settings_schema_source_get_default (), FALSE, NULL);
 *
 *   ...
 *
 *   return plugin;
 * }
 *
 * ...
 *
 * GSettings *
 * plugin_get_settings (Plugin      *plugin,
 *                      const gchar *schema_id)
 * {
 *   GSettingsSchema *schema;
 *
 *   if (schema_id == NULL)
 *     schema_id = plugin->identifier;
 *
 *   schema = g_settings_schema_source_lookup (plugin->schema_source,
 *                                             schema_id, FALSE);
 *
 *   if (schema == NULL)
 *     {
 *       ... disable the plugin or abort, etc ...
 *     }
 *
 *   return g_settings_new_full (schema, NULL, NULL);
 * }
 * ]|
 *
 * The code above shows how hooks should be added to the code that
 * initialises (or enables) the plugin to create the schema source and
 * how an API can be added to the plugin system to provide a convenient
 * way for the plugin to access its settings, using the schemas that it
 * ships.
 *
 * From the standpoint of the plugin, it would need to ensure that it
 * ships a gschemas.compiled file as part of itself, and then simply do
 * the following:
 *
 * |[<!-- language="C" -->
 * {
 *   GSettings *settings;
 *   gint some_value;
 *
 *   settings = plugin_get_settings (self, NULL);
 *   some_value = g_settings_get_int (settings, "some-value");
 *   ...
 * }
 * ]|
 *
 * It's also possible that the plugin system expects the schema source
 * files (ie: .gschema.xml files) instead of a gschemas.compiled file.
 * In that case, the plugin loading system must compile the schemas for
 * itself before attempting to create the settings source.
 *
 * Since: 2.32
 */


/**
 * SECTION:gsimpleaction
 * @title: GSimpleAction
 * @short_description: A simple GAction implementation
 * @include: gio/gio.h
 *
 * A #GSimpleAction is the obvious simple implementation of the #GAction
 * interface. This is the easiest way to create an action for purposes of
 * adding it to a #GSimpleActionGroup.
 *
 * See also #GtkAction.
 */


/**
 * SECTION:gsimpleactiongroup
 * @title: GSimpleActionGroup
 * @short_description: A simple GActionGroup implementation
 * @include: gio/gio.h
 *
 * #GSimpleActionGroup is a hash table filled with #GAction objects,
 * implementing the #GActionGroup and #GActionMap interfaces.
 */


/**
 * SECTION:gsimpleasyncresult
 * @short_description: Simple asynchronous results implementation
 * @include: gio/gio.h
 * @see_also: #GAsyncResult, #GTask
 *
 * As of GLib 2.46, #GSimpleAsyncResult is deprecated in favor of
 * #GTask, which provides a simpler API.
 *
 * #GSimpleAsyncResult implements #GAsyncResult.
 *
 * GSimpleAsyncResult handles #GAsyncReadyCallbacks, error
 * reporting, operation cancellation and the final state of an operation,
 * completely transparent to the application. Results can be returned
 * as a pointer e.g. for functions that return data that is collected
 * asynchronously, a boolean value for checking the success or failure
 * of an operation, or a #gssize for operations which return the number
 * of bytes modified by the operation; all of the simple return cases
 * are covered.
 *
 * Most of the time, an application will not need to know of the details
 * of this API; it is handled transparently, and any necessary operations
 * are handled by #GAsyncResult's interface. However, if implementing a
 * new GIO module, for writing language bindings, or for complex
 * applications that need better control of how asynchronous operations
 * are completed, it is important to understand this functionality.
 *
 * GSimpleAsyncResults are tagged with the calling function to ensure
 * that asynchronous functions and their finishing functions are used
 * together correctly.
 *
 * To create a new #GSimpleAsyncResult, call g_simple_async_result_new().
 * If the result needs to be created for a #GError, use
 * g_simple_async_result_new_from_error() or
 * g_simple_async_result_new_take_error(). If a #GError is not available
 * (e.g. the asynchronous operation's doesn't take a #GError argument),
 * but the result still needs to be created for an error condition, use
 * g_simple_async_result_new_error() (or g_simple_async_result_set_error_va()
 * if your application or binding requires passing a variable argument list
 * directly), and the error can then be propagated through the use of
 * g_simple_async_result_propagate_error().
 *
 * An asynchronous operation can be made to ignore a cancellation event by
 * calling g_simple_async_result_set_handle_cancellation() with a
 * #GSimpleAsyncResult for the operation and %FALSE. This is useful for
 * operations that are dangerous to cancel, such as close (which would
 * cause a leak if cancelled before being run).
 *
 * GSimpleAsyncResult can integrate into GLib's event loop, #GMainLoop,
 * or it can use #GThreads.
 * g_simple_async_result_complete() will finish an I/O task directly
 * from the point where it is called. g_simple_async_result_complete_in_idle()
 * will finish it from an idle handler in the
 * [thread-default main context][g-main-context-push-thread-default]
 * where the #GSimpleAsyncResult was created.
 * g_simple_async_result_run_in_thread() will run the job in a
 * separate thread and then use
 * g_simple_async_result_complete_in_idle() to deliver the result.
 *
 * To set the results of an asynchronous function,
 * g_simple_async_result_set_op_res_gpointer(),
 * g_simple_async_result_set_op_res_gboolean(), and
 * g_simple_async_result_set_op_res_gssize()
 * are provided, setting the operation's result to a gpointer, gboolean, or
 * gssize, respectively.
 *
 * Likewise, to get the result of an asynchronous function,
 * g_simple_async_result_get_op_res_gpointer(),
 * g_simple_async_result_get_op_res_gboolean(), and
 * g_simple_async_result_get_op_res_gssize() are
 * provided, getting the operation's result as a gpointer, gboolean, and
 * gssize, respectively.
 *
 * For the details of the requirements implementations must respect, see
 * #GAsyncResult.  A typical implementation of an asynchronous operation
 * using GSimpleAsyncResult looks something like this:
 *
 * |[<!-- language="C" -->
 * static void
 * baked_cb (Cake    *cake,
 *           gpointer user_data)
 * {
 *   // In this example, this callback is not given a reference to the cake,
 *   // so the GSimpleAsyncResult has to take a reference to it.
 *   GSimpleAsyncResult *result = user_data;
 *
 *   if (cake == NULL)
 *     g_simple_async_result_set_error (result,
 *                                      BAKER_ERRORS,
 *                                      BAKER_ERROR_NO_FLOUR,
 *                                      "Go to the supermarket");
 *   else
 *     g_simple_async_result_set_op_res_gpointer (result,
 *                                                g_object_ref (cake),
 *                                                g_object_unref);
 *
 *
 *   // In this example, we assume that baked_cb is called as a callback from
 *   // the mainloop, so it's safe to complete the operation synchronously here.
 *   // If, however, _baker_prepare_cake () might call its callback without
 *   // first returning to the mainloop — inadvisable, but some APIs do so —
 *   // we would need to use g_simple_async_result_complete_in_idle().
 *   g_simple_async_result_complete (result);
 *   g_object_unref (result);
 * }
 *
 * void
 * baker_bake_cake_async (Baker              *self,
 *                        guint               radius,
 *                        GAsyncReadyCallback callback,
 *                        gpointer            user_data)
 * {
 *   GSimpleAsyncResult *simple;
 *   Cake               *cake;
 *
 *   if (radius < 3)
 *     {
 *       g_simple_async_report_error_in_idle (G_OBJECT (self),
 *                                            callback,
 *                                            user_data,
 *                                            BAKER_ERRORS,
 *                                            BAKER_ERROR_TOO_SMALL,
 *                                            "%ucm radius cakes are silly",
 *                                            radius);
 *       return;
 *     }
 *
 *   simple = g_simple_async_result_new (G_OBJECT (self),
 *                                       callback,
 *                                       user_data,
 *                                       baker_bake_cake_async);
 *   cake = _baker_get_cached_cake (self, radius);
 *
 *   if (cake != NULL)
 *     {
 *       g_simple_async_result_set_op_res_gpointer (simple,
 *                                                  g_object_ref (cake),
 *                                                  g_object_unref);
 *       g_simple_async_result_complete_in_idle (simple);
 *       g_object_unref (simple);
 *       // Drop the reference returned by _baker_get_cached_cake();
 *       // the GSimpleAsyncResult has taken its own reference.
 *       g_object_unref (cake);
 *       return;
 *     }
 *
 *   _baker_prepare_cake (self, radius, baked_cb, simple);
 * }
 *
 * Cake *
 * baker_bake_cake_finish (Baker        *self,
 *                         GAsyncResult *result,
 *                         GError      **error)
 * {
 *   GSimpleAsyncResult *simple;
 *   Cake               *cake;
 *
 *   g_return_val_if_fail (g_simple_async_result_is_valid (result,
 *                                                         G_OBJECT (self),
 *                                                         baker_bake_cake_async),
 *                         NULL);
 *
 *   simple = (GSimpleAsyncResult *) result;
 *
 *   if (g_simple_async_result_propagate_error (simple, error))
 *     return NULL;
 *
 *   cake = CAKE (g_simple_async_result_get_op_res_gpointer (simple));
 *   return g_object_ref (cake);
 * }
 * ]|
 */


/**
 * SECTION:gsimpleiostream
 * @short_description: A wrapper around an input and an output stream.
 * @include: gio/gio.h
 * @see_also: #GIOStream
 *
 * GSimpleIOStream creates a #GIOStream from an arbitrary #GInputStream and
 * #GOutputStream. This allows any pair of input and output streams to be used
 * with #GIOStream methods.
 *
 * This is useful when you obtained a #GInputStream and a #GOutputStream
 * by other means, for instance creating them with platform specific methods as
 * g_unix_input_stream_new() or g_win32_input_stream_new(), and you want
 * to take advantage of the methods provided by #GIOStream.
 *
 * Since: 2.44
 */


/**
 * SECTION:gsimplepermission
 * @title: GSimplePermission
 * @short_description: A GPermission that doesn't change value
 * @include: gio/gio.h
 *
 * #GSimplePermission is a trivial implementation of #GPermission that
 * represents a permission that is either always or never allowed.  The
 * value is given at construction and doesn't change.
 *
 * Calling request or release will result in errors.
 */


/**
 * SECTION:gsimpleproxyresolver
 * @short_description: Simple proxy resolver implementation
 * @include: gio/gio.h
 * @see_also: g_socket_client_set_proxy_resolver()
 *
 * #GSimpleProxyResolver is a simple #GProxyResolver implementation
 * that handles a single default proxy, multiple URI-scheme-specific
 * proxies, and a list of hosts that proxies should not be used for.
 *
 * #GSimpleProxyResolver is never the default proxy resolver, but it
 * can be used as the base class for another proxy resolver
 * implementation, or it can be created and used manually, such as
 * with g_socket_client_set_proxy_resolver().
 *
 * Since: 2.36
 */


/**
 * SECTION:gsocket
 * @short_description: Low-level socket object
 * @include: gio/gio.h
 * @see_also: #GInitable, [<gnetworking.h>][gio-gnetworking.h]
 *
 * A #GSocket is a low-level networking primitive. It is a more or less
 * direct mapping of the BSD socket API in a portable GObject based API.
 * It supports both the UNIX socket implementations and winsock2 on Windows.
 *
 * #GSocket is the platform independent base upon which the higher level
 * network primitives are based. Applications are not typically meant to
 * use it directly, but rather through classes like #GSocketClient,
 * #GSocketService and #GSocketConnection. However there may be cases where
 * direct use of #GSocket is useful.
 *
 * #GSocket implements the #GInitable interface, so if it is manually constructed
 * by e.g. g_object_new() you must call g_initable_init() and check the
 * results before using the object. This is done automatically in
 * g_socket_new() and g_socket_new_from_fd(), so these functions can return
 * %NULL.
 *
 * Sockets operate in two general modes, blocking or non-blocking. When
 * in blocking mode all operations (which don’t take an explicit blocking
 * parameter) block until the requested operation
 * is finished or there is an error. In non-blocking mode all calls that
 * would block return immediately with a %G_IO_ERROR_WOULD_BLOCK error.
 * To know when a call would successfully run you can call g_socket_condition_check(),
 * or g_socket_condition_wait(). You can also use g_socket_create_source() and
 * attach it to a #GMainContext to get callbacks when I/O is possible.
 * Note that all sockets are always set to non blocking mode in the system, and
 * blocking mode is emulated in GSocket.
 *
 * When working in non-blocking mode applications should always be able to
 * handle getting a %G_IO_ERROR_WOULD_BLOCK error even when some other
 * function said that I/O was possible. This can easily happen in case
 * of a race condition in the application, but it can also happen for other
 * reasons. For instance, on Windows a socket is always seen as writable
 * until a write returns %G_IO_ERROR_WOULD_BLOCK.
 *
 * #GSockets can be either connection oriented or datagram based.
 * For connection oriented types you must first establish a connection by
 * either connecting to an address or accepting a connection from another
 * address. For connectionless socket types the target/source address is
 * specified or received in each I/O operation.
 *
 * All socket file descriptors are set to be close-on-exec.
 *
 * Note that creating a #GSocket causes the signal %SIGPIPE to be
 * ignored for the remainder of the program. If you are writing a
 * command-line utility that uses #GSocket, you may need to take into
 * account the fact that your program will not automatically be killed
 * if it tries to write to %stdout after it has been closed.
 *
 * Like most other APIs in GLib, #GSocket is not inherently thread safe. To use
 * a #GSocket concurrently from multiple threads, you must implement your own
 * locking.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketaddress
 * @short_description: Abstract base class representing endpoints
 *     for socket communication
 * @include: gio/gio.h
 *
 * #GSocketAddress is the equivalent of struct sockaddr in the BSD
 * sockets API. This is an abstract class; use #GInetSocketAddress
 * for internet sockets, or #GUnixSocketAddress for UNIX domain sockets.
 */


/**
 * SECTION:gsocketaddressenumerator
 * @short_description: Enumerator for socket addresses
 * @include: gio/gio.h
 *
 * #GSocketAddressEnumerator is an enumerator type for #GSocketAddress
 * instances. It is returned by enumeration functions such as
 * g_socket_connectable_enumerate(), which returns a #GSocketAddressEnumerator
 * to list each #GSocketAddress which could be used to connect to that
 * #GSocketConnectable.
 *
 * Enumeration is typically a blocking operation, so the asynchronous methods
 * g_socket_address_enumerator_next_async() and
 * g_socket_address_enumerator_next_finish() should be used where possible.
 *
 * Each #GSocketAddressEnumerator can only be enumerated once. Once
 * g_socket_address_enumerator_next() has returned %NULL, further
 * enumeration with that #GSocketAddressEnumerator is not possible, and it can
 * be unreffed.
 */


/**
 * SECTION:gsocketclient
 * @short_description: Helper for connecting to a network service
 * @include: gio/gio.h
 * @see_also: #GSocketConnection, #GSocketListener
 *
 * #GSocketClient is a lightweight high-level utility class for connecting to
 * a network host using a connection oriented socket type.
 *
 * You create a #GSocketClient object, set any options you want, and then
 * call a sync or async connect operation, which returns a #GSocketConnection
 * subclass on success.
 *
 * The type of the #GSocketConnection object returned depends on the type of
 * the underlying socket that is in use. For instance, for a TCP/IP connection
 * it will be a #GTcpConnection.
 *
 * As #GSocketClient is a lightweight object, you don't need to cache it. You
 * can just create a new one any time you need one.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketconnectable
 * @short_description: Interface for potential socket endpoints
 * @include: gio/gio.h
 *
 * Objects that describe one or more potential socket endpoints
 * implement #GSocketConnectable. Callers can then use
 * g_socket_connectable_enumerate() to get a #GSocketAddressEnumerator
 * to try out each socket address in turn until one succeeds, as shown
 * in the sample code below.
 *
 * |[<!-- language="C" -->
 * MyConnectionType *
 * connect_to_host (const char    *hostname,
 *                  guint16        port,
 *                  GCancellable  *cancellable,
 *                  GError       **error)
 * {
 *   MyConnection *conn = NULL;
 *   GSocketConnectable *addr;
 *   GSocketAddressEnumerator *enumerator;
 *   GSocketAddress *sockaddr;
 *   GError *conn_error = NULL;
 *
 *   addr = g_network_address_new (hostname, port);
 *   enumerator = g_socket_connectable_enumerate (addr);
 *   g_object_unref (addr);
 *
 *   // Try each sockaddr until we succeed. Record the first connection error,
 *   // but not any further ones (since they'll probably be basically the same
 *   // as the first).
 *   while (!conn && (sockaddr = g_socket_address_enumerator_next (enumerator, cancellable, error))
 *     {
 *       conn = connect_to_sockaddr (sockaddr, conn_error ? NULL : &conn_error);
 *       g_object_unref (sockaddr);
 *     }
 *   g_object_unref (enumerator);
 *
 *   if (conn)
 *     {
 *       if (conn_error)
 *         {
 *           // We couldn't connect to the first address, but we succeeded
 *           // in connecting to a later address.
 *           g_error_free (conn_error);
 *         }
 *       return conn;
 *     }
 *   else if (error)
 *     {
 *       /// Either initial lookup failed, or else the caller cancelled us.
 *       if (conn_error)
 *         g_error_free (conn_error);
 *       return NULL;
 *     }
 *   else
 *     {
 *       g_error_propagate (error, conn_error);
 *       return NULL;
 *     }
 * }
 * ]|
 */


/**
 * SECTION:gsocketconnection
 * @short_description: A socket connection
 * @include: gio/gio.h
 * @see_also: #GIOStream, #GSocketClient, #GSocketListener
 *
 * #GSocketConnection is a #GIOStream for a connected socket. They
 * can be created either by #GSocketClient when connecting to a host,
 * or by #GSocketListener when accepting a new client.
 *
 * The type of the #GSocketConnection object returned from these calls
 * depends on the type of the underlying socket that is in use. For
 * instance, for a TCP/IP connection it will be a #GTcpConnection.
 *
 * Choosing what type of object to construct is done with the socket
 * connection factory, and it is possible for 3rd parties to register
 * custom socket connection types for specific combination of socket
 * family/type/protocol using g_socket_connection_factory_register_type().
 *
 * To close a #GSocketConnection, use g_io_stream_close(). Closing both
 * substreams of the #GIOStream separately will not close the underlying
 * #GSocket.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketcontrolmessage
 * @title: GSocketControlMessage
 * @short_description: A GSocket control message
 * @include: gio/gio.h
 * @see_also: #GSocket.
 *
 * A #GSocketControlMessage is a special-purpose utility message that
 * can be sent to or received from a #GSocket. These types of
 * messages are often called "ancillary data".
 *
 * The message can represent some sort of special instruction to or
 * information from the socket or can represent a special kind of
 * transfer to the peer (for example, sending a file descriptor over
 * a UNIX socket).
 *
 * These messages are sent with g_socket_send_message() and received
 * with g_socket_receive_message().
 *
 * To extend the set of control message that can be sent, subclass this
 * class and override the get_size, get_level, get_type and serialize
 * methods.
 *
 * To extend the set of control messages that can be received, subclass
 * this class and implement the deserialize method. Also, make sure your
 * class is registered with the GType typesystem before calling
 * g_socket_receive_message() to read such a message.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketlistener
 * @title: GSocketListener
 * @short_description: Helper for accepting network client connections
 * @include: gio/gio.h
 * @see_also: #GThreadedSocketService, #GSocketService.
 *
 * A #GSocketListener is an object that keeps track of a set
 * of server sockets and helps you accept sockets from any of the
 * socket, either sync or async.
 *
 * Add addresses and ports to listen on using g_socket_listener_add_address()
 * and g_socket_listener_add_inet_port(). These will be listened on until
 * g_socket_listener_close() is called. Dropping your final reference to the
 * #GSocketListener will not cause g_socket_listener_close() to be called
 * implicitly, as some references to the #GSocketListener may be held
 * internally.
 *
 * If you want to implement a network server, also look at #GSocketService
 * and #GThreadedSocketService which are subclasses of #GSocketListener
 * that make this even easier.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketservice
 * @title: GSocketService
 * @short_description: Make it easy to implement a network service
 * @include: gio/gio.h
 * @see_also: #GThreadedSocketService, #GSocketListener.
 *
 * A #GSocketService is an object that represents a service that
 * is provided to the network or over local sockets.  When a new
 * connection is made to the service the #GSocketService::incoming
 * signal is emitted.
 *
 * A #GSocketService is a subclass of #GSocketListener and you need
 * to add the addresses you want to accept connections on with the
 * #GSocketListener APIs.
 *
 * There are two options for implementing a network service based on
 * #GSocketService. The first is to create the service using
 * g_socket_service_new() and to connect to the #GSocketService::incoming
 * signal. The second is to subclass #GSocketService and override the
 * default signal handler implementation.
 *
 * In either case, the handler must immediately return, or else it
 * will block additional incoming connections from being serviced.
 * If you are interested in writing connection handlers that contain
 * blocking code then see #GThreadedSocketService.
 *
 * The socket service runs on the main loop of the
 * [thread-default context][g-main-context-push-thread-default-context]
 * of the thread it is created in, and is not
 * threadsafe in general. However, the calls to start and stop the
 * service are thread-safe so these can be used from threads that
 * handle incoming clients.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsrvtarget
 * @short_description: DNS SRV record target
 * @include: gio/gio.h
 *
 * SRV (service) records are used by some network protocols to provide
 * service-specific aliasing and load-balancing. For example, XMPP
 * (Jabber) uses SRV records to locate the XMPP server for a domain;
 * rather than connecting directly to "example.com" or assuming a
 * specific server hostname like "xmpp.example.com", an XMPP client
 * would look up the "xmpp-client" SRV record for "example.com", and
 * then connect to whatever host was pointed to by that record.
 *
 * You can use g_resolver_lookup_service() or
 * g_resolver_lookup_service_async() to find the #GSrvTargets
 * for a given service. However, if you are simply planning to connect
 * to the remote service, you can use #GNetworkService's
 * #GSocketConnectable interface and not need to worry about
 * #GSrvTarget at all.
 */


/**
 * SECTION:gsubprocess
 * @title: GSubprocess
 * @short_description: Child processes
 * @include: gio/gio.h
 * @see_also: #GSubprocessLauncher
 *
 * #GSubprocess allows the creation of and interaction with child
 * processes.
 *
 * Processes can be communicated with using standard GIO-style APIs (ie:
 * #GInputStream, #GOutputStream).  There are GIO-style APIs to wait for
 * process termination (ie: cancellable and with an asynchronous
 * variant).
 *
 * There is an API to force a process to terminate, as well as a
 * race-free API for sending UNIX signals to a subprocess.
 *
 * One major advantage that GIO brings over the core GLib library is
 * comprehensive API for asynchronous I/O, such
 * g_output_stream_splice_async().  This makes GSubprocess
 * significantly more powerful and flexible than equivalent APIs in
 * some other languages such as the `subprocess.py`
 * included with Python.  For example, using #GSubprocess one could
 * create two child processes, reading standard output from the first,
 * processing it, and writing to the input stream of the second, all
 * without blocking the main loop.
 *
 * A powerful g_subprocess_communicate() API is provided similar to the
 * `communicate()` method of `subprocess.py`. This enables very easy
 * interaction with a subprocess that has been opened with pipes.
 *
 * #GSubprocess defaults to tight control over the file descriptors open
 * in the child process, avoiding dangling-fd issues that are caused by
 * a simple fork()/exec().  The only open file descriptors in the
 * spawned process are ones that were explicitly specified by the
 * #GSubprocess API (unless %G_SUBPROCESS_FLAGS_INHERIT_FDS was
 * specified).
 *
 * #GSubprocess will quickly reap all child processes as they exit,
 * avoiding "zombie processes" remaining around for long periods of
 * time.  g_subprocess_wait() can be used to wait for this to happen,
 * but it will happen even without the call being explicitly made.
 *
 * As a matter of principle, #GSubprocess has no API that accepts
 * shell-style space-separated strings.  It will, however, match the
 * typical shell behaviour of searching the PATH for executables that do
 * not contain a directory separator in their name. By default, the `PATH`
 * of the current process is used.  You can specify
 * %G_SUBPROCESS_FLAGS_SEARCH_PATH_FROM_ENVP to use the `PATH` of the
 * launcher environment instead.
 *
 * #GSubprocess attempts to have a very simple API for most uses (ie:
 * spawning a subprocess with arguments and support for most typical
 * kinds of input and output redirection).  See g_subprocess_new(). The
 * #GSubprocessLauncher API is provided for more complicated cases
 * (advanced types of redirection, environment variable manipulation,
 * change of working directory, child setup functions, etc).
 *
 * A typical use of #GSubprocess will involve calling
 * g_subprocess_new(), followed by g_subprocess_wait_async() or
 * g_subprocess_wait().  After the process exits, the status can be
 * checked using functions such as g_subprocess_get_if_exited() (which
 * are similar to the familiar WIFEXITED-style POSIX macros).
 *
 * Since: 2.40
 */


/**
 * SECTION:gsubprocesslauncher
 * @title: GSubprocess Launcher
 * @short_description: Environment options for launching a child process
 * @include: gio/gio.h
 *
 * This class contains a set of options for launching child processes,
 * such as where its standard input and output will be directed, the
 * argument list, the environment, and more.
 *
 * While the #GSubprocess class has high level functions covering
 * popular cases, use of this class allows access to more advanced
 * options.  It can also be used to launch multiple subprocesses with
 * a similar configuration.
 *
 * Since: 2.40
 */


/**
 * SECTION:gtask
 * @short_description: Cancellable synchronous or asynchronous task
 *     and result
 * @include: gio/gio.h
 * @see_also: #GAsyncResult
 *
 * A #GTask represents and manages a cancellable "task".
 *
 * ## Asynchronous operations
 *
 * The most common usage of #GTask is as a #GAsyncResult, to
 * manage data during an asynchronous operation. You call
 * g_task_new() in the "start" method, followed by
 * g_task_set_task_data() and the like if you need to keep some
 * additional data associated with the task, and then pass the
 * task object around through your asynchronous operation.
 * Eventually, you will call a method such as
 * g_task_return_pointer() or g_task_return_error(), which will
 * save the value you give it and then invoke the task's callback
 * function in the
 * [thread-default main context][g-main-context-push-thread-default]
 * where it was created (waiting until the next iteration of the main
 * loop first, if necessary). The caller will pass the #GTask back to
 * the operation's finish function (as a #GAsyncResult), and you can
 * use g_task_propagate_pointer() or the like to extract the
 * return value.
 *
 * Using #GTask requires the thread-default #GMainContext from when the
 * #GTask was constructed to be running at least until the task has completed
 * and its data has been freed.
 *
 * If a #GTask has been constructed and its callback set, it is an error to
 * not call `g_task_return_*()` on it. GLib will warn at runtime if this happens
 * (since 2.76).
 *
 * Here is an example for using GTask as a GAsyncResult:
 * |[<!-- language="C" -->
 *     typedef struct {
 *       CakeFrostingType frosting;
 *       char *message;
 *     } DecorationData;
 *
 *     static void
 *     decoration_data_free (DecorationData *decoration)
 *     {
 *       g_free (decoration->message);
 *       g_slice_free (DecorationData, decoration);
 *     }
 *
 *     static void
 *     baked_cb (Cake     *cake,
 *               gpointer  user_data)
 *     {
 *       GTask *task = user_data;
 *       DecorationData *decoration = g_task_get_task_data (task);
 *       GError *error = NULL;
 *
 *       if (cake == NULL)
 *         {
 *           g_task_return_new_error (task, BAKER_ERROR, BAKER_ERROR_NO_FLOUR,
 *                                    "Go to the supermarket");
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       if (!cake_decorate (cake, decoration->frosting, decoration->message, &error))
 *         {
 *           g_object_unref (cake);
 *           // g_task_return_error() takes ownership of error
 *           g_task_return_error (task, error);
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       g_task_return_pointer (task, cake, g_object_unref);
 *       g_object_unref (task);
 *     }
 *
 *     void
 *     baker_bake_cake_async (Baker               *self,
 *                            guint                radius,
 *                            CakeFlavor           flavor,
 *                            CakeFrostingType     frosting,
 *                            const char          *message,
 *                            GCancellable        *cancellable,
 *                            GAsyncReadyCallback  callback,
 *                            gpointer             user_data)
 *     {
 *       GTask *task;
 *       DecorationData *decoration;
 *       Cake  *cake;
 *
 *       task = g_task_new (self, cancellable, callback, user_data);
 *       if (radius < 3)
 *         {
 *           g_task_return_new_error (task, BAKER_ERROR, BAKER_ERROR_TOO_SMALL,
 *                                    "%ucm radius cakes are silly",
 *                                    radius);
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       cake = _baker_get_cached_cake (self, radius, flavor, frosting, message);
 *       if (cake != NULL)
 *         {
 *           // _baker_get_cached_cake() returns a reffed cake
 *           g_task_return_pointer (task, cake, g_object_unref);
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       decoration = g_slice_new (DecorationData);
 *       decoration->frosting = frosting;
 *       decoration->message = g_strdup (message);
 *       g_task_set_task_data (task, decoration, (GDestroyNotify) decoration_data_free);
 *
 *       _baker_begin_cake (self, radius, flavor, cancellable, baked_cb, task);
 *     }
 *
 *     Cake *
 *     baker_bake_cake_finish (Baker         *self,
 *                             GAsyncResult  *result,
 *                             GError       **error)
 *     {
 *       g_return_val_if_fail (g_task_is_valid (result, self), NULL);
 *
 *       return g_task_propagate_pointer (G_TASK (result), error);
 *     }
 * ]|
 *
 * ## Chained asynchronous operations
 *
 * #GTask also tries to simplify asynchronous operations that
 * internally chain together several smaller asynchronous
 * operations. g_task_get_cancellable(), g_task_get_context(),
 * and g_task_get_priority() allow you to get back the task's
 * #GCancellable, #GMainContext, and [I/O priority][io-priority]
 * when starting a new subtask, so you don't have to keep track
 * of them yourself. g_task_attach_source() simplifies the case
 * of waiting for a source to fire (automatically using the correct
 * #GMainContext and priority).
 *
 * Here is an example for chained asynchronous operations:
 *   |[<!-- language="C" -->
 *     typedef struct {
 *       Cake *cake;
 *       CakeFrostingType frosting;
 *       char *message;
 *     } BakingData;
 *
 *     static void
 *     decoration_data_free (BakingData *bd)
 *     {
 *       if (bd->cake)
 *         g_object_unref (bd->cake);
 *       g_free (bd->message);
 *       g_slice_free (BakingData, bd);
 *     }
 *
 *     static void
 *     decorated_cb (Cake         *cake,
 *                   GAsyncResult *result,
 *                   gpointer      user_data)
 *     {
 *       GTask *task = user_data;
 *       GError *error = NULL;
 *
 *       if (!cake_decorate_finish (cake, result, &error))
 *         {
 *           g_object_unref (cake);
 *           g_task_return_error (task, error);
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       // baking_data_free() will drop its ref on the cake, so we have to
 *       // take another here to give to the caller.
 *       g_task_return_pointer (task, g_object_ref (cake), g_object_unref);
 *       g_object_unref (task);
 *     }
 *
 *     static gboolean
 *     decorator_ready (gpointer user_data)
 *     {
 *       GTask *task = user_data;
 *       BakingData *bd = g_task_get_task_data (task);
 *
 *       cake_decorate_async (bd->cake, bd->frosting, bd->message,
 *                            g_task_get_cancellable (task),
 *                            decorated_cb, task);
 *
 *       return G_SOURCE_REMOVE;
 *     }
 *
 *     static void
 *     baked_cb (Cake     *cake,
 *               gpointer  user_data)
 *     {
 *       GTask *task = user_data;
 *       BakingData *bd = g_task_get_task_data (task);
 *       GError *error = NULL;
 *
 *       if (cake == NULL)
 *         {
 *           g_task_return_new_error (task, BAKER_ERROR, BAKER_ERROR_NO_FLOUR,
 *                                    "Go to the supermarket");
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       bd->cake = cake;
 *
 *       // Bail out now if the user has already cancelled
 *       if (g_task_return_error_if_cancelled (task))
 *         {
 *           g_object_unref (task);
 *           return;
 *         }
 *
 *       if (cake_decorator_available (cake))
 *         decorator_ready (task);
 *       else
 *         {
 *           GSource *source;
 *
 *           source = cake_decorator_wait_source_new (cake);
 *           // Attach @source to @task's GMainContext and have it call
 *           // decorator_ready() when it is ready.
 *           g_task_attach_source (task, source, decorator_ready);
 *           g_source_unref (source);
 *         }
 *     }
 *
 *     void
 *     baker_bake_cake_async (Baker               *self,
 *                            guint                radius,
 *                            CakeFlavor           flavor,
 *                            CakeFrostingType     frosting,
 *                            const char          *message,
 *                            gint                 priority,
 *                            GCancellable        *cancellable,
 *                            GAsyncReadyCallback  callback,
 *                            gpointer             user_data)
 *     {
 *       GTask *task;
 *       BakingData *bd;
 *
 *       task = g_task_new (self, cancellable, callback, user_data);
 *       g_task_set_priority (task, priority);
 *
 *       bd = g_slice_new0 (BakingData);
 *       bd->frosting = frosting;
 *       bd->message = g_strdup (message);
 *       g_task_set_task_data (task, bd, (GDestroyNotify) baking_data_free);
 *
 *       _baker_begin_cake (self, radius, flavor, cancellable, baked_cb, task);
 *     }
 *
 *     Cake *
 *     baker_bake_cake_finish (Baker         *self,
 *                             GAsyncResult  *result,
 *                             GError       **error)
 *     {
 *       g_return_val_if_fail (g_task_is_valid (result, self), NULL);
 *
 *       return g_task_propagate_pointer (G_TASK (result), error);
 *     }
 * ]|
 *
 * ## Asynchronous operations from synchronous ones
 *
 * You can use g_task_run_in_thread() to turn a synchronous
 * operation into an asynchronous one, by running it in a thread.
 * When it completes, the result will be dispatched to the
 * [thread-default main context][g-main-context-push-thread-default]
 * where the #GTask was created.
 *
 * Running a task in a thread:
 *   |[<!-- language="C" -->
 *     typedef struct {
 *       guint radius;
 *       CakeFlavor flavor;
 *       CakeFrostingType frosting;
 *       char *message;
 *     } CakeData;
 *
 *     static void
 *     cake_data_free (CakeData *cake_data)
 *     {
 *       g_free (cake_data->message);
 *       g_slice_free (CakeData, cake_data);
 *     }
 *
 *     static void
 *     bake_cake_thread (GTask         *task,
 *                       gpointer       source_object,
 *                       gpointer       task_data,
 *                       GCancellable  *cancellable)
 *     {
 *       Baker *self = source_object;
 *       CakeData *cake_data = task_data;
 *       Cake *cake;
 *       GError *error = NULL;
 *
 *       cake = bake_cake (baker, cake_data->radius, cake_data->flavor,
 *                         cake_data->frosting, cake_data->message,
 *                         cancellable, &error);
 *       if (cake)
 *         g_task_return_pointer (task, cake, g_object_unref);
 *       else
 *         g_task_return_error (task, error);
 *     }
 *
 *     void
 *     baker_bake_cake_async (Baker               *self,
 *                            guint                radius,
 *                            CakeFlavor           flavor,
 *                            CakeFrostingType     frosting,
 *                            const char          *message,
 *                            GCancellable        *cancellable,
 *                            GAsyncReadyCallback  callback,
 *                            gpointer             user_data)
 *     {
 *       CakeData *cake_data;
 *       GTask *task;
 *
 *       cake_data = g_slice_new (CakeData);
 *       cake_data->radius = radius;
 *       cake_data->flavor = flavor;
 *       cake_data->frosting = frosting;
 *       cake_data->message = g_strdup (message);
 *       task = g_task_new (self, cancellable, callback, user_data);
 *       g_task_set_task_data (task, cake_data, (GDestroyNotify) cake_data_free);
 *       g_task_run_in_thread (task, bake_cake_thread);
 *       g_object_unref (task);
 *     }
 *
 *     Cake *
 *     baker_bake_cake_finish (Baker         *self,
 *                             GAsyncResult  *result,
 *                             GError       **error)
 *     {
 *       g_return_val_if_fail (g_task_is_valid (result, self), NULL);
 *
 *       return g_task_propagate_pointer (G_TASK (result), error);
 *     }
 * ]|
 *
 * ## Adding cancellability to uncancellable tasks
 *
 * Finally, g_task_run_in_thread() and g_task_run_in_thread_sync()
 * can be used to turn an uncancellable operation into a
 * cancellable one. If you call g_task_set_return_on_cancel(),
 * passing %TRUE, then if the task's #GCancellable is cancelled,
 * it will return control back to the caller immediately, while
 * allowing the task thread to continue running in the background
 * (and simply discarding its result when it finally does finish).
 * Provided that the task thread is careful about how it uses
 * locks and other externally-visible resources, this allows you
 * to make "GLib-friendly" asynchronous and cancellable
 * synchronous variants of blocking APIs.
 *
 * Cancelling a task:
 *   |[<!-- language="C" -->
 *     static void
 *     bake_cake_thread (GTask         *task,
 *                       gpointer       source_object,
 *                       gpointer       task_data,
 *                       GCancellable  *cancellable)
 *     {
 *       Baker *self = source_object;
 *       CakeData *cake_data = task_data;
 *       Cake *cake;
 *       GError *error = NULL;
 *
 *       cake = bake_cake (baker, cake_data->radius, cake_data->flavor,
 *                         cake_data->frosting, cake_data->message,
 *                         &error);
 *       if (error)
 *         {
 *           g_task_return_error (task, error);
 *           return;
 *         }
 *
 *       // If the task has already been cancelled, then we don't want to add
 *       // the cake to the cake cache. Likewise, we don't  want to have the
 *       // task get cancelled in the middle of updating the cache.
 *       // g_task_set_return_on_cancel() will return %TRUE here if it managed
 *       // to disable return-on-cancel, or %FALSE if the task was cancelled
 *       // before it could.
 *       if (g_task_set_return_on_cancel (task, FALSE))
 *         {
 *           // If the caller cancels at this point, their
 *           // GAsyncReadyCallback won't be invoked until we return,
 *           // so we don't have to worry that this code will run at
 *           // the same time as that code does. But if there were
 *           // other functions that might look at the cake cache,
 *           // then we'd probably need a GMutex here as well.
 *           baker_add_cake_to_cache (baker, cake);
 *           g_task_return_pointer (task, cake, g_object_unref);
 *         }
 *     }
 *
 *     void
 *     baker_bake_cake_async (Baker               *self,
 *                            guint                radius,
 *                            CakeFlavor           flavor,
 *                            CakeFrostingType     frosting,
 *                            const char          *message,
 *                            GCancellable        *cancellable,
 *                            GAsyncReadyCallback  callback,
 *                            gpointer             user_data)
 *     {
 *       CakeData *cake_data;
 *       GTask *task;
 *
 *       cake_data = g_slice_new (CakeData);
 *
 *       ...
 *
 *       task = g_task_new (self, cancellable, callback, user_data);
 *       g_task_set_task_data (task, cake_data, (GDestroyNotify) cake_data_free);
 *       g_task_set_return_on_cancel (task, TRUE);
 *       g_task_run_in_thread (task, bake_cake_thread);
 *     }
 *
 *     Cake *
 *     baker_bake_cake_sync (Baker               *self,
 *                           guint                radius,
 *                           CakeFlavor           flavor,
 *                           CakeFrostingType     frosting,
 *                           const char          *message,
 *                           GCancellable        *cancellable,
 *                           GError             **error)
 *     {
 *       CakeData *cake_data;
 *       GTask *task;
 *       Cake *cake;
 *
 *       cake_data = g_slice_new (CakeData);
 *
 *       ...
 *
 *       task = g_task_new (self, cancellable, NULL, NULL);
 *       g_task_set_task_data (task, cake_data, (GDestroyNotify) cake_data_free);
 *       g_task_set_return_on_cancel (task, TRUE);
 *       g_task_run_in_thread_sync (task, bake_cake_thread);
 *
 *       cake = g_task_propagate_pointer (task, error);
 *       g_object_unref (task);
 *       return cake;
 *     }
 * ]|
 *
 * ## Porting from GSimpleAsyncResult
 *
 * #GTask's API attempts to be simpler than #GSimpleAsyncResult's
 * in several ways:
 * - You can save task-specific data with g_task_set_task_data(), and
 *   retrieve it later with g_task_get_task_data(). This replaces the
 *   abuse of g_simple_async_result_set_op_res_gpointer() for the same
 *   purpose with #GSimpleAsyncResult.
 * - In addition to the task data, #GTask also keeps track of the
 *   [priority][io-priority], #GCancellable, and
 *   #GMainContext associated with the task, so tasks that consist of
 *   a chain of simpler asynchronous operations will have easy access
 *   to those values when starting each sub-task.
 * - g_task_return_error_if_cancelled() provides simplified
 *   handling for cancellation. In addition, cancellation
 *   overrides any other #GTask return value by default, like
 *   #GSimpleAsyncResult does when
 *   g_simple_async_result_set_check_cancellable() is called.
 *   (You can use g_task_set_check_cancellable() to turn off that
 *   behavior.) On the other hand, g_task_run_in_thread()
 *   guarantees that it will always run your
 *   `task_func`, even if the task's #GCancellable
 *   is already cancelled before the task gets a chance to run;
 *   you can start your `task_func` with a
 *   g_task_return_error_if_cancelled() check if you need the
 *   old behavior.
 * - The "return" methods (eg, g_task_return_pointer())
 *   automatically cause the task to be "completed" as well, and
 *   there is no need to worry about the "complete" vs "complete
 *   in idle" distinction. (#GTask automatically figures out
 *   whether the task's callback can be invoked directly, or
 *   if it needs to be sent to another #GMainContext, or delayed
 *   until the next iteration of the current #GMainContext.)
 * - The "finish" functions for #GTask based operations are generally
 *   much simpler than #GSimpleAsyncResult ones, normally consisting
 *   of only a single call to g_task_propagate_pointer() or the like.
 *   Since g_task_propagate_pointer() "steals" the return value from
 *   the #GTask, it is not necessary to juggle pointers around to
 *   prevent it from being freed twice.
 * - With #GSimpleAsyncResult, it was common to call
 *   g_simple_async_result_propagate_error() from the
 *   `_finish()` wrapper function, and have
 *   virtual method implementations only deal with successful
 *   returns. This behavior is deprecated, because it makes it
 *   difficult for a subclass to chain to a parent class's async
 *   methods. Instead, the wrapper function should just be a
 *   simple wrapper, and the virtual method should call an
 *   appropriate `g_task_propagate_` function.
 *   Note that wrapper methods can now use
 *   g_async_result_legacy_propagate_error() to do old-style
 *   #GSimpleAsyncResult error-returning behavior, and
 *   g_async_result_is_tagged() to check if a result is tagged as
 *   having come from the `_async()` wrapper
 *   function (for "short-circuit" results, such as when passing
 *   0 to g_input_stream_read_async()).
 *
 * ## Thread-safety considerations
 *
 * Due to some infelicities in the API design, there is a
 * thread-safety concern that users of GTask have to be aware of:
 *
 * If the `main` thread drops its last reference to the source object
 * or the task data before the task is finalized, then the finalizers
 * of these objects may be called on the worker thread.
 *
 * This is a problem if the finalizers use non-threadsafe API, and
 * can lead to hard-to-debug crashes. Possible workarounds include:
 *
 * - Clear task data in a signal handler for `notify::completed`
 *
 * - Keep iterating a main context in the main thread and defer
 *   dropping the reference to the source object to that main
 *   context when the task is finalized
 */


/**
 * SECTION:gtcpconnection
 * @title: GTcpConnection
 * @short_description: A TCP GSocketConnection
 * @include: gio/gio.h
 * @see_also: #GSocketConnection.
 *
 * This is the subclass of #GSocketConnection that is created
 * for TCP/IP sockets.
 *
 * Since: 2.22
 */


/**
 * SECTION:gtcpwrapperconnection
 * @title: GTcpWrapperConnection
 * @short_description: Wrapper for non-GSocketConnection-based,
 *     GSocket-based GIOStreams
 * @include: gio/gio.h
 * @see_also: #GSocketConnection.
 *
 * A #GTcpWrapperConnection can be used to wrap a #GIOStream that is
 * based on a #GSocket, but which is not actually a
 * #GSocketConnection. This is used by #GSocketClient so that it can
 * always return a #GSocketConnection, even when the connection it has
 * actually created is not directly a #GSocketConnection.
 *
 * Since: 2.28
 */


/**
 * SECTION:gtestdbus
 * @short_description: D-Bus testing helper
 * @include: gio/gio.h
 *
 * A helper class for testing code which uses D-Bus without touching the user's
 * session bus.
 *
 * Note that #GTestDBus modifies the user’s environment, calling setenv().
 * This is not thread-safe, so all #GTestDBus calls should be completed before
 * threads are spawned, or should have appropriate locking to ensure no access
 * conflicts to environment variables shared between #GTestDBus and other
 * threads.
 *
 * ## Creating unit tests using GTestDBus
 *
 * Testing of D-Bus services can be tricky because normally we only ever run
 * D-Bus services over an existing instance of the D-Bus daemon thus we
 * usually don't activate D-Bus services that are not yet installed into the
 * target system. The #GTestDBus object makes this easier for us by taking care
 * of the lower level tasks such as running a private D-Bus daemon and looking
 * up uninstalled services in customizable locations, typically in your source
 * code tree.
 *
 * The first thing you will need is a separate service description file for the
 * D-Bus daemon. Typically a `services` subdirectory of your `tests` directory
 * is a good place to put this file.
 *
 * The service file should list your service along with an absolute path to the
 * uninstalled service executable in your source tree. Using autotools we would
 * achieve this by adding a file such as `my-server.service.in` in the services
 * directory and have it processed by configure.
 * |[
 *     [D-BUS Service]
 *     Name=org.gtk.GDBus.Examples.ObjectManager
 *     Exec=@abs_top_builddir@/gio/tests/gdbus-example-objectmanager-server
 * ]|
 * You will also need to indicate this service directory in your test
 * fixtures, so you will need to pass the path while compiling your
 * test cases. Typically this is done with autotools with an added
 * preprocessor flag specified to compile your tests such as:
 * |[
 *     -DTEST_SERVICES=\""$(abs_top_builddir)/tests/services"\"
 * ]|
 *     Once you have a service definition file which is local to your source tree,
 * you can proceed to set up a GTest fixture using the #GTestDBus scaffolding.
 *
 * An example of a test fixture for D-Bus services can be found
 * here:
 * [gdbus-test-fixture.c](https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gdbus-test-fixture.c)
 *
 * Note that these examples only deal with isolating the D-Bus aspect of your
 * service. To successfully run isolated unit tests on your service you may need
 * some additional modifications to your test case fixture. For example; if your
 * service uses GSettings and installs a schema then it is important that your test service
 * not load the schema in the ordinary installed location (chances are that your service
 * and schema files are not yet installed, or worse; there is an older version of the
 * schema file sitting in the install location).
 *
 * Most of the time we can work around these obstacles using the
 * environment. Since the environment is inherited by the D-Bus daemon
 * created by #GTestDBus and then in turn inherited by any services the
 * D-Bus daemon activates, using the setup routine for your fixture is
 * a practical place to help sandbox your runtime environment. For the
 * rather typical GSettings case we can work around this by setting
 * `GSETTINGS_SCHEMA_DIR` to the in tree directory holding your schemas
 * in the above fixture_setup() routine.
 *
 * The GSettings schemas need to be locally pre-compiled for this to work. This can be achieved
 * by compiling the schemas locally as a step before running test cases, an autotools setup might
 * do the following in the directory holding schemas:
 * |[
 *     all-am:
 *             $(GLIB_COMPILE_SCHEMAS) .
 *
 *     CLEANFILES += gschemas.compiled
 * ]|
 */


/**
 * SECTION:gthemedicon
 * @short_description: Icon theming support
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon
 *
 * #GThemedIcon is an implementation of #GIcon that supports icon themes.
 * #GThemedIcon contains a list of all of the icons present in an icon
 * theme, so that icons can be looked up quickly. #GThemedIcon does
 * not provide actual pixmaps for icons, just the icon names.
 * Ideally something like gtk_icon_theme_choose_icon() should be used to
 * resolve the list of names so that fallback icons work nicely with
 * themes that inherit other themes.
 */


/**
 * SECTION:gthreadedsocketservice
 * @title: GThreadedSocketService
 * @short_description: A threaded GSocketService
 * @include: gio/gio.h
 * @see_also: #GSocketService.
 *
 * A #GThreadedSocketService is a simple subclass of #GSocketService
 * that handles incoming connections by creating a worker thread and
 * dispatching the connection to it by emitting the
 * #GThreadedSocketService::run signal in the new thread.
 *
 * The signal handler may perform blocking IO and need not return
 * until the connection is closed.
 *
 * The service is implemented using a thread pool, so there is a
 * limited amount of threads available to serve incoming requests.
 * The service automatically stops the #GSocketService from accepting
 * new connections when all threads are busy.
 *
 * As with #GSocketService, you may connect to #GThreadedSocketService::run,
 * or subclass and override the default handler.
 */


/**
 * SECTION:gtls
 * @title: TLS Overview
 * @short_description: TLS (aka SSL) support for GSocketConnection
 * @include: gio/gio.h
 *
 * #GTlsConnection and related classes provide TLS (Transport Layer
 * Security, previously known as SSL, Secure Sockets Layer) support for
 * gio-based network streams.
 *
 * #GDtlsConnection and related classes provide DTLS (Datagram TLS) support for
 * GIO-based network sockets, using the #GDatagramBased interface. The TLS and
 * DTLS APIs are almost identical, except TLS is stream-based and DTLS is
 * datagram-based. They share certificate and backend infrastructure.
 *
 * In the simplest case, for a client TLS connection, you can just set the
 * #GSocketClient:tls flag on a #GSocketClient, and then any
 * connections created by that client will have TLS negotiated
 * automatically, using appropriate default settings, and rejecting
 * any invalid or self-signed certificates (unless you change that
 * default by setting the #GSocketClient:tls-validation-flags
 * property). The returned object will be a #GTcpWrapperConnection,
 * which wraps the underlying #GTlsClientConnection.
 *
 * For greater control, you can create your own #GTlsClientConnection,
 * wrapping a #GSocketConnection (or an arbitrary #GIOStream with
 * pollable input and output streams) and then connect to its signals,
 * such as #GTlsConnection::accept-certificate, before starting the
 * handshake.
 *
 * Server-side TLS is similar, using #GTlsServerConnection. At the
 * moment, there is no support for automatically wrapping server-side
 * connections in the way #GSocketClient does for client-side
 * connections.
 */


/**
 * SECTION:gtlsbackend
 * @title: GTlsBackend
 * @short_description: TLS backend implementation
 * @include: gio/gio.h
 *
 * TLS (Transport Layer Security, aka SSL) and DTLS backend.
 *
 * Since: 2.28
 */


/**
 * SECTION:gtlscertificate
 * @title: GTlsCertificate
 * @short_description: TLS certificate
 * @include: gio/gio.h
 * @see_also: #GTlsConnection
 *
 * A certificate used for TLS authentication and encryption.
 * This can represent either a certificate only (eg, the certificate
 * received by a client from a server), or the combination of
 * a certificate and a private key (which is needed when acting as a
 * #GTlsServerConnection).
 *
 * Since: 2.28
 */


/**
 * SECTION:gtlsclientconnection
 * @short_description: TLS client-side connection
 * @include: gio/gio.h
 *
 * #GTlsClientConnection is the client-side subclass of
 * #GTlsConnection, representing a client-side TLS connection.
 */


/**
 * SECTION:gtlsconnection
 * @short_description: TLS connection type
 * @include: gio/gio.h
 *
 * #GTlsConnection is the base TLS connection class type, which wraps
 * a #GIOStream and provides TLS encryption on top of it. Its
 * subclasses, #GTlsClientConnection and #GTlsServerConnection,
 * implement client-side and server-side TLS, respectively.
 *
 * For DTLS (Datagram TLS) support, see #GDtlsConnection.
 *
 * Since: 2.28
 */


/**
 * SECTION:gtlsdatabase
 * @short_description: TLS database type
 * @include: gio/gio.h
 *
 * #GTlsDatabase is used to look up certificates and other information
 * from a certificate or key store. It is an abstract base class which
 * TLS library specific subtypes override.
 *
 * A #GTlsDatabase may be accessed from multiple threads by the TLS backend.
 * All implementations are required to be fully thread-safe.
 *
 * Most common client applications will not directly interact with
 * #GTlsDatabase. It is used internally by #GTlsConnection.
 *
 * Since: 2.30
 */


/**
 * SECTION:gtlsfiledatabase
 * @short_description: TLS file based database type
 * @include: gio/gio.h
 *
 * #GTlsFileDatabase is implemented by #GTlsDatabase objects which load
 * their certificate information from a file. It is an interface which
 * TLS library specific subtypes implement.
 *
 * Since: 2.30
 */


/**
 * SECTION:gtlsinteraction
 * @short_description: Interaction with the user during TLS operations.
 * @include: gio/gio.h
 *
 * #GTlsInteraction provides a mechanism for the TLS connection and database
 * code to interact with the user. It can be used to ask the user for passwords.
 *
 * To use a #GTlsInteraction with a TLS connection use
 * g_tls_connection_set_interaction().
 *
 * Callers should instantiate a derived class that implements the various
 * interaction methods to show the required dialogs.
 *
 * Callers should use the 'invoke' functions like
 * g_tls_interaction_invoke_ask_password() to run interaction methods. These
 * functions make sure that the interaction is invoked in the main loop
 * and not in the current thread, if the current thread is not running the
 * main loop.
 *
 * Derived classes can choose to implement whichever interactions methods they'd
 * like to support by overriding those virtual methods in their class
 * initialization function. Any interactions not implemented will return
 * %G_TLS_INTERACTION_UNHANDLED. If a derived class implements an async method,
 * it must also implement the corresponding finish method.
 */


/**
 * SECTION:gtlspassword
 * @title: GTlsPassword
 * @short_description: TLS Passwords for prompting
 * @include: gio/gio.h
 *
 * Holds a password used in TLS.
 */


/**
 * SECTION:gtlsserverconnection
 * @short_description: TLS server-side connection
 * @include: gio/gio.h
 *
 * #GTlsServerConnection is the server-side subclass of #GTlsConnection,
 * representing a server-side TLS connection.
 *
 * Since: 2.28
 */


/**
 * SECTION:gunixconnection
 * @title: GUnixConnection
 * @short_description: A UNIX domain GSocketConnection
 * @include: gio/gunixconnection.h
 * @see_also: #GSocketConnection.
 *
 * This is the subclass of #GSocketConnection that is created
 * for UNIX domain sockets.
 *
 * It contains functions to do some of the UNIX socket specific
 * functionality like passing file descriptors.
 *
 * Since GLib 2.72, #GUnixConnection is available on all platforms. It requires
 * underlying system support (such as Windows 10 with `AF_UNIX`) at run time.
 *
 * Before GLib 2.72, `<gio/gunixconnection.h>` belonged to the UNIX-specific GIO
 * interfaces, thus you had to use the `gio-unix-2.0.pc` pkg-config file when
 * using it. This is no longer necessary since GLib 2.72.
 *
 * Since: 2.22
 */


/**
 * SECTION:gunixcredentialsmessage
 * @title: GUnixCredentialsMessage
 * @short_description: A GSocketControlMessage containing credentials
 * @include: gio/gunixcredentialsmessage.h
 * @see_also: #GUnixConnection, #GSocketControlMessage
 *
 * This #GSocketControlMessage contains a #GCredentials instance.  It
 * may be sent using g_socket_send_message() and received using
 * g_socket_receive_message() over UNIX sockets (ie: sockets in the
 * %G_SOCKET_FAMILY_UNIX family).
 *
 * For an easier way to send and receive credentials over
 * stream-oriented UNIX sockets, see
 * g_unix_connection_send_credentials() and
 * g_unix_connection_receive_credentials(). To receive credentials of
 * a foreign process connected to a socket, use
 * g_socket_get_credentials().
 *
 * Since GLib 2.72, #GUnixCredentialMessage is available on all platforms. It
 * requires underlying system support (such as Windows 10 with `AF_UNIX`) at run
 * time.
 *
 * Before GLib 2.72, `<gio/gunixcredentialsmessage.h>` belonged to the UNIX-specific
 * GIO interfaces, thus you had to use the `gio-unix-2.0.pc` pkg-config file
 * when using it. This is no longer necessary since GLib 2.72.
 */


/**
 * SECTION:gunixfdlist
 * @title: GUnixFDList
 * @short_description: An object containing a set of UNIX file descriptors
 * @include: gio/gunixfdlist.h
 * @see_also: #GUnixFDMessage
 *
 * A #GUnixFDList contains a list of file descriptors.  It owns the file
 * descriptors that it contains, closing them when finalized.
 *
 * It may be wrapped in a #GUnixFDMessage and sent over a #GSocket in
 * the %G_SOCKET_FAMILY_UNIX family by using g_socket_send_message()
 * and received using g_socket_receive_message().
 *
 * Before 2.74, `<gio/gunixfdlist.h>` belonged to the UNIX-specific GIO
 * interfaces, thus you had to use the `gio-unix-2.0.pc` pkg-config file when
 * using it.
 *
 * Since 2.74, the API is available for Windows.
 */


/**
 * SECTION:gunixfdmessage
 * @title: GUnixFDMessage
 * @short_description: A GSocketControlMessage containing a GUnixFDList
 * @include: gio/gunixfdmessage.h
 * @see_also: #GUnixConnection, #GUnixFDList, #GSocketControlMessage
 *
 * This #GSocketControlMessage contains a #GUnixFDList.
 * It may be sent using g_socket_send_message() and received using
 * g_socket_receive_message() over UNIX sockets (ie: sockets in the
 * %G_SOCKET_FAMILY_UNIX family). The file descriptors are copied
 * between processes by the kernel.
 *
 * For an easier way to send and receive file descriptors over
 * stream-oriented UNIX sockets, see g_unix_connection_send_fd() and
 * g_unix_connection_receive_fd().
 *
 * Note that `<gio/gunixfdmessage.h>` belongs to the UNIX-specific GIO
 * interfaces, thus you have to use the `gio-unix-2.0.pc` pkg-config
 * file when using it.
 */


/**
 * SECTION:gunixinputstream
 * @short_description: Streaming input operations for UNIX file descriptors
 * @include: gio/gunixinputstream.h
 * @see_also: #GInputStream
 *
 * #GUnixInputStream implements #GInputStream for reading from a UNIX
 * file descriptor, including asynchronous operations. (If the file
 * descriptor refers to a socket or pipe, this will use poll() to do
 * asynchronous I/O. If it refers to a regular file, it will fall back
 * to doing asynchronous I/O in another thread.)
 *
 * Note that `<gio/gunixinputstream.h>` belongs to the UNIX-specific GIO
 * interfaces, thus you have to use the `gio-unix-2.0.pc` pkg-config
 * file when using it.
 */


/**
 * SECTION:gunixmounts
 * @include: gio/gunixmounts.h
 * @short_description: UNIX mounts
 *
 * Routines for managing mounted UNIX mount points and paths.
 *
 * Note that `<gio/gunixmounts.h>` belongs to the UNIX-specific GIO
 * interfaces, thus you have to use the `gio-unix-2.0.pc` pkg-config
 * file when using it.
 */


/**
 * SECTION:gunixoutputstream
 * @short_description: Streaming output operations for UNIX file descriptors
 * @include: gio/gunixoutputstream.h
 * @see_also: #GOutputStream
 *
 * #GUnixOutputStream implements #GOutputStream for writing to a UNIX
 * file descriptor, including asynchronous operations. (If the file
 * descriptor refers to a socket or pipe, this will use poll() to do
 * asynchronous I/O. If it refers to a regular file, it will fall back
 * to doing asynchronous I/O in another thread.)
 *
 * Note that `<gio/gunixoutputstream.h>` belongs to the UNIX-specific GIO
 * interfaces, thus you have to use the `gio-unix-2.0.pc` pkg-config file
 * when using it.
 */


/**
 * SECTION:gunixsocketaddress
 * @short_description: UNIX GSocketAddress
 * @include: gio/gunixsocketaddress.h
 *
 * Support for UNIX-domain (also known as local) sockets.
 *
 * UNIX domain sockets are generally visible in the filesystem.
 * However, some systems support abstract socket names which are not
 * visible in the filesystem and not affected by the filesystem
 * permissions, visibility, etc. Currently this is only supported
 * under Linux. If you attempt to use abstract sockets on other
 * systems, function calls may return %G_IO_ERROR_NOT_SUPPORTED
 * errors. You can use g_unix_socket_address_abstract_names_supported()
 * to see if abstract names are supported.
 *
 * Since GLib 2.72, #GUnixSocketAddress is available on all platforms. It
 * requires underlying system support (such as Windows 10 with `AF_UNIX`) at
 * run time.
 *
 * Before GLib 2.72, `<gio/gunixsocketaddress.h>` belonged to the UNIX-specific
 * GIO interfaces, thus you had to use the `gio-unix-2.0.pc` pkg-config file
 * when using it. This is no longer necessary since GLib 2.72.
 */


/**
 * SECTION:gvfs
 * @short_description: Virtual File System
 * @include: gio/gio.h
 *
 * Entry point for using GIO functionality.
 */


/**
 * SECTION:gvolume
 * @short_description: Volume management
 * @include: gio/gio.h
 *
 * The #GVolume interface represents user-visible objects that can be
 * mounted. Note, when porting from GnomeVFS, #GVolume is the moral
 * equivalent of #GnomeVFSDrive.
 *
 * Mounting a #GVolume instance is an asynchronous operation. For more
 * information about asynchronous operations, see #GAsyncResult and
 * #GTask. To mount a #GVolume, first call g_volume_mount() with (at
 * least) the #GVolume instance, optionally a #GMountOperation object
 * and a #GAsyncReadyCallback.
 *
 * Typically, one will only want to pass %NULL for the
 * #GMountOperation if automounting all volumes when a desktop session
 * starts since it's not desirable to put up a lot of dialogs asking
 * for credentials.
 *
 * The callback will be fired when the operation has resolved (either
 * with success or failure), and a #GAsyncResult instance will be
 * passed to the callback.  That callback should then call
 * g_volume_mount_finish() with the #GVolume instance and the
 * #GAsyncResult data to see if the operation was completed
 * successfully.  If an @error is present when g_volume_mount_finish()
 * is called, then it will be filled with any error information.
 *
 * ## Volume Identifiers # {#volume-identifier}
 *
 * It is sometimes necessary to directly access the underlying
 * operating system object behind a volume (e.g. for passing a volume
 * to an application via the commandline). For this purpose, GIO
 * allows to obtain an 'identifier' for the volume. There can be
 * different kinds of identifiers, such as Hal UDIs, filesystem labels,
 * traditional Unix devices (e.g. `/dev/sda2`), UUIDs. GIO uses predefined
 * strings as names for the different kinds of identifiers:
 * %G_VOLUME_IDENTIFIER_KIND_UUID, %G_VOLUME_IDENTIFIER_KIND_LABEL, etc.
 * Use g_volume_get_identifier() to obtain an identifier for a volume.
 *
 *
 * Note that %G_VOLUME_IDENTIFIER_KIND_HAL_UDI will only be available
 * when the gvfs hal volume monitor is in use. Other volume monitors
 * will generally be able to provide the %G_VOLUME_IDENTIFIER_KIND_UNIX_DEVICE
 * identifier, which can be used to obtain a hal device by means of
 * libhal_manager_find_device_string_match().
 */


/**
 * SECTION:gvolumemonitor
 * @short_description: Volume Monitor
 * @include: gio/gio.h
 * @see_also: #GFileMonitor
 *
 * #GVolumeMonitor is for listing the user interesting devices and volumes
 * on the computer. In other words, what a file selector or file manager
 * would show in a sidebar.
 *
 * #GVolumeMonitor is not
 * [thread-default-context aware][g-main-context-push-thread-default],
 * and so should not be used other than from the main thread, with no
 * thread-default-context active.
 *
 * In order to receive updates about volumes and mounts monitored through GVFS,
 * a main loop must be running.
 */


/**
 * SECTION:gwin32inputstream
 * @short_description: Streaming input operations for Windows file handles
 * @include: gio/gwin32inputstream.h
 * @see_also: #GInputStream
 *
 * #GWin32InputStream implements #GInputStream for reading from a
 * Windows file handle.
 *
 * Note that `<gio/gwin32inputstream.h>` belongs to the Windows-specific GIO
 * interfaces, thus you have to use the `gio-windows-2.0.pc` pkg-config file
 * when using it.
 */


/**
 * SECTION:gwin32outputstream
 * @short_description: Streaming output operations for Windows file handles
 * @include: gio/gwin32outputstream.h
 * @see_also: #GOutputStream
 *
 * #GWin32OutputStream implements #GOutputStream for writing to a
 * Windows file handle.
 *
 * Note that `<gio/gwin32outputstream.h>` belongs to the Windows-specific GIO
 * interfaces, thus you have to use the `gio-windows-2.0.pc` pkg-config file
 * when using it.
 */


/**
 * SECTION:gwin32registrykey
 * @title: GWin32RegistryKey
 * @short_description: W32 registry access helper
 * @include: gio/win32/gwin32registrykey.h
 *
 * #GWin32RegistryKey represents a single Windows Registry key.
 *
 * #GWin32RegistryKey is used by a number of helper functions that read
 * Windows Registry. All keys are opened with read-only access, and at
 * the moment there is no API for writing into registry keys or creating
 * new ones.
 *
 * #GWin32RegistryKey implements the #GInitable interface, so if it is manually
 * constructed by e.g. g_object_new() you must call g_initable_init() and check
 * the results before using the object. This is done automatically
 * in g_win32_registry_key_new() and g_win32_registry_key_get_child(), so these
 * functions can return %NULL.
 *
 * To increase efficiency, a UTF-16 variant is available for all functions
 * that deal with key or value names in the registry. Use these to perform
 * deep registry queries or other operations that require querying a name
 * of a key or a value and then opening it (or querying its data). The use
 * of UTF-16 functions avoids the overhead of converting names to UTF-8 and
 * back.
 *
 * All functions operate in current user's context (it is not possible to
 * access registry tree of a different user).
 *
 * Key paths must use '\\' as a separator, '/' is not supported. Key names
 * must not include '\\', because it's used as a separator. Value names
 * can include '\\'.
 *
 * Key and value names are not case sensitive.
 *
 * Full key name (excluding the pre-defined ancestor's name) can't exceed
 * 255 UTF-16 characters, give or take. Value name can't exceed 16383 UTF-16
 * characters. Tree depth is limited to 512 levels.
 */


/**
 * SECTION:gzlibcompressor
 * @short_description: Zlib compressor
 * @include: gio/gio.h
 *
 * #GZlibCompressor is an implementation of #GConverter that
 * compresses data using zlib.
 */


/**
 * SECTION:gzlibdecompressor
 * @short_description: Zlib decompressor
 * @include: gio/gio.h
 *
 * #GZlibDecompressor is an implementation of #GConverter that
 * decompresses data compressed with zlib.
 */


/**
 * _g_dbus_initialize:
 *
 * Does various one-time init things such as
 *
 *  - registering the G_DBUS_ERROR error domain
 *  - parses the G_DBUS_DEBUG environment variable
 */


/**
 * _g_file_attribute_value_as_string:
 * @attr: a #GFileAttributeValue.
 *
 * Converts a #GFileAttributeValue to a string for display.
 * The returned string should be freed when no longer needed.
 *
 * Returns: a string from the @attr, %NULL on error, or "<invalid>"
 * if @attr is of type %G_FILE_ATTRIBUTE_TYPE_INVALID.
 */


/**
 * _g_file_attribute_value_clear:
 * @attr: a #GFileAttributeValue.
 *
 * Clears the value of @attr and sets its type to
 * %G_FILE_ATTRIBUTE_TYPE_INVALID.
 */


/**
 * _g_file_attribute_value_free:
 * @attr: a #GFileAttributeValue.
 *
 * Frees the memory used by @attr.
 */


/**
 * _g_file_attribute_value_get_boolean:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the boolean value from a file attribute value. If the value is not the
 * right type then %FALSE will be returned.
 *
 * Returns: the boolean value contained within the attribute, or %FALSE.
 */


/**
 * _g_file_attribute_value_get_byte_string:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the byte string from a file attribute value. If the value is not the
 * right type then %NULL will be returned.
 *
 * Returns: the byte string contained within the attribute or %NULL.
 */


/**
 * _g_file_attribute_value_get_int32:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the signed 32-bit integer from a file attribute value. If the value
 * is not the right type then 0 will be returned.
 *
 * Returns: the signed 32-bit integer from the attribute, or 0.
 */


/**
 * _g_file_attribute_value_get_int64:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the signed 64-bit integer from a file attribute value. If the value
 * is not the right type then 0 will be returned.
 *
 * Returns: the signed 64-bit integer from the attribute, or 0.
 */


/**
 * _g_file_attribute_value_get_object:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the GObject from a file attribute value. If the value
 * is not the right type then %NULL will be returned.
 *
 * Returns: the GObject from the attribute, or %NULL.
 */


/**
 * _g_file_attribute_value_get_string:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the string from a file attribute value. If the value is not the
 * right type then %NULL will be returned.
 *
 * Returns: the UTF-8 string value contained within the attribute, or %NULL.
 */


/**
 * _g_file_attribute_value_get_uint32:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the unsigned 32-bit integer from a file attribute value. If the value
 * is not the right type then 0 will be returned.
 *
 * Returns: the unsigned 32-bit integer from the attribute, or 0.
 */


/**
 * _g_file_attribute_value_get_uint64:
 * @attr: a #GFileAttributeValue.
 *
 * Gets the unsigned 64-bit integer from a file attribute value. If the value
 * is not the right type then 0 will be returned.
 *
 * Returns: the unsigned 64-bit integer from the attribute, or 0.
 */


/**
 * _g_file_attribute_value_new:
 *
 * Creates a new file attribute.
 *
 * Returns: a #GFileAttributeValue.
 */


/**
 * _g_file_attribute_value_set_boolean:
 * @attr: a #GFileAttributeValue.
 * @value: a #gboolean to set within the type.
 *
 * Sets the attribute value to the given boolean value.
 */


/**
 * _g_file_attribute_value_set_byte_string:
 * @attr: a #GFileAttributeValue.
 * @string: a byte string to set within the type.
 *
 * Sets the attribute value to a given byte string.
 */


/**
 * _g_file_attribute_value_set_int32:
 * @attr: a #GFileAttributeValue.
 * @value: a #gint32 to set within the type.
 *
 * Sets the attribute value to the given signed 32-bit integer.
 */


/**
 * _g_file_attribute_value_set_int64:
 * @attr: a #GFileAttributeValue.
 * @value: a #gint64 to set within the type.
 *
 * Sets the attribute value to a given signed 64-bit integer.
 */


/**
 * _g_file_attribute_value_set_object:
 * @attr: a #GFileAttributeValue.
 * @obj: a #GObject.
 *
 * Sets the attribute to contain the value @obj.
 * The @attr references the GObject internally.
 */


/**
 * _g_file_attribute_value_set_string:
 * @attr: a #GFileAttributeValue.
 * @string: a UTF-8 string to set within the type.
 *
 * Sets the attribute value to a given UTF-8 string.
 */


/**
 * _g_file_attribute_value_set_uint32:
 * @attr: a #GFileAttributeValue.
 * @value: a #guint32 to set within the type.
 *
 * Sets the attribute value to the given unsigned 32-bit integer.
 */


/**
 * _g_file_attribute_value_set_uint64:
 * @attr: a #GFileAttributeValue.
 * @value: a #guint64 to set within the type.
 *
 * Sets the attribute value to a given unsigned 64-bit integer.
 */


/**
 * _g_io_module_extract_name:
 * @filename: filename of a GIOModule
 *
 * Extract the plugin name from its filename. It removes optional "lib" or
 * "libgio" prefix, and removes everything after the first dot. For example:
 * "libgiognutls.so" -> "gnutls".
 *
 * Returns: (transfer full): the module's name
 */


/**
 * _g_io_module_get_default:
 * @extension_point: the name of an extension point
 * @envvar: (nullable): the name of an environment variable to
 *     override the default implementation.
 * @verify_func: (nullable): a function to call to verify that
 *     a given implementation is usable in the current environment.
 *
 * Retrieves the default object implementing @extension_point.
 *
 * If @envvar is not %NULL, and the environment variable with that
 * name is set, then the implementation it specifies will be tried
 * first. After that, or if @envvar is not set, all other
 * implementations will be tried in order of decreasing priority.
 *
 * If an extension point implementation implements #GInitable, then
 * that implementation will only be used if it initializes
 * successfully. Otherwise, if @verify_func is not %NULL, then it will
 * be called on each candidate implementation after construction, to
 * check if it is actually usable or not.
 *
 * The result is cached after it is generated the first time (but the cache does
 * not keep a strong reference to the object), and
 * the function is thread-safe.
 *
 * Returns: (transfer full) (nullable): an object implementing
 *     @extension_point, or %NULL if there are no usable
 *     implementations.
 */


/**
 * _g_io_module_get_default_type:
 * @extension_point: the name of an extension point
 * @envvar: (nullable): the name of an environment variable to
 *     override the default implementation.
 * @is_supported_offset: a vtable offset, or zero
 *
 * Retrieves the default class implementing @extension_point.
 *
 * If @envvar is not %NULL, and the environment variable with that
 * name is set, then the implementation it specifies will be tried
 * first. After that, or if @envvar is not set, all other
 * implementations will be tried in order of decreasing priority.
 *
 * If @is_supported_offset is non-zero, then it is the offset into the
 * class vtable at which there is a function that takes no arguments and
 * returns a boolean.  This function will be called on each candidate
 * implementation to check if it is actually usable or not.
 *
 * The result is cached after it is generated the first time, and
 * the function is thread-safe.
 *
 * Returns: (transfer none): the type to instantiate to implement
 *     @extension_point, or %G_TYPE_INVALID if there are no usable
 *     implementations.
 */


/**
 * _g_poll_file_monitor_new:
 * @file: a #GFile.
 *
 * Polls @file for changes.
 *
 * Returns: a new #GFileMonitor for the given #GFile.
 */


/**
 * _g_win32_current_process_sid_string: (skip)
 * @error: return location for a #GError, or %NULL
 *
 * Get the current process SID, as a string.
 *
 * Returns: A newly-allocated string, or NULL in case of an error.
 */


/**
 * _g_win32_process_get_access_token_sid: (skip)
 * @process_id: Identifier of a process to get an access token of
 *              (use 0 to get a token of the current process)
 * @error: return location for a #GError, or %NULL
 *
 * Opens the process identified by @process_id and opens its token,
 * then retrieves SID of the token user and returns a copy of that SID.
 *
 * Returns: A newly-allocated SID, or NULL in case of an error.
 *          Free the returned SID with g_free().
 */


/**
 * _g_win32_sid_replace: (skip)
 * @dest: A pointer to a SID storage
 * @src: Existing SID
 * @error: return location for a #GError, or %NULL
 *
 * Creates a copy of the @src SID and puts that into @dest, after freeing
 * existing SID in @dest (if any).
 *
 * The @src SID must be valid (use IsValidSid() to ensure that).
 *
 * Returns: TRUE on success, FALSE otherwise
 */


/**
 * _g_win32_sid_to_string: (skip)
 * @sid: a SID.
 * @error: return location for a #GError, or %NULL
 *
 * Convert a SID to its string form.
 *
 * Returns: A newly-allocated string, or NULL in case of an error.
 */


/**
 * _g_win32_token_get_sid: (skip)
 * @token: A handle of an access token
 * @error: return location for a #GError, or %NULL
 *
 * Gets user SID of the @token and returns a copy of that SID.
 *
 * Returns: A newly-allocated SID, or NULL in case of an error.
 *          Free the returned SID with g_free().
 */


/**
 * g_action_activate:
 * @action: a #GAction
 * @parameter: (nullable): the parameter to the activation
 *
 * Activates the action.
 *
 * @parameter must be the correct type of parameter for the action (ie:
 * the parameter type given at construction time).  If the parameter
 * type was %NULL then @parameter must also be %NULL.
 *
 * If the @parameter GVariant is floating, it is consumed.
 *
 * Since: 2.28
 */


/**
 * g_action_change_state:
 * @action: a #GAction
 * @value: the new state
 *
 * Request for the state of @action to be changed to @value.
 *
 * The action must be stateful and @value must be of the correct type.
 * See g_action_get_state_type().
 *
 * This call merely requests a change.  The action may refuse to change
 * its state or may change its state to something other than @value.
 * See g_action_get_state_hint().
 *
 * If the @value GVariant is floating, it is consumed.
 *
 * Since: 2.30
 */


/**
 * g_action_get_enabled:
 * @action: a #GAction
 *
 * Checks if @action is currently enabled.
 *
 * An action must be enabled in order to be activated or in order to
 * have its state changed from outside callers.
 *
 * Returns: whether the action is enabled
 * Since: 2.28
 */


/**
 * g_action_get_name:
 * @action: a #GAction
 *
 * Queries the name of @action.
 *
 * Returns: the name of the action
 * Since: 2.28
 */


/**
 * g_action_get_parameter_type:
 * @action: a #GAction
 *
 * Queries the type of the parameter that must be given when activating
 * @action.
 *
 * When activating the action using g_action_activate(), the #GVariant
 * given to that function must be of the type returned by this function.
 *
 * In the case that this function returns %NULL, you must not give any
 * #GVariant, but %NULL instead.
 *
 * Returns: (nullable): the parameter type
 * Since: 2.28
 */


/**
 * g_action_get_state:
 * @action: a #GAction
 *
 * Queries the current state of @action.
 *
 * If the action is not stateful then %NULL will be returned.  If the
 * action is stateful then the type of the return value is the type
 * given by g_action_get_state_type().
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (nullable) (transfer full): the current state of the action
 * Since: 2.28
 */


/**
 * g_action_get_state_hint:
 * @action: a #GAction
 *
 * Requests a hint about the valid range of values for the state of
 * @action.
 *
 * If %NULL is returned it either means that the action is not stateful
 * or that there is no hint about the valid range of values for the
 * state of the action.
 *
 * If a #GVariant array is returned then each item in the array is a
 * possible value for the state.  If a #GVariant pair (ie: two-tuple) is
 * returned then the tuple specifies the inclusive lower and upper bound
 * of valid values for the state.
 *
 * In any case, the information is merely a hint.  It may be possible to
 * have a state value outside of the hinted range and setting a value
 * within the range may fail.
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (nullable) (transfer full): the state range hint
 * Since: 2.28
 */


/**
 * g_action_get_state_type:
 * @action: a #GAction
 *
 * Queries the type of the state of @action.
 *
 * If the action is stateful (e.g. created with
 * g_simple_action_new_stateful()) then this function returns the
 * #GVariantType of the state.  This is the type of the initial value
 * given as the state. All calls to g_action_change_state() must give a
 * #GVariant of this type and g_action_get_state() will return a
 * #GVariant of the same type.
 *
 * If the action is not stateful (e.g. created with g_simple_action_new())
 * then this function will return %NULL. In that case, g_action_get_state()
 * will return %NULL and you must not call g_action_change_state().
 *
 * Returns: (nullable): the state type, if the action is stateful
 * Since: 2.28
 */


/**
 * g_action_group_action_added:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 *
 * Emits the #GActionGroup::action-added signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_action_enabled_changed:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 * @enabled: whether or not the action is now enabled
 *
 * Emits the #GActionGroup::action-enabled-changed signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_action_removed:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 *
 * Emits the #GActionGroup::action-removed signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_action_state_changed:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 * @state: the new state of the named action
 *
 * Emits the #GActionGroup::action-state-changed signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_activate_action:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to activate
 * @parameter: (nullable): parameters to the activation
 *
 * Activate the named action within @action_group.
 *
 * If the action is expecting a parameter, then the correct type of
 * parameter must be given as @parameter.  If the action is expecting no
 * parameters then @parameter must be %NULL.  See
 * g_action_group_get_action_parameter_type().
 *
 * If the #GActionGroup implementation supports asynchronous remote
 * activation over D-Bus, this call may return before the relevant
 * D-Bus traffic has been sent, or any replies have been received. In
 * order to block on such asynchronous activation calls,
 * g_dbus_connection_flush() should be called prior to the code, which
 * depends on the result of the action activation. Without flushing
 * the D-Bus connection, there is no guarantee that the action would
 * have been activated.
 *
 * The following code which runs in a remote app instance, shows an
 * example of a "quit" action being activated on the primary app
 * instance over D-Bus. Here g_dbus_connection_flush() is called
 * before `exit()`. Without g_dbus_connection_flush(), the "quit" action
 * may fail to be activated on the primary instance.
 *
 * |[<!-- language="C" -->
 * // call "quit" action on primary instance
 * g_action_group_activate_action (G_ACTION_GROUP (app), "quit", NULL);
 *
 * // make sure the action is activated now
 * g_dbus_connection_flush (...);
 *
 * g_debug ("application has been terminated. exiting.");
 *
 * exit (0);
 * ]|
 *
 * Since: 2.28
 */


/**
 * g_action_group_change_action_state:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to request the change on
 * @value: the new state
 *
 * Request for the state of the named action within @action_group to be
 * changed to @value.
 *
 * The action must be stateful and @value must be of the correct type.
 * See g_action_group_get_action_state_type().
 *
 * This call merely requests a change.  The action may refuse to change
 * its state or may change its state to something other than @value.
 * See g_action_group_get_action_state_hint().
 *
 * If the @value GVariant is floating, it is consumed.
 *
 * Since: 2.28
 */


/**
 * g_action_group_get_action_enabled:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Checks if the named action within @action_group is currently enabled.
 *
 * An action must be enabled in order to be activated or in order to
 * have its state changed from outside callers.
 *
 * Returns: whether or not the action is currently enabled
 * Since: 2.28
 */


/**
 * g_action_group_get_action_parameter_type:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Queries the type of the parameter that must be given when activating
 * the named action within @action_group.
 *
 * When activating the action using g_action_group_activate_action(),
 * the #GVariant given to that function must be of the type returned
 * by this function.
 *
 * In the case that this function returns %NULL, you must not give any
 * #GVariant, but %NULL instead.
 *
 * The parameter type of a particular action will never change but it is
 * possible for an action to be removed and for a new action to be added
 * with the same name but a different parameter type.
 *
 * Returns: (nullable): the parameter type
 * Since: 2.28
 */


/**
 * g_action_group_get_action_state:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Queries the current state of the named action within @action_group.
 *
 * If the action is not stateful then %NULL will be returned.  If the
 * action is stateful then the type of the return value is the type
 * given by g_action_group_get_action_state_type().
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (nullable) (transfer full): the current state of the action
 * Since: 2.28
 */


/**
 * g_action_group_get_action_state_hint:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Requests a hint about the valid range of values for the state of the
 * named action within @action_group.
 *
 * If %NULL is returned it either means that the action is not stateful
 * or that there is no hint about the valid range of values for the
 * state of the action.
 *
 * If a #GVariant array is returned then each item in the array is a
 * possible value for the state.  If a #GVariant pair (ie: two-tuple) is
 * returned then the tuple specifies the inclusive lower and upper bound
 * of valid values for the state.
 *
 * In any case, the information is merely a hint.  It may be possible to
 * have a state value outside of the hinted range and setting a value
 * within the range may fail.
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (nullable) (transfer full): the state range hint
 * Since: 2.28
 */


/**
 * g_action_group_get_action_state_type:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Queries the type of the state of the named action within
 * @action_group.
 *
 * If the action is stateful then this function returns the
 * #GVariantType of the state.  All calls to
 * g_action_group_change_action_state() must give a #GVariant of this
 * type and g_action_group_get_action_state() will return a #GVariant
 * of the same type.
 *
 * If the action is not stateful then this function will return %NULL.
 * In that case, g_action_group_get_action_state() will return %NULL
 * and you must not call g_action_group_change_action_state().
 *
 * The state type of a particular action will never change but it is
 * possible for an action to be removed and for a new action to be added
 * with the same name but a different state type.
 *
 * Returns: (nullable): the state type, if the action is stateful
 * Since: 2.28
 */


/**
 * g_action_group_has_action:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to check for
 *
 * Checks if the named action exists within @action_group.
 *
 * Returns: whether the named action exists
 * Since: 2.28
 */


/**
 * g_action_group_list_actions:
 * @action_group: a #GActionGroup
 *
 * Lists the actions contained within @action_group.
 *
 * The caller is responsible for freeing the list with g_strfreev() when
 * it is no longer required.
 *
 * Returns: (transfer full): a %NULL-terminated array of the names of the
 * actions in the group
 * Since: 2.28
 */


/**
 * g_action_group_query_action:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 * @enabled: (out): if the action is presently enabled
 * @parameter_type: (out) (transfer none) (optional): the parameter type, or %NULL if none needed
 * @state_type: (out) (transfer none) (optional): the state type, or %NULL if stateless
 * @state_hint: (out) (optional): the state hint, or %NULL if none
 * @state: (out) (optional): the current state, or %NULL if stateless
 *
 * Queries all aspects of the named action within an @action_group.
 *
 * This function acquires the information available from
 * g_action_group_has_action(), g_action_group_get_action_enabled(),
 * g_action_group_get_action_parameter_type(),
 * g_action_group_get_action_state_type(),
 * g_action_group_get_action_state_hint() and
 * g_action_group_get_action_state() with a single function call.
 *
 * This provides two main benefits.
 *
 * The first is the improvement in efficiency that comes with not having
 * to perform repeated lookups of the action in order to discover
 * different things about it.  The second is that implementing
 * #GActionGroup can now be done by only overriding this one virtual
 * function.
 *
 * The interface provides a default implementation of this function that
 * calls the individual functions, as required, to fetch the
 * information.  The interface also provides default implementations of
 * those functions that call this function.  All implementations,
 * therefore, must override either this function or all of the others.
 *
 * If the action exists, %TRUE is returned and any of the requested
 * fields (as indicated by having a non-%NULL reference passed in) are
 * filled.  If the action doesn't exist, %FALSE is returned and the
 * fields may or may not have been modified.
 *
 * Returns: %TRUE if the action exists, else %FALSE
 * Since: 2.32
 */


/**
 * g_action_map_add_action:
 * @action_map: a #GActionMap
 * @action: a #GAction
 *
 * Adds an action to the @action_map.
 *
 * If the action map already contains an action with the same name
 * as @action then the old action is dropped from the action map.
 *
 * The action map takes its own reference on @action.
 *
 * Since: 2.32
 */


/**
 * g_action_map_add_action_entries:
 * @action_map: a #GActionMap
 * @entries: (array length=n_entries) (element-type GActionEntry): a pointer to
 *           the first item in an array of #GActionEntry structs
 * @n_entries: the length of @entries, or -1 if @entries is %NULL-terminated
 * @user_data: the user data for signal connections
 *
 * A convenience function for creating multiple #GSimpleAction instances
 * and adding them to a #GActionMap.
 *
 * Each action is constructed as per one #GActionEntry.
 *
 * |[<!-- language="C" -->
 * static void
 * activate_quit (GSimpleAction *simple,
 *                GVariant      *parameter,
 *                gpointer       user_data)
 * {
 *   exit (0);
 * }
 *
 * static void
 * activate_print_string (GSimpleAction *simple,
 *                        GVariant      *parameter,
 *                        gpointer       user_data)
 * {
 *   g_print ("%s\n", g_variant_get_string (parameter, NULL));
 * }
 *
 * static GActionGroup *
 * create_action_group (void)
 * {
 *   const GActionEntry entries[] = {
 *     { "quit",         activate_quit              },
 *     { "print-string", activate_print_string, "s" }
 *   };
 *   GSimpleActionGroup *group;
 *
 *   group = g_simple_action_group_new ();
 *   g_action_map_add_action_entries (G_ACTION_MAP (group), entries, G_N_ELEMENTS (entries), NULL);
 *
 *   return G_ACTION_GROUP (group);
 * }
 * ]|
 *
 * Since: 2.32
 */


/**
 * g_action_map_lookup_action:
 * @action_map: a #GActionMap
 * @action_name: the name of an action
 *
 * Looks up the action with the name @action_name in @action_map.
 *
 * If no such action exists, returns %NULL.
 *
 * Returns: (nullable) (transfer none): a #GAction, or %NULL
 * Since: 2.32
 */


/**
 * g_action_map_remove_action:
 * @action_map: a #GActionMap
 * @action_name: the name of the action
 *
 * Removes the named action from the action map.
 *
 * If no action of this name is in the map then nothing happens.
 *
 * Since: 2.32
 */


/**
 * g_action_map_remove_action_entries:
 * @action_map: The #GActionMap
 * @entries: (array length=n_entries) (element-type GActionEntry): a pointer to
 *           the first item in an array of #GActionEntry structs
 * @n_entries: the length of @entries, or -1 if @entries is %NULL-terminated
 *
 * Remove actions from a #GActionMap. This is meant as the reverse of
 * g_action_map_add_action_entries().
 *
 *
 * |[<!-- language="C" -->
 * static const GActionEntry entries[] = {
 *     { "quit",         activate_quit              },
 *     { "print-string", activate_print_string, "s" }
 * };
 *
 * void
 * add_actions (GActionMap *map)
 * {
 *   g_action_map_add_action_entries (map, entries, G_N_ELEMENTS (entries), NULL);
 * }
 *
 * void
 * remove_actions (GActionMap *map)
 * {
 *   g_action_map_remove_action_entries (map, entries, G_N_ELEMENTS (entries));
 * }
 * ]|
 *
 * Since: 2.78
 */


/**
 * g_action_name_is_valid:
 * @action_name: a potential action name
 *
 * Checks if @action_name is valid.
 *
 * @action_name is valid if it consists only of alphanumeric characters,
 * plus '-' and '.'.  The empty string is not a valid action name.
 *
 * It is an error to call this function with a non-utf8 @action_name.
 * @action_name must not be %NULL.
 *
 * Returns: %TRUE if @action_name is valid
 * Since: 2.38
 */


/**
 * g_action_parse_detailed_name:
 * @detailed_name: a detailed action name
 * @action_name: (out) (optional) (not nullable) (transfer full): the action name
 * @target_value: (out) (optional) (nullable) (transfer full): the target value,
 *   or %NULL for no target
 * @error: a pointer to a %NULL #GError, or %NULL
 *
 * Parses a detailed action name into its separate name and target
 * components.
 *
 * Detailed action names can have three formats.
 *
 * The first format is used to represent an action name with no target
 * value and consists of just an action name containing no whitespace
 * nor the characters `:`, `(` or `)`.  For example: `app.action`.
 *
 * The second format is used to represent an action with a target value
 * that is a non-empty string consisting only of alphanumerics, plus `-`
 * and `.`.  In that case, the action name and target value are
 * separated by a double colon (`::`).  For example:
 * `app.action::target`.
 *
 * The third format is used to represent an action with any type of
 * target value, including strings.  The target value follows the action
 * name, surrounded in parens.  For example: `app.action(42)`.  The
 * target value is parsed using g_variant_parse().  If a tuple-typed
 * value is desired, it must be specified in the same way, resulting in
 * two sets of parens, for example: `app.action((1,2,3))`.  A string
 * target can be specified this way as well: `app.action('target')`.
 * For strings, this third format must be used if target value is
 * empty or contains characters other than alphanumerics, `-` and `.`.
 *
 * If this function returns %TRUE, a non-%NULL value is guaranteed to be returned
 * in @action_name (if a pointer is passed in). A %NULL value may still be
 * returned in @target_value, as the @detailed_name may not contain a target.
 *
 * If returned, the #GVariant in @target_value is guaranteed to not be floating.
 *
 * Returns: %TRUE if successful, else %FALSE with @error set
 * Since: 2.38
 */


/**
 * g_action_print_detailed_name:
 * @action_name: a valid action name
 * @target_value: (nullable): a #GVariant target value, or %NULL
 *
 * Formats a detailed action name from @action_name and @target_value.
 *
 * It is an error to call this function with an invalid action name.
 *
 * This function is the opposite of g_action_parse_detailed_name().
 * It will produce a string that can be parsed back to the @action_name
 * and @target_value by that function.
 *
 * See that function for the types of strings that will be printed by
 * this function.
 *
 * Returns: a detailed format string
 * Since: 2.38
 */


/**
 * g_app_info_add_supports_type:
 * @appinfo: a #GAppInfo.
 * @content_type: a string.
 * @error: a #GError.
 *
 * Adds a content type to the application information to indicate the
 * application is capable of opening files with the given content type.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_can_delete:
 * @appinfo: a #GAppInfo
 *
 * Obtains the information whether the #GAppInfo can be deleted.
 * See g_app_info_delete().
 *
 * Returns: %TRUE if @appinfo can be deleted
 * Since: 2.20
 */


/**
 * g_app_info_can_remove_supports_type:
 * @appinfo: a #GAppInfo.
 *
 * Checks if a supported content type can be removed from an application.
 *
 * Returns: %TRUE if it is possible to remove supported
 *     content types from a given @appinfo, %FALSE if not.
 */


/**
 * g_app_info_create_from_commandline:
 * @commandline: (type filename): the commandline to use
 * @application_name: (nullable): the application name, or %NULL to use @commandline
 * @flags: flags that can specify details of the created #GAppInfo
 * @error: a #GError location to store the error occurring, %NULL to ignore.
 *
 * Creates a new #GAppInfo from the given information.
 *
 * Note that for @commandline, the quoting rules of the Exec key of the
 * [freedesktop.org Desktop Entry Specification](http://freedesktop.org/Standards/desktop-entry-spec)
 * are applied. For example, if the @commandline contains
 * percent-encoded URIs, the percent-character must be doubled in order to prevent it from
 * being swallowed by Exec key unquoting. See the specification for exact quoting rules.
 *
 * Returns: (transfer full): new #GAppInfo for given command.
 */


/**
 * g_app_info_delete: (virtual do_delete)
 * @appinfo: a #GAppInfo
 *
 * Tries to delete a #GAppInfo.
 *
 * On some platforms, there may be a difference between user-defined
 * #GAppInfos which can be deleted, and system-wide ones which cannot.
 * See g_app_info_can_delete().
 *
 * Returns: %TRUE if @appinfo has been deleted
 * Since: 2.20
 */


/**
 * g_app_info_dup:
 * @appinfo: a #GAppInfo.
 *
 * Creates a duplicate of a #GAppInfo.
 *
 * Returns: (transfer full): a duplicate of @appinfo.
 */


/**
 * g_app_info_equal:
 * @appinfo1: the first #GAppInfo.
 * @appinfo2: the second #GAppInfo.
 *
 * Checks if two #GAppInfos are equal.
 *
 * Note that the check *may not* compare each individual
 * field, and only does an identity check. In case detecting changes in the
 * contents is needed, program code must additionally compare relevant fields.
 *
 * Returns: %TRUE if @appinfo1 is equal to @appinfo2. %FALSE otherwise.
 */


/**
 * g_app_info_get_all:
 *
 * Gets a list of all of the applications currently registered
 * on this system.
 *
 * For desktop files, this includes applications that have
 * `NoDisplay=true` set or are excluded from display by means
 * of `OnlyShowIn` or `NotShowIn`. See g_app_info_should_show().
 * The returned list does not include applications which have
 * the `Hidden` key set.
 *
 * Returns: (element-type GAppInfo) (transfer full): a newly allocated #GList of references to #GAppInfos.
 */


/**
 * g_app_info_get_all_for_type:
 * @content_type: the content type to find a #GAppInfo for
 *
 * Gets a list of all #GAppInfos for a given content type,
 * including the recommended and fallback #GAppInfos. See
 * g_app_info_get_recommended_for_type() and
 * g_app_info_get_fallback_for_type().
 *
 * Returns: (element-type GAppInfo) (transfer full): #GList of #GAppInfos
 *     for given @content_type or %NULL on error.
 */


/**
 * g_app_info_get_commandline: (virtual get_commandline)
 * @appinfo: a #GAppInfo
 *
 * Gets the commandline with which the application will be
 * started.
 *
 * Returns: (nullable) (type filename): a string containing the @appinfo's commandline,
 *     or %NULL if this information is not available
 * Since: 2.20
 */


/**
 * g_app_info_get_default_for_type:
 * @content_type: the content type to find a #GAppInfo for
 * @must_support_uris: if %TRUE, the #GAppInfo is expected to
 *     support URIs
 *
 * Gets the default #GAppInfo for a given content type.
 *
 * Returns: (transfer full) (nullable): #GAppInfo for given @content_type or
 *     %NULL on error.
 */


/**
 * g_app_info_get_default_for_type_async:
 * @content_type: the content type to find a #GAppInfo for
 * @must_support_uris: if %TRUE, the #GAppInfo is expected to
 *     support URIs
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Asynchronously gets the default #GAppInfo for a given content type.
 *
 * Since: 2.74
 */


/**
 * g_app_info_get_default_for_type_finish:
 * @result: a #GAsyncResult
 * @error: (nullable): a #GError
 *
 * Finishes a default #GAppInfo lookup started by
 * g_app_info_get_default_for_type_async().
 *
 * If no #GAppInfo is found, then @error will be set to %G_IO_ERROR_NOT_FOUND.
 *
 * Returns: (transfer full): #GAppInfo for given @content_type or
 *     %NULL on error.
 * Since: 2.74
 */


/**
 * g_app_info_get_default_for_uri_scheme:
 * @uri_scheme: a string containing a URI scheme.
 *
 * Gets the default application for handling URIs with
 * the given URI scheme. A URI scheme is the initial part
 * of the URI, up to but not including the ':', e.g. "http",
 * "ftp" or "sip".
 *
 * Returns: (transfer full) (nullable): #GAppInfo for given @uri_scheme or
 *     %NULL on error.
 */


/**
 * g_app_info_get_default_for_uri_scheme_async:
 * @uri_scheme: a string containing a URI scheme.
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Asynchronously gets the default application for handling URIs with
 * the given URI scheme. A URI scheme is the initial part
 * of the URI, up to but not including the ':', e.g. "http",
 * "ftp" or "sip".
 *
 * Since: 2.74
 */


/**
 * g_app_info_get_default_for_uri_scheme_finish:
 * @result: a #GAsyncResult
 * @error: (nullable): a #GError
 *
 * Finishes a default #GAppInfo lookup started by
 * g_app_info_get_default_for_uri_scheme_async().
 *
 * If no #GAppInfo is found, then @error will be set to %G_IO_ERROR_NOT_FOUND.
 *
 * Returns: (transfer full): #GAppInfo for given @uri_scheme or
 *     %NULL on error.
 * Since: 2.74
 */


/**
 * g_app_info_get_description:
 * @appinfo: a #GAppInfo.
 *
 * Gets a human-readable description of an installed application.
 *
 * Returns: (nullable): a string containing a description of the
 * application @appinfo, or %NULL if none.
 */


/**
 * g_app_info_get_display_name:
 * @appinfo: a #GAppInfo.
 *
 * Gets the display name of the application. The display name is often more
 * descriptive to the user than the name itself.
 *
 * Returns: the display name of the application for @appinfo, or the name if
 * no display name is available.
 * Since: 2.24
 */


/**
 * g_app_info_get_executable: (virtual get_executable)
 * @appinfo: a #GAppInfo
 *
 * Gets the executable's name for the installed application.
 *
 * This is intended to be used for debugging or labelling what program is going
 * to be run. To launch the executable, use g_app_info_launch() and related
 * functions, rather than spawning the return value from this function.
 *
 * Returns: (type filename): a string containing the @appinfo's application
 * binaries name
 */


/**
 * g_app_info_get_fallback_for_type:
 * @content_type: the content type to find a #GAppInfo for
 *
 * Gets a list of fallback #GAppInfos for a given content type, i.e.
 * those applications which claim to support the given content type
 * by MIME type subclassing and not directly.
 *
 * Returns: (element-type GAppInfo) (transfer full): #GList of #GAppInfos
 *     for given @content_type or %NULL on error.
 * Since: 2.28
 */


/**
 * g_app_info_get_icon:
 * @appinfo: a #GAppInfo.
 *
 * Gets the icon for the application.
 *
 * Returns: (nullable) (transfer none): the default #GIcon for @appinfo or %NULL
 * if there is no default icon.
 */


/**
 * g_app_info_get_id:
 * @appinfo: a #GAppInfo.
 *
 * Gets the ID of an application. An id is a string that
 * identifies the application. The exact format of the id is
 * platform dependent. For instance, on Unix this is the
 * desktop file id from the xdg menu specification.
 *
 * Note that the returned ID may be %NULL, depending on how
 * the @appinfo has been constructed.
 *
 * Returns: (nullable): a string containing the application's ID.
 */


/**
 * g_app_info_get_name:
 * @appinfo: a #GAppInfo.
 *
 * Gets the installed name of the application.
 *
 * Returns: the name of the application for @appinfo.
 */


/**
 * g_app_info_get_recommended_for_type:
 * @content_type: the content type to find a #GAppInfo for
 *
 * Gets a list of recommended #GAppInfos for a given content type, i.e.
 * those applications which claim to support the given content type exactly,
 * and not by MIME type subclassing.
 * Note that the first application of the list is the last used one, i.e.
 * the last one for which g_app_info_set_as_last_used_for_type() has been
 * called.
 *
 * Returns: (element-type GAppInfo) (transfer full): #GList of #GAppInfos
 *     for given @content_type or %NULL on error.
 * Since: 2.28
 */


/**
 * g_app_info_get_supported_types:
 * @appinfo: a #GAppInfo that can handle files
 *
 * Retrieves the list of content types that @app_info claims to support.
 * If this information is not provided by the environment, this function
 * will return %NULL.
 * This function does not take in consideration associations added with
 * g_app_info_add_supports_type(), but only those exported directly by
 * the application.
 *
 * Returns: (transfer none) (array zero-terminated=1) (element-type utf8):
 *    a list of content types.
 * Since: 2.34
 */


/**
 * g_app_info_launch:
 * @appinfo: a #GAppInfo
 * @files: (nullable) (element-type GFile): a #GList of #GFile objects
 * @context: (nullable): a #GAppLaunchContext or %NULL
 * @error: a #GError
 *
 * Launches the application. Passes @files to the launched application
 * as arguments, using the optional @context to get information
 * about the details of the launcher (like what screen it is on).
 * On error, @error will be set accordingly.
 *
 * To launch the application without arguments pass a %NULL @files list.
 *
 * Note that even if the launch is successful the application launched
 * can fail to start if it runs into problems during startup. There is
 * no way to detect this.
 *
 * Some URIs can be changed when passed through a GFile (for instance
 * unsupported URIs with strange formats like mailto:), so if you have
 * a textual URI you want to pass in as argument, consider using
 * g_app_info_launch_uris() instead.
 *
 * The launched application inherits the environment of the launching
 * process, but it can be modified with g_app_launch_context_setenv()
 * and g_app_launch_context_unsetenv().
 *
 * On UNIX, this function sets the `GIO_LAUNCHED_DESKTOP_FILE`
 * environment variable with the path of the launched desktop file and
 * `GIO_LAUNCHED_DESKTOP_FILE_PID` to the process id of the launched
 * process. This can be used to ignore `GIO_LAUNCHED_DESKTOP_FILE`,
 * should it be inherited by further processes. The `DISPLAY`,
 * `XDG_ACTIVATION_TOKEN` and `DESKTOP_STARTUP_ID` environment
 * variables are also set, based on information provided in @context.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 */


/**
 * g_app_info_launch_default_for_uri:
 * @uri: the uri to show
 * @context: (nullable): an optional #GAppLaunchContext
 * @error: (nullable): return location for an error, or %NULL
 *
 * Utility function that launches the default application
 * registered to handle the specified uri. Synchronous I/O
 * is done on the uri to detect the type of the file if
 * required.
 *
 * The D-Bus–activated applications don't have to be started if your application
 * terminates too soon after this function. To prevent this, use
 * g_app_info_launch_default_for_uri_async() instead.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_launch_default_for_uri_async:
 * @uri: the uri to show
 * @context: (nullable): an optional #GAppLaunchContext
 * @cancellable: (nullable): a #GCancellable
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Async version of g_app_info_launch_default_for_uri().
 *
 * This version is useful if you are interested in receiving
 * error information in the case where the application is
 * sandboxed and the portal may present an application chooser
 * dialog to the user.
 *
 * This is also useful if you want to be sure that the D-Bus–activated
 * applications are really started before termination and if you are interested
 * in receiving error information from their activation.
 *
 * Since: 2.50
 */


/**
 * g_app_info_launch_default_for_uri_finish:
 * @result: a #GAsyncResult
 * @error: (nullable): return location for an error, or %NULL
 *
 * Finishes an asynchronous launch-default-for-uri operation.
 *
 * Returns: %TRUE if the launch was successful, %FALSE if @error is set
 * Since: 2.50
 */


/**
 * g_app_info_launch_uris:
 * @appinfo: a #GAppInfo
 * @uris: (nullable) (element-type utf8): a #GList containing URIs to launch.
 * @context: (nullable): a #GAppLaunchContext or %NULL
 * @error: a #GError
 *
 * Launches the application. This passes the @uris to the launched application
 * as arguments, using the optional @context to get information
 * about the details of the launcher (like what screen it is on).
 * On error, @error will be set accordingly. If the application only supports
 * one URI per invocation as part of their command-line, multiple instances
 * of the application will be spawned.
 *
 * To launch the application without arguments pass a %NULL @uris list.
 *
 * Note that even if the launch is successful the application launched
 * can fail to start if it runs into problems during startup. There is
 * no way to detect this.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 */


/**
 * g_app_info_launch_uris_async:
 * @appinfo: a #GAppInfo
 * @uris: (nullable) (element-type utf8): a #GList containing URIs to launch.
 * @context: (nullable): a #GAppLaunchContext or %NULL
 * @cancellable: (nullable): a #GCancellable
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Async version of g_app_info_launch_uris().
 *
 * The @callback is invoked immediately after the application launch, but it
 * waits for activation in case of D-Bus–activated applications and also provides
 * extended error information for sandboxed applications, see notes for
 * g_app_info_launch_default_for_uri_async().
 *
 * Since: 2.60
 */


/**
 * g_app_info_launch_uris_finish:
 * @appinfo: a #GAppInfo
 * @result: a #GAsyncResult
 * @error: (nullable): a #GError
 *
 * Finishes a g_app_info_launch_uris_async() operation.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 * Since: 2.60
 */


/**
 * g_app_info_monitor_get:
 *
 * Gets the #GAppInfoMonitor for the current thread-default main
 * context.
 *
 * The #GAppInfoMonitor will emit a "changed" signal in the
 * thread-default main context whenever the list of installed
 * applications (as reported by g_app_info_get_all()) may have changed.
 *
 * The #GAppInfoMonitor::changed signal will only be emitted once until
 * g_app_info_get_all() (or another `g_app_info_*()` function) is called. Doing
 * so will re-arm the signal ready to notify about the next change.
 *
 * You must only call g_object_unref() on the return value from under
 * the same main context as you created it.
 *
 * Returns: (transfer full): a reference to a #GAppInfoMonitor
 * Since: 2.40
 */


/**
 * g_app_info_remove_supports_type:
 * @appinfo: a #GAppInfo.
 * @content_type: a string.
 * @error: a #GError.
 *
 * Removes a supported type from an application, if possible.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_reset_type_associations:
 * @content_type: a content type
 *
 * Removes all changes to the type associations done by
 * g_app_info_set_as_default_for_type(),
 * g_app_info_set_as_default_for_extension(),
 * g_app_info_add_supports_type() or
 * g_app_info_remove_supports_type().
 *
 * Since: 2.20
 */


/**
 * g_app_info_set_as_default_for_extension:
 * @appinfo: a #GAppInfo.
 * @extension: (type filename): a string containing the file extension
 *     (without the dot).
 * @error: a #GError.
 *
 * Sets the application as the default handler for the given file extension.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_set_as_default_for_type:
 * @appinfo: a #GAppInfo.
 * @content_type: the content type.
 * @error: a #GError.
 *
 * Sets the application as the default handler for a given type.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_set_as_last_used_for_type:
 * @appinfo: a #GAppInfo.
 * @content_type: the content type.
 * @error: a #GError.
 *
 * Sets the application as the last used application for a given type.
 * This will make the application appear as first in the list returned
 * by g_app_info_get_recommended_for_type(), regardless of the default
 * application for that content type.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_should_show:
 * @appinfo: a #GAppInfo.
 *
 * Checks if the application info should be shown in menus that
 * list available applications.
 *
 * Returns: %TRUE if the @appinfo should be shown, %FALSE otherwise.
 */


/**
 * g_app_info_supports_files:
 * @appinfo: a #GAppInfo.
 *
 * Checks if the application accepts files as arguments.
 *
 * Returns: %TRUE if the @appinfo supports files.
 */


/**
 * g_app_info_supports_uris:
 * @appinfo: a #GAppInfo.
 *
 * Checks if the application supports reading files and directories from URIs.
 *
 * Returns: %TRUE if the @appinfo supports URIs.
 */


/**
 * g_app_launch_context_get_display:
 * @context: a #GAppLaunchContext
 * @info: a #GAppInfo
 * @files: (element-type GFile): a #GList of #GFile objects
 *
 * Gets the display string for the @context. This is used to ensure new
 * applications are started on the same display as the launching
 * application, by setting the `DISPLAY` environment variable.
 *
 * Returns: (nullable): a display string for the display.
 */


/**
 * g_app_launch_context_get_environment:
 * @context: a #GAppLaunchContext
 *
 * Gets the complete environment variable list to be passed to
 * the child process when @context is used to launch an application.
 * This is a %NULL-terminated array of strings, where each string has
 * the form `KEY=VALUE`.
 *
 * Returns: (array zero-terminated=1) (element-type filename) (transfer full):
 *     the child's environment
 * Since: 2.32
 */


/**
 * g_app_launch_context_get_startup_notify_id:
 * @context: a #GAppLaunchContext
 * @info: a #GAppInfo
 * @files: (element-type GFile): a #GList of #GFile objects
 *
 * Initiates startup notification for the application and returns the
 * `XDG_ACTIVATION_TOKEN` or `DESKTOP_STARTUP_ID` for the launched operation,
 * if supported.
 *
 * The returned token may be referred to equivalently as an ‘activation token’
 * (using Wayland terminology) or a ‘startup sequence ID’ (using X11 terminology).
 * The two [are interoperable](https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/xdg-activation/x11-interoperation.rst).
 *
 * Activation tokens are defined in the [XDG Activation Protocol](https://wayland.app/protocols/xdg-activation-v1),
 * and startup notification IDs are defined in the
 * [freedesktop.org Startup Notification Protocol](http://standards.freedesktop.org/startup-notification-spec/startup-notification-latest.txt).
 *
 * Support for the XDG Activation Protocol was added in GLib 2.76.
 *
 * Returns: (nullable): a startup notification ID for the application, or %NULL if
 *     not supported.
 */


/**
 * g_app_launch_context_launch_failed:
 * @context: a #GAppLaunchContext.
 * @startup_notify_id: the startup notification id that was returned by g_app_launch_context_get_startup_notify_id().
 *
 * Called when an application has failed to launch, so that it can cancel
 * the application startup notification started in g_app_launch_context_get_startup_notify_id().
 */


/**
 * g_app_launch_context_new:
 *
 * Creates a new application launch context. This is not normally used,
 * instead you instantiate a subclass of this, such as #GdkAppLaunchContext.
 *
 * Returns: a #GAppLaunchContext.
 */


/**
 * g_app_launch_context_setenv:
 * @context: a #GAppLaunchContext
 * @variable: (type filename): the environment variable to set
 * @value: (type filename): the value for to set the variable to.
 *
 * Arranges for @variable to be set to @value in the child's
 * environment when @context is used to launch an application.
 *
 * Since: 2.32
 */


/**
 * g_app_launch_context_unsetenv:
 * @context: a #GAppLaunchContext
 * @variable: (type filename): the environment variable to remove
 *
 * Arranges for @variable to be unset in the child's environment
 * when @context is used to launch an application.
 *
 * Since: 2.32
 */


/**
 * g_application_activate:
 * @application: a #GApplication
 *
 * Activates the application.
 *
 * In essence, this results in the #GApplication::activate signal being
 * emitted in the primary instance.
 *
 * The application must be registered before calling this function.
 *
 * Since: 2.28
 */


/**
 * g_application_add_main_option:
 * @application: the #GApplication
 * @long_name: the long name of an option used to specify it in a commandline
 * @short_name: the short name of an option
 * @flags: flags from #GOptionFlags
 * @arg: the type of the option, as a #GOptionArg
 * @description: the description for the option in `--help` output
 * @arg_description: (nullable): the placeholder to use for the extra argument
 *    parsed by the option in `--help` output
 *
 * Add an option to be handled by @application.
 *
 * Calling this function is the equivalent of calling
 * g_application_add_main_option_entries() with a single #GOptionEntry
 * that has its arg_data member set to %NULL.
 *
 * The parsed arguments will be packed into a #GVariantDict which
 * is passed to #GApplication::handle-local-options. If
 * %G_APPLICATION_HANDLES_COMMAND_LINE is set, then it will also
 * be sent to the primary instance. See
 * g_application_add_main_option_entries() for more details.
 *
 * See #GOptionEntry for more documentation of the arguments.
 *
 * Since: 2.42
 */


/**
 * g_application_add_main_option_entries:
 * @application: a #GApplication
 * @entries: (array zero-terminated=1) (element-type GOptionEntry): a
 *           %NULL-terminated list of #GOptionEntrys
 *
 * Adds main option entries to be handled by @application.
 *
 * This function is comparable to g_option_context_add_main_entries().
 *
 * After the commandline arguments are parsed, the
 * #GApplication::handle-local-options signal will be emitted.  At this
 * point, the application can inspect the values pointed to by @arg_data
 * in the given #GOptionEntrys.
 *
 * Unlike #GOptionContext, #GApplication supports giving a %NULL
 * @arg_data for a non-callback #GOptionEntry.  This results in the
 * argument in question being packed into a #GVariantDict which is also
 * passed to #GApplication::handle-local-options, where it can be
 * inspected and modified.  If %G_APPLICATION_HANDLES_COMMAND_LINE is
 * set, then the resulting dictionary is sent to the primary instance,
 * where g_application_command_line_get_options_dict() will return it.
 * As it has been passed outside the process at this point, the types of all
 * values in the options dict must be checked before being used.
 * This "packing" is done according to the type of the argument --
 * booleans for normal flags, strings for strings, bytestrings for
 * filenames, etc.  The packing only occurs if the flag is given (ie: we
 * do not pack a "false" #GVariant in the case that a flag is missing).
 *
 * In general, it is recommended that all commandline arguments are
 * parsed locally.  The options dictionary should then be used to
 * transmit the result of the parsing to the primary instance, where
 * g_variant_dict_lookup() can be used.  For local options, it is
 * possible to either use @arg_data in the usual way, or to consult (and
 * potentially remove) the option from the options dictionary.
 *
 * This function is new in GLib 2.40.  Before then, the only real choice
 * was to send all of the commandline arguments (options and all) to the
 * primary instance for handling.  #GApplication ignored them completely
 * on the local side.  Calling this function "opts in" to the new
 * behaviour, and in particular, means that unrecognised options will be
 * treated as errors.  Unrecognised options have never been ignored when
 * %G_APPLICATION_HANDLES_COMMAND_LINE is unset.
 *
 * If #GApplication::handle-local-options needs to see the list of
 * filenames, then the use of %G_OPTION_REMAINING is recommended.  If
 * @arg_data is %NULL then %G_OPTION_REMAINING can be used as a key into
 * the options dictionary.  If you do use %G_OPTION_REMAINING then you
 * need to handle these arguments for yourself because once they are
 * consumed, they will no longer be visible to the default handling
 * (which treats them as filenames to be opened).
 *
 * It is important to use the proper GVariant format when retrieving
 * the options with g_variant_dict_lookup():
 * - for %G_OPTION_ARG_NONE, use `b`
 * - for %G_OPTION_ARG_STRING, use `&s`
 * - for %G_OPTION_ARG_INT, use `i`
 * - for %G_OPTION_ARG_INT64, use `x`
 * - for %G_OPTION_ARG_DOUBLE, use `d`
 * - for %G_OPTION_ARG_FILENAME, use `^&ay`
 * - for %G_OPTION_ARG_STRING_ARRAY, use `^a&s`
 * - for %G_OPTION_ARG_FILENAME_ARRAY, use `^a&ay`
 *
 * Since: 2.40
 */


/**
 * g_application_add_option_group:
 * @application: the #GApplication
 * @group: (transfer full): a #GOptionGroup
 *
 * Adds a #GOptionGroup to the commandline handling of @application.
 *
 * This function is comparable to g_option_context_add_group().
 *
 * Unlike g_application_add_main_option_entries(), this function does
 * not deal with %NULL @arg_data and never transmits options to the
 * primary instance.
 *
 * The reason for that is because, by the time the options arrive at the
 * primary instance, it is typically too late to do anything with them.
 * Taking the GTK option group as an example: GTK will already have been
 * initialised by the time the #GApplication::command-line handler runs.
 * In the case that this is not the first-running instance of the
 * application, the existing instance may already have been running for
 * a very long time.
 *
 * This means that the options from #GOptionGroup are only really usable
 * in the case that the instance of the application being run is the
 * first instance.  Passing options like `--display=` or `--gdk-debug=`
 * on future runs will have no effect on the existing primary instance.
 *
 * Calling this function will cause the options in the supplied option
 * group to be parsed, but it does not cause you to be "opted in" to the
 * new functionality whereby unrecognised options are rejected even if
 * %G_APPLICATION_HANDLES_COMMAND_LINE was given.
 *
 * Since: 2.40
 */


/**
 * g_application_bind_busy_property:
 * @application: a #GApplication
 * @object: (type GObject.Object): a #GObject
 * @property: the name of a boolean property of @object
 *
 * Marks @application as busy (see g_application_mark_busy()) while
 * @property on @object is %TRUE.
 *
 * The binding holds a reference to @application while it is active, but
 * not to @object. Instead, the binding is destroyed when @object is
 * finalized.
 *
 * Since: 2.44
 */


/**
 * g_application_command_line_create_file_for_arg:
 * @cmdline: a #GApplicationCommandLine
 * @arg: (type filename): an argument from @cmdline
 *
 * Creates a #GFile corresponding to a filename that was given as part
 * of the invocation of @cmdline.
 *
 * This differs from g_file_new_for_commandline_arg() in that it
 * resolves relative pathnames using the current working directory of
 * the invoking process rather than the local process.
 *
 * Returns: (transfer full): a new #GFile
 * Since: 2.36
 */


/**
 * g_application_command_line_get_arguments:
 * @cmdline: a #GApplicationCommandLine
 * @argc: (out) (optional): the length of the arguments array, or %NULL
 *
 * Gets the list of arguments that was passed on the command line.
 *
 * The strings in the array may contain non-UTF-8 data on UNIX (such as
 * filenames or arguments given in the system locale) but are always in
 * UTF-8 on Windows.
 *
 * If you wish to use the return value with #GOptionContext, you must
 * use g_option_context_parse_strv().
 *
 * The return value is %NULL-terminated and should be freed using
 * g_strfreev().
 *
 * Returns: (array length=argc) (element-type filename) (transfer full):
 *      the string array containing the arguments (the argv)
 * Since: 2.28
 */


/**
 * g_application_command_line_get_cwd:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the working directory of the command line invocation.
 * The string may contain non-utf8 data.
 *
 * It is possible that the remote application did not send a working
 * directory, so this may be %NULL.
 *
 * The return value should not be modified or freed and is valid for as
 * long as @cmdline exists.
 *
 * Returns: (nullable) (type filename): the current directory, or %NULL
 * Since: 2.28
 */


/**
 * g_application_command_line_get_environ:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the contents of the 'environ' variable of the command line
 * invocation, as would be returned by g_get_environ(), ie as a
 * %NULL-terminated list of strings in the form 'NAME=VALUE'.
 * The strings may contain non-utf8 data.
 *
 * The remote application usually does not send an environment.  Use
 * %G_APPLICATION_SEND_ENVIRONMENT to affect that.  Even with this flag
 * set it is possible that the environment is still not available (due
 * to invocation messages from other applications).
 *
 * The return value should not be modified or freed and is valid for as
 * long as @cmdline exists.
 *
 * See g_application_command_line_getenv() if you are only interested
 * in the value of a single environment variable.
 *
 * Returns: (array zero-terminated=1) (element-type filename) (transfer none):
 *     the environment strings, or %NULL if they were not sent
 * Since: 2.28
 */


/**
 * g_application_command_line_get_exit_status:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the exit status of @cmdline.  See
 * g_application_command_line_set_exit_status() for more information.
 *
 * Returns: the exit status
 * Since: 2.28
 */


/**
 * g_application_command_line_get_is_remote:
 * @cmdline: a #GApplicationCommandLine
 *
 * Determines if @cmdline represents a remote invocation.
 *
 * Returns: %TRUE if the invocation was remote
 * Since: 2.28
 */


/**
 * g_application_command_line_get_options_dict:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the options that were passed to g_application_command_line().
 *
 * If you did not override local_command_line() then these are the same
 * options that were parsed according to the #GOptionEntrys added to the
 * application with g_application_add_main_option_entries() and possibly
 * modified from your GApplication::handle-local-options handler.
 *
 * If no options were sent then an empty dictionary is returned so that
 * you don't need to check for %NULL.
 *
 * The data has been passed via an untrusted external process, so the types of
 * all values must be checked before being used.
 *
 * Returns: (transfer none): a #GVariantDict with the options
 * Since: 2.40
 */


/**
 * g_application_command_line_get_platform_data:
 * @cmdline: #GApplicationCommandLine
 *
 * Gets the platform data associated with the invocation of @cmdline.
 *
 * This is a #GVariant dictionary containing information about the
 * context in which the invocation occurred.  It typically contains
 * information like the current working directory and the startup
 * notification ID.
 *
 * It comes from an untrusted external process and hence the types of all
 * values must be validated before being used.
 *
 * For local invocation, it will be %NULL.
 *
 * Returns: (nullable) (transfer full): the platform data, or %NULL
 * Since: 2.28
 */


/**
 * g_application_command_line_get_stdin:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the stdin of the invoking process.
 *
 * The #GInputStream can be used to read data passed to the standard
 * input of the invoking process.
 * This doesn't work on all platforms.  Presently, it is only available
 * on UNIX when using a D-Bus daemon capable of passing file descriptors.
 * If stdin is not available then %NULL will be returned.  In the
 * future, support may be expanded to other platforms.
 *
 * You must only call this function once per commandline invocation.
 *
 * Returns: (nullable) (transfer full): a #GInputStream for stdin
 * Since: 2.34
 */


/**
 * g_application_command_line_getenv:
 * @cmdline: a #GApplicationCommandLine
 * @name: (type filename): the environment variable to get
 *
 * Gets the value of a particular environment variable of the command
 * line invocation, as would be returned by g_getenv().  The strings may
 * contain non-utf8 data.
 *
 * The remote application usually does not send an environment.  Use
 * %G_APPLICATION_SEND_ENVIRONMENT to affect that.  Even with this flag
 * set it is possible that the environment is still not available (due
 * to invocation messages from other applications).
 *
 * The return value should not be modified or freed and is valid for as
 * long as @cmdline exists.
 *
 * Returns: (nullable): the value of the variable, or %NULL if unset or unsent
 * Since: 2.28
 */


/**
 * g_application_command_line_print:
 * @cmdline: a #GApplicationCommandLine
 * @format: a printf-style format string
 * @...: arguments, as per @format
 *
 * Formats a message and prints it using the stdout print handler in the
 * invoking process.
 *
 * If @cmdline is a local invocation then this is exactly equivalent to
 * g_print().  If @cmdline is remote then this is equivalent to calling
 * g_print() in the invoking process.
 *
 * Since: 2.28
 */


/**
 * g_application_command_line_printerr:
 * @cmdline: a #GApplicationCommandLine
 * @format: a printf-style format string
 * @...: arguments, as per @format
 *
 * Formats a message and prints it using the stderr print handler in the
 * invoking process.
 *
 * If @cmdline is a local invocation then this is exactly equivalent to
 * g_printerr().  If @cmdline is remote then this is equivalent to
 * calling g_printerr() in the invoking process.
 *
 * Since: 2.28
 */


/**
 * g_application_command_line_set_exit_status:
 * @cmdline: a #GApplicationCommandLine
 * @exit_status: the exit status
 *
 * Sets the exit status that will be used when the invoking process
 * exits.
 *
 * The return value of the #GApplication::command-line signal is
 * passed to this function when the handler returns.  This is the usual
 * way of setting the exit status.
 *
 * In the event that you want the remote invocation to continue running
 * and want to decide on the exit status in the future, you can use this
 * call.  For the case of a remote invocation, the remote process will
 * typically exit when the last reference is dropped on @cmdline.  The
 * exit status of the remote process will be equal to the last value
 * that was set with this function.
 *
 * In the case that the commandline invocation is local, the situation
 * is slightly more complicated.  If the commandline invocation results
 * in the mainloop running (ie: because the use-count of the application
 * increased to a non-zero value) then the application is considered to
 * have been 'successful' in a certain sense, and the exit status is
 * always zero.  If the application use count is zero, though, the exit
 * status of the local #GApplicationCommandLine is used.
 *
 * Since: 2.28
 */


/**
 * g_application_get_application_id:
 * @application: a #GApplication
 *
 * Gets the unique identifier for @application.
 *
 * Returns: (nullable): the identifier for @application, owned by @application
 * Since: 2.28
 */


/**
 * g_application_get_dbus_connection:
 * @application: a #GApplication
 *
 * Gets the #GDBusConnection being used by the application, or %NULL.
 *
 * If #GApplication is using its D-Bus backend then this function will
 * return the #GDBusConnection being used for uniqueness and
 * communication with the desktop environment and other instances of the
 * application.
 *
 * If #GApplication is not using D-Bus then this function will return
 * %NULL.  This includes the situation where the D-Bus backend would
 * normally be in use but we were unable to connect to the bus.
 *
 * This function must not be called before the application has been
 * registered.  See g_application_get_is_registered().
 *
 * Returns: (nullable) (transfer none): a #GDBusConnection, or %NULL
 * Since: 2.34
 */


/**
 * g_application_get_dbus_object_path:
 * @application: a #GApplication
 *
 * Gets the D-Bus object path being used by the application, or %NULL.
 *
 * If #GApplication is using its D-Bus backend then this function will
 * return the D-Bus object path that #GApplication is using.  If the
 * application is the primary instance then there is an object published
 * at this path.  If the application is not the primary instance then
 * the result of this function is undefined.
 *
 * If #GApplication is not using D-Bus then this function will return
 * %NULL.  This includes the situation where the D-Bus backend would
 * normally be in use but we were unable to connect to the bus.
 *
 * This function must not be called before the application has been
 * registered.  See g_application_get_is_registered().
 *
 * Returns: (nullable): the object path, or %NULL
 * Since: 2.34
 */


/**
 * g_application_get_default:
 *
 * Returns the default #GApplication instance for this process.
 *
 * Normally there is only one #GApplication per process and it becomes
 * the default when it is created.  You can exercise more control over
 * this by using g_application_set_default().
 *
 * If there is no default application then %NULL is returned.
 *
 * Returns: (nullable) (transfer none): the default application for this process, or %NULL
 * Since: 2.32
 */


/**
 * g_application_get_flags:
 * @application: a #GApplication
 *
 * Gets the flags for @application.
 *
 * See #GApplicationFlags.
 *
 * Returns: the flags for @application
 * Since: 2.28
 */


/**
 * g_application_get_inactivity_timeout:
 * @application: a #GApplication
 *
 * Gets the current inactivity timeout for the application.
 *
 * This is the amount of time (in milliseconds) after the last call to
 * g_application_release() before the application stops running.
 *
 * Returns: the timeout, in milliseconds
 * Since: 2.28
 */


/**
 * g_application_get_is_busy:
 * @application: a #GApplication
 *
 * Gets the application's current busy state, as set through
 * g_application_mark_busy() or g_application_bind_busy_property().
 *
 * Returns: %TRUE if @application is currently marked as busy
 * Since: 2.44
 */


/**
 * g_application_get_is_registered:
 * @application: a #GApplication
 *
 * Checks if @application is registered.
 *
 * An application is registered if g_application_register() has been
 * successfully called.
 *
 * Returns: %TRUE if @application is registered
 * Since: 2.28
 */


/**
 * g_application_get_is_remote:
 * @application: a #GApplication
 *
 * Checks if @application is remote.
 *
 * If @application is remote then it means that another instance of
 * application already exists (the 'primary' instance).  Calls to
 * perform actions on @application will result in the actions being
 * performed by the primary instance.
 *
 * The value of this property cannot be accessed before
 * g_application_register() has been called.  See
 * g_application_get_is_registered().
 *
 * Returns: %TRUE if @application is remote
 * Since: 2.28
 */


/**
 * g_application_get_resource_base_path:
 * @application: a #GApplication
 *
 * Gets the resource base path of @application.
 *
 * See g_application_set_resource_base_path() for more information.
 *
 * Returns: (nullable): the base resource path, if one is set
 * Since: 2.42
 */


/**
 * g_application_hold:
 * @application: a #GApplication
 *
 * Increases the use count of @application.
 *
 * Use this function to indicate that the application has a reason to
 * continue to run.  For example, g_application_hold() is called by GTK
 * when a toplevel window is on the screen.
 *
 * To cancel the hold, call g_application_release().
 */


/**
 * g_application_id_is_valid:
 * @application_id: a potential application identifier
 *
 * Checks if @application_id is a valid application identifier.
 *
 * A valid ID is required for calls to g_application_new() and
 * g_application_set_application_id().
 *
 * Application identifiers follow the same format as
 * [D-Bus well-known bus names](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-bus).
 * For convenience, the restrictions on application identifiers are
 * reproduced here:
 *
 * - Application identifiers are composed of 1 or more elements separated by a
 *   period (`.`) character. All elements must contain at least one character.
 *
 * - Each element must only contain the ASCII characters `[A-Z][a-z][0-9]_-`,
 *   with `-` discouraged in new application identifiers. Each element must not
 *   begin with a digit.
 *
 * - Application identifiers must contain at least one `.` (period) character
 *   (and thus at least two elements).
 *
 * - Application identifiers must not begin with a `.` (period) character.
 *
 * - Application identifiers must not exceed 255 characters.
 *
 * Note that the hyphen (`-`) character is allowed in application identifiers,
 * but is problematic or not allowed in various specifications and APIs that
 * refer to D-Bus, such as
 * [Flatpak application IDs](http://docs.flatpak.org/en/latest/introduction.html#identifiers),
 * the
 * [`DBusActivatable` interface in the Desktop Entry Specification](https://specifications.freedesktop.org/desktop-entry-spec/desktop-entry-spec-latest.html#dbus),
 * and the convention that an application's "main" interface and object path
 * resemble its application identifier and bus name. To avoid situations that
 * require special-case handling, it is recommended that new application
 * identifiers consistently replace hyphens with underscores.
 *
 * Like D-Bus interface names, application identifiers should start with the
 * reversed DNS domain name of the author of the interface (in lower-case), and
 * it is conventional for the rest of the application identifier to consist of
 * words run together, with initial capital letters.
 *
 * As with D-Bus interface names, if the author's DNS domain name contains
 * hyphen/minus characters they should be replaced by underscores, and if it
 * contains leading digits they should be escaped by prepending an underscore.
 * For example, if the owner of 7-zip.org used an application identifier for an
 * archiving application, it might be named `org._7_zip.Archiver`.
 *
 * Returns: %TRUE if @application_id is valid
 */


/**
 * g_application_mark_busy:
 * @application: a #GApplication
 *
 * Increases the busy count of @application.
 *
 * Use this function to indicate that the application is busy, for instance
 * while a long running operation is pending.
 *
 * The busy state will be exposed to other processes, so a session shell will
 * use that information to indicate the state to the user (e.g. with a
 * spinner).
 *
 * To cancel the busy indication, use g_application_unmark_busy().
 *
 * The application must be registered before calling this function.
 *
 * Since: 2.38
 */


/**
 * g_application_new:
 * @application_id: (nullable): the application id
 * @flags: the application flags
 *
 * Creates a new #GApplication instance.
 *
 * If non-%NULL, the application id must be valid.  See
 * g_application_id_is_valid().
 *
 * If no application ID is given then some features of #GApplication
 * (most notably application uniqueness) will be disabled.
 *
 * Returns: a new #GApplication instance
 */


/**
 * g_application_open:
 * @application: a #GApplication
 * @files: (array length=n_files): an array of #GFiles to open
 * @n_files: the length of the @files array
 * @hint: a hint (or ""), but never %NULL
 *
 * Opens the given files.
 *
 * In essence, this results in the #GApplication::open signal being emitted
 * in the primary instance.
 *
 * @n_files must be greater than zero.
 *
 * @hint is simply passed through to the ::open signal.  It is
 * intended to be used by applications that have multiple modes for
 * opening files (eg: "view" vs "edit", etc).  Unless you have a need
 * for this functionality, you should use "".
 *
 * The application must be registered before calling this function
 * and it must have the %G_APPLICATION_HANDLES_OPEN flag set.
 *
 * Since: 2.28
 */


/**
 * g_application_quit:
 * @application: a #GApplication
 *
 * Immediately quits the application.
 *
 * Upon return to the mainloop, g_application_run() will return,
 * calling only the 'shutdown' function before doing so.
 *
 * The hold count is ignored.
 * Take care if your code has called g_application_hold() on the application and
 * is therefore still expecting it to exist.
 * (Note that you may have called g_application_hold() indirectly, for example
 * through gtk_application_add_window().)
 *
 * The result of calling g_application_run() again after it returns is
 * unspecified.
 *
 * Since: 2.32
 */


/**
 * g_application_register:
 * @application: a #GApplication
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @error: a pointer to a NULL #GError, or %NULL
 *
 * Attempts registration of the application.
 *
 * This is the point at which the application discovers if it is the
 * primary instance or merely acting as a remote for an already-existing
 * primary instance.  This is implemented by attempting to acquire the
 * application identifier as a unique bus name on the session bus using
 * GDBus.
 *
 * If there is no application ID or if %G_APPLICATION_NON_UNIQUE was
 * given, then this process will always become the primary instance.
 *
 * Due to the internal architecture of GDBus, method calls can be
 * dispatched at any time (even if a main loop is not running).  For
 * this reason, you must ensure that any object paths that you wish to
 * register are registered before calling this function.
 *
 * If the application has already been registered then %TRUE is
 * returned with no work performed.
 *
 * The #GApplication::startup signal is emitted if registration succeeds
 * and @application is the primary instance (including the non-unique
 * case).
 *
 * In the event of an error (such as @cancellable being cancelled, or a
 * failure to connect to the session bus), %FALSE is returned and @error
 * is set appropriately.
 *
 * Note: the return value of this function is not an indicator that this
 * instance is or is not the primary instance of the application.  See
 * g_application_get_is_remote() for that.
 *
 * Returns: %TRUE if registration succeeded
 * Since: 2.28
 */


/**
 * g_application_release:
 * @application: a #GApplication
 *
 * Decrease the use count of @application.
 *
 * When the use count reaches zero, the application will stop running.
 *
 * Never call this function except to cancel the effect of a previous
 * call to g_application_hold().
 */


/**
 * g_application_run:
 * @application: a #GApplication
 * @argc: the argc from main() (or 0 if @argv is %NULL)
 * @argv: (array length=argc) (element-type filename) (nullable):
 *     the argv from main(), or %NULL
 *
 * Runs the application.
 *
 * This function is intended to be run from main() and its return value
 * is intended to be returned by main(). Although you are expected to pass
 * the @argc, @argv parameters from main() to this function, it is possible
 * to pass %NULL if @argv is not available or commandline handling is not
 * required.  Note that on Windows, @argc and @argv are ignored, and
 * g_win32_get_command_line() is called internally (for proper support
 * of Unicode commandline arguments).
 *
 * #GApplication will attempt to parse the commandline arguments.  You
 * can add commandline flags to the list of recognised options by way of
 * g_application_add_main_option_entries().  After this, the
 * #GApplication::handle-local-options signal is emitted, from which the
 * application can inspect the values of its #GOptionEntrys.
 *
 * #GApplication::handle-local-options is a good place to handle options
 * such as `--version`, where an immediate reply from the local process is
 * desired (instead of communicating with an already-running instance).
 * A #GApplication::handle-local-options handler can stop further processing
 * by returning a non-negative value, which then becomes the exit status of
 * the process.
 *
 * What happens next depends on the flags: if
 * %G_APPLICATION_HANDLES_COMMAND_LINE was specified then the remaining
 * commandline arguments are sent to the primary instance, where a
 * #GApplication::command-line signal is emitted.  Otherwise, the
 * remaining commandline arguments are assumed to be a list of files.
 * If there are no files listed, the application is activated via the
 * #GApplication::activate signal.  If there are one or more files, and
 * %G_APPLICATION_HANDLES_OPEN was specified then the files are opened
 * via the #GApplication::open signal.
 *
 * If you are interested in doing more complicated local handling of the
 * commandline then you should implement your own #GApplication subclass
 * and override local_command_line(). In this case, you most likely want
 * to return %TRUE from your local_command_line() implementation to
 * suppress the default handling. See
 * [gapplication-example-cmdline2.c][https://gitlab.gnome.org/GNOME/glib/-/blob/HEAD/gio/tests/gapplication-example-cmdline2.c]
 * for an example.
 *
 * If, after the above is done, the use count of the application is zero
 * then the exit status is returned immediately.  If the use count is
 * non-zero then the default main context is iterated until the use count
 * falls to zero, at which point 0 is returned.
 *
 * If the %G_APPLICATION_IS_SERVICE flag is set, then the service will
 * run for as much as 10 seconds with a use count of zero while waiting
 * for the message that caused the activation to arrive.  After that,
 * if the use count falls to zero the application will exit immediately,
 * except in the case that g_application_set_inactivity_timeout() is in
 * use.
 *
 * This function sets the prgname (g_set_prgname()), if not already set,
 * to the basename of argv[0].
 *
 * Much like g_main_loop_run(), this function will acquire the main context
 * for the duration that the application is running.
 *
 * Since 2.40, applications that are not explicitly flagged as services
 * or launchers (ie: neither %G_APPLICATION_IS_SERVICE or
 * %G_APPLICATION_IS_LAUNCHER are given as flags) will check (from the
 * default handler for local_command_line) if "--gapplication-service"
 * was given in the command line.  If this flag is present then normal
 * commandline processing is interrupted and the
 * %G_APPLICATION_IS_SERVICE flag is set.  This provides a "compromise"
 * solution whereby running an application directly from the commandline
 * will invoke it in the normal way (which can be useful for debugging)
 * while still allowing applications to be D-Bus activated in service
 * mode.  The D-Bus service file should invoke the executable with
 * "--gapplication-service" as the sole commandline argument.  This
 * approach is suitable for use by most graphical applications but
 * should not be used from applications like editors that need precise
 * control over when processes invoked via the commandline will exit and
 * what their exit status will be.
 *
 * Returns: the exit status
 * Since: 2.28
 */


/**
 * g_application_send_notification:
 * @application: a #GApplication
 * @id: (nullable): id of the notification, or %NULL
 * @notification: the #GNotification to send
 *
 * Sends a notification on behalf of @application to the desktop shell.
 * There is no guarantee that the notification is displayed immediately,
 * or even at all.
 *
 * Notifications may persist after the application exits. It will be
 * D-Bus-activated when the notification or one of its actions is
 * activated.
 *
 * Modifying @notification after this call has no effect. However, the
 * object can be reused for a later call to this function.
 *
 * @id may be any string that uniquely identifies the event for the
 * application. It does not need to be in any special format. For
 * example, "new-message" might be appropriate for a notification about
 * new messages.
 *
 * If a previous notification was sent with the same @id, it will be
 * replaced with @notification and shown again as if it was a new
 * notification. This works even for notifications sent from a previous
 * execution of the application, as long as @id is the same string.
 *
 * @id may be %NULL, but it is impossible to replace or withdraw
 * notifications without an id.
 *
 * If @notification is no longer relevant, it can be withdrawn with
 * g_application_withdraw_notification().
 *
 * Since: 2.40
 */


/**
 * g_application_set_action_group:
 * @application: a #GApplication
 * @action_group: (nullable): a #GActionGroup, or %NULL
 *
 * This used to be how actions were associated with a #GApplication.
 * Now there is #GActionMap for that.
 *
 * Since: 2.28
 * Deprecated: 2.32: Use the #GActionMap interface instead.  Never ever
 * mix use of this API with use of #GActionMap on the same @application
 * or things will go very badly wrong.  This function is known to
 * introduce buggy behaviour (ie: signals not emitted on changes to the
 * action group), so you should really use #GActionMap instead.
 */


/**
 * g_application_set_application_id:
 * @application: a #GApplication
 * @application_id: (nullable): the identifier for @application
 *
 * Sets the unique identifier for @application.
 *
 * The application id can only be modified if @application has not yet
 * been registered.
 *
 * If non-%NULL, the application id must be valid.  See
 * g_application_id_is_valid().
 *
 * Since: 2.28
 */


/**
 * g_application_set_default:
 * @application: (nullable): the application to set as default, or %NULL
 *
 * Sets or unsets the default application for the process, as returned
 * by g_application_get_default().
 *
 * This function does not take its own reference on @application.  If
 * @application is destroyed then the default application will revert
 * back to %NULL.
 *
 * Since: 2.32
 */


/**
 * g_application_set_flags:
 * @application: a #GApplication
 * @flags: the flags for @application
 *
 * Sets the flags for @application.
 *
 * The flags can only be modified if @application has not yet been
 * registered.
 *
 * See #GApplicationFlags.
 *
 * Since: 2.28
 */


/**
 * g_application_set_inactivity_timeout:
 * @application: a #GApplication
 * @inactivity_timeout: the timeout, in milliseconds
 *
 * Sets the current inactivity timeout for the application.
 *
 * This is the amount of time (in milliseconds) after the last call to
 * g_application_release() before the application stops running.
 *
 * This call has no side effects of its own.  The value set here is only
 * used for next time g_application_release() drops the use count to
 * zero.  Any timeouts currently in progress are not impacted.
 *
 * Since: 2.28
 */


/**
 * g_application_set_option_context_description:
 * @application: the #GApplication
 * @description: (nullable): a string to be shown in `--help` output
 *  after the list of options, or %NULL
 *
 * Adds a description to the @application option context.
 *
 * See g_option_context_set_description() for more information.
 *
 * Since: 2.56
 */


/**
 * g_application_set_option_context_parameter_string:
 * @application: the #GApplication
 * @parameter_string: (nullable): a string which is displayed
 *   in the first line of `--help` output, after the usage summary `programname [OPTION...]`.
 *
 * Sets the parameter string to be used by the commandline handling of @application.
 *
 * This function registers the argument to be passed to g_option_context_new()
 * when the internal #GOptionContext of @application is created.
 *
 * See g_option_context_new() for more information about @parameter_string.
 *
 * Since: 2.56
 */


/**
 * g_application_set_option_context_summary:
 * @application: the #GApplication
 * @summary: (nullable): a string to be shown in `--help` output
 *  before the list of options, or %NULL
 *
 * Adds a summary to the @application option context.
 *
 * See g_option_context_set_summary() for more information.
 *
 * Since: 2.56
 */


/**
 * g_application_set_resource_base_path:
 * @application: a #GApplication
 * @resource_path: (nullable): the resource path to use
 *
 * Sets (or unsets) the base resource path of @application.
 *
 * The path is used to automatically load various [application
 * resources][gresource] such as menu layouts and action descriptions.
 * The various types of resources will be found at fixed names relative
 * to the given base path.
 *
 * By default, the resource base path is determined from the application
 * ID by prefixing '/' and replacing each '.' with '/'.  This is done at
 * the time that the #GApplication object is constructed.  Changes to
 * the application ID after that point will not have an impact on the
 * resource base path.
 *
 * As an example, if the application has an ID of "org.example.app" then
 * the default resource base path will be "/org/example/app".  If this
 * is a #GtkApplication (and you have not manually changed the path)
 * then Gtk will then search for the menus of the application at
 * "/org/example/app/gtk/menus.ui".
 *
 * See #GResource for more information about adding resources to your
 * application.
 *
 * You can disable automatic resource loading functionality by setting
 * the path to %NULL.
 *
 * Changing the resource base path once the application is running is
 * not recommended.  The point at which the resource path is consulted
 * for forming paths for various purposes is unspecified.  When writing
 * a sub-class of #GApplication you should either set the
 * #GApplication:resource-base-path property at construction time, or call
 * this function during the instance initialization. Alternatively, you
 * can call this function in the #GApplicationClass.startup virtual function,
 * before chaining up to the parent implementation.
 *
 * Since: 2.42
 */


/**
 * g_application_unbind_busy_property:
 * @application: a #GApplication
 * @object: (type GObject.Object): a #GObject
 * @property: the name of a boolean property of @object
 *
 * Destroys a binding between @property and the busy state of
 * @application that was previously created with
 * g_application_bind_busy_property().
 *
 * Since: 2.44
 */


/**
 * g_application_unmark_busy:
 * @application: a #GApplication
 *
 * Decreases the busy count of @application.
 *
 * When the busy count reaches zero, the new state will be propagated
 * to other processes.
 *
 * This function must only be called to cancel the effect of a previous
 * call to g_application_mark_busy().
 *
 * Since: 2.38
 */


/**
 * g_application_withdraw_notification:
 * @application: a #GApplication
 * @id: id of a previously sent notification
 *
 * Withdraws a notification that was sent with
 * g_application_send_notification().
 *
 * This call does nothing if a notification with @id doesn't exist or
 * the notification was never sent.
 *
 * This function works even for notifications sent in previous
 * executions of this application, as long @id is the same as it was for
 * the sent notification.
 *
 * Note that notifications are dismissed when the user clicks on one
 * of the buttons in a notification or triggers its default action, so
 * there is no need to explicitly withdraw the notification in that case.
 *
 * Since: 2.40
 */


/**
 * g_async_initable_init_async:
 * @initable: a #GAsyncInitable.
 * @io_priority: the [I/O priority][io-priority] of the operation
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts asynchronous initialization of the object implementing the
 * interface. This must be done before any real use of the object after
 * initial construction. If the object also implements #GInitable you can
 * optionally call g_initable_init() instead.
 *
 * This method is intended for language bindings. If writing in C,
 * g_async_initable_new_async() should typically be used instead.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_init_finish() to get the result of the
 * initialization.
 *
 * Implementations may also support cancellation. If @cancellable is not
 * %NULL, then initialization can be cancelled by triggering the cancellable
 * object from another thread. If the operation was cancelled, the error
 * %G_IO_ERROR_CANCELLED will be returned. If @cancellable is not %NULL, and
 * the object doesn't support cancellable initialization, the error
 * %G_IO_ERROR_NOT_SUPPORTED will be returned.
 *
 * As with #GInitable, if the object is not initialized, or initialization
 * returns with an error, then all operations on the object except
 * g_object_ref() and g_object_unref() are considered to be invalid, and
 * have undefined behaviour. They will often fail with g_critical() or
 * g_warning(), but this must not be relied on.
 *
 * Callers should not assume that a class which implements #GAsyncInitable can
 * be initialized multiple times; for more information, see g_initable_init().
 * If a class explicitly supports being initialized multiple times,
 * implementation requires yielding all subsequent calls to init_async() on the
 * results of the first call.
 *
 * For classes that also support the #GInitable interface, the default
 * implementation of this method will run the g_initable_init() function
 * in a thread, so if you want to support asynchronous initialization via
 * threads, just implement the #GAsyncInitable interface without overriding
 * any interface methods.
 *
 * Since: 2.22
 */


/**
 * g_async_initable_init_finish:
 * @initable: a #GAsyncInitable.
 * @res: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes asynchronous initialization and returns the result.
 * See g_async_initable_init_async().
 *
 * Returns: %TRUE if successful. If an error has occurred, this function
 * will return %FALSE and set @error appropriately if present.
 * Since: 2.22
 */


/**
 * g_async_initable_new_async:
 * @object_type: a #GType supporting #GAsyncInitable.
 * @io_priority: the [I/O priority][io-priority] of the operation
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the initialization is
 *     finished
 * @user_data: the data to pass to callback function
 * @first_property_name: (nullable): the name of the first property, or %NULL if no
 *     properties
 * @...: the value of the first property, followed by other property
 *    value pairs, and ended by %NULL.
 *
 * Helper function for constructing #GAsyncInitable object. This is
 * similar to g_object_new() but also initializes the object asynchronously.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_new_finish() to get the new object and check
 * for any errors.
 *
 * Since: 2.22
 */


/**
 * g_async_initable_new_finish:
 * @initable: the #GAsyncInitable from the callback
 * @res: the #GAsyncResult from the callback
 * @error: return location for errors, or %NULL to ignore
 *
 * Finishes the async construction for the various g_async_initable_new
 * calls, returning the created object or %NULL on error.
 *
 * Returns: (type GObject.Object) (transfer full): a newly created #GObject,
 *      or %NULL on error. Free with g_object_unref().
 * Since: 2.22
 */


/**
 * g_async_initable_new_valist_async:
 * @object_type: a #GType supporting #GAsyncInitable.
 * @first_property_name: the name of the first property, followed by
 * the value, and other property value pairs, and ended by %NULL.
 * @var_args: The var args list generated from @first_property_name.
 * @io_priority: the [I/O priority][io-priority] of the operation
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the initialization is
 *     finished
 * @user_data: the data to pass to callback function
 *
 * Helper function for constructing #GAsyncInitable object. This is
 * similar to g_object_new_valist() but also initializes the object
 * asynchronously.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_new_finish() to get the new object and check
 * for any errors.
 *
 * Since: 2.22
 */


/**
 * g_async_initable_newv_async:
 * @object_type: a #GType supporting #GAsyncInitable.
 * @n_parameters: the number of parameters in @parameters
 * @parameters: the parameters to use to construct the object
 * @io_priority: the [I/O priority][io-priority] of the operation
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the initialization is
 *     finished
 * @user_data: the data to pass to callback function
 *
 * Helper function for constructing #GAsyncInitable object. This is
 * similar to g_object_newv() but also initializes the object asynchronously.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_new_finish() to get the new object and check
 * for any errors.
 *
 * Since: 2.22
 * Deprecated: 2.54: Use g_object_new_with_properties() and
 * g_async_initable_init_async() instead. See #GParameter for more information.
 */


/**
 * g_async_result_get_source_object:
 * @res: a #GAsyncResult
 *
 * Gets the source object from a #GAsyncResult.
 *
 * Returns: (transfer full) (nullable): a new reference to the source
 *    object for the @res, or %NULL if there is none.
 */


/**
 * g_async_result_get_user_data:
 * @res: a #GAsyncResult.
 *
 * Gets the user data from a #GAsyncResult.
 *
 * Returns: (transfer full): the user data for @res.
 */


/**
 * g_async_result_is_tagged:
 * @res: a #GAsyncResult
 * @source_tag: an application-defined tag
 *
 * Checks if @res has the given @source_tag (generally a function
 * pointer indicating the function @res was created by).
 *
 * Returns: %TRUE if @res has the indicated @source_tag, %FALSE if
 *   not.
 * Since: 2.34
 */


/**
 * g_async_result_legacy_propagate_error:
 * @res: a #GAsyncResult
 * @error: (out): a location to propagate the error to.
 *
 * If @res is a #GSimpleAsyncResult, this is equivalent to
 * g_simple_async_result_propagate_error(). Otherwise it returns
 * %FALSE.
 *
 * This can be used for legacy error handling in async *_finish()
 * wrapper functions that traditionally handled #GSimpleAsyncResult
 * error returns themselves rather than calling into the virtual method.
 * This should not be used in new code; #GAsyncResult errors that are
 * set by virtual methods should also be extracted by virtual methods,
 * to enable subclasses to chain up correctly.
 *
 * Returns: %TRUE if @error is has been filled in with an error from
 *   @res, %FALSE if not.
 * Since: 2.34
 */


/**
 * g_buffered_input_stream_fill:
 * @stream: a #GBufferedInputStream
 * @count: the number of bytes that will be read from the stream
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read @count bytes from the stream into the buffer.
 * Will block during this read.
 *
 * If @count is zero, returns zero and does nothing. A value of @count
 * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes read into the buffer is returned.
 * It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file. Zero is returned on end of file
 * (or if @count is zero),  but never otherwise.
 *
 * If @count is -1 then the attempted read size is equal to the number of
 * bytes that are required to fill the buffer.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error -1 is returned and @error is set accordingly.
 *
 * For the asynchronous, non-blocking, version of this function, see
 * g_buffered_input_stream_fill_async().
 *
 * Returns: the number of bytes read into @stream's buffer, up to @count,
 *     or -1 on error.
 */


/**
 * g_buffered_input_stream_fill_async:
 * @stream: a #GBufferedInputStream
 * @count: the number of bytes that will be read from the stream
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 * @user_data: a #gpointer
 *
 * Reads data into @stream's buffer asynchronously, up to @count size.
 * @io_priority can be used to prioritize reads. For the synchronous
 * version of this function, see g_buffered_input_stream_fill().
 *
 * If @count is -1 then the attempted read size is equal to the number
 * of bytes that are required to fill the buffer.
 */


/**
 * g_buffered_input_stream_fill_finish:
 * @stream: a #GBufferedInputStream
 * @result: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an asynchronous read.
 *
 * Returns: a #gssize of the read stream, or `-1` on an error.
 */


/**
 * g_buffered_input_stream_get_available:
 * @stream: #GBufferedInputStream
 *
 * Gets the size of the available data within the stream.
 *
 * Returns: size of the available stream.
 */


/**
 * g_buffered_input_stream_get_buffer_size:
 * @stream: a #GBufferedInputStream
 *
 * Gets the size of the input buffer.
 *
 * Returns: the current buffer size.
 */


/**
 * g_buffered_input_stream_new:
 * @base_stream: a #GInputStream
 *
 * Creates a new #GInputStream from the given @base_stream, with
 * a buffer set to the default size (4 kilobytes).
 *
 * Returns: a #GInputStream for the given @base_stream.
 */


/**
 * g_buffered_input_stream_new_sized:
 * @base_stream: a #GInputStream
 * @size: a #gsize
 *
 * Creates a new #GBufferedInputStream from the given @base_stream,
 * with a buffer set to @size.
 *
 * Returns: a #GInputStream.
 */


/**
 * g_buffered_input_stream_peek:
 * @stream: a #GBufferedInputStream
 * @buffer: (array length=count) (element-type guint8): a pointer to
 *   an allocated chunk of memory
 * @offset: a #gsize
 * @count: a #gsize
 *
 * Peeks in the buffer, copying data of size @count into @buffer,
 * offset @offset bytes.
 *
 * Returns: a #gsize of the number of bytes peeked, or -1 on error.
 */


/**
 * g_buffered_input_stream_peek_buffer:
 * @stream: a #GBufferedInputStream
 * @count: (out): a #gsize to get the number of bytes available in the buffer
 *
 * Returns the buffer with the currently available bytes. The returned
 * buffer must not be modified and will become invalid when reading from
 * the stream or filling the buffer.
 *
 * Returns: (array length=count) (element-type guint8) (transfer none):
 *          read-only buffer
 */


/**
 * g_buffered_input_stream_read_byte:
 * @stream: a #GBufferedInputStream
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read a single byte from the stream or the buffer. Will block
 * during this read.
 *
 * On success, the byte read from the stream is returned. On end of stream
 * -1 is returned but it's not an exceptional error and @error is not set.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error -1 is returned and @error is set accordingly.
 *
 * Returns: the byte read from the @stream, or -1 on end of stream or error.
 */


/**
 * g_buffered_input_stream_set_buffer_size:
 * @stream: a #GBufferedInputStream
 * @size: a #gsize
 *
 * Sets the size of the internal buffer of @stream to @size, or to the
 * size of the contents of the buffer. The buffer can never be resized
 * smaller than its current contents.
 */


/**
 * g_buffered_output_stream_get_auto_grow:
 * @stream: a #GBufferedOutputStream.
 *
 * Checks if the buffer automatically grows as data is added.
 *
 * Returns: %TRUE if the @stream's buffer automatically grows,
 * %FALSE otherwise.
 */


/**
 * g_buffered_output_stream_get_buffer_size:
 * @stream: a #GBufferedOutputStream.
 *
 * Gets the size of the buffer in the @stream.
 *
 * Returns: the current size of the buffer.
 */


/**
 * g_buffered_output_stream_new:
 * @base_stream: a #GOutputStream.
 *
 * Creates a new buffered output stream for a base stream.
 *
 * Returns: a #GOutputStream for the given @base_stream.
 */


/**
 * g_buffered_output_stream_new_sized:
 * @base_stream: a #GOutputStream.
 * @size: a #gsize.
 *
 * Creates a new buffered output stream with a given buffer size.
 *
 * Returns: a #GOutputStream with an internal buffer set to @size.
 */


/**
 * g_buffered_output_stream_set_auto_grow:
 * @stream: a #GBufferedOutputStream.
 * @auto_grow: a #gboolean.
 *
 * Sets whether or not the @stream's buffer should automatically grow.
 * If @auto_grow is true, then each write will just make the buffer
 * larger, and you must manually flush the buffer to actually write out
 * the data to the underlying stream.
 */


/**
 * g_buffered_output_stream_set_buffer_size:
 * @stream: a #GBufferedOutputStream.
 * @size: a #gsize.
 *
 * Sets the size of the internal buffer to @size.
 */


/**
 * g_bus_get:
 * @bus_type: a #GBusType
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to @callback
 *
 * Asynchronously connects to the message bus specified by @bus_type.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_bus_get_finish() to get the result of the operation.
 *
 * This is an asynchronous failable function. See g_bus_get_sync() for
 * the synchronous version.
 *
 * Since: 2.26
 */


/**
 * g_bus_get_finish:
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed
 *     to g_bus_get()
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_bus_get().
 *
 * The returned object is a singleton, that is, shared with other
 * callers of g_bus_get() and g_bus_get_sync() for @bus_type. In the
 * event that you need a private message bus connection, use
 * g_dbus_address_get_for_bus_sync() and
 * g_dbus_connection_new_for_address() with
 * G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT and
 * G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION flags.
 *
 * Note that the returned #GDBusConnection object will (usually) have
 * the #GDBusConnection:exit-on-close property set to %TRUE.
 *
 * Returns: (transfer full): a #GDBusConnection or %NULL if @error is set.
 *     Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_bus_get_sync:
 * @bus_type: a #GBusType
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously connects to the message bus specified by @bus_type.
 * Note that the returned object may shared with other callers,
 * e.g. if two separate parts of a process calls this function with
 * the same @bus_type, they will share the same object.
 *
 * This is a synchronous failable function. See g_bus_get() and
 * g_bus_get_finish() for the asynchronous version.
 *
 * The returned object is a singleton, that is, shared with other
 * callers of g_bus_get() and g_bus_get_sync() for @bus_type. In the
 * event that you need a private message bus connection, use
 * g_dbus_address_get_for_bus_sync() and
 * g_dbus_connection_new_for_address() with
 * G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT and
 * G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION flags.
 *
 * Note that the returned #GDBusConnection object will (usually) have
 * the #GDBusConnection:exit-on-close property set to %TRUE.
 *
 * Returns: (transfer full): a #GDBusConnection or %NULL if @error is set.
 *     Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_bus_own_name:
 * @bus_type: the type of bus to own a name on
 * @name: the well-known name to own
 * @flags: a set of flags from the #GBusNameOwnerFlags enumeration
 * @bus_acquired_handler: (nullable): handler to invoke when connected to the bus of type @bus_type or %NULL
 * @name_acquired_handler: (nullable): handler to invoke when @name is acquired or %NULL
 * @name_lost_handler: (nullable): handler to invoke when @name is lost or %NULL
 * @user_data: user data to pass to handlers
 * @user_data_free_func: (nullable): function for freeing @user_data or %NULL
 *
 * Starts acquiring @name on the bus specified by @bus_type and calls
 * @name_acquired_handler and @name_lost_handler when the name is
 * acquired respectively lost. Callbacks will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this function from.
 *
 * You are guaranteed that one of the @name_acquired_handler and @name_lost_handler
 * callbacks will be invoked after calling this function - there are three
 * possible cases:
 *
 * - @name_lost_handler with a %NULL connection (if a connection to the bus
 *   can't be made).
 *
 * - @bus_acquired_handler then @name_lost_handler (if the name can't be
 *   obtained)
 *
 * - @bus_acquired_handler then @name_acquired_handler (if the name was
 *   obtained).
 *
 * When you are done owning the name, just call g_bus_unown_name()
 * with the owner id this function returns.
 *
 * If the name is acquired or lost (for example another application
 * could acquire the name if you allow replacement or the application
 * currently owning the name exits), the handlers are also invoked.
 * If the #GDBusConnection that is used for attempting to own the name
 * closes, then @name_lost_handler is invoked since it is no longer
 * possible for other processes to access the process.
 *
 * You cannot use g_bus_own_name() several times for the same name (unless
 * interleaved with calls to g_bus_unown_name()) - only the first call
 * will work.
 *
 * Another guarantee is that invocations of @name_acquired_handler
 * and @name_lost_handler are guaranteed to alternate; that
 * is, if @name_acquired_handler is invoked then you are
 * guaranteed that the next time one of the handlers is invoked, it
 * will be @name_lost_handler. The reverse is also true.
 *
 * If you plan on exporting objects (using e.g.
 * g_dbus_connection_register_object()), note that it is generally too late
 * to export the objects in @name_acquired_handler. Instead, you can do this
 * in @bus_acquired_handler since you are guaranteed that this will run
 * before @name is requested from the bus.
 *
 * This behavior makes it very simple to write applications that wants
 * to [own names][gdbus-owning-names] and export objects.
 * Simply register objects to be exported in @bus_acquired_handler and
 * unregister the objects (if any) in @name_lost_handler.
 *
 * Returns: an identifier (never 0) that can be used with
 *     g_bus_unown_name() to stop owning the name.
 * Since: 2.26
 */


/**
 * g_bus_own_name_on_connection:
 * @connection: a #GDBusConnection
 * @name: the well-known name to own
 * @flags: a set of flags from the #GBusNameOwnerFlags enumeration
 * @name_acquired_handler: (nullable): handler to invoke when @name is acquired or %NULL
 * @name_lost_handler: (nullable): handler to invoke when @name is lost or %NULL
 * @user_data: user data to pass to handlers
 * @user_data_free_func: (nullable): function for freeing @user_data or %NULL
 *
 * Like g_bus_own_name() but takes a #GDBusConnection instead of a
 * #GBusType.
 *
 * Returns: an identifier (never 0) that can be used with
 *     g_bus_unown_name() to stop owning the name
 * Since: 2.26
 */


/**
 * g_bus_own_name_on_connection_with_closures: (rename-to g_bus_own_name_on_connection)
 * @connection: a #GDBusConnection
 * @name: the well-known name to own
 * @flags: a set of flags from the #GBusNameOwnerFlags enumeration
 * @name_acquired_closure: (nullable): #GClosure to invoke when @name is
 *     acquired or %NULL
 * @name_lost_closure: (nullable): #GClosure to invoke when @name is lost
 *     or %NULL
 *
 * Version of g_bus_own_name_on_connection() using closures instead of
 * callbacks for easier binding in other languages.
 *
 * Returns: an identifier (never 0) that can be used with
 *     g_bus_unown_name() to stop owning the name.
 * Since: 2.26
 */


/**
 * g_bus_own_name_with_closures: (rename-to g_bus_own_name)
 * @bus_type: the type of bus to own a name on
 * @name: the well-known name to own
 * @flags: a set of flags from the #GBusNameOwnerFlags enumeration
 * @bus_acquired_closure: (nullable): #GClosure to invoke when connected to
 *     the bus of type @bus_type or %NULL
 * @name_acquired_closure: (nullable): #GClosure to invoke when @name is
 *     acquired or %NULL
 * @name_lost_closure: (nullable): #GClosure to invoke when @name is lost or
 *     %NULL
 *
 * Version of g_bus_own_name() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * Returns: an identifier (never 0) that can be used with
 *     g_bus_unown_name() to stop owning the name.
 * Since: 2.26
 */


/**
 * g_bus_unown_name:
 * @owner_id: an identifier obtained from g_bus_own_name()
 *
 * Stops owning a name.
 *
 * Note that there may still be D-Bus traffic to process (relating to owning
 * and unowning the name) in the current thread-default #GMainContext after
 * this function has returned. You should continue to iterate the #GMainContext
 * until the #GDestroyNotify function passed to g_bus_own_name() is called, in
 * order to avoid memory leaks through callbacks queued on the #GMainContext
 * after it’s stopped being iterated.
 *
 * Since: 2.26
 */


/**
 * g_bus_unwatch_name:
 * @watcher_id: An identifier obtained from g_bus_watch_name()
 *
 * Stops watching a name.
 *
 * Note that there may still be D-Bus traffic to process (relating to watching
 * and unwatching the name) in the current thread-default #GMainContext after
 * this function has returned. You should continue to iterate the #GMainContext
 * until the #GDestroyNotify function passed to g_bus_watch_name() is called, in
 * order to avoid memory leaks through callbacks queued on the #GMainContext
 * after it’s stopped being iterated.
 *
 * Since: 2.26
 */


/**
 * g_bus_watch_name:
 * @bus_type: The type of bus to watch a name on.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_handler: (nullable): Handler to invoke when @name is known to exist or %NULL.
 * @name_vanished_handler: (nullable): Handler to invoke when @name is known to not exist or %NULL.
 * @user_data: User data to pass to handlers.
 * @user_data_free_func: (nullable): Function for freeing @user_data or %NULL.
 *
 * Starts watching @name on the bus specified by @bus_type and calls
 * @name_appeared_handler and @name_vanished_handler when the name is
 * known to have an owner respectively known to lose its
 * owner. Callbacks will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this function from.
 *
 * You are guaranteed that one of the handlers will be invoked after
 * calling this function. When you are done watching the name, just
 * call g_bus_unwatch_name() with the watcher id this function
 * returns.
 *
 * If the name vanishes or appears (for example the application owning
 * the name could restart), the handlers are also invoked. If the
 * #GDBusConnection that is used for watching the name disconnects, then
 * @name_vanished_handler is invoked since it is no longer
 * possible to access the name.
 *
 * Another guarantee is that invocations of @name_appeared_handler
 * and @name_vanished_handler are guaranteed to alternate; that
 * is, if @name_appeared_handler is invoked then you are
 * guaranteed that the next time one of the handlers is invoked, it
 * will be @name_vanished_handler. The reverse is also true.
 *
 * This behavior makes it very simple to write applications that want
 * to take action when a certain [name exists][gdbus-watching-names].
 * Basically, the application should create object proxies in
 * @name_appeared_handler and destroy them again (if any) in
 * @name_vanished_handler.
 *
 * Returns: An identifier (never 0) that can be used with
 * g_bus_unwatch_name() to stop watching the name.
 * Since: 2.26
 */


/**
 * g_bus_watch_name_on_connection:
 * @connection: A #GDBusConnection.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_handler: (nullable): Handler to invoke when @name is known to exist or %NULL.
 * @name_vanished_handler: (nullable): Handler to invoke when @name is known to not exist or %NULL.
 * @user_data: User data to pass to handlers.
 * @user_data_free_func: (nullable): Function for freeing @user_data or %NULL.
 *
 * Like g_bus_watch_name() but takes a #GDBusConnection instead of a
 * #GBusType.
 *
 * Returns: An identifier (never 0) that can be used with
 * g_bus_unwatch_name() to stop watching the name.
 * Since: 2.26
 */


/**
 * g_bus_watch_name_on_connection_with_closures: (rename-to g_bus_watch_name_on_connection)
 * @connection: A #GDBusConnection.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_closure: (nullable): #GClosure to invoke when @name is known
 * to exist or %NULL.
 * @name_vanished_closure: (nullable): #GClosure to invoke when @name is known
 * to not exist or %NULL.
 *
 * Version of g_bus_watch_name_on_connection() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * Returns: An identifier (never 0) that can be used with
 * g_bus_unwatch_name() to stop watching the name.
 * Since: 2.26
 */


/**
 * g_bus_watch_name_with_closures: (rename-to g_bus_watch_name)
 * @bus_type: The type of bus to watch a name on.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_closure: (nullable): #GClosure to invoke when @name is known
 * to exist or %NULL.
 * @name_vanished_closure: (nullable): #GClosure to invoke when @name is known
 * to not exist or %NULL.
 *
 * Version of g_bus_watch_name() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * Returns: An identifier (never 0) that can be used with
 * g_bus_unwatch_name() to stop watching the name.
 * Since: 2.26
 */


/**
 * g_bytes_icon_get_bytes:
 * @icon: a #GIcon.
 *
 * Gets the #GBytes associated with the given @icon.
 *
 * Returns: (transfer none): a #GBytes.
 * Since: 2.38
 */


/**
 * g_bytes_icon_new:
 * @bytes: a #GBytes.
 *
 * Creates a new icon for a bytes.
 *
 * This cannot fail, but loading and interpreting the bytes may fail later on
 * (for example, if g_loadable_icon_load() is called) if the image is invalid.
 *
 * Returns: (transfer full) (type GBytesIcon): a #GIcon for the given
 *   @bytes.
 * Since: 2.38
 */


/**
 * g_cancellable_cancel:
 * @cancellable: (nullable): a #GCancellable object.
 *
 * Will set @cancellable to cancelled, and will emit the
 * #GCancellable::cancelled signal. (However, see the warning about
 * race conditions in the documentation for that signal if you are
 * planning to connect to it.)
 *
 * This function is thread-safe. In other words, you can safely call
 * it from a thread other than the one running the operation that was
 * passed the @cancellable.
 *
 * If @cancellable is %NULL, this function returns immediately for convenience.
 *
 * The convention within GIO is that cancelling an asynchronous
 * operation causes it to complete asynchronously. That is, if you
 * cancel the operation from the same thread in which it is running,
 * then the operation's #GAsyncReadyCallback will not be invoked until
 * the application returns to the main loop.
 */


/**
 * g_cancellable_connect:
 * @cancellable: A #GCancellable.
 * @callback: The #GCallback to connect.
 * @data: Data to pass to @callback.
 * @data_destroy_func: (nullable): Free function for @data or %NULL.
 *
 * Convenience function to connect to the #GCancellable::cancelled
 * signal. Also handles the race condition that may happen
 * if the cancellable is cancelled right before connecting.
 *
 * @callback is called at most once, either directly at the
 * time of the connect if @cancellable is already cancelled,
 * or when @cancellable is cancelled in some thread.
 *
 * @data_destroy_func will be called when the handler is
 * disconnected, or immediately if the cancellable is already
 * cancelled.
 *
 * See #GCancellable::cancelled for details on how to use this.
 *
 * Since GLib 2.40, the lock protecting @cancellable is not held when
 * @callback is invoked.  This lifts a restriction in place for
 * earlier GLib versions which now makes it easier to write cleanup
 * code that unconditionally invokes e.g. g_cancellable_cancel().
 *
 * Returns: The id of the signal handler or 0 if @cancellable has already
 *          been cancelled.
 * Since: 2.22
 */


/**
 * g_cancellable_disconnect:
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @handler_id: Handler id of the handler to be disconnected, or `0`.
 *
 * Disconnects a handler from a cancellable instance similar to
 * g_signal_handler_disconnect().  Additionally, in the event that a
 * signal handler is currently running, this call will block until the
 * handler has finished.  Calling this function from a
 * #GCancellable::cancelled signal handler will therefore result in a
 * deadlock.
 *
 * This avoids a race condition where a thread cancels at the
 * same time as the cancellable operation is finished and the
 * signal handler is removed. See #GCancellable::cancelled for
 * details on how to use this.
 *
 * If @cancellable is %NULL or @handler_id is `0` this function does
 * nothing.
 *
 * Since: 2.22
 */


/**
 * g_cancellable_get_current:
 *
 * Gets the top cancellable from the stack.
 *
 * Returns: (nullable) (transfer none): a #GCancellable from the top
 * of the stack, or %NULL if the stack is empty.
 */


/**
 * g_cancellable_get_fd:
 * @cancellable: a #GCancellable.
 *
 * Gets the file descriptor for a cancellable job. This can be used to
 * implement cancellable operations on Unix systems. The returned fd will
 * turn readable when @cancellable is cancelled.
 *
 * You are not supposed to read from the fd yourself, just check for
 * readable status. Reading to unset the readable status is done
 * with g_cancellable_reset().
 *
 * After a successful return from this function, you should use
 * g_cancellable_release_fd() to free up resources allocated for
 * the returned file descriptor.
 *
 * See also g_cancellable_make_pollfd().
 *
 * Returns: A valid file descriptor. `-1` if the file descriptor
 * is not supported, or on errors.
 */


/**
 * g_cancellable_is_cancelled:
 * @cancellable: (nullable): a #GCancellable or %NULL
 *
 * Checks if a cancellable job has been cancelled.
 *
 * Returns: %TRUE if @cancellable is cancelled,
 * FALSE if called with %NULL or if item is not cancelled.
 */


/**
 * g_cancellable_make_pollfd:
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @pollfd: a pointer to a #GPollFD
 *
 * Creates a #GPollFD corresponding to @cancellable; this can be passed
 * to g_poll() and used to poll for cancellation. This is useful both
 * for unix systems without a native poll and for portability to
 * windows.
 *
 * When this function returns %TRUE, you should use
 * g_cancellable_release_fd() to free up resources allocated for the
 * @pollfd. After a %FALSE return, do not call g_cancellable_release_fd().
 *
 * If this function returns %FALSE, either no @cancellable was given or
 * resource limits prevent this function from allocating the necessary
 * structures for polling. (On Linux, you will likely have reached
 * the maximum number of file descriptors.) The suggested way to handle
 * these cases is to ignore the @cancellable.
 *
 * You are not supposed to read from the fd yourself, just check for
 * readable status. Reading to unset the readable status is done
 * with g_cancellable_reset().
 *
 * Returns: %TRUE if @pollfd was successfully initialized, %FALSE on
 *          failure to prepare the cancellable.
 * Since: 2.22
 */


/**
 * g_cancellable_new:
 *
 * Creates a new #GCancellable object.
 *
 * Applications that want to start one or more operations
 * that should be cancellable should create a #GCancellable
 * and pass it to the operations.
 *
 * One #GCancellable can be used in multiple consecutive
 * operations or in multiple concurrent operations.
 *
 * Returns: a #GCancellable.
 */


/**
 * g_cancellable_pop_current:
 * @cancellable: a #GCancellable object
 *
 * Pops @cancellable off the cancellable stack (verifying that @cancellable
 * is on the top of the stack).
 */


/**
 * g_cancellable_push_current:
 * @cancellable: a #GCancellable object
 *
 * Pushes @cancellable onto the cancellable stack. The current
 * cancellable can then be received using g_cancellable_get_current().
 *
 * This is useful when implementing cancellable operations in
 * code that does not allow you to pass down the cancellable object.
 *
 * This is typically called automatically by e.g. #GFile operations,
 * so you rarely have to call this yourself.
 */


/**
 * g_cancellable_release_fd:
 * @cancellable: a #GCancellable
 *
 * Releases a resources previously allocated by g_cancellable_get_fd()
 * or g_cancellable_make_pollfd().
 *
 * For compatibility reasons with older releases, calling this function
 * is not strictly required, the resources will be automatically freed
 * when the @cancellable is finalized. However, the @cancellable will
 * block scarce file descriptors until it is finalized if this function
 * is not called. This can cause the application to run out of file
 * descriptors when many #GCancellables are used at the same time.
 *
 * Since: 2.22
 */


/**
 * g_cancellable_reset:
 * @cancellable: a #GCancellable object.
 *
 * Resets @cancellable to its uncancelled state.
 *
 * If cancellable is currently in use by any cancellable operation
 * then the behavior of this function is undefined.
 *
 * Note that it is generally not a good idea to reuse an existing
 * cancellable for more operations after it has been cancelled once,
 * as this function might tempt you to do. The recommended practice
 * is to drop the reference to a cancellable after cancelling it,
 * and let it die with the outstanding async operations. You should
 * create a fresh cancellable for further async operations.
 */


/**
 * g_cancellable_set_error_if_cancelled:
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: #GError to append error state to
 *
 * If the @cancellable is cancelled, sets the error to notify
 * that the operation was cancelled.
 *
 * Returns: %TRUE if @cancellable was cancelled, %FALSE if it was not
 */


/**
 * g_cancellable_source_new:
 * @cancellable: (nullable): a #GCancellable, or %NULL
 *
 * Creates a source that triggers if @cancellable is cancelled and
 * calls its callback of type #GCancellableSourceFunc. This is
 * primarily useful for attaching to another (non-cancellable) source
 * with g_source_add_child_source() to add cancellability to it.
 *
 * For convenience, you can call this with a %NULL #GCancellable,
 * in which case the source will never trigger.
 *
 * The new #GSource will hold a reference to the #GCancellable.
 *
 * Returns: (transfer full): the new #GSource.
 * Since: 2.28
 */


/**
 * g_charset_converter_get_num_fallbacks:
 * @converter: a #GCharsetConverter
 *
 * Gets the number of fallbacks that @converter has applied so far.
 *
 * Returns: the number of fallbacks that @converter has applied
 * Since: 2.24
 */


/**
 * g_charset_converter_get_use_fallback:
 * @converter: a #GCharsetConverter
 *
 * Gets the #GCharsetConverter:use-fallback property.
 *
 * Returns: %TRUE if fallbacks are used by @converter
 * Since: 2.24
 */


/**
 * g_charset_converter_new:
 * @to_charset: destination charset
 * @from_charset: source charset
 * @error: #GError for error reporting, or %NULL to ignore.
 *
 * Creates a new #GCharsetConverter.
 *
 * Returns: a new #GCharsetConverter or %NULL on error.
 * Since: 2.24
 */


/**
 * g_charset_converter_set_use_fallback:
 * @converter: a #GCharsetConverter
 * @use_fallback: %TRUE to use fallbacks
 *
 * Sets the #GCharsetConverter:use-fallback property.
 *
 * Since: 2.24
 */


/**
 * g_content_type_can_be_executable:
 * @type: a content type string
 *
 * Checks if a content type can be executable. Note that for instance
 * things like text files can be executables (i.e. scripts and batch files).
 *
 * Returns: %TRUE if the file type corresponds to a type that
 *     can be executable, %FALSE otherwise.
 */


/**
 * g_content_type_equals:
 * @type1: a content type string
 * @type2: a content type string
 *
 * Compares two content types for equality.
 *
 * Returns: %TRUE if the two strings are identical or equivalent,
 *     %FALSE otherwise.
 */


/**
 * g_content_type_from_mime_type:
 * @mime_type: a mime type string
 *
 * Tries to find a content type based on the mime type name.
 *
 * Returns: (nullable): Newly allocated string with content type or
 *     %NULL. Free with g_free()
 * Since: 2.18
 */


/**
 * g_content_type_get_description:
 * @type: a content type string
 *
 * Gets the human readable description of the content type.
 *
 * Returns: a short description of the content type @type. Free the
 *     returned string with g_free()
 */


/**
 * g_content_type_get_generic_icon_name:
 * @type: a content type string
 *
 * Gets the generic icon name for a content type.
 *
 * See the
 * [shared-mime-info](http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec)
 * specification for more on the generic icon name.
 *
 * Returns: (nullable): the registered generic icon name for the given @type,
 *     or %NULL if unknown. Free with g_free()
 * Since: 2.34
 */


/**
 * g_content_type_get_icon:
 * @type: a content type string
 *
 * Gets the icon for a content type.
 *
 * Returns: (transfer full): #GIcon corresponding to the content type. Free the returned
 *     object with g_object_unref()
 */


/**
 * g_content_type_get_mime_dirs:
 *
 * Get the list of directories which MIME data is loaded from. See
 * g_content_type_set_mime_dirs() for details.
 *
 * Returns: (transfer none) (array zero-terminated=1): %NULL-terminated list of
 *    directories to load MIME data from, including any `mime/` subdirectory,
 *    and with the first directory to try listed first
 * Since: 2.60
 */


/**
 * g_content_type_get_mime_type:
 * @type: a content type string
 *
 * Gets the mime type for the content type, if one is registered.
 *
 * Returns: (nullable) (transfer full): the registered mime type for the
 *     given @type, or %NULL if unknown; free with g_free().
 */


/**
 * g_content_type_get_symbolic_icon:
 * @type: a content type string
 *
 * Gets the symbolic icon for a content type.
 *
 * Returns: (transfer full): symbolic #GIcon corresponding to the content type.
 *     Free the returned object with g_object_unref()
 * Since: 2.34
 */


/**
 * g_content_type_guess:
 * @filename: (nullable) (type filename): a path, or %NULL
 * @data: (nullable) (array length=data_size): a stream of data, or %NULL
 * @data_size: the size of @data
 * @result_uncertain: (out) (optional): return location for the certainty
 *     of the result, or %NULL
 *
 * Guesses the content type based on example data. If the function is
 * uncertain, @result_uncertain will be set to %TRUE. Either @filename
 * or @data may be %NULL, in which case the guess will be based solely
 * on the other argument.
 *
 * Returns: a string indicating a guessed content type for the
 *     given data. Free with g_free()
 */


/**
 * g_content_type_guess_for_tree:
 * @root: the root of the tree to guess a type for
 *
 * Tries to guess the type of the tree with root @root, by
 * looking at the files it contains. The result is an array
 * of content types, with the best guess coming first.
 *
 * The types returned all have the form x-content/foo, e.g.
 * x-content/audio-cdda (for audio CDs) or x-content/image-dcf
 * (for a camera memory card). See the
 * [shared-mime-info](http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec)
 * specification for more on x-content types.
 *
 * This function is useful in the implementation of
 * g_mount_guess_content_type().
 *
 * Returns: (transfer full) (array zero-terminated=1): an %NULL-terminated
 *     array of zero or more content types. Free with g_strfreev()
 * Since: 2.18
 */


/**
 * g_content_type_is_a:
 * @type: a content type string
 * @supertype: a content type string
 *
 * Determines if @type is a subset of @supertype.
 *
 * Returns: %TRUE if @type is a kind of @supertype,
 *     %FALSE otherwise.
 */


/**
 * g_content_type_is_mime_type:
 * @type: a content type string
 * @mime_type: a mime type string
 *
 * Determines if @type is a subset of @mime_type.
 * Convenience wrapper around g_content_type_is_a().
 *
 * Returns: %TRUE if @type is a kind of @mime_type,
 *     %FALSE otherwise.
 * Since: 2.52
 */


/**
 * g_content_type_is_unknown:
 * @type: a content type string
 *
 * Checks if the content type is the generic "unknown" type.
 * On UNIX this is the "application/octet-stream" mimetype,
 * while on win32 it is "*" and on OSX it is a dynamic type
 * or octet-stream.
 *
 * Returns: %TRUE if the type is the unknown type.
 */


/**
 * g_content_type_set_mime_dirs:
 * @dirs: (array zero-terminated=1) (nullable): %NULL-terminated list of
 *    directories to load MIME data from, including any `mime/` subdirectory,
 *    and with the first directory to try listed first
 *
 * Set the list of directories used by GIO to load the MIME database.
 * If @dirs is %NULL, the directories used are the default:
 *
 *  - the `mime` subdirectory of the directory in `$XDG_DATA_HOME`
 *  - the `mime` subdirectory of every directory in `$XDG_DATA_DIRS`
 *
 * This function is intended to be used when writing tests that depend on
 * information stored in the MIME database, in order to control the data.
 *
 * Typically, in case your tests use %G_TEST_OPTION_ISOLATE_DIRS, but they
 * depend on the system’s MIME database, you should call this function
 * with @dirs set to %NULL before calling g_test_init(), for instance:
 *
 * |[<!-- language="C" -->
 *   // Load MIME data from the system
 *   g_content_type_set_mime_dirs (NULL);
 *   // Isolate the environment
 *   g_test_init (&argc, &argv, G_TEST_OPTION_ISOLATE_DIRS, NULL);
 *
 *   …
 *
 *   return g_test_run ();
 * ]|
 *
 * Since: 2.60
 */


/**
 * g_content_types_get_registered:
 *
 * Gets a list of strings containing all the registered content types
 * known to the system. The list and its data should be freed using
 * `g_list_free_full (list, g_free)`.
 *
 * Returns: (element-type utf8) (transfer full): list of the registered
 *     content types
 */


/**
 * g_converter_convert:
 * @converter: a #GConverter.
 * @inbuf: (array length=inbuf_size) (element-type guint8): the buffer
 *         containing the data to convert.
 * @inbuf_size: the number of bytes in @inbuf
 * @outbuf: (element-type guint8) (array length=outbuf_size) (not nullable): a
 *    buffer to write converted data in.
 * @outbuf_size: the number of bytes in @outbuf, must be at least one
 * @flags: a #GConverterFlags controlling the conversion details
 * @bytes_read: (out) (not nullable): will be set to the number of bytes read
 *    from @inbuf on success
 * @bytes_written: (out) (not nullable): will be set to the number of bytes
 *    written to @outbuf on success
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * This is the main operation used when converting data. It is to be called
 * multiple times in a loop, and each time it will do some work, i.e.
 * producing some output (in @outbuf) or consuming some input (from @inbuf) or
 * both. If its not possible to do any work an error is returned.
 *
 * Note that a single call may not consume all input (or any input at all).
 * Also a call may produce output even if given no input, due to state stored
 * in the converter producing output.
 *
 * If any data was either produced or consumed, and then an error happens, then
 * only the successful conversion is reported and the error is returned on the
 * next call.
 *
 * A full conversion loop involves calling this method repeatedly, each time
 * giving it new input and space output space. When there is no more input
 * data after the data in @inbuf, the flag %G_CONVERTER_INPUT_AT_END must be set.
 * The loop will be (unless some error happens) returning %G_CONVERTER_CONVERTED
 * each time until all data is consumed and all output is produced, then
 * %G_CONVERTER_FINISHED is returned instead. Note, that %G_CONVERTER_FINISHED
 * may be returned even if %G_CONVERTER_INPUT_AT_END is not set, for instance
 * in a decompression converter where the end of data is detectable from the
 * data (and there might even be other data after the end of the compressed data).
 *
 * When some data has successfully been converted @bytes_read and is set to
 * the number of bytes read from @inbuf, and @bytes_written is set to indicate
 * how many bytes was written to @outbuf. If there are more data to output
 * or consume (i.e. unless the %G_CONVERTER_INPUT_AT_END is specified) then
 * %G_CONVERTER_CONVERTED is returned, and if no more data is to be output
 * then %G_CONVERTER_FINISHED is returned.
 *
 * On error %G_CONVERTER_ERROR is returned and @error is set accordingly.
 * Some errors need special handling:
 *
 * %G_IO_ERROR_NO_SPACE is returned if there is not enough space
 * to write the resulting converted data, the application should
 * call the function again with a larger @outbuf to continue.
 *
 * %G_IO_ERROR_PARTIAL_INPUT is returned if there is not enough
 * input to fully determine what the conversion should produce,
 * and the %G_CONVERTER_INPUT_AT_END flag is not set. This happens for
 * example with an incomplete multibyte sequence when converting text,
 * or when a regexp matches up to the end of the input (and may match
 * further input). It may also happen when @inbuf_size is zero and
 * there is no more data to produce.
 *
 * When this happens the application should read more input and then
 * call the function again. If further input shows that there is no
 * more data call the function again with the same data but with
 * the %G_CONVERTER_INPUT_AT_END flag set. This may cause the conversion
 * to finish as e.g. in the regexp match case (or, to fail again with
 * %G_IO_ERROR_PARTIAL_INPUT in e.g. a charset conversion where the
 * input is actually partial).
 *
 * After g_converter_convert() has returned %G_CONVERTER_FINISHED the
 * converter object is in an invalid state where its not allowed
 * to call g_converter_convert() anymore. At this time you can only
 * free the object or call g_converter_reset() to reset it to the
 * initial state.
 *
 * If the flag %G_CONVERTER_FLUSH is set then conversion is modified
 * to try to write out all internal state to the output. The application
 * has to call the function multiple times with the flag set, and when
 * the available input has been consumed and all internal state has
 * been produced then %G_CONVERTER_FLUSHED (or %G_CONVERTER_FINISHED if
 * really at the end) is returned instead of %G_CONVERTER_CONVERTED.
 * This is somewhat similar to what happens at the end of the input stream,
 * but done in the middle of the data.
 *
 * This has different meanings for different conversions. For instance
 * in a compression converter it would mean that we flush all the
 * compression state into output such that if you uncompress the
 * compressed data you get back all the input data. Doing this may
 * make the final file larger due to padding though. Another example
 * is a regexp conversion, where if you at the end of the flushed data
 * have a match, but there is also a potential longer match. In the
 * non-flushed case we would ask for more input, but when flushing we
 * treat this as the end of input and do the match.
 *
 * Flushing is not always possible (like if a charset converter flushes
 * at a partial multibyte sequence). Converters are supposed to try
 * to produce as much output as possible and then return an error
 * (typically %G_IO_ERROR_PARTIAL_INPUT).
 *
 * Returns: a #GConverterResult, %G_CONVERTER_ERROR on error.
 * Since: 2.24
 */


/**
 * g_converter_input_stream_get_converter:
 * @converter_stream: a #GConverterInputStream
 *
 * Gets the #GConverter that is used by @converter_stream.
 *
 * Returns: (transfer none): the converter of the converter input stream
 * Since: 2.24
 */


/**
 * g_converter_input_stream_new:
 * @base_stream: a #GInputStream
 * @converter: a #GConverter
 *
 * Creates a new converter input stream for the @base_stream.
 *
 * Returns: a new #GInputStream.
 */


/**
 * g_converter_output_stream_get_converter:
 * @converter_stream: a #GConverterOutputStream
 *
 * Gets the #GConverter that is used by @converter_stream.
 *
 * Returns: (transfer none): the converter of the converter output stream
 * Since: 2.24
 */


/**
 * g_converter_output_stream_new:
 * @base_stream: a #GOutputStream
 * @converter: a #GConverter
 *
 * Creates a new converter output stream for the @base_stream.
 *
 * Returns: a new #GOutputStream.
 */


/**
 * g_converter_reset:
 * @converter: a #GConverter.
 *
 * Resets all internal state in the converter, making it behave
 * as if it was just created. If the converter has any internal
 * state that would produce output then that output is lost.
 *
 * Since: 2.24
 */


/**
 * g_credentials_get_native: (skip)
 * @credentials: A #GCredentials.
 * @native_type: The type of native credentials to get.
 *
 * Gets a pointer to native credentials of type @native_type from
 * @credentials.
 *
 * It is a programming error (which will cause a warning to be
 * logged) to use this method if there is no #GCredentials support for
 * the OS or if @native_type isn't supported by the OS.
 *
 * Returns: (transfer none) (nullable): The pointer to native credentials or
 *     %NULL if there is no #GCredentials support for the OS or if @native_type
 *     isn't supported by the OS. Do not free the returned data, it is owned
 *     by @credentials.
 * Since: 2.26
 */


/**
 * g_credentials_get_unix_pid:
 * @credentials: A #GCredentials
 * @error: Return location for error or %NULL.
 *
 * Tries to get the UNIX process identifier from @credentials. This
 * method is only available on UNIX platforms.
 *
 * This operation can fail if #GCredentials is not supported on the
 * OS or if the native credentials type does not contain information
 * about the UNIX process ID.
 *
 * Returns: The UNIX process ID, or `-1` if @error is set.
 * Since: 2.36
 */


/**
 * g_credentials_get_unix_user:
 * @credentials: A #GCredentials
 * @error: Return location for error or %NULL.
 *
 * Tries to get the UNIX user identifier from @credentials. This
 * method is only available on UNIX platforms.
 *
 * This operation can fail if #GCredentials is not supported on the
 * OS or if the native credentials type does not contain information
 * about the UNIX user.
 *
 * Returns: The UNIX user identifier or `-1` if @error is set.
 * Since: 2.26
 */


/**
 * g_credentials_is_same_user:
 * @credentials: A #GCredentials.
 * @other_credentials: A #GCredentials.
 * @error: Return location for error or %NULL.
 *
 * Checks if @credentials and @other_credentials is the same user.
 *
 * This operation can fail if #GCredentials is not supported on the
 * the OS.
 *
 * Returns: %TRUE if @credentials and @other_credentials has the same
 * user, %FALSE otherwise or if @error is set.
 * Since: 2.26
 */


/**
 * g_credentials_new:
 *
 * Creates a new #GCredentials object with credentials matching the
 * the current process.
 *
 * Returns: (transfer full): A #GCredentials. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_credentials_set_native:
 * @credentials: A #GCredentials.
 * @native_type: The type of native credentials to set.
 * @native: (not nullable): A pointer to native credentials.
 *
 * Copies the native credentials of type @native_type from @native
 * into @credentials.
 *
 * It is a programming error (which will cause a warning to be
 * logged) to use this method if there is no #GCredentials support for
 * the OS or if @native_type isn't supported by the OS.
 *
 * Since: 2.26
 */


/**
 * g_credentials_set_unix_user:
 * @credentials: A #GCredentials.
 * @uid: The UNIX user identifier to set.
 * @error: Return location for error or %NULL.
 *
 * Tries to set the UNIX user identifier on @credentials. This method
 * is only available on UNIX platforms.
 *
 * This operation can fail if #GCredentials is not supported on the
 * OS or if the native credentials type does not contain information
 * about the UNIX user. It can also fail if the OS does not allow the
 * use of "spoofed" credentials.
 *
 * Returns: %TRUE if @uid was set, %FALSE if error is set.
 * Since: 2.26
 */


/**
 * g_credentials_to_string:
 * @credentials: A #GCredentials object.
 *
 * Creates a human-readable textual representation of @credentials
 * that can be used in logging and debug messages. The format of the
 * returned string may change in future GLib release.
 *
 * Returns: (transfer full): A string that should be freed with g_free().
 * Since: 2.26
 */


/**
 * g_data_input_stream_get_byte_order:
 * @stream: a given #GDataInputStream.
 *
 * Gets the byte order for the data input stream.
 *
 * Returns: the @stream's current #GDataStreamByteOrder.
 */


/**
 * g_data_input_stream_get_newline_type:
 * @stream: a given #GDataInputStream.
 *
 * Gets the current newline type for the @stream.
 *
 * Returns: #GDataStreamNewlineType for the given @stream.
 */


/**
 * g_data_input_stream_new:
 * @base_stream: a #GInputStream.
 *
 * Creates a new data input stream for the @base_stream.
 *
 * Returns: a new #GDataInputStream.
 */


/**
 * g_data_input_stream_read_byte:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 8-bit/1-byte value from @stream.
 *
 * Returns: an unsigned 8-bit/1-byte value read from the @stream or `0`
 * if an error occurred.
 */


/**
 * g_data_input_stream_read_int16:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a 16-bit/2-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * Returns: a signed 16-bit/2-byte value read from @stream or `0` if
 * an error occurred.
 */


/**
 * g_data_input_stream_read_int32:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a signed 32-bit/4-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: a signed 32-bit/4-byte value read from the @stream or `0` if
 * an error occurred.
 */


/**
 * g_data_input_stream_read_int64:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a 64-bit/8-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: a signed 64-bit/8-byte value read from @stream or `0` if
 * an error occurred.
 */


/**
 * g_data_input_stream_read_line:
 * @stream: a given #GDataInputStream.
 * @length: (out) (optional): a #gsize to get the length of the data read in.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a line from the data input stream.  Note that no encoding
 * checks or conversion is performed; the input is not guaranteed to
 * be UTF-8, and may in fact have embedded NUL characters.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (nullable) (transfer full) (array zero-terminated=1) (element-type guint8):
 *  a NUL terminated byte array with the line that was read in
 *  (without the newlines).  Set @length to a #gsize to get the length
 *  of the read line.  On an error, it will return %NULL and @error
 *  will be set. If there's no content to read, it will still return
 *  %NULL, but @error won't be set.
 */


/**
 * g_data_input_stream_read_line_async:
 * @stream: a given #GDataInputStream.
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async) (closure user_data): callback to call when the request is satisfied.
 * @user_data: the data to pass to callback function.
 *
 * The asynchronous version of g_data_input_stream_read_line().  It is
 * an error to have two outstanding calls to this function.
 *
 * When the operation is finished, @callback will be called. You
 * can then call g_data_input_stream_read_line_finish() to get
 * the result of the operation.
 *
 * Since: 2.20
 */


/**
 * g_data_input_stream_read_line_finish:
 * @stream: a given #GDataInputStream.
 * @result: the #GAsyncResult that was provided to the callback.
 * @length: (out) (optional): a #gsize to get the length of the data read in.
 * @error: #GError for error reporting.
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_line_async().  Note the warning about
 * string encoding in g_data_input_stream_read_line() applies here as
 * well.
 *
 * Returns: (nullable) (transfer full) (array zero-terminated=1) (element-type guint8):
 *  a NUL-terminated byte array with the line that was read in
 *  (without the newlines).  Set @length to a #gsize to get the length
 *  of the read line.  On an error, it will return %NULL and @error
 *  will be set. If there's no content to read, it will still return
 *  %NULL, but @error won't be set.
 * Since: 2.20
 */


/**
 * g_data_input_stream_read_line_finish_utf8:
 * @stream: a given #GDataInputStream.
 * @result: the #GAsyncResult that was provided to the callback.
 * @length: (out) (optional): a #gsize to get the length of the data read in.
 * @error: #GError for error reporting.
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_line_async().
 *
 * Returns: (nullable) (transfer full): a string with the line that
 *  was read in (without the newlines).  Set @length to a #gsize to
 *  get the length of the read line.  On an error, it will return
 *  %NULL and @error will be set. For UTF-8 conversion errors, the set
 *  error domain is %G_CONVERT_ERROR.  If there's no content to read,
 *  it will still return %NULL, but @error won't be set.
 * Since: 2.30
 */


/**
 * g_data_input_stream_read_line_utf8:
 * @stream: a given #GDataInputStream.
 * @length: (out) (optional): a #gsize to get the length of the data read in.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a UTF-8 encoded line from the data input stream.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (nullable) (transfer full): a NUL terminated UTF-8 string
 *  with the line that was read in (without the newlines).  Set
 *  @length to a #gsize to get the length of the read line.  On an
 *  error, it will return %NULL and @error will be set.  For UTF-8
 *  conversion errors, the set error domain is %G_CONVERT_ERROR.  If
 *  there's no content to read, it will still return %NULL, but @error
 *  won't be set.
 * Since: 2.30
 */


/**
 * g_data_input_stream_read_uint16:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 16-bit/2-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * Returns: an unsigned 16-bit/2-byte value read from the @stream or `0` if
 * an error occurred.
 */


/**
 * g_data_input_stream_read_uint32:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 32-bit/4-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: an unsigned 32-bit/4-byte value read from the @stream or `0` if
 * an error occurred.
 */


/**
 * g_data_input_stream_read_uint64:
 * @stream: a given #GDataInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 64-bit/8-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: an unsigned 64-bit/8-byte read from @stream or `0` if
 * an error occurred.
 */


/**
 * g_data_input_stream_read_until:
 * @stream: a given #GDataInputStream.
 * @stop_chars: characters to terminate the read.
 * @length: (out) (optional): a #gsize to get the length of the data read in.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a string from the data input stream, up to the first
 * occurrence of any of the stop characters.
 *
 * Note that, in contrast to g_data_input_stream_read_until_async(),
 * this function consumes the stop character that it finds.
 *
 * Don't use this function in new code.  Its functionality is
 * inconsistent with g_data_input_stream_read_until_async().  Both
 * functions will be marked as deprecated in a future release.  Use
 * g_data_input_stream_read_upto() instead, but note that that function
 * does not consume the stop character.
 *
 * Returns: (transfer full): a string with the data that was read
 *     before encountering any of the stop characters. Set @length to
 *     a #gsize to get the length of the string. This function will
 *     return %NULL on an error.
 * Deprecated: 2.56: Use g_data_input_stream_read_upto() instead, which has more
 *     consistent behaviour regarding the stop character.
 */


/**
 * g_data_input_stream_read_until_async:
 * @stream: a given #GDataInputStream.
 * @stop_chars: characters to terminate the read.
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied.
 * @user_data: (closure): the data to pass to callback function.
 *
 * The asynchronous version of g_data_input_stream_read_until().
 * It is an error to have two outstanding calls to this function.
 *
 * Note that, in contrast to g_data_input_stream_read_until(),
 * this function does not consume the stop character that it finds.  You
 * must read it for yourself.
 *
 * When the operation is finished, @callback will be called. You
 * can then call g_data_input_stream_read_until_finish() to get
 * the result of the operation.
 *
 * Don't use this function in new code.  Its functionality is
 * inconsistent with g_data_input_stream_read_until().  Both functions
 * will be marked as deprecated in a future release.  Use
 * g_data_input_stream_read_upto_async() instead.
 *
 * Since: 2.20
 * Deprecated: 2.56: Use g_data_input_stream_read_upto_async() instead, which
 *     has more consistent behaviour regarding the stop character.
 */


/**
 * g_data_input_stream_read_until_finish:
 * @stream: a given #GDataInputStream.
 * @result: the #GAsyncResult that was provided to the callback.
 * @length: (out) (optional): a #gsize to get the length of the data read in.
 * @error: #GError for error reporting.
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_until_async().
 *
 * Since: 2.20
 * Returns: (transfer full): a string with the data that was read
 *     before encountering any of the stop characters. Set @length to
 *     a #gsize to get the length of the string. This function will
 *     return %NULL on an error.
 * Deprecated: 2.56: Use g_data_input_stream_read_upto_finish() instead, which
 *     has more consistent behaviour regarding the stop character.
 */


/**
 * g_data_input_stream_read_upto:
 * @stream: a #GDataInputStream
 * @stop_chars: characters to terminate the read
 * @stop_chars_len: length of @stop_chars. May be -1 if @stop_chars is
 *     nul-terminated
 * @length: (out) (optional): a #gsize to get the length of the data read in
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @error: #GError for error reporting
 *
 * Reads a string from the data input stream, up to the first
 * occurrence of any of the stop characters.
 *
 * In contrast to g_data_input_stream_read_until(), this function
 * does not consume the stop character. You have to use
 * g_data_input_stream_read_byte() to get it before calling
 * g_data_input_stream_read_upto() again.
 *
 * Note that @stop_chars may contain '\0' if @stop_chars_len is
 * specified.
 *
 * The returned string will always be nul-terminated on success.
 *
 * Returns: (transfer full): a string with the data that was read
 *     before encountering any of the stop characters. Set @length to
 *     a #gsize to get the length of the string. This function will
 *     return %NULL on an error
 * Since: 2.26
 */


/**
 * g_data_input_stream_read_upto_async:
 * @stream: a #GDataInputStream
 * @stop_chars: characters to terminate the read
 * @stop_chars_len: length of @stop_chars. May be -1 if @stop_chars is
 *     nul-terminated
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * The asynchronous version of g_data_input_stream_read_upto().
 * It is an error to have two outstanding calls to this function.
 *
 * In contrast to g_data_input_stream_read_until(), this function
 * does not consume the stop character. You have to use
 * g_data_input_stream_read_byte() to get it before calling
 * g_data_input_stream_read_upto() again.
 *
 * Note that @stop_chars may contain '\0' if @stop_chars_len is
 * specified.
 *
 * When the operation is finished, @callback will be called. You
 * can then call g_data_input_stream_read_upto_finish() to get
 * the result of the operation.
 *
 * Since: 2.26
 */


/**
 * g_data_input_stream_read_upto_finish:
 * @stream: a #GDataInputStream
 * @result: the #GAsyncResult that was provided to the callback
 * @length: (out) (optional): a #gsize to get the length of the data read in
 * @error: #GError for error reporting
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_upto_async().
 *
 * Note that this function does not consume the stop character. You
 * have to use g_data_input_stream_read_byte() to get it before calling
 * g_data_input_stream_read_upto_async() again.
 *
 * The returned string will always be nul-terminated on success.
 *
 * Returns: (transfer full): a string with the data that was read
 *     before encountering any of the stop characters. Set @length to
 *     a #gsize to get the length of the string. This function will
 *     return %NULL on an error.
 * Since: 2.24
 */


/**
 * g_data_input_stream_set_byte_order:
 * @stream: a given #GDataInputStream.
 * @order: a #GDataStreamByteOrder to set.
 *
 * This function sets the byte order for the given @stream. All subsequent
 * reads from the @stream will be read in the given @order.
 */


/**
 * g_data_input_stream_set_newline_type:
 * @stream: a #GDataInputStream.
 * @type: the type of new line return as #GDataStreamNewlineType.
 *
 * Sets the newline type for the @stream.
 *
 * Note that using G_DATA_STREAM_NEWLINE_TYPE_ANY is slightly unsafe. If a read
 * chunk ends in "CR" we must read an additional byte to know if this is "CR" or
 * "CR LF", and this might block if there is no more data available.
 */


/**
 * g_data_output_stream_get_byte_order:
 * @stream: a #GDataOutputStream.
 *
 * Gets the byte order for the stream.
 *
 * Returns: the #GDataStreamByteOrder for the @stream.
 */


/**
 * g_data_output_stream_new:
 * @base_stream: a #GOutputStream.
 *
 * Creates a new data output stream for @base_stream.
 *
 * Returns: #GDataOutputStream.
 */


/**
 * g_data_output_stream_put_byte:
 * @stream: a #GDataOutputStream.
 * @data: a #guchar.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a byte into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_int16:
 * @stream: a #GDataOutputStream.
 * @data: a #gint16.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a signed 16-bit integer into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_int32:
 * @stream: a #GDataOutputStream.
 * @data: a #gint32.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a signed 32-bit integer into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_int64:
 * @stream: a #GDataOutputStream.
 * @data: a #gint64.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a signed 64-bit integer into the stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_string:
 * @stream: a #GDataOutputStream.
 * @str: a string.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a string into the output stream.
 *
 * Returns: %TRUE if @string was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_uint16:
 * @stream: a #GDataOutputStream.
 * @data: a #guint16.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts an unsigned 16-bit integer into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_uint32:
 * @stream: a #GDataOutputStream.
 * @data: a #guint32.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts an unsigned 32-bit integer into the stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_uint64:
 * @stream: a #GDataOutputStream.
 * @data: a #guint64.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts an unsigned 64-bit integer into the stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_set_byte_order:
 * @stream: a #GDataOutputStream.
 * @order: a %GDataStreamByteOrder.
 *
 * Sets the byte order of the data output stream to @order.
 */


/**
 * g_datagram_based_condition_check:
 * @datagram_based: a #GDatagramBased
 * @condition: a #GIOCondition mask to check
 *
 * Checks on the readiness of @datagram_based to perform operations. The
 * operations specified in @condition are checked for and masked against the
 * currently-satisfied conditions on @datagram_based. The result is returned.
 *
 * %G_IO_IN will be set in the return value if data is available to read with
 * g_datagram_based_receive_messages(), or if the connection is closed remotely
 * (EOS); and if the datagram_based has not been closed locally using some
 * implementation-specific method (such as g_socket_close() or
 * g_socket_shutdown() with @shutdown_read set, if it’s a #GSocket).
 *
 * If the connection is shut down or closed (by calling g_socket_close() or
 * g_socket_shutdown() with @shutdown_read set, if it’s a #GSocket, for
 * example), all calls to this function will return %G_IO_ERROR_CLOSED.
 *
 * %G_IO_OUT will be set if it is expected that at least one byte can be sent
 * using g_datagram_based_send_messages() without blocking. It will not be set
 * if the datagram_based has been closed locally.
 *
 * %G_IO_HUP will be set if the connection has been closed locally.
 *
 * %G_IO_ERR will be set if there was an asynchronous error in transmitting data
 * previously enqueued using g_datagram_based_send_messages().
 *
 * Note that on Windows, it is possible for an operation to return
 * %G_IO_ERROR_WOULD_BLOCK even immediately after
 * g_datagram_based_condition_check() has claimed that the #GDatagramBased is
 * ready for writing. Rather than calling g_datagram_based_condition_check() and
 * then writing to the #GDatagramBased if it succeeds, it is generally better to
 * simply try writing right away, and try again later if the initial attempt
 * returns %G_IO_ERROR_WOULD_BLOCK.
 *
 * It is meaningless to specify %G_IO_ERR or %G_IO_HUP in @condition; these
 * conditions will always be set in the output if they are true. Apart from
 * these flags, the output is guaranteed to be masked by @condition.
 *
 * This call never blocks.
 *
 * Returns: the #GIOCondition mask of the current state
 * Since: 2.48
 */


/**
 * g_datagram_based_condition_wait:
 * @datagram_based: a #GDatagramBased
 * @condition: a #GIOCondition mask to wait for
 * @timeout: the maximum time (in microseconds) to wait, 0 to not block, or -1
 *   to block indefinitely
 * @cancellable: (nullable): a #GCancellable
 * @error: return location for a #GError
 *
 * Waits for up to @timeout microseconds for condition to become true on
 * @datagram_based. If the condition is met, %TRUE is returned.
 *
 * If @cancellable is cancelled before the condition is met, or if @timeout is
 * reached before the condition is met, then %FALSE is returned and @error is
 * set appropriately (%G_IO_ERROR_CANCELLED or %G_IO_ERROR_TIMED_OUT).
 *
 * Returns: %TRUE if the condition was met, %FALSE otherwise
 * Since: 2.48
 */


/**
 * g_datagram_based_create_source:
 * @datagram_based: a #GDatagramBased
 * @condition: a #GIOCondition mask to monitor
 * @cancellable: (nullable): a #GCancellable
 *
 * Creates a #GSource that can be attached to a #GMainContext to monitor for
 * the availability of the specified @condition on the #GDatagramBased. The
 * #GSource keeps a reference to the @datagram_based.
 *
 * The callback on the source is of the #GDatagramBasedSourceFunc type.
 *
 * It is meaningless to specify %G_IO_ERR or %G_IO_HUP in @condition; these
 * conditions will always be reported in the callback if they are true.
 *
 * If non-%NULL, @cancellable can be used to cancel the source, which will
 * cause the source to trigger, reporting the current condition (which is
 * likely 0 unless cancellation happened at the same time as a condition
 * change). You can check for this in the callback using
 * g_cancellable_is_cancelled().
 *
 * Returns: (transfer full): a newly allocated #GSource
 * Since: 2.48
 */


/**
 * g_datagram_based_receive_messages:
 * @datagram_based: a #GDatagramBased
 * @messages: (array length=num_messages): an array of #GInputMessage structs
 * @num_messages: the number of elements in @messages
 * @flags: an int containing #GSocketMsgFlags flags for the overall operation
 * @timeout: the maximum time (in microseconds) to wait, 0 to not block, or -1
 *   to block indefinitely
 * @cancellable: (nullable): a %GCancellable
 * @error: return location for a #GError
 *
 * Receive one or more data messages from @datagram_based in one go.
 *
 * @messages must point to an array of #GInputMessage structs and
 * @num_messages must be the length of this array. Each #GInputMessage
 * contains a pointer to an array of #GInputVector structs describing the
 * buffers that the data received in each message will be written to.
 *
 * @flags modify how all messages are received. The commonly available
 * arguments for this are available in the #GSocketMsgFlags enum, but the
 * values there are the same as the system values, and the flags
 * are passed in as-is, so you can pass in system-specific flags too. These
 * flags affect the overall receive operation. Flags affecting individual
 * messages are returned in #GInputMessage.flags.
 *
 * The other members of #GInputMessage are treated as described in its
 * documentation.
 *
 * If @timeout is negative the call will block until @num_messages have been
 * received, the connection is closed remotely (EOS), @cancellable is cancelled,
 * or an error occurs.
 *
 * If @timeout is 0 the call will return up to @num_messages without blocking,
 * or %G_IO_ERROR_WOULD_BLOCK if no messages are queued in the operating system
 * to be received.
 *
 * If @timeout is positive the call will block on the same conditions as if
 * @timeout were negative. If the timeout is reached
 * before any messages are received, %G_IO_ERROR_TIMED_OUT is returned,
 * otherwise it will return the number of messages received before timing out.
 * (Note: This is effectively the behaviour of `MSG_WAITFORONE` with
 * recvmmsg().)
 *
 * To be notified when messages are available, wait for the %G_IO_IN condition.
 * Note though that you may still receive %G_IO_ERROR_WOULD_BLOCK from
 * g_datagram_based_receive_messages() even if you were previously notified of a
 * %G_IO_IN condition.
 *
 * If the remote peer closes the connection, any messages queued in the
 * underlying receive buffer will be returned, and subsequent calls to
 * g_datagram_based_receive_messages() will return 0 (with no error set).
 *
 * If the connection is shut down or closed (by calling g_socket_close() or
 * g_socket_shutdown() with @shutdown_read set, if it’s a #GSocket, for
 * example), all calls to this function will return %G_IO_ERROR_CLOSED.
 *
 * On error -1 is returned and @error is set accordingly. An error will only
 * be returned if zero messages could be received; otherwise the number of
 * messages successfully received before the error will be returned. If
 * @cancellable is cancelled, %G_IO_ERROR_CANCELLED is returned as with any
 * other error.
 *
 * Returns: number of messages received, or -1 on error. Note that the number
 *     of messages received may be smaller than @num_messages if @timeout is
 *     zero or positive, if the peer closed the connection, or if @num_messages
 *     was larger than `UIO_MAXIOV` (1024), in which case the caller may re-try
 *     to receive the remaining messages.
 * Since: 2.48
 */


/**
 * g_datagram_based_send_messages:
 * @datagram_based: a #GDatagramBased
 * @messages: (array length=num_messages): an array of #GOutputMessage structs
 * @num_messages: the number of elements in @messages
 * @flags: an int containing #GSocketMsgFlags flags
 * @timeout: the maximum time (in microseconds) to wait, 0 to not block, or -1
 *   to block indefinitely
 * @cancellable: (nullable): a %GCancellable
 * @error: return location for a #GError
 *
 * Send one or more data messages from @datagram_based in one go.
 *
 * @messages must point to an array of #GOutputMessage structs and
 * @num_messages must be the length of this array. Each #GOutputMessage
 * contains an address to send the data to, and a pointer to an array of
 * #GOutputVector structs to describe the buffers that the data to be sent
 * for each message will be gathered from.
 *
 * @flags modify how the message is sent. The commonly available arguments
 * for this are available in the #GSocketMsgFlags enum, but the
 * values there are the same as the system values, and the flags
 * are passed in as-is, so you can pass in system-specific flags too.
 *
 * The other members of #GOutputMessage are treated as described in its
 * documentation.
 *
 * If @timeout is negative the call will block until @num_messages have been
 * sent, @cancellable is cancelled, or an error occurs.
 *
 * If @timeout is 0 the call will send up to @num_messages without blocking,
 * or will return %G_IO_ERROR_WOULD_BLOCK if there is no space to send messages.
 *
 * If @timeout is positive the call will block on the same conditions as if
 * @timeout were negative. If the timeout is reached before any messages are
 * sent, %G_IO_ERROR_TIMED_OUT is returned, otherwise it will return the number
 * of messages sent before timing out.
 *
 * To be notified when messages can be sent, wait for the %G_IO_OUT condition.
 * Note though that you may still receive %G_IO_ERROR_WOULD_BLOCK from
 * g_datagram_based_send_messages() even if you were previously notified of a
 * %G_IO_OUT condition. (On Windows in particular, this is very common due to
 * the way the underlying APIs work.)
 *
 * If the connection is shut down or closed (by calling g_socket_close() or
 * g_socket_shutdown() with @shutdown_write set, if it’s a #GSocket, for
 * example), all calls to this function will return %G_IO_ERROR_CLOSED.
 *
 * On error -1 is returned and @error is set accordingly. An error will only
 * be returned if zero messages could be sent; otherwise the number of messages
 * successfully sent before the error will be returned. If @cancellable is
 * cancelled, %G_IO_ERROR_CANCELLED is returned as with any other error.
 *
 * Returns: number of messages sent, or -1 on error. Note that the number of
 *     messages sent may be smaller than @num_messages if @timeout is zero
 *     or positive, or if @num_messages was larger than `UIO_MAXIOV` (1024), in
 *     which case the caller may re-try to send the remaining messages.
 * Since: 2.48
 */


/**
 * g_dbus_action_group_get:
 * @connection: A #GDBusConnection
 * @bus_name: (nullable): the bus name which exports the action
 *     group or %NULL if @connection is not a message bus connection
 * @object_path: the object path at which the action group is exported
 *
 * Obtains a #GDBusActionGroup for the action group which is exported at
 * the given @bus_name and @object_path.
 *
 * The thread default main context is taken at the time of this call.
 * All signals on the menu model (and any linked models) are reported
 * with respect to this context.  All calls on the returned menu model
 * (and linked models) must also originate from this same context, with
 * the thread default main context unchanged.
 *
 * This call is non-blocking.  The returned action group may or may not
 * already be filled in.  The correct thing to do is connect the signals
 * for the action group to monitor for changes and then to call
 * g_action_group_list_actions() to get the initial list.
 *
 * Returns: (transfer full): a #GDBusActionGroup
 * Since: 2.32
 */


/**
 * g_dbus_address_escape_value:
 * @string: an unescaped string to be included in a D-Bus address
 *     as the value in a key-value pair
 *
 * Escape @string so it can appear in a D-Bus address as the value
 * part of a key-value pair.
 *
 * For instance, if @string is `/run/bus-for-:0`,
 * this function would return `/run/bus-for-%3A0`,
 * which could be used in a D-Bus address like
 * `unix:nonce-tcp:host=127.0.0.1,port=42,noncefile=/run/bus-for-%3A0`.
 *
 * Returns: (transfer full): a copy of @string with all
 *     non-optionally-escaped bytes escaped
 * Since: 2.36
 */


/**
 * g_dbus_address_get_for_bus_sync:
 * @bus_type: a #GBusType
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously looks up the D-Bus address for the well-known message
 * bus instance specified by @bus_type. This may involve using various
 * platform specific mechanisms.
 *
 * The returned address will be in the
 * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * Returns: (transfer full): a valid D-Bus address string for @bus_type or
 *     %NULL if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_address_get_stream:
 * @address: A valid D-Bus address.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: Data to pass to @callback.
 *
 * Asynchronously connects to an endpoint specified by @address and
 * sets up the connection so it is in a state to run the client-side
 * of the D-Bus authentication conversation. @address must be in the
 * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_dbus_address_get_stream_finish() to get the result of
 * the operation.
 *
 * This is an asynchronous failable function. See
 * g_dbus_address_get_stream_sync() for the synchronous version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_address_get_stream_finish:
 * @res: A #GAsyncResult obtained from the GAsyncReadyCallback passed to g_dbus_address_get_stream().
 * @out_guid: (optional) (out) (nullable): %NULL or return location to store the GUID extracted from @address, if any.
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_address_get_stream().
 *
 * A server is not required to set a GUID, so @out_guid may be set to %NULL
 * even on success.
 *
 * Returns: (transfer full): A #GIOStream or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_address_get_stream_sync:
 * @address: A valid D-Bus address.
 * @out_guid: (optional) (out) (nullable): %NULL or return location to store the GUID extracted from @address, if any.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously connects to an endpoint specified by @address and
 * sets up the connection so it is in a state to run the client-side
 * of the D-Bus authentication conversation. @address must be in the
 * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * A server is not required to set a GUID, so @out_guid may be set to %NULL
 * even on success.
 *
 * This is a synchronous failable function. See
 * g_dbus_address_get_stream() for the asynchronous version.
 *
 * Returns: (transfer full): A #GIOStream or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_annotation_info_lookup:
 * @annotations: (array zero-terminated=1) (nullable): A %NULL-terminated array of annotations or %NULL.
 * @name: The name of the annotation to look up.
 *
 * Looks up the value of an annotation.
 *
 * The cost of this function is O(n) in number of annotations.
 *
 * Returns: (nullable): The value or %NULL if not found. Do not free, it is owned by @annotations.
 * Since: 2.26
 */


/**
 * g_dbus_annotation_info_ref:
 * @info: A #GDBusNodeInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_annotation_info_unref:
 * @info: A #GDBusAnnotationInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_arg_info_ref:
 * @info: A #GDBusArgInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_arg_info_unref:
 * @info: A #GDBusArgInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_auth_observer_allow_mechanism:
 * @observer: A #GDBusAuthObserver.
 * @mechanism: The name of the mechanism, e.g. `DBUS_COOKIE_SHA1`.
 *
 * Emits the #GDBusAuthObserver::allow-mechanism signal on @observer.
 *
 * Returns: %TRUE if @mechanism can be used to authenticate the other peer, %FALSE if not.
 * Since: 2.34
 */


/**
 * g_dbus_auth_observer_authorize_authenticated_peer:
 * @observer: A #GDBusAuthObserver.
 * @stream: A #GIOStream for the #GDBusConnection.
 * @credentials: (nullable): Credentials received from the peer or %NULL.
 *
 * Emits the #GDBusAuthObserver::authorize-authenticated-peer signal on @observer.
 *
 * Returns: %TRUE if the peer is authorized, %FALSE if not.
 * Since: 2.26
 */


/**
 * g_dbus_auth_observer_new:
 *
 * Creates a new #GDBusAuthObserver object.
 *
 * Returns: A #GDBusAuthObserver. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_add_filter:
 * @connection: a #GDBusConnection
 * @filter_function: a filter function
 * @user_data: user data to pass to @filter_function
 * @user_data_free_func: function to free @user_data with when filter
 *     is removed or %NULL
 *
 * Adds a message filter. Filters are handlers that are run on all
 * incoming and outgoing messages, prior to standard dispatch. Filters
 * are run in the order that they were added.  The same handler can be
 * added as a filter more than once, in which case it will be run more
 * than once.  Filters added during a filter callback won't be run on
 * the message being processed. Filter functions are allowed to modify
 * and even drop messages.
 *
 * Note that filters are run in a dedicated message handling thread so
 * they can't block and, generally, can't do anything but signal a
 * worker thread. Also note that filters are rarely needed - use API
 * such as g_dbus_connection_send_message_with_reply(),
 * g_dbus_connection_signal_subscribe() or g_dbus_connection_call() instead.
 *
 * If a filter consumes an incoming message the message is not
 * dispatched anywhere else - not even the standard dispatch machinery
 * (that API such as g_dbus_connection_signal_subscribe() and
 * g_dbus_connection_send_message_with_reply() relies on) will see the
 * message. Similarly, if a filter consumes an outgoing message, the
 * message will not be sent to the other peer.
 *
 * If @user_data_free_func is non-%NULL, it will be called (in the
 * thread-default main context of the thread you are calling this
 * method from) at some point after @user_data is no longer
 * needed. (It is not guaranteed to be called synchronously when the
 * filter is removed, and may be called after @connection has been
 * destroyed.)
 *
 * Returns: a filter identifier that can be used with
 *     g_dbus_connection_remove_filter()
 * Since: 2.26
 */


/**
 * g_dbus_connection_call:
 * @connection: a #GDBusConnection
 * @bus_name: (nullable): a unique or well-known bus name or %NULL if
 *     @connection is not a message bus connection
 * @object_path: path of remote object
 * @interface_name: D-Bus interface to invoke method on
 * @method_name: the name of the method to invoke
 * @parameters: (nullable): a #GVariant tuple with parameters for the method
 *     or %NULL if not passing parameters
 * @reply_type: (nullable): the expected type of the reply (which will be a
 *     tuple), or %NULL
 * @flags: flags from the #GDBusCallFlags enumeration
 * @timeout_msec: the timeout in milliseconds, -1 to use the default
 *     timeout or %G_MAXINT for no timeout
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request
 *     is satisfied or %NULL if you don't care about the result of the
 *     method invocation
 * @user_data: the data to pass to @callback
 *
 * Asynchronously invokes the @method_name method on the
 * @interface_name D-Bus interface on the remote object at
 * @object_path owned by @bus_name.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the operation will
 * fail with %G_IO_ERROR_CANCELLED. If @parameters contains a value
 * not compatible with the D-Bus protocol, the operation fails with
 * %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If @reply_type is non-%NULL then the reply will be checked for having this type and an
 * error will be raised if it does not match.  Said another way, if you give a @reply_type
 * then any non-%NULL return value will be of this type. Unless it’s
 * %G_VARIANT_TYPE_UNIT, the @reply_type will be a tuple containing one or more
 * values.
 *
 * If the @parameters #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.:
 * |[<!-- language="C" -->
 *  g_dbus_connection_call (connection,
 *                          "org.freedesktop.StringThings",
 *                          "/org/freedesktop/StringThings",
 *                          "org.freedesktop.StringThings",
 *                          "TwoStrings",
 *                          g_variant_new ("(ss)",
 *                                         "Thing One",
 *                                         "Thing Two"),
 *                          NULL,
 *                          G_DBUS_CALL_FLAGS_NONE,
 *                          -1,
 *                          NULL,
 *                          (GAsyncReadyCallback) two_strings_done,
 *                          NULL);
 * ]|
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from. You can then call
 * g_dbus_connection_call_finish() to get the result of the operation.
 * See g_dbus_connection_call_sync() for the synchronous version of this
 * function.
 *
 * If @callback is %NULL then the D-Bus method call message will be sent with
 * the %G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED flag set.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_call_finish:
 * @connection: a #GDBusConnection
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_call()
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_call().
 *
 * Returns: (transfer full): %NULL if @error is set. Otherwise a non-floating
 *     #GVariant tuple with return values. Free with g_variant_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_call_sync:
 * @connection: a #GDBusConnection
 * @bus_name: (nullable): a unique or well-known bus name or %NULL if
 *     @connection is not a message bus connection
 * @object_path: path of remote object
 * @interface_name: D-Bus interface to invoke method on
 * @method_name: the name of the method to invoke
 * @parameters: (nullable): a #GVariant tuple with parameters for the method
 *     or %NULL if not passing parameters
 * @reply_type: (nullable): the expected type of the reply, or %NULL
 * @flags: flags from the #GDBusCallFlags enumeration
 * @timeout_msec: the timeout in milliseconds, -1 to use the default
 *     timeout or %G_MAXINT for no timeout
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously invokes the @method_name method on the
 * @interface_name D-Bus interface on the remote object at
 * @object_path owned by @bus_name.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the
 * operation will fail with %G_IO_ERROR_CANCELLED. If @parameters
 * contains a value not compatible with the D-Bus protocol, the operation
 * fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If @reply_type is non-%NULL then the reply will be checked for having
 * this type and an error will be raised if it does not match.  Said
 * another way, if you give a @reply_type then any non-%NULL return
 * value will be of this type.
 *
 * If the @parameters #GVariant is floating, it is consumed.
 * This allows convenient 'inline' use of g_variant_new(), e.g.:
 * |[<!-- language="C" -->
 *  g_dbus_connection_call_sync (connection,
 *                               "org.freedesktop.StringThings",
 *                               "/org/freedesktop/StringThings",
 *                               "org.freedesktop.StringThings",
 *                               "TwoStrings",
 *                               g_variant_new ("(ss)",
 *                                              "Thing One",
 *                                              "Thing Two"),
 *                               NULL,
 *                               G_DBUS_CALL_FLAGS_NONE,
 *                               -1,
 *                               NULL,
 *                               &error);
 * ]|
 *
 * The calling thread is blocked until a reply is received. See
 * g_dbus_connection_call() for the asynchronous version of
 * this method.
 *
 * Returns: (transfer full): %NULL if @error is set. Otherwise a non-floating
 *     #GVariant tuple with return values. Free with g_variant_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_call_with_unix_fd_list:
 * @connection: a #GDBusConnection
 * @bus_name: (nullable): a unique or well-known bus name or %NULL if
 *     @connection is not a message bus connection
 * @object_path: path of remote object
 * @interface_name: D-Bus interface to invoke method on
 * @method_name: the name of the method to invoke
 * @parameters: (nullable): a #GVariant tuple with parameters for the method
 *     or %NULL if not passing parameters
 * @reply_type: (nullable): the expected type of the reply, or %NULL
 * @flags: flags from the #GDBusCallFlags enumeration
 * @timeout_msec: the timeout in milliseconds, -1 to use the default
 *     timeout or %G_MAXINT for no timeout
 * @fd_list: (nullable): a #GUnixFDList or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is
 *     satisfied or %NULL if you don't * care about the result of the
 *     method invocation
 * @user_data: The data to pass to @callback.
 *
 * Like g_dbus_connection_call() but also takes a #GUnixFDList object.
 *
 * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
 * values in the body of the message. For example, if a message contains
 * two file descriptors, @fd_list would have length 2, and
 * `g_variant_new_handle (0)` and `g_variant_new_handle (1)` would appear
 * somewhere in the body of the message (not necessarily in that order!)
 * to represent the file descriptors at indexes 0 and 1 respectively.
 *
 * When designing D-Bus APIs that are intended to be interoperable,
 * please note that non-GDBus implementations of D-Bus can usually only
 * access file descriptors if they are referenced in this way by a
 * value of type %G_VARIANT_TYPE_HANDLE in the body of the message.
 *
 * This method is only available on UNIX.
 *
 * Since: 2.30
 */


/**
 * g_dbus_connection_call_with_unix_fd_list_finish:
 * @connection: a #GDBusConnection
 * @out_fd_list: (out) (optional): return location for a #GUnixFDList or %NULL
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed to
 *     g_dbus_connection_call_with_unix_fd_list()
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_call_with_unix_fd_list().
 *
 * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
 * values in the body of the message. For example,
 * if g_variant_get_handle() returns 5, that is intended to be a reference
 * to the file descriptor that can be accessed by
 * `g_unix_fd_list_get (*out_fd_list, 5, ...)`.
 *
 * When designing D-Bus APIs that are intended to be interoperable,
 * please note that non-GDBus implementations of D-Bus can usually only
 * access file descriptors if they are referenced in this way by a
 * value of type %G_VARIANT_TYPE_HANDLE in the body of the message.
 *
 * Returns: (transfer full): %NULL if @error is set. Otherwise a non-floating
 *     #GVariant tuple with return values. Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_connection_call_with_unix_fd_list_sync:
 * @connection: a #GDBusConnection
 * @bus_name: (nullable): a unique or well-known bus name or %NULL
 *     if @connection is not a message bus connection
 * @object_path: path of remote object
 * @interface_name: D-Bus interface to invoke method on
 * @method_name: the name of the method to invoke
 * @parameters: (nullable): a #GVariant tuple with parameters for
 *     the method or %NULL if not passing parameters
 * @reply_type: (nullable): the expected type of the reply, or %NULL
 * @flags: flags from the #GDBusCallFlags enumeration
 * @timeout_msec: the timeout in milliseconds, -1 to use the default
 *     timeout or %G_MAXINT for no timeout
 * @fd_list: (nullable): a #GUnixFDList or %NULL
 * @out_fd_list: (out) (optional): return location for a #GUnixFDList or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Like g_dbus_connection_call_sync() but also takes and returns #GUnixFDList objects.
 * See g_dbus_connection_call_with_unix_fd_list() and
 * g_dbus_connection_call_with_unix_fd_list_finish() for more details.
 *
 * This method is only available on UNIX.
 *
 * Returns: (transfer full): %NULL if @error is set. Otherwise a non-floating
 *     #GVariant tuple with return values. Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_connection_close:
 * @connection: a #GDBusConnection
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is
 *     satisfied or %NULL if you don't care about the result
 * @user_data: The data to pass to @callback
 *
 * Closes @connection. Note that this never causes the process to
 * exit (this might only happen if the other end of a shared message
 * bus connection disconnects, see #GDBusConnection:exit-on-close).
 *
 * Once the connection is closed, operations such as sending a message
 * will return with the error %G_IO_ERROR_CLOSED. Closing a connection
 * will not automatically flush the connection so queued messages may
 * be lost. Use g_dbus_connection_flush() if you need such guarantees.
 *
 * If @connection is already closed, this method fails with
 * %G_IO_ERROR_CLOSED.
 *
 * When @connection has been closed, the #GDBusConnection::closed
 * signal is emitted in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread that @connection was constructed in.
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from. You can
 * then call g_dbus_connection_close_finish() to get the result of the
 * operation. See g_dbus_connection_close_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_close_finish:
 * @connection: a #GDBusConnection
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed
 *     to g_dbus_connection_close()
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_close().
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_close_sync:
 * @connection: a #GDBusConnection
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously closes @connection. The calling thread is blocked
 * until this is done. See g_dbus_connection_close() for the
 * asynchronous version of this method and more details about what it
 * does.
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_emit_signal:
 * @connection: a #GDBusConnection
 * @destination_bus_name: (nullable): the unique bus name for the destination
 *     for the signal or %NULL to emit to all listeners
 * @object_path: path of remote object
 * @interface_name: D-Bus interface to emit a signal on
 * @signal_name: the name of the signal to emit
 * @parameters: (nullable): a #GVariant tuple with parameters for the signal
 *              or %NULL if not passing parameters
 * @error: Return location for error or %NULL
 *
 * Emits a signal.
 *
 * If the parameters GVariant is floating, it is consumed.
 *
 * This can only fail if @parameters is not compatible with the D-Bus protocol
 * (%G_IO_ERROR_INVALID_ARGUMENT), or if @connection has been closed
 * (%G_IO_ERROR_CLOSED).
 *
 * Returns: %TRUE unless @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_export_action_group:
 * @connection: a #GDBusConnection
 * @object_path: a D-Bus object path
 * @action_group: a #GActionGroup
 * @error: a pointer to a %NULL #GError, or %NULL
 *
 * Exports @action_group on @connection at @object_path.
 *
 * The implemented D-Bus API should be considered private.  It is
 * subject to change in the future.
 *
 * A given object path can only have one action group exported on it.
 * If this constraint is violated, the export will fail and 0 will be
 * returned (with @error set accordingly).
 *
 * You can unexport the action group using
 * g_dbus_connection_unexport_action_group() with the return value of
 * this function.
 *
 * The thread default main context is taken at the time of this call.
 * All incoming action activations and state change requests are
 * reported from this context.  Any changes on the action group that
 * cause it to emit signals must also come from this same context.
 * Since incoming action activations and state change requests are
 * rather likely to cause changes on the action group, this effectively
 * limits a given action group to being exported from only one main
 * context.
 *
 * Returns: the ID of the export (never zero), or 0 in case of failure
 * Since: 2.32
 */


/**
 * g_dbus_connection_export_menu_model:
 * @connection: a #GDBusConnection
 * @object_path: a D-Bus object path
 * @menu: a #GMenuModel
 * @error: return location for an error, or %NULL
 *
 * Exports @menu on @connection at @object_path.
 *
 * The implemented D-Bus API should be considered private.
 * It is subject to change in the future.
 *
 * An object path can only have one menu model exported on it. If this
 * constraint is violated, the export will fail and 0 will be
 * returned (with @error set accordingly).
 *
 * Exporting menus with sections containing more than
 * %G_MENU_EXPORTER_MAX_SECTION_SIZE items is not supported and results in
 * undefined behavior.
 *
 * You can unexport the menu model using
 * g_dbus_connection_unexport_menu_model() with the return value of
 * this function.
 *
 * Returns: the ID of the export (never zero), or 0 in case of failure
 * Since: 2.32
 */


/**
 * g_dbus_connection_flush:
 * @connection: a #GDBusConnection
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: (nullable): a #GAsyncReadyCallback to call when the
 *     request is satisfied or %NULL if you don't care about the result
 * @user_data: The data to pass to @callback
 *
 * Asynchronously flushes @connection, that is, writes all queued
 * outgoing message to the transport and then flushes the transport
 * (using g_output_stream_flush_async()). This is useful in programs
 * that wants to emit a D-Bus signal and then exit immediately. Without
 * flushing the connection, there is no guaranteed that the message has
 * been sent to the networking buffers in the OS kernel.
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from. You can
 * then call g_dbus_connection_flush_finish() to get the result of the
 * operation. See g_dbus_connection_flush_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_flush_finish:
 * @connection: a #GDBusConnection
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed
 *     to g_dbus_connection_flush()
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_flush().
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_flush_sync:
 * @connection: a #GDBusConnection
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously flushes @connection. The calling thread is blocked
 * until this is done. See g_dbus_connection_flush() for the
 * asynchronous version of this method and more details about what it
 * does.
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_capabilities:
 * @connection: a #GDBusConnection
 *
 * Gets the capabilities negotiated with the remote peer
 *
 * Returns: zero or more flags from the #GDBusCapabilityFlags enumeration
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_exit_on_close:
 * @connection: a #GDBusConnection
 *
 * Gets whether the process is terminated when @connection is
 * closed by the remote peer. See
 * #GDBusConnection:exit-on-close for more details.
 *
 * Returns: whether the process is terminated when @connection is
 *     closed by the remote peer
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_flags:
 * @connection: a #GDBusConnection
 *
 * Gets the flags used to construct this connection
 *
 * Returns: zero or more flags from the #GDBusConnectionFlags enumeration
 * Since: 2.60
 */


/**
 * g_dbus_connection_get_guid:
 * @connection: a #GDBusConnection
 *
 * The GUID of the peer performing the role of server when
 * authenticating. See #GDBusConnection:guid for more details.
 *
 * Returns: (not nullable): The GUID. Do not free this string, it is owned by
 *     @connection.
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_last_serial:
 * @connection: a #GDBusConnection
 *
 * Retrieves the last serial number assigned to a #GDBusMessage on
 * the current thread. This includes messages sent via both low-level
 * API such as g_dbus_connection_send_message() as well as
 * high-level API such as g_dbus_connection_emit_signal(),
 * g_dbus_connection_call() or g_dbus_proxy_call().
 *
 * Returns: the last used serial or zero when no message has been sent
 *     within the current thread
 * Since: 2.34
 */


/**
 * g_dbus_connection_get_peer_credentials:
 * @connection: a #GDBusConnection
 *
 * Gets the credentials of the authenticated peer. This will always
 * return %NULL unless @connection acted as a server
 * (e.g. %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER was passed)
 * when set up and the client passed credentials as part of the
 * authentication process.
 *
 * In a message bus setup, the message bus is always the server and
 * each application is a client. So this method will always return
 * %NULL for message bus clients.
 *
 * Returns: (transfer none) (nullable): a #GCredentials or %NULL if not
 *     available. Do not free this object, it is owned by @connection.
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_stream:
 * @connection: a #GDBusConnection
 *
 * Gets the underlying stream used for IO.
 *
 * While the #GDBusConnection is active, it will interact with this
 * stream from a worker thread, so it is not safe to interact with
 * the stream directly.
 *
 * Returns: (transfer none) (not nullable): the stream used for IO
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_unique_name:
 * @connection: a #GDBusConnection
 *
 * Gets the unique name of @connection as assigned by the message
 * bus. This can also be used to figure out if @connection is a
 * message bus connection.
 *
 * Returns: (nullable): the unique name or %NULL if @connection is not a message
 *     bus connection. Do not free this string, it is owned by
 *     @connection.
 * Since: 2.26
 */


/**
 * g_dbus_connection_is_closed:
 * @connection: a #GDBusConnection
 *
 * Gets whether @connection is closed.
 *
 * Returns: %TRUE if the connection is closed, %FALSE otherwise
 * Since: 2.26
 */


/**
 * g_dbus_connection_new:
 * @stream: a #GIOStream
 * @guid: (nullable): the GUID to use if authenticating as a server or %NULL
 * @flags: flags describing how to make the connection
 * @observer: (nullable): a #GDBusAuthObserver or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to @callback
 *
 * Asynchronously sets up a D-Bus connection for exchanging D-Bus messages
 * with the end represented by @stream.
 *
 * If @stream is a #GSocketConnection, then the corresponding #GSocket
 * will be put into non-blocking mode.
 *
 * The D-Bus connection will interact with @stream from a worker thread.
 * As a result, the caller should not interact with @stream after this
 * method has been called, except by calling g_object_unref() on it.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_dbus_connection_new_finish() to get the result of the
 * operation.
 *
 * This is an asynchronous failable constructor. See
 * g_dbus_connection_new_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_finish:
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback
 *     passed to g_dbus_connection_new().
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_new().
 *
 * Returns: (transfer full): a #GDBusConnection or %NULL if @error is set. Free
 *     with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_for_address:
 * @address: a D-Bus address
 * @flags: flags describing how to make the connection
 * @observer: (nullable): a #GDBusAuthObserver or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to @callback
 *
 * Asynchronously connects and sets up a D-Bus client connection for
 * exchanging D-Bus messages with an endpoint specified by @address
 * which must be in the
 * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * This constructor can only be used to initiate client-side
 * connections - use g_dbus_connection_new() if you need to act as the
 * server. In particular, @flags cannot contain the
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER,
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS or
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_REQUIRE_SAME_USER flags.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_dbus_connection_new_for_address_finish() to get the result of
 * the operation.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * This is an asynchronous failable constructor. See
 * g_dbus_connection_new_for_address_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_for_address_finish:
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed
 *     to g_dbus_connection_new()
 * @error: return location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_new_for_address().
 *
 * Returns: (transfer full): a #GDBusConnection or %NULL if @error is set.
 *     Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_for_address_sync:
 * @address: a D-Bus address
 * @flags: flags describing how to make the connection
 * @observer: (nullable): a #GDBusAuthObserver or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously connects and sets up a D-Bus client connection for
 * exchanging D-Bus messages with an endpoint specified by @address
 * which must be in the
 * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * This constructor can only be used to initiate client-side
 * connections - use g_dbus_connection_new_sync() if you need to act
 * as the server. In particular, @flags cannot contain the
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER,
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS or
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_REQUIRE_SAME_USER flags.
 *
 * This is a synchronous failable constructor. See
 * g_dbus_connection_new_for_address() for the asynchronous version.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * Returns: (transfer full): a #GDBusConnection or %NULL if @error is set.
 *     Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_sync:
 * @stream: a #GIOStream
 * @guid: (nullable): the GUID to use if authenticating as a server or %NULL
 * @flags: flags describing how to make the connection
 * @observer: (nullable): a #GDBusAuthObserver or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously sets up a D-Bus connection for exchanging D-Bus messages
 * with the end represented by @stream.
 *
 * If @stream is a #GSocketConnection, then the corresponding #GSocket
 * will be put into non-blocking mode.
 *
 * The D-Bus connection will interact with @stream from a worker thread.
 * As a result, the caller should not interact with @stream after this
 * method has been called, except by calling g_object_unref() on it.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * This is a synchronous failable constructor. See
 * g_dbus_connection_new() for the asynchronous version.
 *
 * Returns: (transfer full): a #GDBusConnection or %NULL if @error is set.
 *     Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_register_object:
 * @connection: a #GDBusConnection
 * @object_path: the object path to register at
 * @interface_info: introspection data for the interface
 * @vtable: (nullable): a #GDBusInterfaceVTable to call into or %NULL
 * @user_data: (nullable): data to pass to functions in @vtable
 * @user_data_free_func: function to call when the object path is unregistered
 * @error: return location for error or %NULL
 *
 * Registers callbacks for exported objects at @object_path with the
 * D-Bus interface that is described in @interface_info.
 *
 * Calls to functions in @vtable (and @user_data_free_func) will happen
 * in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from.
 *
 * Note that all #GVariant values passed to functions in @vtable will match
 * the signature given in @interface_info - if a remote caller passes
 * incorrect values, the `org.freedesktop.DBus.Error.InvalidArgs`
 * is returned to the remote caller.
 *
 * Additionally, if the remote caller attempts to invoke methods or
 * access properties not mentioned in @interface_info the
 * `org.freedesktop.DBus.Error.UnknownMethod` resp.
 * `org.freedesktop.DBus.Error.InvalidArgs` errors
 * are returned to the caller.
 *
 * It is considered a programming error if the
 * #GDBusInterfaceGetPropertyFunc function in @vtable returns a
 * #GVariant of incorrect type.
 *
 * If an existing callback is already registered at @object_path and
 * @interface_name, then @error is set to %G_IO_ERROR_EXISTS.
 *
 * GDBus automatically implements the standard D-Bus interfaces
 * org.freedesktop.DBus.Properties, org.freedesktop.DBus.Introspectable
 * and org.freedesktop.Peer, so you don't have to implement those for the
 * objects you export. You can implement org.freedesktop.DBus.Properties
 * yourself, e.g. to handle getting and setting of properties asynchronously.
 *
 * Note that the reference count on @interface_info will be
 * incremented by 1 (unless allocated statically, e.g. if the
 * reference count is -1, see g_dbus_interface_info_ref()) for as long
 * as the object is exported. Also note that @vtable will be copied.
 *
 * See this [server][gdbus-server] for an example of how to use this method.
 *
 * Returns: 0 if @error is set, otherwise a registration id (never 0)
 *     that can be used with g_dbus_connection_unregister_object()
 * Since: 2.26
 */


/**
 * g_dbus_connection_register_object_with_closures: (rename-to g_dbus_connection_register_object)
 * @connection: A #GDBusConnection.
 * @object_path: The object path to register at.
 * @interface_info: Introspection data for the interface.
 * @method_call_closure: (nullable): #GClosure for handling incoming method calls.
 * @get_property_closure: (nullable): #GClosure for getting a property.
 * @set_property_closure: (nullable): #GClosure for setting a property.
 * @error: Return location for error or %NULL.
 *
 * Version of g_dbus_connection_register_object() using closures instead of a
 * #GDBusInterfaceVTable for easier binding in other languages.
 *
 * Returns: 0 if @error is set, otherwise a registration ID (never 0)
 * that can be used with g_dbus_connection_unregister_object() .
 * Since: 2.46
 */


/**
 * g_dbus_connection_register_subtree:
 * @connection: a #GDBusConnection
 * @object_path: the object path to register the subtree at
 * @vtable: a #GDBusSubtreeVTable to enumerate, introspect and
 *     dispatch nodes in the subtree
 * @flags: flags used to fine tune the behavior of the subtree
 * @user_data: data to pass to functions in @vtable
 * @user_data_free_func: function to call when the subtree is unregistered
 * @error: return location for error or %NULL
 *
 * Registers a whole subtree of dynamic objects.
 *
 * The @enumerate and @introspection functions in @vtable are used to
 * convey, to remote callers, what nodes exist in the subtree rooted
 * by @object_path.
 *
 * When handling remote calls into any node in the subtree, first the
 * @enumerate function is used to check if the node exists. If the node exists
 * or the %G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES flag is set
 * the @introspection function is used to check if the node supports the
 * requested method. If so, the @dispatch function is used to determine
 * where to dispatch the call. The collected #GDBusInterfaceVTable and
 * #gpointer will be used to call into the interface vtable for processing
 * the request.
 *
 * All calls into user-provided code will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from.
 *
 * If an existing subtree is already registered at @object_path or
 * then @error is set to %G_IO_ERROR_EXISTS.
 *
 * Note that it is valid to register regular objects (using
 * g_dbus_connection_register_object()) in a subtree registered with
 * g_dbus_connection_register_subtree() - if so, the subtree handler
 * is tried as the last resort. One way to think about a subtree
 * handler is to consider it a fallback handler for object paths not
 * registered via g_dbus_connection_register_object() or other bindings.
 *
 * Note that @vtable will be copied so you cannot change it after
 * registration.
 *
 * See this [server][gdbus-subtree-server] for an example of how to use
 * this method.
 *
 * Returns: 0 if @error is set, otherwise a subtree registration ID (never 0)
 * that can be used with g_dbus_connection_unregister_subtree()
 * Since: 2.26
 */


/**
 * g_dbus_connection_remove_filter:
 * @connection: a #GDBusConnection
 * @filter_id: an identifier obtained from g_dbus_connection_add_filter()
 *
 * Removes a filter.
 *
 * Note that since filters run in a different thread, there is a race
 * condition where it is possible that the filter will be running even
 * after calling g_dbus_connection_remove_filter(), so you cannot just
 * free data that the filter might be using. Instead, you should pass
 * a #GDestroyNotify to g_dbus_connection_add_filter(), which will be
 * called when it is guaranteed that the data is no longer needed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message:
 * @connection: a #GDBusConnection
 * @message: a #GDBusMessage
 * @flags: flags affecting how the message is sent
 * @out_serial: (out) (optional): return location for serial number assigned
 *     to @message when sending it or %NULL
 * @error: Return location for error or %NULL
 *
 * Asynchronously sends @message to the peer represented by @connection.
 *
 * Unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
 * will be assigned by @connection and set on @message via
 * g_dbus_message_set_serial(). If @out_serial is not %NULL, then the
 * serial number used will be written to this location prior to
 * submitting the message to the underlying transport. While it has a `volatile`
 * qualifier, this is a historical artifact and the argument passed to it should
 * not be `volatile`.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @message is not well-formed,
 * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * See this [server][gdbus-server] and [client][gdbus-unix-fd-client]
 * for an example of how to use this low-level API to send and receive
 * UNIX file descriptors.
 *
 * Note that @message must be unlocked, unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
 *
 * Returns: %TRUE if the message was well-formed and queued for
 *     transmission, %FALSE if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message_with_reply:
 * @connection: a #GDBusConnection
 * @message: a #GDBusMessage
 * @flags: flags affecting how the message is sent
 * @timeout_msec: the timeout in milliseconds, -1 to use the default
 *     timeout or %G_MAXINT for no timeout
 * @out_serial: (out) (optional): return location for serial number assigned
 *     to @message when sending it or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request
 *     is satisfied or %NULL if you don't care about the result
 * @user_data: The data to pass to @callback
 *
 * Asynchronously sends @message to the peer represented by @connection.
 *
 * Unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
 * will be assigned by @connection and set on @message via
 * g_dbus_message_set_serial(). If @out_serial is not %NULL, then the
 * serial number used will be written to this location prior to
 * submitting the message to the underlying transport. While it has a `volatile`
 * qualifier, this is a historical artifact and the argument passed to it should
 * not be `volatile`.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the operation will
 * fail with %G_IO_ERROR_CANCELLED. If @message is not well-formed,
 * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * This is an asynchronous method. When the operation is finished, @callback
 * will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from. You can then call
 * g_dbus_connection_send_message_with_reply_finish() to get the result of the operation.
 * See g_dbus_connection_send_message_with_reply_sync() for the synchronous version.
 *
 * Note that @message must be unlocked, unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
 *
 * See this [server][gdbus-server] and [client][gdbus-unix-fd-client]
 * for an example of how to use this low-level API to send and receive
 * UNIX file descriptors.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message_with_reply_finish:
 * @connection: a #GDBusConnection
 * @res: a #GAsyncResult obtained from the #GAsyncReadyCallback passed to
 *     g_dbus_connection_send_message_with_reply()
 * @error: teturn location for error or %NULL
 *
 * Finishes an operation started with g_dbus_connection_send_message_with_reply().
 *
 * Note that @error is only set if a local in-process error
 * occurred. That is to say that the returned #GDBusMessage object may
 * be of type %G_DBUS_MESSAGE_TYPE_ERROR. Use
 * g_dbus_message_to_gerror() to transcode this to a #GError.
 *
 * See this [server][gdbus-server] and [client][gdbus-unix-fd-client]
 * for an example of how to use this low-level API to send and receive
 * UNIX file descriptors.
 *
 * Returns: (transfer full): a locked #GDBusMessage or %NULL if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message_with_reply_sync:
 * @connection: a #GDBusConnection
 * @message: a #GDBusMessage
 * @flags: flags affecting how the message is sent.
 * @timeout_msec: the timeout in milliseconds, -1 to use the default
 *     timeout or %G_MAXINT for no timeout
 * @out_serial: (out) (optional): return location for serial number
 *     assigned to @message when sending it or %NULL
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @error: return location for error or %NULL
 *
 * Synchronously sends @message to the peer represented by @connection
 * and blocks the calling thread until a reply is received or the
 * timeout is reached. See g_dbus_connection_send_message_with_reply()
 * for the asynchronous version of this method.
 *
 * Unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
 * will be assigned by @connection and set on @message via
 * g_dbus_message_set_serial(). If @out_serial is not %NULL, then the
 * serial number used will be written to this location prior to
 * submitting the message to the underlying transport. While it has a `volatile`
 * qualifier, this is a historical artifact and the argument passed to it should
 * not be `volatile`.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the operation will
 * fail with %G_IO_ERROR_CANCELLED. If @message is not well-formed,
 * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * Note that @error is only set if a local in-process error
 * occurred. That is to say that the returned #GDBusMessage object may
 * be of type %G_DBUS_MESSAGE_TYPE_ERROR. Use
 * g_dbus_message_to_gerror() to transcode this to a #GError.
 *
 * See this [server][gdbus-server] and [client][gdbus-unix-fd-client]
 * for an example of how to use this low-level API to send and receive
 * UNIX file descriptors.
 *
 * Note that @message must be unlocked, unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
 *
 * Returns: (transfer full): a locked #GDBusMessage that is the reply
 *     to @message or %NULL if @error is set
 * Since: 2.26
 */


/**
 * g_dbus_connection_set_exit_on_close:
 * @connection: a #GDBusConnection
 * @exit_on_close: whether the process should be terminated
 *     when @connection is closed by the remote peer
 *
 * Sets whether the process should be terminated when @connection is
 * closed by the remote peer. See #GDBusConnection:exit-on-close for
 * more details.
 *
 * Note that this function should be used with care. Most modern UNIX
 * desktops tie the notion of a user session with the session bus, and expect
 * all of a user's applications to quit when their bus connection goes away.
 * If you are setting @exit_on_close to %FALSE for the shared session
 * bus connection, you should make sure that your application exits
 * when the user session ends.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_signal_subscribe:
 * @connection: a #GDBusConnection
 * @sender: (nullable): sender name to match on (unique or well-known name)
 *     or %NULL to listen from all senders
 * @interface_name: (nullable): D-Bus interface name to match on or %NULL to
 *     match on all interfaces
 * @member: (nullable): D-Bus signal name to match on or %NULL to match on
 *     all signals
 * @object_path: (nullable): object path to match on or %NULL to match on
 *     all object paths
 * @arg0: (nullable): contents of first string argument to match on or %NULL
 *     to match on all kinds of arguments
 * @flags: #GDBusSignalFlags describing how arg0 is used in subscribing to the
 *     signal
 * @callback: callback to invoke when there is a signal matching the requested data
 * @user_data: user data to pass to @callback
 * @user_data_free_func: (nullable): function to free @user_data with when
 *     subscription is removed or %NULL
 *
 * Subscribes to signals on @connection and invokes @callback whenever
 * the signal is received. Note that @callback will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from.
 *
 * If @connection is not a message bus connection, @sender must be
 * %NULL.
 *
 * If @sender is a well-known name note that @callback is invoked with
 * the unique name for the owner of @sender, not the well-known name
 * as one would expect. This is because the message bus rewrites the
 * name. As such, to avoid certain race conditions, users should be
 * tracking the name owner of the well-known name and use that when
 * processing the received signal.
 *
 * If one of %G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_NAMESPACE or
 * %G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_PATH are given, @arg0 is
 * interpreted as part of a namespace or path.  The first argument
 * of a signal is matched against that part as specified by D-Bus.
 *
 * If @user_data_free_func is non-%NULL, it will be called (in the
 * thread-default main context of the thread you are calling this
 * method from) at some point after @user_data is no longer
 * needed. (It is not guaranteed to be called synchronously when the
 * signal is unsubscribed from, and may be called after @connection
 * has been destroyed.)
 *
 * As @callback is potentially invoked in a different thread from where it’s
 * emitted, it’s possible for this to happen after
 * g_dbus_connection_signal_unsubscribe() has been called in another thread.
 * Due to this, @user_data should have a strong reference which is freed with
 * @user_data_free_func, rather than pointing to data whose lifecycle is tied
 * to the signal subscription. For example, if a #GObject is used to store the
 * subscription ID from g_dbus_connection_signal_subscribe(), a strong reference
 * to that #GObject must be passed to @user_data, and g_object_unref() passed to
 * @user_data_free_func. You are responsible for breaking the resulting
 * reference count cycle by explicitly unsubscribing from the signal when
 * dropping the last external reference to the #GObject. Alternatively, a weak
 * reference may be used.
 *
 * It is guaranteed that if you unsubscribe from a signal using
 * g_dbus_connection_signal_unsubscribe() from the same thread which made the
 * corresponding g_dbus_connection_signal_subscribe() call, @callback will not
 * be invoked after g_dbus_connection_signal_unsubscribe() returns.
 *
 * The returned subscription identifier is an opaque value which is guaranteed
 * to never be zero.
 *
 * This function can never fail.
 *
 * Returns: a subscription identifier that can be used with g_dbus_connection_signal_unsubscribe()
 * Since: 2.26
 */


/**
 * g_dbus_connection_signal_unsubscribe:
 * @connection: a #GDBusConnection
 * @subscription_id: a subscription id obtained from
 *     g_dbus_connection_signal_subscribe()
 *
 * Unsubscribes from signals.
 *
 * Note that there may still be D-Bus traffic to process (relating to this
 * signal subscription) in the current thread-default #GMainContext after this
 * function has returned. You should continue to iterate the #GMainContext
 * until the #GDestroyNotify function passed to
 * g_dbus_connection_signal_subscribe() is called, in order to avoid memory
 * leaks through callbacks queued on the #GMainContext after it’s stopped being
 * iterated.
 * Alternatively, any idle source with a priority lower than %G_PRIORITY_DEFAULT
 * that was scheduled after unsubscription, also indicates that all resources
 * of this subscription are released.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_start_message_processing:
 * @connection: a #GDBusConnection
 *
 * If @connection was created with
 * %G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING, this method
 * starts processing messages. Does nothing on if @connection wasn't
 * created with this flag or if the method has already been called.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_unexport_action_group:
 * @connection: a #GDBusConnection
 * @export_id: the ID from g_dbus_connection_export_action_group()
 *
 * Reverses the effect of a previous call to
 * g_dbus_connection_export_action_group().
 *
 * It is an error to call this function with an ID that wasn't returned
 * from g_dbus_connection_export_action_group() or to call it with the
 * same ID more than once.
 *
 * Since: 2.32
 */


/**
 * g_dbus_connection_unexport_menu_model:
 * @connection: a #GDBusConnection
 * @export_id: the ID from g_dbus_connection_export_menu_model()
 *
 * Reverses the effect of a previous call to
 * g_dbus_connection_export_menu_model().
 *
 * It is an error to call this function with an ID that wasn't returned
 * from g_dbus_connection_export_menu_model() or to call it with the
 * same ID more than once.
 *
 * Since: 2.32
 */


/**
 * g_dbus_connection_unregister_object:
 * @connection: a #GDBusConnection
 * @registration_id: a registration id obtained from
 *     g_dbus_connection_register_object()
 *
 * Unregisters an object.
 *
 * Returns: %TRUE if the object was unregistered, %FALSE otherwise
 * Since: 2.26
 */


/**
 * g_dbus_connection_unregister_subtree:
 * @connection: a #GDBusConnection
 * @registration_id: a subtree registration id obtained from
 *     g_dbus_connection_register_subtree()
 *
 * Unregisters a subtree.
 *
 * Returns: %TRUE if the subtree was unregistered, %FALSE otherwise
 * Since: 2.26
 */


/**
 * g_dbus_error_encode_gerror:
 * @error: A #GError.
 *
 * Creates a D-Bus error name to use for @error. If @error matches
 * a registered error (cf. g_dbus_error_register_error()), the corresponding
 * D-Bus error name will be returned.
 *
 * Otherwise the a name of the form
 * `org.gtk.GDBus.UnmappedGError.Quark._ESCAPED_QUARK_NAME.Code_ERROR_CODE`
 * will be used. This allows other GDBus applications to map the error
 * on the wire back to a #GError using g_dbus_error_new_for_dbus_error().
 *
 * This function is typically only used in object mappings to put a
 * #GError on the wire. Regular applications should not use it.
 *
 * Returns: (transfer full) (not nullable): A D-Bus error name (never %NULL).
 *     Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_error_get_remote_error:
 * @error: a #GError
 *
 * Gets the D-Bus error name used for @error, if any.
 *
 * This function is guaranteed to return a D-Bus error name for all
 * #GErrors returned from functions handling remote method calls
 * (e.g. g_dbus_connection_call_finish()) unless
 * g_dbus_error_strip_remote_error() has been used on @error.
 *
 * Returns: (nullable) (transfer full): an allocated string or %NULL if the
 *     D-Bus error name could not be found. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_error_is_remote_error:
 * @error: A #GError.
 *
 * Checks if @error represents an error received via D-Bus from a remote peer. If so,
 * use g_dbus_error_get_remote_error() to get the name of the error.
 *
 * Returns: %TRUE if @error represents an error from a remote peer,
 * %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_error_new_for_dbus_error:
 * @dbus_error_name: D-Bus error name.
 * @dbus_error_message: D-Bus error message.
 *
 * Creates a #GError based on the contents of @dbus_error_name and
 * @dbus_error_message.
 *
 * Errors registered with g_dbus_error_register_error() will be looked
 * up using @dbus_error_name and if a match is found, the error domain
 * and code is used. Applications can use g_dbus_error_get_remote_error()
 * to recover @dbus_error_name.
 *
 * If a match against a registered error is not found and the D-Bus
 * error name is in a form as returned by g_dbus_error_encode_gerror()
 * the error domain and code encoded in the name is used to
 * create the #GError. Also, @dbus_error_name is added to the error message
 * such that it can be recovered with g_dbus_error_get_remote_error().
 *
 * Otherwise, a #GError with the error code %G_IO_ERROR_DBUS_ERROR
 * in the %G_IO_ERROR error domain is returned. Also, @dbus_error_name is
 * added to the error message such that it can be recovered with
 * g_dbus_error_get_remote_error().
 *
 * In all three cases, @dbus_error_name can always be recovered from the
 * returned #GError using the g_dbus_error_get_remote_error() function
 * (unless g_dbus_error_strip_remote_error() hasn't been used on the returned error).
 *
 * This function is typically only used in object mappings to prepare
 * #GError instances for applications. Regular applications should not use
 * it.
 *
 * Returns: (transfer full): An allocated #GError. Free with g_error_free().
 * Since: 2.26
 */


/**
 * g_dbus_error_register_error:
 * @error_domain: A #GQuark for an error domain.
 * @error_code: An error code.
 * @dbus_error_name: A D-Bus error name.
 *
 * Creates an association to map between @dbus_error_name and
 * #GErrors specified by @error_domain and @error_code.
 *
 * This is typically done in the routine that returns the #GQuark for
 * an error domain.
 *
 * Returns: %TRUE if the association was created, %FALSE if it already
 * exists.
 * Since: 2.26
 */


/**
 * g_dbus_error_register_error_domain:
 * @error_domain_quark_name: The error domain name.
 * @quark_volatile: A pointer where to store the #GQuark.
 * @entries: (array length=num_entries): A pointer to @num_entries #GDBusErrorEntry struct items.
 * @num_entries: Number of items to register.
 *
 * Helper function for associating a #GError error domain with D-Bus error names.
 *
 * While @quark_volatile has a `volatile` qualifier, this is a historical
 * artifact and the argument passed to it should not be `volatile`.
 *
 * Since: 2.26
 */


/**
 * g_dbus_error_set_dbus_error:
 * @error: A pointer to a #GError or %NULL.
 * @dbus_error_name: D-Bus error name.
 * @dbus_error_message: D-Bus error message.
 * @format: (nullable): printf()-style format to prepend to @dbus_error_message or %NULL.
 * @...: Arguments for @format.
 *
 * Does nothing if @error is %NULL. Otherwise sets *@error to
 * a new #GError created with g_dbus_error_new_for_dbus_error()
 * with @dbus_error_message prepend with @format (unless %NULL).
 *
 * Since: 2.26
 */


/**
 * g_dbus_error_set_dbus_error_valist:
 * @error: A pointer to a #GError or %NULL.
 * @dbus_error_name: D-Bus error name.
 * @dbus_error_message: D-Bus error message.
 * @format: (nullable): printf()-style format to prepend to @dbus_error_message or %NULL.
 * @var_args: Arguments for @format.
 *
 * Like g_dbus_error_set_dbus_error() but intended for language bindings.
 *
 * Since: 2.26
 */


/**
 * g_dbus_error_strip_remote_error:
 * @error: A #GError.
 *
 * Looks for extra information in the error message used to recover
 * the D-Bus error name and strips it if found. If stripped, the
 * message field in @error will correspond exactly to what was
 * received on the wire.
 *
 * This is typically used when presenting errors to the end user.
 *
 * Returns: %TRUE if information was stripped, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_error_unregister_error:
 * @error_domain: A #GQuark for an error domain.
 * @error_code: An error code.
 * @dbus_error_name: A D-Bus error name.
 *
 * Destroys an association previously set up with g_dbus_error_register_error().
 *
 * Returns: %TRUE if the association was destroyed, %FALSE if it wasn't found.
 * Since: 2.26
 */


/**
 * g_dbus_escape_object_path:
 * @s: the string to escape
 *
 * This is a language binding friendly version of g_dbus_escape_object_path_bytestring().
 *
 * Returns: an escaped version of @s. Free with g_free().
 * Since: 2.68
 */


/**
 * g_dbus_escape_object_path_bytestring:
 * @bytes: (array zero-terminated=1) (element-type guint8): the string of bytes to escape
 *
 * Escapes @bytes for use in a D-Bus object path component.
 * @bytes is an array of zero or more nonzero bytes in an
 * unspecified encoding, followed by a single zero byte.
 *
 * The escaping method consists of replacing all non-alphanumeric
 * characters (see g_ascii_isalnum()) with their hexadecimal value
 * preceded by an underscore (`_`). For example:
 * `foo.bar.baz` will become `foo_2ebar_2ebaz`.
 *
 * This method is appropriate to use when the input is nearly
 * a valid object path component but is not when your input
 * is far from being a valid object path component.
 * Other escaping algorithms are also valid to use with
 * D-Bus object paths.
 *
 * This can be reversed with g_dbus_unescape_object_path().
 *
 * Returns: an escaped version of @bytes. Free with g_free().
 * Since: 2.68
 */


/**
 * g_dbus_generate_guid:
 *
 * Generate a D-Bus GUID that can be used with
 * e.g. g_dbus_connection_new().
 *
 * See the
 * [D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#uuids)
 * regarding what strings are valid D-Bus GUIDs. The specification refers to
 * these as ‘UUIDs’ whereas GLib (for historical reasons) refers to them as
 * ‘GUIDs’. The terms are interchangeable.
 *
 * Note that D-Bus GUIDs do not follow
 * [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122).
 *
 * Returns: A valid D-Bus GUID. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_gvalue_to_gvariant:
 * @gvalue: A #GValue to convert to a #GVariant
 * @type: A #GVariantType
 *
 * Converts a #GValue to a #GVariant of the type indicated by the @type
 * parameter.
 *
 * The conversion is using the following rules:
 *
 * - `G_TYPE_STRING`: 's', 'o', 'g' or 'ay'
 * - `G_TYPE_STRV`: 'as', 'ao' or 'aay'
 * - `G_TYPE_BOOLEAN`: 'b'
 * - `G_TYPE_UCHAR`: 'y'
 * - `G_TYPE_INT`: 'i', 'n'
 * - `G_TYPE_UINT`: 'u', 'q'
 * - `G_TYPE_INT64`: 'x'
 * - `G_TYPE_UINT64`: 't'
 * - `G_TYPE_DOUBLE`: 'd'
 * - `G_TYPE_VARIANT`: Any #GVariantType
 *
 * This can fail if e.g. @gvalue is of type %G_TYPE_STRING and @type
 * is 'i', i.e. %G_VARIANT_TYPE_INT32. It will also fail for any #GType
 * (including e.g. %G_TYPE_OBJECT and %G_TYPE_BOXED derived-types) not
 * in the table above.
 *
 * Note that if @gvalue is of type %G_TYPE_VARIANT and its value is
 * %NULL, the empty #GVariant instance (never %NULL) for @type is
 * returned (e.g. 0 for scalar types, the empty string for string types,
 * '/' for object path types, the empty array for any array type and so on).
 *
 * See the g_dbus_gvariant_to_gvalue() function for how to convert a
 * #GVariant to a #GValue.
 *
 * Returns: (transfer full): A #GVariant (never floating) of
 *     #GVariantType @type holding the data from @gvalue or an empty #GVariant
 *     in case of failure. Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_gvariant_to_gvalue:
 * @value: A #GVariant.
 * @out_gvalue: (out): Return location pointing to a zero-filled (uninitialized) #GValue.
 *
 * Converts a #GVariant to a #GValue. If @value is floating, it is consumed.
 *
 * The rules specified in the g_dbus_gvalue_to_gvariant() function are
 * used - this function is essentially its reverse form. So, a #GVariant
 * containing any basic or string array type will be converted to a #GValue
 * containing a basic value or string array. Any other #GVariant (handle,
 * variant, tuple, dict entry) will be converted to a #GValue containing that
 * #GVariant.
 *
 * The conversion never fails - a valid #GValue is always returned in
 * @out_gvalue.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_dup_object: (rename-to g_dbus_interface_get_object)
 * @interface_: An exported D-Bus interface.
 *
 * Gets the #GDBusObject that @interface_ belongs to, if any.
 *
 * Returns: (nullable) (transfer full): A #GDBusObject or %NULL. The returned
 * reference should be freed with g_object_unref().
 * Since: 2.32
 */


/**
 * g_dbus_interface_get_info:
 * @interface_: An exported D-Bus interface.
 *
 * Gets D-Bus introspection information for the D-Bus interface
 * implemented by @interface_.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_interface_get_object: (skip)
 * @interface_: An exported D-Bus interface
 *
 * Gets the #GDBusObject that @interface_ belongs to, if any.
 *
 * It is not safe to use the returned object if @interface_ or
 * the returned object is being used from other threads. See
 * g_dbus_interface_dup_object() for a thread-safe alternative.
 *
 * Returns: (nullable) (transfer none): A #GDBusObject or %NULL. The returned
 *     reference belongs to @interface_ and should not be freed.
 * Since: 2.30
 */


/**
 * g_dbus_interface_info_cache_build:
 * @info: A #GDBusInterfaceInfo.
 *
 * Builds a lookup-cache to speed up
 * g_dbus_interface_info_lookup_method(),
 * g_dbus_interface_info_lookup_signal() and
 * g_dbus_interface_info_lookup_property().
 *
 * If this has already been called with @info, the existing cache is
 * used and its use count is increased.
 *
 * Note that @info cannot be modified until
 * g_dbus_interface_info_cache_release() is called.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_info_cache_release:
 * @info: A GDBusInterfaceInfo
 *
 * Decrements the usage count for the cache for @info built by
 * g_dbus_interface_info_cache_build() (if any) and frees the
 * resources used by the cache if the usage count drops to zero.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_info_generate_xml:
 * @info: A #GDBusNodeInfo
 * @indent: Indentation level.
 * @string_builder: A #GString to to append XML data to.
 *
 * Appends an XML representation of @info (and its children) to @string_builder.
 *
 * This function is typically used for generating introspection XML
 * documents at run-time for handling the
 * `org.freedesktop.DBus.Introspectable.Introspect`
 * method.
 *
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_lookup_method:
 * @info: A #GDBusInterfaceInfo.
 * @name: A D-Bus method name (typically in CamelCase)
 *
 * Looks up information about a method.
 *
 * The cost of this function is O(n) in number of methods unless
 * g_dbus_interface_info_cache_build() has been used on @info.
 *
 * Returns: (nullable) (transfer none): A #GDBusMethodInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_lookup_property:
 * @info: A #GDBusInterfaceInfo.
 * @name: A D-Bus property name (typically in CamelCase).
 *
 * Looks up information about a property.
 *
 * The cost of this function is O(n) in number of properties unless
 * g_dbus_interface_info_cache_build() has been used on @info.
 *
 * Returns: (nullable) (transfer none): A #GDBusPropertyInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_lookup_signal:
 * @info: A #GDBusInterfaceInfo.
 * @name: A D-Bus signal name (typically in CamelCase)
 *
 * Looks up information about a signal.
 *
 * The cost of this function is O(n) in number of signals unless
 * g_dbus_interface_info_cache_build() has been used on @info.
 *
 * Returns: (nullable) (transfer none): A #GDBusSignalInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_ref:
 * @info: A #GDBusInterfaceInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_unref:
 * @info: A #GDBusInterfaceInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_interface_set_object:
 * @interface_: An exported D-Bus interface.
 * @object: (nullable): A #GDBusObject or %NULL.
 *
 * Sets the #GDBusObject for @interface_ to @object.
 *
 * Note that @interface_ will hold a weak reference to @object.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_export:
 * @interface_: The D-Bus interface to export.
 * @connection: A #GDBusConnection to export @interface_ on.
 * @object_path: The path to export the interface at.
 * @error: Return location for error or %NULL.
 *
 * Exports @interface_ at @object_path on @connection.
 *
 * This can be called multiple times to export the same @interface_
 * onto multiple connections however the @object_path provided must be
 * the same for all connections.
 *
 * Use g_dbus_interface_skeleton_unexport() to unexport the object.
 *
 * Returns: %TRUE if the interface was exported on @connection, otherwise %FALSE with
 * @error set.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_flush:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * If @interface_ has outstanding changes, request for these changes to be
 * emitted immediately.
 *
 * For example, an exported D-Bus interface may queue up property
 * changes and emit the
 * `org.freedesktop.DBus.Properties.PropertiesChanged`
 * signal later (e.g. in an idle handler). This technique is useful
 * for collapsing multiple property changes into one.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_connection:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the first connection that @interface_ is exported on, if any.
 *
 * Returns: (nullable) (transfer none): A #GDBusConnection or %NULL if @interface_ is
 * not exported anywhere. Do not free, the object belongs to @interface_.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_connections:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets a list of the connections that @interface_ is exported on.
 *
 * Returns: (element-type GDBusConnection) (transfer full): A list of
 *   all the connections that @interface_ is exported on. The returned
 *   list should be freed with g_list_free() after each element has
 *   been freed with g_object_unref().
 * Since: 2.32
 */


/**
 * g_dbus_interface_skeleton_get_flags:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the #GDBusInterfaceSkeletonFlags that describes what the behavior
 * of @interface_
 *
 * Returns: One or more flags from the #GDBusInterfaceSkeletonFlags enumeration.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_info:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets D-Bus introspection information for the D-Bus interface
 * implemented by @interface_.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo (never %NULL). Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_object_path:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the object path that @interface_ is exported on, if any.
 *
 * Returns: (nullable): A string owned by @interface_ or %NULL if @interface_ is not exported
 * anywhere. Do not free, the string belongs to @interface_.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_properties:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets all D-Bus properties for @interface_.
 *
 * Returns: (transfer full): A #GVariant of type
 * ['a{sv}'][G-VARIANT-TYPE-VARDICT:CAPS].
 * Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_vtable:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the interface vtable for the D-Bus interface implemented by
 * @interface_. The returned function pointers should expect @interface_
 * itself to be passed as @user_data.
 *
 * Returns: (not nullable) (transfer none): the vtable of the D-Bus interface implemented by the skeleton
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_has_connection:
 * @interface_: A #GDBusInterfaceSkeleton.
 * @connection: A #GDBusConnection.
 *
 * Checks if @interface_ is exported on @connection.
 *
 * Returns: %TRUE if @interface_ is exported on @connection, %FALSE otherwise.
 * Since: 2.32
 */


/**
 * g_dbus_interface_skeleton_set_flags:
 * @interface_: A #GDBusInterfaceSkeleton.
 * @flags: Flags from the #GDBusInterfaceSkeletonFlags enumeration.
 *
 * Sets flags describing what the behavior of @skeleton should be.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_unexport:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Stops exporting @interface_ on all connections it is exported on.
 *
 * To unexport @interface_ from only a single connection, use
 * g_dbus_interface_skeleton_unexport_from_connection()
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_unexport_from_connection:
 * @interface_: A #GDBusInterfaceSkeleton.
 * @connection: A #GDBusConnection.
 *
 * Stops exporting @interface_ on @connection.
 *
 * To stop exporting on all connections the interface is exported on,
 * use g_dbus_interface_skeleton_unexport().
 *
 * Since: 2.32
 */


/**
 * g_dbus_is_address:
 * @string: A string.
 *
 * Checks if @string is a
 * [D-Bus address](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * This doesn't check if @string is actually supported by #GDBusServer
 * or #GDBusConnection - use g_dbus_is_supported_address() to do more
 * checks.
 *
 * Returns: %TRUE if @string is a valid D-Bus address, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_error_name:
 * @string: The string to check.
 *
 * Check whether @string is a valid D-Bus error name.
 *
 * This function returns the same result as g_dbus_is_interface_name(),
 * because D-Bus error names are defined to have exactly the
 * same syntax as interface names.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.70
 */


/**
 * g_dbus_is_guid:
 * @string: The string to check.
 *
 * Checks if @string is a D-Bus GUID.
 *
 * See the documentation for g_dbus_generate_guid() for more information about
 * the format of a GUID.
 *
 * Returns: %TRUE if @string is a GUID, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_interface_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus interface name.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_member_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus member (e.g. signal or method) name.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus bus name (either unique or well-known).
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_supported_address:
 * @string: A string.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_is_address() but also checks if the library supports the
 * transports in @string and that key/value pairs for each transport
 * are valid. See the specification of the
 * [D-Bus address format](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses).
 *
 * Returns: %TRUE if @string is a valid D-Bus address that is
 * supported by this library, %FALSE if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_is_unique_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus unique bus name.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_menu_model_get:
 * @connection: a #GDBusConnection
 * @bus_name: (nullable): the bus name which exports the menu model
 *     or %NULL if @connection is not a message bus connection
 * @object_path: the object path at which the menu model is exported
 *
 * Obtains a #GDBusMenuModel for the menu model which is exported
 * at the given @bus_name and @object_path.
 *
 * The thread default main context is taken at the time of this call.
 * All signals on the menu model (and any linked models) are reported
 * with respect to this context.  All calls on the returned menu model
 * (and linked models) must also originate from this same context, with
 * the thread default main context unchanged.
 *
 * Returns: (transfer full): a #GDBusMenuModel object. Free with
 *     g_object_unref().
 * Since: 2.32
 */


/**
 * g_dbus_message_bytes_needed:
 * @blob: (array length=blob_len) (element-type guint8): A blob representing a binary D-Bus message.
 * @blob_len: The length of @blob (must be at least 16).
 * @error: Return location for error or %NULL.
 *
 * Utility function to calculate how many bytes are needed to
 * completely deserialize the D-Bus message stored at @blob.
 *
 * Returns: Number of bytes needed or -1 if @error is set (e.g. if
 * @blob contains invalid data or not enough data is available to
 * determine the size).
 * Since: 2.26
 */


/**
 * g_dbus_message_copy:
 * @message: A #GDBusMessage.
 * @error: Return location for error or %NULL.
 *
 * Copies @message. The copy is a deep copy and the returned
 * #GDBusMessage is completely identical except that it is guaranteed
 * to not be locked.
 *
 * This operation can fail if e.g. @message contains file descriptors
 * and the per-process or system-wide open files limit is reached.
 *
 * Returns: (transfer full): A new #GDBusMessage or %NULL if @error is set.
 *     Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_get_arg0:
 * @message: A #GDBusMessage.
 *
 * Convenience to get the first item in the body of @message.
 *
 * Returns: (nullable): The string item or %NULL if the first item in the body of
 * @message is not a string.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_body:
 * @message: A #GDBusMessage.
 *
 * Gets the body of a message.
 *
 * Returns: (nullable) (transfer none): A #GVariant or %NULL if the body is
 * empty. Do not free, it is owned by @message.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_byte_order:
 * @message: A #GDBusMessage.
 *
 * Gets the byte order of @message.
 *
 * Returns: The byte order.
 */


/**
 * g_dbus_message_get_destination:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
 *
 * Returns: (nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_error_name:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
 *
 * Returns: (nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_flags:
 * @message: A #GDBusMessage.
 *
 * Gets the flags for @message.
 *
 * Returns: Flags that are set (typically values from the #GDBusMessageFlags enumeration bitwise ORed together).
 * Since: 2.26
 */


/**
 * g_dbus_message_get_header:
 * @message: A #GDBusMessage.
 * @header_field: A 8-bit unsigned integer (typically a value from the #GDBusMessageHeaderField enumeration)
 *
 * Gets a header field on @message.
 *
 * The caller is responsible for checking the type of the returned #GVariant
 * matches what is expected.
 *
 * Returns: (transfer none) (nullable): A #GVariant with the value if the header was found, %NULL
 * otherwise. Do not free, it is owned by @message.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_header_fields:
 * @message: A #GDBusMessage.
 *
 * Gets an array of all header fields on @message that are set.
 *
 * Returns: (array zero-terminated=1): An array of header fields
 * terminated by %G_DBUS_MESSAGE_HEADER_FIELD_INVALID.  Each element
 * is a #guchar. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_message_get_interface:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
 *
 * Returns: (nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_locked:
 * @message: A #GDBusMessage.
 *
 * Checks whether @message is locked. To monitor changes to this
 * value, conncet to the #GObject::notify signal to listen for changes
 * on the #GDBusMessage:locked property.
 *
 * Returns: %TRUE if @message is locked, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_member:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
 *
 * Returns: (nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_message_type:
 * @message: A #GDBusMessage.
 *
 * Gets the type of @message.
 *
 * Returns: A 8-bit unsigned integer (typically a value from the #GDBusMessageType enumeration).
 * Since: 2.26
 */


/**
 * g_dbus_message_get_num_unix_fds:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_path:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_PATH header field.
 *
 * Returns: (nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_reply_serial:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_sender:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
 *
 * Returns: (nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_serial:
 * @message: A #GDBusMessage.
 *
 * Gets the serial for @message.
 *
 * Returns: A #guint32.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_signature:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
 *
 * This will always be non-%NULL, but may be an empty string.
 *
 * Returns: (not nullable): The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_unix_fd_list:
 * @message: A #GDBusMessage.
 *
 * Gets the UNIX file descriptors associated with @message, if any.
 *
 * This method is only available on UNIX.
 *
 * The file descriptors normally correspond to %G_VARIANT_TYPE_HANDLE
 * values in the body of the message. For example,
 * if g_variant_get_handle() returns 5, that is intended to be a reference
 * to the file descriptor that can be accessed by
 * `g_unix_fd_list_get (list, 5, ...)`.
 *
 * Returns: (nullable) (transfer none): A #GUnixFDList or %NULL if no file descriptors are
 * associated. Do not free, this object is owned by @message.
 * Since: 2.26
 */


/**
 * g_dbus_message_lock:
 * @message: A #GDBusMessage.
 *
 * If @message is locked, does nothing. Otherwise locks the message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_new:
 *
 * Creates a new empty #GDBusMessage.
 *
 * Returns: A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_from_blob:
 * @blob: (array length=blob_len) (element-type guint8): A blob representing a binary D-Bus message.
 * @blob_len: The length of @blob.
 * @capabilities: A #GDBusCapabilityFlags describing what protocol features are supported.
 * @error: Return location for error or %NULL.
 *
 * Creates a new #GDBusMessage from the data stored at @blob. The byte
 * order that the message was in can be retrieved using
 * g_dbus_message_get_byte_order().
 *
 * If the @blob cannot be parsed, contains invalid fields, or contains invalid
 * headers, %G_IO_ERROR_INVALID_ARGUMENT will be returned.
 *
 * Returns: A new #GDBusMessage or %NULL if @error is set. Free with
 * g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_call:
 * @name: (nullable): A valid D-Bus name or %NULL.
 * @path: A valid object path.
 * @interface_: (nullable): A valid D-Bus interface name or %NULL.
 * @method: A valid method name.
 *
 * Creates a new #GDBusMessage for a method call.
 *
 * Returns: A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_error:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to
 * create a reply message to.
 * @error_name: A valid D-Bus error name.
 * @error_message_format: The D-Bus error message in a printf() format.
 * @...: Arguments for @error_message_format.
 *
 * Creates a new #GDBusMessage that is an error reply to @method_call_message.
 *
 * Returns: (transfer full): A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_error_literal:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to
 * create a reply message to.
 * @error_name: A valid D-Bus error name.
 * @error_message: The D-Bus error message.
 *
 * Creates a new #GDBusMessage that is an error reply to @method_call_message.
 *
 * Returns: (transfer full): A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_error_valist:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to
 * create a reply message to.
 * @error_name: A valid D-Bus error name.
 * @error_message_format: The D-Bus error message in a printf() format.
 * @var_args: Arguments for @error_message_format.
 *
 * Like g_dbus_message_new_method_error() but intended for language bindings.
 *
 * Returns: (transfer full): A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_reply:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to
 * create a reply message to.
 *
 * Creates a new #GDBusMessage that is a reply to @method_call_message.
 *
 * Returns: (transfer full): #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_signal:
 * @path: A valid object path.
 * @interface_: A valid D-Bus interface name.
 * @signal: A valid signal name.
 *
 * Creates a new #GDBusMessage for a signal emission.
 *
 * Returns: A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_print: (type method-return)
 * @message: A #GDBusMessage.
 * @indent: Indentation level.
 *
 * Produces a human-readable multi-line description of @message.
 *
 * The contents of the description has no ABI guarantees, the contents
 * and formatting is subject to change at any time. Typical output
 * looks something like this:
 * |[
 * Flags:   none
 * Version: 0
 * Serial:  4
 * Headers:
 *   path -> objectpath '/org/gtk/GDBus/TestObject'
 *   interface -> 'org.gtk.GDBus.TestInterface'
 *   member -> 'GimmeStdout'
 *   destination -> ':1.146'
 * Body: ()
 * UNIX File Descriptors:
 *   (none)
 * ]|
 * or
 * |[
 * Flags:   no-reply-expected
 * Version: 0
 * Serial:  477
 * Headers:
 *   reply-serial -> uint32 4
 *   destination -> ':1.159'
 *   sender -> ':1.146'
 *   num-unix-fds -> uint32 1
 * Body: ()
 * UNIX File Descriptors:
 *   fd 12: dev=0:10,mode=020620,ino=5,uid=500,gid=5,rdev=136:2,size=0,atime=1273085037,mtime=1273085851,ctime=1272982635
 * ]|
 *
 * Returns: (not nullable): A string that should be freed with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_message_set_body:
 * @message: A #GDBusMessage.
 * @body: Either %NULL or a #GVariant that is a tuple.
 *
 * Sets the body @message. As a side-effect the
 * %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field is set to the
 * type string of @body (or cleared if @body is %NULL).
 *
 * If @body is floating, @message assumes ownership of @body.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_byte_order:
 * @message: A #GDBusMessage.
 * @byte_order: The byte order.
 *
 * Sets the byte order of @message.
 */


/**
 * g_dbus_message_set_destination:
 * @message: A #GDBusMessage.
 * @value: (nullable): The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_error_name:
 * @message: (nullable): A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_flags:
 * @message: A #GDBusMessage.
 * @flags: Flags for @message that are set (typically values from the #GDBusMessageFlags
 * enumeration bitwise ORed together).
 *
 * Sets the flags to set on @message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_header:
 * @message: A #GDBusMessage.
 * @header_field: A 8-bit unsigned integer (typically a value from the #GDBusMessageHeaderField enumeration)
 * @value: (nullable): A #GVariant to set the header field or %NULL to clear the header field.
 *
 * Sets a header field on @message.
 *
 * If @value is floating, @message assumes ownership of @value.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_interface:
 * @message: A #GDBusMessage.
 * @value: (nullable): The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_member:
 * @message: A #GDBusMessage.
 * @value: (nullable): The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_message_type:
 * @message: A #GDBusMessage.
 * @type: A 8-bit unsigned integer (typically a value from the #GDBusMessageType enumeration).
 *
 * Sets @message to be of @type.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_num_unix_fds:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_path:
 * @message: A #GDBusMessage.
 * @value: (nullable): The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_PATH header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_reply_serial:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_sender:
 * @message: A #GDBusMessage.
 * @value: (nullable): The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_serial:
 * @message: A #GDBusMessage.
 * @serial: A #guint32.
 *
 * Sets the serial for @message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_signature:
 * @message: A #GDBusMessage.
 * @value: (nullable): The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_unix_fd_list:
 * @message: A #GDBusMessage.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Sets the UNIX file descriptors associated with @message. As a
 * side-effect the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header
 * field is set to the number of fds in @fd_list (or cleared if
 * @fd_list is %NULL).
 *
 * This method is only available on UNIX.
 *
 * When designing D-Bus APIs that are intended to be interoperable,
 * please note that non-GDBus implementations of D-Bus can usually only
 * access file descriptors if they are referenced by a value of type
 * %G_VARIANT_TYPE_HANDLE in the body of the message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_to_blob:
 * @message: A #GDBusMessage.
 * @out_size: Return location for size of generated blob.
 * @capabilities: A #GDBusCapabilityFlags describing what protocol features are supported.
 * @error: Return location for error.
 *
 * Serializes @message to a blob. The byte order returned by
 * g_dbus_message_get_byte_order() will be used.
 *
 * Returns: (array length=out_size) (transfer full): A pointer to a
 * valid binary D-Bus message of @out_size bytes generated by @message
 * or %NULL if @error is set. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_message_to_gerror:
 * @message: A #GDBusMessage.
 * @error: The #GError to set.
 *
 * If @message is not of type %G_DBUS_MESSAGE_TYPE_ERROR does
 * nothing and returns %FALSE.
 *
 * Otherwise this method encodes the error in @message as a #GError
 * using g_dbus_error_set_dbus_error() using the information in the
 * %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field of @message as
 * well as the first string item in @message's body.
 *
 * Returns: %TRUE if @error was set, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_method_info_ref:
 * @info: A #GDBusMethodInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_method_info_unref:
 * @info: A #GDBusMethodInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_connection:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the #GDBusConnection the method was invoked on.
 *
 * Returns: (transfer none): A #GDBusConnection. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_interface_name:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the name of the D-Bus interface the method was invoked on.
 *
 * If this method call is a property Get, Set or GetAll call that has
 * been redirected to the method call handler then
 * "org.freedesktop.DBus.Properties" will be returned.  See
 * #GDBusInterfaceVTable for more information.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_message:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the #GDBusMessage for the method invocation. This is useful if
 * you need to use low-level protocol features, such as UNIX file
 * descriptor passing, that cannot be properly expressed in the
 * #GVariant API.
 *
 * See this [server][gdbus-server] and [client][gdbus-unix-fd-client]
 * for an example of how to use this low-level API to send and receive
 * UNIX file descriptors.
 *
 * Returns: (transfer none): #GDBusMessage. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_method_info:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets information about the method call, if any.
 *
 * If this method invocation is a property Get, Set or GetAll call that
 * has been redirected to the method call handler then %NULL will be
 * returned.  See g_dbus_method_invocation_get_property_info() and
 * #GDBusInterfaceVTable for more information.
 *
 * Returns: (nullable): A #GDBusMethodInfo or %NULL. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_method_name:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the name of the method that was invoked.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_object_path:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the object path the method was invoked on.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_parameters:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the parameters of the method invocation. If there are no input
 * parameters then this will return a GVariant with 0 children rather than NULL.
 *
 * Returns: (transfer none): A #GVariant tuple. Do not unref this because it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_property_info:
 * @invocation: A #GDBusMethodInvocation
 *
 * Gets information about the property that this method call is for, if
 * any.
 *
 * This will only be set in the case of an invocation in response to a
 * property Get or Set call that has been directed to the method call
 * handler for an object on account of its property_get() or
 * property_set() vtable pointers being unset.
 *
 * See #GDBusInterfaceVTable for more information.
 *
 * If the call was GetAll, %NULL will be returned.
 *
 * Returns: (nullable) (transfer none): a #GDBusPropertyInfo or %NULL
 * Since: 2.38
 */


/**
 * g_dbus_method_invocation_get_sender:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the bus name that invoked the method.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_user_data: (skip)
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the @user_data #gpointer passed to g_dbus_connection_register_object().
 *
 * Returns: A #gpointer.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_dbus_error:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @error_name: A valid D-Bus error name.
 * @error_message: A valid D-Bus error message.
 *
 * Finishes handling a D-Bus method call by returning an error.
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_error:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @domain: A #GQuark for the #GError error domain.
 * @code: The error code.
 * @format: printf()-style format.
 * @...: Parameters for @format.
 *
 * Finishes handling a D-Bus method call by returning an error.
 *
 * See g_dbus_error_encode_gerror() for details about what error name
 * will be returned on the wire. In a nutshell, if the given error is
 * registered using g_dbus_error_register_error() the name given
 * during registration is used. Otherwise, a name of the form
 * `org.gtk.GDBus.UnmappedGError.Quark...` is used. This provides
 * transparent mapping of #GError between applications using GDBus.
 *
 * If you are writing an application intended to be portable,
 * always register errors with g_dbus_error_register_error()
 * or use g_dbus_method_invocation_return_dbus_error().
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since 2.48, if the method call requested for a reply not to be sent
 * then this call will free @invocation but otherwise do nothing (as per
 * the recommendations of the D-Bus specification).
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_error_literal:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @domain: A #GQuark for the #GError error domain.
 * @code: The error code.
 * @message: The error message.
 *
 * Like g_dbus_method_invocation_return_error() but without printf()-style formatting.
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_error_valist:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @domain: A #GQuark for the #GError error domain.
 * @code: The error code.
 * @format: printf()-style format.
 * @var_args: #va_list of parameters for @format.
 *
 * Like g_dbus_method_invocation_return_error() but intended for
 * language bindings.
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_gerror:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @error: A #GError.
 *
 * Like g_dbus_method_invocation_return_error() but takes a #GError
 * instead of the error domain, error code and message.
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_value:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @parameters: (nullable): A #GVariant tuple with out parameters for the method or %NULL if not passing any parameters.
 *
 * Finishes handling a D-Bus method call by returning @parameters.
 * If the @parameters GVariant is floating, it is consumed.
 *
 * It is an error if @parameters is not of the right format: it must be a tuple
 * containing the out-parameters of the D-Bus method. Even if the method has a
 * single out-parameter, it must be contained in a tuple. If the method has no
 * out-parameters, @parameters may be %NULL or an empty tuple.
 *
 * |[<!-- language="C" -->
 * GDBusMethodInvocation *invocation = some_invocation;
 * g_autofree gchar *result_string = NULL;
 * g_autoptr (GError) error = NULL;
 *
 * result_string = calculate_result (&error);
 *
 * if (error != NULL)
 *   g_dbus_method_invocation_return_gerror (invocation, error);
 * else
 *   g_dbus_method_invocation_return_value (invocation,
 *                                          g_variant_new ("(s)", result_string));
 *
 * // Do not free @invocation here; returning a value does that
 * ]|
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since 2.48, if the method call requested for a reply not to be sent
 * then this call will sink @parameters and free @invocation, but
 * otherwise do nothing (as per the recommendations of the D-Bus
 * specification).
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_value_with_unix_fd_list:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @parameters: (nullable): A #GVariant tuple with out parameters for the method or %NULL if not passing any parameters.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Like g_dbus_method_invocation_return_value() but also takes a #GUnixFDList.
 *
 * This method is only available on UNIX.
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since: 2.30
 */


/**
 * g_dbus_method_invocation_take_error: (skip)
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @error: (transfer full): A #GError.
 *
 * Like g_dbus_method_invocation_return_gerror() but takes ownership
 * of @error so the caller does not need to free it.
 *
 * This method will take ownership of @invocation. See
 * #GDBusInterfaceVTable for more information about the ownership of
 * @invocation.
 *
 * Since: 2.30
 */


/**
 * g_dbus_node_info_generate_xml:
 * @info: A #GDBusNodeInfo.
 * @indent: Indentation level.
 * @string_builder: A #GString to to append XML data to.
 *
 * Appends an XML representation of @info (and its children) to @string_builder.
 *
 * This function is typically used for generating introspection XML documents at run-time for
 * handling the `org.freedesktop.DBus.Introspectable.Introspect`  method.
 *
 * Since: 2.26
 */


/**
 * g_dbus_node_info_lookup_interface:
 * @info: A #GDBusNodeInfo.
 * @name: A D-Bus interface name.
 *
 * Looks up information about an interface.
 *
 * The cost of this function is O(n) in number of interfaces.
 *
 * Returns: (nullable) (transfer none): A #GDBusInterfaceInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_node_info_new_for_xml:
 * @xml_data: Valid D-Bus introspection XML.
 * @error: Return location for error.
 *
 * Parses @xml_data and returns a #GDBusNodeInfo representing the data.
 *
 * The introspection XML must contain exactly one top-level
 * <node> element.
 *
 * Note that this routine is using a
 * [GMarkup][glib-Simple-XML-Subset-Parser.description]-based
 * parser that only accepts a subset of valid XML documents.
 *
 * Returns: A #GDBusNodeInfo structure or %NULL if @error is set. Free
 * with g_dbus_node_info_unref().
 * Since: 2.26
 */


/**
 * g_dbus_node_info_ref:
 * @info: A #GDBusNodeInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_node_info_unref:
 * @info: A #GDBusNodeInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_object_get_interface:
 * @object: A #GDBusObject.
 * @interface_name: A D-Bus interface name.
 *
 * Gets the D-Bus interface with name @interface_name associated with
 * @object, if any.
 *
 * Returns: (nullable) (transfer full): %NULL if not found, otherwise a
 *   #GDBusInterface that must be freed with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_get_interfaces:
 * @object: A #GDBusObject.
 *
 * Gets the D-Bus interfaces associated with @object.
 *
 * Returns: (element-type GDBusInterface) (transfer full): A list of #GDBusInterface instances.
 *   The returned list must be freed by g_list_free() after each element has been freed
 *   with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_get_object_path:
 * @object: A #GDBusObject.
 *
 * Gets the object path for @object.
 *
 * Returns: A string owned by @object. Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_connection:
 * @manager: A #GDBusObjectManagerClient
 *
 * Gets the #GDBusConnection used by @manager.
 *
 * Returns: (transfer none): A #GDBusConnection object. Do not free,
 *   the object belongs to @manager.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_flags:
 * @manager: A #GDBusObjectManagerClient
 *
 * Gets the flags that @manager was constructed with.
 *
 * Returns: Zero of more flags from the #GDBusObjectManagerClientFlags
 * enumeration.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_name:
 * @manager: A #GDBusObjectManagerClient
 *
 * Gets the name that @manager is for, or %NULL if not a message bus
 * connection.
 *
 * Returns: A unique or well-known name. Do not free, the string
 * belongs to @manager.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_name_owner:
 * @manager: A #GDBusObjectManagerClient.
 *
 * The unique name that owns the name that @manager is for or %NULL if
 * no-one currently owns that name. You can connect to the
 * #GObject::notify signal to track changes to the
 * #GDBusObjectManagerClient:name-owner property.
 *
 * Returns: (nullable): The name owner or %NULL if no name owner
 * exists. Free with g_free().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: (nullable): A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (nullable): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously creates a new #GDBusObjectManagerClient object.
 *
 * This is an asynchronous failable constructor. When the result is
 * ready, @callback will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from. You can
 * then call g_dbus_object_manager_client_new_finish() to get the result. See
 * g_dbus_object_manager_client_new_sync() for the synchronous version.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_object_manager_client_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_object_manager_client_new().
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 *   #GDBusObjectManagerClient object or %NULL if @error is set. Free
 *   with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: (nullable): A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (nullable): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Like g_dbus_object_manager_client_new() but takes a #GBusType instead of a
 * #GDBusConnection.
 *
 * This is an asynchronous failable constructor. When the result is
 * ready, @callback will be invoked in the
 * [thread-default main loop][g-main-context-push-thread-default]
 * of the thread you are calling this method from. You can
 * then call g_dbus_object_manager_client_new_for_bus_finish() to get the result. See
 * g_dbus_object_manager_client_new_for_bus_sync() for the synchronous version.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 *   #GDBusObjectManagerClient object or %NULL if @error is set. Free
 *   with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: (nullable): A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (nullable): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_object_manager_client_new_sync() but takes a #GBusType instead
 * of a #GDBusConnection.
 *
 * This is a synchronous failable constructor - the calling thread is
 * blocked until a reply is received. See g_dbus_object_manager_client_new_for_bus()
 * for the asynchronous version.
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 *   #GDBusObjectManagerClient object or %NULL if @error is set. Free
 *   with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): The owner of the control object (unique or well-known name), or %NULL when not using a message bus connection.
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: (nullable): A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (nullable): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL
 * @error: Return location for error or %NULL.
 *
 * Creates a new #GDBusObjectManagerClient object.
 *
 * This is a synchronous failable constructor - the calling thread is
 * blocked until a reply is received. See g_dbus_object_manager_client_new()
 * for the asynchronous version.
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 *   #GDBusObjectManagerClient object or %NULL if @error is set. Free
 *   with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_interface:
 * @manager: A #GDBusObjectManager.
 * @object_path: Object path to look up.
 * @interface_name: D-Bus interface name to look up.
 *
 * Gets the interface proxy for @interface_name at @object_path, if
 * any.
 *
 * Returns: (transfer full) (nullable): A #GDBusInterface instance or %NULL. Free
 *   with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_object:
 * @manager: A #GDBusObjectManager.
 * @object_path: Object path to look up.
 *
 * Gets the #GDBusObject at @object_path, if any.
 *
 * Returns: (transfer full) (nullable): A #GDBusObject or %NULL. Free with
 *   g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_object_path:
 * @manager: A #GDBusObjectManager.
 *
 * Gets the object path that @manager is for.
 *
 * Returns: A string owned by @manager. Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_objects:
 * @manager: A #GDBusObjectManager.
 *
 * Gets all #GDBusObject objects known to @manager.
 *
 * Returns: (transfer full) (element-type GDBusObject): A list of
 *   #GDBusObject objects. The returned list should be freed with
 *   g_list_free() after each element has been freed with
 *   g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_export:
 * @manager: A #GDBusObjectManagerServer.
 * @object: A #GDBusObjectSkeleton.
 *
 * Exports @object on @manager.
 *
 * If there is already a #GDBusObject exported at the object path,
 * then the old object is removed.
 *
 * The object path for @object must be in the hierarchy rooted by the
 * object path for @manager.
 *
 * Note that @manager will take a reference on @object for as long as
 * it is exported.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_export_uniquely:
 * @manager: A #GDBusObjectManagerServer.
 * @object: An object.
 *
 * Like g_dbus_object_manager_server_export() but appends a string of
 * the form _N (with N being a natural number) to @object's object path
 * if an object with the given path already exists. As such, the
 * #GDBusObjectProxy:g-object-path property of @object may be modified.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_get_connection:
 * @manager: A #GDBusObjectManagerServer
 *
 * Gets the #GDBusConnection used by @manager.
 *
 * Returns: (transfer full) (nullable): A #GDBusConnection object or %NULL if
 *   @manager isn't exported on a connection. The returned object should
 *   be freed with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_is_exported:
 * @manager: A #GDBusObjectManagerServer.
 * @object: An object.
 *
 * Returns whether @object is currently exported on @manager.
 *
 * Returns: %TRUE if @object is exported
 * Since: 2.34
 */


/**
 * g_dbus_object_manager_server_new:
 * @object_path: The object path to export the manager object at.
 *
 * Creates a new #GDBusObjectManagerServer object.
 *
 * The returned server isn't yet exported on any connection. To do so,
 * use g_dbus_object_manager_server_set_connection(). Normally you
 * want to export all of your objects before doing so to avoid
 * [InterfacesAdded](http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager)
 * signals being emitted.
 *
 * Returns: A #GDBusObjectManagerServer object. Free with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_set_connection:
 * @manager: A #GDBusObjectManagerServer.
 * @connection: (nullable): A #GDBusConnection or %NULL.
 *
 * Exports all objects managed by @manager on @connection. If
 * @connection is %NULL, stops exporting objects.
 */


/**
 * g_dbus_object_manager_server_unexport:
 * @manager: A #GDBusObjectManagerServer.
 * @object_path: An object path.
 *
 * If @manager has an object at @path, removes the object. Otherwise
 * does nothing.
 *
 * Note that @object_path must be in the hierarchy rooted by the
 * object path for @manager.
 *
 * Returns: %TRUE if object at @object_path was removed, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * g_dbus_object_proxy_get_connection:
 * @proxy: a #GDBusObjectProxy
 *
 * Gets the connection that @proxy is for.
 *
 * Returns: (transfer none): A #GDBusConnection. Do not free, the
 *   object is owned by @proxy.
 * Since: 2.30
 */


/**
 * g_dbus_object_proxy_new:
 * @connection: a #GDBusConnection
 * @object_path: the object path
 *
 * Creates a new #GDBusObjectProxy for the given connection and
 * object path.
 *
 * Returns: a new #GDBusObjectProxy
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_add_interface:
 * @object: A #GDBusObjectSkeleton.
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Adds @interface_ to @object.
 *
 * If @object already contains a #GDBusInterfaceSkeleton with the same
 * interface name, it is removed before @interface_ is added.
 *
 * Note that @object takes its own reference on @interface_ and holds
 * it until removed.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_flush:
 * @object: A #GDBusObjectSkeleton.
 *
 * This method simply calls g_dbus_interface_skeleton_flush() on all
 * interfaces belonging to @object. See that method for when flushing
 * is useful.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new #GDBusObjectSkeleton.
 *
 * Returns: A #GDBusObjectSkeleton. Free with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_remove_interface:
 * @object: A #GDBusObjectSkeleton.
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Removes @interface_ from @object.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_remove_interface_by_name:
 * @object: A #GDBusObjectSkeleton.
 * @interface_name: A D-Bus interface name.
 *
 * Removes the #GDBusInterface with @interface_name from @object.
 *
 * If no D-Bus interface of the given interface exists, this function
 * does nothing.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_set_object_path:
 * @object: A #GDBusObjectSkeleton.
 * @object_path: A valid D-Bus object path.
 *
 * Sets the object path for @object.
 *
 * Since: 2.30
 */


/**
 * g_dbus_property_info_ref:
 * @info: A #GDBusPropertyInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_property_info_unref:
 * @info: A #GDBusPropertyInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (nullable): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning
 *                "infinite") or -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: (nullable): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't
 * care about the result of the method invocation.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously invokes the @method_name method on @proxy.
 *
 * If @method_name contains any dots, then @name is split into interface and
 * method name parts. This allows using @proxy for invoking methods on
 * other interfaces.
 *
 * If the #GDBusConnection associated with @proxy is closed then
 * the operation will fail with %G_IO_ERROR_CLOSED. If
 * @cancellable is canceled, the operation will fail with
 * %G_IO_ERROR_CANCELLED. If @parameters contains a value not
 * compatible with the D-Bus protocol, the operation fails with
 * %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If the @parameters #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.:
 * |[<!-- language="C" -->
 *  g_dbus_proxy_call (proxy,
 *                     "TwoStrings",
 *                     g_variant_new ("(ss)",
 *                                    "Thing One",
 *                                    "Thing Two"),
 *                     G_DBUS_CALL_FLAGS_NONE,
 *                     -1,
 *                     NULL,
 *                     (GAsyncReadyCallback) two_strings_done,
 *                     &data);
 * ]|
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @method_name is referenced by it,
 * then the return value is checked against the return type.
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the
 * [thread-default main context][g-main-context-push-thread-default]
 * of the thread you are calling this method from.
 * You can then call g_dbus_proxy_call_finish() to get the result of
 * the operation. See g_dbus_proxy_call_sync() for the synchronous
 * version of this method.
 *
 * If @callback is %NULL then the D-Bus method call message will be sent with
 * the %G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED flag set.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call_finish:
 * @proxy: A #GDBusProxy.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_proxy_call().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_proxy_call().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * return values. Free with g_variant_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call_sync:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (nullable): A #GVariant tuple with parameters for the signal
 *              or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning
 *                "infinite") or -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the @method_name method on @proxy.
 *
 * If @method_name contains any dots, then @name is split into interface and
 * method name parts. This allows using @proxy for invoking methods on
 * other interfaces.
 *
 * If the #GDBusConnection associated with @proxy is disconnected then
 * the operation will fail with %G_IO_ERROR_CLOSED. If
 * @cancellable is canceled, the operation will fail with
 * %G_IO_ERROR_CANCELLED. If @parameters contains a value not
 * compatible with the D-Bus protocol, the operation fails with
 * %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If the @parameters #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.:
 * |[<!-- language="C" -->
 *  g_dbus_proxy_call_sync (proxy,
 *                          "TwoStrings",
 *                          g_variant_new ("(ss)",
 *                                         "Thing One",
 *                                         "Thing Two"),
 *                          G_DBUS_CALL_FLAGS_NONE,
 *                          -1,
 *                          NULL,
 *                          &error);
 * ]|
 *
 * The calling thread is blocked until a reply is received. See
 * g_dbus_proxy_call() for the asynchronous version of this
 * method.
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @method_name is referenced by it,
 * then the return value is checked against the return type.
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * return values. Free with g_variant_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call_with_unix_fd_list:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (nullable): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning
 *                "infinite") or -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: (nullable): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't
 * care about the result of the method invocation.
 * @user_data: The data to pass to @callback.
 *
 * Like g_dbus_proxy_call() but also takes a #GUnixFDList object.
 *
 * This method is only available on UNIX.
 *
 * Since: 2.30
 */


/**
 * g_dbus_proxy_call_with_unix_fd_list_finish:
 * @proxy: A #GDBusProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_proxy_call_with_unix_fd_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_proxy_call_with_unix_fd_list().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * return values. Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_proxy_call_with_unix_fd_list_sync:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (nullable): A #GVariant tuple with parameters for the signal
 *              or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning
 *                "infinite") or -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_call_sync() but also takes and returns #GUnixFDList objects.
 *
 * This method is only available on UNIX.
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * return values. Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_proxy_get_cached_property:
 * @proxy: A #GDBusProxy.
 * @property_name: Property name.
 *
 * Looks up the value for a property from the cache. This call does no
 * blocking IO.
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @property_name is referenced by
 * it, then @value is checked against the type of the property.
 *
 * Returns: (transfer full) (nullable): A reference to the #GVariant instance
 *    that holds the value for @property_name or %NULL if the value is not in
 *    the cache. The returned reference must be freed with g_variant_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_cached_property_names:
 * @proxy: A #GDBusProxy.
 *
 * Gets the names of all cached properties on @proxy.
 *
 * Returns: (transfer full) (nullable) (array zero-terminated=1): A
 *          %NULL-terminated array of strings or %NULL if
 *          @proxy has no cached properties. Free the returned array with
 *          g_strfreev().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_connection:
 * @proxy: A #GDBusProxy.
 *
 * Gets the connection @proxy is for.
 *
 * Returns: (transfer none) (not nullable): A #GDBusConnection owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_default_timeout:
 * @proxy: A #GDBusProxy.
 *
 * Gets the timeout to use if -1 (specifying default timeout) is
 * passed as @timeout_msec in the g_dbus_proxy_call() and
 * g_dbus_proxy_call_sync() functions.
 *
 * See the #GDBusProxy:g-default-timeout property for more details.
 *
 * Returns: Timeout to use for @proxy.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_flags:
 * @proxy: A #GDBusProxy.
 *
 * Gets the flags that @proxy was constructed with.
 *
 * Returns: Flags from the #GDBusProxyFlags enumeration.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_interface_info:
 * @proxy: A #GDBusProxy
 *
 * Returns the #GDBusInterfaceInfo, if any, specifying the interface
 * that @proxy conforms to. See the #GDBusProxy:g-interface-info
 * property for more details.
 *
 * Returns: (transfer none) (nullable): A #GDBusInterfaceInfo or %NULL.
 *    Do not unref the returned object, it is owned by @proxy.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_interface_name:
 * @proxy: A #GDBusProxy.
 *
 * Gets the D-Bus interface name @proxy is for.
 *
 * Returns: (not nullable): A string owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_name:
 * @proxy: A #GDBusProxy.
 *
 * Gets the name that @proxy was constructed for.
 *
 * When connected to a message bus, this will usually be non-%NULL.
 * However, it may be %NULL for a proxy that communicates using a peer-to-peer
 * pattern.
 *
 * Returns: (nullable): A string owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_name_owner:
 * @proxy: A #GDBusProxy.
 *
 * The unique name that owns the name that @proxy is for or %NULL if
 * no-one currently owns that name. You may connect to the
 * #GObject::notify signal to track changes to the
 * #GDBusProxy:g-name-owner property.
 *
 * Returns: (transfer full) (nullable): The name owner or %NULL if no name
 *    owner exists. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_object_path:
 * @proxy: A #GDBusProxy.
 *
 * Gets the object path @proxy is for.
 *
 * Returns: (not nullable): A string owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @info: (nullable): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Creates a proxy for accessing @interface_name on the remote object
 * at @object_path owned by @name at @connection and asynchronously
 * loads D-Bus properties unless the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used. Connect to
 * the #GDBusProxy::g-properties-changed signal to get notified about
 * property changes.
 *
 * If the %G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
 * match rules for signals. Connect to the #GDBusProxy::g-signal signal
 * to handle signals from the remote object.
 *
 * If both %G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES and
 * %G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS are set, this constructor is
 * guaranteed to complete immediately without blocking.
 *
 * If @name is a well-known name and the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START and %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START_AT_CONSTRUCTION
 * flags aren't set and no name owner currently exists, the message bus
 * will be requested to launch a name owner for the name.
 *
 * This is a failable asynchronous constructor - when the proxy is
 * ready, @callback will be invoked and you can use
 * g_dbus_proxy_new_finish() to get the result.
 *
 * See g_dbus_proxy_new_sync() and for a synchronous version of this constructor.
 *
 * #GDBusProxy is used in this [example][gdbus-wellknown-proxy].
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to g_dbus_proxy_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #GDBusProxy.
 *
 * Returns: (transfer full): A #GDBusProxy or %NULL if @error is set.
 *    Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @info: (nullable): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * #GDBusProxy is used in this [example][gdbus-wellknown-proxy].
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to g_dbus_proxy_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #GDBusProxy.
 *
 * Returns: (transfer full): A #GDBusProxy or %NULL if @error is set.
 *    Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @info: (nullable): A #GDBusInterfaceInfo specifying the minimal interface
 *        that @proxy conforms to or %NULL.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * #GDBusProxy is used in this [example][gdbus-wellknown-proxy].
 *
 * Returns: (transfer full): A #GDBusProxy or %NULL if error is set.
 *    Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @info: (nullable): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: (nullable): Return location for error or %NULL.
 *
 * Creates a proxy for accessing @interface_name on the remote object
 * at @object_path owned by @name at @connection and synchronously
 * loads D-Bus properties unless the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used.
 *
 * If the %G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
 * match rules for signals. Connect to the #GDBusProxy::g-signal signal
 * to handle signals from the remote object.
 *
 * If both %G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES and
 * %G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS are set, this constructor is
 * guaranteed to return immediately without blocking.
 *
 * If @name is a well-known name and the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START and %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START_AT_CONSTRUCTION
 * flags aren't set and no name owner currently exists, the message bus
 * will be requested to launch a name owner for the name.
 *
 * This is a synchronous failable constructor. See g_dbus_proxy_new()
 * and g_dbus_proxy_new_finish() for the asynchronous version.
 *
 * #GDBusProxy is used in this [example][gdbus-wellknown-proxy].
 *
 * Returns: (transfer full): A #GDBusProxy or %NULL if error is set.
 *    Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_set_cached_property:
 * @proxy: A #GDBusProxy
 * @property_name: Property name.
 * @value: (nullable): Value for the property or %NULL to remove it from the cache.
 *
 * If @value is not %NULL, sets the cached value for the property with
 * name @property_name to the value in @value.
 *
 * If @value is %NULL, then the cached value is removed from the
 * property cache.
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @property_name is referenced by
 * it, then @value is checked against the type of the property.
 *
 * If the @value #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.
 * |[<!-- language="C" -->
 *  g_dbus_proxy_set_cached_property (proxy,
 *                                    "SomeProperty",
 *                                    g_variant_new ("(si)",
 *                                                  "A String",
 *                                                  42));
 * ]|
 *
 * Normally you will not need to use this method since @proxy
 * is tracking changes using the
 * `org.freedesktop.DBus.Properties.PropertiesChanged`
 * D-Bus signal. However, for performance reasons an object may
 * decide to not use this signal for some properties and instead
 * use a proprietary out-of-band mechanism to transmit changes.
 *
 * As a concrete example, consider an object with a property
 * `ChatroomParticipants` which is an array of strings. Instead of
 * transmitting the same (long) array every time the property changes,
 * it is more efficient to only transmit the delta using e.g. signals
 * `ChatroomParticipantJoined(String name)` and
 * `ChatroomParticipantParted(String name)`.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_set_default_timeout:
 * @proxy: A #GDBusProxy.
 * @timeout_msec: Timeout in milliseconds.
 *
 * Sets the timeout to use if -1 (specifying default timeout) is
 * passed as @timeout_msec in the g_dbus_proxy_call() and
 * g_dbus_proxy_call_sync() functions.
 *
 * See the #GDBusProxy:g-default-timeout property for more details.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_set_interface_info:
 * @proxy: A #GDBusProxy
 * @info: (transfer none) (nullable): Minimum interface this proxy conforms to
 *    or %NULL to unset.
 *
 * Ensure that interactions with @proxy conform to the given
 * interface. See the #GDBusProxy:g-interface-info property for more
 * details.
 *
 * Since: 2.26
 */


/**
 * g_dbus_server_get_client_address:
 * @server: A #GDBusServer.
 *
 * Gets a
 * [D-Bus address](https://dbus.freedesktop.org/doc/dbus-specification.html#addresses)
 * string that can be used by clients to connect to @server.
 *
 * This is valid and non-empty if initializing the #GDBusServer succeeded.
 *
 * Returns: (not nullable): A D-Bus address string. Do not free, the string is owned
 * by @server.
 * Since: 2.26
 */


/**
 * g_dbus_server_get_flags:
 * @server: A #GDBusServer.
 *
 * Gets the flags for @server.
 *
 * Returns: A set of flags from the #GDBusServerFlags enumeration.
 * Since: 2.26
 */


/**
 * g_dbus_server_get_guid:
 * @server: A #GDBusServer.
 *
 * Gets the GUID for @server, as provided to g_dbus_server_new_sync().
 *
 * Returns: (not nullable): A D-Bus GUID. Do not free this string, it is owned by @server.
 * Since: 2.26
 */


/**
 * g_dbus_server_is_active:
 * @server: A #GDBusServer.
 *
 * Gets whether @server is active.
 *
 * Returns: %TRUE if server is active, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_server_new_sync:
 * @address: A D-Bus address.
 * @flags: Flags from the #GDBusServerFlags enumeration.
 * @guid: A D-Bus GUID.
 * @observer: (nullable): A #GDBusAuthObserver or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for server or %NULL.
 *
 * Creates a new D-Bus server that listens on the first address in
 * @address that works.
 *
 * Once constructed, you can use g_dbus_server_get_client_address() to
 * get a D-Bus address string that clients can use to connect.
 *
 * To have control over the available authentication mechanisms and
 * the users that are authorized to connect, it is strongly recommended
 * to provide a non-%NULL #GDBusAuthObserver.
 *
 * Connect to the #GDBusServer::new-connection signal to handle
 * incoming connections.
 *
 * The returned #GDBusServer isn't active - you have to start it with
 * g_dbus_server_start().
 *
 * #GDBusServer is used in this [example][gdbus-peer-to-peer].
 *
 * This is a synchronous failable constructor. There is currently no
 * asynchronous version.
 *
 * Returns: A #GDBusServer or %NULL if @error is set. Free with
 * g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_server_start:
 * @server: A #GDBusServer.
 *
 * Starts @server.
 *
 * Since: 2.26
 */


/**
 * g_dbus_server_stop:
 * @server: A #GDBusServer.
 *
 * Stops @server.
 *
 * Since: 2.26
 */


/**
 * g_dbus_signal_info_ref:
 * @info: A #GDBusSignalInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: (not nullable): The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_signal_info_unref:
 * @info: A #GDBusSignalInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_unescape_object_path:
 * @s: the string to unescape
 *
 * Unescapes an string that was previously escaped with
 * g_dbus_escape_object_path(). If the string is in a format that could
 * not have been returned by g_dbus_escape_object_path(), this function
 * returns %NULL.
 *
 * Encoding alphanumeric characters which do not need to be
 * encoded is not allowed (e.g `_63` is not valid, the string
 * should contain `c` instead).
 *
 * Returns: (array zero-terminated=1) (element-type guint8) (nullable): an
 *   unescaped version of @s, or %NULL if @s is not a string returned
 *   from g_dbus_escape_object_path(). Free with g_free().
 * Since: 2.68
 */


/**
 * g_debug_controller_dbus_new:
 * @connection: a #GDBusConnection to register the debug object on
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @error: return location for a #GError, or %NULL
 *
 * Create a new #GDebugControllerDBus and synchronously initialize it.
 *
 * Initializing the object will export the debug object on @connection. The
 * object will remain registered until the last reference to the
 * #GDebugControllerDBus is dropped.
 *
 * Initialization may fail if registering the object on @connection fails.
 *
 * Returns: (nullable) (transfer full): a new #GDebugControllerDBus, or %NULL
 *   on failure
 * Since: 2.72
 */


/**
 * g_debug_controller_dbus_stop:
 * @self: a #GDebugControllerDBus
 *
 * Stop the debug controller, unregistering its object from the bus.
 *
 * Any pending method calls to the object will complete successfully, but new
 * ones will return an error. This method will block until all pending
 * #GDebugControllerDBus::authorize signals have been handled. This is expected
 * to not take long, as it will just be waiting for threads to join. If any
 * #GDebugControllerDBus::authorize signal handlers are still executing in other
 * threads, this will block until after they have returned.
 *
 * This method will be called automatically when the final reference to the
 * #GDebugControllerDBus is dropped. You may want to call it explicitly to know
 * when the controller has been fully removed from the bus, or to break
 * reference count cycles.
 *
 * Calling this method from within a #GDebugControllerDBus::authorize signal
 * handler will cause a deadlock and must not be done.
 *
 * Since: 2.72
 */


/**
 * g_debug_controller_get_debug_enabled:
 * @self: a #GDebugController
 *
 * Get the value of #GDebugController:debug-enabled.
 *
 * Returns: %TRUE if debug output should be exposed, %FALSE otherwise
 * Since: 2.72
 */


/**
 * g_debug_controller_set_debug_enabled:
 * @self: a #GDebugController
 * @debug_enabled: %TRUE if debug output should be exposed, %FALSE otherwise
 *
 * Set the value of #GDebugController:debug-enabled.
 *
 * Since: 2.72
 */


/**
 * g_desktop_app_info_get_action_name:
 * @info: a #GDesktopAppInfo
 * @action_name: the name of the action as from
 *   g_desktop_app_info_list_actions()
 *
 * Gets the user-visible display name of the "additional application
 * action" specified by @action_name.
 *
 * This corresponds to the "Name" key within the keyfile group for the
 * action.
 *
 * Returns: (transfer full): the locale-specific action name
 * Since: 2.38
 */


/**
 * g_desktop_app_info_get_boolean:
 * @info: a #GDesktopAppInfo
 * @key: the key to look up
 *
 * Looks up a boolean value in the keyfile backing @info.
 *
 * The @key is looked up in the "Desktop Entry" group.
 *
 * Returns: the boolean value, or %FALSE if the key
 *     is not found
 * Since: 2.36
 */


/**
 * g_desktop_app_info_get_categories:
 * @info: a #GDesktopAppInfo
 *
 * Gets the categories from the desktop file.
 *
 * Returns: (nullable): The unparsed Categories key from the desktop file;
 *     i.e. no attempt is made to split it by ';' or validate it.
 */


/**
 * g_desktop_app_info_get_filename:
 * @info: a #GDesktopAppInfo
 *
 * When @info was created from a known filename, return it.  In some
 * situations such as the #GDesktopAppInfo returned from
 * g_desktop_app_info_new_from_keyfile(), this function will return %NULL.
 *
 * Returns: (nullable) (type filename): The full path to the file for @info,
 *     or %NULL if not known.
 * Since: 2.24
 */


/**
 * g_desktop_app_info_get_generic_name:
 * @info: a #GDesktopAppInfo
 *
 * Gets the generic name from the desktop file.
 *
 * Returns: (nullable): The value of the GenericName key
 */


/**
 * g_desktop_app_info_get_implementations:
 * @interface: the name of the interface
 *
 * Gets all applications that implement @interface.
 *
 * An application implements an interface if that interface is listed in
 * the Implements= line of the desktop file of the application.
 *
 * Returns: (element-type GDesktopAppInfo) (transfer full): a list of #GDesktopAppInfo
 * objects.
 * Since: 2.42
 */


/**
 * g_desktop_app_info_get_is_hidden:
 * @info: a #GDesktopAppInfo.
 *
 * A desktop file is hidden if the Hidden key in it is
 * set to True.
 *
 * Returns: %TRUE if hidden, %FALSE otherwise.
 */


/**
 * g_desktop_app_info_get_keywords:
 * @info: a #GDesktopAppInfo
 *
 * Gets the keywords from the desktop file.
 *
 * Returns: (transfer none): The value of the Keywords key
 * Since: 2.32
 */


/**
 * g_desktop_app_info_get_locale_string:
 * @info: a #GDesktopAppInfo
 * @key: the key to look up
 *
 * Looks up a localized string value in the keyfile backing @info
 * translated to the current locale.
 *
 * The @key is looked up in the "Desktop Entry" group.
 *
 * Returns: (nullable): a newly allocated string, or %NULL if the key
 *     is not found
 * Since: 2.56
 */


/**
 * g_desktop_app_info_get_nodisplay:
 * @info: a #GDesktopAppInfo
 *
 * Gets the value of the NoDisplay key, which helps determine if the
 * application info should be shown in menus. See
 * %G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY and g_app_info_should_show().
 *
 * Returns: The value of the NoDisplay key
 * Since: 2.30
 */


/**
 * g_desktop_app_info_get_show_in:
 * @info: a #GDesktopAppInfo
 * @desktop_env: (nullable): a string specifying a desktop name
 *
 * Checks if the application info should be shown in menus that list available
 * applications for a specific name of the desktop, based on the
 * `OnlyShowIn` and `NotShowIn` keys.
 *
 * @desktop_env should typically be given as %NULL, in which case the
 * `XDG_CURRENT_DESKTOP` environment variable is consulted.  If you want
 * to override the default mechanism then you may specify @desktop_env,
 * but this is not recommended.
 *
 * Note that g_app_info_should_show() for @info will include this check (with
 * %NULL for @desktop_env) as well as additional checks.
 *
 * Returns: %TRUE if the @info should be shown in @desktop_env according to the
 * `OnlyShowIn` and `NotShowIn` keys, %FALSE
 * otherwise.
 * Since: 2.30
 */


/**
 * g_desktop_app_info_get_startup_wm_class:
 * @info: a #GDesktopAppInfo that supports startup notify
 *
 * Retrieves the StartupWMClass field from @info. This represents the
 * WM_CLASS property of the main window of the application, if launched
 * through @info.
 *
 * Returns: (nullable) (transfer none): the startup WM class, or %NULL if none is set
 * in the desktop file.
 * Since: 2.34
 */


/**
 * g_desktop_app_info_get_string:
 * @info: a #GDesktopAppInfo
 * @key: the key to look up
 *
 * Looks up a string value in the keyfile backing @info.
 *
 * The @key is looked up in the "Desktop Entry" group.
 *
 * Returns: (nullable): a newly allocated string, or %NULL if the key
 *     is not found
 * Since: 2.36
 */


/**
 * g_desktop_app_info_get_string_list:
 * @info: a #GDesktopAppInfo
 * @key: the key to look up
 * @length: (out) (optional): return location for the number of returned strings, or %NULL
 *
 * Looks up a string list value in the keyfile backing @info.
 *
 * The @key is looked up in the "Desktop Entry" group.
 *
 * Returns: (array zero-terminated=1 length=length) (element-type utf8) (transfer full):
 *  a %NULL-terminated string array or %NULL if the specified
 *  key cannot be found. The array should be freed with g_strfreev().
 * Since: 2.60
 */


/**
 * g_desktop_app_info_has_key:
 * @info: a #GDesktopAppInfo
 * @key: the key to look up
 *
 * Returns whether @key exists in the "Desktop Entry" group
 * of the keyfile backing @info.
 *
 * Returns: %TRUE if the @key exists
 * Since: 2.36
 */


/**
 * g_desktop_app_info_launch_action:
 * @info: a #GDesktopAppInfo
 * @action_name: the name of the action as from
 *   g_desktop_app_info_list_actions()
 * @launch_context: (nullable): a #GAppLaunchContext
 *
 * Activates the named application action.
 *
 * You may only call this function on action names that were
 * returned from g_desktop_app_info_list_actions().
 *
 * Note that if the main entry of the desktop file indicates that the
 * application supports startup notification, and @launch_context is
 * non-%NULL, then startup notification will be used when activating the
 * action (and as such, invocation of the action on the receiving side
 * must signal the end of startup notification when it is completed).
 * This is the expected behaviour of applications declaring additional
 * actions, as per the desktop file specification.
 *
 * As with g_app_info_launch() there is no way to detect failures that
 * occur while using this function.
 *
 * Since: 2.38
 */


/**
 * g_desktop_app_info_launch_uris_as_manager:
 * @appinfo: a #GDesktopAppInfo
 * @uris: (element-type utf8): List of URIs
 * @launch_context: (nullable): a #GAppLaunchContext
 * @spawn_flags: #GSpawnFlags, used for each process
 * @user_setup: (scope async) (nullable): a #GSpawnChildSetupFunc, used once
 *     for each process.
 * @user_setup_data: (closure user_setup) (nullable): User data for @user_setup
 * @pid_callback: (scope call) (nullable): Callback for child processes
 * @pid_callback_data: (closure pid_callback) (nullable): User data for @callback
 * @error: return location for a #GError, or %NULL
 *
 * This function performs the equivalent of g_app_info_launch_uris(),
 * but is intended primarily for operating system components that
 * launch applications.  Ordinary applications should use
 * g_app_info_launch_uris().
 *
 * If the application is launched via GSpawn, then @spawn_flags, @user_setup
 * and @user_setup_data are used for the call to g_spawn_async().
 * Additionally, @pid_callback (with @pid_callback_data) will be called to
 * inform about the PID of the created process. See g_spawn_async_with_pipes()
 * for information on certain parameter conditions that can enable an
 * optimized posix_spawn() codepath to be used.
 *
 * If application launching occurs via some other mechanism (eg: D-Bus
 * activation) then @spawn_flags, @user_setup, @user_setup_data,
 * @pid_callback and @pid_callback_data are ignored.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 */


/**
 * g_desktop_app_info_launch_uris_as_manager_with_fds:
 * @appinfo: a #GDesktopAppInfo
 * @uris: (element-type utf8): List of URIs
 * @launch_context: (nullable): a #GAppLaunchContext
 * @spawn_flags: #GSpawnFlags, used for each process
 * @user_setup: (scope async) (nullable) (closure user_setup_data): a #GSpawnChildSetupFunc, used once
 *     for each process.
 * @user_setup_data: User data for @user_setup
 * @pid_callback: (scope call) (nullable) (closure pid_callback_data): Callback for child processes
 * @pid_callback_data: User data for @callback
 * @stdin_fd: file descriptor to use for child's stdin, or -1
 * @stdout_fd: file descriptor to use for child's stdout, or -1
 * @stderr_fd: file descriptor to use for child's stderr, or -1
 * @error: return location for a #GError, or %NULL
 *
 * Equivalent to g_desktop_app_info_launch_uris_as_manager() but allows
 * you to pass in file descriptors for the stdin, stdout and stderr streams
 * of the launched process.
 *
 * If application launching occurs via some non-spawn mechanism (e.g. D-Bus
 * activation) then @stdin_fd, @stdout_fd and @stderr_fd are ignored.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 * Since: 2.58
 */


/**
 * g_desktop_app_info_list_actions:
 * @info: a #GDesktopAppInfo
 *
 * Returns the list of "additional application actions" supported on the
 * desktop file, as per the desktop file specification.
 *
 * As per the specification, this is the list of actions that are
 * explicitly listed in the "Actions" key of the [Desktop Entry] group.
 *
 * Returns: (array zero-terminated=1) (element-type utf8) (transfer none): a list of strings, always non-%NULL
 * Since: 2.38
 */


/**
 * g_desktop_app_info_lookup_get_default_for_uri_scheme:
 * @lookup: a #GDesktopAppInfoLookup
 * @uri_scheme: a string containing a URI scheme.
 *
 * Gets the default application for launching applications
 * using this URI scheme for a particular #GDesktopAppInfoLookup
 * implementation.
 *
 * The #GDesktopAppInfoLookup interface and this function is used
 * to implement g_app_info_get_default_for_uri_scheme() backends
 * in a GIO module. There is no reason for applications to use it
 * directly. Applications should use g_app_info_get_default_for_uri_scheme().
 *
 * Returns: (transfer full) (nullable): #GAppInfo for given @uri_scheme or
 *    %NULL on error.
 * Deprecated: 2.28: The #GDesktopAppInfoLookup interface is deprecated and
 *    unused by GIO.
 */


/**
 * g_desktop_app_info_new:
 * @desktop_id: the desktop file id
 *
 * Creates a new #GDesktopAppInfo based on a desktop file id.
 *
 * A desktop file id is the basename of the desktop file, including the
 * .desktop extension. GIO is looking for a desktop file with this name
 * in the `applications` subdirectories of the XDG
 * data directories (i.e. the directories specified in the `XDG_DATA_HOME`
 * and `XDG_DATA_DIRS` environment variables). GIO also supports the
 * prefix-to-subdirectory mapping that is described in the
 * [Menu Spec](http://standards.freedesktop.org/menu-spec/latest/)
 * (i.e. a desktop id of kde-foo.desktop will match
 * `/usr/share/applications/kde/foo.desktop`).
 *
 * Returns: (nullable): a new #GDesktopAppInfo, or %NULL if no desktop
 *     file with that id exists.
 */


/**
 * g_desktop_app_info_new_from_filename:
 * @filename: (type filename): the path of a desktop file, in the GLib
 *      filename encoding
 *
 * Creates a new #GDesktopAppInfo.
 *
 * Returns: (nullable): a new #GDesktopAppInfo or %NULL on error.
 */


/**
 * g_desktop_app_info_new_from_keyfile:
 * @key_file: an opened #GKeyFile
 *
 * Creates a new #GDesktopAppInfo.
 *
 * Returns: (nullable): a new #GDesktopAppInfo or %NULL on error.
 * Since: 2.18
 */


/**
 * g_desktop_app_info_search:
 * @search_string: the search string to use
 *
 * Searches desktop files for ones that match @search_string.
 *
 * The return value is an array of strvs.  Each strv contains a list of
 * applications that matched @search_string with an equal score.  The
 * outer list is sorted by score so that the first strv contains the
 * best-matching applications, and so on.
 * The algorithm for determining matches is undefined and may change at
 * any time.
 *
 * None of the search results are subjected to the normal validation
 * checks performed by g_desktop_app_info_new() (for example, checking that
 * the executable referenced by a result exists), and so it is possible for
 * g_desktop_app_info_new() to return %NULL when passed an app ID returned by
 * this function. It is expected that calling code will do this when
 * subsequently creating a #GDesktopAppInfo for each result.
 *
 * Returns: (array zero-terminated=1) (element-type GStrv) (transfer full): a
 *   list of strvs.  Free each item with g_strfreev() and free the outer
 *   list with g_free().
 */


/**
 * g_desktop_app_info_set_desktop_env:
 * @desktop_env: a string specifying what desktop this is
 *
 * Sets the name of the desktop that the application is running in.
 * This is used by g_app_info_should_show() and
 * g_desktop_app_info_get_show_in() to evaluate the
 * `OnlyShowIn` and `NotShowIn`
 * desktop entry fields.
 *
 * Should be called only once; subsequent calls are ignored.
 *
 * Deprecated: 2.42: do not use this API.  Since 2.42 the value of the
 * `XDG_CURRENT_DESKTOP` environment variable will be used.
 */


/**
 * g_drive_can_eject:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be ejected.
 *
 * Returns: %TRUE if the @drive can be ejected, %FALSE otherwise.
 */


/**
 * g_drive_can_poll_for_media:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be polled for media changes.
 *
 * Returns: %TRUE if the @drive can be polled for media changes,
 *     %FALSE otherwise.
 */


/**
 * g_drive_can_start:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be started.
 *
 * Returns: %TRUE if the @drive can be started, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_can_start_degraded:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be started degraded.
 *
 * Returns: %TRUE if the @drive can be started degraded, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_can_stop:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be stopped.
 *
 * Returns: %TRUE if the @drive can be stopped, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_eject:
 * @drive: a #GDrive.
 * @flags: flags affecting the unmount if required for eject
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously ejects a drive.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_eject_finish() to obtain the
 * result of the operation.
 *
 * Deprecated: 2.22: Use g_drive_eject_with_operation() instead.
 */


/**
 * g_drive_eject_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes ejecting a drive.
 *
 * Returns: %TRUE if the drive has been ejected successfully,
 *     %FALSE otherwise.
 * Deprecated: 2.22: Use g_drive_eject_with_operation_finish() instead.
 */


/**
 * g_drive_eject_with_operation:
 * @drive: a #GDrive.
 * @flags: flags affecting the unmount if required for eject
 * @mount_operation: (nullable): a #GMountOperation or %NULL to avoid
 *     user interaction.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Ejects a drive. This is an asynchronous operation, and is
 * finished by calling g_drive_eject_with_operation_finish() with the @drive
 * and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.22
 */


/**
 * g_drive_eject_with_operation_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Finishes ejecting a drive. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the drive was successfully ejected. %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_enumerate_identifiers:
 * @drive: a #GDrive
 *
 * Gets the kinds of identifiers that @drive has.
 * Use g_drive_get_identifier() to obtain the identifiers
 * themselves.
 *
 * Returns: (transfer full) (array zero-terminated=1): a %NULL-terminated
 *     array of strings containing kinds of identifiers. Use g_strfreev()
 *     to free.
 */


/**
 * g_drive_get_icon:
 * @drive: a #GDrive.
 *
 * Gets the icon for @drive.
 *
 * Returns: (transfer full): #GIcon for the @drive.
 *    Free the returned object with g_object_unref().
 */


/**
 * g_drive_get_identifier:
 * @drive: a #GDrive
 * @kind: the kind of identifier to return
 *
 * Gets the identifier of the given kind for @drive. The only
 * identifier currently available is
 * %G_DRIVE_IDENTIFIER_KIND_UNIX_DEVICE.
 *
 * Returns: (nullable) (transfer full): a newly allocated string containing the
 *     requested identifier, or %NULL if the #GDrive
 *     doesn't have this kind of identifier.
 */


/**
 * g_drive_get_name:
 * @drive: a #GDrive.
 *
 * Gets the name of @drive.
 *
 * Returns: a string containing @drive's name. The returned
 *     string should be freed when no longer needed.
 */


/**
 * g_drive_get_sort_key:
 * @drive: A #GDrive.
 *
 * Gets the sort key for @drive, if any.
 *
 * Returns: (nullable): Sorting key for @drive or %NULL if no such key is available.
 * Since: 2.32
 */


/**
 * g_drive_get_start_stop_type:
 * @drive: a #GDrive.
 *
 * Gets a hint about how a drive can be started/stopped.
 *
 * Returns: A value from the #GDriveStartStopType enumeration.
 * Since: 2.22
 */


/**
 * g_drive_get_symbolic_icon:
 * @drive: a #GDrive.
 *
 * Gets the icon for @drive.
 *
 * Returns: (transfer full): symbolic #GIcon for the @drive.
 *    Free the returned object with g_object_unref().
 * Since: 2.34
 */


/**
 * g_drive_get_volumes:
 * @drive: a #GDrive.
 *
 * Get a list of mountable volumes for @drive.
 *
 * The returned list should be freed with g_list_free(), after
 * its elements have been unreffed with g_object_unref().
 *
 * Returns: (element-type GVolume) (transfer full): #GList containing any #GVolume objects on the given @drive.
 */


/**
 * g_drive_has_media:
 * @drive: a #GDrive.
 *
 * Checks if the @drive has media. Note that the OS may not be polling
 * the drive for media changes; see g_drive_is_media_check_automatic()
 * for more details.
 *
 * Returns: %TRUE if @drive has media, %FALSE otherwise.
 */


/**
 * g_drive_has_volumes:
 * @drive: a #GDrive.
 *
 * Check if @drive has any mountable volumes.
 *
 * Returns: %TRUE if the @drive contains volumes, %FALSE otherwise.
 */


/**
 * g_drive_is_media_check_automatic:
 * @drive: a #GDrive.
 *
 * Checks if @drive is capable of automatically detecting media changes.
 *
 * Returns: %TRUE if the @drive is capable of automatically detecting
 *     media changes, %FALSE otherwise.
 */


/**
 * g_drive_is_media_removable:
 * @drive: a #GDrive.
 *
 * Checks if the @drive supports removable media.
 *
 * Returns: %TRUE if @drive supports removable media, %FALSE otherwise.
 */


/**
 * g_drive_is_removable:
 * @drive: a #GDrive.
 *
 * Checks if the #GDrive and/or its media is considered removable by the user.
 * See g_drive_is_media_removable().
 *
 * Returns: %TRUE if @drive and/or its media is considered removable, %FALSE otherwise.
 * Since: 2.50
 */


/**
 * g_drive_poll_for_media:
 * @drive: a #GDrive.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously polls @drive to see if media has been inserted or removed.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_poll_for_media_finish() to obtain the
 * result of the operation.
 */


/**
 * g_drive_poll_for_media_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an operation started with g_drive_poll_for_media() on a drive.
 *
 * Returns: %TRUE if the drive has been poll_for_mediaed successfully,
 *     %FALSE otherwise.
 */


/**
 * g_drive_start:
 * @drive: a #GDrive.
 * @flags: flags affecting the start operation.
 * @mount_operation: (nullable): a #GMountOperation or %NULL to avoid
 *     user interaction.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously starts a drive.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_start_finish() to obtain the
 * result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_drive_start_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes starting a drive.
 *
 * Returns: %TRUE if the drive has been started successfully,
 *     %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_stop:
 * @drive: a #GDrive.
 * @flags: flags affecting the unmount if required for stopping.
 * @mount_operation: (nullable): a #GMountOperation or %NULL to avoid
 *     user interaction.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously stops a drive.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_stop_finish() to obtain the
 * result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_drive_stop_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes stopping a drive.
 *
 * Returns: %TRUE if the drive has been stopped successfully,
 *     %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_dtls_client_connection_get_accepted_cas:
 * @conn: the #GDtlsClientConnection
 *
 * Gets the list of distinguished names of the Certificate Authorities
 * that the server will accept certificates from. This will be set
 * during the TLS handshake if the server requests a certificate.
 * Otherwise, it will be %NULL.
 *
 * Each item in the list is a #GByteArray which contains the complete
 * subject DN of the certificate authority.
 *
 * Returns: (element-type GByteArray) (transfer full): the list of
 * CA DNs. You should unref each element with g_byte_array_unref() and then
 * the free the list with g_list_free().
 * Since: 2.48
 */


/**
 * g_dtls_client_connection_get_server_identity:
 * @conn: the #GDtlsClientConnection
 *
 * Gets @conn's expected server identity
 *
 * Returns: (transfer none): a #GSocketConnectable describing the
 * expected server identity, or %NULL if the expected identity is not
 * known.
 * Since: 2.48
 */


/**
 * g_dtls_client_connection_get_validation_flags:
 * @conn: the #GDtlsClientConnection
 *
 * Gets @conn's validation flags
 *
 * This function does not work as originally designed and is impossible
 * to use correctly. See #GDtlsClientConnection:validation-flags for more
 * information.
 *
 * Returns: the validation flags
 * Since: 2.48
 * Deprecated: 2.74: Do not attempt to ignore validation errors.
 */


/**
 * g_dtls_client_connection_new:
 * @base_socket: the #GDatagramBased to wrap
 * @server_identity: (nullable): the expected identity of the server
 * @error: #GError for error reporting, or %NULL to ignore.
 *
 * Creates a new #GDtlsClientConnection wrapping @base_socket which is
 * assumed to communicate with the server identified by @server_identity.
 *
 * Returns: (transfer full) (type GDtlsClientConnection): the new
 *   #GDtlsClientConnection, or %NULL on error
 * Since: 2.48
 */


/**
 * g_dtls_client_connection_set_server_identity:
 * @conn: the #GDtlsClientConnection
 * @identity: a #GSocketConnectable describing the expected server identity
 *
 * Sets @conn's expected server identity, which is used both to tell
 * servers on virtual hosts which certificate to present, and also
 * to let @conn know what name to look for in the certificate when
 * performing %G_TLS_CERTIFICATE_BAD_IDENTITY validation, if enabled.
 *
 * Since: 2.48
 */


/**
 * g_dtls_client_connection_set_validation_flags:
 * @conn: the #GDtlsClientConnection
 * @flags: the #GTlsCertificateFlags to use
 *
 * Sets @conn's validation flags, to override the default set of
 * checks performed when validating a server certificate. By default,
 * %G_TLS_CERTIFICATE_VALIDATE_ALL is used.
 *
 * This function does not work as originally designed and is impossible
 * to use correctly. See #GDtlsClientConnection:validation-flags for more
 * information.
 *
 * Since: 2.48
 * Deprecated: 2.74: Do not attempt to ignore validation errors.
 */


/**
 * g_dtls_connection_close:
 * @conn: a #GDtlsConnection
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @error: a #GError, or %NULL
 *
 * Close the DTLS connection. This is equivalent to calling
 * g_dtls_connection_shutdown() to shut down both sides of the connection.
 *
 * Closing a #GDtlsConnection waits for all buffered but untransmitted data to
 * be sent before it completes. It then sends a `close_notify` DTLS alert to the
 * peer and may wait for a `close_notify` to be received from the peer. It does
 * not close the underlying #GDtlsConnection:base-socket; that must be closed
 * separately.
 *
 * Once @conn is closed, all other operations will return %G_IO_ERROR_CLOSED.
 * Closing a #GDtlsConnection multiple times will not return an error.
 *
 * #GDtlsConnections will be automatically closed when the last reference is
 * dropped, but you might want to call this function to make sure resources are
 * released as early as possible.
 *
 * If @cancellable is cancelled, the #GDtlsConnection may be left
 * partially-closed and any pending untransmitted data may be lost. Call
 * g_dtls_connection_close() again to complete closing the #GDtlsConnection.
 *
 * Returns: %TRUE on success, %FALSE otherwise
 * Since: 2.48
 */


/**
 * g_dtls_connection_close_async:
 * @conn: a #GDtlsConnection
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @callback: callback to call when the close operation is complete
 * @user_data: the data to pass to the callback function
 *
 * Asynchronously close the DTLS connection. See g_dtls_connection_close() for
 * more information.
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_close_finish:
 * @conn: a #GDtlsConnection
 * @result: a #GAsyncResult
 * @error: a #GError pointer, or %NULL
 *
 * Finish an asynchronous TLS close operation. See g_dtls_connection_close()
 * for more information.
 *
 * Returns: %TRUE on success, %FALSE on failure, in which
 * case @error will be set
 * Since: 2.48
 */


/**
 * g_dtls_connection_emit_accept_certificate:
 * @conn: a #GDtlsConnection
 * @peer_cert: the peer's #GTlsCertificate
 * @errors: the problems with @peer_cert
 *
 * Used by #GDtlsConnection implementations to emit the
 * #GDtlsConnection::accept-certificate signal.
 *
 * Returns: %TRUE if one of the signal handlers has returned
 *     %TRUE to accept @peer_cert
 * Since: 2.48
 */


/**
 * g_dtls_connection_get_certificate:
 * @conn: a #GDtlsConnection
 *
 * Gets @conn's certificate, as set by
 * g_dtls_connection_set_certificate().
 *
 * Returns: (transfer none) (nullable): @conn's certificate, or %NULL
 * Since: 2.48
 */


/**
 * g_dtls_connection_get_channel_binding_data:
 * @conn: a #GDtlsConnection
 * @type: #GTlsChannelBindingType type of data to fetch
 * @data: (out callee-allocates) (optional) (transfer none): #GByteArray is
 *        filled with the binding data, or %NULL
 * @error: a #GError pointer, or %NULL
 *
 * Query the TLS backend for TLS channel binding data of @type for @conn.
 *
 * This call retrieves TLS channel binding data as specified in RFC
 * [5056](https://tools.ietf.org/html/rfc5056), RFC
 * [5929](https://tools.ietf.org/html/rfc5929), and related RFCs.  The
 * binding data is returned in @data.  The @data is resized by the callee
 * using #GByteArray buffer management and will be freed when the @data
 * is destroyed by g_byte_array_unref(). If @data is %NULL, it will only
 * check whether TLS backend is able to fetch the data (e.g. whether @type
 * is supported by the TLS backend). It does not guarantee that the data
 * will be available though.  That could happen if TLS connection does not
 * support @type or the binding data is not available yet due to additional
 * negotiation or input required.
 *
 * Returns: %TRUE on success, %FALSE otherwise
 * Since: 2.66
 */


/**
 * g_dtls_connection_get_ciphersuite_name:
 * @conn: a #GDTlsConnection
 *
 * Returns the name of the current DTLS ciphersuite, or %NULL if the
 * connection has not handshaked or has been closed. Beware that the TLS
 * backend may use any of multiple different naming conventions, because
 * OpenSSL and GnuTLS have their own ciphersuite naming conventions that
 * are different from each other and different from the standard, IANA-
 * registered ciphersuite names. The ciphersuite name is intended to be
 * displayed to the user for informative purposes only, and parsing it
 * is not recommended.
 *
 * Returns: (nullable): The name of the current DTLS ciphersuite, or %NULL
 * Since: 2.70
 */


/**
 * g_dtls_connection_get_database:
 * @conn: a #GDtlsConnection
 *
 * Gets the certificate database that @conn uses to verify
 * peer certificates. See g_dtls_connection_set_database().
 *
 * Returns: (transfer none) (nullable): the certificate database that @conn uses or %NULL
 * Since: 2.48
 */


/**
 * g_dtls_connection_get_interaction:
 * @conn: a connection
 *
 * Get the object that will be used to interact with the user. It will be used
 * for things like prompting the user for passwords. If %NULL is returned, then
 * no user interaction will occur for this connection.
 *
 * Returns: (transfer none) (nullable): The interaction object.
 * Since: 2.48
 */


/**
 * g_dtls_connection_get_negotiated_protocol:
 * @conn: a #GDtlsConnection
 *
 * Gets the name of the application-layer protocol negotiated during
 * the handshake.
 *
 * If the peer did not use the ALPN extension, or did not advertise a
 * protocol that matched one of @conn's protocols, or the TLS backend
 * does not support ALPN, then this will be %NULL. See
 * g_dtls_connection_set_advertised_protocols().
 *
 * Returns: (nullable): the negotiated protocol, or %NULL
 * Since: 2.60
 */


/**
 * g_dtls_connection_get_peer_certificate:
 * @conn: a #GDtlsConnection
 *
 * Gets @conn's peer's certificate after the handshake has completed
 * or failed. (It is not set during the emission of
 * #GDtlsConnection::accept-certificate.)
 *
 * Returns: (transfer none) (nullable): @conn's peer's certificate, or %NULL
 * Since: 2.48
 */


/**
 * g_dtls_connection_get_peer_certificate_errors:
 * @conn: a #GDtlsConnection
 *
 * Gets the errors associated with validating @conn's peer's
 * certificate, after the handshake has completed or failed. (It is
 * not set during the emission of #GDtlsConnection::accept-certificate.)
 *
 * Returns: @conn's peer's certificate errors
 * Since: 2.48
 */


/**
 * g_dtls_connection_get_protocol_version:
 * @conn: a #GDTlsConnection
 *
 * Returns the current DTLS protocol version, which may be
 * %G_TLS_PROTOCOL_VERSION_UNKNOWN if the connection has not handshaked, or
 * has been closed, or if the TLS backend has implemented a protocol version
 * that is not a recognized #GTlsProtocolVersion.
 *
 * Returns: The current DTLS protocol version
 * Since: 2.70
 */


/**
 * g_dtls_connection_get_rehandshake_mode:
 * @conn: a #GDtlsConnection
 *
 * Gets @conn rehandshaking mode. See
 * g_dtls_connection_set_rehandshake_mode() for details.
 *
 * Returns: %G_TLS_REHANDSHAKE_SAFELY
 * Since: 2.48
 * Deprecated: 2.64.: Changing the rehandshake mode is no longer
 *   required for compatibility. Also, rehandshaking has been removed
 *   from the TLS protocol in TLS 1.3.
 */


/**
 * g_dtls_connection_get_require_close_notify:
 * @conn: a #GDtlsConnection
 *
 * Tests whether or not @conn expects a proper TLS close notification
 * when the connection is closed. See
 * g_dtls_connection_set_require_close_notify() for details.
 *
 * Returns: %TRUE if @conn requires a proper TLS close notification.
 * Since: 2.48
 */


/**
 * g_dtls_connection_handshake:
 * @conn: a #GDtlsConnection
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @error: a #GError, or %NULL
 *
 * Attempts a TLS handshake on @conn.
 *
 * On the client side, it is never necessary to call this method;
 * although the connection needs to perform a handshake after
 * connecting, #GDtlsConnection will handle this for you automatically
 * when you try to send or receive data on the connection. You can call
 * g_dtls_connection_handshake() manually if you want to know whether
 * the initial handshake succeeded or failed (as opposed to just
 * immediately trying to use @conn to read or write, in which case,
 * if it fails, it may not be possible to tell if it failed before
 * or after completing the handshake), but beware that servers may reject
 * client authentication after the handshake has completed, so a
 * successful handshake does not indicate the connection will be usable.
 *
 * Likewise, on the server side, although a handshake is necessary at
 * the beginning of the communication, you do not need to call this
 * function explicitly unless you want clearer error reporting.
 *
 * Previously, calling g_dtls_connection_handshake() after the initial
 * handshake would trigger a rehandshake; however, this usage was
 * deprecated in GLib 2.60 because rehandshaking was removed from the
 * TLS protocol in TLS 1.3. Since GLib 2.64, calling this function after
 * the initial handshake will no longer do anything.
 *
 * #GDtlsConnection::accept_certificate may be emitted during the
 * handshake.
 *
 * Returns: success or failure
 * Since: 2.48
 */


/**
 * g_dtls_connection_handshake_async:
 * @conn: a #GDtlsConnection
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @callback: callback to call when the handshake is complete
 * @user_data: the data to pass to the callback function
 *
 * Asynchronously performs a TLS handshake on @conn. See
 * g_dtls_connection_handshake() for more information.
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_handshake_finish:
 * @conn: a #GDtlsConnection
 * @result: a #GAsyncResult.
 * @error: a #GError pointer, or %NULL
 *
 * Finish an asynchronous TLS handshake operation. See
 * g_dtls_connection_handshake() for more information.
 *
 * Returns: %TRUE on success, %FALSE on failure, in which
 * case @error will be set.
 * Since: 2.48
 */


/**
 * g_dtls_connection_set_advertised_protocols:
 * @conn: a #GDtlsConnection
 * @protocols: (array zero-terminated=1) (nullable): a %NULL-terminated
 *   array of ALPN protocol names (eg, "http/1.1", "h2"), or %NULL
 *
 * Sets the list of application-layer protocols to advertise that the
 * caller is willing to speak on this connection. The
 * Application-Layer Protocol Negotiation (ALPN) extension will be
 * used to negotiate a compatible protocol with the peer; use
 * g_dtls_connection_get_negotiated_protocol() to find the negotiated
 * protocol after the handshake.  Specifying %NULL for the the value
 * of @protocols will disable ALPN negotiation.
 *
 * See [IANA TLS ALPN Protocol IDs](https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids)
 * for a list of registered protocol IDs.
 *
 * Since: 2.60
 */


/**
 * g_dtls_connection_set_certificate:
 * @conn: a #GDtlsConnection
 * @certificate: the certificate to use for @conn
 *
 * This sets the certificate that @conn will present to its peer
 * during the TLS handshake. For a #GDtlsServerConnection, it is
 * mandatory to set this, and that will normally be done at construct
 * time.
 *
 * For a #GDtlsClientConnection, this is optional. If a handshake fails
 * with %G_TLS_ERROR_CERTIFICATE_REQUIRED, that means that the server
 * requires a certificate, and if you try connecting again, you should
 * call this method first. You can call
 * g_dtls_client_connection_get_accepted_cas() on the failed connection
 * to get a list of Certificate Authorities that the server will
 * accept certificates from.
 *
 * (It is also possible that a server will allow the connection with
 * or without a certificate; in that case, if you don't provide a
 * certificate, you can tell that the server requested one by the fact
 * that g_dtls_client_connection_get_accepted_cas() will return
 * non-%NULL.)
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_set_database:
 * @conn: a #GDtlsConnection
 * @database: (nullable): a #GTlsDatabase
 *
 * Sets the certificate database that is used to verify peer certificates.
 * This is set to the default database by default. See
 * g_tls_backend_get_default_database(). If set to %NULL, then
 * peer certificate validation will always set the
 * %G_TLS_CERTIFICATE_UNKNOWN_CA error (meaning
 * #GDtlsConnection::accept-certificate will always be emitted on
 * client-side connections, unless that bit is not set in
 * #GDtlsClientConnection:validation-flags).
 *
 * There are nonintuitive security implications when using a non-default
 * database. See #GDtlsConnection:database for details.
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_set_interaction:
 * @conn: a connection
 * @interaction: (nullable): an interaction object, or %NULL
 *
 * Set the object that will be used to interact with the user. It will be used
 * for things like prompting the user for passwords.
 *
 * The @interaction argument will normally be a derived subclass of
 * #GTlsInteraction. %NULL can also be provided if no user interaction
 * should occur for this connection.
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_set_rehandshake_mode:
 * @conn: a #GDtlsConnection
 * @mode: the rehandshaking mode
 *
 * Since GLib 2.64, changing the rehandshake mode is no longer supported
 * and will have no effect. With TLS 1.3, rehandshaking has been removed from
 * the TLS protocol, replaced by separate post-handshake authentication and
 * rekey operations.
 *
 * Since: 2.48
 * Deprecated: 2.60.: Changing the rehandshake mode is no longer
 *   required for compatibility. Also, rehandshaking has been removed
 *   from the TLS protocol in TLS 1.3.
 */


/**
 * g_dtls_connection_set_require_close_notify:
 * @conn: a #GDtlsConnection
 * @require_close_notify: whether or not to require close notification
 *
 * Sets whether or not @conn expects a proper TLS close notification
 * before the connection is closed. If this is %TRUE (the default),
 * then @conn will expect to receive a TLS close notification from its
 * peer before the connection is closed, and will return a
 * %G_TLS_ERROR_EOF error if the connection is closed without proper
 * notification (since this may indicate a network error, or
 * man-in-the-middle attack).
 *
 * In some protocols, the application will know whether or not the
 * connection was closed cleanly based on application-level data
 * (because the application-level data includes a length field, or is
 * somehow self-delimiting); in this case, the close notify is
 * redundant and may be omitted. You
 * can use g_dtls_connection_set_require_close_notify() to tell @conn
 * to allow an "unannounced" connection close, in which case the close
 * will show up as a 0-length read, as in a non-TLS
 * #GDatagramBased, and it is up to the application to check that
 * the data has been fully received.
 *
 * Note that this only affects the behavior when the peer closes the
 * connection; when the application calls g_dtls_connection_close_async() on
 * @conn itself, this will send a close notification regardless of the
 * setting of this property. If you explicitly want to do an unclean
 * close, you can close @conn's #GDtlsConnection:base-socket rather
 * than closing @conn itself.
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_shutdown:
 * @conn: a #GDtlsConnection
 * @shutdown_read: %TRUE to stop reception of incoming datagrams
 * @shutdown_write: %TRUE to stop sending outgoing datagrams
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @error: a #GError, or %NULL
 *
 * Shut down part or all of a DTLS connection.
 *
 * If @shutdown_read is %TRUE then the receiving side of the connection is shut
 * down, and further reading is disallowed. Subsequent calls to
 * g_datagram_based_receive_messages() will return %G_IO_ERROR_CLOSED.
 *
 * If @shutdown_write is %TRUE then the sending side of the connection is shut
 * down, and further writing is disallowed. Subsequent calls to
 * g_datagram_based_send_messages() will return %G_IO_ERROR_CLOSED.
 *
 * It is allowed for both @shutdown_read and @shutdown_write to be TRUE — this
 * is equivalent to calling g_dtls_connection_close().
 *
 * If @cancellable is cancelled, the #GDtlsConnection may be left
 * partially-closed and any pending untransmitted data may be lost. Call
 * g_dtls_connection_shutdown() again to complete closing the #GDtlsConnection.
 *
 * Returns: %TRUE on success, %FALSE otherwise
 * Since: 2.48
 */


/**
 * g_dtls_connection_shutdown_async:
 * @conn: a #GDtlsConnection
 * @shutdown_read: %TRUE to stop reception of incoming datagrams
 * @shutdown_write: %TRUE to stop sending outgoing datagrams
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): a #GCancellable, or %NULL
 * @callback: callback to call when the shutdown operation is complete
 * @user_data: the data to pass to the callback function
 *
 * Asynchronously shut down part or all of the DTLS connection. See
 * g_dtls_connection_shutdown() for more information.
 *
 * Since: 2.48
 */


/**
 * g_dtls_connection_shutdown_finish:
 * @conn: a #GDtlsConnection
 * @result: a #GAsyncResult
 * @error: a #GError pointer, or %NULL
 *
 * Finish an asynchronous TLS shutdown operation. See
 * g_dtls_connection_shutdown() for more information.
 *
 * Returns: %TRUE on success, %FALSE on failure, in which
 * case @error will be set
 * Since: 2.48
 */


/**
 * g_dtls_server_connection_new:
 * @base_socket: the #GDatagramBased to wrap
 * @certificate: (nullable): the default server certificate, or %NULL
 * @error: #GError for error reporting, or %NULL to ignore
 *
 * Creates a new #GDtlsServerConnection wrapping @base_socket.
 *
 * Returns: (transfer full) (type GDtlsServerConnection): the new
 *   #GDtlsServerConnection, or %NULL on error
 * Since: 2.48
 */


/**
 * g_emblem_get_icon:
 * @emblem: a #GEmblem from which the icon should be extracted.
 *
 * Gives back the icon from @emblem.
 *
 * Returns: (transfer none): a #GIcon. The returned object belongs to
 *          the emblem and should not be modified or freed.
 * Since: 2.18
 */


/**
 * g_emblem_get_origin:
 * @emblem: a #GEmblem
 *
 * Gets the origin of the emblem.
 *
 * Returns: (transfer none): the origin of the emblem
 * Since: 2.18
 */


/**
 * g_emblem_new:
 * @icon: a GIcon containing the icon.
 *
 * Creates a new emblem for @icon.
 *
 * Returns: a new #GEmblem.
 * Since: 2.18
 */


/**
 * g_emblem_new_with_origin:
 * @icon: a GIcon containing the icon.
 * @origin: a GEmblemOrigin enum defining the emblem's origin
 *
 * Creates a new emblem for @icon.
 *
 * Returns: a new #GEmblem.
 * Since: 2.18
 */


/**
 * g_emblemed_icon_add_emblem:
 * @emblemed: a #GEmblemedIcon
 * @emblem: a #GEmblem
 *
 * Adds @emblem to the #GList of #GEmblems.
 *
 * Since: 2.18
 */


/**
 * g_emblemed_icon_clear_emblems:
 * @emblemed: a #GEmblemedIcon
 *
 * Removes all the emblems from @icon.
 *
 * Since: 2.28
 */


/**
 * g_emblemed_icon_get_emblems:
 * @emblemed: a #GEmblemedIcon
 *
 * Gets the list of emblems for the @icon.
 *
 * Returns: (element-type Gio.Emblem) (transfer none): a #GList of
 *     #GEmblems that is owned by @emblemed
 * Since: 2.18
 */


/**
 * g_emblemed_icon_get_icon:
 * @emblemed: a #GEmblemedIcon
 *
 * Gets the main icon for @emblemed.
 *
 * Returns: (transfer none): a #GIcon that is owned by @emblemed
 * Since: 2.18
 */


/**
 * g_emblemed_icon_new:
 * @icon: a #GIcon
 * @emblem: (nullable): a #GEmblem, or %NULL
 *
 * Creates a new emblemed icon for @icon with the emblem @emblem.
 *
 * Returns: (transfer full) (type GEmblemedIcon): a new #GIcon
 * Since: 2.18
 */


/**
 * g_file_append_to:
 * @file: input #GFile
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Gets an output stream for appending data to the file.
 * If the file doesn't already exist it is created.
 *
 * By default files created are generally readable by everyone,
 * but if you pass %G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level that
 * is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * Some file systems don't allow all file names, and may return an
 * %G_IO_ERROR_INVALID_FILENAME error. If the file is a directory the
 * %G_IO_ERROR_IS_DIRECTORY error will be returned. Other errors are
 * possible too, and depend on what kind of filesystem the file is on.
 *
 * Returns: (transfer full): a #GFileOutputStream, or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_append_to_async:
 * @file: input #GFile
 * @flags: a set of #GFileCreateFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously opens @file for appending.
 *
 * For more details, see g_file_append_to() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_append_to_finish() to get the result
 * of the operation.
 */


/**
 * g_file_append_to_finish:
 * @file: input #GFile
 * @res: #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file append operation started with
 * g_file_append_to_async().
 *
 * Returns: (transfer full): a valid #GFileOutputStream
 *   or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_attribute_info_list_add:
 * @list: a #GFileAttributeInfoList.
 * @name: the name of the attribute to add.
 * @type: the #GFileAttributeType for the attribute.
 * @flags: #GFileAttributeInfoFlags for the attribute.
 *
 * Adds a new attribute with @name to the @list, setting
 * its @type and @flags.
 */


/**
 * g_file_attribute_info_list_dup:
 * @list: a #GFileAttributeInfoList to duplicate.
 *
 * Makes a duplicate of a file attribute info list.
 *
 * Returns: a copy of the given @list.
 */


/**
 * g_file_attribute_info_list_lookup:
 * @list: a #GFileAttributeInfoList.
 * @name: the name of the attribute to look up.
 *
 * Gets the file attribute with the name @name from @list.
 *
 * Returns: a #GFileAttributeInfo for the @name, or %NULL if an
 * attribute isn't found.
 */


/**
 * g_file_attribute_info_list_new:
 *
 * Creates a new file attribute info list.
 *
 * Returns: a #GFileAttributeInfoList.
 */


/**
 * g_file_attribute_info_list_ref:
 * @list: a #GFileAttributeInfoList to reference.
 *
 * References a file attribute info list.
 *
 * Returns: #GFileAttributeInfoList or %NULL on error.
 */


/**
 * g_file_attribute_info_list_unref:
 * @list: The #GFileAttributeInfoList to unreference.
 *
 * Removes a reference from the given @list. If the reference count
 * falls to zero, the @list is deleted.
 */


/**
 * g_file_attribute_matcher_enumerate_namespace:
 * @matcher: a #GFileAttributeMatcher.
 * @ns: a string containing a file attribute namespace.
 *
 * Checks if the matcher will match all of the keys in a given namespace.
 * This will always return %TRUE if a wildcard character is in use (e.g. if
 * matcher was created with "standard::*" and @ns is "standard", or if matcher was created
 * using "*" and namespace is anything.)
 *
 * TODO: this is awkwardly worded.
 *
 * Returns: %TRUE if the matcher matches all of the entries
 * in the given @ns, %FALSE otherwise.
 */


/**
 * g_file_attribute_matcher_enumerate_next:
 * @matcher: a #GFileAttributeMatcher.
 *
 * Gets the next matched attribute from a #GFileAttributeMatcher.
 *
 * Returns: (nullable): a string containing the next attribute or, %NULL if
 * no more attribute exist.
 */


/**
 * g_file_attribute_matcher_matches:
 * @matcher: a #GFileAttributeMatcher.
 * @attribute: a file attribute key.
 *
 * Checks if an attribute will be matched by an attribute matcher. If
 * the matcher was created with the "*" matching string, this function
 * will always return %TRUE.
 *
 * Returns: %TRUE if @attribute matches @matcher. %FALSE otherwise.
 */


/**
 * g_file_attribute_matcher_matches_only:
 * @matcher: a #GFileAttributeMatcher.
 * @attribute: a file attribute key.
 *
 * Checks if an attribute matcher only matches a given attribute. Always
 * returns %FALSE if "*" was used when creating the matcher.
 *
 * Returns: %TRUE if the matcher only matches @attribute. %FALSE otherwise.
 */


/**
 * g_file_attribute_matcher_new:
 * @attributes: an attribute string to match.
 *
 * Creates a new file attribute matcher, which matches attributes
 * against a given string. #GFileAttributeMatchers are reference
 * counted structures, and are created with a reference count of 1. If
 * the number of references falls to 0, the #GFileAttributeMatcher is
 * automatically destroyed.
 *
 * The @attributes string should be formatted with specific keys separated
 * from namespaces with a double colon. Several "namespace::key" strings may be
 * concatenated with a single comma (e.g. "standard::type,standard::is-hidden").
 * The wildcard "*" may be used to match all keys and namespaces, or
 * "namespace::*" will match all keys in a given namespace.
 *
 * ## Examples of file attribute matcher strings and results
 *
 * - `"*"`: matches all attributes.
 * - `"standard::is-hidden"`: matches only the key is-hidden in the
 *   standard namespace.
 * - `"standard::type,unix::*"`: matches the type key in the standard
 *   namespace and all keys in the unix namespace.
 *
 * Returns: a #GFileAttributeMatcher
 */


/**
 * g_file_attribute_matcher_ref:
 * @matcher: a #GFileAttributeMatcher.
 *
 * References a file attribute matcher.
 *
 * Returns: a #GFileAttributeMatcher.
 */


/**
 * g_file_attribute_matcher_subtract:
 * @matcher: (nullable): Matcher to subtract from
 * @subtract: (nullable): The matcher to subtract
 *
 * Subtracts all attributes of @subtract from @matcher and returns
 * a matcher that supports those attributes.
 *
 * Note that currently it is not possible to remove a single
 * attribute when the @matcher matches the whole namespace - or remove
 * a namespace or attribute when the matcher matches everything. This
 * is a limitation of the current implementation, but may be fixed
 * in the future.
 *
 * Returns: (nullable): A file attribute matcher matching all attributes of
 *     @matcher that are not matched by @subtract
 */


/**
 * g_file_attribute_matcher_to_string:
 * @matcher: (nullable): a #GFileAttributeMatcher.
 *
 * Prints what the matcher is matching against. The format will be
 * equal to the format passed to g_file_attribute_matcher_new().
 * The output however, might not be identical, as the matcher may
 * decide to use a different order or omit needless parts.
 *
 * Returns: a string describing the attributes the matcher matches
 *   against or %NULL if @matcher was %NULL.
 * Since: 2.32
 */


/**
 * g_file_attribute_matcher_unref:
 * @matcher: a #GFileAttributeMatcher.
 *
 * Unreferences @matcher. If the reference count falls below 1,
 * the @matcher is automatically freed.
 */


/**
 * g_file_attribute_value_dup:
 * @other: a #GFileAttributeValue to duplicate.
 *
 * Duplicates a file attribute.
 *
 * Returns: a duplicate of the @other.
 */


/**
 * g_file_attribute_value_set:
 * @attr: a #GFileAttributeValue to set the value in.
 * @new_value: a #GFileAttributeValue to get the value from.
 *
 * Sets an attribute's value from another attribute.
 */


/**
 * g_file_build_attribute_list_for_copy:
 * @file: a #GFile to copy attributes to
 * @flags: a set of #GFileCopyFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, %NULL to ignore
 *
 * Prepares the file attribute query string for copying to @file.
 *
 * This function prepares an attribute query string to be
 * passed to g_file_query_info() to get a list of attributes
 * normally copied with the file (see g_file_copy_attributes()
 * for the detailed description). This function is used by the
 * implementation of g_file_copy_attributes() and is useful
 * when one needs to query and set the attributes in two
 * stages (e.g., for recursive move of a directory).
 *
 * Returns: an attribute query string for g_file_query_info(),
 *   or %NULL if an error occurs.
 * Since: 2.68
 */


/**
 * g_file_copy:
 * @source: input #GFile
 * @destination: destination #GFile
 * @flags: set of #GFileCopyFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @progress_callback: (nullable) (scope call) (closure progress_callback_data): function to callback with
 *   progress information, or %NULL if progress information is not needed
 * @progress_callback_data: user data to pass to @progress_callback
 * @error: #GError to set on error, or %NULL
 *
 * Copies the file @source to the location specified by @destination.
 * Can not handle recursive copies of directories.
 *
 * If the flag %G_FILE_COPY_OVERWRITE is specified an already
 * existing @destination file is overwritten.
 *
 * If the flag %G_FILE_COPY_NOFOLLOW_SYMLINKS is specified then symlinks
 * will be copied as symlinks, otherwise the target of the
 * @source symlink will be copied.
 *
 * If the flag %G_FILE_COPY_ALL_METADATA is specified then all the metadata
 * that is possible to copy is copied, not just the default subset (which,
 * for instance, does not include the owner, see #GFileInfo).
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @progress_callback is not %NULL, then the operation can be monitored
 * by setting this to a #GFileProgressCallback function.
 * @progress_callback_data will be passed to this function. It is guaranteed
 * that this callback will be called after all data has been transferred with
 * the total number of bytes copied during the operation.
 *
 * If the @source file does not exist, then the %G_IO_ERROR_NOT_FOUND error
 * is returned, independent on the status of the @destination.
 *
 * If %G_FILE_COPY_OVERWRITE is not specified and the target exists, then
 * the error %G_IO_ERROR_EXISTS is returned.
 *
 * If trying to overwrite a file over a directory, the %G_IO_ERROR_IS_DIRECTORY
 * error is returned. If trying to overwrite a directory with a directory the
 * %G_IO_ERROR_WOULD_MERGE error is returned.
 *
 * If the source is a directory and the target does not exist, or
 * %G_FILE_COPY_OVERWRITE is specified and the target is a file, then the
 * %G_IO_ERROR_WOULD_RECURSE error is returned.
 *
 * If you are interested in copying the #GFile object itself (not the on-disk
 * file), see g_file_dup().
 *
 * Returns: %TRUE on success, %FALSE otherwise.
 */


/**
 * g_file_copy_async:
 * @source: input #GFile
 * @destination: destination #GFile
 * @flags: set of #GFileCopyFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @progress_callback: (nullable) (scope notified) (closure progress_callback_data):
 *   function to callback with progress information, or %NULL if
 *   progress information is not needed
 * @progress_callback_data: user data to pass to @progress_callback
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback
 *
 * Copies the file @source to the location specified by @destination
 * asynchronously. For details of the behaviour, see g_file_copy().
 *
 * If @progress_callback is not %NULL, then that function that will be called
 * just like in g_file_copy(). The callback will run in the default main context
 * of the thread calling g_file_copy_async() — the same context as @callback is
 * run in.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_copy_finish() to get the result of the operation.
 */


/**
 * g_file_copy_attributes:
 * @source: a #GFile with attributes
 * @destination: a #GFile to copy attributes to
 * @flags: a set of #GFileCopyFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, %NULL to ignore
 *
 * Copies the file attributes from @source to @destination.
 *
 * Normally only a subset of the file attributes are copied,
 * those that are copies in a normal file copy operation
 * (which for instance does not include e.g. owner). However
 * if %G_FILE_COPY_ALL_METADATA is specified in @flags, then
 * all the metadata that is possible to copy is copied. This
 * is useful when implementing move by copy + delete source.
 *
 * Returns: %TRUE if the attributes were copied successfully,
 *   %FALSE otherwise.
 */


/**
 * g_file_copy_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes copying the file started with g_file_copy_async().
 *
 * Returns: a %TRUE on success, %FALSE on error.
 */


/**
 * g_file_create:
 * @file: input #GFile
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Creates a new file and returns an output stream for writing to it.
 * The file must not already exist.
 *
 * By default files created are generally readable by everyone,
 * but if you pass %G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level
 * that is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * If a file or directory with this name already exists the
 * %G_IO_ERROR_EXISTS error will be returned. Some file systems don't
 * allow all file names, and may return an %G_IO_ERROR_INVALID_FILENAME
 * error, and if the name is to long %G_IO_ERROR_FILENAME_TOO_LONG will
 * be returned. Other errors are possible too, and depend on what kind
 * of filesystem the file is on.
 *
 * Returns: (transfer full): a #GFileOutputStream for the newly created
 *   file, or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_create_async:
 * @file: input #GFile
 * @flags: a set of #GFileCreateFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously creates a new file and returns an output stream
 * for writing to it. The file must not already exist.
 *
 * For more details, see g_file_create() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_create_finish() to get the result
 * of the operation.
 */


/**
 * g_file_create_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file create operation started with
 * g_file_create_async().
 *
 * Returns: (transfer full): a #GFileOutputStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_create_readwrite:
 * @file: a #GFile
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: return location for a #GError, or %NULL
 *
 * Creates a new file and returns a stream for reading and
 * writing to it. The file must not already exist.
 *
 * By default files created are generally readable by everyone,
 * but if you pass %G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level
 * that is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * If a file or directory with this name already exists, the
 * %G_IO_ERROR_EXISTS error will be returned. Some file systems don't
 * allow all file names, and may return an %G_IO_ERROR_INVALID_FILENAME
 * error, and if the name is too long, %G_IO_ERROR_FILENAME_TOO_LONG
 * will be returned. Other errors are possible too, and depend on what
 * kind of filesystem the file is on.
 *
 * Note that in many non-local file cases read and write streams are
 * not supported, so make sure you really need to do read and write
 * streaming, rather than just opening for reading or writing.
 *
 * Returns: (transfer full): a #GFileIOStream for the newly created
 *   file, or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_file_create_readwrite_async:
 * @file: input #GFile
 * @flags: a set of #GFileCreateFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously creates a new file and returns a stream
 * for reading and writing to it. The file must not already exist.
 *
 * For more details, see g_file_create_readwrite() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_create_readwrite_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_create_readwrite_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file create operation started with
 * g_file_create_readwrite_async().
 *
 * Returns: (transfer full): a #GFileIOStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_file_delete: (virtual delete_file)
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Deletes a file. If the @file is a directory, it will only be
 * deleted if it is empty. This has the same semantics as g_unlink().
 *
 * If @file doesn’t exist, %G_IO_ERROR_NOT_FOUND will be returned. This allows
 * for deletion to be implemented avoiding
 * [time-of-check to time-of-use races](https://en.wikipedia.org/wiki/Time-of-check_to_time-of-use):
 * |[
 * g_autoptr(GError) local_error = NULL;
 * if (!g_file_delete (my_file, my_cancellable, &local_error) &&
 *     !g_error_matches (local_error, G_IO_ERROR, G_IO_ERROR_NOT_FOUND))
 *   {
 *     // deletion failed for some reason other than the file not existing:
 *     // so report the error
 *     g_warning ("Failed to delete %s: %s",
 *                g_file_peek_path (my_file), local_error->message);
 *   }
 * ]|
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the file was deleted. %FALSE otherwise.
 */


/**
 * g_file_delete_async: (virtual delete_file_async)
 * @file: input #GFile
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call
 *   when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously delete a file. If the @file is a directory, it will
 * only be deleted if it is empty.  This has the same semantics as
 * g_unlink().
 *
 * Since: 2.34
 */


/**
 * g_file_delete_finish: (virtual delete_file_finish)
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes deleting a file started with g_file_delete_async().
 *
 * Returns: %TRUE if the file was deleted. %FALSE otherwise.
 * Since: 2.34
 */


/**
 * g_file_descriptor_based_get_fd:
 * @fd_based: a #GFileDescriptorBased.
 *
 * Gets the underlying file descriptor.
 *
 * Returns: The file descriptor
 * Since: 2.24
 */


/**
 * g_file_dup:
 * @file: input #GFile
 *
 * Duplicates a #GFile handle. This operation does not duplicate
 * the actual file or directory represented by the #GFile; see
 * g_file_copy() if attempting to copy a file.
 *
 * g_file_dup() is useful when a second handle is needed to the same underlying
 * file, for use in a separate thread (#GFile is not thread-safe). For use
 * within the same thread, use g_object_ref() to increment the existing object’s
 * reference count.
 *
 * This call does no blocking I/O.
 *
 * Returns: (transfer full): a new #GFile that is a duplicate
 *   of the given #GFile.
 */


/**
 * g_file_eject_mountable:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (nullable) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts an asynchronous eject on a mountable.
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_eject_mountable_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Deprecated: 2.22: Use g_file_eject_mountable_with_operation() instead.
 */


/**
 * g_file_eject_mountable_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous eject operation started by
 * g_file_eject_mountable().
 *
 * Returns: %TRUE if the @file was ejected successfully.
 *   %FALSE otherwise.
 * Deprecated: 2.22: Use g_file_eject_mountable_with_operation_finish()
 *   instead.
 */


/**
 * g_file_eject_mountable_with_operation:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation,
 *   or %NULL to avoid user interaction
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (nullable) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts an asynchronous eject on a mountable.
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_eject_mountable_with_operation_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Since: 2.22
 */


/**
 * g_file_eject_mountable_with_operation_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous eject operation started by
 * g_file_eject_mountable_with_operation().
 *
 * Returns: %TRUE if the @file was ejected successfully.
 *   %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_file_enumerate_children:
 * @file: input #GFile
 * @attributes: an attribute query string
 * @flags: a set of #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: #GError for error reporting
 *
 * Gets the requested information about the files in a directory.
 * The result is a #GFileEnumerator object that will give out
 * #GFileInfo objects for all the files in the directory.
 *
 * The @attributes value is a string that specifies the file
 * attributes that should be gathered. It is not an error if
 * it's not possible to read a particular requested attribute
 * from a file - it just won't be set. @attributes should
 * be a comma-separated list of attributes or attribute wildcards.
 * The wildcard "*" means all attributes, and a wildcard like
 * "standard::*" means all attributes in the standard namespace.
 * An example attribute query be "standard::*,owner::user".
 * The standard attributes are available as defines, like
 * %G_FILE_ATTRIBUTE_STANDARD_NAME. %G_FILE_ATTRIBUTE_STANDARD_NAME should
 * always be specified if you plan to call g_file_enumerator_get_child() or
 * g_file_enumerator_iterate() on the returned enumerator.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * If the file does not exist, the %G_IO_ERROR_NOT_FOUND error will
 * be returned. If the file is not a directory, the %G_IO_ERROR_NOT_DIRECTORY
 * error will be returned. Other errors are possible too.
 *
 * Returns: (transfer full): A #GFileEnumerator if successful,
 *   %NULL on error. Free the returned object with g_object_unref().
 */


/**
 * g_file_enumerate_children_async:
 * @file: input #GFile
 * @attributes: an attribute query string
 * @flags: a set of #GFileQueryInfoFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously gets the requested information about the files
 * in a directory. The result is a #GFileEnumerator object that will
 * give out #GFileInfo objects for all the files in the directory.
 *
 * For more details, see g_file_enumerate_children() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can
 * then call g_file_enumerate_children_finish() to get the result of
 * the operation.
 */


/**
 * g_file_enumerate_children_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an async enumerate children operation.
 * See g_file_enumerate_children_async().
 *
 * Returns: (transfer full): a #GFileEnumerator or %NULL
 *   if an error occurred.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_enumerator_close:
 * @enumerator: a #GFileEnumerator.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Releases all resources used by this enumerator, making the
 * enumerator return %G_IO_ERROR_CLOSED on all calls.
 *
 * This will be automatically called when the last reference
 * is dropped, but you might want to call this function to make
 * sure resources are released as early as possible.
 *
 * Returns: #TRUE on success or #FALSE on error.
 */


/**
 * g_file_enumerator_close_async:
 * @enumerator: a #GFileEnumerator.
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously closes the file enumerator.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned in
 * g_file_enumerator_close_finish().
 */


/**
 * g_file_enumerator_close_finish:
 * @enumerator: a #GFileEnumerator.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes closing a file enumerator, started from g_file_enumerator_close_async().
 *
 * If the file enumerator was already closed when g_file_enumerator_close_async()
 * was called, then this function will report %G_IO_ERROR_CLOSED in @error, and
 * return %FALSE. If the file enumerator had pending operation when the close
 * operation was started, then this function will report %G_IO_ERROR_PENDING, and
 * return %FALSE.  If @cancellable was not %NULL, then the operation may have been
 * cancelled by triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set, and %FALSE will be
 * returned.
 *
 * Returns: %TRUE if the close operation has finished successfully.
 */


/**
 * g_file_enumerator_get_child:
 * @enumerator: a #GFileEnumerator
 * @info: a #GFileInfo gotten from g_file_enumerator_next_file()
 *   or the async equivalents.
 *
 * Return a new #GFile which refers to the file named by @info in the source
 * directory of @enumerator.  This function is primarily intended to be used
 * inside loops with g_file_enumerator_next_file().
 *
 * To use this, %G_FILE_ATTRIBUTE_STANDARD_NAME must have been listed in the
 * attributes list used when creating the #GFileEnumerator.
 *
 * This is a convenience method that's equivalent to:
 * |[<!-- language="C" -->
 *   gchar *name = g_file_info_get_name (info);
 *   GFile *child = g_file_get_child (g_file_enumerator_get_container (enumr),
 *                                    name);
 * ]|
 *
 * Returns: (transfer full): a #GFile for the #GFileInfo passed it.
 * Since: 2.36
 */


/**
 * g_file_enumerator_get_container:
 * @enumerator: a #GFileEnumerator
 *
 * Get the #GFile container which is being enumerated.
 *
 * Returns: (transfer none): the #GFile which is being enumerated.
 * Since: 2.18
 */


/**
 * g_file_enumerator_has_pending:
 * @enumerator: a #GFileEnumerator.
 *
 * Checks if the file enumerator has pending operations.
 *
 * Returns: %TRUE if the @enumerator has pending operations.
 */


/**
 * g_file_enumerator_is_closed:
 * @enumerator: a #GFileEnumerator.
 *
 * Checks if the file enumerator has been closed.
 *
 * Returns: %TRUE if the @enumerator is closed.
 */


/**
 * g_file_enumerator_iterate:
 * @direnum: an open #GFileEnumerator
 * @out_info: (out) (transfer none) (optional): Output location for the next #GFileInfo, or %NULL
 * @out_child: (out) (transfer none) (optional): Output location for the next #GFile, or %NULL
 * @cancellable: a #GCancellable
 * @error: a #GError
 *
 * This is a version of g_file_enumerator_next_file() that's easier to
 * use correctly from C programs.  With g_file_enumerator_next_file(),
 * the gboolean return value signifies "end of iteration or error", which
 * requires allocation of a temporary #GError.
 *
 * In contrast, with this function, a %FALSE return from
 * g_file_enumerator_iterate() *always* means
 * "error".  End of iteration is signaled by @out_info or @out_child being %NULL.
 *
 * Another crucial difference is that the references for @out_info and
 * @out_child are owned by @direnum (they are cached as hidden
 * properties).  You must not unref them in your own code.  This makes
 * memory management significantly easier for C code in combination
 * with loops.
 *
 * Finally, this function optionally allows retrieving a #GFile as
 * well.
 *
 * You must specify at least one of @out_info or @out_child.
 *
 * The code pattern for correctly using g_file_enumerator_iterate() from C
 * is:
 *
 * |[
 * direnum = g_file_enumerate_children (file, ...);
 * while (TRUE)
 *   {
 *     GFileInfo *info;
 *     if (!g_file_enumerator_iterate (direnum, &info, NULL, cancellable, error))
 *       goto out;
 *     if (!info)
 *       break;
 *     ... do stuff with "info"; do not unref it! ...
 *   }
 *
 * out:
 *   g_object_unref (direnum); // Note: frees the last @info
 * ]|
 *
 * Since: 2.44
 */


/**
 * g_file_enumerator_next_file:
 * @enumerator: a #GFileEnumerator.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Returns information for the next file in the enumerated object.
 * Will block until the information is available. The #GFileInfo
 * returned from this function will contain attributes that match the
 * attribute string that was passed when the #GFileEnumerator was created.
 *
 * See the documentation of #GFileEnumerator for information about the
 * order of returned files.
 *
 * On error, returns %NULL and sets @error to the error. If the
 * enumerator is at the end, %NULL will be returned and @error will
 * be unset.
 *
 * Returns: (nullable) (transfer full): A #GFileInfo or %NULL on error
 *    or end of enumerator.  Free the returned object with
 *    g_object_unref() when no longer needed.
 */


/**
 * g_file_enumerator_next_files_async:
 * @enumerator: a #GFileEnumerator.
 * @num_files: the number of file info objects to request
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Request information for a number of files from the enumerator asynchronously.
 * When all I/O for the operation is finished the @callback will be called with
 * the requested information.
 *
 * See the documentation of #GFileEnumerator for information about the
 * order of returned files.
 *
 * Once the end of the enumerator is reached, or if an error occurs, the
 * @callback will be called with an empty list. In this case, the previous call
 * to g_file_enumerator_next_files_async() will typically have returned fewer
 * than @num_files items.
 *
 * If a request is cancelled the callback will be called with
 * %G_IO_ERROR_CANCELLED.
 *
 * This leads to the following pseudo-code usage:
 * |[
 * g_autoptr(GFile) dir = get_directory ();
 * g_autoptr(GFileEnumerator) enumerator = NULL;
 * g_autolist(GFileInfo) files = NULL;
 * g_autoptr(GError) local_error = NULL;
 *
 * enumerator = yield g_file_enumerate_children_async (dir,
 *                                                     G_FILE_ATTRIBUTE_STANDARD_NAME ","
 *                                                     G_FILE_ATTRIBUTE_STANDARD_TYPE,
 *                                                     G_FILE_QUERY_INFO_NONE,
 *                                                     G_PRIORITY_DEFAULT,
 *                                                     cancellable,
 *                                                     …,
 *                                                     &local_error);
 * if (enumerator == NULL)
 *   g_error ("Error enumerating: %s", local_error->message);
 *
 * // Loop until no files are returned, either because the end of the enumerator
 * // has been reached, or an error was returned.
 * do
 *   {
 *     files = yield g_file_enumerator_next_files_async (enumerator,
 *                                                       5,  // number of files to request
 *                                                       G_PRIORITY_DEFAULT,
 *                                                       cancellable,
 *                                                       …,
 *                                                       &local_error);
 *
 *     // Process the returned files, but don’t assume that exactly 5 were returned.
 *     for (GList *l = files; l != NULL; l = l->next)
 *       {
 *         GFileInfo *info = l->data;
 *         handle_file_info (info);
 *       }
 *   }
 * while (files != NULL);
 *
 * if (local_error != NULL &&
 *     !g_error_matches (local_error, G_IO_ERROR, G_IO_ERROR_CANCELLED))
 *   g_error ("Error while enumerating: %s", local_error->message);
 * ]|
 *
 * During an async request no other sync and async calls are allowed, and will
 * result in %G_IO_ERROR_PENDING errors.
 *
 * Any outstanding I/O request with higher priority (lower numerical value) will
 * be executed before an outstanding request with lower priority. Default
 * priority is %G_PRIORITY_DEFAULT.
 */


/**
 * g_file_enumerator_next_files_finish:
 * @enumerator: a #GFileEnumerator.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes the asynchronous operation started with g_file_enumerator_next_files_async().
 *
 * Returns: (transfer full) (element-type Gio.FileInfo): a #GList of #GFileInfos. You must free the list with
 *     g_list_free() and unref the infos with g_object_unref() when you're
 *     done with them.
 */


/**
 * g_file_enumerator_set_pending:
 * @enumerator: a #GFileEnumerator.
 * @pending: a boolean value.
 *
 * Sets the file enumerator as having pending operations.
 */


/**
 * g_file_equal:
 * @file1: the first #GFile
 * @file2: the second #GFile
 *
 * Checks if the two given #GFiles refer to the same file.
 *
 * Note that two #GFiles that differ can still refer to the same
 * file on the filesystem due to various forms of filename
 * aliasing.
 *
 * This call does no blocking I/O.
 *
 * Returns: %TRUE if @file1 and @file2 are equal.
 */


/**
 * g_file_find_enclosing_mount:
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError
 *
 * Gets a #GMount for the #GFile.
 *
 * #GMount is returned only for user interesting locations, see
 * #GVolumeMonitor. If the #GFileIface for @file does not have a #mount,
 * @error will be set to %G_IO_ERROR_NOT_FOUND and %NULL #will be returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (transfer full): a #GMount where the @file is located
 *   or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_find_enclosing_mount_async:
 * @file: a #GFile
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously gets the mount for the file.
 *
 * For more details, see g_file_find_enclosing_mount() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_find_enclosing_mount_finish() to
 * get the result of the operation.
 */


/**
 * g_file_find_enclosing_mount_finish:
 * @file: a #GFile
 * @res: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an asynchronous find mount request.
 * See g_file_find_enclosing_mount_async().
 *
 * Returns: (transfer full): #GMount for given @file or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_get_basename: (virtual get_basename)
 * @file: input #GFile
 *
 * Gets the base name (the last component of the path) for a given #GFile.
 *
 * If called for the top level of a system (such as the filesystem root
 * or a uri like sftp://host/) it will return a single directory separator
 * (and on Windows, possibly a drive letter).
 *
 * The base name is a byte string (not UTF-8). It has no defined encoding
 * or rules other than it may not contain zero bytes.  If you want to use
 * filenames in a user interface you should use the display name that you
 * can get by requesting the %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME
 * attribute with g_file_query_info().
 *
 * This call does no blocking I/O.
 *
 * Returns: (type filename) (nullable): string containing the #GFile's
 *   base name, or %NULL if given #GFile is invalid. The returned string
 *   should be freed with g_free() when no longer needed.
 */


/**
 * g_file_get_child:
 * @file: input #GFile
 * @name: (type filename): string containing the child's basename
 *
 * Gets a child of @file with basename equal to @name.
 *
 * Note that the file with that specific name might not exist, but
 * you can still have a #GFile that points to it. You can use this
 * for instance to create that file.
 *
 * This call does no blocking I/O.
 *
 * Returns: (transfer full): a #GFile to a child specified by @name.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_get_child_for_display_name:
 * @file: input #GFile
 * @display_name: string to a possible child
 * @error: return location for an error
 *
 * Gets the child of @file for a given @display_name (i.e. a UTF-8
 * version of the name). If this function fails, it returns %NULL
 * and @error will be set. This is very useful when constructing a
 * #GFile for a new file and the user entered the filename in the
 * user interface, for instance when you select a directory and
 * type a filename in the file selector.
 *
 * This call does no blocking I/O.
 *
 * Returns: (transfer full): a #GFile to the specified child, or
 *   %NULL if the display name couldn't be converted.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_get_parent:
 * @file: input #GFile
 *
 * Gets the parent directory for the @file.
 * If the @file represents the root directory of the
 * file system, then %NULL will be returned.
 *
 * This call does no blocking I/O.
 *
 * Returns: (nullable) (transfer full): a #GFile structure to the
 *   parent of the given #GFile or %NULL if there is no parent. Free
 *   the returned object with g_object_unref().
 */


/**
 * g_file_get_parse_name:
 * @file: input #GFile
 *
 * Gets the parse name of the @file.
 * A parse name is a UTF-8 string that describes the
 * file such that one can get the #GFile back using
 * g_file_parse_name().
 *
 * This is generally used to show the #GFile as a nice
 * full-pathname kind of string in a user interface,
 * like in a location entry.
 *
 * For local files with names that can safely be converted
 * to UTF-8 the pathname is used, otherwise the IRI is used
 * (a form of URI that allows UTF-8 characters unescaped).
 *
 * This call does no blocking I/O.
 *
 * Returns: a string containing the #GFile's parse name.
 *   The returned string should be freed with g_free()
 *   when no longer needed.
 */


/**
 * g_file_get_path: (virtual get_path)
 * @file: input #GFile
 *
 * Gets the local pathname for #GFile, if one exists. If non-%NULL, this is
 * guaranteed to be an absolute, canonical path. It might contain symlinks.
 *
 * This call does no blocking I/O.
 *
 * Returns: (type filename) (nullable): string containing the #GFile's path,
 *   or %NULL if no such path exists. The returned string should be freed
 *   with g_free() when no longer needed.
 */


/**
 * g_file_get_relative_path: (virtual get_relative_path)
 * @parent: input #GFile
 * @descendant: input #GFile
 *
 * Gets the path for @descendant relative to @parent.
 *
 * This call does no blocking I/O.
 *
 * Returns: (type filename) (nullable): string with the relative path from
 *   @descendant to @parent, or %NULL if @descendant doesn't have @parent as
 *   prefix. The returned string should be freed with g_free() when
 *   no longer needed.
 */


/**
 * g_file_get_uri:
 * @file: input #GFile
 *
 * Gets the URI for the @file.
 *
 * This call does no blocking I/O.
 *
 * Returns: a string containing the #GFile's URI. If the #GFile was constructed
 *   with an invalid URI, an invalid URI is returned.
 *   The returned string should be freed with g_free()
 *   when no longer needed.
 */


/**
 * g_file_get_uri_scheme:
 * @file: input #GFile
 *
 * Gets the URI scheme for a #GFile.
 * RFC 3986 decodes the scheme as:
 * |[
 * URI = scheme ":" hier-part [ "?" query ] [ "#" fragment ]
 * ]|
 * Common schemes include "file", "http", "ftp", etc.
 *
 * The scheme can be different from the one used to construct the #GFile,
 * in that it might be replaced with one that is logically equivalent to the #GFile.
 *
 * This call does no blocking I/O.
 *
 * Returns: (nullable): a string containing the URI scheme for the given
 *   #GFile or %NULL if the #GFile was constructed with an invalid URI. The
 *   returned string should be freed with g_free() when no longer needed.
 */


/**
 * g_file_has_parent:
 * @file: input #GFile
 * @parent: (nullable): the parent to check for, or %NULL
 *
 * Checks if @file has a parent, and optionally, if it is @parent.
 *
 * If @parent is %NULL then this function returns %TRUE if @file has any
 * parent at all.  If @parent is non-%NULL then %TRUE is only returned
 * if @file is an immediate child of @parent.
 *
 * Returns: %TRUE if @file is an immediate child of @parent (or any parent in
 *   the case that @parent is %NULL).
 * Since: 2.24
 */


/**
 * g_file_has_prefix: (virtual prefix_matches)
 * @file: input #GFile
 * @prefix: input #GFile
 *
 * Checks whether @file has the prefix specified by @prefix.
 *
 * In other words, if the names of initial elements of @file's
 * pathname match @prefix. Only full pathname elements are matched,
 * so a path like /foo is not considered a prefix of /foobar, only
 * of /foo/bar.
 *
 * A #GFile is not a prefix of itself. If you want to check for
 * equality, use g_file_equal().
 *
 * This call does no I/O, as it works purely on names. As such it can
 * sometimes return %FALSE even if @file is inside a @prefix (from a
 * filesystem point of view), because the prefix of @file is an alias
 * of @prefix.
 *
 * Returns: %TRUE if the @file's parent, grandparent, etc is @prefix,
 *   %FALSE otherwise.
 */


/**
 * g_file_has_uri_scheme:
 * @file: input #GFile
 * @uri_scheme: a string containing a URI scheme
 *
 * Checks to see if a #GFile has a given URI scheme.
 *
 * This call does no blocking I/O.
 *
 * Returns: %TRUE if #GFile's backend supports the
 *   given URI scheme, %FALSE if URI scheme is %NULL,
 *   not supported, or #GFile is invalid.
 */


/**
 * g_file_hash: (virtual hash)
 * @file: (type GFile): #gconstpointer to a #GFile
 *
 * Creates a hash value for a #GFile.
 *
 * This call does no blocking I/O.
 *
 * Returns: 0 if @file is not a valid #GFile, otherwise an
 *   integer that can be used as hash value for the #GFile.
 *   This function is intended for easily hashing a #GFile to
 *   add to a #GHashTable or similar data structure.
 */


/**
 * g_file_icon_get_file:
 * @icon: a #GIcon.
 *
 * Gets the #GFile associated with the given @icon.
 *
 * Returns: (transfer none): a #GFile.
 */


/**
 * g_file_icon_new:
 * @file: a #GFile.
 *
 * Creates a new icon for a file.
 *
 * Returns: (transfer full) (type GFileIcon): a #GIcon for the given
 *   @file, or %NULL on error.
 */


/**
 * g_file_info_clear_status:
 * @info: a #GFileInfo.
 *
 * Clears the status information from @info.
 */


/**
 * g_file_info_copy_into:
 * @src_info: source to copy attributes from.
 * @dest_info: destination to copy attributes to.
 *
 * First clears all of the [GFileAttribute][gio-GFileAttribute] of @dest_info,
 * and then copies all of the file attributes from @src_info to @dest_info.
 */


/**
 * g_file_info_dup:
 * @other: a #GFileInfo.
 *
 * Duplicates a file info structure.
 *
 * Returns: (transfer full): a duplicate #GFileInfo of @other.
 */


/**
 * g_file_info_get_access_date_time:
 * @info: a #GFileInfo.
 *
 * Gets the access time of the current @info and returns it as a
 * #GDateTime.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_TIME_ACCESS. If %G_FILE_ATTRIBUTE_TIME_ACCESS_USEC is
 * provided, the resulting #GDateTime will additionally have microsecond
 * precision.
 *
 * If nanosecond precision is needed, %G_FILE_ATTRIBUTE_TIME_ACCESS_NSEC must
 * be queried separately using g_file_info_get_attribute_uint32().
 *
 * Returns: (transfer full) (nullable): access time, or %NULL if unknown
 * Since: 2.70
 */


/**
 * g_file_info_get_attribute_as_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of an attribute, formatted as a string.
 * This escapes things as needed to make the string valid
 * UTF-8.
 *
 * Returns: (nullable): a UTF-8 string associated with the given @attribute, or
 *    %NULL if the attribute wasn’t set.
 *    When you're done with the string it must be freed with g_free().
 */


/**
 * g_file_info_get_attribute_boolean:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a boolean attribute. If the attribute does not
 * contain a boolean value, %FALSE will be returned.
 *
 * Returns: the boolean value contained within the attribute.
 */


/**
 * g_file_info_get_attribute_byte_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a byte string attribute. If the attribute does
 * not contain a byte string, %NULL will be returned.
 *
 * Returns: (nullable): the contents of the @attribute value as a byte string, or
 * %NULL otherwise.
 */


/**
 * g_file_info_get_attribute_data:
 * @info: a #GFileInfo
 * @attribute: a file attribute key
 * @type: (out) (optional): return location for the attribute type, or %NULL
 * @value_pp: (out) (optional) (not nullable): return location for the
 *    attribute value, or %NULL; the attribute value will not be %NULL
 * @status: (out) (optional): return location for the attribute status, or %NULL
 *
 * Gets the attribute type, value and status for an attribute key.
 *
 * Returns: (transfer none): %TRUE if @info has an attribute named @attribute,
 *      %FALSE otherwise.
 */


/**
 * g_file_info_get_attribute_file_path:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a byte string attribute as a file path.
 *
 * If the attribute does not contain a byte string, `NULL` will be returned.
 *
 * This function is meant to be used by language bindings that have specific
 * handling for Unix paths.
 *
 * Returns: (type filename) (nullable): the contents of the @attribute value as
 * a file path, or %NULL otherwise.
 * Since: 2.78
 */


/**
 * g_file_info_get_attribute_int32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets a signed 32-bit integer contained within the attribute. If the
 * attribute does not contain a signed 32-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: a signed 32-bit integer from the attribute.
 */


/**
 * g_file_info_get_attribute_int64:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets a signed 64-bit integer contained within the attribute. If the
 * attribute does not contain a signed 64-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: a signed 64-bit integer from the attribute.
 */


/**
 * g_file_info_get_attribute_object:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a #GObject attribute. If the attribute does
 * not contain a #GObject, %NULL will be returned.
 *
 * Returns: (transfer none) (nullable): a #GObject associated with the given @attribute,
 * or %NULL otherwise.
 */


/**
 * g_file_info_get_attribute_status:
 * @info: a #GFileInfo
 * @attribute: a file attribute key
 *
 * Gets the attribute status for an attribute key.
 *
 * Returns: a #GFileAttributeStatus for the given @attribute, or
 *    %G_FILE_ATTRIBUTE_STATUS_UNSET if the key is invalid.
 */


/**
 * g_file_info_get_attribute_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a string attribute. If the attribute does
 * not contain a string, %NULL will be returned.
 *
 * Returns: (nullable): the contents of the @attribute value as a UTF-8 string,
 * or %NULL otherwise.
 */


/**
 * g_file_info_get_attribute_stringv:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a stringv attribute. If the attribute does
 * not contain a stringv, %NULL will be returned.
 *
 * Returns: (transfer none) (nullable): the contents of the @attribute value as a stringv,
 * or %NULL otherwise. Do not free. These returned strings are UTF-8.
 * Since: 2.22
 */


/**
 * g_file_info_get_attribute_type:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the attribute type for an attribute key.
 *
 * Returns: a #GFileAttributeType for the given @attribute, or
 * %G_FILE_ATTRIBUTE_TYPE_INVALID if the key is not set.
 */


/**
 * g_file_info_get_attribute_uint32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets an unsigned 32-bit integer contained within the attribute. If the
 * attribute does not contain an unsigned 32-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: an unsigned 32-bit integer from the attribute.
 */


/**
 * g_file_info_get_attribute_uint64:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets a unsigned 64-bit integer contained within the attribute. If the
 * attribute does not contain an unsigned 64-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: a unsigned 64-bit integer from the attribute.
 */


/**
 * g_file_info_get_content_type:
 * @info: a #GFileInfo.
 *
 * Gets the file's content type.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE.
 *
 * Returns: (nullable): a string containing the file's content type,
 * or %NULL if unknown.
 */


/**
 * g_file_info_get_creation_date_time:
 * @info: a #GFileInfo.
 *
 * Gets the creation time of the current @info and returns it as a
 * #GDateTime.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_TIME_CREATED. If %G_FILE_ATTRIBUTE_TIME_CREATED_USEC is
 * provided, the resulting #GDateTime will additionally have microsecond
 * precision.
 *
 * If nanosecond precision is needed, %G_FILE_ATTRIBUTE_TIME_CREATED_NSEC must
 * be queried separately using g_file_info_get_attribute_uint32().
 *
 * Returns: (transfer full) (nullable): creation time, or %NULL if unknown
 * Since: 2.70
 */


/**
 * g_file_info_get_deletion_date:
 * @info: a #GFileInfo.
 *
 * Returns the #GDateTime representing the deletion date of the file, as
 * available in %G_FILE_ATTRIBUTE_TRASH_DELETION_DATE. If the
 * %G_FILE_ATTRIBUTE_TRASH_DELETION_DATE attribute is unset, %NULL is returned.
 *
 * Returns: (nullable): a #GDateTime, or %NULL.
 * Since: 2.36
 */


/**
 * g_file_info_get_display_name:
 * @info: a #GFileInfo.
 *
 * Gets a display name for a file. This is guaranteed to always be set.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME.
 *
 * Returns: (not nullable): a string containing the display name.
 */


/**
 * g_file_info_get_edit_name:
 * @info: a #GFileInfo.
 *
 * Gets the edit name for a file.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME.
 *
 * Returns: a string containing the edit name.
 */


/**
 * g_file_info_get_etag:
 * @info: a #GFileInfo.
 *
 * Gets the [entity tag][gfile-etag] for a given
 * #GFileInfo. See %G_FILE_ATTRIBUTE_ETAG_VALUE.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_ETAG_VALUE.
 *
 * Returns: (nullable): a string containing the value of the "etag:value" attribute.
 */


/**
 * g_file_info_get_file_type:
 * @info: a #GFileInfo.
 *
 * Gets a file's type (whether it is a regular file, symlink, etc).
 * This is different from the file's content type, see g_file_info_get_content_type().
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_TYPE.
 *
 * Returns: a #GFileType for the given file.
 */


/**
 * g_file_info_get_icon:
 * @info: a #GFileInfo.
 *
 * Gets the icon for a file.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_ICON.
 *
 * Returns: (nullable) (transfer none): #GIcon for the given @info.
 */


/**
 * g_file_info_get_is_backup:
 * @info: a #GFileInfo.
 *
 * Checks if a file is a backup file.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP.
 *
 * Returns: %TRUE if file is a backup file, %FALSE otherwise.
 */


/**
 * g_file_info_get_is_hidden:
 * @info: a #GFileInfo.
 *
 * Checks if a file is hidden.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN.
 *
 * Returns: %TRUE if the file is a hidden file, %FALSE otherwise.
 */


/**
 * g_file_info_get_is_symlink:
 * @info: a #GFileInfo.
 *
 * Checks if a file is a symlink.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK.
 *
 * Returns: %TRUE if the given @info is a symlink.
 */


/**
 * g_file_info_get_modification_date_time:
 * @info: a #GFileInfo.
 *
 * Gets the modification time of the current @info and returns it as a
 * #GDateTime.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_TIME_MODIFIED. If %G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC is
 * provided, the resulting #GDateTime will additionally have microsecond
 * precision.
 *
 * If nanosecond precision is needed, %G_FILE_ATTRIBUTE_TIME_MODIFIED_NSEC must
 * be queried separately using g_file_info_get_attribute_uint32().
 *
 * Returns: (transfer full) (nullable): modification time, or %NULL if unknown
 * Since: 2.62
 */


/**
 * g_file_info_get_modification_time:
 * @info: a #GFileInfo.
 * @result: (out caller-allocates): a #GTimeVal.
 *
 * Gets the modification time of the current @info and sets it
 * in @result.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_TIME_MODIFIED. If %G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC is
 * provided it will be used too.
 *
 * Deprecated: 2.62: Use g_file_info_get_modification_date_time() instead, as
 *    #GTimeVal is deprecated due to the year 2038 problem.
 */


/**
 * g_file_info_get_name:
 * @info: a #GFileInfo.
 *
 * Gets the name for a file. This is guaranteed to always be set.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_NAME.
 *
 * Returns: (type filename) (not nullable): a string containing the file name.
 */


/**
 * g_file_info_get_size:
 * @info: a #GFileInfo.
 *
 * Gets the file's size (in bytes). The size is retrieved through the value of
 * the %G_FILE_ATTRIBUTE_STANDARD_SIZE attribute and is converted
 * from #guint64 to #goffset before returning the result.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_SIZE.
 *
 * Returns: a #goffset containing the file's size (in bytes).
 */


/**
 * g_file_info_get_sort_order:
 * @info: a #GFileInfo.
 *
 * Gets the value of the sort_order attribute from the #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER.
 *
 * Returns: a #gint32 containing the value of the "standard::sort_order" attribute.
 */


/**
 * g_file_info_get_symbolic_icon:
 * @info: a #GFileInfo.
 *
 * Gets the symbolic icon for a file.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON.
 *
 * Returns: (nullable) (transfer none): #GIcon for the given @info.
 * Since: 2.34
 */


/**
 * g_file_info_get_symlink_target:
 * @info: a #GFileInfo.
 *
 * Gets the symlink target for a given #GFileInfo.
 *
 * It is an error to call this if the #GFileInfo does not contain
 * %G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET.
 *
 * Returns: (type filename) (nullable): a string containing the symlink target.
 */


/**
 * g_file_info_has_attribute:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Checks if a file info structure has an attribute named @attribute.
 *
 * Returns: %TRUE if @info has an attribute named @attribute,
 *     %FALSE otherwise.
 */


/**
 * g_file_info_has_namespace:
 * @info: a #GFileInfo.
 * @name_space: a file attribute namespace.
 *
 * Checks if a file info structure has an attribute in the
 * specified @name_space.
 *
 * Returns: %TRUE if @info has an attribute in @name_space,
 *     %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_file_info_list_attributes:
 * @info: a #GFileInfo.
 * @name_space: (nullable): a file attribute key's namespace, or %NULL to list
 *   all attributes.
 *
 * Lists the file info structure's attributes.
 *
 * Returns: (nullable) (array zero-terminated=1) (transfer full): a
 * null-terminated array of strings of all of the possible attribute
 * types for the given @name_space, or %NULL on error.
 */


/**
 * g_file_info_new:
 *
 * Creates a new file info structure.
 *
 * Returns: a #GFileInfo.
 */


/**
 * g_file_info_remove_attribute:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Removes all cases of @attribute from @info if it exists.
 */


/**
 * g_file_info_set_access_date_time:
 * @info: a #GFileInfo.
 * @atime: (not nullable): a #GDateTime.
 *
 * Sets the %G_FILE_ATTRIBUTE_TIME_ACCESS and
 * %G_FILE_ATTRIBUTE_TIME_ACCESS_USEC attributes in the file info to the
 * given date/time value.
 *
 * %G_FILE_ATTRIBUTE_TIME_ACCESS_NSEC will be cleared.
 *
 * Since: 2.70
 */


/**
 * g_file_info_set_attribute:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @type: a #GFileAttributeType
 * @value_p: (not nullable): pointer to the value
 *
 * Sets the @attribute to contain the given value, if possible. To unset the
 * attribute, use %G_FILE_ATTRIBUTE_TYPE_INVALID for @type.
 */


/**
 * g_file_info_set_attribute_boolean:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a boolean value.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_byte_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a byte string.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_file_path:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: (type filename): a file path.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 *
 * This function is meant to be used by language bindings that have specific
 * handling for Unix paths.
 *
 * Since: 2.78
 */


/**
 * g_file_info_set_attribute_int32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a signed 32-bit integer
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_int64:
 * @info: a #GFileInfo.
 * @attribute: attribute name to set.
 * @attr_value: int64 value to set attribute to.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_mask:
 * @info: a #GFileInfo.
 * @mask: a #GFileAttributeMatcher.
 *
 * Sets @mask on @info to match specific attribute types.
 */


/**
 * g_file_info_set_attribute_object:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a #GObject.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_status:
 * @info: a #GFileInfo
 * @attribute: a file attribute key
 * @status: a #GFileAttributeStatus
 *
 * Sets the attribute status for an attribute key. This is only
 * needed by external code that implement g_file_set_attributes_from_info()
 * or similar functions.
 *
 * The attribute must exist in @info for this to work. Otherwise %FALSE
 * is returned and @info is unchanged.
 *
 * Returns: %TRUE if the status was changed, %FALSE if the key was not set.
 * Since: 2.22
 */


/**
 * g_file_info_set_attribute_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a UTF-8 string.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_stringv:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key
 * @attr_value: (array zero-terminated=1) (element-type utf8): a %NULL
 *   terminated array of UTF-8 strings.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 *
 * Sinze: 2.22
 */


/**
 * g_file_info_set_attribute_uint32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: an unsigned 32-bit integer.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_uint64:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: an unsigned 64-bit integer.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_content_type:
 * @info: a #GFileInfo.
 * @content_type: a content type. See [GContentType][gio-GContentType]
 *
 * Sets the content type attribute for a given #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE.
 */


/**
 * g_file_info_set_creation_date_time:
 * @info: a #GFileInfo.
 * @creation_time: (not nullable): a #GDateTime.
 *
 * Sets the %G_FILE_ATTRIBUTE_TIME_CREATED and
 * %G_FILE_ATTRIBUTE_TIME_CREATED_USEC attributes in the file info to the
 * given date/time value.
 *
 * %G_FILE_ATTRIBUTE_TIME_CREATED_NSEC will be cleared.
 *
 * Since: 2.70
 */


/**
 * g_file_info_set_display_name:
 * @info: a #GFileInfo.
 * @display_name: a string containing a display name.
 *
 * Sets the display name for the current #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME.
 */


/**
 * g_file_info_set_edit_name:
 * @info: a #GFileInfo.
 * @edit_name: a string containing an edit name.
 *
 * Sets the edit name for the current file.
 * See %G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME.
 */


/**
 * g_file_info_set_file_type:
 * @info: a #GFileInfo.
 * @type: a #GFileType.
 *
 * Sets the file type in a #GFileInfo to @type.
 * See %G_FILE_ATTRIBUTE_STANDARD_TYPE.
 */


/**
 * g_file_info_set_icon:
 * @info: a #GFileInfo.
 * @icon: a #GIcon.
 *
 * Sets the icon for a given #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_ICON.
 */


/**
 * g_file_info_set_is_hidden:
 * @info: a #GFileInfo.
 * @is_hidden: a #gboolean.
 *
 * Sets the "is_hidden" attribute in a #GFileInfo according to @is_hidden.
 * See %G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN.
 */


/**
 * g_file_info_set_is_symlink:
 * @info: a #GFileInfo.
 * @is_symlink: a #gboolean.
 *
 * Sets the "is_symlink" attribute in a #GFileInfo according to @is_symlink.
 * See %G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK.
 */


/**
 * g_file_info_set_modification_date_time:
 * @info: a #GFileInfo.
 * @mtime: (not nullable): a #GDateTime.
 *
 * Sets the %G_FILE_ATTRIBUTE_TIME_MODIFIED and
 * %G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC attributes in the file info to the
 * given date/time value.
 *
 * %G_FILE_ATTRIBUTE_TIME_MODIFIED_NSEC will be cleared.
 *
 * Since: 2.62
 */


/**
 * g_file_info_set_modification_time:
 * @info: a #GFileInfo.
 * @mtime: a #GTimeVal.
 *
 * Sets the %G_FILE_ATTRIBUTE_TIME_MODIFIED and
 * %G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC attributes in the file info to the
 * given time value.
 *
 * %G_FILE_ATTRIBUTE_TIME_MODIFIED_NSEC will be cleared.
 *
 * Deprecated: 2.62: Use g_file_info_set_modification_date_time() instead, as
 *    #GTimeVal is deprecated due to the year 2038 problem.
 */


/**
 * g_file_info_set_name:
 * @info: a #GFileInfo.
 * @name: (type filename): a string containing a name.
 *
 * Sets the name attribute for the current #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_NAME.
 */


/**
 * g_file_info_set_size:
 * @info: a #GFileInfo.
 * @size: a #goffset containing the file's size.
 *
 * Sets the %G_FILE_ATTRIBUTE_STANDARD_SIZE attribute in the file info
 * to the given size.
 */


/**
 * g_file_info_set_sort_order:
 * @info: a #GFileInfo.
 * @sort_order: a sort order integer.
 *
 * Sets the sort order attribute in the file info structure. See
 * %G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER.
 */


/**
 * g_file_info_set_symbolic_icon:
 * @info: a #GFileInfo.
 * @icon: a #GIcon.
 *
 * Sets the symbolic icon for a given #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_SYMBOLIC_ICON.
 *
 * Since: 2.34
 */


/**
 * g_file_info_set_symlink_target:
 * @info: a #GFileInfo.
 * @symlink_target: (type filename): a static string containing a path to a symlink target.
 *
 * Sets the %G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET attribute in the file info
 * to the given symlink target.
 */


/**
 * g_file_info_unset_attribute_mask:
 * @info: #GFileInfo.
 *
 * Unsets a mask set by g_file_info_set_attribute_mask(), if one
 * is set.
 */


/**
 * g_file_input_stream_query_info:
 * @stream: a #GFileInputStream.
 * @attributes: a file attribute query string.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Queries a file input stream the given @attributes. This function blocks
 * while querying the stream. For the asynchronous (non-blocking) version
 * of this function, see g_file_input_stream_query_info_async(). While the
 * stream is blocked, the stream will set the pending flag internally, and
 * any other operations on the stream will fail with %G_IO_ERROR_PENDING.
 *
 * Returns: (transfer full): a #GFileInfo, or %NULL on error.
 */


/**
 * g_file_input_stream_query_info_async:
 * @stream: a #GFileInputStream.
 * @attributes: a file attribute query string.
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Queries the stream information asynchronously.
 * When the operation is finished @callback will be called.
 * You can then call g_file_input_stream_query_info_finish()
 * to get the result of the operation.
 *
 * For the synchronous version of this function,
 * see g_file_input_stream_query_info().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set
 */


/**
 * g_file_input_stream_query_info_finish:
 * @stream: a #GFileInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring,
 *     or %NULL to ignore.
 *
 * Finishes an asynchronous info query operation.
 *
 * Returns: (transfer full): #GFileInfo.
 */


/**
 * g_file_io_stream_get_etag:
 * @stream: a #GFileIOStream.
 *
 * Gets the entity tag for the file when it has been written.
 * This must be called after the stream has been written
 * and closed, as the etag can change while writing.
 *
 * Returns: (nullable) (transfer full): the entity tag for the stream.
 * Since: 2.22
 */


/**
 * g_file_io_stream_query_info:
 * @stream: a #GFileIOStream.
 * @attributes: a file attribute query string.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Queries a file io stream for the given @attributes.
 * This function blocks while querying the stream. For the asynchronous
 * version of this function, see g_file_io_stream_query_info_async().
 * While the stream is blocked, the stream will set the pending flag
 * internally, and any other operations on the stream will fail with
 * %G_IO_ERROR_PENDING.
 *
 * Can fail if the stream was already closed (with @error being set to
 * %G_IO_ERROR_CLOSED), the stream has pending operations (with @error being
 * set to %G_IO_ERROR_PENDING), or if querying info is not supported for
 * the stream's interface (with @error being set to %G_IO_ERROR_NOT_SUPPORTED). I
 * all cases of failure, %NULL will be returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set, and %NULL will
 * be returned.
 *
 * Returns: (transfer full): a #GFileInfo for the @stream, or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_io_stream_query_info_async:
 * @stream: a #GFileIOStream.
 * @attributes: a file attribute query string.
 * @io_priority: the [I/O priority][gio-GIOScheduler] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously queries the @stream for a #GFileInfo. When completed,
 * @callback will be called with a #GAsyncResult which can be used to
 * finish the operation with g_file_io_stream_query_info_finish().
 *
 * For the synchronous version of this function, see
 * g_file_io_stream_query_info().
 *
 * Since: 2.22
 */


/**
 * g_file_io_stream_query_info_finish:
 * @stream: a #GFileIOStream.
 * @result: a #GAsyncResult.
 * @error: a #GError, %NULL to ignore.
 *
 * Finalizes the asynchronous query started
 * by g_file_io_stream_query_info_async().
 *
 * Returns: (transfer full): A #GFileInfo for the finished query.
 * Since: 2.22
 */


/**
 * g_file_is_native:
 * @file: input #GFile
 *
 * Checks to see if a file is native to the platform.
 *
 * A native file is one expressed in the platform-native filename format,
 * e.g. "C:\Windows" or "/usr/bin/". This does not mean the file is local,
 * as it might be on a locally mounted remote filesystem.
 *
 * On some systems non-native files may be available using the native
 * filesystem via a userspace filesystem (FUSE), in these cases this call
 * will return %FALSE, but g_file_get_path() will still return a native path.
 *
 * This call does no blocking I/O.
 *
 * Returns: %TRUE if @file is native
 */


/**
 * g_file_load_bytes:
 * @file: a #GFile
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @etag_out: (out) (nullable) (optional): a location to place the current
 *   entity tag for the file, or %NULL if the entity tag is not needed
 * @error: a location for a #GError or %NULL
 *
 * Loads the contents of @file and returns it as #GBytes.
 *
 * If @file is a resource:// based URI, the resulting bytes will reference the
 * embedded resource instead of a copy. Otherwise, this is equivalent to calling
 * g_file_load_contents() and g_bytes_new_take().
 *
 * For resources, @etag_out will be set to %NULL.
 *
 * The data contained in the resulting #GBytes is always zero-terminated, but
 * this is not included in the #GBytes length. The resulting #GBytes should be
 * freed with g_bytes_unref() when no longer in use.
 *
 * Returns: (transfer full): a #GBytes or %NULL and @error is set
 * Since: 2.56
 */


/**
 * g_file_load_bytes_async:
 * @file: a #GFile
 * @cancellable: (nullable): a #GCancellable or %NULL
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously loads the contents of @file as #GBytes.
 *
 * If @file is a resource:// based URI, the resulting bytes will reference the
 * embedded resource instead of a copy. Otherwise, this is equivalent to calling
 * g_file_load_contents_async() and g_bytes_new_take().
 *
 * @callback should call g_file_load_bytes_finish() to get the result of this
 * asynchronous operation.
 *
 * See g_file_load_bytes() for more information.
 *
 * Since: 2.56
 */


/**
 * g_file_load_bytes_finish:
 * @file: a #GFile
 * @result: a #GAsyncResult provided to the callback
 * @etag_out: (out) (nullable) (optional): a location to place the current
 *   entity tag for the file, or %NULL if the entity tag is not needed
 * @error: a location for a #GError, or %NULL
 *
 * Completes an asynchronous request to g_file_load_bytes_async().
 *
 * For resources, @etag_out will be set to %NULL.
 *
 * The data contained in the resulting #GBytes is always zero-terminated, but
 * this is not included in the #GBytes length. The resulting #GBytes should be
 * freed with g_bytes_unref() when no longer in use.
 *
 * See g_file_load_bytes() for more information.
 *
 * Returns: (transfer full): a #GBytes or %NULL and @error is set
 * Since: 2.56
 */


/**
 * g_file_load_contents:
 * @file: input #GFile
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @contents: (out) (transfer full) (element-type guint8) (array length=length): a location to place the contents of the file
 * @length: (out) (optional): a location to place the length of the contents of the file,
 *   or %NULL if the length is not needed
 * @etag_out: (out) (optional) (nullable): a location to place the current entity tag for the file,
 *   or %NULL if the entity tag is not needed
 * @error: a #GError, or %NULL
 *
 * Loads the content of the file into memory. The data is always
 * zero-terminated, but this is not included in the resultant @length.
 * The returned @contents should be freed with g_free() when no longer
 * needed.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @file's contents were successfully loaded.
 *   %FALSE if there were errors.
 */


/**
 * g_file_load_contents_async:
 * @file: input #GFile
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts an asynchronous load of the @file's contents.
 *
 * For more details, see g_file_load_contents() which is
 * the synchronous version of this call.
 *
 * When the load operation has completed, @callback will be called
 * with @user data. To finish the operation, call
 * g_file_load_contents_finish() with the #GAsyncResult returned by
 * the @callback.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 */


/**
 * g_file_load_contents_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @contents: (out) (transfer full) (element-type guint8) (array length=length): a location to place the contents of the file
 * @length: (out) (optional): a location to place the length of the contents of the file,
 *   or %NULL if the length is not needed
 * @etag_out: (out) (optional) (nullable): a location to place the current entity tag for the file,
 *   or %NULL if the entity tag is not needed
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous load of the @file's contents.
 * The contents are placed in @contents, and @length is set to the
 * size of the @contents string. The @contents should be freed with
 * g_free() when no longer needed. If @etag_out is present, it will be
 * set to the new entity tag for the @file.
 *
 * Returns: %TRUE if the load was successful. If %FALSE and @error is
 *   present, it will be set appropriately.
 */


/**
 * g_file_load_partial_contents_async: (skip)
 * @file: input #GFile
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @read_more_callback: (scope call) (closure user_data): a
 *   #GFileReadMoreCallback to receive partial data
 *   and to specify whether further data should be read
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback to call
 *   when the request is satisfied
 * @user_data: the data to pass to the callback functions
 *
 * Reads the partial contents of a file. A #GFileReadMoreCallback should
 * be used to stop reading from the file when appropriate, else this
 * function will behave exactly as g_file_load_contents_async(). This
 * operation can be finished by g_file_load_partial_contents_finish().
 *
 * Users of this function should be aware that @user_data is passed to
 * both the @read_more_callback and the @callback.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 */


/**
 * g_file_load_partial_contents_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @contents: (out) (transfer full) (element-type guint8) (array length=length): a location to place the contents of the file
 * @length: (out) (optional): a location to place the length of the contents of the file,
 *   or %NULL if the length is not needed
 * @etag_out: (out) (optional) (nullable): a location to place the current entity tag for the file,
 *   or %NULL if the entity tag is not needed
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous partial load operation that was started
 * with g_file_load_partial_contents_async(). The data is always
 * zero-terminated, but this is not included in the resultant @length.
 * The returned @contents should be freed with g_free() when no longer
 * needed.
 *
 * Returns: %TRUE if the load was successful. If %FALSE and @error is
 *   present, it will be set appropriately.
 */


/**
 * g_file_make_directory:
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Creates a directory. Note that this will only create a child directory
 * of the immediate parent directory of the path or URI given by the #GFile.
 * To recursively create directories, see g_file_make_directory_with_parents().
 * This function will fail if the parent directory does not exist, setting
 * @error to %G_IO_ERROR_NOT_FOUND. If the file system doesn't support
 * creating directories, this function will fail, setting @error to
 * %G_IO_ERROR_NOT_SUPPORTED.
 *
 * For a local #GFile the newly created directory will have the default
 * (current) ownership and permissions of the current process.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on successful creation, %FALSE otherwise.
 */


/**
 * g_file_make_directory_async: (virtual make_directory_async)
 * @file: input #GFile
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call
 *   when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously creates a directory.
 *
 * Since: 2.38
 */


/**
 * g_file_make_directory_finish: (virtual make_directory_finish)
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous directory creation, started with
 * g_file_make_directory_async().
 *
 * Returns: %TRUE on successful directory creation, %FALSE otherwise.
 * Since: 2.38
 */


/**
 * g_file_make_directory_with_parents:
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Creates a directory and any parent directories that may not
 * exist similar to 'mkdir -p'. If the file system does not support
 * creating directories, this function will fail, setting @error to
 * %G_IO_ERROR_NOT_SUPPORTED. If the directory itself already exists,
 * this function will fail setting @error to %G_IO_ERROR_EXISTS, unlike
 * the similar g_mkdir_with_parents().
 *
 * For a local #GFile the newly created directories will have the default
 * (current) ownership and permissions of the current process.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if all directories have been successfully created, %FALSE
 * otherwise.
 * Since: 2.18
 */


/**
 * g_file_make_symbolic_link:
 * @file: a #GFile with the name of the symlink to create
 * @symlink_value: (type filename): a string with the path for the target
 *   of the new symlink
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError
 *
 * Creates a symbolic link named @file which contains the string
 * @symlink_value.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on the creation of a new symlink, %FALSE otherwise.
 */


/**
 * g_file_make_symbolic_link_async: (virtual make_symbolic_link_async)
 * @file: a #GFile with the name of the symlink to create
 * @symlink_value: (type filename): a string with the path for the target
 *   of the new symlink
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call
 *   when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously creates a symbolic link named @file which contains the
 * string @symlink_value.
 *
 * Since: 2.74
 */


/**
 * g_file_make_symbolic_link_finish: (virtual make_symbolic_link_finish)
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous symbolic link creation, started with
 * g_file_make_symbolic_link_async().
 *
 * Returns: %TRUE on successful directory creation, %FALSE otherwise.
 * Since: 2.74
 */


/**
 * g_file_measure_disk_usage:
 * @file: a #GFile
 * @flags: #GFileMeasureFlags
 * @cancellable: (nullable): optional #GCancellable
 * @progress_callback: (nullable): a #GFileMeasureProgressCallback
 * @progress_data: user_data for @progress_callback
 * @disk_usage: (out) (optional): the number of bytes of disk space used
 * @num_dirs: (out) (optional): the number of directories encountered
 * @num_files: (out) (optional): the number of non-directories encountered
 * @error: (nullable): %NULL, or a pointer to a %NULL #GError pointer
 *
 * Recursively measures the disk usage of @file.
 *
 * This is essentially an analog of the 'du' command, but it also
 * reports the number of directories and non-directory files encountered
 * (including things like symbolic links).
 *
 * By default, errors are only reported against the toplevel file
 * itself.  Errors found while recursing are silently ignored, unless
 * %G_FILE_MEASURE_REPORT_ANY_ERROR is given in @flags.
 *
 * The returned size, @disk_usage, is in bytes and should be formatted
 * with g_format_size() in order to get something reasonable for showing
 * in a user interface.
 *
 * @progress_callback and @progress_data can be given to request
 * periodic progress updates while scanning.  See the documentation for
 * #GFileMeasureProgressCallback for information about when and how the
 * callback will be invoked.
 *
 * Returns: %TRUE if successful, with the out parameters set.
 *   %FALSE otherwise, with @error set.
 * Since: 2.38
 */


/**
 * g_file_measure_disk_usage_async:
 * @file: a #GFile
 * @flags: #GFileMeasureFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable
 * @progress_callback: (nullable): a #GFileMeasureProgressCallback
 * @progress_data: user_data for @progress_callback
 * @callback: (nullable): a #GAsyncReadyCallback to call when complete
 * @user_data: the data to pass to callback function
 *
 * Recursively measures the disk usage of @file.
 *
 * This is the asynchronous version of g_file_measure_disk_usage().  See
 * there for more information.
 *
 * Since: 2.38
 */


/**
 * g_file_measure_disk_usage_finish:
 * @file: a #GFile
 * @result: the #GAsyncResult passed to your #GAsyncReadyCallback
 * @disk_usage: (out) (optional): the number of bytes of disk space used
 * @num_dirs: (out) (optional): the number of directories encountered
 * @num_files: (out) (optional): the number of non-directories encountered
 * @error: (nullable): %NULL, or a pointer to a %NULL #GError pointer
 *
 * Collects the results from an earlier call to
 * g_file_measure_disk_usage_async().  See g_file_measure_disk_usage() for
 * more information.
 *
 * Returns: %TRUE if successful, with the out parameters set.
 *   %FALSE otherwise, with @error set.
 * Since: 2.38
 */


/**
 * g_file_monitor:
 * @file: input #GFile
 * @flags: a set of #GFileMonitorFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Obtains a file or directory monitor for the given file,
 * depending on the type of the file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (transfer full): a #GFileMonitor for the given @file,
 *   or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.18
 */


/**
 * g_file_monitor_cancel:
 * @monitor: a #GFileMonitor.
 *
 * Cancels a file monitor.
 *
 * Returns: always %TRUE
 */


/**
 * g_file_monitor_directory: (virtual monitor_dir)
 * @file: input #GFile
 * @flags: a set of #GFileMonitorFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Obtains a directory monitor for the given file.
 * This may fail if directory monitoring is not supported.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * It does not make sense for @flags to contain
 * %G_FILE_MONITOR_WATCH_HARD_LINKS, since hard links can not be made to
 * directories.  It is not possible to monitor all the files in a
 * directory for changes made via hard links; if you want to do this then
 * you must register individual watches with g_file_monitor().
 *
 * Returns: (transfer full): a #GFileMonitor for the given @file,
 *   or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_monitor_emit_event:
 * @monitor: a #GFileMonitor.
 * @child: a #GFile.
 * @other_file: a #GFile.
 * @event_type: a set of #GFileMonitorEvent flags.
 *
 * Emits the #GFileMonitor::changed signal if a change
 * has taken place. Should be called from file monitor
 * implementations only.
 *
 * Implementations are responsible to call this method from the
 * [thread-default main context][g-main-context-push-thread-default] of the
 * thread that the monitor was created in.
 */


/**
 * g_file_monitor_file:
 * @file: input #GFile
 * @flags: a set of #GFileMonitorFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Obtains a file monitor for the given file. If no file notification
 * mechanism exists, then regular polling of the file is used.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @flags contains %G_FILE_MONITOR_WATCH_HARD_LINKS then the monitor
 * will also attempt to report changes made to the file via another
 * filename (ie, a hard link). Without this flag, you can only rely on
 * changes made through the filename contained in @file to be
 * reported. Using this flag may result in an increase in resource
 * usage, and may not have any effect depending on the #GFileMonitor
 * backend and/or filesystem type.
 *
 * Returns: (transfer full): a #GFileMonitor for the given @file,
 *   or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_monitor_is_cancelled:
 * @monitor: a #GFileMonitor
 *
 * Returns whether the monitor is canceled.
 *
 * Returns: %TRUE if monitor is canceled. %FALSE otherwise.
 */


/**
 * g_file_monitor_set_rate_limit:
 * @monitor: a #GFileMonitor.
 * @limit_msecs: a non-negative integer with the limit in milliseconds
 *     to poll for changes
 *
 * Sets the rate limit to which the @monitor will report
 * consecutive change events to the same file.
 */


/**
 * g_file_mount_enclosing_volume:
 * @location: input #GFile
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation
 *   or %NULL to avoid user interaction
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call
 *   when the request is satisfied, or %NULL
 * @user_data: the data to pass to callback function
 *
 * Starts a @mount_operation, mounting the volume that contains
 * the file @location.
 *
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_mount_enclosing_volume_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 */


/**
 * g_file_mount_enclosing_volume_finish:
 * @location: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes a mount operation started by g_file_mount_enclosing_volume().
 *
 * Returns: %TRUE if successful. If an error has occurred,
 *   this function will return %FALSE and set @error
 *   appropriately if present.
 */


/**
 * g_file_mount_mountable:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation,
 *   or %NULL to avoid user interaction
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Mounts a file of type G_FILE_TYPE_MOUNTABLE.
 * Using @mount_operation, you can request callbacks when, for instance,
 * passwords are needed during authentication.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_mount_mountable_finish() to get
 * the result of the operation.
 */


/**
 * g_file_mount_mountable_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes a mount operation. See g_file_mount_mountable() for details.
 *
 * Finish an asynchronous mount operation that was started
 * with g_file_mount_mountable().
 *
 * Returns: (transfer full): a #GFile or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_move:
 * @source: #GFile pointing to the source location
 * @destination: #GFile pointing to the destination location
 * @flags: set of #GFileCopyFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @progress_callback: (nullable) (scope call) (closure progress_callback_data): #GFileProgressCallback
 *   function for updates
 * @progress_callback_data: gpointer to user data for
 *   the callback function
 * @error: #GError for returning error conditions, or %NULL
 *
 * Tries to move the file or directory @source to the location specified
 * by @destination. If native move operations are supported then this is
 * used, otherwise a copy + delete fallback is used. The native
 * implementation may support moving directories (for instance on moves
 * inside the same filesystem), but the fallback code does not.
 *
 * If the flag %G_FILE_COPY_OVERWRITE is specified an already
 * existing @destination file is overwritten.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @progress_callback is not %NULL, then the operation can be monitored
 * by setting this to a #GFileProgressCallback function.
 * @progress_callback_data will be passed to this function. It is
 * guaranteed that this callback will be called after all data has been
 * transferred with the total number of bytes copied during the operation.
 *
 * If the @source file does not exist, then the %G_IO_ERROR_NOT_FOUND
 * error is returned, independent on the status of the @destination.
 *
 * If %G_FILE_COPY_OVERWRITE is not specified and the target exists,
 * then the error %G_IO_ERROR_EXISTS is returned.
 *
 * If trying to overwrite a file over a directory, the %G_IO_ERROR_IS_DIRECTORY
 * error is returned. If trying to overwrite a directory with a directory the
 * %G_IO_ERROR_WOULD_MERGE error is returned.
 *
 * If the source is a directory and the target does not exist, or
 * %G_FILE_COPY_OVERWRITE is specified and the target is a file, then
 * the %G_IO_ERROR_WOULD_RECURSE error may be returned (if the native
 * move operation isn't available).
 *
 * Returns: %TRUE on successful move, %FALSE otherwise.
 */


/**
 * g_file_move_async:
 * @source: #GFile pointing to the source location
 * @destination: #GFile pointing to the destination location
 * @flags: set of #GFileCopyFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @progress_callback: (nullable) (scope call) (closure progress_callback_data):
 *   #GFileProgressCallback function for updates
 * @progress_callback_data: gpointer to user data for the callback function
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously moves a file @source to the location of @destination. For details of the behaviour, see g_file_move().
 *
 * If @progress_callback is not %NULL, then that function that will be called
 * just like in g_file_move(). The callback will run in the default main context
 * of the thread calling g_file_move_async() — the same context as @callback is
 * run in.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_move_finish() to get the result of the operation.
 *
 * Since: 2.72
 */


/**
 * g_file_move_finish:
 * @file: input source #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file movement, started with
 * g_file_move_async().
 *
 * Returns: %TRUE on successful file move, %FALSE otherwise.
 * Since: 2.72
 */


/**
 * g_file_new_build_filename:
 * @first_element: (type filename): the first element in the path
 * @...: remaining elements in path, terminated by %NULL
 *
 * Constructs a #GFile from a series of elements using the correct
 * separator for filenames.
 *
 * Using this function is equivalent to calling g_build_filename(),
 * followed by g_file_new_for_path() on the result.
 *
 * Returns: (transfer full): a new #GFile
 * Since: 2.56
 */


/**
 * g_file_new_build_filenamev:
 * @args: (array zero-terminated=1) (element-type filename): %NULL-terminated
 *   array of strings containing the path elements.
 *
 * Constructs a #GFile from a vector of elements using the correct
 * separator for filenames.
 *
 * Using this function is equivalent to calling g_build_filenamev(),
 * followed by g_file_new_for_path() on the result.
 *
 * Returns: (transfer full): a new #GFile
 * Since: 2.78
 */


/**
 * g_file_new_for_commandline_arg:
 * @arg: (type filename): a command line string
 *
 * Creates a #GFile with the given argument from the command line.
 * The value of @arg can be either a URI, an absolute path or a
 * relative path resolved relative to the current working directory.
 * This operation never fails, but the returned object might not
 * support any I/O operation if @arg points to a malformed path.
 *
 * Note that on Windows, this function expects its argument to be in
 * UTF-8 -- not the system code page.  This means that you
 * should not use this function with string from argv as it is passed
 * to main().  g_win32_get_command_line() will return a UTF-8 version of
 * the commandline.  #GApplication also uses UTF-8 but
 * g_application_command_line_create_file_for_arg() may be more useful
 * for you there.  It is also always possible to use this function with
 * #GOptionContext arguments of type %G_OPTION_ARG_FILENAME.
 *
 * Returns: (transfer full): a new #GFile.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_new_for_commandline_arg_and_cwd:
 * @arg: (type filename): a command line string
 * @cwd: (type filename): the current working directory of the commandline
 *
 * Creates a #GFile with the given argument from the command line.
 *
 * This function is similar to g_file_new_for_commandline_arg() except
 * that it allows for passing the current working directory as an
 * argument instead of using the current working directory of the
 * process.
 *
 * This is useful if the commandline argument was given in a context
 * other than the invocation of the current process.
 *
 * See also g_application_command_line_create_file_for_arg().
 *
 * Returns: (transfer full): a new #GFile
 * Since: 2.36
 */


/**
 * g_file_new_for_path:
 * @path: (type filename): a string containing a relative or absolute path.
 *   The string must be encoded in the glib filename encoding.
 *
 * Constructs a #GFile for a given path. This operation never
 * fails, but the returned object might not support any I/O
 * operation if @path is malformed.
 *
 * Returns: (transfer full): a new #GFile for the given @path.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_new_for_uri:
 * @uri: a UTF-8 string containing a URI
 *
 * Constructs a #GFile for a given URI. This operation never
 * fails, but the returned object might not support any I/O
 * operation if @uri is malformed or if the uri type is
 * not supported.
 *
 * Returns: (transfer full): a new #GFile for the given @uri.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_new_tmp:
 * @tmpl: (type filename) (nullable): Template for the file
 *   name, as in g_file_open_tmp(), or %NULL for a default template
 * @iostream: (out): on return, a #GFileIOStream for the created file
 * @error: a #GError, or %NULL
 *
 * Opens a file in the preferred directory for temporary files (as
 * returned by g_get_tmp_dir()) and returns a #GFile and
 * #GFileIOStream pointing to it.
 *
 * @tmpl should be a string in the GLib file name encoding
 * containing a sequence of six 'X' characters, and containing no
 * directory components. If it is %NULL, a default template is used.
 *
 * Unlike the other #GFile constructors, this will return %NULL if
 * a temporary file could not be created.
 *
 * Returns: (transfer full): a new #GFile.
 *   Free the returned object with g_object_unref().
 * Since: 2.32
 */


/**
 * g_file_new_tmp_async:
 * @tmpl: (type filename) (nullable): Template for the file
 *   name, as in g_file_open_tmp(), or %NULL for a default template
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Asynchronously opens a file in the preferred directory for temporary files
 *  (as returned by g_get_tmp_dir()) as g_file_new_tmp().
 *
 * @tmpl should be a string in the GLib file name encoding
 * containing a sequence of six 'X' characters, and containing no
 * directory components. If it is %NULL, a default template is used.
 *
 * Since: 2.74
 */


/**
 * g_file_new_tmp_dir_async:
 * @tmpl: (type filename) (nullable): Template for the file
 *   name, as in g_dir_make_tmp(), or %NULL for a default template
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Asynchronously creates a directory in the preferred directory for
 * temporary files (as returned by g_get_tmp_dir()) as g_dir_make_tmp().
 *
 * @tmpl should be a string in the GLib file name encoding
 * containing a sequence of six 'X' characters, and containing no
 * directory components. If it is %NULL, a default template is used.
 *
 * Since: 2.74
 */


/**
 * g_file_new_tmp_dir_finish:
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes a temporary directory creation started by
 * g_file_new_tmp_dir_async().
 *
 * Returns: (transfer full): a new #GFile.
 *   Free the returned object with g_object_unref().
 * Since: 2.74
 */


/**
 * g_file_new_tmp_finish:
 * @result: a #GAsyncResult
 * @iostream: (out) (not nullable) (transfer full): on return, a #GFileIOStream for the created file
 * @error: a #GError, or %NULL
 *
 * Finishes a temporary file creation started by g_file_new_tmp_async().
 *
 * Returns: (transfer full): a new #GFile.
 *   Free the returned object with g_object_unref().
 * Since: 2.74
 */


/**
 * g_file_open_readwrite:
 * @file: #GFile to open
 * @cancellable: (nullable): a #GCancellable
 * @error: a #GError, or %NULL
 *
 * Opens an existing file for reading and writing. The result is
 * a #GFileIOStream that can be used to read and write the contents
 * of the file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * If the file does not exist, the %G_IO_ERROR_NOT_FOUND error will
 * be returned. If the file is a directory, the %G_IO_ERROR_IS_DIRECTORY
 * error will be returned. Other errors are possible too, and depend on
 * what kind of filesystem the file is on. Note that in many non-local
 * file cases read and write streams are not supported, so make sure you
 * really need to do read and write streaming, rather than just opening
 * for reading or writing.
 *
 * Returns: (transfer full): #GFileIOStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_file_open_readwrite_async:
 * @file: input #GFile
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously opens @file for reading and writing.
 *
 * For more details, see g_file_open_readwrite() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_open_readwrite_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_open_readwrite_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file read operation started with
 * g_file_open_readwrite_async().
 *
 * Returns: (transfer full): a #GFileIOStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_file_output_stream_get_etag:
 * @stream: a #GFileOutputStream.
 *
 * Gets the entity tag for the file when it has been written.
 * This must be called after the stream has been written
 * and closed, as the etag can change while writing.
 *
 * Returns: (nullable) (transfer full): the entity tag for the stream.
 */


/**
 * g_file_output_stream_query_info:
 * @stream: a #GFileOutputStream.
 * @attributes: a file attribute query string.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Queries a file output stream for the given @attributes.
 * This function blocks while querying the stream. For the asynchronous
 * version of this function, see g_file_output_stream_query_info_async().
 * While the stream is blocked, the stream will set the pending flag
 * internally, and any other operations on the stream will fail with
 * %G_IO_ERROR_PENDING.
 *
 * Can fail if the stream was already closed (with @error being set to
 * %G_IO_ERROR_CLOSED), the stream has pending operations (with @error being
 * set to %G_IO_ERROR_PENDING), or if querying info is not supported for
 * the stream's interface (with @error being set to %G_IO_ERROR_NOT_SUPPORTED). In
 * all cases of failure, %NULL will be returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set, and %NULL will
 * be returned.
 *
 * Returns: (transfer full): a #GFileInfo for the @stream, or %NULL on error.
 */


/**
 * g_file_output_stream_query_info_async:
 * @stream: a #GFileOutputStream.
 * @attributes: a file attribute query string.
 * @io_priority: the [I/O priority][gio-GIOScheduler] of the request
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: callback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously queries the @stream for a #GFileInfo. When completed,
 * @callback will be called with a #GAsyncResult which can be used to
 * finish the operation with g_file_output_stream_query_info_finish().
 *
 * For the synchronous version of this function, see
 * g_file_output_stream_query_info().
 */


/**
 * g_file_output_stream_query_info_finish:
 * @stream: a #GFileOutputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError, %NULL to ignore.
 *
 * Finalizes the asynchronous query started
 * by g_file_output_stream_query_info_async().
 *
 * Returns: (transfer full): A #GFileInfo for the finished query.
 */


/**
 * g_file_parse_name:
 * @parse_name: a file name or path to be parsed
 *
 * Constructs a #GFile with the given @parse_name (i.e. something
 * given by g_file_get_parse_name()). This operation never fails,
 * but the returned object might not support any I/O operation if
 * the @parse_name cannot be parsed.
 *
 * Returns: (transfer full): a new #GFile.
 */


/**
 * g_file_peek_path:
 * @file: input #GFile
 *
 * Exactly like g_file_get_path(), but caches the result via
 * g_object_set_qdata_full().  This is useful for example in C
 * applications which mix `g_file_*` APIs with native ones.  It
 * also avoids an extra duplicated string when possible, so will be
 * generally more efficient.
 *
 * This call does no blocking I/O.
 *
 * Returns: (type filename) (nullable): string containing the #GFile's path,
 *   or %NULL if no such path exists. The returned string is owned by @file.
 * Since: 2.56
 */


/**
 * g_file_poll_mountable:
 * @file: input #GFile
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call
 *   when the request is satisfied, or %NULL
 * @user_data: the data to pass to callback function
 *
 * Polls a file of type %G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_mount_mountable_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_poll_mountable_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes a poll operation. See g_file_poll_mountable() for details.
 *
 * Finish an asynchronous poll operation that was polled
 * with g_file_poll_mountable().
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * otherwise.
 * Since: 2.22
 */


/**
 * g_file_query_default_handler:
 * @file: a #GFile to open
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Returns the #GAppInfo that is registered as the default
 * application to handle the file specified by @file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (transfer full): a #GAppInfo if the handle was found,
 *   %NULL if there were errors.
 *   When you are done with it, release it with g_object_unref()
 */


/**
 * g_file_query_default_handler_async:
 * @file: a #GFile to open
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is done
 * @user_data: (nullable): data to pass to @callback
 *
 * Async version of g_file_query_default_handler().
 *
 * Since: 2.60
 */


/**
 * g_file_query_default_handler_finish:
 * @file: a #GFile to open
 * @result: a #GAsyncResult
 * @error: (nullable): a #GError
 *
 * Finishes a g_file_query_default_handler_async() operation.
 *
 * Returns: (transfer full): a #GAppInfo if the handle was found,
 *   %NULL if there were errors.
 *   When you are done with it, release it with g_object_unref()
 * Since: 2.60
 */


/**
 * g_file_query_exists:
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 *
 * Utility function to check if a particular file exists. This is
 * implemented using g_file_query_info() and as such does blocking I/O.
 *
 * Note that in many cases it is [racy to first check for file existence](https://en.wikipedia.org/wiki/Time_of_check_to_time_of_use)
 * and then execute something based on the outcome of that, because the
 * file might have been created or removed in between the operations. The
 * general approach to handling that is to not check, but just do the
 * operation and handle the errors as they come.
 *
 * As an example of race-free checking, take the case of reading a file,
 * and if it doesn't exist, creating it. There are two racy versions: read
 * it, and on error create it; and: check if it exists, if not create it.
 * These can both result in two processes creating the file (with perhaps
 * a partially written file as the result). The correct approach is to
 * always try to create the file with g_file_create() which will either
 * atomically create the file or fail with a %G_IO_ERROR_EXISTS error.
 *
 * However, in many cases an existence check is useful in a user interface,
 * for instance to make a menu item sensitive/insensitive, so that you don't
 * have to fool users that something is possible and then just show an error
 * dialog. If you do this, you should make sure to also handle the errors
 * that can happen due to races when you execute the operation.
 *
 * Returns: %TRUE if the file exists (and can be detected without error),
 *   %FALSE otherwise (or if cancelled).
 */


/**
 * g_file_query_file_type:
 * @file: input #GFile
 * @flags: a set of #GFileQueryInfoFlags passed to g_file_query_info()
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 *
 * Utility function to inspect the #GFileType of a file. This is
 * implemented using g_file_query_info() and as such does blocking I/O.
 *
 * The primary use case of this method is to check if a file is
 * a regular file, directory, or symlink.
 *
 * Returns: The #GFileType of the file and %G_FILE_TYPE_UNKNOWN
 *   if the file does not exist
 * Since: 2.18
 */


/**
 * g_file_query_filesystem_info:
 * @file: input #GFile
 * @attributes: an attribute query string
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError
 *
 * Similar to g_file_query_info(), but obtains information
 * about the filesystem the @file is on, rather than the file itself.
 * For instance the amount of space available and the type of
 * the filesystem.
 *
 * The @attributes value is a string that specifies the attributes
 * that should be gathered. It is not an error if it's not possible
 * to read a particular requested attribute from a file - it just
 * won't be set. @attributes should be a comma-separated list of
 * attributes or attribute wildcards. The wildcard "*" means all
 * attributes, and a wildcard like "filesystem::*" means all attributes
 * in the filesystem namespace. The standard namespace for filesystem
 * attributes is "filesystem". Common attributes of interest are
 * %G_FILE_ATTRIBUTE_FILESYSTEM_SIZE (the total size of the filesystem
 * in bytes), %G_FILE_ATTRIBUTE_FILESYSTEM_FREE (number of bytes available),
 * and %G_FILE_ATTRIBUTE_FILESYSTEM_TYPE (type of the filesystem).
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * If the file does not exist, the %G_IO_ERROR_NOT_FOUND error will
 * be returned. Other errors are possible too, and depend on what
 * kind of filesystem the file is on.
 *
 * Returns: (transfer full): a #GFileInfo or %NULL if there was an error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_query_filesystem_info_async:
 * @file: input #GFile
 * @attributes: an attribute query string
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously gets the requested information about the filesystem
 * that the specified @file is on. The result is a #GFileInfo object
 * that contains key-value attributes (such as type or size for the
 * file).
 *
 * For more details, see g_file_query_filesystem_info() which is the
 * synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can
 * then call g_file_query_info_finish() to get the result of the
 * operation.
 */


/**
 * g_file_query_filesystem_info_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an asynchronous filesystem info query.
 * See g_file_query_filesystem_info_async().
 *
 * Returns: (transfer full): #GFileInfo for given @file
 *   or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_query_info:
 * @file: input #GFile
 * @attributes: an attribute query string
 * @flags: a set of #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError
 *
 * Gets the requested information about specified @file.
 * The result is a #GFileInfo object that contains key-value
 * attributes (such as the type or size of the file).
 *
 * The @attributes value is a string that specifies the file
 * attributes that should be gathered. It is not an error if
 * it's not possible to read a particular requested attribute
 * from a file - it just won't be set. @attributes should be a
 * comma-separated list of attributes or attribute wildcards.
 * The wildcard "*" means all attributes, and a wildcard like
 * "standard::*" means all attributes in the standard namespace.
 * An example attribute query be "standard::*,owner::user".
 * The standard attributes are available as defines, like
 * %G_FILE_ATTRIBUTE_STANDARD_NAME.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * For symlinks, normally the information about the target of the
 * symlink is returned, rather than information about the symlink
 * itself. However if you pass %G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS
 * in @flags the information about the symlink itself will be returned.
 * Also, for symlinks that point to non-existing files the information
 * about the symlink itself will be returned.
 *
 * If the file does not exist, the %G_IO_ERROR_NOT_FOUND error will be
 * returned. Other errors are possible too, and depend on what kind of
 * filesystem the file is on.
 *
 * Returns: (transfer full): a #GFileInfo for the given @file, or %NULL
 *   on error. Free the returned object with g_object_unref().
 */


/**
 * g_file_query_info_async:
 * @file: input #GFile
 * @attributes: an attribute query string
 * @flags: a set of #GFileQueryInfoFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously gets the requested information about specified @file.
 * The result is a #GFileInfo object that contains key-value attributes
 * (such as type or size for the file).
 *
 * For more details, see g_file_query_info() which is the synchronous
 * version of this call.
 *
 * When the operation is finished, @callback will be called. You can
 * then call g_file_query_info_finish() to get the result of the operation.
 */


/**
 * g_file_query_info_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an asynchronous file info query.
 * See g_file_query_info_async().
 *
 * Returns: (transfer full): #GFileInfo for given @file
 *   or %NULL on error. Free the returned object with
 *   g_object_unref().
 */


/**
 * g_file_query_settable_attributes:
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Obtain the list of settable attributes for the file.
 *
 * Returns the type and full attribute name of all the attributes
 * that can be set on this file. This doesn't mean setting it will
 * always succeed though, you might get an access failure, or some
 * specific file may not support a specific attribute.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (transfer full): a #GFileAttributeInfoList describing the settable attributes.
 *   When you are done with it, release it with
 *   g_file_attribute_info_list_unref()
 */


/**
 * g_file_query_writable_namespaces:
 * @file: input #GFile
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Obtain the list of attribute namespaces where new attributes
 * can be created by a user. An example of this is extended
 * attributes (in the "xattr" namespace).
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (transfer full): a #GFileAttributeInfoList describing the writable namespaces.
 *   When you are done with it, release it with
 *   g_file_attribute_info_list_unref()
 */


/**
 * g_file_read: (virtual read_fn)
 * @file: #GFile to read
 * @cancellable: (nullable): a #GCancellable
 * @error: a #GError, or %NULL
 *
 * Opens a file for reading. The result is a #GFileInputStream that
 * can be used to read the contents of the file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If the file does not exist, the %G_IO_ERROR_NOT_FOUND error will be
 * returned. If the file is a directory, the %G_IO_ERROR_IS_DIRECTORY
 * error will be returned. Other errors are possible too, and depend
 * on what kind of filesystem the file is on.
 *
 * Returns: (transfer full): #GFileInputStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_read_async:
 * @file: input #GFile
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously opens @file for reading.
 *
 * For more details, see g_file_read() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_read_finish() to get the result
 * of the operation.
 */


/**
 * g_file_read_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file read operation started with
 * g_file_read_async().
 *
 * Returns: (transfer full): a #GFileInputStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_replace:
 * @file: input #GFile
 * @etag: (nullable): an optional [entity tag][gfile-etag]
 *   for the current #GFile, or #NULL to ignore
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Returns an output stream for overwriting the file, possibly
 * creating a backup copy of the file first. If the file doesn't exist,
 * it will be created.
 *
 * This will try to replace the file in the safest way possible so
 * that any errors during the writing will not affect an already
 * existing copy of the file. For instance, for local files it
 * may write to a temporary file and then atomically rename over
 * the destination when the stream is closed.
 *
 * By default files created are generally readable by everyone,
 * but if you pass %G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level that
 * is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled
 * by triggering the cancellable object from another thread. If the
 * operation was cancelled, the error %G_IO_ERROR_CANCELLED will be
 * returned.
 *
 * If you pass in a non-%NULL @etag value and @file already exists, then
 * this value is compared to the current entity tag of the file, and if
 * they differ an %G_IO_ERROR_WRONG_ETAG error is returned. This
 * generally means that the file has been changed since you last read
 * it. You can get the new etag from g_file_output_stream_get_etag()
 * after you've finished writing and closed the #GFileOutputStream. When
 * you load a new file you can use g_file_input_stream_query_info() to
 * get the etag of the file.
 *
 * If @make_backup is %TRUE, this function will attempt to make a
 * backup of the current file before overwriting it. If this fails
 * a %G_IO_ERROR_CANT_CREATE_BACKUP error will be returned. If you
 * want to replace anyway, try again with @make_backup set to %FALSE.
 *
 * If the file is a directory the %G_IO_ERROR_IS_DIRECTORY error will
 * be returned, and if the file is some other form of non-regular file
 * then a %G_IO_ERROR_NOT_REGULAR_FILE error will be returned. Some
 * file systems don't allow all file names, and may return an
 * %G_IO_ERROR_INVALID_FILENAME error, and if the name is to long
 * %G_IO_ERROR_FILENAME_TOO_LONG will be returned. Other errors are
 * possible too, and depend on what kind of filesystem the file is on.
 *
 * Returns: (transfer full): a #GFileOutputStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_replace_async:
 * @file: input #GFile
 * @etag: (nullable): an [entity tag][gfile-etag] for the current #GFile,
 *   or %NULL to ignore
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously overwrites the file, replacing the contents,
 * possibly creating a backup copy of the file first.
 *
 * For more details, see g_file_replace() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_replace_finish() to get the result
 * of the operation.
 */


/**
 * g_file_replace_contents:
 * @file: input #GFile
 * @contents: (element-type guint8) (array length=length): a string containing the new contents for @file
 * @length: the length of @contents in bytes
 * @etag: (nullable): the old [entity-tag][gfile-etag] for the document,
 *   or %NULL
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @new_etag: (out) (optional) (nullable): a location to a new [entity tag][gfile-etag]
 *   for the document. This should be freed with g_free() when no longer
 *   needed, or %NULL
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Replaces the contents of @file with @contents of @length bytes.
 *
 * If @etag is specified (not %NULL), any existing file must have that etag,
 * or the error %G_IO_ERROR_WRONG_ETAG will be returned.
 *
 * If @make_backup is %TRUE, this function will attempt to make a backup
 * of @file. Internally, it uses g_file_replace(), so will try to replace the
 * file contents in the safest way possible. For example, atomic renames are
 * used when replacing local files’ contents.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * The returned @new_etag can be used to verify that the file hasn't
 * changed the next time it is saved over.
 *
 * Returns: %TRUE if successful. If an error has occurred, this function
 *   will return %FALSE and set @error appropriately if present.
 */


/**
 * g_file_replace_contents_async:
 * @file: input #GFile
 * @contents: (element-type guint8) (array length=length): string of contents to replace the file with
 * @length: the length of @contents in bytes
 * @etag: (nullable): a new [entity tag][gfile-etag] for the @file, or %NULL
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts an asynchronous replacement of @file with the given
 * @contents of @length bytes. @etag will replace the document's
 * current entity tag.
 *
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_replace_contents_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @make_backup is %TRUE, this function will attempt to
 * make a backup of @file.
 *
 * Note that no copy of @contents will be made, so it must stay valid
 * until @callback is called. See g_file_replace_contents_bytes_async()
 * for a #GBytes version that will automatically hold a reference to the
 * contents (without copying) for the duration of the call.
 */


/**
 * g_file_replace_contents_bytes_async:
 * @file: input #GFile
 * @contents: a #GBytes
 * @etag: (nullable): a new [entity tag][gfile-etag] for the @file, or %NULL
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @cancellable: optional #GCancellable object, %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Same as g_file_replace_contents_async() but takes a #GBytes input instead.
 * This function will keep a ref on @contents until the operation is done.
 * Unlike g_file_replace_contents_async() this allows forgetting about the
 * content without waiting for the callback.
 *
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_replace_contents_finish().
 *
 * Since: 2.40
 */


/**
 * g_file_replace_contents_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @new_etag: (out) (optional) (nullable): a location of a new [entity tag][gfile-etag]
 *   for the document. This should be freed with g_free() when it is no
 *   longer needed, or %NULL
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous replace of the given @file. See
 * g_file_replace_contents_async(). Sets @new_etag to the new entity
 * tag for the document, if present.
 *
 * Returns: %TRUE on success, %FALSE on failure.
 */


/**
 * g_file_replace_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file replace operation started with
 * g_file_replace_async().
 *
 * Returns: (transfer full): a #GFileOutputStream, or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_replace_readwrite:
 * @file: a #GFile
 * @etag: (nullable): an optional [entity tag][gfile-etag]
 *   for the current #GFile, or #NULL to ignore
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: return location for a #GError, or %NULL
 *
 * Returns an output stream for overwriting the file in readwrite mode,
 * possibly creating a backup copy of the file first. If the file doesn't
 * exist, it will be created.
 *
 * For details about the behaviour, see g_file_replace() which does the
 * same thing but returns an output stream only.
 *
 * Note that in many non-local file cases read and write streams are not
 * supported, so make sure you really need to do read and write streaming,
 * rather than just opening for reading or writing.
 *
 * Returns: (transfer full): a #GFileIOStream or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_file_replace_readwrite_async:
 * @file: input #GFile
 * @etag: (nullable): an [entity tag][gfile-etag] for the current #GFile,
 *   or %NULL to ignore
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously overwrites the file in read-write mode,
 * replacing the contents, possibly creating a backup copy
 * of the file first.
 *
 * For more details, see g_file_replace_readwrite() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_replace_readwrite_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_replace_readwrite_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file replace operation started with
 * g_file_replace_readwrite_async().
 *
 * Returns: (transfer full): a #GFileIOStream, or %NULL on error.
 *   Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_file_resolve_relative_path:
 * @file: input #GFile
 * @relative_path: (type filename): a given relative path string
 *
 * Resolves a relative path for @file to an absolute path.
 *
 * This call does no blocking I/O.
 *
 * If the @relative_path is an absolute path name, the resolution
 * is done absolutely (without taking @file path as base).
 *
 * Returns: (transfer full): a #GFile for the resolved path.
 */


/**
 * g_file_set_attribute:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @type: The type of the attribute
 * @value_p: (nullable): a pointer to the value (or the pointer
 *   itself if the type is a pointer type)
 * @flags: a set of #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets an attribute in the file with attribute name @attribute to @value_p.
 *
 * Some attributes can be unset by setting @type to
 * %G_FILE_ATTRIBUTE_TYPE_INVALID and @value_p to %NULL.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the attribute was set, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_byte_string:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @value: a string containing the attribute's new value
 * @flags: a #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING to @value.
 * If @attribute is of a different type, this operation will fail,
 * returning %FALSE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 *   in the @file, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_int32:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @value: a #gint32 containing the attribute's new value
 * @flags: a #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_INT32 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 *   in the @file, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_int64:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @value: a #guint64 containing the attribute's new value
 * @flags: a #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_INT64 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_string:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @value: a string containing the attribute's value
 * @flags: #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_STRING to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_uint32:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @value: a #guint32 containing the attribute's new value
 * @flags: a #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_UINT32 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 *   in the @file, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_uint64:
 * @file: input #GFile
 * @attribute: a string containing the attribute's name
 * @value: a #guint64 containing the attribute's new value
 * @flags: a #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_UINT64 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 *   in the @file, %FALSE otherwise.
 */


/**
 * g_file_set_attributes_async:
 * @file: input #GFile
 * @info: a #GFileInfo
 * @flags: a #GFileQueryInfoFlags
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously sets the attributes of @file with @info.
 *
 * For more details, see g_file_set_attributes_from_info(),
 * which is the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_set_attributes_finish() to get
 * the result of the operation.
 */


/**
 * g_file_set_attributes_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @info: (out) (transfer full): a #GFileInfo
 * @error: a #GError, or %NULL
 *
 * Finishes setting an attribute started in g_file_set_attributes_async().
 *
 * Returns: %TRUE if the attributes were set correctly, %FALSE otherwise.
 */


/**
 * g_file_set_attributes_from_info:
 * @file: input #GFile
 * @info: a #GFileInfo
 * @flags: #GFileQueryInfoFlags
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Tries to set all attributes in the #GFileInfo on the target
 * values, not stopping on the first error.
 *
 * If there is any error during this operation then @error will
 * be set to the first error. Error on particular fields are flagged
 * by setting the "status" field in the attribute value to
 * %G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING, which means you can
 * also detect further errors.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %FALSE if there was any error, %TRUE otherwise.
 */


/**
 * g_file_set_display_name:
 * @file: input #GFile
 * @display_name: a string
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Renames @file to the specified display name.
 *
 * The display name is converted from UTF-8 to the correct encoding
 * for the target filesystem if possible and the @file is renamed to this.
 *
 * If you want to implement a rename operation in the user interface the
 * edit name (%G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME) should be used as the
 * initial value in the rename widget, and then the result after editing
 * should be passed to g_file_set_display_name().
 *
 * On success the resulting converted filename is returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: (transfer full): a #GFile specifying what @file was renamed to,
 *   or %NULL if there was an error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_set_display_name_async:
 * @file: input #GFile
 * @display_name: a string
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously sets the display name for a given #GFile.
 *
 * For more details, see g_file_set_display_name() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_set_display_name_finish() to get
 * the result of the operation.
 */


/**
 * g_file_set_display_name_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes setting a display name started with
 * g_file_set_display_name_async().
 *
 * Returns: (transfer full): a #GFile or %NULL on error.
 *   Free the returned object with g_object_unref().
 */


/**
 * g_file_start_mountable:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @start_operation: (nullable): a #GMountOperation, or %NULL to avoid user interaction
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call when the request is satisfied, or %NULL
 * @user_data: the data to pass to callback function
 *
 * Starts a file of type %G_FILE_TYPE_MOUNTABLE.
 * Using @start_operation, you can request callbacks when, for instance,
 * passwords are needed during authentication.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_mount_mountable_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_start_mountable_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes a start operation. See g_file_start_mountable() for details.
 *
 * Finish an asynchronous start operation that was started
 * with g_file_start_mountable().
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * otherwise.
 * Since: 2.22
 */


/**
 * g_file_stop_mountable:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation,
 *   or %NULL to avoid user interaction.
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (nullable): a #GAsyncReadyCallback to call
 *   when the request is satisfied, or %NULL
 * @user_data: the data to pass to callback function
 *
 * Stops a file of type %G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_stop_mountable_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_stop_mountable_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes a stop operation, see g_file_stop_mountable() for details.
 *
 * Finish an asynchronous stop operation that was started
 * with g_file_stop_mountable().
 *
 * Returns: %TRUE if the operation finished successfully.
 *   %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_file_supports_thread_contexts:
 * @file: a #GFile
 *
 * Checks if @file supports
 * [thread-default contexts][g-main-context-push-thread-default-context].
 * If this returns %FALSE, you cannot perform asynchronous operations on
 * @file in a thread that has a thread-default context.
 *
 * Returns: Whether or not @file supports thread-default contexts.
 * Since: 2.22
 */


/**
 * g_file_trash: (virtual trash)
 * @file: #GFile to send to trash
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Sends @file to the "Trashcan", if possible. This is similar to
 * deleting it, but the user can recover it before emptying the trashcan.
 * Not all file systems support trashing, so this call can return the
 * %G_IO_ERROR_NOT_SUPPORTED error. Since GLib 2.66, the `x-gvfs-notrash` unix
 * mount option can be used to disable g_file_trash() support for certain
 * mounts, the %G_IO_ERROR_NOT_SUPPORTED error will be returned in that case.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on successful trash, %FALSE otherwise.
 */


/**
 * g_file_trash_async: (virtual trash_async)
 * @file: input #GFile
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: a #GAsyncReadyCallback to call
 *   when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously sends @file to the Trash location, if possible.
 *
 * Since: 2.38
 */


/**
 * g_file_trash_finish: (virtual trash_finish)
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file trashing operation, started with
 * g_file_trash_async().
 *
 * Returns: %TRUE on successful trash, %FALSE otherwise.
 * Since: 2.38
 */


/**
 * g_file_unmount_mountable:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (nullable) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Unmounts a file of type G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_unmount_mountable_finish() to get
 * the result of the operation.
 *
 * Deprecated: 2.22: Use g_file_unmount_mountable_with_operation() instead.
 */


/**
 * g_file_unmount_mountable_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an unmount operation, see g_file_unmount_mountable() for details.
 *
 * Finish an asynchronous unmount operation that was started
 * with g_file_unmount_mountable().
 *
 * Returns: %TRUE if the operation finished successfully.
 *   %FALSE otherwise.
 * Deprecated: 2.22: Use g_file_unmount_mountable_with_operation_finish()
 *   instead.
 */


/**
 * g_file_unmount_mountable_with_operation:
 * @file: input #GFile
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation,
 *   or %NULL to avoid user interaction
 * @cancellable: (nullable): optional #GCancellable object,
 *   %NULL to ignore
 * @callback: (scope async) (nullable) (closure user_data): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Unmounts a file of type %G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_file_unmount_mountable_finish() to get
 * the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_unmount_mountable_with_operation_finish:
 * @file: input #GFile
 * @result: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an unmount operation,
 * see g_file_unmount_mountable_with_operation() for details.
 *
 * Finish an asynchronous unmount operation that was started
 * with g_file_unmount_mountable_with_operation().
 *
 * Returns: %TRUE if the operation finished successfully.
 *   %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_filename_completer_get_completion_suffix:
 * @completer: the filename completer.
 * @initial_text: text to be completed.
 *
 * Obtains a completion for @initial_text from @completer.
 *
 * Returns: (nullable) (transfer full): a completed string, or %NULL if no
 *     completion exists. This string is not owned by GIO, so remember to g_free()
 *     it when finished.
 */


/**
 * g_filename_completer_get_completions:
 * @completer: the filename completer.
 * @initial_text: text to be completed.
 *
 * Gets an array of completion strings for a given initial text.
 *
 * Returns: (array zero-terminated=1) (transfer full): array of strings with possible completions for @initial_text.
 * This array must be freed by g_strfreev() when finished.
 */


/**
 * g_filename_completer_new:
 *
 * Creates a new filename completer.
 *
 * Returns: a #GFilenameCompleter.
 */


/**
 * g_filename_completer_set_dirs_only:
 * @completer: the filename completer.
 * @dirs_only: a #gboolean.
 *
 * If @dirs_only is %TRUE, @completer will only
 * complete directory names, and not file names.
 */


/**
 * g_filter_input_stream_get_base_stream:
 * @stream: a #GFilterInputStream.
 *
 * Gets the base stream for the filter stream.
 *
 * Returns: (transfer none): a #GInputStream.
 */


/**
 * g_filter_input_stream_get_close_base_stream:
 * @stream: a #GFilterInputStream.
 *
 * Returns whether the base stream will be closed when @stream is
 * closed.
 *
 * Returns: %TRUE if the base stream will be closed.
 */


/**
 * g_filter_input_stream_set_close_base_stream:
 * @stream: a #GFilterInputStream.
 * @close_base: %TRUE to close the base stream.
 *
 * Sets whether the base stream will be closed when @stream is closed.
 */


/**
 * g_filter_output_stream_get_base_stream:
 * @stream: a #GFilterOutputStream.
 *
 * Gets the base stream for the filter stream.
 *
 * Returns: (transfer none): a #GOutputStream.
 */


/**
 * g_filter_output_stream_get_close_base_stream:
 * @stream: a #GFilterOutputStream.
 *
 * Returns whether the base stream will be closed when @stream is
 * closed.
 *
 * Returns: %TRUE if the base stream will be closed.
 */


/**
 * g_filter_output_stream_set_close_base_stream:
 * @stream: a #GFilterOutputStream.
 * @close_base: %TRUE to close the base stream.
 *
 * Sets whether the base stream will be closed when @stream is closed.
 */


/**
 * g_icon_deserialize:
 * @value: (transfer none): a #GVariant created with g_icon_serialize()
 *
 * Deserializes a #GIcon previously serialized using g_icon_serialize().
 *
 * Returns: (nullable) (transfer full): a #GIcon, or %NULL when deserialization fails.
 * Since: 2.38
 */


/**
 * g_icon_equal: (virtual equal)
 * @icon1: (nullable): pointer to the first #GIcon.
 * @icon2: (nullable): pointer to the second #GIcon.
 *
 * Checks if two icons are equal.
 *
 * Returns: %TRUE if @icon1 is equal to @icon2. %FALSE otherwise.
 */


/**
 * g_icon_hash: (virtual hash)
 * @icon: (not nullable) (type Gio.Icon): #gconstpointer to an icon object.
 *
 * Gets a hash for an icon.
 *
 * Returns: a #guint containing a hash for the @icon, suitable for
 * use in a #GHashTable or similar data structure.
 */


/**
 * g_icon_new_for_string:
 * @str: A string obtained via g_icon_to_string().
 * @error: Return location for error.
 *
 * Generate a #GIcon instance from @str. This function can fail if
 * @str is not valid - see g_icon_to_string() for discussion.
 *
 * If your application or library provides one or more #GIcon
 * implementations you need to ensure that each #GType is registered
 * with the type system prior to calling g_icon_new_for_string().
 *
 * Returns: (transfer full): An object implementing the #GIcon
 *          interface or %NULL if @error is set.
 * Since: 2.20
 */


/**
 * g_icon_serialize: (virtual serialize)
 * @icon: a #GIcon
 *
 * Serializes a #GIcon into a #GVariant. An equivalent #GIcon can be retrieved
 * back by calling g_icon_deserialize() on the returned value.
 * As serialization will avoid using raw icon data when possible, it only
 * makes sense to transfer the #GVariant between processes on the same machine,
 * (as opposed to over the network), and within the same file system namespace.
 *
 * Returns: (nullable) (transfer full): a #GVariant, or %NULL when serialization fails. The #GVariant will not be floating.
 * Since: 2.38
 */


/**
 * g_icon_to_string:
 * @icon: a #GIcon.
 *
 * Generates a textual representation of @icon that can be used for
 * serialization such as when passing @icon to a different process or
 * saving it to persistent storage. Use g_icon_new_for_string() to
 * get @icon back from the returned string.
 *
 * The encoding of the returned string is proprietary to #GIcon except
 * in the following two cases
 *
 * - If @icon is a #GFileIcon, the returned string is a native path
 *   (such as `/path/to/my icon.png`) without escaping
 *   if the #GFile for @icon is a native file.  If the file is not
 *   native, the returned string is the result of g_file_get_uri()
 *   (such as `sftp://path/to/my%20icon.png`).
 *
 * - If @icon is a #GThemedIcon with exactly one name and no fallbacks,
 *   the encoding is simply the name (such as `network-server`).
 *
 * Returns: (nullable): An allocated NUL-terminated UTF8 string or
 * %NULL if @icon can't be serialized. Use g_free() to free.
 * Since: 2.20
 */


/**
 * g_inet_address_equal:
 * @address: A #GInetAddress.
 * @other_address: Another #GInetAddress.
 *
 * Checks if two #GInetAddress instances are equal, e.g. the same address.
 *
 * Returns: %TRUE if @address and @other_address are equal, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * g_inet_address_get_family:
 * @address: a #GInetAddress
 *
 * Gets @address's family
 *
 * Returns: @address's family
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_any:
 * @address: a #GInetAddress
 *
 * Tests whether @address is the "any" address for its family.
 *
 * Returns: %TRUE if @address is the "any" address for its family.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_link_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a link-local address (that is, if it
 * identifies a host on a local network that is not connected to the
 * Internet).
 *
 * Returns: %TRUE if @address is a link-local address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_loopback:
 * @address: a #GInetAddress
 *
 * Tests whether @address is the loopback address for its family.
 *
 * Returns: %TRUE if @address is the loopback address for its family.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_global:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a global multicast address.
 *
 * Returns: %TRUE if @address is a global multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_link_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a link-local multicast address.
 *
 * Returns: %TRUE if @address is a link-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_node_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a node-local multicast address.
 *
 * Returns: %TRUE if @address is a node-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_org_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is an organization-local multicast address.
 *
 * Returns: %TRUE if @address is an organization-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_site_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a site-local multicast address.
 *
 * Returns: %TRUE if @address is a site-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_multicast:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a multicast address.
 *
 * Returns: %TRUE if @address is a multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_site_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a site-local address such as 10.0.0.1
 * (that is, the address identifies a host on a local network that can
 * not be reached directly from the Internet, but which may have
 * outgoing Internet connectivity via a NAT or firewall).
 *
 * Returns: %TRUE if @address is a site-local address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_native_size:
 * @address: a #GInetAddress
 *
 * Gets the size of the native raw binary address for @address. This
 * is the size of the data that you get from g_inet_address_to_bytes().
 *
 * Returns: the number of bytes used for the native version of @address.
 * Since: 2.22
 */


/**
 * g_inet_address_mask_equal:
 * @mask: a #GInetAddressMask
 * @mask2: another #GInetAddressMask
 *
 * Tests if @mask and @mask2 are the same mask.
 *
 * Returns: whether @mask and @mask2 are the same mask
 * Since: 2.32
 */


/**
 * g_inet_address_mask_get_address:
 * @mask: a #GInetAddressMask
 *
 * Gets @mask's base address
 *
 * Returns: (transfer none): @mask's base address
 * Since: 2.32
 */


/**
 * g_inet_address_mask_get_family:
 * @mask: a #GInetAddressMask
 *
 * Gets the #GSocketFamily of @mask's address
 *
 * Returns: the #GSocketFamily of @mask's address
 * Since: 2.32
 */


/**
 * g_inet_address_mask_get_length:
 * @mask: a #GInetAddressMask
 *
 * Gets @mask's length
 *
 * Returns: @mask's length
 * Since: 2.32
 */


/**
 * g_inet_address_mask_matches:
 * @mask: a #GInetAddressMask
 * @address: a #GInetAddress
 *
 * Tests if @address falls within the range described by @mask.
 *
 * Returns: whether @address falls within the range described by
 * @mask.
 * Since: 2.32
 */


/**
 * g_inet_address_mask_new:
 * @addr: a #GInetAddress
 * @length: number of bits of @addr to use
 * @error: return location for #GError, or %NULL
 *
 * Creates a new #GInetAddressMask representing all addresses whose
 * first @length bits match @addr.
 *
 * Returns: a new #GInetAddressMask, or %NULL on error
 * Since: 2.32
 */


/**
 * g_inet_address_mask_new_from_string:
 * @mask_string: an IP address or address/length string
 * @error: return location for #GError, or %NULL
 *
 * Parses @mask_string as an IP address and (optional) length, and
 * creates a new #GInetAddressMask. The length, if present, is
 * delimited by a "/". If it is not present, then the length is
 * assumed to be the full length of the address.
 *
 * Returns: a new #GInetAddressMask corresponding to @string, or %NULL
 * on error.
 * Since: 2.32
 */


/**
 * g_inet_address_mask_to_string:
 * @mask: a #GInetAddressMask
 *
 * Converts @mask back to its corresponding string form.
 *
 * Returns: a string corresponding to @mask.
 * Since: 2.32
 */


/**
 * g_inet_address_new_any:
 * @family: the address family
 *
 * Creates a #GInetAddress for the "any" address (unassigned/"don't
 * care") for @family.
 *
 * Returns: a new #GInetAddress corresponding to the "any" address
 * for @family.
 *     Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_inet_address_new_from_bytes:
 * @bytes: (array) (element-type guint8): raw address data
 * @family: the address family of @bytes
 *
 * Creates a new #GInetAddress from the given @family and @bytes.
 * @bytes should be 4 bytes for %G_SOCKET_FAMILY_IPV4 and 16 bytes for
 * %G_SOCKET_FAMILY_IPV6.
 *
 * Returns: a new #GInetAddress corresponding to @family and @bytes.
 *     Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_inet_address_new_from_string:
 * @string: a string representation of an IP address
 *
 * Parses @string as an IP address and creates a new #GInetAddress.
 *
 * Returns: (nullable) (transfer full): a new #GInetAddress corresponding
 * to @string, or %NULL if @string could not be parsed.
 *     Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_inet_address_new_loopback:
 * @family: the address family
 *
 * Creates a #GInetAddress for the loopback address for @family.
 *
 * Returns: a new #GInetAddress corresponding to the loopback address
 * for @family.
 *     Free the returned object with g_object_unref().
 * Since: 2.22
 */


/**
 * g_inet_address_to_bytes: (skip)
 * @address: a #GInetAddress
 *
 * Gets the raw binary address data from @address.
 *
 * Returns: a pointer to an internal array of the bytes in @address,
 * which should not be modified, stored, or freed. The size of this
 * array can be gotten with g_inet_address_get_native_size().
 * Since: 2.22
 */


/**
 * g_inet_address_to_string:
 * @address: a #GInetAddress
 *
 * Converts @address to string form.
 *
 * Returns: a representation of @address as a string, which should be
 * freed after use.
 * Since: 2.22
 */


/**
 * g_inet_socket_address_get_address:
 * @address: a #GInetSocketAddress
 *
 * Gets @address's #GInetAddress.
 *
 * Returns: (transfer none): the #GInetAddress for @address, which must be
 * g_object_ref()'d if it will be stored
 * Since: 2.22
 */


/**
 * g_inet_socket_address_get_flowinfo:
 * @address: a %G_SOCKET_FAMILY_IPV6 #GInetSocketAddress
 *
 * Gets the `sin6_flowinfo` field from @address,
 * which must be an IPv6 address.
 *
 * Returns: the flowinfo field
 * Since: 2.32
 */


/**
 * g_inet_socket_address_get_port:
 * @address: a #GInetSocketAddress
 *
 * Gets @address's port.
 *
 * Returns: the port for @address
 * Since: 2.22
 */


/**
 * g_inet_socket_address_get_scope_id:
 * @address: a %G_SOCKET_FAMILY_IPV6 #GInetAddress
 *
 * Gets the `sin6_scope_id` field from @address,
 * which must be an IPv6 address.
 *
 * Returns: the scope id field
 * Since: 2.32
 */


/**
 * g_inet_socket_address_new:
 * @address: a #GInetAddress
 * @port: a port number
 *
 * Creates a new #GInetSocketAddress for @address and @port.
 *
 * Returns: a new #GInetSocketAddress
 * Since: 2.22
 */


/**
 * g_inet_socket_address_new_from_string:
 * @address: the string form of an IP address
 * @port: a port number
 *
 * Creates a new #GInetSocketAddress for @address and @port.
 *
 * If @address is an IPv6 address, it can also contain a scope ID
 * (separated from the address by a `%`).
 *
 * Returns: (nullable) (transfer full): a new #GInetSocketAddress,
 * or %NULL if @address cannot be parsed.
 * Since: 2.40
 */


/**
 * g_initable_init:
 * @initable: a #GInitable.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Initializes the object implementing the interface.
 *
 * This method is intended for language bindings. If writing in C,
 * g_initable_new() should typically be used instead.
 *
 * The object must be initialized before any real use after initial
 * construction, either with this function or g_async_initable_init_async().
 *
 * Implementations may also support cancellation. If @cancellable is not %NULL,
 * then initialization can be cancelled by triggering the cancellable object
 * from another thread. If the operation was cancelled, the error
 * %G_IO_ERROR_CANCELLED will be returned. If @cancellable is not %NULL and
 * the object doesn't support cancellable initialization the error
 * %G_IO_ERROR_NOT_SUPPORTED will be returned.
 *
 * If the object is not initialized, or initialization returns with an
 * error, then all operations on the object except g_object_ref() and
 * g_object_unref() are considered to be invalid, and have undefined
 * behaviour. See the [introduction][ginitable] for more details.
 *
 * Callers should not assume that a class which implements #GInitable can be
 * initialized multiple times, unless the class explicitly documents itself as
 * supporting this. Generally, a class’ implementation of init() can assume
 * (and assert) that it will only be called once. Previously, this documentation
 * recommended all #GInitable implementations should be idempotent; that
 * recommendation was relaxed in GLib 2.54.
 *
 * If a class explicitly supports being initialized multiple times, it is
 * recommended that the method is idempotent: multiple calls with the same
 * arguments should return the same results. Only the first call initializes
 * the object; further calls return the result of the first call.
 *
 * One reason why a class might need to support idempotent initialization is if
 * it is designed to be used via the singleton pattern, with a
 * #GObjectClass.constructor that sometimes returns an existing instance.
 * In this pattern, a caller would expect to be able to call g_initable_init()
 * on the result of g_object_new(), regardless of whether it is in fact a new
 * instance.
 *
 * Returns: %TRUE if successful. If an error has occurred, this function will
 *     return %FALSE and set @error appropriately if present.
 * Since: 2.22
 */


/**
 * g_initable_new:
 * @object_type: a #GType supporting #GInitable.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to
 *    ignore.
 * @first_property_name: (nullable): the name of the first property, or %NULL if no
 *     properties
 * @...: the value if the first property, followed by and other property
 *    value pairs, and ended by %NULL.
 *
 * Helper function for constructing #GInitable object. This is
 * similar to g_object_new() but also initializes the object
 * and returns %NULL, setting an error on failure.
 *
 * Returns: (type GObject.Object) (transfer full): a newly allocated
 *      #GObject, or %NULL on error
 * Since: 2.22
 */


/**
 * g_initable_new_valist:
 * @object_type: a #GType supporting #GInitable.
 * @first_property_name: the name of the first property, followed by
 * the value, and other property value pairs, and ended by %NULL.
 * @var_args: The var args list generated from @first_property_name.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Helper function for constructing #GInitable object. This is
 * similar to g_object_new_valist() but also initializes the object
 * and returns %NULL, setting an error on failure.
 *
 * Returns: (type GObject.Object) (transfer full): a newly allocated
 *      #GObject, or %NULL on error
 * Since: 2.22
 */


/**
 * g_initable_newv:
 * @object_type: a #GType supporting #GInitable.
 * @n_parameters: the number of parameters in @parameters
 * @parameters: (array length=n_parameters): the parameters to use to construct the object
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Helper function for constructing #GInitable object. This is
 * similar to g_object_newv() but also initializes the object
 * and returns %NULL, setting an error on failure.
 *
 * Returns: (type GObject.Object) (transfer full): a newly allocated
 *      #GObject, or %NULL on error
 * Since: 2.22
 * Deprecated: 2.54: Use g_object_new_with_properties() and
 * g_initable_init() instead. See #GParameter for more information.
 */


/**
 * g_input_stream_clear_pending:
 * @stream: input stream
 *
 * Clears the pending flag on @stream.
 */


/**
 * g_input_stream_close:
 * @stream: A #GInputStream.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Closes the stream, releasing resources related to it.
 *
 * Once the stream is closed, all other operations will return %G_IO_ERROR_CLOSED.
 * Closing a stream multiple times will not return an error.
 *
 * Streams will be automatically closed when the last reference
 * is dropped, but you might want to call this function to make sure
 * resources are released as early as possible.
 *
 * Some streams might keep the backing store of the stream (e.g. a file descriptor)
 * open after the stream is closed. See the documentation for the individual
 * stream for details.
 *
 * On failure the first error that happened will be reported, but the close
 * operation will finish as much as possible. A stream that failed to
 * close will still return %G_IO_ERROR_CLOSED for all operations. Still, it
 * is important to check and report the error to the user.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 * Cancelling a close will still leave the stream closed, but some streams
 * can use a faster close that doesn't block to e.g. check errors.
 *
 * Returns: %TRUE on success, %FALSE on failure
 */


/**
 * g_input_stream_close_async:
 * @stream: A #GInputStream.
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional cancellable object
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Requests an asynchronous closes of the stream, releasing resources related to it.
 * When the operation is finished @callback will be called.
 * You can then call g_input_stream_close_finish() to get the result of the
 * operation.
 *
 * For behaviour details see g_input_stream_close().
 *
 * The asynchronous methods have a default fallback that uses threads to implement
 * asynchronicity, so they are optional for inheriting classes. However, if you
 * override one you must override all.
 */


/**
 * g_input_stream_close_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes closing a stream asynchronously, started from g_input_stream_close_async().
 *
 * Returns: %TRUE if the stream was closed successfully.
 */


/**
 * g_input_stream_has_pending:
 * @stream: input stream.
 *
 * Checks if an input stream has pending actions.
 *
 * Returns: %TRUE if @stream has pending actions.
 */


/**
 * g_input_stream_is_closed:
 * @stream: input stream.
 *
 * Checks if an input stream is closed.
 *
 * Returns: %TRUE if the stream is closed.
 */


/**
 * g_input_stream_read:
 * @stream: a #GInputStream.
 * @buffer: (array length=count) (element-type guint8) (out caller-allocates):
 *     a buffer to read data into (which should be at least count bytes long).
 * @count: (in): the number of bytes that will be read from the stream
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read @count bytes from the stream into the buffer starting at
 * @buffer. Will block during this read.
 *
 * If count is zero returns zero and does nothing. A value of @count
 * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes read into the buffer is returned.
 * It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file. Zero is returned on end of file
 * (or if @count is zero),  but never otherwise.
 *
 * The returned @buffer is not a nul-terminated string, it can contain nul bytes
 * at any position, and this function doesn't nul-terminate the @buffer.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error -1 is returned and @error is set accordingly.
 *
 * Returns: Number of bytes read, or -1 on error, or 0 on end of file.
 */


/**
 * g_input_stream_read_all:
 * @stream: a #GInputStream.
 * @buffer: (array length=count) (element-type guint8) (out caller-allocates):
 *     a buffer to read data into (which should be at least count bytes long).
 * @count: (in): the number of bytes that will be read from the stream
 * @bytes_read: (out): location to store the number of bytes that was read from the stream
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read @count bytes from the stream into the buffer starting at
 * @buffer. Will block during this read.
 *
 * This function is similar to g_input_stream_read(), except it tries to
 * read as many bytes as requested, only stopping on an error or end of stream.
 *
 * On a successful read of @count bytes, or if we reached the end of the
 * stream,  %TRUE is returned, and @bytes_read is set to the number of bytes
 * read into @buffer.
 *
 * If there is an error during the operation %FALSE is returned and @error
 * is set to indicate the error status.
 *
 * As a special exception to the normal conventions for functions that
 * use #GError, if this function returns %FALSE (and sets @error) then
 * @bytes_read will be set to the number of bytes that were successfully
 * read before the error was encountered.  This functionality is only
 * available from C.  If you need it from another language then you must
 * write your own loop around g_input_stream_read().
 *
 * Returns: %TRUE on success, %FALSE if there was an error
 */


/**
 * g_input_stream_read_all_async:
 * @stream: A #GInputStream
 * @buffer: (array length=count) (element-type guint8) (out caller-allocates):
 *     a buffer to read data into (which should be at least count bytes long)
 * @count: (in): the number of bytes that will be read from the stream
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Request an asynchronous read of @count bytes from the stream into the
 * buffer starting at @buffer.
 *
 * This is the asynchronous equivalent of g_input_stream_read_all().
 *
 * Call g_input_stream_read_all_finish() to collect the result.
 *
 * Any outstanding I/O request with higher priority (lower numerical
 * value) will be executed before an outstanding request with lower
 * priority. Default priority is %G_PRIORITY_DEFAULT.
 *
 * Since: 2.44
 */


/**
 * g_input_stream_read_all_finish:
 * @stream: a #GInputStream
 * @result: a #GAsyncResult
 * @bytes_read: (out): location to store the number of bytes that was read from the stream
 * @error: a #GError location to store the error occurring, or %NULL to ignore
 *
 * Finishes an asynchronous stream read operation started with
 * g_input_stream_read_all_async().
 *
 * As a special exception to the normal conventions for functions that
 * use #GError, if this function returns %FALSE (and sets @error) then
 * @bytes_read will be set to the number of bytes that were successfully
 * read before the error was encountered.  This functionality is only
 * available from C.  If you need it from another language then you must
 * write your own loop around g_input_stream_read_async().
 *
 * Returns: %TRUE on success, %FALSE if there was an error
 * Since: 2.44
 */


/**
 * g_input_stream_read_async:
 * @stream: A #GInputStream.
 * @buffer: (array length=count) (element-type guint8) (out caller-allocates):
 *     a buffer to read data into (which should be at least count bytes long).
 * @count: (in): the number of bytes that will be read from the stream
 * @io_priority: the [I/O priority][io-priority]
 * of the request.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Request an asynchronous read of @count bytes from the stream into the buffer
 * starting at @buffer. When the operation is finished @callback will be called.
 * You can then call g_input_stream_read_finish() to get the result of the
 * operation.
 *
 * During an async request no other sync and async calls are allowed on @stream, and will
 * result in %G_IO_ERROR_PENDING errors.
 *
 * A value of @count larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes read into the buffer will be passed to the
 * callback. It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file, but generally we try to read
 * as many bytes as requested. Zero is returned on end of file
 * (or if @count is zero),  but never otherwise.
 *
 * Any outstanding i/o request with higher priority (lower numerical value) will
 * be executed before an outstanding request with lower priority. Default
 * priority is %G_PRIORITY_DEFAULT.
 *
 * The asynchronous methods have a default fallback that uses threads to implement
 * asynchronicity, so they are optional for inheriting classes. However, if you
 * override one you must override all.
 */


/**
 * g_input_stream_read_bytes:
 * @stream: a #GInputStream.
 * @count: maximum number of bytes that will be read from the stream. Common
 * values include 4096 and 8192.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Like g_input_stream_read(), this tries to read @count bytes from
 * the stream in a blocking fashion. However, rather than reading into
 * a user-supplied buffer, this will create a new #GBytes containing
 * the data that was read. This may be easier to use from language
 * bindings.
 *
 * If count is zero, returns a zero-length #GBytes and does nothing. A
 * value of @count larger than %G_MAXSSIZE will cause a
 * %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, a new #GBytes is returned. It is not an error if the
 * size of this object is not the same as the requested size, as it
 * can happen e.g. near the end of a file. A zero-length #GBytes is
 * returned on end of file (or if @count is zero), but never
 * otherwise.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error %NULL is returned and @error is set accordingly.
 *
 * Returns: (transfer full): a new #GBytes, or %NULL on error
 * Since: 2.34
 */


/**
 * g_input_stream_read_bytes_async:
 * @stream: A #GInputStream.
 * @count: the number of bytes that will be read from the stream
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Request an asynchronous read of @count bytes from the stream into a
 * new #GBytes. When the operation is finished @callback will be
 * called. You can then call g_input_stream_read_bytes_finish() to get the
 * result of the operation.
 *
 * During an async request no other sync and async calls are allowed
 * on @stream, and will result in %G_IO_ERROR_PENDING errors.
 *
 * A value of @count larger than %G_MAXSSIZE will cause a
 * %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the new #GBytes will be passed to the callback. It is
 * not an error if this is smaller than the requested size, as it can
 * happen e.g. near the end of a file, but generally we try to read as
 * many bytes as requested. Zero is returned on end of file (or if
 * @count is zero), but never otherwise.
 *
 * Any outstanding I/O request with higher priority (lower numerical
 * value) will be executed before an outstanding request with lower
 * priority. Default priority is %G_PRIORITY_DEFAULT.
 *
 * Since: 2.34
 */


/**
 * g_input_stream_read_bytes_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *   ignore.
 *
 * Finishes an asynchronous stream read-into-#GBytes operation.
 *
 * Returns: (transfer full): the newly-allocated #GBytes, or %NULL on error
 * Since: 2.34
 */


/**
 * g_input_stream_read_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes an asynchronous stream read operation.
 *
 * Returns: number of bytes read in, or -1 on error, or 0 on end of file.
 */


/**
 * g_input_stream_set_pending:
 * @stream: input stream
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Sets @stream to have actions pending. If the pending flag is
 * already set or @stream is closed, it will return %FALSE and set
 * @error.
 *
 * Returns: %TRUE if pending was previously unset and is now set.
 */


/**
 * g_input_stream_skip:
 * @stream: a #GInputStream.
 * @count: the number of bytes that will be skipped from the stream
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to skip @count bytes from the stream. Will block during the operation.
 *
 * This is identical to g_input_stream_read(), from a behaviour standpoint,
 * but the bytes that are skipped are not returned to the user. Some
 * streams have an implementation that is more efficient than reading the data.
 *
 * This function is optional for inherited classes, as the default implementation
 * emulates it using read.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * Returns: Number of bytes skipped, or -1 on error
 */


/**
 * g_input_stream_skip_async:
 * @stream: A #GInputStream.
 * @count: the number of bytes that will be skipped from the stream
 * @io_priority: the [I/O priority][io-priority] of the request
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Request an asynchronous skip of @count bytes from the stream.
 * When the operation is finished @callback will be called.
 * You can then call g_input_stream_skip_finish() to get the result
 * of the operation.
 *
 * During an async request no other sync and async calls are allowed,
 * and will result in %G_IO_ERROR_PENDING errors.
 *
 * A value of @count larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes skipped will be passed to the callback.
 * It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file, but generally we try to skip
 * as many bytes as requested. Zero is returned on end of file
 * (or if @count is zero), but never otherwise.
 *
 * Any outstanding i/o request with higher priority (lower numerical value)
 * will be executed before an outstanding request with lower priority.
 * Default priority is %G_PRIORITY_DEFAULT.
 *
 * The asynchronous methods have a default fallback that uses threads to
 * implement asynchronicity, so they are optional for inheriting classes.
 * However, if you override one, you must override all.
 */


/**
 * g_input_stream_skip_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes a stream skip operation.
 *
 * Returns: the size of the bytes skipped, or `-1` on error.
 */


/**
 * g_io_error_from_errno:
 * @err_no: Error number as defined in errno.h.
 *
 * Converts errno.h error codes into GIO error codes. The fallback
 * value %G_IO_ERROR_FAILED is returned for error codes not currently
 * handled (but note that future GLib releases may return a more
 * specific value instead).
 *
 * As %errno is global and may be modified by intermediate function
 * calls, you should save its value as soon as the call which sets it
 *
 * Returns: #GIOErrorEnum value for the given errno.h error number.
 */


/**
 * g_io_error_from_file_error:
 * @file_error: a #GFileError.
 *
 * Converts #GFileError error codes into GIO error codes.
 *
 * Returns: #GIOErrorEnum value for the given #GFileError error value.
 * Since: 2.74
 */


/**
 * g_io_error_from_win32_error:
 * @error_code: Windows error number.
 *
 * Converts some common error codes (as returned from GetLastError()
 * or WSAGetLastError()) into GIO error codes. The fallback value
 * %G_IO_ERROR_FAILED is returned for error codes not currently
 * handled (but note that future GLib releases may return a more
 * specific value instead).
 *
 * You can use g_win32_error_message() to get a localized string
 * corresponding to @error_code. (But note that unlike g_strerror(),
 * g_win32_error_message() returns a string that must be freed.)
 *
 * Returns: #GIOErrorEnum value for the given error number.
 * Since: 2.26
 */


/**
 * g_io_error_quark:
 *
 * Gets the GIO Error Quark.
 *
 * Returns: a #GQuark.
 */


/**
 * g_io_extension_get_name:
 * @extension: a #GIOExtension
 *
 * Gets the name under which @extension was registered.
 *
 * Note that the same type may be registered as extension
 * for multiple extension points, under different names.
 *
 * Returns: the name of @extension.
 */


/**
 * g_io_extension_get_priority:
 * @extension: a #GIOExtension
 *
 * Gets the priority with which @extension was registered.
 *
 * Returns: the priority of @extension
 */


/**
 * g_io_extension_get_type:
 * @extension: a #GIOExtension
 *
 * Gets the type associated with @extension.
 *
 * Returns: the type of @extension
 */


/**
 * g_io_extension_point_get_extension_by_name:
 * @extension_point: a #GIOExtensionPoint
 * @name: the name of the extension to get
 *
 * Finds a #GIOExtension for an extension point by name.
 *
 * Returns: (transfer none): the #GIOExtension for @extension_point that has the
 *    given name, or %NULL if there is no extension with that name
 */


/**
 * g_io_extension_point_get_extensions:
 * @extension_point: a #GIOExtensionPoint
 *
 * Gets a list of all extensions that implement this extension point.
 * The list is sorted by priority, beginning with the highest priority.
 *
 * Returns: (element-type GIOExtension) (transfer none): a #GList of
 *     #GIOExtensions. The list is owned by GIO and should not be
 *     modified.
 */


/**
 * g_io_extension_point_get_required_type:
 * @extension_point: a #GIOExtensionPoint
 *
 * Gets the required type for @extension_point.
 *
 * Returns: the #GType that all implementations must have,
 *   or %G_TYPE_INVALID if the extension point has no required type
 */


/**
 * g_io_extension_point_implement:
 * @extension_point_name: the name of the extension point
 * @type: the #GType to register as extension
 * @extension_name: the name for the extension
 * @priority: the priority for the extension
 *
 * Registers @type as extension for the extension point with name
 * @extension_point_name.
 *
 * If @type has already been registered as an extension for this
 * extension point, the existing #GIOExtension object is returned.
 *
 * Returns: (transfer none): a #GIOExtension object for #GType
 */


/**
 * g_io_extension_point_lookup:
 * @name: the name of the extension point
 *
 * Looks up an existing extension point.
 *
 * Returns: (transfer none): the #GIOExtensionPoint, or %NULL if there
 *    is no registered extension point with the given name.
 */


/**
 * g_io_extension_point_register:
 * @name: The name of the extension point
 *
 * Registers an extension point.
 *
 * Returns: (transfer none): the new #GIOExtensionPoint. This object is
 *    owned by GIO and should not be freed.
 */


/**
 * g_io_extension_point_set_required_type:
 * @extension_point: a #GIOExtensionPoint
 * @type: the #GType to require
 *
 * Sets the required type for @extension_point to @type.
 * All implementations must henceforth have this type.
 */


/**
 * g_io_extension_ref_class:
 * @extension: a #GIOExtension
 *
 * Gets a reference to the class for the type that is
 * associated with @extension.
 *
 * Returns: (transfer full): the #GTypeClass for the type of @extension
 */


/**
 * g_io_module_new:
 * @filename: (type filename): filename of the shared library module.
 *
 * Creates a new GIOModule that will load the specific
 * shared library when in use.
 *
 * Returns: a #GIOModule from given @filename,
 * or %NULL on error.
 */


/**
 * g_io_module_scope_block:
 * @scope: a module loading scope
 * @basename: the basename to block
 *
 * Block modules with the given @basename from being loaded when
 * this scope is used with g_io_modules_scan_all_in_directory_with_scope()
 * or g_io_modules_load_all_in_directory_with_scope().
 *
 * Since: 2.30
 */


/**
 * g_io_module_scope_free:
 * @scope: a module loading scope
 *
 * Free a module scope.
 *
 * Since: 2.30
 */


/**
 * g_io_module_scope_new:
 * @flags: flags for the new scope
 *
 * Create a new scope for loading of IO modules. A scope can be used for
 * blocking duplicate modules, or blocking a module you don't want to load.
 *
 * Specify the %G_IO_MODULE_SCOPE_BLOCK_DUPLICATES flag to block modules
 * which have the same base name as a module that has already been seen
 * in this scope.
 *
 * Returns: (transfer full): the new module scope
 * Since: 2.30
 */


/**
 * g_io_modules_load_all_in_directory:
 * @dirname: (type filename): pathname for a directory containing modules
 *     to load.
 *
 * Loads all the modules in the specified directory.
 *
 * If don't require all modules to be initialized (and thus registering
 * all gtypes) then you can use g_io_modules_scan_all_in_directory()
 * which allows delayed/lazy loading of modules.
 *
 * Returns: (element-type GIOModule) (transfer full): a list of #GIOModules loaded
 *      from the directory,
 *      All the modules are loaded into memory, if you want to
 *      unload them (enabling on-demand loading) you must call
 *      g_type_module_unuse() on all the modules. Free the list
 *      with g_list_free().
 */


/**
 * g_io_modules_load_all_in_directory_with_scope:
 * @dirname: (type filename): pathname for a directory containing modules
 *     to load.
 * @scope: a scope to use when scanning the modules.
 *
 * Loads all the modules in the specified directory.
 *
 * If don't require all modules to be initialized (and thus registering
 * all gtypes) then you can use g_io_modules_scan_all_in_directory()
 * which allows delayed/lazy loading of modules.
 *
 * Returns: (element-type GIOModule) (transfer full): a list of #GIOModules loaded
 *      from the directory,
 *      All the modules are loaded into memory, if you want to
 *      unload them (enabling on-demand loading) you must call
 *      g_type_module_unuse() on all the modules. Free the list
 *      with g_list_free().
 * Since: 2.30
 */


/**
 * g_io_modules_scan_all_in_directory:
 * @dirname: (type filename): pathname for a directory containing modules
 *     to scan.
 *
 * Scans all the modules in the specified directory, ensuring that
 * any extension point implemented by a module is registered.
 *
 * This may not actually load and initialize all the types in each
 * module, some modules may be lazily loaded and initialized when
 * an extension point it implements is used with e.g.
 * g_io_extension_point_get_extensions() or
 * g_io_extension_point_get_extension_by_name().
 *
 * If you need to guarantee that all types are loaded in all the modules,
 * use g_io_modules_load_all_in_directory().
 *
 * Since: 2.24
 */


/**
 * g_io_modules_scan_all_in_directory_with_scope:
 * @dirname: (type filename): pathname for a directory containing modules
 *     to scan.
 * @scope: a scope to use when scanning the modules
 *
 * Scans all the modules in the specified directory, ensuring that
 * any extension point implemented by a module is registered.
 *
 * This may not actually load and initialize all the types in each
 * module, some modules may be lazily loaded and initialized when
 * an extension point it implements is used with e.g.
 * g_io_extension_point_get_extensions() or
 * g_io_extension_point_get_extension_by_name().
 *
 * If you need to guarantee that all types are loaded in all the modules,
 * use g_io_modules_load_all_in_directory().
 *
 * Since: 2.30
 */


/**
 * g_io_scheduler_cancel_all_jobs:
 *
 * Cancels all cancellable I/O jobs.
 *
 * A job is cancellable if a #GCancellable was passed into
 * g_io_scheduler_push_job().
 *
 * Deprecated: You should never call this function, since you don't
 * know how other libraries in your program might be making use of
 * gioscheduler.
 */


/**
 * g_io_scheduler_job_send_to_mainloop:
 * @job: a #GIOSchedulerJob
 * @func: a #GSourceFunc callback that will be called in the original thread
 * @user_data: data to pass to @func
 * @notify: (nullable): a #GDestroyNotify for @user_data, or %NULL
 *
 * Used from an I/O job to send a callback to be run in the thread
 * that the job was started from, waiting for the result (and thus
 * blocking the I/O job).
 *
 * Returns: The return value of @func
 * Deprecated: Use g_main_context_invoke().
 */


/**
 * g_io_scheduler_job_send_to_mainloop_async:
 * @job: a #GIOSchedulerJob
 * @func: a #GSourceFunc callback that will be called in the original thread
 * @user_data: data to pass to @func
 * @notify: (nullable): a #GDestroyNotify for @user_data, or %NULL
 *
 * Used from an I/O job to send a callback to be run asynchronously in
 * the thread that the job was started from. The callback will be run
 * when the main loop is available, but at that time the I/O job might
 * have finished. The return value from the callback is ignored.
 *
 * Note that if you are passing the @user_data from g_io_scheduler_push_job()
 * on to this function you have to ensure that it is not freed before
 * @func is called, either by passing %NULL as @notify to
 * g_io_scheduler_push_job() or by using refcounting for @user_data.
 *
 * Deprecated: Use g_main_context_invoke().
 */


/**
 * g_io_scheduler_push_job:
 * @job_func: a #GIOSchedulerJobFunc.
 * @user_data: data to pass to @job_func
 * @notify: (nullable): a #GDestroyNotify for @user_data, or %NULL
 * @io_priority: the [I/O priority][io-priority]
 * of the request.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 *
 * Schedules the I/O job to run in another thread.
 *
 * @notify will be called on @user_data after @job_func has returned,
 * regardless whether the job was cancelled or has run to completion.
 *
 * If @cancellable is not %NULL, it can be used to cancel the I/O job
 * by calling g_cancellable_cancel() or by calling
 * g_io_scheduler_cancel_all_jobs().
 *
 * Deprecated: use #GThreadPool or g_task_run_in_thread()
 */


/**
 * g_io_stream_clear_pending:
 * @stream: a #GIOStream
 *
 * Clears the pending flag on @stream.
 *
 * Since: 2.22
 */


/**
 * g_io_stream_close:
 * @stream: a #GIOStream
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Closes the stream, releasing resources related to it. This will also
 * close the individual input and output streams, if they are not already
 * closed.
 *
 * Once the stream is closed, all other operations will return
 * %G_IO_ERROR_CLOSED. Closing a stream multiple times will not
 * return an error.
 *
 * Closing a stream will automatically flush any outstanding buffers
 * in the stream.
 *
 * Streams will be automatically closed when the last reference
 * is dropped, but you might want to call this function to make sure
 * resources are released as early as possible.
 *
 * Some streams might keep the backing store of the stream (e.g. a file
 * descriptor) open after the stream is closed. See the documentation for
 * the individual stream for details.
 *
 * On failure the first error that happened will be reported, but the
 * close operation will finish as much as possible. A stream that failed
 * to close will still return %G_IO_ERROR_CLOSED for all operations.
 * Still, it is important to check and report the error to the user,
 * otherwise there might be a loss of data as all data might not be written.
 *
 * If @cancellable is not NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 * Cancelling a close will still leave the stream closed, but some streams
 * can use a faster close that doesn't block to e.g. check errors.
 *
 * The default implementation of this method just calls close on the
 * individual input/output streams.
 *
 * Returns: %TRUE on success, %FALSE on failure
 * Since: 2.22
 */


/**
 * g_io_stream_close_async:
 * @stream: a #GIOStream
 * @io_priority: the io priority of the request
 * @cancellable: (nullable): optional cancellable object
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Requests an asynchronous close of the stream, releasing resources
 * related to it. When the operation is finished @callback will be
 * called. You can then call g_io_stream_close_finish() to get
 * the result of the operation.
 *
 * For behaviour details see g_io_stream_close().
 *
 * The asynchronous methods have a default fallback that uses threads
 * to implement asynchronicity, so they are optional for inheriting
 * classes. However, if you override one you must override all.
 *
 * Since: 2.22
 */


/**
 * g_io_stream_close_finish:
 * @stream: a #GIOStream
 * @result: a #GAsyncResult
 * @error: a #GError location to store the error occurring, or %NULL to
 *    ignore
 *
 * Closes a stream.
 *
 * Returns: %TRUE if stream was successfully closed, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_io_stream_get_input_stream:
 * @stream: a #GIOStream
 *
 * Gets the input stream for this object. This is used
 * for reading.
 *
 * Returns: (transfer none): a #GInputStream, owned by the #GIOStream.
 * Do not free.
 * Since: 2.22
 */


/**
 * g_io_stream_get_output_stream:
 * @stream: a #GIOStream
 *
 * Gets the output stream for this object. This is used for
 * writing.
 *
 * Returns: (transfer none): a #GOutputStream, owned by the #GIOStream.
 * Do not free.
 * Since: 2.22
 */


/**
 * g_io_stream_has_pending:
 * @stream: a #GIOStream
 *
 * Checks if a stream has pending actions.
 *
 * Returns: %TRUE if @stream has pending actions.
 * Since: 2.22
 */


/**
 * g_io_stream_is_closed:
 * @stream: a #GIOStream
 *
 * Checks if a stream is closed.
 *
 * Returns: %TRUE if the stream is closed.
 * Since: 2.22
 */


/**
 * g_io_stream_set_pending:
 * @stream: a #GIOStream
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore
 *
 * Sets @stream to have actions pending. If the pending flag is
 * already set or @stream is closed, it will return %FALSE and set
 * @error.
 *
 * Returns: %TRUE if pending was previously unset and is now set.
 * Since: 2.22
 */


/**
 * g_io_stream_splice_async:
 * @stream1: a #GIOStream.
 * @stream2: a #GIOStream.
 * @flags: a set of #GIOStreamSpliceFlags.
 * @io_priority: the io priority of the request.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously splice the output stream of @stream1 to the input stream of
 * @stream2, and splice the output stream of @stream2 to the input stream of
 * @stream1.
 *
 * When the operation is finished @callback will be called.
 * You can then call g_io_stream_splice_finish() to get the
 * result of the operation.
 *
 * Since: 2.28
 */


/**
 * g_io_stream_splice_finish:
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes an asynchronous io stream splice operation.
 *
 * Returns: %TRUE on success, %FALSE otherwise.
 * Since: 2.28
 */


/**
 * g_keyfile_settings_backend_new:
 * @filename: the filename of the keyfile
 * @root_path: the path under which all settings keys appear
 * @root_group: (nullable): the group name corresponding to
 *              @root_path, or %NULL
 *
 * Creates a keyfile-backed #GSettingsBackend.
 *
 * The filename of the keyfile to use is given by @filename.
 *
 * All settings read to or written from the backend must fall under the
 * path given in @root_path (which must start and end with a slash and
 * not contain two consecutive slashes).  @root_path may be "/".
 *
 * If @root_group is non-%NULL then it specifies the name of the keyfile
 * group used for keys that are written directly below @root_path.  For
 * example, if @root_path is "/apps/example/" and @root_group is
 * "toplevel", then settings the key "/apps/example/enabled" to a value
 * of %TRUE will cause the following to appear in the keyfile:
 *
 * |[
 *   [toplevel]
 *   enabled=true
 * ]|
 *
 * If @root_group is %NULL then it is not permitted to store keys
 * directly below the @root_path.
 *
 * For keys not stored directly below @root_path (ie: in a sub-path),
 * the name of the subpath (with the final slash stripped) is used as
 * the name of the keyfile group.  To continue the example, if
 * "/apps/example/profiles/default/font-size" were set to
 * 12 then the following would appear in the keyfile:
 *
 * |[
 *   [profiles/default]
 *   font-size=12
 * ]|
 *
 * The backend will refuse writes (and return writability as being
 * %FALSE) for keys outside of @root_path and, in the event that
 * @root_group is %NULL, also for keys directly under @root_path.
 * Writes will also be refused if the backend detects that it has the
 * inability to rewrite the keyfile (ie: the containing directory is not
 * writable).
 *
 * There is no checking done for your key namespace clashing with the
 * syntax of the key file format.  For example, if you have '[' or ']'
 * characters in your path names or '=' in your key names you may be in
 * trouble.
 *
 * The backend reads default values from a keyfile called `defaults` in
 * the directory specified by the #GKeyfileSettingsBackend:defaults-dir property,
 * and a list of locked keys from a text file with the name `locks` in
 * the same location.
 *
 * Returns: (transfer full): a keyfile-backed #GSettingsBackend
 */


/**
 * g_list_model_get_item: (skip)
 * @list: a #GListModel
 * @position: the position of the item to fetch
 *
 * Get the item at @position.
 *
 * If @position is greater than the number of items in @list, %NULL is
 * returned.
 *
 * %NULL is never returned for an index that is smaller than the length
 * of the list.
 *
 * See also: g_list_model_get_n_items()
 *
 * Returns: (transfer full) (nullable): the item at @position.
 * Since: 2.44
 */


/**
 * g_list_model_get_item_type:
 * @list: a #GListModel
 *
 * Gets the type of the items in @list.
 *
 * All items returned from g_list_model_get_item() are of the type
 * returned by this function, or a subtype, or if the type is an
 * interface, they are an implementation of that interface.
 *
 * The item type of a #GListModel can not change during the life of the
 * model.
 *
 * Returns: the #GType of the items contained in @list.
 * Since: 2.44
 */


/**
 * g_list_model_get_n_items:
 * @list: a #GListModel
 *
 * Gets the number of items in @list.
 *
 * Depending on the model implementation, calling this function may be
 * less efficient than iterating the list with increasing values for
 * @position until g_list_model_get_item() returns %NULL.
 *
 * Returns: the number of items in @list.
 * Since: 2.44
 */


/**
 * g_list_model_get_object: (rename-to g_list_model_get_item)
 * @list: a #GListModel
 * @position: the position of the item to fetch
 *
 * Get the item at @position.
 *
 * If @position is greater than the number of items in @list, %NULL is
 * returned.
 *
 * %NULL is never returned for an index that is smaller than the length
 * of the list.
 *
 * This function is meant to be used by language bindings in place
 * of g_list_model_get_item().
 *
 * See also: g_list_model_get_n_items()
 *
 * Returns: (transfer full) (nullable): the object at @position.
 * Since: 2.44
 */


/**
 * g_list_model_items_changed:
 * @list: a #GListModel
 * @position: the position at which @list changed
 * @removed: the number of items removed
 * @added: the number of items added
 *
 * Emits the #GListModel::items-changed signal on @list.
 *
 * This function should only be called by classes implementing
 * #GListModel. It has to be called after the internal representation
 * of @list has been updated, because handlers connected to this signal
 * might query the new state of the list.
 *
 * Implementations must only make changes to the model (as visible to
 * its consumer) in places that will not cause problems for that
 * consumer.  For models that are driven directly by a write API (such
 * as #GListStore), changes can be reported in response to uses of that
 * API.  For models that represent remote data, changes should only be
 * made from a fresh mainloop dispatch.  It is particularly not
 * permitted to make changes in response to a call to the #GListModel
 * consumer API.
 *
 * Stated another way: in general, it is assumed that code making a
 * series of accesses to the model via the API, without returning to the
 * mainloop, and without calling other code, will continue to view the
 * same contents of the model.
 *
 * Since: 2.44
 */


/**
 * g_list_store_append:
 * @store: a #GListStore
 * @item: (type GObject): the new item
 *
 * Appends @item to @store. @item must be of type #GListStore:item-type.
 *
 * This function takes a ref on @item.
 *
 * Use g_list_store_splice() to append multiple items at the same time
 * efficiently.
 *
 * Since: 2.44
 */


/**
 * g_list_store_find:
 * @store: a #GListStore
 * @item: (type GObject): an item
 * @position: (out) (optional): the first position of @item, if it was found.
 *
 * Looks up the given @item in the list store by looping over the items until
 * the first occurrence of @item. If @item was not found, then @position will
 * not be set, and this method will return %FALSE.
 *
 * If you need to compare the two items with a custom comparison function, use
 * g_list_store_find_with_equal_func() with a custom #GEqualFunc instead.
 *
 * Returns: Whether @store contains @item. If it was found, @position will be
 * set to the position where @item occurred for the first time.
 * Since: 2.64
 */


/**
 * g_list_store_find_with_equal_func:
 * @store: a #GListStore
 * @item: (type GObject) (nullable): an item
 * @equal_func: (scope call): A custom equality check function
 * @position: (out) (optional): the first position of @item, if it was found.
 *
 * Looks up the given @item in the list store by looping over the items and
 * comparing them with @equal_func until the first occurrence of @item which
 * matches. If @item was not found, then @position will not be set, and this
 * method will return %FALSE.
 *
 * @item is always passed as second parameter to @equal_func.
 *
 * Since GLib 2.76 it is possible to pass `NULL` for @item.
 *
 * Returns: Whether @store contains @item. If it was found, @position will be
 * set to the position where @item occurred for the first time.
 * Since: 2.64
 */


/**
 * g_list_store_find_with_equal_func_full:
 * @store: a #GListStore
 * @item: (type GObject) (nullable): an item
 * @equal_func: (scope call) (closure user_data): A custom equality check function
 * @user_data: user data for @equal_func
 * @position: (out) (optional): the first position of @item, if it was found.
 *
 * Like g_list_store_find_with_equal_func() but with an additional @user_data
 * that is passed to @equal_func.
 *
 * @item is always passed as second parameter to @equal_func.
 *
 * Since GLib 2.76 it is possible to pass `NULL` for @item.
 *
 * Returns: Whether @store contains @item. If it was found, @position will be
 * set to the position where @item occurred for the first time.
 * Since: 2.74
 */


/**
 * g_list_store_insert:
 * @store: a #GListStore
 * @position: the position at which to insert the new item
 * @item: (type GObject): the new item
 *
 * Inserts @item into @store at @position. @item must be of type
 * #GListStore:item-type or derived from it. @position must be smaller
 * than the length of the list, or equal to it to append.
 *
 * This function takes a ref on @item.
 *
 * Use g_list_store_splice() to insert multiple items at the same time
 * efficiently.
 *
 * Since: 2.44
 */


/**
 * g_list_store_insert_sorted:
 * @store: a #GListStore
 * @item: (type GObject): the new item
 * @compare_func: (scope call) (closure user_data): pairwise comparison function for sorting
 * @user_data: user data for @compare_func
 *
 * Inserts @item into @store at a position to be determined by the
 * @compare_func.
 *
 * The list must already be sorted before calling this function or the
 * result is undefined.  Usually you would approach this by only ever
 * inserting items by way of this function.
 *
 * This function takes a ref on @item.
 *
 * Returns: the position at which @item was inserted
 * Since: 2.44
 */


/**
 * g_list_store_new:
 * @item_type: the #GType of items in the list
 *
 * Creates a new #GListStore with items of type @item_type. @item_type
 * must be a subclass of #GObject.
 *
 * Returns: a new #GListStore
 * Since: 2.44
 */


/**
 * g_list_store_remove:
 * @store: a #GListStore
 * @position: the position of the item that is to be removed
 *
 * Removes the item from @store that is at @position. @position must be
 * smaller than the current length of the list.
 *
 * Use g_list_store_splice() to remove multiple items at the same time
 * efficiently.
 *
 * Since: 2.44
 */


/**
 * g_list_store_remove_all:
 * @store: a #GListStore
 *
 * Removes all items from @store.
 *
 * Since: 2.44
 */


/**
 * g_list_store_sort:
 * @store: a #GListStore
 * @compare_func: (scope call) (closure user_data): pairwise comparison function for sorting
 * @user_data: user data for @compare_func
 *
 * Sort the items in @store according to @compare_func.
 *
 * Since: 2.46
 */


/**
 * g_list_store_splice:
 * @store: a #GListStore
 * @position: the position at which to make the change
 * @n_removals: the number of items to remove
 * @additions: (array length=n_additions) (element-type GObject): the items to add
 * @n_additions: the number of items to add
 *
 * Changes @store by removing @n_removals items and adding @n_additions
 * items to it. @additions must contain @n_additions items of type
 * #GListStore:item-type.  %NULL is not permitted.
 *
 * This function is more efficient than g_list_store_insert() and
 * g_list_store_remove(), because it only emits
 * #GListModel::items-changed once for the change.
 *
 * This function takes a ref on each item in @additions.
 *
 * The parameters @position and @n_removals must be correct (ie:
 * @position + @n_removals must be less than or equal to the length of
 * the list at the time this function is called).
 *
 * Since: 2.44
 */


/**
 * g_loadable_icon_load:
 * @icon: a #GLoadableIcon.
 * @size: an integer.
 * @type: (out) (optional): a location to store the type of the loaded
 * icon, %NULL to ignore.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to
 * ignore.
 * @error: a #GError location to store the error occurring, or %NULL
 * to ignore.
 *
 * Loads a loadable icon. For the asynchronous version of this function,
 * see g_loadable_icon_load_async().
 *
 * Returns: (transfer full): a #GInputStream to read the icon from.
 */


/**
 * g_loadable_icon_load_async:
 * @icon: a #GLoadableIcon.
 * @size: an integer.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback
 *   to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Loads an icon asynchronously. To finish this function, see
 * g_loadable_icon_load_finish(). For the synchronous, blocking
 * version of this function, see g_loadable_icon_load().
 */


/**
 * g_loadable_icon_load_finish:
 * @icon: a #GLoadableIcon.
 * @res: a #GAsyncResult.
 * @type: (out) (optional): a location to store the type of the loaded
 *        icon, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to
 * ignore.
 *
 * Finishes an asynchronous icon load started in g_loadable_icon_load_async().
 *
 * Returns: (transfer full): a #GInputStream to read the icon from.
 */


/**
 * g_local_vfs_new:
 *
 * Returns a new #GVfs handle for a local vfs.
 *
 * Returns: a new #GVfs handle.
 */


/**
 * g_memory_input_stream_add_bytes:
 * @stream: a #GMemoryInputStream
 * @bytes: input data
 *
 * Appends @bytes to data that can be read from the input stream.
 *
 * Since: 2.34
 */


/**
 * g_memory_input_stream_add_data:
 * @stream: a #GMemoryInputStream
 * @data: (array length=len) (element-type guint8) (transfer full): input data
 * @len: length of the data, may be -1 if @data is a nul-terminated string
 * @destroy: (nullable): function that is called to free @data, or %NULL
 *
 * Appends @data to data that can be read from the input stream
 */


/**
 * g_memory_input_stream_new:
 *
 * Creates a new empty #GMemoryInputStream.
 *
 * Returns: a new #GInputStream
 */


/**
 * g_memory_input_stream_new_from_bytes:
 * @bytes: a #GBytes
 *
 * Creates a new #GMemoryInputStream with data from the given @bytes.
 *
 * Returns: new #GInputStream read from @bytes
 * Since: 2.34
 */


/**
 * g_memory_input_stream_new_from_data:
 * @data: (array length=len) (element-type guint8) (transfer full): input data
 * @len: length of the data, may be -1 if @data is a nul-terminated string
 * @destroy: (nullable): function that is called to free @data, or %NULL
 *
 * Creates a new #GMemoryInputStream with data in memory of a given size.
 *
 * Returns: new #GInputStream read from @data of @len bytes.
 */


/**
 * g_memory_monitor_dup_default:
 *
 * Gets a reference to the default #GMemoryMonitor for the system.
 *
 * Returns: (not nullable) (transfer full): a new reference to the default #GMemoryMonitor
 * Since: 2.64
 */


/**
 * g_memory_output_stream_get_data:
 * @ostream: a #GMemoryOutputStream
 *
 * Gets any loaded data from the @ostream.
 *
 * Note that the returned pointer may become invalid on the next
 * write or truncate operation on the stream.
 *
 * Returns: (transfer none): pointer to the stream's data, or %NULL if the data
 *    has been stolen
 */


/**
 * g_memory_output_stream_get_data_size:
 * @ostream: a #GMemoryOutputStream
 *
 * Returns the number of bytes from the start up to including the last
 * byte written in the stream that has not been truncated away.
 *
 * Returns: the number of bytes written to the stream
 * Since: 2.18
 */


/**
 * g_memory_output_stream_get_size:
 * @ostream: a #GMemoryOutputStream
 *
 * Gets the size of the currently allocated data area (available from
 * g_memory_output_stream_get_data()).
 *
 * You probably don't want to use this function on resizable streams.
 * See g_memory_output_stream_get_data_size() instead.  For resizable
 * streams the size returned by this function is an implementation
 * detail and may be change at any time in response to operations on the
 * stream.
 *
 * If the stream is fixed-sized (ie: no realloc was passed to
 * g_memory_output_stream_new()) then this is the maximum size of the
 * stream and further writes will return %G_IO_ERROR_NO_SPACE.
 *
 * In any case, if you want the number of bytes currently written to the
 * stream, use g_memory_output_stream_get_data_size().
 *
 * Returns: the number of bytes allocated for the data buffer
 */


/**
 * g_memory_output_stream_new: (skip)
 * @data: (nullable): pointer to a chunk of memory to use, or %NULL
 * @size: the size of @data
 * @realloc_function: (nullable): a function with realloc() semantics (like g_realloc())
 *     to be called when @data needs to be grown, or %NULL
 * @destroy_function: (nullable): a function to be called on @data when the stream is
 *     finalized, or %NULL
 *
 * Creates a new #GMemoryOutputStream.
 *
 * In most cases this is not the function you want.  See
 * g_memory_output_stream_new_resizable() instead.
 *
 * If @data is non-%NULL, the stream will use that for its internal storage.
 *
 * If @realloc_fn is non-%NULL, it will be used for resizing the internal
 * storage when necessary and the stream will be considered resizable.
 * In that case, the stream will start out being (conceptually) empty.
 * @size is used only as a hint for how big @data is.  Specifically,
 * seeking to the end of a newly-created stream will seek to zero, not
 * @size.  Seeking past the end of the stream and then writing will
 * introduce a zero-filled gap.
 *
 * If @realloc_fn is %NULL then the stream is fixed-sized.  Seeking to
 * the end will seek to @size exactly.  Writing past the end will give
 * an 'out of space' error.  Attempting to seek past the end will fail.
 * Unlike the resizable case, seeking to an offset within the stream and
 * writing will preserve the bytes passed in as @data before that point
 * and will return them as part of g_memory_output_stream_steal_data().
 * If you intend to seek you should probably therefore ensure that @data
 * is properly initialised.
 *
 * It is probably only meaningful to provide @data and @size in the case
 * that you want a fixed-sized stream.  Put another way: if @realloc_fn
 * is non-%NULL then it makes most sense to give @data as %NULL and
 * @size as 0 (allowing #GMemoryOutputStream to do the initial
 * allocation for itself).
 *
 * |[<!-- language="C" -->
 * // a stream that can grow
 * stream = g_memory_output_stream_new (NULL, 0, realloc, free);
 *
 * // another stream that can grow
 * stream2 = g_memory_output_stream_new (NULL, 0, g_realloc, g_free);
 *
 * // a fixed-size stream
 * data = malloc (200);
 * stream3 = g_memory_output_stream_new (data, 200, NULL, free);
 * ]|
 *
 * Returns: A newly created #GMemoryOutputStream object.
 */


/**
 * g_memory_output_stream_new_resizable:
 *
 * Creates a new #GMemoryOutputStream, using g_realloc() and g_free()
 * for memory allocation.
 *
 * Since: 2.36
 */


/**
 * g_memory_output_stream_steal_as_bytes:
 * @ostream: a #GMemoryOutputStream
 *
 * Returns data from the @ostream as a #GBytes. @ostream must be
 * closed before calling this function.
 *
 * Returns: (transfer full): the stream's data
 * Since: 2.34
 */


/**
 * g_memory_output_stream_steal_data:
 * @ostream: a #GMemoryOutputStream
 *
 * Gets any loaded data from the @ostream. Ownership of the data
 * is transferred to the caller; when no longer needed it must be
 * freed using the free function set in @ostream's
 * #GMemoryOutputStream:destroy-function property.
 *
 * @ostream must be closed before calling this function.
 *
 * Returns: (transfer full): the stream's data, or %NULL if it has previously
 *    been stolen
 * Since: 2.26
 */


/**
 * g_memory_settings_backend_new:
 *
 * Creates a memory-backed #GSettingsBackend.
 *
 * This backend allows changes to settings, but does not write them
 * to any backing storage, so the next time you run your application,
 * the memory backend will start out with the default values again.
 *
 * Returns: (transfer full): a newly created #GSettingsBackend
 * Since: 2.28
 */


/**
 * g_menu_append:
 * @menu: a #GMenu
 * @label: (nullable): the section label, or %NULL
 * @detailed_action: (nullable): the detailed action string, or %NULL
 *
 * Convenience function for appending a normal menu item to the end of
 * @menu.  Combine g_menu_item_new() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_append_item:
 * @menu: a #GMenu
 * @item: a #GMenuItem to append
 *
 * Appends @item to the end of @menu.
 *
 * See g_menu_insert_item() for more information.
 *
 * Since: 2.32
 */


/**
 * g_menu_append_section:
 * @menu: a #GMenu
 * @label: (nullable): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Convenience function for appending a section menu item to the end of
 * @menu.  Combine g_menu_item_new_section() and g_menu_insert_item() for a
 * more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_append_submenu:
 * @menu: a #GMenu
 * @label: (nullable): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Convenience function for appending a submenu menu item to the end of
 * @menu.  Combine g_menu_item_new_submenu() and g_menu_insert_item() for a
 * more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_get_name:
 * @iter: a #GMenuAttributeIter
 *
 * Gets the name of the attribute at the current iterator position, as
 * a string.
 *
 * The iterator is not advanced.
 *
 * Returns: the name of the attribute
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_get_next:
 * @iter: a #GMenuAttributeIter
 * @out_name: (out) (optional) (transfer none): the type of the attribute
 * @value: (out) (optional) (transfer full): the attribute value
 *
 * This function combines g_menu_attribute_iter_next() with
 * g_menu_attribute_iter_get_name() and g_menu_attribute_iter_get_value().
 *
 * First the iterator is advanced to the next (possibly first) attribute.
 * If that fails, then %FALSE is returned and there are no other
 * effects.
 *
 * If successful, @name and @value are set to the name and value of the
 * attribute that has just been advanced to.  At this point,
 * g_menu_attribute_iter_get_name() and g_menu_attribute_iter_get_value() will
 * return the same values again.
 *
 * The value returned in @name remains valid for as long as the iterator
 * remains at the current position.  The value returned in @value must
 * be unreffed using g_variant_unref() when it is no longer in use.
 *
 * Returns: %TRUE on success, or %FALSE if there is no additional
 *     attribute
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_get_value:
 * @iter: a #GMenuAttributeIter
 *
 * Gets the value of the attribute at the current iterator position.
 *
 * The iterator is not advanced.
 *
 * Returns: (transfer full): the value of the current attribute
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_next:
 * @iter: a #GMenuAttributeIter
 *
 * Attempts to advance the iterator to the next (possibly first)
 * attribute.
 *
 * %TRUE is returned on success, or %FALSE if there are no more
 * attributes.
 *
 * You must call this function when you first acquire the iterator
 * to advance it to the first attribute (and determine if the first
 * attribute exists at all).
 *
 * Returns: %TRUE on success, or %FALSE when there are no more attributes
 * Since: 2.32
 */


/**
 * g_menu_freeze:
 * @menu: a #GMenu
 *
 * Marks @menu as frozen.
 *
 * After the menu is frozen, it is an error to attempt to make any
 * changes to it.  In effect this means that the #GMenu API must no
 * longer be used.
 *
 * This function causes g_menu_model_is_mutable() to begin returning
 * %FALSE, which has some positive performance implications.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @label: (nullable): the section label, or %NULL
 * @detailed_action: (nullable): the detailed action string, or %NULL
 *
 * Convenience function for inserting a normal menu item into @menu.
 * Combine g_menu_item_new() and g_menu_insert_item() for a more flexible
 * alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert_item:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @item: the #GMenuItem to insert
 *
 * Inserts @item into @menu.
 *
 * The "insertion" is actually done by copying all of the attribute and
 * link values of @item and using them to form a new item within @menu.
 * As such, @item itself is not really inserted, but rather, a menu item
 * that is exactly the same as the one presently described by @item.
 *
 * This means that @item is essentially useless after the insertion
 * occurs.  Any changes you make to it are ignored unless it is inserted
 * again (at which point its updated values will be copied).
 *
 * You should probably just free @item once you're done.
 *
 * There are many convenience functions to take care of common cases.
 * See g_menu_insert(), g_menu_insert_section() and
 * g_menu_insert_submenu() as well as "prepend" and "append" variants of
 * each of these functions.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert_section:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @label: (nullable): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Convenience function for inserting a section menu item into @menu.
 * Combine g_menu_item_new_section() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert_submenu:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @label: (nullable): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Convenience function for inserting a submenu menu item into @menu.
 * Combine g_menu_item_new_submenu() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_get_attribute:
 * @menu_item: a #GMenuItem
 * @attribute: the attribute name to query
 * @format_string: a #GVariant format string
 * @...: positional parameters, as per @format_string
 *
 * Queries the named @attribute on @menu_item.
 *
 * If the attribute exists and matches the #GVariantType corresponding
 * to @format_string then @format_string is used to deconstruct the
 * value into the positional parameters and %TRUE is returned.
 *
 * If the attribute does not exist, or it does exist but has the wrong
 * type, then the positional parameters are ignored and %FALSE is
 * returned.
 *
 * Returns: %TRUE if the named attribute was found with the expected
 *     type
 * Since: 2.34
 */


/**
 * g_menu_item_get_attribute_value:
 * @menu_item: a #GMenuItem
 * @attribute: the attribute name to query
 * @expected_type: (nullable): the expected type of the attribute
 *
 * Queries the named @attribute on @menu_item.
 *
 * If @expected_type is specified and the attribute does not have this
 * type, %NULL is returned.  %NULL is also returned if the attribute
 * simply does not exist.
 *
 * Returns: (nullable) (transfer full): the attribute value, or %NULL
 * Since: 2.34
 */


/**
 * g_menu_item_get_link:
 * @menu_item: a #GMenuItem
 * @link: the link name to query
 *
 * Queries the named @link on @menu_item.
 *
 * Returns: (nullable) (transfer full): the link, or %NULL
 * Since: 2.34
 */


/**
 * g_menu_item_new:
 * @label: (nullable): the section label, or %NULL
 * @detailed_action: (nullable): the detailed action string, or %NULL
 *
 * Creates a new #GMenuItem.
 *
 * If @label is non-%NULL it is used to set the "label" attribute of the
 * new item.
 *
 * If @detailed_action is non-%NULL it is used to set the "action" and
 * possibly the "target" attribute of the new item.  See
 * g_menu_item_set_detailed_action() for more information.
 *
 * Returns: a new #GMenuItem
 * Since: 2.32
 */


/**
 * g_menu_item_new_from_model:
 * @model: a #GMenuModel
 * @item_index: the index of an item in @model
 *
 * Creates a #GMenuItem as an exact copy of an existing menu item in a
 * #GMenuModel.
 *
 * @item_index must be valid (ie: be sure to call
 * g_menu_model_get_n_items() first).
 *
 * Returns: a new #GMenuItem.
 * Since: 2.34
 */


/**
 * g_menu_item_new_section:
 * @label: (nullable): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Creates a new #GMenuItem representing a section.
 *
 * This is a convenience API around g_menu_item_new() and
 * g_menu_item_set_section().
 *
 * The effect of having one menu appear as a section of another is
 * exactly as it sounds: the items from @section become a direct part of
 * the menu that @menu_item is added to.
 *
 * Visual separation is typically displayed between two non-empty
 * sections.  If @label is non-%NULL then it will be encorporated into
 * this visual indication.  This allows for labeled subsections of a
 * menu.
 *
 * As a simple example, consider a typical "Edit" menu from a simple
 * program.  It probably contains an "Undo" and "Redo" item, followed by
 * a separator, followed by "Cut", "Copy" and "Paste".
 *
 * This would be accomplished by creating three #GMenu instances.  The
 * first would be populated with the "Undo" and "Redo" items, and the
 * second with the "Cut", "Copy" and "Paste" items.  The first and
 * second menus would then be added as submenus of the third.  In XML
 * format, this would look something like the following:
 * |[
 * <menu id='edit-menu'>
 *   <section>
 *     <item label='Undo'/>
 *     <item label='Redo'/>
 *   </section>
 *   <section>
 *     <item label='Cut'/>
 *     <item label='Copy'/>
 *     <item label='Paste'/>
 *   </section>
 * </menu>
 * ]|
 *
 * The following example is exactly equivalent.  It is more illustrative
 * of the exact relationship between the menus and items (keeping in
 * mind that the 'link' element defines a new menu that is linked to the
 * containing one).  The style of the second example is more verbose and
 * difficult to read (and therefore not recommended except for the
 * purpose of understanding what is really going on).
 * |[
 * <menu id='edit-menu'>
 *   <item>
 *     <link name='section'>
 *       <item label='Undo'/>
 *       <item label='Redo'/>
 *     </link>
 *   </item>
 *   <item>
 *     <link name='section'>
 *       <item label='Cut'/>
 *       <item label='Copy'/>
 *       <item label='Paste'/>
 *     </link>
 *   </item>
 * </menu>
 * ]|
 *
 * Returns: a new #GMenuItem
 * Since: 2.32
 */


/**
 * g_menu_item_new_submenu:
 * @label: (nullable): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Creates a new #GMenuItem representing a submenu.
 *
 * This is a convenience API around g_menu_item_new() and
 * g_menu_item_set_submenu().
 *
 * Returns: a new #GMenuItem
 * Since: 2.32
 */


/**
 * g_menu_item_set_action_and_target:
 * @menu_item: a #GMenuItem
 * @action: (nullable): the name of the action for this item
 * @format_string: (nullable): a GVariant format string
 * @...: positional parameters, as per @format_string
 *
 * Sets or unsets the "action" and "target" attributes of @menu_item.
 *
 * If @action is %NULL then both the "action" and "target" attributes
 * are unset (and @format_string is ignored along with the positional
 * parameters).
 *
 * If @action is non-%NULL then the "action" attribute is set.
 * @format_string is then inspected.  If it is non-%NULL then the proper
 * position parameters are collected to create a #GVariant instance to
 * use as the target value.  If it is %NULL then the positional
 * parameters are ignored and the "target" attribute is unset.
 *
 * See also g_menu_item_set_action_and_target_value() for an equivalent
 * call that directly accepts a #GVariant.  See
 * g_menu_item_set_detailed_action() for a more convenient version that
 * works with string-typed targets.
 *
 * See also g_menu_item_set_action_and_target_value() for a
 * description of the semantics of the action and target attributes.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_action_and_target_value:
 * @menu_item: a #GMenuItem
 * @action: (nullable): the name of the action for this item
 * @target_value: (nullable): a #GVariant to use as the action target
 *
 * Sets or unsets the "action" and "target" attributes of @menu_item.
 *
 * If @action is %NULL then both the "action" and "target" attributes
 * are unset (and @target_value is ignored).
 *
 * If @action is non-%NULL then the "action" attribute is set.  The
 * "target" attribute is then set to the value of @target_value if it is
 * non-%NULL or unset otherwise.
 *
 * Normal menu items (ie: not submenu, section or other custom item
 * types) are expected to have the "action" attribute set to identify
 * the action that they are associated with.  The state type of the
 * action help to determine the disposition of the menu item.  See
 * #GAction and #GActionGroup for an overview of actions.
 *
 * In general, clicking on the menu item will result in activation of
 * the named action with the "target" attribute given as the parameter
 * to the action invocation.  If the "target" attribute is not set then
 * the action is invoked with no parameter.
 *
 * If the action has no state then the menu item is usually drawn as a
 * plain menu item (ie: with no additional decoration).
 *
 * If the action has a boolean state then the menu item is usually drawn
 * as a toggle menu item (ie: with a checkmark or equivalent
 * indication).  The item should be marked as 'toggled' or 'checked'
 * when the boolean state is %TRUE.
 *
 * If the action has a string state then the menu item is usually drawn
 * as a radio menu item (ie: with a radio bullet or equivalent
 * indication).  The item should be marked as 'selected' when the string
 * state is equal to the value of the @target property.
 *
 * See g_menu_item_set_action_and_target() or
 * g_menu_item_set_detailed_action() for two equivalent calls that are
 * probably more convenient for most uses.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_attribute:
 * @menu_item: a #GMenuItem
 * @attribute: the attribute to set
 * @format_string: (nullable): a #GVariant format string, or %NULL
 * @...: positional parameters, as per @format_string
 *
 * Sets or unsets an attribute on @menu_item.
 *
 * The attribute to set or unset is specified by @attribute. This
 * can be one of the standard attribute names %G_MENU_ATTRIBUTE_LABEL,
 * %G_MENU_ATTRIBUTE_ACTION, %G_MENU_ATTRIBUTE_TARGET, or a custom
 * attribute name.
 * Attribute names are restricted to lowercase characters, numbers
 * and '-'. Furthermore, the names must begin with a lowercase character,
 * must not end with a '-', and must not contain consecutive dashes.
 *
 * If @format_string is non-%NULL then the proper position parameters
 * are collected to create a #GVariant instance to use as the attribute
 * value.  If it is %NULL then the positional parameterrs are ignored
 * and the named attribute is unset.
 *
 * See also g_menu_item_set_attribute_value() for an equivalent call
 * that directly accepts a #GVariant.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_attribute_value:
 * @menu_item: a #GMenuItem
 * @attribute: the attribute to set
 * @value: (nullable): a #GVariant to use as the value, or %NULL
 *
 * Sets or unsets an attribute on @menu_item.
 *
 * The attribute to set or unset is specified by @attribute. This
 * can be one of the standard attribute names %G_MENU_ATTRIBUTE_LABEL,
 * %G_MENU_ATTRIBUTE_ACTION, %G_MENU_ATTRIBUTE_TARGET, or a custom
 * attribute name.
 * Attribute names are restricted to lowercase characters, numbers
 * and '-'. Furthermore, the names must begin with a lowercase character,
 * must not end with a '-', and must not contain consecutive dashes.
 *
 * must consist only of lowercase
 * ASCII characters, digits and '-'.
 *
 * If @value is non-%NULL then it is used as the new value for the
 * attribute.  If @value is %NULL then the attribute is unset. If
 * the @value #GVariant is floating, it is consumed.
 *
 * See also g_menu_item_set_attribute() for a more convenient way to do
 * the same.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_detailed_action:
 * @menu_item: a #GMenuItem
 * @detailed_action: the "detailed" action string
 *
 * Sets the "action" and possibly the "target" attribute of @menu_item.
 *
 * The format of @detailed_action is the same format parsed by
 * g_action_parse_detailed_name().
 *
 * See g_menu_item_set_action_and_target() or
 * g_menu_item_set_action_and_target_value() for more flexible (but
 * slightly less convenient) alternatives.
 *
 * See also g_menu_item_set_action_and_target_value() for a description of
 * the semantics of the action and target attributes.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_icon:
 * @menu_item: a #GMenuItem
 * @icon: a #GIcon, or %NULL
 *
 * Sets (or unsets) the icon on @menu_item.
 *
 * This call is the same as calling g_icon_serialize() and using the
 * result as the value to g_menu_item_set_attribute_value() for
 * %G_MENU_ATTRIBUTE_ICON.
 *
 * This API is only intended for use with "noun" menu items; things like
 * bookmarks or applications in an "Open With" menu.  Don't use it on
 * menu items corresponding to verbs (eg: stock icons for 'Save' or
 * 'Quit').
 *
 * If @icon is %NULL then the icon is unset.
 *
 * Since: 2.38
 */


/**
 * g_menu_item_set_label:
 * @menu_item: a #GMenuItem
 * @label: (nullable): the label to set, or %NULL to unset
 *
 * Sets or unsets the "label" attribute of @menu_item.
 *
 * If @label is non-%NULL it is used as the label for the menu item.  If
 * it is %NULL then the label attribute is unset.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_link:
 * @menu_item: a #GMenuItem
 * @link: type of link to establish or unset
 * @model: (nullable): the #GMenuModel to link to (or %NULL to unset)
 *
 * Creates a link from @menu_item to @model if non-%NULL, or unsets it.
 *
 * Links are used to establish a relationship between a particular menu
 * item and another menu.  For example, %G_MENU_LINK_SUBMENU is used to
 * associate a submenu with a particular menu item, and %G_MENU_LINK_SECTION
 * is used to create a section. Other types of link can be used, but there
 * is no guarantee that clients will be able to make sense of them.
 * Link types are restricted to lowercase characters, numbers
 * and '-'. Furthermore, the names must begin with a lowercase character,
 * must not end with a '-', and must not contain consecutive dashes.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_section:
 * @menu_item: a #GMenuItem
 * @section: (nullable): a #GMenuModel, or %NULL
 *
 * Sets or unsets the "section" link of @menu_item to @section.
 *
 * The effect of having one menu appear as a section of another is
 * exactly as it sounds: the items from @section become a direct part of
 * the menu that @menu_item is added to.  See g_menu_item_new_section()
 * for more information about what it means for a menu item to be a
 * section.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_submenu:
 * @menu_item: a #GMenuItem
 * @submenu: (nullable): a #GMenuModel, or %NULL
 *
 * Sets or unsets the "submenu" link of @menu_item to @submenu.
 *
 * If @submenu is non-%NULL, it is linked to.  If it is %NULL then the
 * link is unset.
 *
 * The effect of having one menu appear as a submenu of another is
 * exactly as it sounds.
 *
 * Since: 2.32
 */


/**
 * g_menu_link_iter_get_name:
 * @iter: a #GMenuLinkIter
 *
 * Gets the name of the link at the current iterator position.
 *
 * The iterator is not advanced.
 *
 * Returns: the type of the link
 * Since: 2.32
 */


/**
 * g_menu_link_iter_get_next:
 * @iter: a #GMenuLinkIter
 * @out_link: (out) (optional) (transfer none): the name of the link
 * @value: (out) (optional) (transfer full): the linked #GMenuModel
 *
 * This function combines g_menu_link_iter_next() with
 * g_menu_link_iter_get_name() and g_menu_link_iter_get_value().
 *
 * First the iterator is advanced to the next (possibly first) link.
 * If that fails, then %FALSE is returned and there are no other effects.
 *
 * If successful, @out_link and @value are set to the name and #GMenuModel
 * of the link that has just been advanced to.  At this point,
 * g_menu_link_iter_get_name() and g_menu_link_iter_get_value() will return the
 * same values again.
 *
 * The value returned in @out_link remains valid for as long as the iterator
 * remains at the current position.  The value returned in @value must
 * be unreffed using g_object_unref() when it is no longer in use.
 *
 * Returns: %TRUE on success, or %FALSE if there is no additional link
 * Since: 2.32
 */


/**
 * g_menu_link_iter_get_value:
 * @iter: a #GMenuLinkIter
 *
 * Gets the linked #GMenuModel at the current iterator position.
 *
 * The iterator is not advanced.
 *
 * Returns: (transfer full): the #GMenuModel that is linked to
 * Since: 2.32
 */


/**
 * g_menu_link_iter_next:
 * @iter: a #GMenuLinkIter
 *
 * Attempts to advance the iterator to the next (possibly first)
 * link.
 *
 * %TRUE is returned on success, or %FALSE if there are no more links.
 *
 * You must call this function when you first acquire the iterator to
 * advance it to the first link (and determine if the first link exists
 * at all).
 *
 * Returns: %TRUE on success, or %FALSE when there are no more links
 * Since: 2.32
 */


/**
 * g_menu_model_get_item_attribute:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 * @attribute: the attribute to query
 * @format_string: a #GVariant format string
 * @...: positional parameters, as per @format_string
 *
 * Queries item at position @item_index in @model for the attribute
 * specified by @attribute.
 *
 * If the attribute exists and matches the #GVariantType corresponding
 * to @format_string then @format_string is used to deconstruct the
 * value into the positional parameters and %TRUE is returned.
 *
 * If the attribute does not exist, or it does exist but has the wrong
 * type, then the positional parameters are ignored and %FALSE is
 * returned.
 *
 * This function is a mix of g_menu_model_get_item_attribute_value() and
 * g_variant_get(), followed by a g_variant_unref().  As such,
 * @format_string must make a complete copy of the data (since the
 * #GVariant may go away after the call to g_variant_unref()).  In
 * particular, no '&' characters are allowed in @format_string.
 *
 * Returns: %TRUE if the named attribute was found with the expected
 *     type
 * Since: 2.32
 */


/**
 * g_menu_model_get_item_attribute_value:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 * @attribute: the attribute to query
 * @expected_type: (nullable): the expected type of the attribute, or
 *     %NULL
 *
 * Queries the item at position @item_index in @model for the attribute
 * specified by @attribute.
 *
 * If @expected_type is non-%NULL then it specifies the expected type of
 * the attribute.  If it is %NULL then any type will be accepted.
 *
 * If the attribute exists and matches @expected_type (or if the
 * expected type is unspecified) then the value is returned.
 *
 * If the attribute does not exist, or does not match the expected type
 * then %NULL is returned.
 *
 * Returns: (nullable) (transfer full): the value of the attribute
 * Since: 2.32
 */


/**
 * g_menu_model_get_item_link:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 * @link: the link to query
 *
 * Queries the item at position @item_index in @model for the link
 * specified by @link.
 *
 * If the link exists, the linked #GMenuModel is returned.  If the link
 * does not exist, %NULL is returned.
 *
 * Returns: (nullable) (transfer full): the linked #GMenuModel, or %NULL
 * Since: 2.32
 */


/**
 * g_menu_model_get_n_items:
 * @model: a #GMenuModel
 *
 * Query the number of items in @model.
 *
 * Returns: the number of items
 * Since: 2.32
 */


/**
 * g_menu_model_is_mutable:
 * @model: a #GMenuModel
 *
 * Queries if @model is mutable.
 *
 * An immutable #GMenuModel will never emit the #GMenuModel::items-changed
 * signal. Consumers of the model may make optimisations accordingly.
 *
 * Returns: %TRUE if the model is mutable (ie: "items-changed" may be
 *     emitted).
 * Since: 2.32
 */


/**
 * g_menu_model_items_changed:
 * @model: a #GMenuModel
 * @position: the position of the change
 * @removed: the number of items removed
 * @added: the number of items added
 *
 * Requests emission of the #GMenuModel::items-changed signal on @model.
 *
 * This function should never be called except by #GMenuModel
 * subclasses.  Any other calls to this function will very likely lead
 * to a violation of the interface of the model.
 *
 * The implementation should update its internal representation of the
 * menu before emitting the signal.  The implementation should further
 * expect to receive queries about the new state of the menu (and
 * particularly added menu items) while signal handlers are running.
 *
 * The implementation must dispatch this call directly from a mainloop
 * entry and not in response to calls -- particularly those from the
 * #GMenuModel API.  Said another way: the menu must not change while
 * user code is running without returning to the mainloop.
 *
 * Since: 2.32
 */


/**
 * g_menu_model_iterate_item_attributes:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 *
 * Creates a #GMenuAttributeIter to iterate over the attributes of
 * the item at position @item_index in @model.
 *
 * You must free the iterator with g_object_unref() when you are done.
 *
 * Returns: (transfer full): a new #GMenuAttributeIter
 * Since: 2.32
 */


/**
 * g_menu_model_iterate_item_links:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 *
 * Creates a #GMenuLinkIter to iterate over the links of the item at
 * position @item_index in @model.
 *
 * You must free the iterator with g_object_unref() when you are done.
 *
 * Returns: (transfer full): a new #GMenuLinkIter
 * Since: 2.32
 */


/**
 * g_menu_new:
 *
 * Creates a new #GMenu.
 *
 * The new menu has no items.
 *
 * Returns: a new #GMenu
 * Since: 2.32
 */


/**
 * g_menu_prepend:
 * @menu: a #GMenu
 * @label: (nullable): the section label, or %NULL
 * @detailed_action: (nullable): the detailed action string, or %NULL
 *
 * Convenience function for prepending a normal menu item to the start
 * of @menu.  Combine g_menu_item_new() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_prepend_item:
 * @menu: a #GMenu
 * @item: a #GMenuItem to prepend
 *
 * Prepends @item to the start of @menu.
 *
 * See g_menu_insert_item() for more information.
 *
 * Since: 2.32
 */


/**
 * g_menu_prepend_section:
 * @menu: a #GMenu
 * @label: (nullable): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Convenience function for prepending a section menu item to the start
 * of @menu.  Combine g_menu_item_new_section() and g_menu_insert_item() for
 * a more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_prepend_submenu:
 * @menu: a #GMenu
 * @label: (nullable): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Convenience function for prepending a submenu menu item to the start
 * of @menu.  Combine g_menu_item_new_submenu() and g_menu_insert_item() for
 * a more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_remove:
 * @menu: a #GMenu
 * @position: the position of the item to remove
 *
 * Removes an item from the menu.
 *
 * @position gives the index of the item to remove.
 *
 * It is an error if position is not in range the range from 0 to one
 * less than the number of items in the menu.
 *
 * It is not possible to remove items by identity since items are added
 * to the menu simply by copying their links and attributes (ie:
 * identity of the item itself is not preserved).
 *
 * Since: 2.32
 */


/**
 * g_menu_remove_all:
 * @menu: a #GMenu
 *
 * Removes all items in the menu.
 *
 * Since: 2.38
 */


/**
 * g_mount_can_eject:
 * @mount: a #GMount.
 *
 * Checks if @mount can be ejected.
 *
 * Returns: %TRUE if the @mount can be ejected.
 */


/**
 * g_mount_can_unmount:
 * @mount: a #GMount.
 *
 * Checks if @mount can be unmounted.
 *
 * Returns: %TRUE if the @mount can be unmounted.
 */


/**
 * g_mount_eject:
 * @mount: a #GMount.
 * @flags: flags affecting the unmount if required for eject
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Ejects a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_eject_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Deprecated: 2.22: Use g_mount_eject_with_operation() instead.
 */


/**
 * g_mount_eject_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Finishes ejecting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully ejected. %FALSE otherwise.
 * Deprecated: 2.22: Use g_mount_eject_with_operation_finish() instead.
 */


/**
 * g_mount_eject_with_operation:
 * @mount: a #GMount.
 * @flags: flags affecting the unmount if required for eject
 * @mount_operation: (nullable): a #GMountOperation or %NULL to avoid
 *     user interaction.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Ejects a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_eject_with_operation_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.22
 */


/**
 * g_mount_eject_with_operation_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Finishes ejecting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully ejected. %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_mount_get_default_location:
 * @mount: a #GMount.
 *
 * Gets the default location of @mount. The default location of the given
 * @mount is a path that reflects the main entry point for the user (e.g.
 * the home directory, or the root of the volume).
 *
 * Returns: (transfer full): a #GFile.
 *      The returned object should be unreffed with
 *      g_object_unref() when no longer needed.
 */


/**
 * g_mount_get_drive:
 * @mount: a #GMount.
 *
 * Gets the drive for the @mount.
 *
 * This is a convenience method for getting the #GVolume and then
 * using that object to get the #GDrive.
 *
 * Returns: (transfer full) (nullable): a #GDrive or %NULL if @mount is not
 *      associated with a volume or a drive.
 *      The returned object should be unreffed with
 *      g_object_unref() when no longer needed.
 */


/**
 * g_mount_get_icon:
 * @mount: a #GMount.
 *
 * Gets the icon for @mount.
 *
 * Returns: (transfer full): a #GIcon.
 *      The returned object should be unreffed with
 *      g_object_unref() when no longer needed.
 */


/**
 * g_mount_get_name:
 * @mount: a #GMount.
 *
 * Gets the name of @mount.
 *
 * Returns: the name for the given @mount.
 *     The returned string should be freed with g_free()
 *     when no longer needed.
 */


/**
 * g_mount_get_root:
 * @mount: a #GMount.
 *
 * Gets the root directory on @mount.
 *
 * Returns: (transfer full): a #GFile.
 *      The returned object should be unreffed with
 *      g_object_unref() when no longer needed.
 */


/**
 * g_mount_get_sort_key:
 * @mount: A #GMount.
 *
 * Gets the sort key for @mount, if any.
 *
 * Returns: (nullable): Sorting key for @mount or %NULL if no such key is available.
 * Since: 2.32
 */


/**
 * g_mount_get_symbolic_icon:
 * @mount: a #GMount.
 *
 * Gets the symbolic icon for @mount.
 *
 * Returns: (transfer full): a #GIcon.
 *      The returned object should be unreffed with
 *      g_object_unref() when no longer needed.
 * Since: 2.34
 */


/**
 * g_mount_get_uuid:
 * @mount: a #GMount.
 *
 * Gets the UUID for the @mount. The reference is typically based on
 * the file system UUID for the mount in question and should be
 * considered an opaque string. Returns %NULL if there is no UUID
 * available.
 *
 * Returns: (nullable) (transfer full): the UUID for @mount or %NULL if no UUID
 *     can be computed.
 *     The returned string should be freed with g_free()
 *     when no longer needed.
 */


/**
 * g_mount_get_volume:
 * @mount: a #GMount.
 *
 * Gets the volume for the @mount.
 *
 * Returns: (transfer full) (nullable): a #GVolume or %NULL if @mount is not
 *      associated with a volume.
 *      The returned object should be unreffed with
 *      g_object_unref() when no longer needed.
 */


/**
 * g_mount_guess_content_type:
 * @mount: a #GMount
 * @force_rescan: Whether to force a rescan of the content.
 *     Otherwise a cached result will be used if available
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @callback: a #GAsyncReadyCallback
 * @user_data: user data passed to @callback
 *
 * Tries to guess the type of content stored on @mount. Returns one or
 * more textual identifiers of well-known content types (typically
 * prefixed with "x-content/"), e.g. x-content/image-dcf for camera
 * memory cards. See the
 * [shared-mime-info](http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec)
 * specification for more on x-content types.
 *
 * This is an asynchronous operation (see
 * g_mount_guess_content_type_sync() for the synchronous version), and
 * is finished by calling g_mount_guess_content_type_finish() with the
 * @mount and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.18
 */


/**
 * g_mount_guess_content_type_finish:
 * @mount: a #GMount
 * @result: a #GAsyncResult
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore
 *
 * Finishes guessing content types of @mount. If any errors occurred
 * during the operation, @error will be set to contain the errors and
 * %FALSE will be returned. In particular, you may get an
 * %G_IO_ERROR_NOT_SUPPORTED if the mount does not support content
 * guessing.
 *
 * Returns: (transfer full) (element-type utf8): a %NULL-terminated array of content types or %NULL on error.
 *     Caller should free this array with g_strfreev() when done with it.
 * Since: 2.18
 */


/**
 * g_mount_guess_content_type_sync:
 * @mount: a #GMount
 * @force_rescan: Whether to force a rescan of the content.
 *     Otherwise a cached result will be used if available
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore
 *
 * Tries to guess the type of content stored on @mount. Returns one or
 * more textual identifiers of well-known content types (typically
 * prefixed with "x-content/"), e.g. x-content/image-dcf for camera
 * memory cards. See the
 * [shared-mime-info](http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec)
 * specification for more on x-content types.
 *
 * This is a synchronous operation and as such may block doing IO;
 * see g_mount_guess_content_type() for the asynchronous version.
 *
 * Returns: (transfer full) (element-type utf8): a %NULL-terminated array of content types or %NULL on error.
 *     Caller should free this array with g_strfreev() when done with it.
 * Since: 2.18
 */


/**
 * g_mount_is_shadowed:
 * @mount: A #GMount.
 *
 * Determines if @mount is shadowed. Applications or libraries should
 * avoid displaying @mount in the user interface if it is shadowed.
 *
 * A mount is said to be shadowed if there exists one or more user
 * visible objects (currently #GMount objects) with a root that is
 * inside the root of @mount.
 *
 * One application of shadow mounts is when exposing a single file
 * system that is used to address several logical volumes. In this
 * situation, a #GVolumeMonitor implementation would create two
 * #GVolume objects (for example, one for the camera functionality of
 * the device and one for a SD card reader on the device) with
 * activation URIs `gphoto2://[usb:001,002]/store1/`
 * and `gphoto2://[usb:001,002]/store2/`. When the
 * underlying mount (with root
 * `gphoto2://[usb:001,002]/`) is mounted, said
 * #GVolumeMonitor implementation would create two #GMount objects
 * (each with their root matching the corresponding volume activation
 * root) that would shadow the original mount.
 *
 * The proxy monitor in GVfs 2.26 and later, automatically creates and
 * manage shadow mounts (and shadows the underlying mount) if the
 * activation root on a #GVolume is set.
 *
 * Returns: %TRUE if @mount is shadowed.
 * Since: 2.20
 */


/**
 * g_mount_operation_get_anonymous:
 * @op: a #GMountOperation.
 *
 * Check to see whether the mount operation is being used
 * for an anonymous user.
 *
 * Returns: %TRUE if mount operation is anonymous.
 */


/**
 * g_mount_operation_get_choice:
 * @op: a #GMountOperation.
 *
 * Gets a choice from the mount operation.
 *
 * Returns: an integer containing an index of the user's choice from
 * the choice's list, or `0`.
 */


/**
 * g_mount_operation_get_domain:
 * @op: a #GMountOperation.
 *
 * Gets the domain of the mount operation.
 *
 * Returns: (nullable): a string set to the domain.
 */


/**
 * g_mount_operation_get_is_tcrypt_hidden_volume:
 * @op: a #GMountOperation.
 *
 * Check to see whether the mount operation is being used
 * for a TCRYPT hidden volume.
 *
 * Returns: %TRUE if mount operation is for hidden volume.
 * Since: 2.58
 */


/**
 * g_mount_operation_get_is_tcrypt_system_volume:
 * @op: a #GMountOperation.
 *
 * Check to see whether the mount operation is being used
 * for a TCRYPT system volume.
 *
 * Returns: %TRUE if mount operation is for system volume.
 * Since: 2.58
 */


/**
 * g_mount_operation_get_password:
 * @op: a #GMountOperation.
 *
 * Gets a password from the mount operation.
 *
 * Returns: (nullable): a string containing the password within @op.
 */


/**
 * g_mount_operation_get_password_save:
 * @op: a #GMountOperation.
 *
 * Gets the state of saving passwords for the mount operation.
 *
 * Returns: a #GPasswordSave flag.
 */


/**
 * g_mount_operation_get_pim:
 * @op: a #GMountOperation.
 *
 * Gets a PIM from the mount operation.
 *
 * Returns: The VeraCrypt PIM within @op.
 * Since: 2.58
 */


/**
 * g_mount_operation_get_username:
 * @op: a #GMountOperation.
 *
 * Get the user name from the mount operation.
 *
 * Returns: (nullable): a string containing the user name.
 */


/**
 * g_mount_operation_new:
 *
 * Creates a new mount operation.
 *
 * Returns: a #GMountOperation.
 */


/**
 * g_mount_operation_reply:
 * @op: a #GMountOperation
 * @result: a #GMountOperationResult
 *
 * Emits the #GMountOperation::reply signal.
 */


/**
 * g_mount_operation_set_anonymous:
 * @op: a #GMountOperation.
 * @anonymous: boolean value.
 *
 * Sets the mount operation to use an anonymous user if @anonymous is %TRUE.
 */


/**
 * g_mount_operation_set_choice:
 * @op: a #GMountOperation.
 * @choice: an integer.
 *
 * Sets a default choice for the mount operation.
 */


/**
 * g_mount_operation_set_domain:
 * @op: a #GMountOperation.
 * @domain: (nullable): the domain to set.
 *
 * Sets the mount operation's domain.
 */


/**
 * g_mount_operation_set_is_tcrypt_hidden_volume:
 * @op: a #GMountOperation.
 * @hidden_volume: boolean value.
 *
 * Sets the mount operation to use a hidden volume if @hidden_volume is %TRUE.
 *
 * Since: 2.58
 */


/**
 * g_mount_operation_set_is_tcrypt_system_volume:
 * @op: a #GMountOperation.
 * @system_volume: boolean value.
 *
 * Sets the mount operation to use a system volume if @system_volume is %TRUE.
 *
 * Since: 2.58
 */


/**
 * g_mount_operation_set_password:
 * @op: a #GMountOperation.
 * @password: (nullable): password to set.
 *
 * Sets the mount operation's password to @password.
 */


/**
 * g_mount_operation_set_password_save:
 * @op: a #GMountOperation.
 * @save: a set of #GPasswordSave flags.
 *
 * Sets the state of saving passwords for the mount operation.
 */


/**
 * g_mount_operation_set_pim:
 * @op: a #GMountOperation.
 * @pim: an unsigned integer.
 *
 * Sets the mount operation's PIM to @pim.
 *
 * Since: 2.58
 */


/**
 * g_mount_operation_set_username:
 * @op: a #GMountOperation.
 * @username: (nullable): input username.
 *
 * Sets the user name within @op to @username.
 */


/**
 * g_mount_remount:
 * @mount: a #GMount.
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation or %NULL to avoid
 *     user interaction.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Remounts a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_remount_finish() with the @mount
 * and #GAsyncResults data returned in the @callback.
 *
 * Remounting is useful when some setting affecting the operation
 * of the volume has been changed, as these may need a remount to
 * take affect. While this is semantically equivalent with unmounting
 * and then remounting not all backends might need to actually be
 * unmounted.
 */


/**
 * g_mount_remount_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Finishes remounting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully remounted. %FALSE otherwise.
 */


/**
 * g_mount_shadow:
 * @mount: A #GMount.
 *
 * Increments the shadow count on @mount. Usually used by
 * #GVolumeMonitor implementations when creating a shadow mount for
 * @mount, see g_mount_is_shadowed() for more information. The caller
 * will need to emit the #GMount::changed signal on @mount manually.
 *
 * Since: 2.20
 */


/**
 * g_mount_unmount:
 * @mount: a #GMount.
 * @flags: flags affecting the operation
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Unmounts a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_unmount_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Deprecated: 2.22: Use g_mount_unmount_with_operation() instead.
 */


/**
 * g_mount_unmount_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Finishes unmounting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully unmounted. %FALSE otherwise.
 * Deprecated: 2.22: Use g_mount_unmount_with_operation_finish() instead.
 */


/**
 * g_mount_unmount_with_operation:
 * @mount: a #GMount.
 * @flags: flags affecting the operation
 * @mount_operation: (nullable): a #GMountOperation or %NULL to avoid
 *     user interaction.
 * @cancellable: (nullable): optional #GCancellable object, %NULL to ignore.
 * @callback: (nullable): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Unmounts a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_unmount_with_operation_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.22
 */


/**
 * g_mount_unmount_with_operation_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to
 *     ignore.
 *
 * Finishes unmounting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully unmounted. %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_mount_unshadow:
 * @mount: A #GMount.
 *
 * Decrements the shadow count on @mount. Usually used by
 * #GVolumeMonitor implementations when destroying a shadow mount for
 * @mount, see g_mount_is_shadowed() for more information. The caller
 * will need to emit the #GMount::changed signal on @mount manually.
 *
 * Since: 2.20
 */


/**
 * g_native_socket_address_new:
 * @native: a native address object
 * @len: the length of @native, in bytes
 *
 * Creates a new #GNativeSocketAddress for @native and @len.
 *
 * Returns: a new #GNativeSocketAddress
 * Since: 2.46
 */


/**
 * g_network_address_get_hostname:
 * @addr: a #GNetworkAddress
 *
 * Gets @addr's hostname. This might be either UTF-8 or ASCII-encoded,
 * depending on what @addr was created with.
 *
 * Returns: @addr's hostname
 * Since: 2.22
 */


/**
 * g_network_address_get_port:
 * @addr: a #GNetworkAddress
 *
 * Gets @addr's port number
 *
 * Returns: @addr's port (which may be 0)
 * Since: 2.22
 */


/**
 * g_network_address_get_scheme:
 * @addr: a #GNetworkAddress
 *
 * Gets @addr's scheme
 *
 * Returns: (nullable): @addr's scheme (%NULL if not built from URI)
 * Since: 2.26
 */


/**
 * g_network_address_new:
 * @hostname: the hostname
 * @port: the port
 *
 * Creates a new #GSocketConnectable for connecting to the given
 * @hostname and @port.
 *
 * Note that depending on the configuration of the machine, a
 * @hostname of `localhost` may refer to the IPv4 loopback address
 * only, or to both IPv4 and IPv6; use
 * g_network_address_new_loopback() to create a #GNetworkAddress that
 * is guaranteed to resolve to both addresses.
 *
 * Returns: (transfer full) (type GNetworkAddress): the new #GNetworkAddress
 * Since: 2.22
 */


/**
 * g_network_address_new_loopback:
 * @port: the port
 *
 * Creates a new #GSocketConnectable for connecting to the local host
 * over a loopback connection to the given @port. This is intended for
 * use in connecting to local services which may be running on IPv4 or
 * IPv6.
 *
