/*
 *  GRUB  --  GRand Unified Bootloader
 *  Copyright (C) 2025 Free Software Foundation, Inc.
 *
 *  GRUB is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  GRUB is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GRUB.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <grub/test.h>
#include <grub/crypto.h>
#include <grub/gcrypt/gcrypt.h>

GRUB_MOD_LICENSE ("GPLv3+");

/* Sample DSA public key.  */
static char pubkey_dump[] = {
  0x28, 0x31, 0x30, 0x3a, 0x70, 0x75, 0x62, 0x6c,
  0x69, 0x63, 0x2d, 0x6b, 0x65, 0x79, 0x28, 0x33,
  0x3a, 0x64, 0x73, 0x61, 0x28, 0x31, 0x3a, 0x70,
  0x31, 0x32, 0x39, 0x3a, 0x00, 0xc0, 0x50, 0x14,
  0x4c, 0x97, 0x10, 0x69, 0x07, 0xa7, 0xe9, 0x2b,
  0xe5, 0xc6, 0x88, 0xe1, 0x6d, 0xd8, 0x38, 0x28,
  0x09, 0x49, 0x5b, 0xe8, 0xa3, 0x04, 0xb8, 0xc4,
  0x6e, 0x98, 0xc1, 0xc2, 0xb0, 0x2a, 0xe0, 0xe2,
  0x1a, 0x30, 0xd2, 0xdb, 0x45, 0x1a, 0x88, 0x80,
  0x28, 0x24, 0xb0, 0xbf, 0xc2, 0xbd, 0xe9, 0xf6,
  0x9d, 0xa2, 0x01, 0x94, 0xe6, 0x7f, 0xa0, 0xb6,
  0xe4, 0x39, 0xfc, 0x54, 0xba, 0x99, 0xb6, 0xbe,
  0x39, 0xee, 0xa5, 0xd9, 0xa0, 0x35, 0x3c, 0x2d,
  0x3e, 0x96, 0xc3, 0x96, 0xa5, 0x0d, 0x2b, 0xbf,
  0x3b, 0xa3, 0xe2, 0xe8, 0x89, 0xed, 0x60, 0xe0,
  0x43, 0x61, 0xb6, 0x73, 0xf6, 0xa7, 0xb4, 0x56,
  0x76, 0x04, 0xf7, 0x8b, 0xf1, 0x84, 0xaa, 0x3e,
  0xe0, 0x08, 0xad, 0xdd, 0xc2, 0x36, 0xfd, 0x3d,
  0xd0, 0xad, 0xf4, 0x3a, 0x7e, 0x80, 0x8c, 0x52,
  0x2b, 0x04, 0xa8, 0x03, 0x27, 0x29, 0x28, 0x31,
  0x3a, 0x71, 0x32, 0x31, 0x3a, 0x00, 0xd5, 0x34,
  0xd2, 0xc5, 0x1c, 0x26, 0xdf, 0xb0, 0xba, 0x78,
  0x75, 0xe5, 0xe9, 0x36, 0x6b, 0x04, 0x03, 0xe2,
  0x57, 0x3f, 0x29, 0x28, 0x31, 0x3a, 0x67, 0x31,
  0x32, 0x38, 0x3a, 0x3b, 0xa0, 0xac, 0xa3, 0xa1,
  0xd1, 0x04, 0x23, 0x5f, 0x9f, 0xbc, 0x6d, 0x9e,
  0x88, 0x2a, 0x28, 0xc1, 0x48, 0xaf, 0xa5, 0x17,
  0x59, 0x3a, 0x17, 0x33, 0x56, 0xaa, 0x8d, 0x27,
  0x64, 0xfe, 0x8e, 0x8a, 0x2e, 0xba, 0xf2, 0x66,
  0xcc, 0x66, 0xbd, 0xa4, 0xfe, 0xa9, 0x07, 0x0d,
  0xae, 0x8c, 0x9f, 0x70, 0xf7, 0x87, 0xaa, 0x01,
  0x47, 0x6b, 0xf9, 0x0f, 0x09, 0x18, 0x42, 0x76,
  0xc4, 0xa3, 0xb9, 0x55, 0x11, 0x8d, 0xa3, 0xa5,
  0x69, 0x30, 0x91, 0xb7, 0x03, 0xef, 0x7f, 0x12,
  0xe6, 0xb9, 0x78, 0x73, 0xe0, 0xc0, 0x4f, 0xc6,
  0xd9, 0x43, 0x99, 0x95, 0x0b, 0x4d, 0x58, 0xd3,
  0x6b, 0x76, 0xb0, 0x6a, 0xcf, 0x68, 0x6d, 0xf0,
  0xd9, 0xc1, 0x88, 0x43, 0x9d, 0xf9, 0x04, 0xcb,
  0xc9, 0x82, 0x6c, 0xee, 0xd4, 0x9c, 0xbd, 0x1c,
  0x4d, 0x54, 0x29, 0x83, 0xa9, 0x5e, 0xaa, 0x10,
  0xa7, 0xc1, 0x04, 0x29, 0x28, 0x31, 0x3a, 0x79,
  0x31, 0x32, 0x39, 0x3a, 0x00, 0x82, 0x33, 0xf1,
  0x91, 0xe3, 0xf2, 0x12, 0x93, 0x5a, 0xed, 0x0c,
  0x9d, 0xec, 0x67, 0xaa, 0xa7, 0x97, 0x7f, 0x9f,
  0x5e, 0xef, 0x6a, 0x3e, 0xa4, 0x7f, 0x9b, 0xed,
  0x65, 0xd7, 0xba, 0x40, 0x6d, 0xe1, 0xde, 0xc1,
  0x14, 0x4c, 0x9b, 0x28, 0x5c, 0x03, 0x8e, 0x1a,
  0xd4, 0x1b, 0x80, 0x1b, 0x07, 0xd6, 0x84, 0x04,
  0x49, 0x6c, 0x1b, 0x08, 0x84, 0x15, 0x54, 0x62,
  0xca, 0xd5, 0x75, 0xff, 0xc8, 0xb3, 0x81, 0x76,
  0x82, 0x91, 0x35, 0x80, 0x20, 0x73, 0x2a, 0x21,
  0xca, 0x22, 0x06, 0xa7, 0x73, 0x99, 0x75, 0x7e,
  0x5e, 0xa6, 0x09, 0x59, 0x66, 0x2c, 0xcd, 0xb1,
  0x8d, 0x3b, 0xc0, 0x68, 0xc5, 0x41, 0xa0, 0x9d,
  0x82, 0x15, 0xc4, 0xdd, 0x47, 0x1c, 0x5b, 0xa9,
  0x74, 0x18, 0xaf, 0x72, 0x63, 0x6b, 0x0a, 0x4e,
  0x95, 0x09, 0x7a, 0xb5, 0x4b, 0x98, 0x85, 0xb9,
  0x6d, 0x9d, 0x3b, 0x73, 0x8c, 0x29, 0x29, 0x29,
};

/* Sample DSA signature of message "hello" with sample key.  */
static char sig_dump[] = {
  0x28, 0x37, 0x3a, 0x73, 0x69, 0x67, 0x2d, 0x76,
  0x61, 0x6c, 0x28, 0x33, 0x3a, 0x64, 0x73, 0x61,
  0x28, 0x31, 0x3a, 0x72, 0x32, 0x30, 0x3a, 0xb6,
  0x60, 0x37, 0xef, 0x02, 0x7c, 0x7c, 0x6e, 0x4f,
  0x66, 0x8c, 0x7c, 0x26, 0x77, 0xd9, 0x33, 0x90,
  0xba, 0x7c, 0xfb, 0x29, 0x28, 0x31, 0x3a, 0x73,
  0x32, 0x30, 0x3a, 0x83, 0xc0, 0x84, 0x72, 0xc6,
  0x1c, 0x85, 0x6f, 0x8b, 0x9b, 0xb0, 0x38, 0x38,
  0xb2, 0xb6, 0xdf, 0x1c, 0x52, 0x96, 0x1b, 0x29,
  0x29, 0x29,
};

extern gcry_pk_spec_t _gcry_pubkey_spec_dsa;

static void
dsa_sexp_test (void)
{
  gcry_sexp_t sign_parms, sign_parms_invalid, pubkey, sig;
  int rc;
  grub_size_t errof;

  rc = _gcry_sexp_build (&sign_parms_invalid, &errof,
			"(data (value \"hi\"))\n");
  grub_test_assert (rc == 0, "sexp build failed");

  rc = _gcry_sexp_build (&sign_parms, &errof,
			"(data (value \"hello\"))\n");
  grub_test_assert (rc == 0, "sexp build failed");
  rc = _gcry_sexp_new (&pubkey, pubkey_dump, sizeof(pubkey_dump), 0);
  grub_test_assert (rc == 0, "sexp new failed");
  rc = _gcry_sexp_new (&sig, sig_dump, sizeof(sig_dump), 0);
  grub_test_assert (rc == 0, "sexp new failed");
  rc = _gcry_pubkey_spec_dsa.verify (sig, sign_parms, pubkey);
  grub_test_assert (rc == 0, "signature verification failed: %d", rc);
  rc = _gcry_pubkey_spec_dsa.verify (sig, sign_parms_invalid, pubkey);
  grub_test_assert (rc != 0, "signature verification succeded wrongly");
}

GRUB_FUNCTIONAL_TEST (dsa_sexp_test, dsa_sexp_test);
