/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Syncable;

public class FSDataOutputStream
extends DataOutputStream
implements Syncable {
    private OutputStream wrappedStream;

    @Deprecated
    public FSDataOutputStream(OutputStream out) throws IOException {
        this(out, null);
    }

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super(new PositionCache(out, stats, startPosition));
        this.wrappedStream = out;
    }

    public long getPos() throws IOException {
        return ((PositionCache)this.out).getPos();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream getWrappedStream() {
        return this.wrappedStream;
    }

    @Override
    public void sync() throws IOException {
        if (this.wrappedStream instanceof Syncable) {
            ((Syncable)((Object)this.wrappedStream)).sync();
        }
    }

    private static class PositionCache
    extends FilterOutputStream {
        private FileSystem.Statistics statistics;
        long position;

        public PositionCache(OutputStream out, FileSystem.Statistics stats, long pos) throws IOException {
            super(out);
            this.statistics = stats;
            this.position = pos;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.position;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(1L);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(len);
            }
        }

        public long getPos() throws IOException {
            return this.position;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

