; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -basic-aa -dse -S | FileCheck %s

target datalayout = "e-p:64:64:64"

declare void @free(i8* nocapture)
declare noalias i8* @malloc(i64)

define void @test(i32* %Q, i32* %P) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32* [[P:%.*]] to i8*
; CHECK-NEXT:    tail call void @free(i8* [[TMP1]]) [[ATTR0:#.*]]
; CHECK-NEXT:    ret void
;
  %DEAD = load i32, i32* %Q            ; <i32> [#uses=1]
  store i32 %DEAD, i32* %P
  %1 = bitcast i32* %P to i8*
  tail call void @free(i8* %1) nounwind
  ret void
}

define void @test2({i32, i32}* %P) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast { i32, i32 }* [[P:%.*]] to i8*
; CHECK-NEXT:    tail call void @free(i8* [[TMP1]]) [[ATTR0]]
; CHECK-NEXT:    ret void
;
  %Q = getelementptr {i32, i32}, {i32, i32} *%P, i32 0, i32 1
  store i32 4, i32* %Q
  %1 = bitcast {i32, i32}* %P to i8*
  tail call void @free(i8* %1) nounwind
  ret void
}

define void @test3() {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[M:%.*]] = call i8* @malloc(i64 24)
; CHECK-NEXT:    call void @free(i8* [[M]]) [[ATTR0]]
; CHECK-NEXT:    ret void
;
  %m = call i8* @malloc(i64 24)
  store i8 0, i8* %m
  %m1 = getelementptr i8, i8* %m, i64 1
  store i8 1, i8* %m1
  call void @free(i8* %m) nounwind
  ret void
}

; PR11240
define void @test4(i1 %x) nounwind {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOC1:%.*]] = tail call noalias i8* @malloc(i64 4) [[ATTR0]]
; CHECK-NEXT:    br i1 [[X:%.*]], label [[SKIPINIT1:%.*]], label [[INIT1:%.*]]
; CHECK:       init1:
; CHECK-NEXT:    br label [[SKIPINIT1]]
; CHECK:       skipinit1:
; CHECK-NEXT:    tail call void @free(i8* [[ALLOC1]]) [[ATTR0]]
; CHECK-NEXT:    ret void
;
entry:
  %alloc1 = tail call noalias i8* @malloc(i64 4) nounwind
  br i1 %x, label %skipinit1, label %init1

init1:
  store i8 1, i8* %alloc1
  br label %skipinit1

skipinit1:
  tail call void @free(i8* %alloc1) nounwind
  ret void
}

define void @test5() {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    tail call void @free(i8* undef) [[ATTR0]]
; CHECK-NEXT:    br label [[BB]]
;
  br label %bb

bb:
  tail call void @free(i8* undef) nounwind
  br label %bb
}


%struct  = type { i32 , i32  }

; Test case inspired by PR48036.
define void @delete_field_after(%struct* %ptr) {
;
; CHECK-LABEL: @delete_field_after(
; CHECK-NEXT:    [[PTR_F0:%.*]] = getelementptr [[STRUCT:%.*]], %struct* [[PTR:%.*]], i32 1
; CHECK-NEXT:    [[BC:%.*]] = bitcast %struct* [[PTR_F0]] to i8*
; CHECK-NEXT:    [[PTR_F1:%.*]] = getelementptr [[STRUCT]], %struct* [[PTR]], i32 0, i32 1
; CHECK-NEXT:    store i32 0, i32* [[PTR_F1]], align 4
; CHECK-NEXT:    call void @free(i8* [[BC]])
; CHECK-NEXT:    ret void
;
  %ptr.f0 = getelementptr %struct, %struct* %ptr, i32 1
  %bc = bitcast %struct* %ptr.f0 to i8*
  %ptr.f1 = getelementptr %struct, %struct* %ptr, i32 0, i32 1
  store i32 0, i32* %ptr.f1
  call void @free(i8* %bc)
  ret void
}

; Test case inspired by PR48036.
define void @delete_field_before(%struct* %ptr) {
; CHECK-LABEL: @delete_field_before(
; CHECK-NEXT:    [[PTR_F0:%.*]] = getelementptr [[STRUCT:%.*]], %struct* [[PTR:%.*]], i32 0
; CHECK-NEXT:    [[BC:%.*]] = bitcast %struct* [[PTR_F0]] to i8*
; CHECK-NEXT:    call void @free(i8* [[BC]])
; CHECK-NEXT:    ret void
;
  %ptr.f0 = getelementptr %struct, %struct* %ptr, i32 0
  %bc = bitcast %struct* %ptr.f0 to i8*
  %ptr.f1 = getelementptr %struct, %struct* %ptr, i32 1, i32 1
  store i32 0, i32* %ptr.f1
  call void @free(i8* %bc)
  ret void
}
