; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=RV64I
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=RV32I

define void @lshr_4bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_4bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    lb a0, 3(a0)
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_4bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    lbu a3, 1(a1)
; RV32I-NEXT:    lbu a4, 0(a1)
; RV32I-NEXT:    lbu a5, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    srl a0, a0, a1
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i32, ptr %src.ptr, align 1
  %bitOff = load i32, ptr %bitOff.ptr, align 1
  %res = lshr i32 %src, %bitOff
  store i32 %res, ptr %dst, align 1
  ret void
}
define void @shl_4bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_4bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    lb a0, 3(a0)
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_4bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    lbu a3, 1(a1)
; RV32I-NEXT:    lbu a4, 0(a1)
; RV32I-NEXT:    lbu a5, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    sll a0, a0, a1
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i32, ptr %src.ptr, align 1
  %bitOff = load i32, ptr %bitOff.ptr, align 1
  %res = shl i32 %src, %bitOff
  store i32 %res, ptr %dst, align 1
  ret void
}
define void @ashr_4bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_4bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    lb a0, 3(a0)
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_4bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    lbu a3, 1(a1)
; RV32I-NEXT:    lbu a4, 0(a1)
; RV32I-NEXT:    lbu a5, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    sra a0, a0, a1
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i32, ptr %src.ptr, align 1
  %bitOff = load i32, ptr %bitOff.ptr, align 1
  %res = ashr i32 %src, %bitOff
  store i32 %res, ptr %dst, align 1
  ret void
}

define void @lshr_8bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_8bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    lbu a3, 1(a1)
; RV64I-NEXT:    lbu a4, 0(a1)
; RV64I-NEXT:    lbu a5, 2(a1)
; RV64I-NEXT:    lbu a6, 3(a1)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a1)
; RV64I-NEXT:    lbu a5, 4(a1)
; RV64I-NEXT:    lbu a6, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_8bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    lbu a4, 4(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 7(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    lbu a4, 1(a1)
; RV32I-NEXT:    lbu a5, 0(a1)
; RV32I-NEXT:    lbu a6, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    or a4, a4, a5
; RV32I-NEXT:    slli a6, a6, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a5, a1, a6
; RV32I-NEXT:    or a5, a5, a4
; RV32I-NEXT:    addi a4, a5, -32
; RV32I-NEXT:    srl a1, a3, a5
; RV32I-NEXT:    bltz a4, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    j .LBB3_3
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 0(a0)
; RV32I-NEXT:    lbu t0, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a6, a6, 8
; RV32I-NEXT:    or a6, a6, a7
; RV32I-NEXT:    slli t0, t0, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, t0
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    srl a0, a0, a5
; RV32I-NEXT:    not a5, a5
; RV32I-NEXT:    slli a3, a3, 1
; RV32I-NEXT:    sll a3, a3, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:  .LBB3_3:
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    and a1, a4, a1
; RV32I-NEXT:    sb a1, 4(a2)
; RV32I-NEXT:    srli a3, a1, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    sb a3, 7(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i64, ptr %src.ptr, align 1
  %bitOff = load i64, ptr %bitOff.ptr, align 1
  %res = lshr i64 %src, %bitOff
  store i64 %res, ptr %dst, align 1
  ret void
}
define void @shl_8bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_8bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    lbu a3, 1(a1)
; RV64I-NEXT:    lbu a4, 0(a1)
; RV64I-NEXT:    lbu a5, 2(a1)
; RV64I-NEXT:    lbu a6, 3(a1)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a1)
; RV64I-NEXT:    lbu a5, 4(a1)
; RV64I-NEXT:    lbu a6, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    sll a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_8bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a6, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    lbu a4, 1(a1)
; RV32I-NEXT:    lbu a5, 0(a1)
; RV32I-NEXT:    lbu a6, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    or a4, a4, a5
; RV32I-NEXT:    slli a6, a6, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a5, a1, a6
; RV32I-NEXT:    or a5, a5, a4
; RV32I-NEXT:    addi a4, a5, -32
; RV32I-NEXT:    sll a1, a3, a5
; RV32I-NEXT:    bltz a4, .LBB4_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    j .LBB4_3
; RV32I-NEXT:  .LBB4_2:
; RV32I-NEXT:    lbu a6, 5(a0)
; RV32I-NEXT:    lbu a7, 4(a0)
; RV32I-NEXT:    lbu t0, 6(a0)
; RV32I-NEXT:    lbu a0, 7(a0)
; RV32I-NEXT:    slli a6, a6, 8
; RV32I-NEXT:    or a6, a6, a7
; RV32I-NEXT:    slli t0, t0, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, t0
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    sll a0, a0, a5
; RV32I-NEXT:    not a5, a5
; RV32I-NEXT:    srli a3, a3, 1
; RV32I-NEXT:    srl a3, a3, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:  .LBB4_3:
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    and a1, a4, a1
; RV32I-NEXT:    sb a1, 0(a2)
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    srli a3, a1, 16
; RV32I-NEXT:    sb a3, 2(a2)
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    sb a3, 3(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 1(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 6(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 7(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    ret
  %src = load i64, ptr %src.ptr, align 1
  %bitOff = load i64, ptr %bitOff.ptr, align 1
  %res = shl i64 %src, %bitOff
  store i64 %res, ptr %dst, align 1
  ret void
}
define void @ashr_8bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_8bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    lbu a3, 1(a1)
; RV64I-NEXT:    lbu a4, 0(a1)
; RV64I-NEXT:    lbu a5, 2(a1)
; RV64I-NEXT:    lbu a6, 3(a1)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a1)
; RV64I-NEXT:    lbu a5, 4(a1)
; RV64I-NEXT:    lbu a6, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    sra a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_8bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    lbu a4, 4(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 7(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a4, a6, 24
; RV32I-NEXT:    or a5, a4, a5
; RV32I-NEXT:    or a3, a5, a3
; RV32I-NEXT:    lbu a5, 1(a1)
; RV32I-NEXT:    lbu a6, 0(a1)
; RV32I-NEXT:    lbu a7, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a5, a5, 8
; RV32I-NEXT:    or a5, a5, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a7
; RV32I-NEXT:    or a5, a1, a5
; RV32I-NEXT:    addi a6, a5, -32
; RV32I-NEXT:    sra a1, a3, a5
; RV32I-NEXT:    bltz a6, .LBB5_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    mv a1, a4
; RV32I-NEXT:    j .LBB5_3
; RV32I-NEXT:  .LBB5_2:
; RV32I-NEXT:    lbu a4, 1(a0)
; RV32I-NEXT:    lbu a6, 0(a0)
; RV32I-NEXT:    lbu a7, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    or a4, a4, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a7
; RV32I-NEXT:    or a0, a0, a4
; RV32I-NEXT:    srl a0, a0, a5
; RV32I-NEXT:    not a4, a5
; RV32I-NEXT:    slli a3, a3, 1
; RV32I-NEXT:    sll a3, a3, a4
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:  .LBB5_3:
; RV32I-NEXT:    sb a1, 4(a2)
; RV32I-NEXT:    srli a3, a1, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    sb a3, 7(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i64, ptr %src.ptr, align 1
  %bitOff = load i64, ptr %bitOff.ptr, align 1
  %res = ashr i64 %src, %bitOff
  store i64 %res, ptr %dst, align 1
  ret void
}

define void @lshr_16bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_16bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 9(a0)
; RV64I-NEXT:    lbu a4, 8(a0)
; RV64I-NEXT:    lbu a5, 10(a0)
; RV64I-NEXT:    lbu a6, 11(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 13(a0)
; RV64I-NEXT:    lbu a5, 12(a0)
; RV64I-NEXT:    lbu a6, 14(a0)
; RV64I-NEXT:    lbu a7, 15(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a4, a4, 32
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 1(a1)
; RV64I-NEXT:    lbu a5, 0(a1)
; RV64I-NEXT:    lbu a6, 2(a1)
; RV64I-NEXT:    lbu a7, 3(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    lbu a5, 5(a1)
; RV64I-NEXT:    lbu a6, 4(a1)
; RV64I-NEXT:    lbu a7, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a7
; RV64I-NEXT:    or a1, a1, a5
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a5, a1, a4
; RV64I-NEXT:    addi a4, a5, -64
; RV64I-NEXT:    srl a1, a3, a5
; RV64I-NEXT:    bltz a4, .LBB6_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    j .LBB6_3
; RV64I-NEXT:  .LBB6_2:
; RV64I-NEXT:    lbu a6, 1(a0)
; RV64I-NEXT:    lbu a7, 0(a0)
; RV64I-NEXT:    lbu t0, 2(a0)
; RV64I-NEXT:    lbu t1, 3(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 5(a0)
; RV64I-NEXT:    lbu t0, 4(a0)
; RV64I-NEXT:    lbu t1, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, t1
; RV64I-NEXT:    or a0, a0, a7
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    srl a0, a0, a5
; RV64I-NEXT:    not a5, a5
; RV64I-NEXT:    slli a3, a3, 1
; RV64I-NEXT:    sll a3, a3, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:  .LBB6_3:
; RV64I-NEXT:    srai a4, a4, 63
; RV64I-NEXT:    and a1, a4, a1
; RV64I-NEXT:    sb a1, 8(a2)
; RV64I-NEXT:    srli a3, a1, 56
; RV64I-NEXT:    sb a3, 15(a2)
; RV64I-NEXT:    srli a3, a1, 48
; RV64I-NEXT:    sb a3, 14(a2)
; RV64I-NEXT:    srli a3, a1, 40
; RV64I-NEXT:    sb a3, 13(a2)
; RV64I-NEXT:    srli a3, a1, 32
; RV64I-NEXT:    sb a3, 12(a2)
; RV64I-NEXT:    srli a3, a1, 24
; RV64I-NEXT:    sb a3, 11(a2)
; RV64I-NEXT:    srli a3, a1, 16
; RV64I-NEXT:    sb a3, 10(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 9(a2)
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_16bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -64
; RV32I-NEXT:    sw s0, 60(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 56(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 52(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 48(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    lbu a4, 1(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a6, 3(a0)
; RV32I-NEXT:    lbu a7, 4(a0)
; RV32I-NEXT:    lbu t0, 5(a0)
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 1(a1)
; RV32I-NEXT:    lbu s1, 0(a1)
; RV32I-NEXT:    lbu s2, 12(a0)
; RV32I-NEXT:    lbu s3, 13(a0)
; RV32I-NEXT:    slli s0, s0, 8
; RV32I-NEXT:    or s0, s0, s1
; RV32I-NEXT:    lbu s1, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    lbu s4, 14(a0)
; RV32I-NEXT:    lbu a0, 15(a0)
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, s1
; RV32I-NEXT:    or a1, a1, s0
; RV32I-NEXT:    sb zero, 43(sp)
; RV32I-NEXT:    sb zero, 42(sp)
; RV32I-NEXT:    sb zero, 41(sp)
; RV32I-NEXT:    sb zero, 40(sp)
; RV32I-NEXT:    sb zero, 39(sp)
; RV32I-NEXT:    sb zero, 38(sp)
; RV32I-NEXT:    sb zero, 37(sp)
; RV32I-NEXT:    sb zero, 36(sp)
; RV32I-NEXT:    sb zero, 35(sp)
; RV32I-NEXT:    sb zero, 34(sp)
; RV32I-NEXT:    sb zero, 33(sp)
; RV32I-NEXT:    sb zero, 32(sp)
; RV32I-NEXT:    sb zero, 31(sp)
; RV32I-NEXT:    sb zero, 30(sp)
; RV32I-NEXT:    sb zero, 29(sp)
; RV32I-NEXT:    sb zero, 28(sp)
; RV32I-NEXT:    sb a0, 27(sp)
; RV32I-NEXT:    sb s4, 26(sp)
; RV32I-NEXT:    sb s3, 25(sp)
; RV32I-NEXT:    sb s2, 24(sp)
; RV32I-NEXT:    sb t6, 23(sp)
; RV32I-NEXT:    sb t5, 22(sp)
; RV32I-NEXT:    sb t4, 21(sp)
; RV32I-NEXT:    sb t3, 20(sp)
; RV32I-NEXT:    sb t2, 19(sp)
; RV32I-NEXT:    sb t1, 18(sp)
; RV32I-NEXT:    sb t0, 17(sp)
; RV32I-NEXT:    sb a7, 16(sp)
; RV32I-NEXT:    sb a6, 15(sp)
; RV32I-NEXT:    sb a5, 14(sp)
; RV32I-NEXT:    sb a4, 13(sp)
; RV32I-NEXT:    sb a3, 12(sp)
; RV32I-NEXT:    slli a0, a1, 25
; RV32I-NEXT:    srli a0, a0, 28
; RV32I-NEXT:    addi a3, sp, 12
; RV32I-NEXT:    add a3, a3, a0
; RV32I-NEXT:    lbu a0, 5(a3)
; RV32I-NEXT:    lbu a4, 4(a3)
; RV32I-NEXT:    lbu a5, 6(a3)
; RV32I-NEXT:    lbu a6, 7(a3)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a4, a4, a0
; RV32I-NEXT:    andi a5, a1, 7
; RV32I-NEXT:    srl a0, a4, a5
; RV32I-NEXT:    lbu a1, 9(a3)
; RV32I-NEXT:    lbu a6, 8(a3)
; RV32I-NEXT:    lbu a7, 10(a3)
; RV32I-NEXT:    lbu t0, 11(a3)
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli t0, t0, 24
; RV32I-NEXT:    or a6, t0, a7
; RV32I-NEXT:    or a6, a6, a1
; RV32I-NEXT:    slli a1, a6, 1
; RV32I-NEXT:    not a7, a5
; RV32I-NEXT:    sll a1, a1, a7
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    lbu a7, 1(a3)
; RV32I-NEXT:    lbu t0, 0(a3)
; RV32I-NEXT:    lbu t1, 2(a3)
; RV32I-NEXT:    lbu t2, 3(a3)
; RV32I-NEXT:    slli a7, a7, 8
; RV32I-NEXT:    or a7, a7, t0
; RV32I-NEXT:    slli t1, t1, 16
; RV32I-NEXT:    slli t2, t2, 24
; RV32I-NEXT:    or t0, t2, t1
; RV32I-NEXT:    or a7, t0, a7
; RV32I-NEXT:    srl a7, a7, a5
; RV32I-NEXT:    slli a4, a4, 1
; RV32I-NEXT:    xori t0, a5, 31
; RV32I-NEXT:    sll a4, a4, t0
; RV32I-NEXT:    or a4, a7, a4
; RV32I-NEXT:    srl a6, a6, a5
; RV32I-NEXT:    lbu t1, 13(a3)
; RV32I-NEXT:    lbu t2, 12(a3)
; RV32I-NEXT:    lbu t3, 14(a3)
; RV32I-NEXT:    lbu a3, 15(a3)
; RV32I-NEXT:    slli t1, t1, 8
; RV32I-NEXT:    or t1, t1, t2
; RV32I-NEXT:    slli t3, t3, 16
; RV32I-NEXT:    slli a3, a3, 24
; RV32I-NEXT:    or a3, a3, t3
; RV32I-NEXT:    or a3, a3, t1
; RV32I-NEXT:    slli t1, a3, 1
; RV32I-NEXT:    sll t0, t1, t0
; RV32I-NEXT:    or t0, a6, t0
; RV32I-NEXT:    srl a3, a3, a5
; RV32I-NEXT:    sb a6, 8(a2)
; RV32I-NEXT:    sb a3, 12(a2)
; RV32I-NEXT:    sb a7, 0(a2)
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    srli a5, a6, 16
; RV32I-NEXT:    sb a5, 10(a2)
; RV32I-NEXT:    srli a5, a6, 8
; RV32I-NEXT:    sb a5, 9(a2)
; RV32I-NEXT:    srli a5, a3, 16
; RV32I-NEXT:    sb a5, 14(a2)
; RV32I-NEXT:    srli a5, a3, 24
; RV32I-NEXT:    sb a5, 15(a2)
; RV32I-NEXT:    srli a3, a3, 8
; RV32I-NEXT:    sb a3, 13(a2)
; RV32I-NEXT:    srli a3, a7, 16
; RV32I-NEXT:    sb a3, 2(a2)
; RV32I-NEXT:    srli a3, a7, 8
; RV32I-NEXT:    sb a3, 1(a2)
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    srli a0, t0, 24
; RV32I-NEXT:    sb a0, 11(a2)
; RV32I-NEXT:    srli a4, a4, 24
; RV32I-NEXT:    sb a4, 3(a2)
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    sb a1, 7(a2)
; RV32I-NEXT:    lw s0, 60(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 56(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 52(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 48(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 64
; RV32I-NEXT:    ret
  %src = load i128, ptr %src.ptr, align 1
  %bitOff = load i128, ptr %bitOff.ptr, align 1
  %res = lshr i128 %src, %bitOff
  store i128 %res, ptr %dst, align 1
  ret void
}
define void @shl_16bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_16bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a7, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a4, a4, 32
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 1(a1)
; RV64I-NEXT:    lbu a5, 0(a1)
; RV64I-NEXT:    lbu a6, 2(a1)
; RV64I-NEXT:    lbu a7, 3(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    lbu a5, 5(a1)
; RV64I-NEXT:    lbu a6, 4(a1)
; RV64I-NEXT:    lbu a7, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a7
; RV64I-NEXT:    or a1, a1, a5
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a5, a1, a4
; RV64I-NEXT:    addi a4, a5, -64
; RV64I-NEXT:    sll a1, a3, a5
; RV64I-NEXT:    bltz a4, .LBB7_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    j .LBB7_3
; RV64I-NEXT:  .LBB7_2:
; RV64I-NEXT:    lbu a6, 9(a0)
; RV64I-NEXT:    lbu a7, 8(a0)
; RV64I-NEXT:    lbu t0, 10(a0)
; RV64I-NEXT:    lbu t1, 11(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 13(a0)
; RV64I-NEXT:    lbu t0, 12(a0)
; RV64I-NEXT:    lbu t1, 14(a0)
; RV64I-NEXT:    lbu a0, 15(a0)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, t1
; RV64I-NEXT:    or a0, a0, a7
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    sll a0, a0, a5
; RV64I-NEXT:    not a5, a5
; RV64I-NEXT:    srli a3, a3, 1
; RV64I-NEXT:    srl a3, a3, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:  .LBB7_3:
; RV64I-NEXT:    srai a4, a4, 63
; RV64I-NEXT:    and a1, a4, a1
; RV64I-NEXT:    sb a1, 0(a2)
; RV64I-NEXT:    sb a0, 8(a2)
; RV64I-NEXT:    srli a3, a1, 56
; RV64I-NEXT:    sb a3, 7(a2)
; RV64I-NEXT:    srli a3, a1, 48
; RV64I-NEXT:    sb a3, 6(a2)
; RV64I-NEXT:    srli a3, a1, 40
; RV64I-NEXT:    sb a3, 5(a2)
; RV64I-NEXT:    srli a3, a1, 32
; RV64I-NEXT:    sb a3, 4(a2)
; RV64I-NEXT:    srli a3, a1, 24
; RV64I-NEXT:    sb a3, 3(a2)
; RV64I-NEXT:    srli a3, a1, 16
; RV64I-NEXT:    sb a3, 2(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 1(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 15(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 14(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 13(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 12(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 11(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 10(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 9(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_16bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -64
; RV32I-NEXT:    sw s0, 60(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 56(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 52(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 48(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    lbu a4, 1(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a6, 3(a0)
; RV32I-NEXT:    lbu a7, 4(a0)
; RV32I-NEXT:    lbu t0, 5(a0)
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 1(a1)
; RV32I-NEXT:    lbu s1, 0(a1)
; RV32I-NEXT:    lbu s2, 12(a0)
; RV32I-NEXT:    lbu s3, 13(a0)
; RV32I-NEXT:    slli s0, s0, 8
; RV32I-NEXT:    or s0, s0, s1
; RV32I-NEXT:    lbu s1, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    lbu s4, 14(a0)
; RV32I-NEXT:    lbu a0, 15(a0)
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, s1
; RV32I-NEXT:    or a1, a1, s0
; RV32I-NEXT:    sb zero, 27(sp)
; RV32I-NEXT:    sb zero, 26(sp)
; RV32I-NEXT:    sb zero, 25(sp)
; RV32I-NEXT:    sb zero, 24(sp)
; RV32I-NEXT:    sb zero, 23(sp)
; RV32I-NEXT:    sb zero, 22(sp)
; RV32I-NEXT:    sb zero, 21(sp)
; RV32I-NEXT:    sb zero, 20(sp)
; RV32I-NEXT:    sb zero, 19(sp)
; RV32I-NEXT:    sb zero, 18(sp)
; RV32I-NEXT:    sb zero, 17(sp)
; RV32I-NEXT:    sb zero, 16(sp)
; RV32I-NEXT:    sb zero, 15(sp)
; RV32I-NEXT:    sb zero, 14(sp)
; RV32I-NEXT:    sb zero, 13(sp)
; RV32I-NEXT:    sb zero, 12(sp)
; RV32I-NEXT:    sb a0, 43(sp)
; RV32I-NEXT:    sb s4, 42(sp)
; RV32I-NEXT:    sb s3, 41(sp)
; RV32I-NEXT:    sb s2, 40(sp)
; RV32I-NEXT:    sb t6, 39(sp)
; RV32I-NEXT:    sb t5, 38(sp)
; RV32I-NEXT:    sb t4, 37(sp)
; RV32I-NEXT:    sb t3, 36(sp)
; RV32I-NEXT:    sb t2, 35(sp)
; RV32I-NEXT:    sb t1, 34(sp)
; RV32I-NEXT:    sb t0, 33(sp)
; RV32I-NEXT:    sb a7, 32(sp)
; RV32I-NEXT:    sb a6, 31(sp)
; RV32I-NEXT:    sb a5, 30(sp)
; RV32I-NEXT:    sb a4, 29(sp)
; RV32I-NEXT:    sb a3, 28(sp)
; RV32I-NEXT:    slli a0, a1, 25
; RV32I-NEXT:    srli a0, a0, 28
; RV32I-NEXT:    addi a3, sp, 28
; RV32I-NEXT:    sub a3, a3, a0
; RV32I-NEXT:    lbu a0, 5(a3)
; RV32I-NEXT:    lbu a4, 4(a3)
; RV32I-NEXT:    lbu a5, 6(a3)
; RV32I-NEXT:    lbu a6, 7(a3)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a4, a4, a0
; RV32I-NEXT:    andi a5, a1, 7
; RV32I-NEXT:    sll a0, a4, a5
; RV32I-NEXT:    lbu a1, 1(a3)
; RV32I-NEXT:    lbu a6, 0(a3)
; RV32I-NEXT:    lbu a7, 2(a3)
; RV32I-NEXT:    lbu t0, 3(a3)
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli t0, t0, 24
; RV32I-NEXT:    or a6, t0, a7
; RV32I-NEXT:    or a6, a6, a1
; RV32I-NEXT:    srli a1, a6, 1
; RV32I-NEXT:    xori a7, a5, 31
; RV32I-NEXT:    srl a1, a1, a7
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    lbu t0, 13(a3)
; RV32I-NEXT:    lbu t1, 12(a3)
; RV32I-NEXT:    lbu t2, 14(a3)
; RV32I-NEXT:    lbu t3, 15(a3)
; RV32I-NEXT:    slli t0, t0, 8
; RV32I-NEXT:    or t0, t0, t1
; RV32I-NEXT:    slli t2, t2, 16
; RV32I-NEXT:    slli t3, t3, 24
; RV32I-NEXT:    or t1, t3, t2
; RV32I-NEXT:    or t0, t1, t0
; RV32I-NEXT:    sll t0, t0, a5
; RV32I-NEXT:    lbu t1, 9(a3)
; RV32I-NEXT:    lbu t2, 8(a3)
; RV32I-NEXT:    lbu t3, 10(a3)
; RV32I-NEXT:    lbu a3, 11(a3)
; RV32I-NEXT:    slli t1, t1, 8
; RV32I-NEXT:    or t1, t1, t2
; RV32I-NEXT:    slli t3, t3, 16
; RV32I-NEXT:    slli a3, a3, 24
; RV32I-NEXT:    or a3, a3, t3
; RV32I-NEXT:    or a3, a3, t1
; RV32I-NEXT:    srli t1, a3, 1
; RV32I-NEXT:    srl a7, t1, a7
; RV32I-NEXT:    or a7, t0, a7
; RV32I-NEXT:    sll a3, a3, a5
; RV32I-NEXT:    srli a4, a4, 1
; RV32I-NEXT:    not t1, a5
; RV32I-NEXT:    srl a4, a4, t1
; RV32I-NEXT:    or a4, a3, a4
; RV32I-NEXT:    sll a5, a6, a5
; RV32I-NEXT:    sb a5, 0(a2)
; RV32I-NEXT:    srli a6, a3, 16
; RV32I-NEXT:    sb a6, 10(a2)
; RV32I-NEXT:    srli a6, a3, 24
; RV32I-NEXT:    sb a6, 11(a2)
; RV32I-NEXT:    srli a3, a3, 8
; RV32I-NEXT:    sb a3, 9(a2)
; RV32I-NEXT:    srli a3, t0, 16
; RV32I-NEXT:    sb a3, 14(a2)
; RV32I-NEXT:    srli a3, t0, 24
; RV32I-NEXT:    sb a3, 15(a2)
; RV32I-NEXT:    srli a3, t0, 8
; RV32I-NEXT:    sb a3, 13(a2)
; RV32I-NEXT:    srli a3, a5, 16
; RV32I-NEXT:    sb a3, 2(a2)
; RV32I-NEXT:    srli a3, a5, 24
; RV32I-NEXT:    sb a3, 3(a2)
; RV32I-NEXT:    srli a5, a5, 8
; RV32I-NEXT:    sb a5, 1(a2)
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    sb a3, 7(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    sb a4, 8(a2)
; RV32I-NEXT:    sb a7, 12(a2)
; RV32I-NEXT:    sb a1, 4(a2)
; RV32I-NEXT:    lw s0, 60(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 56(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 52(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 48(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 64
; RV32I-NEXT:    ret
  %src = load i128, ptr %src.ptr, align 1
  %bitOff = load i128, ptr %bitOff.ptr, align 1
  %res = shl i128 %src, %bitOff
  store i128 %res, ptr %dst, align 1
  ret void
}
define void @ashr_16bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_16bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 9(a0)
; RV64I-NEXT:    lbu a4, 8(a0)
; RV64I-NEXT:    lbu a5, 10(a0)
; RV64I-NEXT:    lbu a6, 11(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 13(a0)
; RV64I-NEXT:    lbu a5, 12(a0)
; RV64I-NEXT:    lbu a6, 14(a0)
; RV64I-NEXT:    lbu a7, 15(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a5, a4, 32
; RV64I-NEXT:    or a3, a5, a3
; RV64I-NEXT:    lbu a5, 1(a1)
; RV64I-NEXT:    lbu a6, 0(a1)
; RV64I-NEXT:    lbu a7, 2(a1)
; RV64I-NEXT:    lbu t0, 3(a1)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    lbu a6, 5(a1)
; RV64I-NEXT:    lbu a7, 4(a1)
; RV64I-NEXT:    lbu t0, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, t0
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a5, a1, a5
; RV64I-NEXT:    addi a6, a5, -64
; RV64I-NEXT:    sra a1, a3, a5
; RV64I-NEXT:    bltz a6, .LBB8_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    sraiw a3, a4, 31
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    mv a1, a3
; RV64I-NEXT:    j .LBB8_3
; RV64I-NEXT:  .LBB8_2:
; RV64I-NEXT:    lbu a4, 1(a0)
; RV64I-NEXT:    lbu a6, 0(a0)
; RV64I-NEXT:    lbu a7, 2(a0)
; RV64I-NEXT:    lbu t0, 3(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a4, a6, a4
; RV64I-NEXT:    lbu a6, 5(a0)
; RV64I-NEXT:    lbu a7, 4(a0)
; RV64I-NEXT:    lbu t0, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, t0
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    srl a0, a0, a5
; RV64I-NEXT:    not a4, a5
; RV64I-NEXT:    slli a3, a3, 1
; RV64I-NEXT:    sll a3, a3, a4
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:  .LBB8_3:
; RV64I-NEXT:    sb a1, 8(a2)
; RV64I-NEXT:    srli a3, a1, 56
; RV64I-NEXT:    sb a3, 15(a2)
; RV64I-NEXT:    srli a3, a1, 48
; RV64I-NEXT:    sb a3, 14(a2)
; RV64I-NEXT:    srli a3, a1, 40
; RV64I-NEXT:    sb a3, 13(a2)
; RV64I-NEXT:    srli a3, a1, 32
; RV64I-NEXT:    sb a3, 12(a2)
; RV64I-NEXT:    srli a3, a1, 24
; RV64I-NEXT:    sb a3, 11(a2)
; RV64I-NEXT:    srli a3, a1, 16
; RV64I-NEXT:    sb a3, 10(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 9(a2)
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_16bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -64
; RV32I-NEXT:    sw s0, 60(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 56(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 52(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 48(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 40(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 15(a0)
; RV32I-NEXT:    slli a4, a3, 24
; RV32I-NEXT:    lbu a5, 0(a0)
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 2(a0)
; RV32I-NEXT:    lbu t0, 3(a0)
; RV32I-NEXT:    lbu t1, 4(a0)
; RV32I-NEXT:    lbu t2, 5(a0)
; RV32I-NEXT:    lbu t3, 6(a0)
; RV32I-NEXT:    lbu t4, 7(a0)
; RV32I-NEXT:    lbu t5, 8(a0)
; RV32I-NEXT:    lbu t6, 9(a0)
; RV32I-NEXT:    lbu s0, 10(a0)
; RV32I-NEXT:    lbu s1, 1(a1)
; RV32I-NEXT:    lbu s2, 0(a1)
; RV32I-NEXT:    lbu s3, 11(a0)
; RV32I-NEXT:    lbu s4, 12(a0)
; RV32I-NEXT:    slli s1, s1, 8
; RV32I-NEXT:    or s1, s1, s2
; RV32I-NEXT:    lbu s2, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    lbu s5, 13(a0)
; RV32I-NEXT:    lbu a0, 14(a0)
; RV32I-NEXT:    slli s2, s2, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, s2
; RV32I-NEXT:    or a1, a1, s1
; RV32I-NEXT:    sb a3, 23(sp)
; RV32I-NEXT:    sb a0, 22(sp)
; RV32I-NEXT:    sb s5, 21(sp)
; RV32I-NEXT:    sb s4, 20(sp)
; RV32I-NEXT:    sb s3, 19(sp)
; RV32I-NEXT:    sb s0, 18(sp)
; RV32I-NEXT:    sb t6, 17(sp)
; RV32I-NEXT:    sb t5, 16(sp)
; RV32I-NEXT:    sb t4, 15(sp)
; RV32I-NEXT:    sb t3, 14(sp)
; RV32I-NEXT:    sb t2, 13(sp)
; RV32I-NEXT:    sb t1, 12(sp)
; RV32I-NEXT:    sb t0, 11(sp)
; RV32I-NEXT:    sb a7, 10(sp)
; RV32I-NEXT:    sb a6, 9(sp)
; RV32I-NEXT:    sb a5, 8(sp)
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    sb a4, 36(sp)
; RV32I-NEXT:    sb a4, 32(sp)
; RV32I-NEXT:    sb a4, 28(sp)
; RV32I-NEXT:    sb a4, 24(sp)
; RV32I-NEXT:    srli a0, a4, 24
; RV32I-NEXT:    sb a0, 39(sp)
; RV32I-NEXT:    srli a3, a4, 16
; RV32I-NEXT:    sb a3, 38(sp)
; RV32I-NEXT:    srli a4, a4, 8
; RV32I-NEXT:    sb a4, 37(sp)
; RV32I-NEXT:    sb a0, 35(sp)
; RV32I-NEXT:    sb a3, 34(sp)
; RV32I-NEXT:    sb a4, 33(sp)
; RV32I-NEXT:    sb a0, 31(sp)
; RV32I-NEXT:    sb a3, 30(sp)
; RV32I-NEXT:    sb a4, 29(sp)
; RV32I-NEXT:    sb a0, 27(sp)
; RV32I-NEXT:    sb a3, 26(sp)
; RV32I-NEXT:    sb a4, 25(sp)
; RV32I-NEXT:    slli a0, a1, 25
; RV32I-NEXT:    srli a0, a0, 28
; RV32I-NEXT:    addi a3, sp, 8
; RV32I-NEXT:    add a3, a3, a0
; RV32I-NEXT:    lbu a0, 5(a3)
; RV32I-NEXT:    lbu a4, 4(a3)
; RV32I-NEXT:    lbu a5, 6(a3)
; RV32I-NEXT:    lbu a6, 7(a3)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a4, a4, a0
; RV32I-NEXT:    andi a5, a1, 7
; RV32I-NEXT:    srl a0, a4, a5
; RV32I-NEXT:    lbu a1, 9(a3)
; RV32I-NEXT:    lbu a6, 8(a3)
; RV32I-NEXT:    lbu a7, 10(a3)
; RV32I-NEXT:    lbu t0, 11(a3)
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli t0, t0, 24
; RV32I-NEXT:    or a6, t0, a7
; RV32I-NEXT:    or a6, a6, a1
; RV32I-NEXT:    slli a1, a6, 1
; RV32I-NEXT:    not a7, a5
; RV32I-NEXT:    sll a1, a1, a7
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    lbu a7, 1(a3)
; RV32I-NEXT:    lbu t0, 0(a3)
; RV32I-NEXT:    lbu t1, 2(a3)
; RV32I-NEXT:    lbu t2, 3(a3)
; RV32I-NEXT:    slli a7, a7, 8
; RV32I-NEXT:    or a7, a7, t0
; RV32I-NEXT:    slli t1, t1, 16
; RV32I-NEXT:    slli t2, t2, 24
; RV32I-NEXT:    or t0, t2, t1
; RV32I-NEXT:    or a7, t0, a7
; RV32I-NEXT:    srl a7, a7, a5
; RV32I-NEXT:    slli a4, a4, 1
; RV32I-NEXT:    xori t0, a5, 31
; RV32I-NEXT:    sll a4, a4, t0
; RV32I-NEXT:    or a4, a7, a4
; RV32I-NEXT:    srl a6, a6, a5
; RV32I-NEXT:    lbu t1, 13(a3)
; RV32I-NEXT:    lbu t2, 12(a3)
; RV32I-NEXT:    lbu t3, 14(a3)
; RV32I-NEXT:    lbu a3, 15(a3)
; RV32I-NEXT:    slli t1, t1, 8
; RV32I-NEXT:    or t1, t1, t2
; RV32I-NEXT:    slli t3, t3, 16
; RV32I-NEXT:    slli a3, a3, 24
; RV32I-NEXT:    or a3, a3, t3
; RV32I-NEXT:    or a3, a3, t1
; RV32I-NEXT:    slli t1, a3, 1
; RV32I-NEXT:    sll t0, t1, t0
; RV32I-NEXT:    or t0, a6, t0
; RV32I-NEXT:    sra a3, a3, a5
; RV32I-NEXT:    sb a6, 8(a2)
; RV32I-NEXT:    sb a3, 12(a2)
; RV32I-NEXT:    sb a7, 0(a2)
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    srli a5, a6, 16
; RV32I-NEXT:    sb a5, 10(a2)
; RV32I-NEXT:    srli a5, a6, 8
; RV32I-NEXT:    sb a5, 9(a2)
; RV32I-NEXT:    srli a5, a3, 16
; RV32I-NEXT:    sb a5, 14(a2)
; RV32I-NEXT:    srli a5, a3, 24
; RV32I-NEXT:    sb a5, 15(a2)
; RV32I-NEXT:    srli a3, a3, 8
; RV32I-NEXT:    sb a3, 13(a2)
; RV32I-NEXT:    srli a3, a7, 16
; RV32I-NEXT:    sb a3, 2(a2)
; RV32I-NEXT:    srli a3, a7, 8
; RV32I-NEXT:    sb a3, 1(a2)
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    srli a0, t0, 24
; RV32I-NEXT:    sb a0, 11(a2)
; RV32I-NEXT:    srli a4, a4, 24
; RV32I-NEXT:    sb a4, 3(a2)
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    sb a1, 7(a2)
; RV32I-NEXT:    lw s0, 60(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 56(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 52(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 48(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 40(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 64
; RV32I-NEXT:    ret
  %src = load i128, ptr %src.ptr, align 1
  %bitOff = load i128, ptr %bitOff.ptr, align 1
  %res = ashr i128 %src, %bitOff
  store i128 %res, ptr %dst, align 1
  ret void
}

define void @lshr_32bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_32bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -224
; RV64I-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    sd a3, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    sd a3, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 2(a0)
; RV64I-NEXT:    sd a3, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 3(a0)
; RV64I-NEXT:    sd a3, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 4(a0)
; RV64I-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 5(a0)
; RV64I-NEXT:    sd a3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t1, 6(a0)
; RV64I-NEXT:    lbu t2, 7(a0)
; RV64I-NEXT:    lbu t3, 8(a0)
; RV64I-NEXT:    lbu t4, 9(a0)
; RV64I-NEXT:    lbu t5, 10(a0)
; RV64I-NEXT:    lbu t6, 11(a0)
; RV64I-NEXT:    lbu s0, 12(a0)
; RV64I-NEXT:    lbu s1, 13(a0)
; RV64I-NEXT:    lbu s2, 14(a0)
; RV64I-NEXT:    lbu s3, 15(a0)
; RV64I-NEXT:    lbu s4, 16(a0)
; RV64I-NEXT:    lbu s5, 17(a0)
; RV64I-NEXT:    lbu s6, 18(a0)
; RV64I-NEXT:    lbu s7, 19(a0)
; RV64I-NEXT:    lbu s8, 20(a0)
; RV64I-NEXT:    lbu s9, 1(a1)
; RV64I-NEXT:    lbu s10, 0(a1)
; RV64I-NEXT:    lbu s11, 2(a1)
; RV64I-NEXT:    lbu ra, 3(a1)
; RV64I-NEXT:    slli s9, s9, 8
; RV64I-NEXT:    or s9, s9, s10
; RV64I-NEXT:    slli s11, s11, 16
; RV64I-NEXT:    slli ra, ra, 24
; RV64I-NEXT:    lbu s10, 5(a1)
; RV64I-NEXT:    or s11, ra, s11
; RV64I-NEXT:    or s9, s11, s9
; RV64I-NEXT:    lbu s11, 4(a1)
; RV64I-NEXT:    slli s10, s10, 8
; RV64I-NEXT:    lbu ra, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    or s10, s10, s11
; RV64I-NEXT:    lbu s11, 21(a0)
; RV64I-NEXT:    slli ra, ra, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, ra
; RV64I-NEXT:    lbu ra, 22(a0)
; RV64I-NEXT:    or a1, a1, s10
; RV64I-NEXT:    lbu s10, 23(a0)
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or t0, a1, s9
; RV64I-NEXT:    lbu s9, 24(a0)
; RV64I-NEXT:    lbu a7, 25(a0)
; RV64I-NEXT:    lbu a6, 26(a0)
; RV64I-NEXT:    lbu a5, 27(a0)
; RV64I-NEXT:    lbu a1, 31(a0)
; RV64I-NEXT:    lbu a3, 30(a0)
; RV64I-NEXT:    lbu a4, 29(a0)
; RV64I-NEXT:    lbu a0, 28(a0)
; RV64I-NEXT:    sb a1, 87(sp)
; RV64I-NEXT:    sb a3, 86(sp)
; RV64I-NEXT:    sb a4, 85(sp)
; RV64I-NEXT:    sb a0, 84(sp)
; RV64I-NEXT:    sb a5, 83(sp)
; RV64I-NEXT:    sb a6, 82(sp)
; RV64I-NEXT:    sb a7, 81(sp)
; RV64I-NEXT:    sb s9, 80(sp)
; RV64I-NEXT:    sb s10, 79(sp)
; RV64I-NEXT:    sb ra, 78(sp)
; RV64I-NEXT:    sb s11, 77(sp)
; RV64I-NEXT:    sb s8, 76(sp)
; RV64I-NEXT:    sb s7, 75(sp)
; RV64I-NEXT:    sb s6, 74(sp)
; RV64I-NEXT:    sb s5, 73(sp)
; RV64I-NEXT:    sb s4, 72(sp)
; RV64I-NEXT:    sb s3, 71(sp)
; RV64I-NEXT:    sb s2, 70(sp)
; RV64I-NEXT:    sb s1, 69(sp)
; RV64I-NEXT:    sb s0, 68(sp)
; RV64I-NEXT:    sb t6, 67(sp)
; RV64I-NEXT:    sb t5, 66(sp)
; RV64I-NEXT:    sb t4, 65(sp)
; RV64I-NEXT:    sb zero, 119(sp)
; RV64I-NEXT:    sb zero, 118(sp)
; RV64I-NEXT:    sb zero, 117(sp)
; RV64I-NEXT:    sb zero, 116(sp)
; RV64I-NEXT:    sb zero, 115(sp)
; RV64I-NEXT:    sb zero, 114(sp)
; RV64I-NEXT:    sb zero, 113(sp)
; RV64I-NEXT:    sb zero, 112(sp)
; RV64I-NEXT:    sb zero, 111(sp)
; RV64I-NEXT:    sb zero, 110(sp)
; RV64I-NEXT:    sb zero, 109(sp)
; RV64I-NEXT:    sb zero, 108(sp)
; RV64I-NEXT:    sb zero, 107(sp)
; RV64I-NEXT:    sb zero, 106(sp)
; RV64I-NEXT:    sb zero, 105(sp)
; RV64I-NEXT:    sb zero, 104(sp)
; RV64I-NEXT:    sb zero, 103(sp)
; RV64I-NEXT:    sb zero, 102(sp)
; RV64I-NEXT:    sb zero, 101(sp)
; RV64I-NEXT:    sb zero, 100(sp)
; RV64I-NEXT:    sb zero, 99(sp)
; RV64I-NEXT:    sb zero, 98(sp)
; RV64I-NEXT:    sb zero, 97(sp)
; RV64I-NEXT:    sb zero, 96(sp)
; RV64I-NEXT:    sb zero, 95(sp)
; RV64I-NEXT:    sb zero, 94(sp)
; RV64I-NEXT:    sb zero, 93(sp)
; RV64I-NEXT:    sb zero, 92(sp)
; RV64I-NEXT:    sb zero, 91(sp)
; RV64I-NEXT:    sb zero, 90(sp)
; RV64I-NEXT:    sb zero, 89(sp)
; RV64I-NEXT:    sb zero, 88(sp)
; RV64I-NEXT:    sb t3, 64(sp)
; RV64I-NEXT:    sb t2, 63(sp)
; RV64I-NEXT:    sb t1, 62(sp)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 61(sp)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 60(sp)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 59(sp)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 58(sp)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 57(sp)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 56(sp)
; RV64I-NEXT:    slli a0, t0, 56
; RV64I-NEXT:    srli a0, a0, 59
; RV64I-NEXT:    addi a3, sp, 56
; RV64I-NEXT:    add a3, a3, a0
; RV64I-NEXT:    lbu a0, 9(a3)
; RV64I-NEXT:    lbu a1, 8(a3)
; RV64I-NEXT:    lbu a4, 10(a3)
; RV64I-NEXT:    lbu a5, 11(a3)
; RV64I-NEXT:    slli a0, a0, 8
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    slli a4, a4, 16
; RV64I-NEXT:    slli a5, a5, 24
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    lbu a1, 13(a3)
; RV64I-NEXT:    lbu a4, 12(a3)
; RV64I-NEXT:    lbu a5, 14(a3)
; RV64I-NEXT:    lbu a6, 15(a3)
; RV64I-NEXT:    slli a1, a1, 8
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a1, a4, a1
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a4, a1, a0
; RV64I-NEXT:    andi a1, t0, 7
; RV64I-NEXT:    lbu a0, 17(a3)
; RV64I-NEXT:    lbu a5, 16(a3)
; RV64I-NEXT:    lbu a6, 18(a3)
; RV64I-NEXT:    lbu a7, 19(a3)
; RV64I-NEXT:    slli a0, a0, 8
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a0, a5, a0
; RV64I-NEXT:    lbu a5, 21(a3)
; RV64I-NEXT:    lbu a6, 20(a3)
; RV64I-NEXT:    lbu a7, 22(a3)
; RV64I-NEXT:    lbu t0, 23(a3)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    slli a5, a5, 32
; RV64I-NEXT:    or a5, a5, a0
; RV64I-NEXT:    slli a0, a5, 1
; RV64I-NEXT:    not a6, a1
; RV64I-NEXT:    sll a0, a0, a6
; RV64I-NEXT:    lbu a6, 1(a3)
; RV64I-NEXT:    lbu a7, 0(a3)
; RV64I-NEXT:    lbu t0, 2(a3)
; RV64I-NEXT:    lbu t1, 3(a3)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 5(a3)
; RV64I-NEXT:    lbu t0, 4(a3)
; RV64I-NEXT:    lbu t1, 6(a3)
; RV64I-NEXT:    lbu t2, 7(a3)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli t2, t2, 24
; RV64I-NEXT:    or t0, t2, t1
; RV64I-NEXT:    or a7, t0, a7
; RV64I-NEXT:    slli a7, a7, 32
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 25(a3)
; RV64I-NEXT:    lbu t0, 24(a3)
; RV64I-NEXT:    lbu t1, 26(a3)
; RV64I-NEXT:    lbu t2, 27(a3)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli t2, t2, 24
; RV64I-NEXT:    or t0, t2, t1
; RV64I-NEXT:    or a7, t0, a7
; RV64I-NEXT:    lbu t0, 29(a3)
; RV64I-NEXT:    lbu t1, 28(a3)
; RV64I-NEXT:    lbu t2, 30(a3)
; RV64I-NEXT:    lbu a3, 31(a3)
; RV64I-NEXT:    slli t0, t0, 8
; RV64I-NEXT:    or t0, t0, t1
; RV64I-NEXT:    slli t2, t2, 16
; RV64I-NEXT:    slli a3, a3, 24
; RV64I-NEXT:    or a3, a3, t2
; RV64I-NEXT:    slli t1, a4, 1
; RV64I-NEXT:    or a3, a3, t0
; RV64I-NEXT:    xori t0, a1, 63
; RV64I-NEXT:    sll t1, t1, t0
; RV64I-NEXT:    slli a3, a3, 32
; RV64I-NEXT:    or a3, a3, a7
; RV64I-NEXT:    slli a7, a3, 1
; RV64I-NEXT:    sll a7, a7, t0
; RV64I-NEXT:    srl a4, a4, a1
; RV64I-NEXT:    srl a6, a6, a1
; RV64I-NEXT:    srl a5, a5, a1
; RV64I-NEXT:    srl a1, a3, a1
; RV64I-NEXT:    srli a3, a5, 48
; RV64I-NEXT:    sb a3, 22(a2)
; RV64I-NEXT:    srli a3, a5, 40
; RV64I-NEXT:    sb a3, 21(a2)
; RV64I-NEXT:    srli a3, a5, 32
; RV64I-NEXT:    sb a3, 20(a2)
; RV64I-NEXT:    srli a3, a5, 24
; RV64I-NEXT:    sb a3, 19(a2)
; RV64I-NEXT:    srli a3, a5, 16
; RV64I-NEXT:    sb a3, 18(a2)
; RV64I-NEXT:    or a3, a5, a7
; RV64I-NEXT:    sb a5, 16(a2)
; RV64I-NEXT:    srli a5, a5, 8
; RV64I-NEXT:    sb a5, 17(a2)
; RV64I-NEXT:    srli a5, a1, 56
; RV64I-NEXT:    sb a5, 31(a2)
; RV64I-NEXT:    srli a5, a1, 48
; RV64I-NEXT:    sb a5, 30(a2)
; RV64I-NEXT:    srli a5, a1, 40
; RV64I-NEXT:    sb a5, 29(a2)
; RV64I-NEXT:    srli a5, a1, 32
; RV64I-NEXT:    sb a5, 28(a2)
; RV64I-NEXT:    srli a5, a1, 24
; RV64I-NEXT:    sb a5, 27(a2)
; RV64I-NEXT:    srli a5, a1, 16
; RV64I-NEXT:    sb a5, 26(a2)
; RV64I-NEXT:    sb a1, 24(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 25(a2)
; RV64I-NEXT:    srli a1, a6, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a6, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a6, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a6, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a1, a6, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    or a1, a6, t1
; RV64I-NEXT:    sb a6, 0(a2)
; RV64I-NEXT:    srli a5, a6, 8
; RV64I-NEXT:    sb a5, 1(a2)
; RV64I-NEXT:    srli a5, a4, 48
; RV64I-NEXT:    sb a5, 14(a2)
; RV64I-NEXT:    srli a5, a4, 40
; RV64I-NEXT:    sb a5, 13(a2)
; RV64I-NEXT:    srli a5, a4, 32
; RV64I-NEXT:    sb a5, 12(a2)
; RV64I-NEXT:    srli a5, a4, 24
; RV64I-NEXT:    sb a5, 11(a2)
; RV64I-NEXT:    srli a5, a4, 16
; RV64I-NEXT:    sb a5, 10(a2)
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    sb a4, 8(a2)
; RV64I-NEXT:    srli a4, a4, 8
; RV64I-NEXT:    sb a4, 9(a2)
; RV64I-NEXT:    srli a3, a3, 56
; RV64I-NEXT:    sb a3, 23(a2)
; RV64I-NEXT:    srli a1, a1, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    sb a0, 15(a2)
; RV64I-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 224
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_32bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    sw a3, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    sw a3, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 2(a0)
; RV32I-NEXT:    sw a3, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 3(a0)
; RV32I-NEXT:    sw a3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    sw a3, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 12(a0)
; RV32I-NEXT:    lbu s1, 13(a0)
; RV32I-NEXT:    lbu s2, 14(a0)
; RV32I-NEXT:    lbu s3, 15(a0)
; RV32I-NEXT:    lbu s4, 16(a0)
; RV32I-NEXT:    lbu s5, 17(a0)
; RV32I-NEXT:    lbu s6, 18(a0)
; RV32I-NEXT:    lbu s7, 19(a0)
; RV32I-NEXT:    lbu s8, 1(a1)
; RV32I-NEXT:    lbu s9, 20(a0)
; RV32I-NEXT:    lbu s10, 21(a0)
; RV32I-NEXT:    lbu s11, 0(a1)
; RV32I-NEXT:    slli s8, s8, 8
; RV32I-NEXT:    lbu ra, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    or s8, s8, s11
; RV32I-NEXT:    lbu s11, 22(a0)
; RV32I-NEXT:    slli ra, ra, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, ra
; RV32I-NEXT:    lbu ra, 23(a0)
; RV32I-NEXT:    or t0, a1, s8
; RV32I-NEXT:    lbu s8, 24(a0)
; RV32I-NEXT:    lbu a7, 25(a0)
; RV32I-NEXT:    lbu a6, 26(a0)
; RV32I-NEXT:    lbu a5, 27(a0)
; RV32I-NEXT:    lbu a1, 31(a0)
; RV32I-NEXT:    lbu a3, 30(a0)
; RV32I-NEXT:    lbu a4, 29(a0)
; RV32I-NEXT:    lbu a0, 28(a0)
; RV32I-NEXT:    sb a1, 59(sp)
; RV32I-NEXT:    sb a3, 58(sp)
; RV32I-NEXT:    sb a4, 57(sp)
; RV32I-NEXT:    sb a0, 56(sp)
; RV32I-NEXT:    sb a5, 55(sp)
; RV32I-NEXT:    sb a6, 54(sp)
; RV32I-NEXT:    sb a7, 53(sp)
; RV32I-NEXT:    sb s8, 52(sp)
; RV32I-NEXT:    sb ra, 51(sp)
; RV32I-NEXT:    sb s11, 50(sp)
; RV32I-NEXT:    sb s10, 49(sp)
; RV32I-NEXT:    sb s9, 48(sp)
; RV32I-NEXT:    sb s7, 47(sp)
; RV32I-NEXT:    sb s6, 46(sp)
; RV32I-NEXT:    sb s5, 45(sp)
; RV32I-NEXT:    sb s4, 44(sp)
; RV32I-NEXT:    sb zero, 91(sp)
; RV32I-NEXT:    sb zero, 90(sp)
; RV32I-NEXT:    sb zero, 89(sp)
; RV32I-NEXT:    sb zero, 88(sp)
; RV32I-NEXT:    sb zero, 87(sp)
; RV32I-NEXT:    sb zero, 86(sp)
; RV32I-NEXT:    sb zero, 85(sp)
; RV32I-NEXT:    sb zero, 84(sp)
; RV32I-NEXT:    sb zero, 83(sp)
; RV32I-NEXT:    sb zero, 82(sp)
; RV32I-NEXT:    sb zero, 81(sp)
; RV32I-NEXT:    sb zero, 80(sp)
; RV32I-NEXT:    sb zero, 79(sp)
; RV32I-NEXT:    sb zero, 78(sp)
; RV32I-NEXT:    sb zero, 77(sp)
; RV32I-NEXT:    sb zero, 76(sp)
; RV32I-NEXT:    sb zero, 75(sp)
; RV32I-NEXT:    sb zero, 74(sp)
; RV32I-NEXT:    sb zero, 73(sp)
; RV32I-NEXT:    sb zero, 72(sp)
; RV32I-NEXT:    sb zero, 71(sp)
; RV32I-NEXT:    sb zero, 70(sp)
; RV32I-NEXT:    sb zero, 69(sp)
; RV32I-NEXT:    sb zero, 68(sp)
; RV32I-NEXT:    sb zero, 67(sp)
; RV32I-NEXT:    sb zero, 66(sp)
; RV32I-NEXT:    sb zero, 65(sp)
; RV32I-NEXT:    sb zero, 64(sp)
; RV32I-NEXT:    sb zero, 63(sp)
; RV32I-NEXT:    sb zero, 62(sp)
; RV32I-NEXT:    sb zero, 61(sp)
; RV32I-NEXT:    sb zero, 60(sp)
; RV32I-NEXT:    sb s3, 43(sp)
; RV32I-NEXT:    sb s2, 42(sp)
; RV32I-NEXT:    sb s1, 41(sp)
; RV32I-NEXT:    sb s0, 40(sp)
; RV32I-NEXT:    sb t6, 39(sp)
; RV32I-NEXT:    sb t5, 38(sp)
; RV32I-NEXT:    sb t4, 37(sp)
; RV32I-NEXT:    sb t3, 36(sp)
; RV32I-NEXT:    sb t2, 35(sp)
; RV32I-NEXT:    sb t1, 34(sp)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 33(sp)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 32(sp)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 31(sp)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 30(sp)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 29(sp)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 28(sp)
; RV32I-NEXT:    slli a0, t0, 24
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    addi a4, sp, 28
; RV32I-NEXT:    add a4, a4, a0
; RV32I-NEXT:    lbu a0, 5(a4)
; RV32I-NEXT:    lbu a1, 4(a4)
; RV32I-NEXT:    lbu a3, 6(a4)
; RV32I-NEXT:    lbu a5, 7(a4)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a3, a3, 16
; RV32I-NEXT:    slli a5, a5, 24
; RV32I-NEXT:    or a3, a5, a3
; RV32I-NEXT:    or t4, a3, a0
; RV32I-NEXT:    andi a3, t0, 7
; RV32I-NEXT:    lbu a0, 9(a4)
; RV32I-NEXT:    lbu a1, 8(a4)
; RV32I-NEXT:    lbu a5, 10(a4)
; RV32I-NEXT:    lbu a6, 11(a4)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a1, a6, a5
; RV32I-NEXT:    or a6, a1, a0
; RV32I-NEXT:    slli a0, a6, 1
; RV32I-NEXT:    not t0, a3
; RV32I-NEXT:    sll a0, a0, t0
; RV32I-NEXT:    lbu a1, 1(a4)
; RV32I-NEXT:    lbu a5, 0(a4)
; RV32I-NEXT:    lbu a7, 2(a4)
; RV32I-NEXT:    lbu t1, 3(a4)
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli t1, t1, 24
; RV32I-NEXT:    or a5, t1, a7
; RV32I-NEXT:    or t1, a5, a1
; RV32I-NEXT:    slli a1, t4, 1
; RV32I-NEXT:    xori t2, a3, 31
; RV32I-NEXT:    sll a1, a1, t2
; RV32I-NEXT:    lbu a5, 13(a4)
; RV32I-NEXT:    lbu a7, 12(a4)
; RV32I-NEXT:    lbu t3, 14(a4)
; RV32I-NEXT:    lbu t5, 15(a4)
; RV32I-NEXT:    slli a5, a5, 8
; RV32I-NEXT:    or a5, a5, a7
; RV32I-NEXT:    slli t3, t3, 16
; RV32I-NEXT:    slli t5, t5, 24
; RV32I-NEXT:    or a7, t5, t3
; RV32I-NEXT:    or t3, a7, a5
; RV32I-NEXT:    lbu a5, 17(a4)
; RV32I-NEXT:    lbu a7, 16(a4)
; RV32I-NEXT:    lbu t5, 18(a4)
; RV32I-NEXT:    lbu t6, 19(a4)
; RV32I-NEXT:    slli a5, a5, 8
; RV32I-NEXT:    or a5, a5, a7
; RV32I-NEXT:    slli t5, t5, 16
; RV32I-NEXT:    slli t6, t6, 24
; RV32I-NEXT:    or a7, t6, t5
; RV32I-NEXT:    or a5, a7, a5
; RV32I-NEXT:    slli a7, a5, 1
; RV32I-NEXT:    sll a7, a7, t0
; RV32I-NEXT:    lbu t5, 21(a4)
; RV32I-NEXT:    lbu t6, 20(a4)
; RV32I-NEXT:    lbu s0, 22(a4)
; RV32I-NEXT:    lbu s1, 23(a4)
; RV32I-NEXT:    slli t5, t5, 8
; RV32I-NEXT:    or t5, t5, t6
; RV32I-NEXT:    slli s0, s0, 16
; RV32I-NEXT:    slli s1, s1, 24
; RV32I-NEXT:    or s0, s1, s0
; RV32I-NEXT:    or t5, s0, t5
; RV32I-NEXT:    lbu t6, 25(a4)
; RV32I-NEXT:    lbu s0, 24(a4)
; RV32I-NEXT:    lbu s1, 26(a4)
; RV32I-NEXT:    lbu s2, 27(a4)
; RV32I-NEXT:    slli t6, t6, 8
; RV32I-NEXT:    or t6, t6, s0
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli s2, s2, 24
; RV32I-NEXT:    or s0, s2, s1
; RV32I-NEXT:    or t6, s0, t6
; RV32I-NEXT:    lbu s0, 29(a4)
; RV32I-NEXT:    lbu s1, 28(a4)
; RV32I-NEXT:    slli s2, t6, 1
; RV32I-NEXT:    sll t0, s2, t0
; RV32I-NEXT:    slli s0, s0, 8
; RV32I-NEXT:    or s0, s0, s1
; RV32I-NEXT:    lbu s1, 30(a4)
; RV32I-NEXT:    lbu a4, 31(a4)
; RV32I-NEXT:    slli s2, t3, 1
; RV32I-NEXT:    sll s2, s2, t2
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli a4, a4, 24
; RV32I-NEXT:    or a4, a4, s1
; RV32I-NEXT:    slli s1, t5, 1
; RV32I-NEXT:    sll s1, s1, t2
; RV32I-NEXT:    or a4, a4, s0
; RV32I-NEXT:    slli s0, a4, 1
; RV32I-NEXT:    sll t2, s0, t2
; RV32I-NEXT:    srl t4, t4, a3
; RV32I-NEXT:    srl t1, t1, a3
; RV32I-NEXT:    srl t3, t3, a3
; RV32I-NEXT:    srl a6, a6, a3
; RV32I-NEXT:    srl t5, t5, a3
; RV32I-NEXT:    srl a5, a5, a3
; RV32I-NEXT:    srl t6, t6, a3
; RV32I-NEXT:    srl a3, a4, a3
; RV32I-NEXT:    srli a4, t6, 16
; RV32I-NEXT:    sb a4, 26(a2)
; RV32I-NEXT:    or a4, t6, t2
; RV32I-NEXT:    sb t6, 24(a2)
; RV32I-NEXT:    srli t2, t6, 8
; RV32I-NEXT:    sb t2, 25(a2)
; RV32I-NEXT:    srli t2, a3, 24
; RV32I-NEXT:    sb t2, 31(a2)
; RV32I-NEXT:    srli t2, a3, 16
; RV32I-NEXT:    sb t2, 30(a2)
; RV32I-NEXT:    sb a3, 28(a2)
; RV32I-NEXT:    srli a3, a3, 8
; RV32I-NEXT:    sb a3, 29(a2)
; RV32I-NEXT:    srli a3, a5, 16
; RV32I-NEXT:    sb a3, 18(a2)
; RV32I-NEXT:    or s1, a5, s1
; RV32I-NEXT:    sb a5, 16(a2)
; RV32I-NEXT:    srli a5, a5, 8
; RV32I-NEXT:    sb a5, 17(a2)
; RV32I-NEXT:    srli a3, t5, 16
; RV32I-NEXT:    sb a3, 22(a2)
; RV32I-NEXT:    or a3, t5, t0
; RV32I-NEXT:    sb t5, 20(a2)
; RV32I-NEXT:    srli a5, t5, 8
; RV32I-NEXT:    sb a5, 21(a2)
; RV32I-NEXT:    srli a5, a6, 16
; RV32I-NEXT:    sb a5, 10(a2)
; RV32I-NEXT:    or a5, a6, s2
; RV32I-NEXT:    sb a6, 8(a2)
; RV32I-NEXT:    srli a6, a6, 8
; RV32I-NEXT:    sb a6, 9(a2)
; RV32I-NEXT:    srli a6, t3, 16
; RV32I-NEXT:    sb a6, 14(a2)
; RV32I-NEXT:    or a6, t3, a7
; RV32I-NEXT:    sb t3, 12(a2)
; RV32I-NEXT:    srli a7, t3, 8
; RV32I-NEXT:    sb a7, 13(a2)
; RV32I-NEXT:    srli a7, t1, 16
; RV32I-NEXT:    sb a7, 2(a2)
; RV32I-NEXT:    or a1, t1, a1
; RV32I-NEXT:    sb t1, 0(a2)
; RV32I-NEXT:    srli a7, t1, 8
; RV32I-NEXT:    sb a7, 1(a2)
; RV32I-NEXT:    srli a7, t4, 16
; RV32I-NEXT:    sb a7, 6(a2)
; RV32I-NEXT:    or a0, t4, a0
; RV32I-NEXT:    sb t4, 4(a2)
; RV32I-NEXT:    srli a7, t4, 8
; RV32I-NEXT:    sb a7, 5(a2)
; RV32I-NEXT:    srli a4, a4, 24
; RV32I-NEXT:    sb a4, 27(a2)
; RV32I-NEXT:    srli s1, s1, 24
; RV32I-NEXT:    sb s1, 19(a2)
; RV32I-NEXT:    srli a3, a3, 24
; RV32I-NEXT:    sb a3, 23(a2)
; RV32I-NEXT:    srli a5, a5, 24
; RV32I-NEXT:    sb a5, 11(a2)
; RV32I-NEXT:    srli a3, a6, 24
; RV32I-NEXT:    sb a3, 15(a2)
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    sb a0, 7(a2)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
  %src = load i256, ptr %src.ptr, align 1
  %bitOff = load i256, ptr %bitOff.ptr, align 1
  %res = lshr i256 %src, %bitOff
  store i256 %res, ptr %dst, align 1
  ret void
}
define void @shl_32bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_32bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -224
; RV64I-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    sd a3, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    sd a3, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 2(a0)
; RV64I-NEXT:    sd a3, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 3(a0)
; RV64I-NEXT:    sd a3, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 4(a0)
; RV64I-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 5(a0)
; RV64I-NEXT:    sd a3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t1, 6(a0)
; RV64I-NEXT:    lbu t2, 7(a0)
; RV64I-NEXT:    lbu t3, 8(a0)
; RV64I-NEXT:    lbu t4, 9(a0)
; RV64I-NEXT:    lbu t5, 10(a0)
; RV64I-NEXT:    lbu t6, 11(a0)
; RV64I-NEXT:    lbu s0, 12(a0)
; RV64I-NEXT:    lbu s1, 13(a0)
; RV64I-NEXT:    lbu s2, 14(a0)
; RV64I-NEXT:    lbu s3, 15(a0)
; RV64I-NEXT:    lbu s4, 16(a0)
; RV64I-NEXT:    lbu s5, 17(a0)
; RV64I-NEXT:    lbu s6, 18(a0)
; RV64I-NEXT:    lbu s7, 19(a0)
; RV64I-NEXT:    lbu s8, 20(a0)
; RV64I-NEXT:    lbu s9, 1(a1)
; RV64I-NEXT:    lbu s10, 0(a1)
; RV64I-NEXT:    lbu s11, 2(a1)
; RV64I-NEXT:    lbu ra, 3(a1)
; RV64I-NEXT:    slli s9, s9, 8
; RV64I-NEXT:    or s9, s9, s10
; RV64I-NEXT:    slli s11, s11, 16
; RV64I-NEXT:    slli ra, ra, 24
; RV64I-NEXT:    lbu s10, 5(a1)
; RV64I-NEXT:    or s11, ra, s11
; RV64I-NEXT:    or s9, s11, s9
; RV64I-NEXT:    lbu s11, 4(a1)
; RV64I-NEXT:    slli s10, s10, 8
; RV64I-NEXT:    lbu ra, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    or s10, s10, s11
; RV64I-NEXT:    lbu s11, 21(a0)
; RV64I-NEXT:    slli ra, ra, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, ra
; RV64I-NEXT:    lbu ra, 22(a0)
; RV64I-NEXT:    or a1, a1, s10
; RV64I-NEXT:    lbu s10, 23(a0)
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or t0, a1, s9
; RV64I-NEXT:    lbu s9, 24(a0)
; RV64I-NEXT:    lbu a7, 25(a0)
; RV64I-NEXT:    lbu a6, 26(a0)
; RV64I-NEXT:    lbu a5, 27(a0)
; RV64I-NEXT:    lbu a1, 31(a0)
; RV64I-NEXT:    lbu a3, 30(a0)
; RV64I-NEXT:    lbu a4, 29(a0)
; RV64I-NEXT:    lbu a0, 28(a0)
; RV64I-NEXT:    sb a1, 119(sp)
; RV64I-NEXT:    sb a3, 118(sp)
; RV64I-NEXT:    sb a4, 117(sp)
; RV64I-NEXT:    sb a0, 116(sp)
; RV64I-NEXT:    sb a5, 115(sp)
; RV64I-NEXT:    sb a6, 114(sp)
; RV64I-NEXT:    sb a7, 113(sp)
; RV64I-NEXT:    sb s9, 112(sp)
; RV64I-NEXT:    sb s10, 111(sp)
; RV64I-NEXT:    sb ra, 110(sp)
; RV64I-NEXT:    sb s11, 109(sp)
; RV64I-NEXT:    sb s8, 108(sp)
; RV64I-NEXT:    sb s7, 107(sp)
; RV64I-NEXT:    sb s6, 106(sp)
; RV64I-NEXT:    sb s5, 105(sp)
; RV64I-NEXT:    sb s4, 104(sp)
; RV64I-NEXT:    sb s3, 103(sp)
; RV64I-NEXT:    sb s2, 102(sp)
; RV64I-NEXT:    sb s1, 101(sp)
; RV64I-NEXT:    sb s0, 100(sp)
; RV64I-NEXT:    sb t6, 99(sp)
; RV64I-NEXT:    sb t5, 98(sp)
; RV64I-NEXT:    sb t4, 97(sp)
; RV64I-NEXT:    sb t3, 96(sp)
; RV64I-NEXT:    sb zero, 87(sp)
; RV64I-NEXT:    sb zero, 86(sp)
; RV64I-NEXT:    sb zero, 85(sp)
; RV64I-NEXT:    sb zero, 84(sp)
; RV64I-NEXT:    sb zero, 83(sp)
; RV64I-NEXT:    sb zero, 82(sp)
; RV64I-NEXT:    sb zero, 81(sp)
; RV64I-NEXT:    sb zero, 80(sp)
; RV64I-NEXT:    sb zero, 79(sp)
; RV64I-NEXT:    sb zero, 78(sp)
; RV64I-NEXT:    sb zero, 77(sp)
; RV64I-NEXT:    sb zero, 76(sp)
; RV64I-NEXT:    sb zero, 75(sp)
; RV64I-NEXT:    sb zero, 74(sp)
; RV64I-NEXT:    sb zero, 73(sp)
; RV64I-NEXT:    sb zero, 72(sp)
; RV64I-NEXT:    sb zero, 71(sp)
; RV64I-NEXT:    sb zero, 70(sp)
; RV64I-NEXT:    sb zero, 69(sp)
; RV64I-NEXT:    sb zero, 68(sp)
; RV64I-NEXT:    sb zero, 67(sp)
; RV64I-NEXT:    sb zero, 66(sp)
; RV64I-NEXT:    sb zero, 65(sp)
; RV64I-NEXT:    sb zero, 64(sp)
; RV64I-NEXT:    sb zero, 63(sp)
; RV64I-NEXT:    sb zero, 62(sp)
; RV64I-NEXT:    sb zero, 61(sp)
; RV64I-NEXT:    sb zero, 60(sp)
; RV64I-NEXT:    sb zero, 59(sp)
; RV64I-NEXT:    sb zero, 58(sp)
; RV64I-NEXT:    sb zero, 57(sp)
; RV64I-NEXT:    sb zero, 56(sp)
; RV64I-NEXT:    sb t2, 95(sp)
; RV64I-NEXT:    sb t1, 94(sp)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 93(sp)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 92(sp)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 91(sp)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 90(sp)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 89(sp)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 88(sp)
; RV64I-NEXT:    slli a0, t0, 56
; RV64I-NEXT:    srli a0, a0, 59
; RV64I-NEXT:    addi a1, sp, 88
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    lbu a1, 9(a0)
; RV64I-NEXT:    lbu a3, 8(a0)
; RV64I-NEXT:    lbu a4, 10(a0)
; RV64I-NEXT:    lbu a5, 11(a0)
; RV64I-NEXT:    slli a1, a1, 8
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    slli a4, a4, 16
; RV64I-NEXT:    slli a5, a5, 24
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    or a1, a4, a1
; RV64I-NEXT:    lbu a3, 13(a0)
; RV64I-NEXT:    lbu a4, 12(a0)
; RV64I-NEXT:    lbu a5, 14(a0)
; RV64I-NEXT:    lbu a6, 15(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    slli a3, a3, 32
; RV64I-NEXT:    or a3, a3, a1
; RV64I-NEXT:    andi a1, t0, 7
; RV64I-NEXT:    lbu a4, 1(a0)
; RV64I-NEXT:    lbu a5, 0(a0)
; RV64I-NEXT:    lbu a6, 2(a0)
; RV64I-NEXT:    lbu a7, 3(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    lbu a5, 5(a0)
; RV64I-NEXT:    lbu a6, 4(a0)
; RV64I-NEXT:    lbu a7, 6(a0)
; RV64I-NEXT:    lbu t0, 7(a0)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    slli a5, a5, 32
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    lbu a5, 25(a0)
; RV64I-NEXT:    lbu a6, 24(a0)
; RV64I-NEXT:    lbu a7, 26(a0)
; RV64I-NEXT:    lbu t0, 27(a0)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    lbu a6, 29(a0)
; RV64I-NEXT:    lbu a7, 28(a0)
; RV64I-NEXT:    lbu t0, 30(a0)
; RV64I-NEXT:    lbu t1, 31(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    slli a6, a6, 32
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    lbu a6, 17(a0)
; RV64I-NEXT:    lbu a7, 16(a0)
; RV64I-NEXT:    lbu t0, 18(a0)
; RV64I-NEXT:    lbu t1, 19(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    lbu a7, 21(a0)
; RV64I-NEXT:    or t0, t1, t0
; RV64I-NEXT:    or a6, t0, a6
; RV64I-NEXT:    lbu t0, 20(a0)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    lbu t1, 22(a0)
; RV64I-NEXT:    lbu a0, 23(a0)
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    srli t0, a4, 1
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or t1, a0, t1
; RV64I-NEXT:    xori t2, a1, 63
; RV64I-NEXT:    srl a0, t0, t2
; RV64I-NEXT:    or a7, t1, a7
; RV64I-NEXT:    slli a7, a7, 32
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    srli a7, a6, 1
; RV64I-NEXT:    srl a7, a7, t2
; RV64I-NEXT:    srli t0, a3, 1
; RV64I-NEXT:    not t1, a1
; RV64I-NEXT:    srl t0, t0, t1
; RV64I-NEXT:    sll a3, a3, a1
; RV64I-NEXT:    sll a5, a5, a1
; RV64I-NEXT:    sll a6, a6, a1
; RV64I-NEXT:    sll a1, a4, a1
; RV64I-NEXT:    srli a4, a6, 56
; RV64I-NEXT:    sb a4, 23(a2)
; RV64I-NEXT:    srli a4, a6, 48
; RV64I-NEXT:    sb a4, 22(a2)
; RV64I-NEXT:    srli a4, a6, 40
; RV64I-NEXT:    sb a4, 21(a2)
; RV64I-NEXT:    srli a4, a6, 32
; RV64I-NEXT:    sb a4, 20(a2)
; RV64I-NEXT:    srli a4, a6, 24
; RV64I-NEXT:    sb a4, 19(a2)
; RV64I-NEXT:    srli a4, a6, 16
; RV64I-NEXT:    sb a4, 18(a2)
; RV64I-NEXT:    or a4, a6, t0
; RV64I-NEXT:    srli a6, a6, 8
; RV64I-NEXT:    sb a6, 17(a2)
; RV64I-NEXT:    srli a6, a5, 56
; RV64I-NEXT:    sb a6, 31(a2)
; RV64I-NEXT:    srli a6, a5, 48
; RV64I-NEXT:    sb a6, 30(a2)
; RV64I-NEXT:    srli a6, a5, 40
; RV64I-NEXT:    sb a6, 29(a2)
; RV64I-NEXT:    srli a6, a5, 32
; RV64I-NEXT:    sb a6, 28(a2)
; RV64I-NEXT:    srli a6, a5, 24
; RV64I-NEXT:    sb a6, 27(a2)
; RV64I-NEXT:    srli a6, a5, 16
; RV64I-NEXT:    sb a6, 26(a2)
; RV64I-NEXT:    or a6, a5, a7
; RV64I-NEXT:    srli a5, a5, 8
; RV64I-NEXT:    sb a5, 25(a2)
; RV64I-NEXT:    srli a5, a1, 56
; RV64I-NEXT:    sb a5, 7(a2)
; RV64I-NEXT:    srli a5, a1, 48
; RV64I-NEXT:    sb a5, 6(a2)
; RV64I-NEXT:    srli a5, a1, 40
; RV64I-NEXT:    sb a5, 5(a2)
; RV64I-NEXT:    srli a5, a1, 32
; RV64I-NEXT:    sb a5, 4(a2)
; RV64I-NEXT:    srli a5, a1, 24
; RV64I-NEXT:    sb a5, 3(a2)
; RV64I-NEXT:    srli a5, a1, 16
; RV64I-NEXT:    sb a5, 2(a2)
; RV64I-NEXT:    sb a1, 0(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 1(a2)
; RV64I-NEXT:    srli a1, a3, 56
; RV64I-NEXT:    sb a1, 15(a2)
; RV64I-NEXT:    srli a1, a3, 48
; RV64I-NEXT:    sb a1, 14(a2)
; RV64I-NEXT:    srli a1, a3, 40
; RV64I-NEXT:    sb a1, 13(a2)
; RV64I-NEXT:    srli a1, a3, 32
; RV64I-NEXT:    sb a1, 12(a2)
; RV64I-NEXT:    srli a1, a3, 24
; RV64I-NEXT:    sb a1, 11(a2)
; RV64I-NEXT:    srli a1, a3, 16
; RV64I-NEXT:    sb a1, 10(a2)
; RV64I-NEXT:    or a0, a3, a0
; RV64I-NEXT:    srli a3, a3, 8
; RV64I-NEXT:    sb a3, 9(a2)
; RV64I-NEXT:    sb a4, 16(a2)
; RV64I-NEXT:    sb a6, 24(a2)
; RV64I-NEXT:    sb a0, 8(a2)
; RV64I-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 224
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_32bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    sw a3, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    sw a3, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 2(a0)
; RV32I-NEXT:    sw a3, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 3(a0)
; RV32I-NEXT:    sw a3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    sw a3, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 12(a0)
; RV32I-NEXT:    lbu s1, 13(a0)
; RV32I-NEXT:    lbu s2, 14(a0)
; RV32I-NEXT:    lbu s3, 15(a0)
; RV32I-NEXT:    lbu s4, 16(a0)
; RV32I-NEXT:    lbu s5, 17(a0)
; RV32I-NEXT:    lbu s6, 18(a0)
; RV32I-NEXT:    lbu s7, 19(a0)
; RV32I-NEXT:    lbu s8, 1(a1)
; RV32I-NEXT:    lbu s9, 20(a0)
; RV32I-NEXT:    lbu s10, 21(a0)
; RV32I-NEXT:    lbu s11, 0(a1)
; RV32I-NEXT:    slli s8, s8, 8
; RV32I-NEXT:    lbu ra, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    or s8, s8, s11
; RV32I-NEXT:    lbu s11, 22(a0)
; RV32I-NEXT:    slli ra, ra, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, ra
; RV32I-NEXT:    lbu ra, 23(a0)
; RV32I-NEXT:    or t0, a1, s8
; RV32I-NEXT:    lbu s8, 24(a0)
; RV32I-NEXT:    lbu a7, 25(a0)
; RV32I-NEXT:    lbu a6, 26(a0)
; RV32I-NEXT:    lbu a5, 27(a0)
; RV32I-NEXT:    lbu a1, 31(a0)
; RV32I-NEXT:    lbu a3, 30(a0)
; RV32I-NEXT:    lbu a4, 29(a0)
; RV32I-NEXT:    lbu a0, 28(a0)
; RV32I-NEXT:    sb a1, 91(sp)
; RV32I-NEXT:    sb a3, 90(sp)
; RV32I-NEXT:    sb a4, 89(sp)
; RV32I-NEXT:    sb a0, 88(sp)
; RV32I-NEXT:    sb a5, 87(sp)
; RV32I-NEXT:    sb a6, 86(sp)
; RV32I-NEXT:    sb a7, 85(sp)
; RV32I-NEXT:    sb s8, 84(sp)
; RV32I-NEXT:    sb ra, 83(sp)
; RV32I-NEXT:    sb s11, 82(sp)
; RV32I-NEXT:    sb s10, 81(sp)
; RV32I-NEXT:    sb s9, 80(sp)
; RV32I-NEXT:    sb s7, 79(sp)
; RV32I-NEXT:    sb s6, 78(sp)
; RV32I-NEXT:    sb s5, 77(sp)
; RV32I-NEXT:    sb s4, 76(sp)
; RV32I-NEXT:    sb zero, 59(sp)
; RV32I-NEXT:    sb zero, 58(sp)
; RV32I-NEXT:    sb zero, 57(sp)
; RV32I-NEXT:    sb zero, 56(sp)
; RV32I-NEXT:    sb zero, 55(sp)
; RV32I-NEXT:    sb zero, 54(sp)
; RV32I-NEXT:    sb zero, 53(sp)
; RV32I-NEXT:    sb zero, 52(sp)
; RV32I-NEXT:    sb zero, 51(sp)
; RV32I-NEXT:    sb zero, 50(sp)
; RV32I-NEXT:    sb zero, 49(sp)
; RV32I-NEXT:    sb zero, 48(sp)
; RV32I-NEXT:    sb zero, 47(sp)
; RV32I-NEXT:    sb zero, 46(sp)
; RV32I-NEXT:    sb zero, 45(sp)
; RV32I-NEXT:    sb zero, 44(sp)
; RV32I-NEXT:    sb zero, 43(sp)
; RV32I-NEXT:    sb zero, 42(sp)
; RV32I-NEXT:    sb zero, 41(sp)
; RV32I-NEXT:    sb zero, 40(sp)
; RV32I-NEXT:    sb zero, 39(sp)
; RV32I-NEXT:    sb zero, 38(sp)
; RV32I-NEXT:    sb zero, 37(sp)
; RV32I-NEXT:    sb zero, 36(sp)
; RV32I-NEXT:    sb zero, 35(sp)
; RV32I-NEXT:    sb zero, 34(sp)
; RV32I-NEXT:    sb zero, 33(sp)
; RV32I-NEXT:    sb zero, 32(sp)
; RV32I-NEXT:    sb zero, 31(sp)
; RV32I-NEXT:    sb zero, 30(sp)
; RV32I-NEXT:    sb zero, 29(sp)
; RV32I-NEXT:    sb zero, 28(sp)
; RV32I-NEXT:    sb s3, 75(sp)
; RV32I-NEXT:    sb s2, 74(sp)
; RV32I-NEXT:    sb s1, 73(sp)
; RV32I-NEXT:    sb s0, 72(sp)
; RV32I-NEXT:    sb t6, 71(sp)
; RV32I-NEXT:    sb t5, 70(sp)
; RV32I-NEXT:    sb t4, 69(sp)
; RV32I-NEXT:    sb t3, 68(sp)
; RV32I-NEXT:    sb t2, 67(sp)
; RV32I-NEXT:    sb t1, 66(sp)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 65(sp)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 64(sp)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 63(sp)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 62(sp)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 61(sp)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 60(sp)
; RV32I-NEXT:    slli a0, t0, 24
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    addi a5, sp, 60
; RV32I-NEXT:    sub a5, a5, a0
; RV32I-NEXT:    lbu a0, 5(a5)
; RV32I-NEXT:    lbu a1, 4(a5)
; RV32I-NEXT:    lbu a3, 6(a5)
; RV32I-NEXT:    lbu a4, 7(a5)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a3, a3, 16
; RV32I-NEXT:    slli a4, a4, 24
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    or t3, a3, a0
; RV32I-NEXT:    andi a1, t0, 7
; RV32I-NEXT:    lbu a0, 1(a5)
; RV32I-NEXT:    lbu a3, 0(a5)
; RV32I-NEXT:    lbu a4, 2(a5)
; RV32I-NEXT:    lbu a6, 3(a5)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a4, a4, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a3, a6, a4
; RV32I-NEXT:    or a6, a3, a0
; RV32I-NEXT:    srli a0, a6, 1
; RV32I-NEXT:    xori a7, a1, 31
; RV32I-NEXT:    srl a0, a0, a7
; RV32I-NEXT:    lbu a3, 13(a5)
; RV32I-NEXT:    lbu a4, 12(a5)
; RV32I-NEXT:    lbu t0, 14(a5)
; RV32I-NEXT:    lbu t1, 15(a5)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli t0, t0, 16
; RV32I-NEXT:    slli t1, t1, 24
; RV32I-NEXT:    or a4, t1, t0
; RV32I-NEXT:    or t0, a4, a3
; RV32I-NEXT:    lbu a3, 9(a5)
; RV32I-NEXT:    lbu a4, 8(a5)
; RV32I-NEXT:    lbu t1, 10(a5)
; RV32I-NEXT:    lbu t2, 11(a5)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli t1, t1, 16
; RV32I-NEXT:    slli t2, t2, 24
; RV32I-NEXT:    or a4, t2, t1
; RV32I-NEXT:    or t1, a4, a3
; RV32I-NEXT:    srli a3, t1, 1
; RV32I-NEXT:    srl a3, a3, a7
; RV32I-NEXT:    srli a4, t3, 1
; RV32I-NEXT:    not t2, a1
; RV32I-NEXT:    lbu t4, 21(a5)
; RV32I-NEXT:    lbu t5, 20(a5)
; RV32I-NEXT:    lbu t6, 22(a5)
; RV32I-NEXT:    lbu s0, 23(a5)
; RV32I-NEXT:    slli t4, t4, 8
; RV32I-NEXT:    or t4, t4, t5
; RV32I-NEXT:    slli t6, t6, 16
; RV32I-NEXT:    slli s0, s0, 24
; RV32I-NEXT:    or t5, s0, t6
; RV32I-NEXT:    or t4, t5, t4
; RV32I-NEXT:    lbu t5, 17(a5)
; RV32I-NEXT:    lbu t6, 16(a5)
; RV32I-NEXT:    lbu s0, 18(a5)
; RV32I-NEXT:    lbu s1, 19(a5)
; RV32I-NEXT:    slli t5, t5, 8
; RV32I-NEXT:    or t5, t5, t6
; RV32I-NEXT:    slli s0, s0, 16
; RV32I-NEXT:    slli s1, s1, 24
; RV32I-NEXT:    or s0, s1, s0
; RV32I-NEXT:    or t5, s0, t5
; RV32I-NEXT:    lbu t6, 29(a5)
; RV32I-NEXT:    lbu s0, 28(a5)
; RV32I-NEXT:    lbu s1, 30(a5)
; RV32I-NEXT:    lbu s2, 31(a5)
; RV32I-NEXT:    slli t6, t6, 8
; RV32I-NEXT:    or t6, t6, s0
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli s2, s2, 24
; RV32I-NEXT:    or s0, s2, s1
; RV32I-NEXT:    lbu s1, 25(a5)
; RV32I-NEXT:    lbu s2, 24(a5)
; RV32I-NEXT:    srl a4, a4, t2
; RV32I-NEXT:    or t6, s0, t6
; RV32I-NEXT:    slli s1, s1, 8
; RV32I-NEXT:    or s0, s1, s2
; RV32I-NEXT:    lbu s1, 26(a5)
; RV32I-NEXT:    lbu a5, 27(a5)
; RV32I-NEXT:    srli s2, t5, 1
; RV32I-NEXT:    srl s2, s2, a7
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli a5, a5, 24
; RV32I-NEXT:    or a5, a5, s1
; RV32I-NEXT:    srli s1, t0, 1
; RV32I-NEXT:    srl s1, s1, t2
; RV32I-NEXT:    or a5, a5, s0
; RV32I-NEXT:    srli s0, a5, 1
; RV32I-NEXT:    srl a7, s0, a7
; RV32I-NEXT:    srli s0, t4, 1
; RV32I-NEXT:    srl t2, s0, t2
; RV32I-NEXT:    sll t3, t3, a1
; RV32I-NEXT:    sll t0, t0, a1
; RV32I-NEXT:    sll t1, t1, a1
; RV32I-NEXT:    sll t4, t4, a1
; RV32I-NEXT:    sll t5, t5, a1
; RV32I-NEXT:    sll t6, t6, a1
; RV32I-NEXT:    sll a5, a5, a1
; RV32I-NEXT:    sll a1, a6, a1
; RV32I-NEXT:    srli a6, a5, 24
; RV32I-NEXT:    sb a6, 27(a2)
; RV32I-NEXT:    srli a6, a5, 16
; RV32I-NEXT:    sb a6, 26(a2)
; RV32I-NEXT:    or a6, a5, t2
; RV32I-NEXT:    srli a5, a5, 8
; RV32I-NEXT:    sb a5, 25(a2)
; RV32I-NEXT:    srli a5, t6, 24
; RV32I-NEXT:    sb a5, 31(a2)
; RV32I-NEXT:    srli a5, t6, 16
; RV32I-NEXT:    sb a5, 30(a2)
; RV32I-NEXT:    or a5, t6, a7
; RV32I-NEXT:    srli a7, t6, 8
; RV32I-NEXT:    sb a7, 29(a2)
; RV32I-NEXT:    srli a7, t5, 24
; RV32I-NEXT:    sb a7, 19(a2)
; RV32I-NEXT:    srli a7, t5, 16
; RV32I-NEXT:    sb a7, 18(a2)
; RV32I-NEXT:    or a7, t5, s1
; RV32I-NEXT:    srli t2, t5, 8
; RV32I-NEXT:    sb t2, 17(a2)
; RV32I-NEXT:    srli t2, t4, 24
; RV32I-NEXT:    sb t2, 23(a2)
; RV32I-NEXT:    srli t2, t4, 16
; RV32I-NEXT:    sb t2, 22(a2)
; RV32I-NEXT:    or t2, t4, s2
; RV32I-NEXT:    srli t4, t4, 8
; RV32I-NEXT:    sb t4, 21(a2)
; RV32I-NEXT:    srli t4, t1, 24
; RV32I-NEXT:    sb t4, 11(a2)
; RV32I-NEXT:    srli t4, t1, 16
; RV32I-NEXT:    sb t4, 10(a2)
; RV32I-NEXT:    or a4, t1, a4
; RV32I-NEXT:    srli t1, t1, 8
; RV32I-NEXT:    sb t1, 9(a2)
; RV32I-NEXT:    srli t1, t0, 24
; RV32I-NEXT:    sb t1, 15(a2)
; RV32I-NEXT:    srli t1, t0, 16
; RV32I-NEXT:    sb t1, 14(a2)
; RV32I-NEXT:    or a3, t0, a3
; RV32I-NEXT:    srli t0, t0, 8
; RV32I-NEXT:    sb t0, 13(a2)
; RV32I-NEXT:    srli t0, a1, 24
; RV32I-NEXT:    sb t0, 3(a2)
; RV32I-NEXT:    srli t0, a1, 16
; RV32I-NEXT:    sb t0, 2(a2)
; RV32I-NEXT:    sb a1, 0(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 1(a2)
; RV32I-NEXT:    srli a1, t3, 24
; RV32I-NEXT:    sb a1, 7(a2)
; RV32I-NEXT:    srli a1, t3, 16
; RV32I-NEXT:    sb a1, 6(a2)
; RV32I-NEXT:    or a0, t3, a0
; RV32I-NEXT:    srli a1, t3, 8
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    sb a6, 24(a2)
; RV32I-NEXT:    sb a5, 28(a2)
; RV32I-NEXT:    sb a7, 16(a2)
; RV32I-NEXT:    sb t2, 20(a2)
; RV32I-NEXT:    sb a4, 8(a2)
; RV32I-NEXT:    sb a3, 12(a2)
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
  %src = load i256, ptr %src.ptr, align 1
  %bitOff = load i256, ptr %bitOff.ptr, align 1
  %res = shl i256 %src, %bitOff
  store i256 %res, ptr %dst, align 1
  ret void
}
define void @ashr_32bytes(ptr %src.ptr, ptr %bitOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_32bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -224
; RV64I-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t0, 31(a0)
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    sd a3, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    sd a3, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 2(a0)
; RV64I-NEXT:    sd a3, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 3(a0)
; RV64I-NEXT:    sd a3, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 4(a0)
; RV64I-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 5(a0)
; RV64I-NEXT:    sd a3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t2, 6(a0)
; RV64I-NEXT:    lbu t3, 7(a0)
; RV64I-NEXT:    lbu t4, 8(a0)
; RV64I-NEXT:    lbu t5, 9(a0)
; RV64I-NEXT:    lbu t6, 10(a0)
; RV64I-NEXT:    lbu s0, 11(a0)
; RV64I-NEXT:    lbu s1, 12(a0)
; RV64I-NEXT:    lbu s2, 13(a0)
; RV64I-NEXT:    lbu s3, 14(a0)
; RV64I-NEXT:    lbu s4, 15(a0)
; RV64I-NEXT:    lbu s5, 16(a0)
; RV64I-NEXT:    lbu s6, 17(a0)
; RV64I-NEXT:    lbu s7, 18(a0)
; RV64I-NEXT:    lbu s8, 19(a0)
; RV64I-NEXT:    lbu s9, 1(a1)
; RV64I-NEXT:    lbu s10, 0(a1)
; RV64I-NEXT:    lbu s11, 2(a1)
; RV64I-NEXT:    lbu ra, 3(a1)
; RV64I-NEXT:    slli s9, s9, 8
; RV64I-NEXT:    or s9, s9, s10
; RV64I-NEXT:    slli s11, s11, 16
; RV64I-NEXT:    slli ra, ra, 24
; RV64I-NEXT:    lbu s10, 5(a1)
; RV64I-NEXT:    or s11, ra, s11
; RV64I-NEXT:    or s9, s11, s9
; RV64I-NEXT:    lbu s11, 4(a1)
; RV64I-NEXT:    slli s10, s10, 8
; RV64I-NEXT:    lbu ra, 6(a1)
; RV64I-NEXT:    lbu a1, 7(a1)
; RV64I-NEXT:    or s10, s10, s11
; RV64I-NEXT:    lbu s11, 20(a0)
; RV64I-NEXT:    slli ra, ra, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, ra
; RV64I-NEXT:    lbu ra, 21(a0)
; RV64I-NEXT:    or a1, a1, s10
; RV64I-NEXT:    lbu s10, 22(a0)
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or t1, a1, s9
; RV64I-NEXT:    lbu s9, 23(a0)
; RV64I-NEXT:    lbu a7, 24(a0)
; RV64I-NEXT:    lbu a6, 25(a0)
; RV64I-NEXT:    lbu a5, 26(a0)
; RV64I-NEXT:    lbu a1, 30(a0)
; RV64I-NEXT:    lbu a3, 29(a0)
; RV64I-NEXT:    lbu a4, 28(a0)
; RV64I-NEXT:    lbu a0, 27(a0)
; RV64I-NEXT:    sb a1, 86(sp)
; RV64I-NEXT:    sb a3, 85(sp)
; RV64I-NEXT:    sb a4, 84(sp)
; RV64I-NEXT:    sb a0, 83(sp)
; RV64I-NEXT:    sb a5, 82(sp)
; RV64I-NEXT:    sb a6, 81(sp)
; RV64I-NEXT:    sb a7, 80(sp)
; RV64I-NEXT:    sb s9, 79(sp)
; RV64I-NEXT:    sb s10, 78(sp)
; RV64I-NEXT:    sb ra, 77(sp)
; RV64I-NEXT:    sb s11, 76(sp)
; RV64I-NEXT:    sb s8, 75(sp)
; RV64I-NEXT:    sb s7, 74(sp)
; RV64I-NEXT:    sb s6, 73(sp)
; RV64I-NEXT:    sb s5, 72(sp)
; RV64I-NEXT:    sb s4, 71(sp)
; RV64I-NEXT:    sb s3, 70(sp)
; RV64I-NEXT:    sb s2, 69(sp)
; RV64I-NEXT:    sb s1, 68(sp)
; RV64I-NEXT:    sb s0, 67(sp)
; RV64I-NEXT:    sb t6, 66(sp)
; RV64I-NEXT:    sb t5, 65(sp)
; RV64I-NEXT:    sb t4, 64(sp)
; RV64I-NEXT:    sb t0, 87(sp)
; RV64I-NEXT:    slli t0, t0, 56
; RV64I-NEXT:    sb t3, 63(sp)
; RV64I-NEXT:    sb t2, 62(sp)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 61(sp)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 60(sp)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 59(sp)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 58(sp)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 57(sp)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 56(sp)
; RV64I-NEXT:    srai a0, t0, 63
; RV64I-NEXT:    sb a0, 112(sp)
; RV64I-NEXT:    sb a0, 104(sp)
; RV64I-NEXT:    sb a0, 96(sp)
; RV64I-NEXT:    sb a0, 88(sp)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 119(sp)
; RV64I-NEXT:    srli a3, a0, 48
; RV64I-NEXT:    sb a3, 118(sp)
; RV64I-NEXT:    srli a4, a0, 40
; RV64I-NEXT:    sb a4, 117(sp)
; RV64I-NEXT:    srli a5, a0, 32
; RV64I-NEXT:    sb a5, 116(sp)
; RV64I-NEXT:    srli a6, a0, 24
; RV64I-NEXT:    sb a6, 115(sp)
; RV64I-NEXT:    srli a7, a0, 16
; RV64I-NEXT:    sb a7, 114(sp)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 113(sp)
; RV64I-NEXT:    sb a1, 111(sp)
; RV64I-NEXT:    sb a3, 110(sp)
; RV64I-NEXT:    sb a4, 109(sp)
; RV64I-NEXT:    sb a5, 108(sp)
; RV64I-NEXT:    sb a6, 107(sp)
; RV64I-NEXT:    sb a7, 106(sp)
; RV64I-NEXT:    sb a0, 105(sp)
; RV64I-NEXT:    sb a1, 103(sp)
; RV64I-NEXT:    sb a3, 102(sp)
; RV64I-NEXT:    sb a4, 101(sp)
; RV64I-NEXT:    sb a5, 100(sp)
; RV64I-NEXT:    sb a6, 99(sp)
; RV64I-NEXT:    sb a7, 98(sp)
; RV64I-NEXT:    sb a0, 97(sp)
; RV64I-NEXT:    sb a1, 95(sp)
; RV64I-NEXT:    sb a3, 94(sp)
; RV64I-NEXT:    sb a4, 93(sp)
; RV64I-NEXT:    sb a5, 92(sp)
; RV64I-NEXT:    sb a6, 91(sp)
; RV64I-NEXT:    sb a7, 90(sp)
; RV64I-NEXT:    sb a0, 89(sp)
; RV64I-NEXT:    slli a0, t1, 56
; RV64I-NEXT:    srli a0, a0, 59
; RV64I-NEXT:    addi a3, sp, 56
; RV64I-NEXT:    add a3, a3, a0
; RV64I-NEXT:    lbu a0, 9(a3)
; RV64I-NEXT:    lbu a1, 8(a3)
; RV64I-NEXT:    lbu a4, 10(a3)
; RV64I-NEXT:    lbu a5, 11(a3)
; RV64I-NEXT:    slli a0, a0, 8
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    slli a4, a4, 16
; RV64I-NEXT:    slli a5, a5, 24
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    lbu a1, 13(a3)
; RV64I-NEXT:    lbu a4, 12(a3)
; RV64I-NEXT:    lbu a5, 14(a3)
; RV64I-NEXT:    lbu a6, 15(a3)
; RV64I-NEXT:    slli a1, a1, 8
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a1, a4, a1
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    or a4, a1, a0
; RV64I-NEXT:    andi a1, t1, 7
; RV64I-NEXT:    lbu a0, 17(a3)
; RV64I-NEXT:    lbu a5, 16(a3)
; RV64I-NEXT:    lbu a6, 18(a3)
; RV64I-NEXT:    lbu a7, 19(a3)
; RV64I-NEXT:    slli a0, a0, 8
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a0, a5, a0
; RV64I-NEXT:    lbu a5, 21(a3)
; RV64I-NEXT:    lbu a6, 20(a3)
; RV64I-NEXT:    lbu a7, 22(a3)
; RV64I-NEXT:    lbu t0, 23(a3)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    slli a5, a5, 32
; RV64I-NEXT:    or a5, a5, a0
; RV64I-NEXT:    slli a0, a5, 1
; RV64I-NEXT:    not a6, a1
; RV64I-NEXT:    sll a0, a0, a6
; RV64I-NEXT:    lbu a6, 1(a3)
; RV64I-NEXT:    lbu a7, 0(a3)
; RV64I-NEXT:    lbu t0, 2(a3)
; RV64I-NEXT:    lbu t1, 3(a3)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 5(a3)
; RV64I-NEXT:    lbu t0, 4(a3)
; RV64I-NEXT:    lbu t1, 6(a3)
; RV64I-NEXT:    lbu t2, 7(a3)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli t2, t2, 24
; RV64I-NEXT:    or t0, t2, t1
; RV64I-NEXT:    or a7, t0, a7
; RV64I-NEXT:    slli a7, a7, 32
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 25(a3)
; RV64I-NEXT:    lbu t0, 24(a3)
; RV64I-NEXT:    lbu t1, 26(a3)
; RV64I-NEXT:    lbu t2, 27(a3)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli t2, t2, 24
; RV64I-NEXT:    or t0, t2, t1
; RV64I-NEXT:    or a7, t0, a7
; RV64I-NEXT:    lbu t0, 29(a3)
; RV64I-NEXT:    lbu t1, 28(a3)
; RV64I-NEXT:    lbu t2, 30(a3)
; RV64I-NEXT:    lbu a3, 31(a3)
; RV64I-NEXT:    slli t0, t0, 8
; RV64I-NEXT:    or t0, t0, t1
; RV64I-NEXT:    slli t2, t2, 16
; RV64I-NEXT:    slli a3, a3, 24
; RV64I-NEXT:    or a3, a3, t2
; RV64I-NEXT:    slli t1, a4, 1
; RV64I-NEXT:    or a3, a3, t0
; RV64I-NEXT:    xori t0, a1, 63
; RV64I-NEXT:    sll t1, t1, t0
; RV64I-NEXT:    slli a3, a3, 32
; RV64I-NEXT:    or a3, a3, a7
; RV64I-NEXT:    slli a7, a3, 1
; RV64I-NEXT:    sll a7, a7, t0
; RV64I-NEXT:    srl a4, a4, a1
; RV64I-NEXT:    srl a6, a6, a1
; RV64I-NEXT:    srl a5, a5, a1
; RV64I-NEXT:    sra a1, a3, a1
; RV64I-NEXT:    srli a3, a5, 48
; RV64I-NEXT:    sb a3, 22(a2)
; RV64I-NEXT:    srli a3, a5, 40
; RV64I-NEXT:    sb a3, 21(a2)
; RV64I-NEXT:    srli a3, a5, 32
; RV64I-NEXT:    sb a3, 20(a2)
; RV64I-NEXT:    srli a3, a5, 24
; RV64I-NEXT:    sb a3, 19(a2)
; RV64I-NEXT:    srli a3, a5, 16
; RV64I-NEXT:    sb a3, 18(a2)
; RV64I-NEXT:    or a3, a5, a7
; RV64I-NEXT:    sb a5, 16(a2)
; RV64I-NEXT:    srli a5, a5, 8
; RV64I-NEXT:    sb a5, 17(a2)
; RV64I-NEXT:    srli a5, a1, 56
; RV64I-NEXT:    sb a5, 31(a2)
; RV64I-NEXT:    srli a5, a1, 48
; RV64I-NEXT:    sb a5, 30(a2)
; RV64I-NEXT:    srli a5, a1, 40
; RV64I-NEXT:    sb a5, 29(a2)
; RV64I-NEXT:    srli a5, a1, 32
; RV64I-NEXT:    sb a5, 28(a2)
; RV64I-NEXT:    srli a5, a1, 24
; RV64I-NEXT:    sb a5, 27(a2)
; RV64I-NEXT:    srli a5, a1, 16
; RV64I-NEXT:    sb a5, 26(a2)
; RV64I-NEXT:    sb a1, 24(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 25(a2)
; RV64I-NEXT:    srli a1, a6, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a6, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a6, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a6, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a1, a6, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    or a1, a6, t1
; RV64I-NEXT:    sb a6, 0(a2)
; RV64I-NEXT:    srli a5, a6, 8
; RV64I-NEXT:    sb a5, 1(a2)
; RV64I-NEXT:    srli a5, a4, 48
; RV64I-NEXT:    sb a5, 14(a2)
; RV64I-NEXT:    srli a5, a4, 40
; RV64I-NEXT:    sb a5, 13(a2)
; RV64I-NEXT:    srli a5, a4, 32
; RV64I-NEXT:    sb a5, 12(a2)
; RV64I-NEXT:    srli a5, a4, 24
; RV64I-NEXT:    sb a5, 11(a2)
; RV64I-NEXT:    srli a5, a4, 16
; RV64I-NEXT:    sb a5, 10(a2)
; RV64I-NEXT:    or a0, a4, a0
; RV64I-NEXT:    sb a4, 8(a2)
; RV64I-NEXT:    srli a4, a4, 8
; RV64I-NEXT:    sb a4, 9(a2)
; RV64I-NEXT:    srli a3, a3, 56
; RV64I-NEXT:    sb a3, 23(a2)
; RV64I-NEXT:    srli a1, a1, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    sb a0, 15(a2)
; RV64I-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 224
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_32bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t3, 31(a0)
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    sw a3, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    sw a3, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 2(a0)
; RV32I-NEXT:    sw a3, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 3(a0)
; RV32I-NEXT:    sw a3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    sw a3, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t2, 6(a0)
; RV32I-NEXT:    lbu t4, 7(a0)
; RV32I-NEXT:    lbu t5, 8(a0)
; RV32I-NEXT:    lbu t6, 9(a0)
; RV32I-NEXT:    lbu s0, 10(a0)
; RV32I-NEXT:    lbu s1, 11(a0)
; RV32I-NEXT:    lbu s2, 12(a0)
; RV32I-NEXT:    lbu s3, 13(a0)
; RV32I-NEXT:    lbu s4, 14(a0)
; RV32I-NEXT:    lbu s5, 15(a0)
; RV32I-NEXT:    lbu s6, 16(a0)
; RV32I-NEXT:    lbu s7, 17(a0)
; RV32I-NEXT:    lbu s8, 18(a0)
; RV32I-NEXT:    lbu a4, 1(a1)
; RV32I-NEXT:    lbu s9, 19(a0)
; RV32I-NEXT:    lbu s10, 20(a0)
; RV32I-NEXT:    lbu s11, 0(a1)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    lbu ra, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    or a4, a4, s11
; RV32I-NEXT:    lbu s11, 21(a0)
; RV32I-NEXT:    slli ra, ra, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, ra
; RV32I-NEXT:    lbu ra, 22(a0)
; RV32I-NEXT:    or t1, a1, a4
; RV32I-NEXT:    lbu t0, 23(a0)
; RV32I-NEXT:    lbu a7, 24(a0)
; RV32I-NEXT:    lbu a6, 25(a0)
; RV32I-NEXT:    lbu a5, 26(a0)
; RV32I-NEXT:    lbu a1, 30(a0)
; RV32I-NEXT:    lbu a3, 29(a0)
; RV32I-NEXT:    lbu a4, 28(a0)
; RV32I-NEXT:    lbu a0, 27(a0)
; RV32I-NEXT:    sb a1, 58(sp)
; RV32I-NEXT:    sb a3, 57(sp)
; RV32I-NEXT:    sb a4, 56(sp)
; RV32I-NEXT:    sb a0, 55(sp)
; RV32I-NEXT:    sb a5, 54(sp)
; RV32I-NEXT:    sb a6, 53(sp)
; RV32I-NEXT:    sb a7, 52(sp)
; RV32I-NEXT:    sb t0, 51(sp)
; RV32I-NEXT:    sb ra, 50(sp)
; RV32I-NEXT:    sb s11, 49(sp)
; RV32I-NEXT:    sb s10, 48(sp)
; RV32I-NEXT:    sb s9, 47(sp)
; RV32I-NEXT:    sb s8, 46(sp)
; RV32I-NEXT:    sb s7, 45(sp)
; RV32I-NEXT:    sb s6, 44(sp)
; RV32I-NEXT:    sb s5, 43(sp)
; RV32I-NEXT:    sb t3, 59(sp)
; RV32I-NEXT:    slli t3, t3, 24
; RV32I-NEXT:    sb s4, 42(sp)
; RV32I-NEXT:    sb s3, 41(sp)
; RV32I-NEXT:    sb s2, 40(sp)
; RV32I-NEXT:    sb s1, 39(sp)
; RV32I-NEXT:    sb s0, 38(sp)
; RV32I-NEXT:    sb t6, 37(sp)
; RV32I-NEXT:    sb t5, 36(sp)
; RV32I-NEXT:    sb t4, 35(sp)
; RV32I-NEXT:    sb t2, 34(sp)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 33(sp)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 32(sp)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 31(sp)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 30(sp)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 29(sp)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 28(sp)
; RV32I-NEXT:    srai a0, t3, 31
; RV32I-NEXT:    sb a0, 88(sp)
; RV32I-NEXT:    sb a0, 84(sp)
; RV32I-NEXT:    sb a0, 80(sp)
; RV32I-NEXT:    sb a0, 76(sp)
; RV32I-NEXT:    sb a0, 72(sp)
; RV32I-NEXT:    sb a0, 68(sp)
; RV32I-NEXT:    sb a0, 64(sp)
; RV32I-NEXT:    sb a0, 60(sp)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 91(sp)
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    sb a3, 90(sp)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 89(sp)
; RV32I-NEXT:    sb a1, 87(sp)
; RV32I-NEXT:    sb a3, 86(sp)
; RV32I-NEXT:    sb a0, 85(sp)
; RV32I-NEXT:    sb a1, 83(sp)
; RV32I-NEXT:    sb a3, 82(sp)
; RV32I-NEXT:    sb a0, 81(sp)
; RV32I-NEXT:    sb a1, 79(sp)
; RV32I-NEXT:    sb a3, 78(sp)
; RV32I-NEXT:    sb a0, 77(sp)
; RV32I-NEXT:    sb a1, 75(sp)
; RV32I-NEXT:    sb a3, 74(sp)
; RV32I-NEXT:    sb a0, 73(sp)
; RV32I-NEXT:    sb a1, 71(sp)
; RV32I-NEXT:    sb a3, 70(sp)
; RV32I-NEXT:    sb a0, 69(sp)
; RV32I-NEXT:    sb a1, 67(sp)
; RV32I-NEXT:    sb a3, 66(sp)
; RV32I-NEXT:    sb a0, 65(sp)
; RV32I-NEXT:    sb a1, 63(sp)
; RV32I-NEXT:    sb a3, 62(sp)
; RV32I-NEXT:    sb a0, 61(sp)
; RV32I-NEXT:    slli a0, t1, 24
; RV32I-NEXT:    srli a0, a0, 27
; RV32I-NEXT:    addi a3, sp, 28
; RV32I-NEXT:    add a3, a3, a0
; RV32I-NEXT:    lbu a0, 5(a3)
; RV32I-NEXT:    lbu a1, 4(a3)
; RV32I-NEXT:    lbu a4, 6(a3)
; RV32I-NEXT:    lbu a5, 7(a3)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a4, a4, 16
; RV32I-NEXT:    slli a5, a5, 24
; RV32I-NEXT:    or a4, a5, a4
; RV32I-NEXT:    or t4, a4, a0
; RV32I-NEXT:    andi a4, t1, 7
; RV32I-NEXT:    lbu a0, 9(a3)
; RV32I-NEXT:    lbu a1, 8(a3)
; RV32I-NEXT:    lbu a5, 10(a3)
; RV32I-NEXT:    lbu a6, 11(a3)
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a1, a6, a5
; RV32I-NEXT:    or a6, a1, a0
; RV32I-NEXT:    slli a0, a6, 1
; RV32I-NEXT:    not t0, a4
; RV32I-NEXT:    sll a0, a0, t0
; RV32I-NEXT:    lbu a1, 1(a3)
; RV32I-NEXT:    lbu a5, 0(a3)
; RV32I-NEXT:    lbu a7, 2(a3)
; RV32I-NEXT:    lbu t1, 3(a3)
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli t1, t1, 24
; RV32I-NEXT:    or a5, t1, a7
; RV32I-NEXT:    or t1, a5, a1
; RV32I-NEXT:    slli a1, t4, 1
; RV32I-NEXT:    xori t2, a4, 31
; RV32I-NEXT:    sll a1, a1, t2
; RV32I-NEXT:    lbu a5, 13(a3)
; RV32I-NEXT:    lbu a7, 12(a3)
; RV32I-NEXT:    lbu t3, 14(a3)
; RV32I-NEXT:    lbu t5, 15(a3)
; RV32I-NEXT:    slli a5, a5, 8
; RV32I-NEXT:    or a5, a5, a7
; RV32I-NEXT:    slli t3, t3, 16
; RV32I-NEXT:    slli t5, t5, 24
; RV32I-NEXT:    or a7, t5, t3
; RV32I-NEXT:    or t3, a7, a5
; RV32I-NEXT:    lbu a5, 17(a3)
; RV32I-NEXT:    lbu a7, 16(a3)
; RV32I-NEXT:    lbu t5, 18(a3)
; RV32I-NEXT:    lbu t6, 19(a3)
; RV32I-NEXT:    slli a5, a5, 8
; RV32I-NEXT:    or a5, a5, a7
; RV32I-NEXT:    slli t5, t5, 16
; RV32I-NEXT:    slli t6, t6, 24
; RV32I-NEXT:    or a7, t6, t5
; RV32I-NEXT:    or a5, a7, a5
; RV32I-NEXT:    slli a7, a5, 1
; RV32I-NEXT:    sll a7, a7, t0
; RV32I-NEXT:    lbu t5, 21(a3)
; RV32I-NEXT:    lbu t6, 20(a3)
; RV32I-NEXT:    lbu s0, 22(a3)
; RV32I-NEXT:    lbu s1, 23(a3)
; RV32I-NEXT:    slli t5, t5, 8
; RV32I-NEXT:    or t5, t5, t6
; RV32I-NEXT:    slli s0, s0, 16
; RV32I-NEXT:    slli s1, s1, 24
; RV32I-NEXT:    or s0, s1, s0
; RV32I-NEXT:    or t5, s0, t5
; RV32I-NEXT:    lbu t6, 25(a3)
; RV32I-NEXT:    lbu s0, 24(a3)
; RV32I-NEXT:    lbu s1, 26(a3)
; RV32I-NEXT:    lbu s2, 27(a3)
; RV32I-NEXT:    slli t6, t6, 8
; RV32I-NEXT:    or t6, t6, s0
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli s2, s2, 24
; RV32I-NEXT:    or s0, s2, s1
; RV32I-NEXT:    or t6, s0, t6
; RV32I-NEXT:    lbu s0, 29(a3)
; RV32I-NEXT:    lbu s1, 28(a3)
; RV32I-NEXT:    slli s2, t6, 1
; RV32I-NEXT:    sll t0, s2, t0
; RV32I-NEXT:    slli s0, s0, 8
; RV32I-NEXT:    or s0, s0, s1
; RV32I-NEXT:    lbu s1, 30(a3)
; RV32I-NEXT:    lbu a3, 31(a3)
; RV32I-NEXT:    slli s2, t3, 1
; RV32I-NEXT:    sll s2, s2, t2
; RV32I-NEXT:    slli s1, s1, 16
; RV32I-NEXT:    slli a3, a3, 24
; RV32I-NEXT:    or a3, a3, s1
; RV32I-NEXT:    slli s1, t5, 1
; RV32I-NEXT:    sll s1, s1, t2
; RV32I-NEXT:    or a3, a3, s0
; RV32I-NEXT:    slli s0, a3, 1
; RV32I-NEXT:    sll t2, s0, t2
; RV32I-NEXT:    srl t4, t4, a4
; RV32I-NEXT:    srl t1, t1, a4
; RV32I-NEXT:    srl t3, t3, a4
; RV32I-NEXT:    srl a6, a6, a4
; RV32I-NEXT:    srl t5, t5, a4
; RV32I-NEXT:    srl a5, a5, a4
; RV32I-NEXT:    srl t6, t6, a4
; RV32I-NEXT:    sra a3, a3, a4
; RV32I-NEXT:    srli a4, t6, 16
; RV32I-NEXT:    sb a4, 26(a2)
; RV32I-NEXT:    or a4, t6, t2
; RV32I-NEXT:    sb t6, 24(a2)
; RV32I-NEXT:    srli t2, t6, 8
; RV32I-NEXT:    sb t2, 25(a2)
; RV32I-NEXT:    srli t2, a3, 24
; RV32I-NEXT:    sb t2, 31(a2)
; RV32I-NEXT:    srli t2, a3, 16
; RV32I-NEXT:    sb t2, 30(a2)
; RV32I-NEXT:    sb a3, 28(a2)
; RV32I-NEXT:    srli a3, a3, 8
; RV32I-NEXT:    sb a3, 29(a2)
; RV32I-NEXT:    srli a3, a5, 16
; RV32I-NEXT:    sb a3, 18(a2)
; RV32I-NEXT:    or s1, a5, s1
; RV32I-NEXT:    sb a5, 16(a2)
; RV32I-NEXT:    srli a5, a5, 8
; RV32I-NEXT:    sb a5, 17(a2)
; RV32I-NEXT:    srli a3, t5, 16
; RV32I-NEXT:    sb a3, 22(a2)
; RV32I-NEXT:    or a3, t5, t0
; RV32I-NEXT:    sb t5, 20(a2)
; RV32I-NEXT:    srli a5, t5, 8
; RV32I-NEXT:    sb a5, 21(a2)
; RV32I-NEXT:    srli a5, a6, 16
; RV32I-NEXT:    sb a5, 10(a2)
; RV32I-NEXT:    or a5, a6, s2
; RV32I-NEXT:    sb a6, 8(a2)
; RV32I-NEXT:    srli a6, a6, 8
; RV32I-NEXT:    sb a6, 9(a2)
; RV32I-NEXT:    srli a6, t3, 16
; RV32I-NEXT:    sb a6, 14(a2)
; RV32I-NEXT:    or a6, t3, a7
; RV32I-NEXT:    sb t3, 12(a2)
; RV32I-NEXT:    srli a7, t3, 8
; RV32I-NEXT:    sb a7, 13(a2)
; RV32I-NEXT:    srli a7, t1, 16
; RV32I-NEXT:    sb a7, 2(a2)
; RV32I-NEXT:    or a1, t1, a1
; RV32I-NEXT:    sb t1, 0(a2)
; RV32I-NEXT:    srli a7, t1, 8
; RV32I-NEXT:    sb a7, 1(a2)
; RV32I-NEXT:    srli a7, t4, 16
; RV32I-NEXT:    sb a7, 6(a2)
; RV32I-NEXT:    or a0, t4, a0
; RV32I-NEXT:    sb t4, 4(a2)
; RV32I-NEXT:    srli a7, t4, 8
; RV32I-NEXT:    sb a7, 5(a2)
; RV32I-NEXT:    srli a4, a4, 24
; RV32I-NEXT:    sb a4, 27(a2)
; RV32I-NEXT:    srli s1, s1, 24
; RV32I-NEXT:    sb s1, 19(a2)
; RV32I-NEXT:    srli a3, a3, 24
; RV32I-NEXT:    sb a3, 23(a2)
; RV32I-NEXT:    srli a5, a5, 24
; RV32I-NEXT:    sb a5, 11(a2)
; RV32I-NEXT:    srli a3, a6, 24
; RV32I-NEXT:    sb a3, 15(a2)
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    sb a0, 7(a2)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
  %src = load i256, ptr %src.ptr, align 1
  %bitOff = load i256, ptr %bitOff.ptr, align 1
  %res = ashr i256 %src, %bitOff
  store i256 %res, ptr %dst, align 1
  ret void
}
