// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/iot/v1/device_manager.proto

/*
Package iot is a generated protocol buffer package.

It is generated from these files:
	google/cloud/iot/v1/device_manager.proto
	google/cloud/iot/v1/resources.proto

It has these top-level messages:
	CreateDeviceRegistryRequest
	GetDeviceRegistryRequest
	DeleteDeviceRegistryRequest
	UpdateDeviceRegistryRequest
	ListDeviceRegistriesRequest
	ListDeviceRegistriesResponse
	CreateDeviceRequest
	GetDeviceRequest
	UpdateDeviceRequest
	DeleteDeviceRequest
	ListDevicesRequest
	ListDevicesResponse
	ModifyCloudToDeviceConfigRequest
	ListDeviceConfigVersionsRequest
	ListDeviceConfigVersionsResponse
	ListDeviceStatesRequest
	ListDeviceStatesResponse
	Device
	DeviceRegistry
	MqttConfig
	HttpConfig
	EventNotificationConfig
	StateNotificationConfig
	RegistryCredential
	X509CertificateDetails
	PublicKeyCertificate
	DeviceCredential
	PublicKeyCredential
	DeviceConfig
	DeviceState
*/
package iot

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request for `CreateDeviceRegistry`.
type CreateDeviceRegistryRequest struct {
	// The project and cloud region where this device registry must be created.
	// For example, `projects/example-project/locations/us-central1`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The device registry. The field `name` must be empty. The server will
	// generate that field from the device registry `id` provided and the
	// `parent` field.
	DeviceRegistry *DeviceRegistry `protobuf:"bytes,2,opt,name=device_registry,json=deviceRegistry" json:"device_registry,omitempty"`
}

func (m *CreateDeviceRegistryRequest) Reset()                    { *m = CreateDeviceRegistryRequest{} }
func (m *CreateDeviceRegistryRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateDeviceRegistryRequest) ProtoMessage()               {}
func (*CreateDeviceRegistryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateDeviceRegistryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeviceRegistryRequest) GetDeviceRegistry() *DeviceRegistry {
	if m != nil {
		return m.DeviceRegistry
	}
	return nil
}

// Request for `GetDeviceRegistry`.
type GetDeviceRegistryRequest struct {
	// The name of the device registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetDeviceRegistryRequest) Reset()                    { *m = GetDeviceRegistryRequest{} }
func (m *GetDeviceRegistryRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDeviceRegistryRequest) ProtoMessage()               {}
func (*GetDeviceRegistryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GetDeviceRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `DeleteDeviceRegistry`.
type DeleteDeviceRegistryRequest struct {
	// The name of the device registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteDeviceRegistryRequest) Reset()                    { *m = DeleteDeviceRegistryRequest{} }
func (m *DeleteDeviceRegistryRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteDeviceRegistryRequest) ProtoMessage()               {}
func (*DeleteDeviceRegistryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *DeleteDeviceRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `UpdateDeviceRegistry`.
type UpdateDeviceRegistryRequest struct {
	// The new values for the device registry. The `id` field must be empty, and
	// the `name` field must indicate the path of the resource. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	DeviceRegistry *DeviceRegistry `protobuf:"bytes,1,opt,name=device_registry,json=deviceRegistry" json:"device_registry,omitempty"`
	// Only updates the `device_registry` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	// Mutable top-level fields: `event_notification_config`, `http_config`,
	// `mqtt_config`, and `state_notification_config`.
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateDeviceRegistryRequest) Reset()                    { *m = UpdateDeviceRegistryRequest{} }
func (m *UpdateDeviceRegistryRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateDeviceRegistryRequest) ProtoMessage()               {}
func (*UpdateDeviceRegistryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *UpdateDeviceRegistryRequest) GetDeviceRegistry() *DeviceRegistry {
	if m != nil {
		return m.DeviceRegistry
	}
	return nil
}

func (m *UpdateDeviceRegistryRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for `ListDeviceRegistries`.
type ListDeviceRegistriesRequest struct {
	// The project and cloud region path. For example,
	// `projects/example-project/locations/us-central1`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The maximum number of registries to return in the response. If this value
	// is zero, the service will select a default size. A call may return fewer
	// objects than requested, but if there is a non-empty `page_token`, it
	// indicates that more entries are available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListDeviceRegistriesResponse`; indicates
	// that this is a continuation of a prior `ListDeviceRegistries` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListDeviceRegistriesRequest) Reset()                    { *m = ListDeviceRegistriesRequest{} }
func (m *ListDeviceRegistriesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDeviceRegistriesRequest) ProtoMessage()               {}
func (*ListDeviceRegistriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListDeviceRegistriesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDeviceRegistriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDeviceRegistriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for `ListDeviceRegistries`.
type ListDeviceRegistriesResponse struct {
	// The registries that matched the query.
	DeviceRegistries []*DeviceRegistry `protobuf:"bytes,1,rep,name=device_registries,json=deviceRegistries" json:"device_registries,omitempty"`
	// If not empty, indicates that there may be more registries that match the
	// request; this value should be passed in a new
	// `ListDeviceRegistriesRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDeviceRegistriesResponse) Reset()                    { *m = ListDeviceRegistriesResponse{} }
func (m *ListDeviceRegistriesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDeviceRegistriesResponse) ProtoMessage()               {}
func (*ListDeviceRegistriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ListDeviceRegistriesResponse) GetDeviceRegistries() []*DeviceRegistry {
	if m != nil {
		return m.DeviceRegistries
	}
	return nil
}

func (m *ListDeviceRegistriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for `CreateDevice`.
type CreateDeviceRequest struct {
	// The name of the device registry where this device should be created.
	// For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The device registration details.
	Device *Device `protobuf:"bytes,2,opt,name=device" json:"device,omitempty"`
}

func (m *CreateDeviceRequest) Reset()                    { *m = CreateDeviceRequest{} }
func (m *CreateDeviceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateDeviceRequest) ProtoMessage()               {}
func (*CreateDeviceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CreateDeviceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

// Request for `GetDevice`.
type GetDeviceRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The fields of the `Device` resource to be returned in the response. If the
	// field mask is unset or empty, all fields are returned.
	FieldMask *google_protobuf4.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask" json:"field_mask,omitempty"`
}

func (m *GetDeviceRequest) Reset()                    { *m = GetDeviceRequest{} }
func (m *GetDeviceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDeviceRequest) ProtoMessage()               {}
func (*GetDeviceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetDeviceRequest) GetFieldMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// Request for `UpdateDevice`.
type UpdateDeviceRequest struct {
	// The new values for the device registry. The `id` and `num_id` fields must
	// be empty, and the field `name` must specify the name path. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0`or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Device *Device `protobuf:"bytes,2,opt,name=device" json:"device,omitempty"`
	// Only updates the `device` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	// Mutable top-level fields: `credentials`, `enabled_state`, and `metadata`
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateDeviceRequest) Reset()                    { *m = UpdateDeviceRequest{} }
func (m *UpdateDeviceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateDeviceRequest) ProtoMessage()               {}
func (*UpdateDeviceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *UpdateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

func (m *UpdateDeviceRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for `DeleteDevice`.
type DeleteDeviceRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteDeviceRequest) Reset()                    { *m = DeleteDeviceRequest{} }
func (m *DeleteDeviceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteDeviceRequest) ProtoMessage()               {}
func (*DeleteDeviceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeleteDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `ListDevices`.
type ListDevicesRequest struct {
	// The device registry path. Required. For example,
	// `projects/my-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// A list of device numerical ids. If empty, it will ignore this field. This
	// field cannot hold more than 10,000 entries.
	DeviceNumIds []uint64 `protobuf:"varint,2,rep,packed,name=device_num_ids,json=deviceNumIds" json:"device_num_ids,omitempty"`
	// A list of device string identifiers. If empty, it will ignore this field.
	// For example, `['device0', 'device12']`. This field cannot hold more than
	// 10,000 entries.
	DeviceIds []string `protobuf:"bytes,3,rep,name=device_ids,json=deviceIds" json:"device_ids,omitempty"`
	// The fields of the `Device` resource to be returned in the response. The
	// fields `id`, and `num_id` are always returned by default, along with any
	// other fields specified.
	FieldMask *google_protobuf4.FieldMask `protobuf:"bytes,4,opt,name=field_mask,json=fieldMask" json:"field_mask,omitempty"`
	// The maximum number of devices to return in the response. If this value
	// is zero, the service will select a default size. A call may return fewer
	// objects than requested, but if there is a non-empty `page_token`, it
	// indicates that more entries are available.
	PageSize int32 `protobuf:"varint,100,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListDevicesResponse`; indicates
	// that this is a continuation of a prior `ListDevices` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,101,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListDevicesRequest) Reset()                    { *m = ListDevicesRequest{} }
func (m *ListDevicesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDevicesRequest) ProtoMessage()               {}
func (*ListDevicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ListDevicesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDevicesRequest) GetDeviceNumIds() []uint64 {
	if m != nil {
		return m.DeviceNumIds
	}
	return nil
}

func (m *ListDevicesRequest) GetDeviceIds() []string {
	if m != nil {
		return m.DeviceIds
	}
	return nil
}

func (m *ListDevicesRequest) GetFieldMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListDevicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDevicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for `ListDevices`.
type ListDevicesResponse struct {
	// The devices that match the request.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices" json:"devices,omitempty"`
	// If not empty, indicates that there may be more devices that match the
	// request; this value should be passed in a new `ListDevicesRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDevicesResponse) Reset()                    { *m = ListDevicesResponse{} }
func (m *ListDevicesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDevicesResponse) ProtoMessage()               {}
func (*ListDevicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ListDevicesResponse) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *ListDevicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for `ModifyCloudToDeviceConfig`.
type ModifyCloudToDeviceConfigRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The version number to update. If this value is zero, it will not check the
	// version number of the server and will always update the current version;
	// otherwise, this update will fail if the version number found on the server
	// does not match this version number. This is used to support multiple
	// simultaneous updates without losing data.
	VersionToUpdate int64 `protobuf:"varint,2,opt,name=version_to_update,json=versionToUpdate" json:"version_to_update,omitempty"`
	// The configuration data for the device.
	BinaryData []byte `protobuf:"bytes,3,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
}

func (m *ModifyCloudToDeviceConfigRequest) Reset()         { *m = ModifyCloudToDeviceConfigRequest{} }
func (m *ModifyCloudToDeviceConfigRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyCloudToDeviceConfigRequest) ProtoMessage()    {}
func (*ModifyCloudToDeviceConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{12}
}

func (m *ModifyCloudToDeviceConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifyCloudToDeviceConfigRequest) GetVersionToUpdate() int64 {
	if m != nil {
		return m.VersionToUpdate
	}
	return 0
}

func (m *ModifyCloudToDeviceConfigRequest) GetBinaryData() []byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

// Request for `ListDeviceConfigVersions`.
type ListDeviceConfigVersionsRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The number of versions to list. Versions are listed in decreasing order of
	// the version number. The maximum number of versions retained is 10. If this
	// value is zero, it will return all the versions available.
	NumVersions int32 `protobuf:"varint,2,opt,name=num_versions,json=numVersions" json:"num_versions,omitempty"`
}

func (m *ListDeviceConfigVersionsRequest) Reset()         { *m = ListDeviceConfigVersionsRequest{} }
func (m *ListDeviceConfigVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceConfigVersionsRequest) ProtoMessage()    {}
func (*ListDeviceConfigVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{13}
}

func (m *ListDeviceConfigVersionsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListDeviceConfigVersionsRequest) GetNumVersions() int32 {
	if m != nil {
		return m.NumVersions
	}
	return 0
}

// Response for `ListDeviceConfigVersions`.
type ListDeviceConfigVersionsResponse struct {
	// The device configuration for the last few versions. Versions are listed
	// in decreasing order, starting from the most recent one.
	DeviceConfigs []*DeviceConfig `protobuf:"bytes,1,rep,name=device_configs,json=deviceConfigs" json:"device_configs,omitempty"`
}

func (m *ListDeviceConfigVersionsResponse) Reset()         { *m = ListDeviceConfigVersionsResponse{} }
func (m *ListDeviceConfigVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceConfigVersionsResponse) ProtoMessage()    {}
func (*ListDeviceConfigVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{14}
}

func (m *ListDeviceConfigVersionsResponse) GetDeviceConfigs() []*DeviceConfig {
	if m != nil {
		return m.DeviceConfigs
	}
	return nil
}

// Request for `ListDeviceStates`.
type ListDeviceStatesRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The number of states to list. States are listed in descending order of
	// update time. The maximum number of states retained is 10. If this
	// value is zero, it will return all the states available.
	NumStates int32 `protobuf:"varint,2,opt,name=num_states,json=numStates" json:"num_states,omitempty"`
}

func (m *ListDeviceStatesRequest) Reset()                    { *m = ListDeviceStatesRequest{} }
func (m *ListDeviceStatesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDeviceStatesRequest) ProtoMessage()               {}
func (*ListDeviceStatesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListDeviceStatesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListDeviceStatesRequest) GetNumStates() int32 {
	if m != nil {
		return m.NumStates
	}
	return 0
}

// Response for `ListDeviceStates`.
type ListDeviceStatesResponse struct {
	// The last few device states. States are listed in descending order of server
	// update time, starting from the most recent one.
	DeviceStates []*DeviceState `protobuf:"bytes,1,rep,name=device_states,json=deviceStates" json:"device_states,omitempty"`
}

func (m *ListDeviceStatesResponse) Reset()                    { *m = ListDeviceStatesResponse{} }
func (m *ListDeviceStatesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDeviceStatesResponse) ProtoMessage()               {}
func (*ListDeviceStatesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListDeviceStatesResponse) GetDeviceStates() []*DeviceState {
	if m != nil {
		return m.DeviceStates
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateDeviceRegistryRequest)(nil), "google.cloud.iot.v1.CreateDeviceRegistryRequest")
	proto.RegisterType((*GetDeviceRegistryRequest)(nil), "google.cloud.iot.v1.GetDeviceRegistryRequest")
	proto.RegisterType((*DeleteDeviceRegistryRequest)(nil), "google.cloud.iot.v1.DeleteDeviceRegistryRequest")
	proto.RegisterType((*UpdateDeviceRegistryRequest)(nil), "google.cloud.iot.v1.UpdateDeviceRegistryRequest")
	proto.RegisterType((*ListDeviceRegistriesRequest)(nil), "google.cloud.iot.v1.ListDeviceRegistriesRequest")
	proto.RegisterType((*ListDeviceRegistriesResponse)(nil), "google.cloud.iot.v1.ListDeviceRegistriesResponse")
	proto.RegisterType((*CreateDeviceRequest)(nil), "google.cloud.iot.v1.CreateDeviceRequest")
	proto.RegisterType((*GetDeviceRequest)(nil), "google.cloud.iot.v1.GetDeviceRequest")
	proto.RegisterType((*UpdateDeviceRequest)(nil), "google.cloud.iot.v1.UpdateDeviceRequest")
	proto.RegisterType((*DeleteDeviceRequest)(nil), "google.cloud.iot.v1.DeleteDeviceRequest")
	proto.RegisterType((*ListDevicesRequest)(nil), "google.cloud.iot.v1.ListDevicesRequest")
	proto.RegisterType((*ListDevicesResponse)(nil), "google.cloud.iot.v1.ListDevicesResponse")
	proto.RegisterType((*ModifyCloudToDeviceConfigRequest)(nil), "google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest")
	proto.RegisterType((*ListDeviceConfigVersionsRequest)(nil), "google.cloud.iot.v1.ListDeviceConfigVersionsRequest")
	proto.RegisterType((*ListDeviceConfigVersionsResponse)(nil), "google.cloud.iot.v1.ListDeviceConfigVersionsResponse")
	proto.RegisterType((*ListDeviceStatesRequest)(nil), "google.cloud.iot.v1.ListDeviceStatesRequest")
	proto.RegisterType((*ListDeviceStatesResponse)(nil), "google.cloud.iot.v1.ListDeviceStatesResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DeviceManager service

type DeviceManagerClient interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Gets details about a device.
	GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Updates a device.
	UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Deletes a device.
	DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// List devices in a device registry.
	ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
}

type deviceManagerClient struct {
	cc *grpc.ClientConn
}

func NewDeviceManagerClient(cc *grpc.ClientConn) DeviceManagerClient {
	return &deviceManagerClient{cc}
}

func (c *deviceManagerClient) CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error) {
	out := new(ListDeviceRegistriesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/CreateDevice", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetDevice", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UpdateDevice", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/DeleteDevice", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error) {
	out := new(ListDevicesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDevices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error) {
	out := new(DeviceConfig)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error) {
	out := new(ListDeviceConfigVersionsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error) {
	out := new(ListDeviceStatesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceStates", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for DeviceManager service

type DeviceManagerServer interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(context.Context, *CreateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(context.Context, *GetDeviceRegistryRequest) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(context.Context, *UpdateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(context.Context, *DeleteDeviceRegistryRequest) (*google_protobuf3.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(context.Context, *ListDeviceRegistriesRequest) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(context.Context, *CreateDeviceRequest) (*Device, error)
	// Gets details about a device.
	GetDevice(context.Context, *GetDeviceRequest) (*Device, error)
	// Updates a device.
	UpdateDevice(context.Context, *UpdateDeviceRequest) (*Device, error)
	// Deletes a device.
	DeleteDevice(context.Context, *DeleteDeviceRequest) (*google_protobuf3.Empty, error)
	// List devices in a device registry.
	ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(context.Context, *ModifyCloudToDeviceConfigRequest) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(context.Context, *ListDeviceConfigVersionsRequest) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(context.Context, *ListDeviceStatesRequest) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
}

func RegisterDeviceManagerServer(s *grpc.Server, srv DeviceManagerServer) {
	s.RegisterService(&_DeviceManager_serviceDesc, srv)
}

func _DeviceManager_CreateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, req.(*CreateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, req.(*GetDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, req.(*UpdateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, req.(*DeleteDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceRegistries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, req.(*ListDeviceRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_CreateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/CreateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDevice(ctx, req.(*CreateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDevice(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UpdateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, req.(*UpdateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/DeleteDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, req.(*DeleteDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDevices(ctx, req.(*ListDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ModifyCloudToDeviceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyCloudToDeviceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, req.(*ModifyCloudToDeviceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceConfigVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceConfigVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, req.(*ListDeviceConfigVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceStates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceStatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceStates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, req.(*ListDeviceStatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeviceManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iot.v1.DeviceManager",
	HandlerType: (*DeviceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeviceRegistry",
			Handler:    _DeviceManager_CreateDeviceRegistry_Handler,
		},
		{
			MethodName: "GetDeviceRegistry",
			Handler:    _DeviceManager_GetDeviceRegistry_Handler,
		},
		{
			MethodName: "UpdateDeviceRegistry",
			Handler:    _DeviceManager_UpdateDeviceRegistry_Handler,
		},
		{
			MethodName: "DeleteDeviceRegistry",
			Handler:    _DeviceManager_DeleteDeviceRegistry_Handler,
		},
		{
			MethodName: "ListDeviceRegistries",
			Handler:    _DeviceManager_ListDeviceRegistries_Handler,
		},
		{
			MethodName: "CreateDevice",
			Handler:    _DeviceManager_CreateDevice_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _DeviceManager_GetDevice_Handler,
		},
		{
			MethodName: "UpdateDevice",
			Handler:    _DeviceManager_UpdateDevice_Handler,
		},
		{
			MethodName: "DeleteDevice",
			Handler:    _DeviceManager_DeleteDevice_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _DeviceManager_ListDevices_Handler,
		},
		{
			MethodName: "ModifyCloudToDeviceConfig",
			Handler:    _DeviceManager_ModifyCloudToDeviceConfig_Handler,
		},
		{
			MethodName: "ListDeviceConfigVersions",
			Handler:    _DeviceManager_ListDeviceConfigVersions_Handler,
		},
		{
			MethodName: "ListDeviceStates",
			Handler:    _DeviceManager_ListDeviceStates_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DeviceManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DeviceManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DeviceManager_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iot/v1/device_manager.proto",
}

func init() { proto.RegisterFile("google/cloud/iot/v1/device_manager.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1307 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x98, 0xcf, 0x8f, 0xdb, 0x44,
	0x14, 0xc7, 0x35, 0x9b, 0x52, 0xd8, 0xb7, 0x29, 0x6d, 0x67, 0xb7, 0x6d, 0x48, 0x5a, 0x9a, 0xba,
	0xfc, 0x48, 0x23, 0x6a, 0x77, 0xb7, 0xb4, 0x2a, 0xa9, 0xa0, 0xd0, 0x6e, 0xd9, 0xb6, 0x6a, 0x21,
	0x64, 0x17, 0x8a, 0x90, 0x50, 0x34, 0x1b, 0xcf, 0x46, 0xd3, 0x8d, 0x3d, 0xa9, 0xc7, 0x59, 0xb1,
	0x45, 0xbd, 0xd0, 0x03, 0x67, 0x40, 0x48, 0xbd, 0x21, 0x71, 0x40, 0xdc, 0x91, 0x10, 0x12, 0x77,
	0xfe, 0x01, 0x38, 0xf0, 0x07, 0x70, 0xe0, 0x4f, 0xe8, 0x11, 0x79, 0x66, 0xbc, 0x6b, 0x3b, 0xb6,
	0xe3, 0xe4, 0xc0, 0x2d, 0x9e, 0xf7, 0x66, 0xe6, 0x33, 0xdf, 0xf7, 0x9e, 0xe7, 0xc5, 0xd0, 0xe8,
	0x73, 0xde, 0x1f, 0x50, 0xab, 0x37, 0xe0, 0x23, 0xdb, 0x62, 0xdc, 0xb7, 0x76, 0x96, 0x2d, 0x9b,
	0xee, 0xb0, 0x1e, 0xed, 0x3a, 0xc4, 0x25, 0x7d, 0xea, 0x99, 0x43, 0x8f, 0xfb, 0x1c, 0x2f, 0x2a,
	0x4f, 0x53, 0x7a, 0x9a, 0x8c, 0xfb, 0xe6, 0xce, 0x72, 0xf5, 0xa4, 0x9e, 0x4e, 0x86, 0xcc, 0x22,
	0xae, 0xcb, 0x7d, 0xe2, 0x33, 0xee, 0x0a, 0x35, 0xa5, 0x7a, 0x36, 0x6d, 0x71, 0x8f, 0x0a, 0x3e,
	0xf2, 0x7a, 0x34, 0x74, 0x7a, 0x59, 0x3b, 0x31, 0xe2, 0x04, 0x66, 0x46, 0x9c, 0xee, 0x90, 0x0f,
	0x58, 0x6f, 0x57, 0xdb, 0xab, 0x71, 0x7b, 0xcc, 0x56, 0xd3, 0x36, 0xf9, 0xb4, 0x39, 0xda, 0xb2,
	0xa8, 0x33, 0xf4, 0x43, 0x63, 0x3d, 0x69, 0xdc, 0x62, 0x74, 0x60, 0x77, 0x1d, 0x22, 0xb6, 0x95,
	0x87, 0xf1, 0x04, 0x41, 0xed, 0x86, 0x47, 0x89, 0x4f, 0x57, 0xe5, 0x89, 0x3b, 0xb4, 0xcf, 0x84,
	0xef, 0xed, 0x76, 0xe8, 0xc3, 0x11, 0x15, 0x3e, 0x3e, 0x0e, 0x07, 0x87, 0xc4, 0xa3, 0xae, 0x5f,
	0x41, 0x75, 0xd4, 0x98, 0xef, 0xe8, 0x27, 0x7c, 0x17, 0x0e, 0x6b, 0x89, 0x3c, 0x3d, 0xa3, 0x32,
	0x57, 0x47, 0x8d, 0x85, 0x95, 0xb3, 0x66, 0x8a, 0x48, 0x66, 0x62, 0xf1, 0x17, 0xed, 0xd8, 0xb3,
	0x61, 0x42, 0x65, 0x8d, 0xfa, 0xe9, 0x04, 0x18, 0x0e, 0xb8, 0xc4, 0xa1, 0x7a, 0x7f, 0xf9, 0xdb,
	0x58, 0x86, 0xda, 0x2a, 0x1d, 0xd0, 0x2c, 0xe8, 0xb4, 0x29, 0x3f, 0x23, 0xa8, 0x7d, 0x3c, 0xb4,
	0x33, 0x0f, 0x9a, 0x72, 0x20, 0x34, 0xf3, 0x81, 0xf0, 0x55, 0x58, 0x18, 0xc9, 0xcd, 0xa4, 0xd6,
	0x5a, 0x9a, 0x6a, 0xb8, 0x52, 0x18, 0x0e, 0xf3, 0xfd, 0x20, 0x1c, 0xf7, 0x88, 0xd8, 0xee, 0x80,
	0x72, 0x0f, 0x7e, 0x1b, 0x0f, 0xa1, 0x76, 0x97, 0x89, 0xb8, 0x1c, 0x8c, 0x8a, 0x49, 0x21, 0xa9,
	0xc1, 0xfc, 0x90, 0xf4, 0x69, 0x57, 0xb0, 0x47, 0x54, 0xee, 0xf8, 0x5c, 0xe7, 0x85, 0x60, 0x60,
	0x9d, 0x3d, 0xa2, 0xf8, 0x14, 0x80, 0x34, 0xfa, 0x7c, 0x9b, 0xba, 0x95, 0x92, 0x9c, 0x28, 0xdd,
	0x37, 0x82, 0x01, 0xe3, 0x29, 0x82, 0x93, 0xe9, 0x7b, 0x8a, 0x21, 0x77, 0x05, 0xc5, 0x6d, 0x38,
	0x1a, 0x97, 0x87, 0x51, 0x51, 0x41, 0xf5, 0x52, 0x51, 0x81, 0x8e, 0xd8, 0x89, 0x95, 0xf1, 0x6b,
	0x70, 0xd8, 0xa5, 0x5f, 0xf8, 0xdd, 0x08, 0xd6, 0x9c, 0xc4, 0x3a, 0x14, 0x0c, 0xb7, 0xf7, 0xd0,
	0x36, 0x61, 0x31, 0x9e, 0xa0, 0xf9, 0x2a, 0x5c, 0x84, 0x83, 0x6a, 0x2b, 0x2d, 0x7a, 0x2d, 0x8f,
	0x4e, 0xbb, 0x1a, 0x04, 0x8e, 0x44, 0xf2, 0x2f, 0x33, 0x89, 0xf0, 0x5b, 0x00, 0xfb, 0x15, 0x54,
	0x20, 0xaa, 0xf3, 0x5b, 0xe1, 0x4f, 0xe3, 0x6b, 0x04, 0x8b, 0xf1, 0xfc, 0x53, 0xdb, 0xcc, 0xc2,
	0x9b, 0x4c, 0xaf, 0xd2, 0x54, 0xe9, 0x75, 0x0e, 0x16, 0xe3, 0xc5, 0x93, 0x5d, 0x34, 0xff, 0x22,
	0xc0, 0xfb, 0x69, 0x31, 0x31, 0x03, 0x5f, 0x01, 0x5d, 0x07, 0x5d, 0x77, 0xe4, 0x74, 0x99, 0x2d,
	0x2a, 0x73, 0xf5, 0x52, 0xe3, 0x40, 0xa7, 0xac, 0x46, 0x3f, 0x18, 0x39, 0xb7, 0x6d, 0x11, 0xa4,
	0xa2, 0xf6, 0x0a, 0x3c, 0x4a, 0xf5, 0x52, 0x90, 0x8a, 0x6a, 0x24, 0x30, 0xc7, 0x35, 0x3e, 0x30,
	0x85, 0xc6, 0xf1, 0x0a, 0xb0, 0x73, 0x2b, 0x80, 0x26, 0x2b, 0xc0, 0x87, 0xc5, 0xd8, 0x49, 0x75,
	0xde, 0x5f, 0x82, 0xe7, 0x15, 0x5a, 0x98, 0xed, 0xb9, 0xf1, 0x09, 0x7d, 0x0b, 0x27, 0xf7, 0x13,
	0x04, 0xf5, 0x7b, 0xdc, 0x66, 0x5b, 0xbb, 0x37, 0x82, 0xe5, 0x36, 0xb8, 0x5a, 0xe8, 0x06, 0x77,
	0xb7, 0x58, 0x3f, 0x2f, 0x13, 0x9b, 0x70, 0x74, 0x87, 0x7a, 0x82, 0x71, 0xb7, 0xeb, 0xf3, 0xae,
	0x8a, 0xae, 0xdc, 0xa2, 0xd4, 0x39, 0xac, 0x0d, 0x1b, 0x5c, 0xe5, 0x1b, 0x3e, 0x0d, 0x0b, 0x9b,
	0xcc, 0x25, 0xde, 0x6e, 0xd7, 0x26, 0x3e, 0x91, 0xd9, 0x52, 0xee, 0x80, 0x1a, 0x5a, 0x25, 0x3e,
	0x31, 0x3e, 0x85, 0xd3, 0xfb, 0x67, 0x57, 0x7b, 0x7f, 0xa2, 0xd6, 0x10, 0x79, 0x0c, 0x67, 0xa0,
	0x1c, 0xc4, 0x59, 0x6f, 0x27, 0xf4, 0x3b, 0x67, 0xc1, 0x1d, 0x39, 0xe1, 0x6c, 0x63, 0x00, 0xf5,
	0xec, 0x95, 0xb5, 0xc4, 0xb7, 0xf6, 0xb2, 0xa6, 0x27, 0x1d, 0x42, 0xa5, 0xcf, 0xe4, 0x28, 0xad,
	0x05, 0x3a, 0x64, 0x47, 0x9e, 0x84, 0x71, 0x17, 0x4e, 0xec, 0xef, 0xb6, 0xee, 0x13, 0x9f, 0xe6,
	0xf2, 0x9f, 0x02, 0x08, 0xf8, 0x85, 0x74, 0xd4, 0xf4, 0xf3, 0xee, 0xc8, 0x51, 0x33, 0x0d, 0x02,
	0x95, 0xf1, 0xd5, 0x34, 0xf3, 0x4d, 0xd0, 0x5b, 0x87, 0xb3, 0x15, 0x72, 0x3d, 0x07, 0x59, 0xae,
	0x10, 0x96, 0x82, 0x5a, 0x6e, 0xe5, 0xd9, 0x31, 0x38, 0xa4, 0xac, 0xf7, 0x54, 0xa3, 0x81, 0x7f,
	0x45, 0xb0, 0x94, 0x76, 0x1f, 0xe3, 0x0b, 0xa9, 0x4b, 0xe7, 0x5c, 0xdd, 0xd5, 0x22, 0xef, 0x65,
	0x63, 0xed, 0xab, 0x3f, 0xff, 0xf9, 0x6e, 0xee, 0x3d, 0xc3, 0x0c, 0x1a, 0x8b, 0x2f, 0x55, 0x1d,
	0xbf, 0x3d, 0xf4, 0xf8, 0x03, 0xda, 0xf3, 0x85, 0xd5, 0xb4, 0x06, 0xbc, 0xa7, 0xfa, 0x19, 0xab,
	0xf9, 0xd8, 0xda, 0x7f, 0xf5, 0xb7, 0x92, 0x97, 0x25, 0xfe, 0x01, 0xc1, 0xd1, 0xb1, 0x3b, 0x1c,
	0x9f, 0x4f, 0x65, 0xc8, 0xba, 0xeb, 0x8b, 0x21, 0x5f, 0x96, 0xc8, 0x17, 0xb0, 0x42, 0x0e, 0x22,
	0x99, 0x01, 0x1c, 0xe1, 0xb5, 0x9a, 0x8f, 0xf1, 0x1f, 0x08, 0x96, 0xd2, 0x3a, 0x80, 0x0c, 0x69,
	0x73, 0x9a, 0x85, 0x62, 0x9c, 0xf7, 0x25, 0xe7, 0x47, 0x2b, 0xef, 0x48, 0xce, 0x84, 0x5e, 0x66,
	0x61, 0xee, 0x71, 0xa9, 0x9f, 0x22, 0x58, 0x4a, 0x6b, 0x7f, 0x32, 0x0e, 0x92, 0xd3, 0x29, 0x55,
	0x8f, 0x8f, 0xbd, 0x58, 0x6f, 0x06, 0xed, 0x63, 0xa8, 0x71, 0x73, 0x5a, 0x8d, 0x7f, 0x41, 0xb0,
	0x94, 0xd6, 0x47, 0x64, 0xa0, 0xe5, 0xb4, 0x39, 0xd5, 0xe5, 0x29, 0x66, 0xa8, 0xaa, 0x4c, 0x64,
	0x46, 0xe1, 0x64, 0x0e, 0x72, 0xb7, 0x1c, 0xad, 0x24, 0xdc, 0x28, 0x50, 0x6c, 0x8a, 0x32, 0xef,
	0x3a, 0x30, 0x6e, 0x49, 0x9e, 0xeb, 0xc6, 0x95, 0xc9, 0x3c, 0x71, 0x1d, 0xf5, 0xdf, 0x0f, 0xd1,
	0x0a, 0x2f, 0xfc, 0x6f, 0x10, 0xcc, 0xef, 0x55, 0x0d, 0x7e, 0x75, 0x52, 0x55, 0x15, 0x60, 0x7b,
	0x57, 0xb2, 0xb5, 0xf0, 0x95, 0xa9, 0x22, 0x1c, 0x82, 0x05, 0xb1, 0xfe, 0x09, 0x41, 0x39, 0x5a,
	0x24, 0x19, 0xaa, 0xa5, 0x34, 0x3d, 0xf9, 0x64, 0x1f, 0x4a, 0xb2, 0xdb, 0x2b, 0xd7, 0x22, 0x75,
	0x63, 0xce, 0x00, 0xb8, 0x27, 0xde, 0xb7, 0x08, 0xca, 0xd1, 0x22, 0xc8, 0x00, 0x4d, 0x69, 0x8a,
	0x32, 0xeb, 0x43, 0xab, 0xd7, 0x9c, 0x5d, 0xbd, 0x1f, 0x11, 0x2c, 0x44, 0x1a, 0x0e, 0xfc, 0xfa,
	0x84, 0x74, 0xdf, 0xab, 0x8b, 0xc6, 0x64, 0x47, 0x5d, 0x0e, 0xf1, 0x10, 0xcf, 0x90, 0x7e, 0xf8,
	0x2f, 0x04, 0x2f, 0x65, 0xb6, 0x27, 0xf8, 0x52, 0x2a, 0xc9, 0xa4, 0x76, 0xa6, 0x3a, 0xf9, 0x5e,
	0x37, 0x3e, 0x97, 0xe4, 0xf7, 0x8d, 0xce, 0xac, 0xf2, 0xb6, 0x9c, 0x2c, 0x8a, 0x16, 0x6a, 0xe2,
	0xbf, 0x51, 0xf4, 0x6a, 0x8f, 0xb7, 0x25, 0xf8, 0xcd, 0x09, 0xfa, 0xa6, 0xf6, 0x47, 0xd5, 0x4b,
	0x53, 0xce, 0xd2, 0x21, 0xd2, 0xb9, 0x8e, 0xd7, 0x66, 0x3d, 0xa8, 0xd5, 0x8b, 0xd3, 0xff, 0x86,
	0xe0, 0x48, 0xb2, 0x6b, 0xc1, 0x6f, 0x4c, 0x80, 0x8b, 0xb5, 0x4a, 0xd5, 0xf3, 0x05, 0xbd, 0xf5,
	0x11, 0x74, 0x07, 0x81, 0xaf, 0xcd, 0x7c, 0x04, 0xd5, 0x42, 0xe1, 0xef, 0x11, 0x94, 0xd7, 0xa9,
	0x7f, 0x9b, 0x38, 0x6d, 0xf9, 0x81, 0x03, 0x1b, 0x21, 0x08, 0x23, 0x4e, 0x80, 0x10, 0x35, 0x86,
	0xb0, 0xc7, 0x12, 0x3e, 0xca, 0x6a, 0xdc, 0x91, 0x50, 0xab, 0x86, 0x82, 0x0a, 0xbf, 0xb7, 0x14,
	0xbb, 0x6f, 0x45, 0x64, 0x9b, 0x20, 0x5b, 0x02, 0xae, 0xb5, 0x3c, 0xae, 0xb5, 0xff, 0x87, 0xab,
	0x9f, 0xe0, 0xfa, 0x1d, 0x01, 0xde, 0xa0, 0x42, 0x0e, 0x52, 0xcf, 0x61, 0x42, 0x65, 0x40, 0x23,
	0xb1, 0xf3, 0xb8, 0x4b, 0xc8, 0x78, 0xae, 0x80, 0xa7, 0x0e, 0x72, 0x5b, 0x72, 0xdf, 0x31, 0x6e,
	0xce, 0xc0, 0xed, 0x8f, 0x2d, 0xdb, 0x42, 0xcd, 0xeb, 0x0f, 0xe0, 0x44, 0x8f, 0x3b, 0x69, 0xa9,
	0x76, 0x1d, 0xc7, 0x5a, 0xe2, 0x76, 0xf0, 0xe6, 0x6d, 0xa3, 0xcf, 0x2e, 0x6b, 0xd7, 0x3e, 0x1f,
	0x10, 0xb7, 0x6f, 0x72, 0xaf, 0x6f, 0xf5, 0xa9, 0x2b, 0xdf, 0xcb, 0x96, 0x32, 0x91, 0x21, 0x13,
	0xb1, 0x0f, 0x6d, 0x57, 0x19, 0xf7, 0x9f, 0x21, 0xb4, 0x79, 0x50, 0x7a, 0x5d, 0xfc, 0x2f, 0x00,
	0x00, 0xff, 0xff, 0xe6, 0xf2, 0xe0, 0x78, 0xea, 0x13, 0x00, 0x00,
}
