/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.ValidationReport;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HtmlValidationReport
implements ValidationReport {
    static Logger logger = Logger.getLogger(ValidationReport.class);
    private StringBuffer sb = new StringBuffer();
    private int indent;
    private int errCount;
    private boolean ended;
    private HttpServletResponse resp;

    public HtmlValidationReport(HttpServletResponse httpServletResponse) {
        this.resp = httpServletResponse;
        this.sb.append("<?xml version='1.0' standalone='yes'?><div xmlns='http://www.w3.org/1999/xhtml'>");
        String string = Package.getPackage("org.probatron.officeotron").getImplementationVersion();
        this.sb.append("<div class='meta'>Beginning validation using <a href='http://code.google.com/p/officeotron/'>Office-o-tron</a> <span class='officeotron-version'>" + string + "</span> at <span class='timestamp'>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "</span></div>");
    }

    @Override
    public void addComment(String string) {
        this.addComment("INFO", string);
    }

    @Override
    public void addComment(String string, String string2) {
        this.sb.append("<div class='" + string + "'>");
        for (int i = 0; i < this.indent * 5; ++i) {
            this.sb.append("&#160;");
        }
        this.sb.append(string2);
        this.sb.append("</div>");
    }

    @Override
    public void decIndent() {
        --this.indent;
    }

    @Override
    public void endReport() {
        if (this.ended) {
            throw new IllegalStateException("endReport() already called");
        }
        this.ended = true;
        this.sb.append("</div>");
    }

    @Override
    public int getErrCount() {
        return this.errCount;
    }

    @Override
    public void incErrs() {
        ++this.errCount;
    }

    @Override
    public void incIndent() {
        ++this.indent;
    }

    @Override
    public void streamOut() throws IOException {
        if (!this.ended) {
            throw new IllegalStateException("endReport() not called");
        }
        byte[] byArray = this.sb.toString().getBytes("us-ascii");
        this.resp.setContentLength(byArray.length);
        this.resp.setContentType("application/xml");
        this.resp.setHeader("Cache-Control", "no-cache");
        this.resp.setCharacterEncoding("utf-8");
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.parse(new InputSource(new ByteArrayInputStream(byArray)));
        }
        catch (SAXException sAXException) {
            logger.fatal("Validation report is not conformant XML");
        }
        this.streamOut(byArray, (OutputStream)this.resp.getOutputStream());
    }

    private void streamOut(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Utils.transferBytesToEndOfStream(byteArrayInputStream, outputStream, 17);
    }
}

