//========================================================================
//
// annot_stamp_final.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_FINAL_H
#define ANNOT_STAMP_FINAL_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"

static const double ANNOT_STAMP_FINAL_WIDTH = 79.758179;
static const double ANNOT_STAMP_FINAL_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_FINAL = "1 0 0 -1 0 26.484741 cm\n"
                                       "q\n"
                                       "1 1 1 rg /a0 gs\n"
                                       "3.406 2.129 m 76.367 2.129 l 77.066 2.129 77.637 2.828 77.637 3.398 c 77.637\n"
                                       " 23.09 l 77.637 23.789 77.07 24.359 76.367 24.359 c 3.406 24.359 l 2.707\n"
                                       " 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703 2.129 \n"
                                       "3.406 2.129 c h\n"
                                       "3.406 2.129 m f\n"
                                       "0 0.298039 0.431373 rg /a1 gs\n"
                                       "1 1 1 RG 0.531496 w\n"
                                       "0 J\n"
                                       "0 j\n"
                                       "[] 0.0 d\n"
                                       "4 M q 1 0 0 1 0 0 cm\n"
                                       "18.043 7.926 m 18.043 12.691 l 25.922 12.691 l 25.922 15.184 l 18.043 15.18\n"
                                       " l 18.043 20.828 l 14.82 20.828 l 14.82 5.434 l 26.172 5.434 l 26.172 7.926\n"
                                       " l 18.043 7.926 l 28.566 6.875 m 28.566 4.613 l 31.637 4.613 l 31.637 6.875\n"
                                       " l 28.566 6.875 l 28.566 20.828 m 28.566 9.004 l 31.637 9.004 l 31.637 20.828\n"
                                       " l 28.566 20.828 l 42.434 20.828 m 42.434 14.195 l 42.434 13.738 42.398 \n"
                                       "13.316 42.324 12.938 c 42.25 12.551 42.133 12.223 41.965 11.953 c 41.797\n"
                                       " 11.676 41.578 11.461 41.309 11.309 c 41.039 11.156 40.711 11.078 40.324\n"
                                       " 11.078 c 39.953 11.078 39.613 11.16 39.309 11.328 c 39.012 11.488 38.75\n"
                                       " 11.723 38.531 12.027 c 38.312 12.324 38.141 12.688 38.02 13.109 c 37.902\n"
                                       " 13.523 37.844 13.984 37.844 14.484 c 37.844 20.82 l 34.773 20.82 l 34.773\n"
                                       " 11.641 l 34.773 11.387 34.77 11.125 34.762 10.855 c 34.762 10.586 34.754\n"
                                       " 10.332 34.738 10.09 c 34.73 9.844 34.723 9.625 34.715 9.434 c 34.707 9.238\n"
                                       " 34.695 9.09 34.684 8.996 c 37.613 8.996 l 37.629 9.082 37.641 9.227 37.656\n"
                                       " 9.422 c 37.672 9.609 37.684 9.824 37.699 10.055 c 37.715 10.289 37.727 \n"
                                       "10.52 37.73 10.754 c 37.746 10.988 37.754 11.184 37.754 11.344 c 37.797 \n"
                                       "11.344 l 38.211 10.441 38.734 9.785 39.359 9.375 c 39.984 8.969 40.734 8.762\n"
                                       " 41.598 8.762 c 42.312 8.762 42.914 8.879 43.402 9.113 c 43.898 9.348 44.297\n"
                                       " 9.668 44.605 10.074 c 44.918 10.48 45.145 10.965 45.281 11.516 c 45.418\n"
                                       " 12.07 45.488 12.668 45.488 13.309 c 45.488 20.816 l 42.434 20.828 l 51.188\n"
                                       " 21.047 m 50.621 21.047 50.109 20.969 49.656 20.816 c 49.211 20.656 48.832\n"
                                       " 20.426 48.52 20.129 c 48.207 19.824 47.965 19.449 47.797 19.004 c 47.629\n"
                                       " 18.559 47.547 18.055 47.547 17.484 c 47.547 16.785 47.668 16.199 47.906\n"
                                       " 15.727 c 48.152 15.246 48.488 14.859 48.91 14.566 c 49.332 14.27 49.828\n"
                                       " 14.055 50.395 13.922 c 50.961 13.785 51.566 13.711 52.207 13.703 c 54.754\n"
                                       " 13.66 l 54.754 13.059 l 54.754 12.629 54.715 12.273 54.633 11.988 c 54.559\n"
                                       " 11.695 54.449 11.461 54.305 11.277 c 54.16 11.094 53.977 10.969 53.758 \n"
                                       "10.895 c 53.547 10.812 53.301 10.773 53.027 10.773 c 52.773 10.773 52.543\n"
                                       " 10.801 52.34 10.852 c 52.145 10.902 51.973 10.992 51.828 11.125 c 51.684\n"
                                       " 11.25 51.562 11.422 51.469 11.637 c 51.383 11.848 51.32 12.117 51.281 12.445\n"
                                       " c 48.078 12.293 l 48.164 11.777 48.324 11.305 48.559 10.883 c 48.793 10.453\n"
                                       " 49.113 10.082 49.52 9.77 c 49.934 9.457 50.441 9.215 51.039 9.047 c 51.645\n"
                                       " 8.871 52.352 8.785 53.16 8.785 c 53.895 8.785 54.551 8.875 55.129 9.059\n"
                                       " c 55.703 9.242 56.191 9.516 56.594 9.879 c 56.996 10.234 57.301 10.676 \n"
                                       "57.512 11.199 c 57.723 11.723 57.828 12.332 57.828 13.023 c 57.828 17.328\n"
                                       " l 57.828 17.605 57.84 17.852 57.859 18.07 c 57.887 18.289 57.938 18.477\n"
                                       " 58 18.629 c 58.074 18.773 58.172 18.887 58.297 18.969 c 58.43 19.043 58.594\n"
                                       " 19.078 58.801 19.078 c 59.035 19.078 59.258 19.055 59.477 19.012 c 59.477\n"
                                       " 20.672 l 59.293 20.715 59.129 20.754 58.984 20.793 c 58.84 20.828 58.691\n"
                                       " 20.859 58.547 20.879 c 58.402 20.902 58.246 20.918 58.078 20.934 c 57.918\n"
                                       " 20.949 57.727 20.957 57.512 20.957 c 56.738 20.957 56.168 20.77 55.797 \n"
                                       "20.391 c 55.434 20.012 55.215 19.453 55.141 18.719 c 55.074 18.719 l 54.668\n"
                                       " 19.453 54.141 20.027 53.5 20.434 c 52.867 20.84 52.094 21.047 51.184 21.047\n"
                                       " c 54.758 15.355 m 53.184 15.379 l 52.855 15.395 52.543 15.422 52.242 15.465\n"
                                       " c 51.949 15.5 51.691 15.586 51.465 15.715 c 51.246 15.84 51.07 16.02 50.941\n"
                                       " 16.262 c 50.809 16.504 50.746 16.828 50.746 17.246 c 50.746 17.809 50.875\n"
                                       " 18.227 51.129 18.504 c 51.391 18.773 51.738 18.906 52.168 18.906 c 52.562\n"
                                       " 18.906 52.918 18.824 53.238 18.656 c 53.559 18.488 53.828 18.27 54.047 \n"
                                       "18 c 54.273 17.723 54.449 17.406 54.57 17.051 c 54.695 16.695 54.758 16.328\n"
                                       " 54.758 15.957 c 54.758 15.355 l 60.91 20.828 m 60.91 4.613 l 63.98 4.613\n"
                                       " l 63.98 20.828 l 60.91 20.828 l B Q\n"
                                       "Q q\n"
                                       "0 0.298039 0.431373 rg /a1 gs\n"
                                       "1 1 1 RG 0.797243 w\n"
                                       "1 J\n"
                                       "1 j\n"
                                       "[] 0.0 d\n"
                                       "4 M q 1 0 0 1 0 0 cm\n"
                                       "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                       "24.715 1.77 26.086 3.398 26.086 c 76.359 26.086 l 77.988 26.086 79.359 24.715\n"
                                       " 79.359 23.086 c 79.359 3.398 l 79.359 1.77 77.988 0.398 76.359 0.398 c \n"
                                       "h\n"
                                       "3.867 3.844 m 75.914 3.844 l 75.914 22.617 l 3.867 22.617 l h\n"
                                       "3.867 3.844 m B Q\n"
                                       "Q\n";

static Dict *getFinalStampExtGStateDict(PDFDoc *doc)
{
    Dict *a0Dict = new Dict(doc->getXRef());
    a0Dict->add("CA", Object(0.588235));
    a0Dict->add("ca", Object(0.588235));

    Dict *a1Dict = new Dict(doc->getXRef());
    a1Dict->add("CA", Object(1));
    a1Dict->add("ca", Object(1));

    Dict *extGStateDict = new Dict(doc->getXRef());
    extGStateDict->add("a0", Object(a0Dict));
    extGStateDict->add("a1", Object(a1Dict));

    return extGStateDict;
}

#endif
