#line 2 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2021, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "parser/gramparse.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "mb/pg_wchar.h"

#line 45 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 64
#define YY_END_OF_BUFFER 65
struct yy_trans_info
	{
	flex_int16_t yy_verify;
	flex_int16_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[20495] =
    {
 {   0,   0 }, {   0,20239 }, {   0,   0 }, {   0,20237 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6192 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6667 }, {  49,6667 }, {  50,6667 }, {  51,6667 },
 {  52,6667 }, {  53,6667 }, {  54,6667 }, {  55,6667 }, {  56,6667 },
 {  57,6667 }, {  58,6219 }, {  59,6216 }, {  60,6732 }, {  61,6743 },
 {  62,6810 }, {  63,6241 }, {  64,6241 }, {  65,6842 }, {  66,7099 },
 {  67,6842 }, {  68,6842 }, {  69,7356 }, {  70,6842 }, {  71,6842 },
 {  72,6842 }, {  73,6842 }, {  74,6842 }, {  75,6842 }, {  76,6842 },
 {  77,6842 }, {  78,7613 }, {  79,6842 }, {  80,6842 }, {  81,6842 },
 {  82,6842 }, {  83,6842 }, {  84,6842 }, {  85,7870 }, {  86,6842 },
 {  87,6842 }, {  88,8127 }, {  89,6842 }, {  90,6842 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,6842 }, {  96,6241 },

 {  97,6842 }, {  98,7099 }, {  99,6842 }, { 100,6842 }, { 101,7356 },
 { 102,6842 }, { 103,6842 }, { 104,6842 }, { 105,6842 }, { 106,6842 },
 { 107,6842 }, { 108,6842 }, { 109,6842 }, { 110,7613 }, { 111,6842 },
 { 112,6842 }, { 113,6842 }, { 114,6842 }, { 115,6842 }, { 116,6842 },
 { 117,7870 }, { 118,6842 }, { 119,6842 }, { 120,8127 }, { 121,6842 },
 { 122,6842 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,6842 }, { 129,6842 }, { 130,6842 }, { 131,6842 },
 { 132,6842 }, { 133,6842 }, { 134,6842 }, { 135,6842 }, { 136,6842 },
 { 137,6842 }, { 138,6842 }, { 139,6842 }, { 140,6842 }, { 141,6842 },
 { 142,6842 }, { 143,6842 }, { 144,6842 }, { 145,6842 }, { 146,6842 },

 { 147,6842 }, { 148,6842 }, { 149,6842 }, { 150,6842 }, { 151,6842 },
 { 152,6842 }, { 153,6842 }, { 154,6842 }, { 155,6842 }, { 156,6842 },
 { 157,6842 }, { 158,6842 }, { 159,6842 }, { 160,6842 }, { 161,6842 },
 { 162,6842 }, { 163,6842 }, { 164,6842 }, { 165,6842 }, { 166,6842 },
 { 167,6842 }, { 168,6842 }, { 169,6842 }, { 170,6842 }, { 171,6842 },
 { 172,6842 }, { 173,6842 }, { 174,6842 }, { 175,6842 }, { 176,6842 },
 { 177,6842 }, { 178,6842 }, { 179,6842 }, { 180,6842 }, { 181,6842 },
 { 182,6842 }, { 183,6842 }, { 184,6842 }, { 185,6842 }, { 186,6842 },
 { 187,6842 }, { 188,6842 }, { 189,6842 }, { 190,6842 }, { 191,6842 },
 { 192,6842 }, { 193,6842 }, { 194,6842 }, { 195,6842 }, { 196,6842 },

 { 197,6842 }, { 198,6842 }, { 199,6842 }, { 200,6842 }, { 201,6842 },
 { 202,6842 }, { 203,6842 }, { 204,6842 }, { 205,6842 }, { 206,6842 },
 { 207,6842 }, { 208,6842 }, { 209,6842 }, { 210,6842 }, { 211,6842 },
 { 212,6842 }, { 213,6842 }, { 214,6842 }, { 215,6842 }, { 216,6842 },
 { 217,6842 }, { 218,6842 }, { 219,6842 }, { 220,6842 }, { 221,6842 },
 { 222,6842 }, { 223,6842 }, { 224,6842 }, { 225,6842 }, { 226,6842 },
 { 227,6842 }, { 228,6842 }, { 229,6842 }, { 230,6842 }, { 231,6842 },
 { 232,6842 }, { 233,6842 }, { 234,6842 }, { 235,6842 }, { 236,6842 },
 { 237,6842 }, { 238,6842 }, { 239,6842 }, { 240,6842 }, { 241,6842 },
 { 242,6842 }, { 243,6842 }, { 244,6842 }, { 245,6842 }, { 246,6842 },

 { 247,6842 }, { 248,6842 }, { 249,6842 }, { 250,6842 }, { 251,6842 },
 { 252,6842 }, { 253,6842 }, { 254,6842 }, { 255,6842 }, { 256,6192 },
 {   0,   0 }, {   0,19979 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5934 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6409 },
 {  49,6409 }, {  50,6409 }, {  51,6409 }, {  52,6409 }, {  53,6409 },
 {  54,6409 }, {  55,6409 }, {  56,6409 }, {  57,6409 }, {  58,5961 },
 {  59,5958 }, {  60,6474 }, {  61,6485 }, {  62,6552 }, {  63,5983 },
 {  64,5983 }, {  65,6584 }, {  66,6841 }, {  67,6584 }, {  68,6584 },
 {  69,7098 }, {  70,6584 }, {  71,6584 }, {  72,6584 }, {  73,6584 },
 {  74,6584 }, {  75,6584 }, {  76,6584 }, {  77,6584 }, {  78,7355 },
 {  79,6584 }, {  80,6584 }, {  81,6584 }, {  82,6584 }, {  83,6584 },
 {  84,6584 }, {  85,7612 }, {  86,6584 }, {  87,6584 }, {  88,7869 },

 {  89,6584 }, {  90,6584 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,6584 }, {  96,5983 }, {  97,6584 }, {  98,6841 },
 {  99,6584 }, { 100,6584 }, { 101,7098 }, { 102,6584 }, { 103,6584 },
 { 104,6584 }, { 105,6584 }, { 106,6584 }, { 107,6584 }, { 108,6584 },
 { 109,6584 }, { 110,7355 }, { 111,6584 }, { 112,6584 }, { 113,6584 },
 { 114,6584 }, { 115,6584 }, { 116,6584 }, { 117,7612 }, { 118,6584 },
 { 119,6584 }, { 120,7869 }, { 121,6584 }, { 122,6584 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,6584 },
 { 129,6584 }, { 130,6584 }, { 131,6584 }, { 132,6584 }, { 133,6584 },
 { 134,6584 }, { 135,6584 }, { 136,6584 }, { 137,6584 }, { 138,6584 },

 { 139,6584 }, { 140,6584 }, { 141,6584 }, { 142,6584 }, { 143,6584 },
 { 144,6584 }, { 145,6584 }, { 146,6584 }, { 147,6584 }, { 148,6584 },
 { 149,6584 }, { 150,6584 }, { 151,6584 }, { 152,6584 }, { 153,6584 },
 { 154,6584 }, { 155,6584 }, { 156,6584 }, { 157,6584 }, { 158,6584 },
 { 159,6584 }, { 160,6584 }, { 161,6584 }, { 162,6584 }, { 163,6584 },
 { 164,6584 }, { 165,6584 }, { 166,6584 }, { 167,6584 }, { 168,6584 },
 { 169,6584 }, { 170,6584 }, { 171,6584 }, { 172,6584 }, { 173,6584 },
 { 174,6584 }, { 175,6584 }, { 176,6584 }, { 177,6584 }, { 178,6584 },
 { 179,6584 }, { 180,6584 }, { 181,6584 }, { 182,6584 }, { 183,6584 },
 { 184,6584 }, { 185,6584 }, { 186,6584 }, { 187,6584 }, { 188,6584 },

 { 189,6584 }, { 190,6584 }, { 191,6584 }, { 192,6584 }, { 193,6584 },
 { 194,6584 }, { 195,6584 }, { 196,6584 }, { 197,6584 }, { 198,6584 },
 { 199,6584 }, { 200,6584 }, { 201,6584 }, { 202,6584 }, { 203,6584 },
 { 204,6584 }, { 205,6584 }, { 206,6584 }, { 207,6584 }, { 208,6584 },
 { 209,6584 }, { 210,6584 }, { 211,6584 }, { 212,6584 }, { 213,6584 },
 { 214,6584 }, { 215,6584 }, { 216,6584 }, { 217,6584 }, { 218,6584 },
 { 219,6584 }, { 220,6584 }, { 221,6584 }, { 222,6584 }, { 223,6584 },
 { 224,6584 }, { 225,6584 }, { 226,6584 }, { 227,6584 }, { 228,6584 },
 { 229,6584 }, { 230,6584 }, { 231,6584 }, { 232,6584 }, { 233,6584 },
 { 234,6584 }, { 235,6584 }, { 236,6584 }, { 237,6584 }, { 238,6584 },

 { 239,6584 }, { 240,6584 }, { 241,6584 }, { 242,6584 }, { 243,6584 },
 { 244,6584 }, { 245,6584 }, { 246,6584 }, { 247,6584 }, { 248,6584 },
 { 249,6584 }, { 250,6584 }, { 251,6584 }, { 252,6584 }, { 253,6584 },
 { 254,6584 }, { 255,6584 }, { 256,5934 }, {   0,  10 }, {   0,19721 },
 {   1,7868 }, {   2,7868 }, {   3,7868 }, {   4,7868 }, {   5,7868 },
 {   6,7868 }, {   7,7868 }, {   8,7868 }, {   9,7868 }, {  10,7868 },
 {  11,7868 }, {  12,7868 }, {  13,7868 }, {  14,7868 }, {  15,7868 },
 {  16,7868 }, {  17,7868 }, {  18,7868 }, {  19,7868 }, {  20,7868 },
 {  21,7868 }, {  22,7868 }, {  23,7868 }, {  24,7868 }, {  25,7868 },
 {  26,7868 }, {  27,7868 }, {  28,7868 }, {  29,7868 }, {  30,7868 },

 {  31,7868 }, {  32,7868 }, {  33,7868 }, {  34,7868 }, {  35,7868 },
 {  36,7868 }, {  37,7868 }, {  38,7868 }, {  39,5705 }, {  40,7868 },
 {  41,7868 }, {  42,7868 }, {  43,7868 }, {  44,7868 }, {  45,7868 },
 {  46,7868 }, {  47,7868 }, {  48,7868 }, {  49,7868 }, {  50,7868 },
 {  51,7868 }, {  52,7868 }, {  53,7868 }, {  54,7868 }, {  55,7868 },
 {  56,7868 }, {  57,7868 }, {  58,7868 }, {  59,7868 }, {  60,7868 },
 {  61,7868 }, {  62,7868 }, {  63,7868 }, {  64,7868 }, {  65,7868 },
 {  66,7868 }, {  67,7868 }, {  68,7868 }, {  69,7868 }, {  70,7868 },
 {  71,7868 }, {  72,7868 }, {  73,7868 }, {  74,7868 }, {  75,7868 },
 {  76,7868 }, {  77,7868 }, {  78,7868 }, {  79,7868 }, {  80,7868 },

 {  81,7868 }, {  82,7868 }, {  83,7868 }, {  84,7868 }, {  85,7868 },
 {  86,7868 }, {  87,7868 }, {  88,7868 }, {  89,7868 }, {  90,7868 },
 {  91,7868 }, {  92,7868 }, {  93,7868 }, {  94,7868 }, {  95,7868 },
 {  96,7868 }, {  97,7868 }, {  98,7868 }, {  99,7868 }, { 100,7868 },
 { 101,7868 }, { 102,7868 }, { 103,7868 }, { 104,7868 }, { 105,7868 },
 { 106,7868 }, { 107,7868 }, { 108,7868 }, { 109,7868 }, { 110,7868 },
 { 111,7868 }, { 112,7868 }, { 113,7868 }, { 114,7868 }, { 115,7868 },
 { 116,7868 }, { 117,7868 }, { 118,7868 }, { 119,7868 }, { 120,7868 },
 { 121,7868 }, { 122,7868 }, { 123,7868 }, { 124,7868 }, { 125,7868 },
 { 126,7868 }, { 127,7868 }, { 128,7868 }, { 129,7868 }, { 130,7868 },

 { 131,7868 }, { 132,7868 }, { 133,7868 }, { 134,7868 }, { 135,7868 },
 { 136,7868 }, { 137,7868 }, { 138,7868 }, { 139,7868 }, { 140,7868 },
 { 141,7868 }, { 142,7868 }, { 143,7868 }, { 144,7868 }, { 145,7868 },
 { 146,7868 }, { 147,7868 }, { 148,7868 }, { 149,7868 }, { 150,7868 },
 { 151,7868 }, { 152,7868 }, { 153,7868 }, { 154,7868 }, { 155,7868 },
 { 156,7868 }, { 157,7868 }, { 158,7868 }, { 159,7868 }, { 160,7868 },
 { 161,7868 }, { 162,7868 }, { 163,7868 }, { 164,7868 }, { 165,7868 },
 { 166,7868 }, { 167,7868 }, { 168,7868 }, { 169,7868 }, { 170,7868 },
 { 171,7868 }, { 172,7868 }, { 173,7868 }, { 174,7868 }, { 175,7868 },
 { 176,7868 }, { 177,7868 }, { 178,7868 }, { 179,7868 }, { 180,7868 },

 { 181,7868 }, { 182,7868 }, { 183,7868 }, { 184,7868 }, { 185,7868 },
 { 186,7868 }, { 187,7868 }, { 188,7868 }, { 189,7868 }, { 190,7868 },
 { 191,7868 }, { 192,7868 }, { 193,7868 }, { 194,7868 }, { 195,7868 },
 { 196,7868 }, { 197,7868 }, { 198,7868 }, { 199,7868 }, { 200,7868 },
 { 201,7868 }, { 202,7868 }, { 203,7868 }, { 204,7868 }, { 205,7868 },
 { 206,7868 }, { 207,7868 }, { 208,7868 }, { 209,7868 }, { 210,7868 },
 { 211,7868 }, { 212,7868 }, { 213,7868 }, { 214,7868 }, { 215,7868 },
 { 216,7868 }, { 217,7868 }, { 218,7868 }, { 219,7868 }, { 220,7868 },
 { 221,7868 }, { 222,7868 }, { 223,7868 }, { 224,7868 }, { 225,7868 },
 { 226,7868 }, { 227,7868 }, { 228,7868 }, { 229,7868 }, { 230,7868 },

 { 231,7868 }, { 232,7868 }, { 233,7868 }, { 234,7868 }, { 235,7868 },
 { 236,7868 }, { 237,7868 }, { 238,7868 }, { 239,7868 }, { 240,7868 },
 { 241,7868 }, { 242,7868 }, { 243,7868 }, { 244,7868 }, { 245,7868 },
 { 246,7868 }, { 247,7868 }, { 248,7868 }, { 249,7868 }, { 250,7868 },
 { 251,7868 }, { 252,7868 }, { 253,7868 }, { 254,7868 }, { 255,7868 },
 { 256,7868 }, {   0,  10 }, {   0,19463 }, {   1,7610 }, {   2,7610 },
 {   3,7610 }, {   4,7610 }, {   5,7610 }, {   6,7610 }, {   7,7610 },
 {   8,7610 }, {   9,7610 }, {  10,7610 }, {  11,7610 }, {  12,7610 },
 {  13,7610 }, {  14,7610 }, {  15,7610 }, {  16,7610 }, {  17,7610 },
 {  18,7610 }, {  19,7610 }, {  20,7610 }, {  21,7610 }, {  22,7610 },

 {  23,7610 }, {  24,7610 }, {  25,7610 }, {  26,7610 }, {  27,7610 },
 {  28,7610 }, {  29,7610 }, {  30,7610 }, {  31,7610 }, {  32,7610 },
 {  33,7610 }, {  34,7610 }, {  35,7610 }, {  36,7610 }, {  37,7610 },
 {  38,7610 }, {  39,5447 }, {  40,7610 }, {  41,7610 }, {  42,7610 },
 {  43,7610 }, {  44,7610 }, {  45,7610 }, {  46,7610 }, {  47,7610 },
 {  48,7610 }, {  49,7610 }, {  50,7610 }, {  51,7610 }, {  52,7610 },
 {  53,7610 }, {  54,7610 }, {  55,7610 }, {  56,7610 }, {  57,7610 },
 {  58,7610 }, {  59,7610 }, {  60,7610 }, {  61,7610 }, {  62,7610 },
 {  63,7610 }, {  64,7610 }, {  65,7610 }, {  66,7610 }, {  67,7610 },
 {  68,7610 }, {  69,7610 }, {  70,7610 }, {  71,7610 }, {  72,7610 },

 {  73,7610 }, {  74,7610 }, {  75,7610 }, {  76,7610 }, {  77,7610 },
 {  78,7610 }, {  79,7610 }, {  80,7610 }, {  81,7610 }, {  82,7610 },
 {  83,7610 }, {  84,7610 }, {  85,7610 }, {  86,7610 }, {  87,7610 },
 {  88,7610 }, {  89,7610 }, {  90,7610 }, {  91,7610 }, {  92,7610 },
 {  93,7610 }, {  94,7610 }, {  95,7610 }, {  96,7610 }, {  97,7610 },
 {  98,7610 }, {  99,7610 }, { 100,7610 }, { 101,7610 }, { 102,7610 },
 { 103,7610 }, { 104,7610 }, { 105,7610 }, { 106,7610 }, { 107,7610 },
 { 108,7610 }, { 109,7610 }, { 110,7610 }, { 111,7610 }, { 112,7610 },
 { 113,7610 }, { 114,7610 }, { 115,7610 }, { 116,7610 }, { 117,7610 },
 { 118,7610 }, { 119,7610 }, { 120,7610 }, { 121,7610 }, { 122,7610 },

 { 123,7610 }, { 124,7610 }, { 125,7610 }, { 126,7610 }, { 127,7610 },
 { 128,7610 }, { 129,7610 }, { 130,7610 }, { 131,7610 }, { 132,7610 },
 { 133,7610 }, { 134,7610 }, { 135,7610 }, { 136,7610 }, { 137,7610 },
 { 138,7610 }, { 139,7610 }, { 140,7610 }, { 141,7610 }, { 142,7610 },
 { 143,7610 }, { 144,7610 }, { 145,7610 }, { 146,7610 }, { 147,7610 },
 { 148,7610 }, { 149,7610 }, { 150,7610 }, { 151,7610 }, { 152,7610 },
 { 153,7610 }, { 154,7610 }, { 155,7610 }, { 156,7610 }, { 157,7610 },
 { 158,7610 }, { 159,7610 }, { 160,7610 }, { 161,7610 }, { 162,7610 },
 { 163,7610 }, { 164,7610 }, { 165,7610 }, { 166,7610 }, { 167,7610 },
 { 168,7610 }, { 169,7610 }, { 170,7610 }, { 171,7610 }, { 172,7610 },

 { 173,7610 }, { 174,7610 }, { 175,7610 }, { 176,7610 }, { 177,7610 },
 { 178,7610 }, { 179,7610 }, { 180,7610 }, { 181,7610 }, { 182,7610 },
 { 183,7610 }, { 184,7610 }, { 185,7610 }, { 186,7610 }, { 187,7610 },
 { 188,7610 }, { 189,7610 }, { 190,7610 }, { 191,7610 }, { 192,7610 },
 { 193,7610 }, { 194,7610 }, { 195,7610 }, { 196,7610 }, { 197,7610 },
 { 198,7610 }, { 199,7610 }, { 200,7610 }, { 201,7610 }, { 202,7610 },
 { 203,7610 }, { 204,7610 }, { 205,7610 }, { 206,7610 }, { 207,7610 },
 { 208,7610 }, { 209,7610 }, { 210,7610 }, { 211,7610 }, { 212,7610 },
 { 213,7610 }, { 214,7610 }, { 215,7610 }, { 216,7610 }, { 217,7610 },
 { 218,7610 }, { 219,7610 }, { 220,7610 }, { 221,7610 }, { 222,7610 },

 { 223,7610 }, { 224,7610 }, { 225,7610 }, { 226,7610 }, { 227,7610 },
 { 228,7610 }, { 229,7610 }, { 230,7610 }, { 231,7610 }, { 232,7610 },
 { 233,7610 }, { 234,7610 }, { 235,7610 }, { 236,7610 }, { 237,7610 },
 { 238,7610 }, { 239,7610 }, { 240,7610 }, { 241,7610 }, { 242,7610 },
 { 243,7610 }, { 244,7610 }, { 245,7610 }, { 246,7610 }, { 247,7610 },
 { 248,7610 }, { 249,7610 }, { 250,7610 }, { 251,7610 }, { 252,7610 },
 { 253,7610 }, { 254,7610 }, { 255,7610 }, { 256,7610 }, {   0,   0 },
 {   0,19205 }, {   1,7610 }, {   2,7610 }, {   3,7610 }, {   4,7610 },
 {   5,7610 }, {   6,7610 }, {   7,7610 }, {   8,7610 }, {   9,7610 },
 {  10,7610 }, {  11,7610 }, {  12,7610 }, {  13,7610 }, {  14,7610 },

 {  15,7610 }, {  16,7610 }, {  17,7610 }, {  18,7610 }, {  19,7610 },
 {  20,7610 }, {  21,7610 }, {  22,7610 }, {  23,7610 }, {  24,7610 },
 {  25,7610 }, {  26,7610 }, {  27,7610 }, {  28,7610 }, {  29,7610 },
 {  30,7610 }, {  31,7610 }, {  32,7610 }, {  33,7868 }, {  34,7610 },
 {  35,7868 }, {  36,7610 }, {  37,7868 }, {  38,7868 }, {  39,7610 },
 {  40,7610 }, {  41,7610 }, {  42,5192 }, {  43,7868 }, {  44,7610 },
 {  45,7868 }, {  46,7610 }, {  47,5196 }, {  48,7610 }, {  49,7610 },
 {  50,7610 }, {  51,7610 }, {  52,7610 }, {  53,7610 }, {  54,7610 },
 {  55,7610 }, {  56,7610 }, {  57,7610 }, {  58,7610 }, {  59,7610 },
 {  60,7868 }, {  61,7868 }, {  62,7868 }, {  63,7868 }, {  64,7868 },

 {  65,7610 }, {  66,7610 }, {  67,7610 }, {  68,7610 }, {  69,7610 },
 {  70,7610 }, {  71,7610 }, {  72,7610 }, {  73,7610 }, {  74,7610 },
 {  75,7610 }, {  76,7610 }, {  77,7610 }, {  78,7610 }, {  79,7610 },
 {  80,7610 }, {  81,7610 }, {  82,7610 }, {  83,7610 }, {  84,7610 },
 {  85,7610 }, {  86,7610 }, {  87,7610 }, {  88,7610 }, {  89,7610 },
 {  90,7610 }, {  91,7610 }, {  92,7610 }, {  93,7610 }, {  94,7868 },
 {  95,7610 }, {  96,7868 }, {  97,7610 }, {  98,7610 }, {  99,7610 },
 { 100,7610 }, { 101,7610 }, { 102,7610 }, { 103,7610 }, { 104,7610 },
 { 105,7610 }, { 106,7610 }, { 107,7610 }, { 108,7610 }, { 109,7610 },
 { 110,7610 }, { 111,7610 }, { 112,7610 }, { 113,7610 }, { 114,7610 },

 { 115,7610 }, { 116,7610 }, { 117,7610 }, { 118,7610 }, { 119,7610 },
 { 120,7610 }, { 121,7610 }, { 122,7610 }, { 123,7610 }, { 124,7868 },
 { 125,7610 }, { 126,7868 }, { 127,7610 }, { 128,7610 }, { 129,7610 },
 { 130,7610 }, { 131,7610 }, { 132,7610 }, { 133,7610 }, { 134,7610 },
 { 135,7610 }, { 136,7610 }, { 137,7610 }, { 138,7610 }, { 139,7610 },
 { 140,7610 }, { 141,7610 }, { 142,7610 }, { 143,7610 }, { 144,7610 },
 { 145,7610 }, { 146,7610 }, { 147,7610 }, { 148,7610 }, { 149,7610 },
 { 150,7610 }, { 151,7610 }, { 152,7610 }, { 153,7610 }, { 154,7610 },
 { 155,7610 }, { 156,7610 }, { 157,7610 }, { 158,7610 }, { 159,7610 },
 { 160,7610 }, { 161,7610 }, { 162,7610 }, { 163,7610 }, { 164,7610 },

 { 165,7610 }, { 166,7610 }, { 167,7610 }, { 168,7610 }, { 169,7610 },
 { 170,7610 }, { 171,7610 }, { 172,7610 }, { 173,7610 }, { 174,7610 },
 { 175,7610 }, { 176,7610 }, { 177,7610 }, { 178,7610 }, { 179,7610 },
 { 180,7610 }, { 181,7610 }, { 182,7610 }, { 183,7610 }, { 184,7610 },
 { 185,7610 }, { 186,7610 }, { 187,7610 }, { 188,7610 }, { 189,7610 },
 { 190,7610 }, { 191,7610 }, { 192,7610 }, { 193,7610 }, { 194,7610 },
 { 195,7610 }, { 196,7610 }, { 197,7610 }, { 198,7610 }, { 199,7610 },
 { 200,7610 }, { 201,7610 }, { 202,7610 }, { 203,7610 }, { 204,7610 },
 { 205,7610 }, { 206,7610 }, { 207,7610 }, { 208,7610 }, { 209,7610 },
 { 210,7610 }, { 211,7610 }, { 212,7610 }, { 213,7610 }, { 214,7610 },

 { 215,7610 }, { 216,7610 }, { 217,7610 }, { 218,7610 }, { 219,7610 },
 { 220,7610 }, { 221,7610 }, { 222,7610 }, { 223,7610 }, { 224,7610 },
 { 225,7610 }, { 226,7610 }, { 227,7610 }, { 228,7610 }, { 229,7610 },
 { 230,7610 }, { 231,7610 }, { 232,7610 }, { 233,7610 }, { 234,7610 },
 { 235,7610 }, { 236,7610 }, { 237,7610 }, { 238,7610 }, { 239,7610 },
 { 240,7610 }, { 241,7610 }, { 242,7610 }, { 243,7610 }, { 244,7610 },
 { 245,7610 }, { 246,7610 }, { 247,7610 }, { 248,7610 }, { 249,7610 },
 { 250,7610 }, { 251,7610 }, { 252,7610 }, { 253,7610 }, { 254,7610 },
 { 255,7610 }, { 256,7610 }, {   0,   0 }, {   0,18947 }, {   1,7352 },
 {   2,7352 }, {   3,7352 }, {   4,7352 }, {   5,7352 }, {   6,7352 },

 {   7,7352 }, {   8,7352 }, {   9,7352 }, {  10,7352 }, {  11,7352 },
 {  12,7352 }, {  13,7352 }, {  14,7352 }, {  15,7352 }, {  16,7352 },
 {  17,7352 }, {  18,7352 }, {  19,7352 }, {  20,7352 }, {  21,7352 },
 {  22,7352 }, {  23,7352 }, {  24,7352 }, {  25,7352 }, {  26,7352 },
 {  27,7352 }, {  28,7352 }, {  29,7352 }, {  30,7352 }, {  31,7352 },
 {  32,7352 }, {  33,7610 }, {  34,7352 }, {  35,7610 }, {  36,7352 },
 {  37,7610 }, {  38,7610 }, {  39,7352 }, {  40,7352 }, {  41,7352 },
 {  42,4934 }, {  43,7610 }, {  44,7352 }, {  45,7610 }, {  46,7352 },
 {  47,4938 }, {  48,7352 }, {  49,7352 }, {  50,7352 }, {  51,7352 },
 {  52,7352 }, {  53,7352 }, {  54,7352 }, {  55,7352 }, {  56,7352 },

 {  57,7352 }, {  58,7352 }, {  59,7352 }, {  60,7610 }, {  61,7610 },
 {  62,7610 }, {  63,7610 }, {  64,7610 }, {  65,7352 }, {  66,7352 },
 {  67,7352 }, {  68,7352 }, {  69,7352 }, {  70,7352 }, {  71,7352 },
 {  72,7352 }, {  73,7352 }, {  74,7352 }, {  75,7352 }, {  76,7352 },
 {  77,7352 }, {  78,7352 }, {  79,7352 }, {  80,7352 }, {  81,7352 },
 {  82,7352 }, {  83,7352 }, {  84,7352 }, {  85,7352 }, {  86,7352 },
 {  87,7352 }, {  88,7352 }, {  89,7352 }, {  90,7352 }, {  91,7352 },
 {  92,7352 }, {  93,7352 }, {  94,7610 }, {  95,7352 }, {  96,7610 },
 {  97,7352 }, {  98,7352 }, {  99,7352 }, { 100,7352 }, { 101,7352 },
 { 102,7352 }, { 103,7352 }, { 104,7352 }, { 105,7352 }, { 106,7352 },

 { 107,7352 }, { 108,7352 }, { 109,7352 }, { 110,7352 }, { 111,7352 },
 { 112,7352 }, { 113,7352 }, { 114,7352 }, { 115,7352 }, { 116,7352 },
 { 117,7352 }, { 118,7352 }, { 119,7352 }, { 120,7352 }, { 121,7352 },
 { 122,7352 }, { 123,7352 }, { 124,7610 }, { 125,7352 }, { 126,7610 },
 { 127,7352 }, { 128,7352 }, { 129,7352 }, { 130,7352 }, { 131,7352 },
 { 132,7352 }, { 133,7352 }, { 134,7352 }, { 135,7352 }, { 136,7352 },
 { 137,7352 }, { 138,7352 }, { 139,7352 }, { 140,7352 }, { 141,7352 },
 { 142,7352 }, { 143,7352 }, { 144,7352 }, { 145,7352 }, { 146,7352 },
 { 147,7352 }, { 148,7352 }, { 149,7352 }, { 150,7352 }, { 151,7352 },
 { 152,7352 }, { 153,7352 }, { 154,7352 }, { 155,7352 }, { 156,7352 },

 { 157,7352 }, { 158,7352 }, { 159,7352 }, { 160,7352 }, { 161,7352 },
 { 162,7352 }, { 163,7352 }, { 164,7352 }, { 165,7352 }, { 166,7352 },
 { 167,7352 }, { 168,7352 }, { 169,7352 }, { 170,7352 }, { 171,7352 },
 { 172,7352 }, { 173,7352 }, { 174,7352 }, { 175,7352 }, { 176,7352 },
 { 177,7352 }, { 178,7352 }, { 179,7352 }, { 180,7352 }, { 181,7352 },
 { 182,7352 }, { 183,7352 }, { 184,7352 }, { 185,7352 }, { 186,7352 },
 { 187,7352 }, { 188,7352 }, { 189,7352 }, { 190,7352 }, { 191,7352 },
 { 192,7352 }, { 193,7352 }, { 194,7352 }, { 195,7352 }, { 196,7352 },
 { 197,7352 }, { 198,7352 }, { 199,7352 }, { 200,7352 }, { 201,7352 },
 { 202,7352 }, { 203,7352 }, { 204,7352 }, { 205,7352 }, { 206,7352 },

 { 207,7352 }, { 208,7352 }, { 209,7352 }, { 210,7352 }, { 211,7352 },
 { 212,7352 }, { 213,7352 }, { 214,7352 }, { 215,7352 }, { 216,7352 },
 { 217,7352 }, { 218,7352 }, { 219,7352 }, { 220,7352 }, { 221,7352 },
 { 222,7352 }, { 223,7352 }, { 224,7352 }, { 225,7352 }, { 226,7352 },
 { 227,7352 }, { 228,7352 }, { 229,7352 }, { 230,7352 }, { 231,7352 },
 { 232,7352 }, { 233,7352 }, { 234,7352 }, { 235,7352 }, { 236,7352 },
 { 237,7352 }, { 238,7352 }, { 239,7352 }, { 240,7352 }, { 241,7352 },
 { 242,7352 }, { 243,7352 }, { 244,7352 }, { 245,7352 }, { 246,7352 },
 { 247,7352 }, { 248,7352 }, { 249,7352 }, { 250,7352 }, { 251,7352 },
 { 252,7352 }, { 253,7352 }, { 254,7352 }, { 255,7352 }, { 256,7352 },

 {   0,   0 }, {   0,18689 }, {   1,7610 }, {   2,7610 }, {   3,7610 },
 {   4,7610 }, {   5,7610 }, {   6,7610 }, {   7,7610 }, {   8,7610 },
 {   9,7610 }, {  10,7610 }, {  11,7610 }, {  12,7610 }, {  13,7610 },
 {  14,7610 }, {  15,7610 }, {  16,7610 }, {  17,7610 }, {  18,7610 },
 {  19,7610 }, {  20,7610 }, {  21,7610 }, {  22,7610 }, {  23,7610 },
 {  24,7610 }, {  25,7610 }, {  26,7610 }, {  27,7610 }, {  28,7610 },
 {  29,7610 }, {  30,7610 }, {  31,7610 }, {  32,7610 }, {  33,7610 },
 {  34,4685 }, {  35,7610 }, {  36,7610 }, {  37,7610 }, {  38,7610 },
 {  39,7610 }, {  40,7610 }, {  41,7610 }, {  42,7610 }, {  43,7610 },
 {  44,7610 }, {  45,7610 }, {  46,7610 }, {  47,7610 }, {  48,7610 },

 {  49,7610 }, {  50,7610 }, {  51,7610 }, {  52,7610 }, {  53,7610 },
 {  54,7610 }, {  55,7610 }, {  56,7610 }, {  57,7610 }, {  58,7610 },
 {  59,7610 }, {  60,7610 }, {  61,7610 }, {  62,7610 }, {  63,7610 },
 {  64,7610 }, {  65,7610 }, {  66,7610 }, {  67,7610 }, {  68,7610 },
 {  69,7610 }, {  70,7610 }, {  71,7610 }, {  72,7610 }, {  73,7610 },
 {  74,7610 }, {  75,7610 }, {  76,7610 }, {  77,7610 }, {  78,7610 },
 {  79,7610 }, {  80,7610 }, {  81,7610 }, {  82,7610 }, {  83,7610 },
 {  84,7610 }, {  85,7610 }, {  86,7610 }, {  87,7610 }, {  88,7610 },
 {  89,7610 }, {  90,7610 }, {  91,7610 }, {  92,7610 }, {  93,7610 },
 {  94,7610 }, {  95,7610 }, {  96,7610 }, {  97,7610 }, {  98,7610 },

 {  99,7610 }, { 100,7610 }, { 101,7610 }, { 102,7610 }, { 103,7610 },
 { 104,7610 }, { 105,7610 }, { 106,7610 }, { 107,7610 }, { 108,7610 },
 { 109,7610 }, { 110,7610 }, { 111,7610 }, { 112,7610 }, { 113,7610 },
 { 114,7610 }, { 115,7610 }, { 116,7610 }, { 117,7610 }, { 118,7610 },
 { 119,7610 }, { 120,7610 }, { 121,7610 }, { 122,7610 }, { 123,7610 },
 { 124,7610 }, { 125,7610 }, { 126,7610 }, { 127,7610 }, { 128,7610 },
 { 129,7610 }, { 130,7610 }, { 131,7610 }, { 132,7610 }, { 133,7610 },
 { 134,7610 }, { 135,7610 }, { 136,7610 }, { 137,7610 }, { 138,7610 },
 { 139,7610 }, { 140,7610 }, { 141,7610 }, { 142,7610 }, { 143,7610 },
 { 144,7610 }, { 145,7610 }, { 146,7610 }, { 147,7610 }, { 148,7610 },

 { 149,7610 }, { 150,7610 }, { 151,7610 }, { 152,7610 }, { 153,7610 },
 { 154,7610 }, { 155,7610 }, { 156,7610 }, { 157,7610 }, { 158,7610 },
 { 159,7610 }, { 160,7610 }, { 161,7610 }, { 162,7610 }, { 163,7610 },
 { 164,7610 }, { 165,7610 }, { 166,7610 }, { 167,7610 }, { 168,7610 },
 { 169,7610 }, { 170,7610 }, { 171,7610 }, { 172,7610 }, { 173,7610 },
 { 174,7610 }, { 175,7610 }, { 176,7610 }, { 177,7610 }, { 178,7610 },
 { 179,7610 }, { 180,7610 }, { 181,7610 }, { 182,7610 }, { 183,7610 },
 { 184,7610 }, { 185,7610 }, { 186,7610 }, { 187,7610 }, { 188,7610 },
 { 189,7610 }, { 190,7610 }, { 191,7610 }, { 192,7610 }, { 193,7610 },
 { 194,7610 }, { 195,7610 }, { 196,7610 }, { 197,7610 }, { 198,7610 },

 { 199,7610 }, { 200,7610 }, { 201,7610 }, { 202,7610 }, { 203,7610 },
 { 204,7610 }, { 205,7610 }, { 206,7610 }, { 207,7610 }, { 208,7610 },
 { 209,7610 }, { 210,7610 }, { 211,7610 }, { 212,7610 }, { 213,7610 },
 { 214,7610 }, { 215,7610 }, { 216,7610 }, { 217,7610 }, { 218,7610 },
 { 219,7610 }, { 220,7610 }, { 221,7610 }, { 222,7610 }, { 223,7610 },
 { 224,7610 }, { 225,7610 }, { 226,7610 }, { 227,7610 }, { 228,7610 },
 { 229,7610 }, { 230,7610 }, { 231,7610 }, { 232,7610 }, { 233,7610 },
 { 234,7610 }, { 235,7610 }, { 236,7610 }, { 237,7610 }, { 238,7610 },
 { 239,7610 }, { 240,7610 }, { 241,7610 }, { 242,7610 }, { 243,7610 },
 { 244,7610 }, { 245,7610 }, { 246,7610 }, { 247,7610 }, { 248,7610 },

 { 249,7610 }, { 250,7610 }, { 251,7610 }, { 252,7610 }, { 253,7610 },
 { 254,7610 }, { 255,7610 }, { 256,7610 }, {   0,   0 }, {   0,18431 },
 {   1,7352 }, {   2,7352 }, {   3,7352 }, {   4,7352 }, {   5,7352 },
 {   6,7352 }, {   7,7352 }, {   8,7352 }, {   9,7352 }, {  10,7352 },
 {  11,7352 }, {  12,7352 }, {  13,7352 }, {  14,7352 }, {  15,7352 },
 {  16,7352 }, {  17,7352 }, {  18,7352 }, {  19,7352 }, {  20,7352 },
 {  21,7352 }, {  22,7352 }, {  23,7352 }, {  24,7352 }, {  25,7352 },
 {  26,7352 }, {  27,7352 }, {  28,7352 }, {  29,7352 }, {  30,7352 },
 {  31,7352 }, {  32,7352 }, {  33,7352 }, {  34,4427 }, {  35,7352 },
 {  36,7352 }, {  37,7352 }, {  38,7352 }, {  39,7352 }, {  40,7352 },

 {  41,7352 }, {  42,7352 }, {  43,7352 }, {  44,7352 }, {  45,7352 },
 {  46,7352 }, {  47,7352 }, {  48,7352 }, {  49,7352 }, {  50,7352 },
 {  51,7352 }, {  52,7352 }, {  53,7352 }, {  54,7352 }, {  55,7352 },
 {  56,7352 }, {  57,7352 }, {  58,7352 }, {  59,7352 }, {  60,7352 },
 {  61,7352 }, {  62,7352 }, {  63,7352 }, {  64,7352 }, {  65,7352 },
 {  66,7352 }, {  67,7352 }, {  68,7352 }, {  69,7352 }, {  70,7352 },
 {  71,7352 }, {  72,7352 }, {  73,7352 }, {  74,7352 }, {  75,7352 },
 {  76,7352 }, {  77,7352 }, {  78,7352 }, {  79,7352 }, {  80,7352 },
 {  81,7352 }, {  82,7352 }, {  83,7352 }, {  84,7352 }, {  85,7352 },
 {  86,7352 }, {  87,7352 }, {  88,7352 }, {  89,7352 }, {  90,7352 },

 {  91,7352 }, {  92,7352 }, {  93,7352 }, {  94,7352 }, {  95,7352 },
 {  96,7352 }, {  97,7352 }, {  98,7352 }, {  99,7352 }, { 100,7352 },
 { 101,7352 }, { 102,7352 }, { 103,7352 }, { 104,7352 }, { 105,7352 },
 { 106,7352 }, { 107,7352 }, { 108,7352 }, { 109,7352 }, { 110,7352 },
 { 111,7352 }, { 112,7352 }, { 113,7352 }, { 114,7352 }, { 115,7352 },
 { 116,7352 }, { 117,7352 }, { 118,7352 }, { 119,7352 }, { 120,7352 },
 { 121,7352 }, { 122,7352 }, { 123,7352 }, { 124,7352 }, { 125,7352 },
 { 126,7352 }, { 127,7352 }, { 128,7352 }, { 129,7352 }, { 130,7352 },
 { 131,7352 }, { 132,7352 }, { 133,7352 }, { 134,7352 }, { 135,7352 },
 { 136,7352 }, { 137,7352 }, { 138,7352 }, { 139,7352 }, { 140,7352 },

 { 141,7352 }, { 142,7352 }, { 143,7352 }, { 144,7352 }, { 145,7352 },
 { 146,7352 }, { 147,7352 }, { 148,7352 }, { 149,7352 }, { 150,7352 },
 { 151,7352 }, { 152,7352 }, { 153,7352 }, { 154,7352 }, { 155,7352 },
 { 156,7352 }, { 157,7352 }, { 158,7352 }, { 159,7352 }, { 160,7352 },
 { 161,7352 }, { 162,7352 }, { 163,7352 }, { 164,7352 }, { 165,7352 },
 { 166,7352 }, { 167,7352 }, { 168,7352 }, { 169,7352 }, { 170,7352 },
 { 171,7352 }, { 172,7352 }, { 173,7352 }, { 174,7352 }, { 175,7352 },
 { 176,7352 }, { 177,7352 }, { 178,7352 }, { 179,7352 }, { 180,7352 },
 { 181,7352 }, { 182,7352 }, { 183,7352 }, { 184,7352 }, { 185,7352 },
 { 186,7352 }, { 187,7352 }, { 188,7352 }, { 189,7352 }, { 190,7352 },

 { 191,7352 }, { 192,7352 }, { 193,7352 }, { 194,7352 }, { 195,7352 },
 { 196,7352 }, { 197,7352 }, { 198,7352 }, { 199,7352 }, { 200,7352 },
 { 201,7352 }, { 202,7352 }, { 203,7352 }, { 204,7352 }, { 205,7352 },
 { 206,7352 }, { 207,7352 }, { 208,7352 }, { 209,7352 }, { 210,7352 },
 { 211,7352 }, { 212,7352 }, { 213,7352 }, { 214,7352 }, { 215,7352 },
 { 216,7352 }, { 217,7352 }, { 218,7352 }, { 219,7352 }, { 220,7352 },
 { 221,7352 }, { 222,7352 }, { 223,7352 }, { 224,7352 }, { 225,7352 },
 { 226,7352 }, { 227,7352 }, { 228,7352 }, { 229,7352 }, { 230,7352 },
 { 231,7352 }, { 232,7352 }, { 233,7352 }, { 234,7352 }, { 235,7352 },
 { 236,7352 }, { 237,7352 }, { 238,7352 }, { 239,7352 }, { 240,7352 },

 { 241,7352 }, { 242,7352 }, { 243,7352 }, { 244,7352 }, { 245,7352 },
 { 246,7352 }, { 247,7352 }, { 248,7352 }, { 249,7352 }, { 250,7352 },
 { 251,7352 }, { 252,7352 }, { 253,7352 }, { 254,7352 }, { 255,7352 },
 { 256,7352 }, {   0,   9 }, {   0,18173 }, {   1,7352 }, {   2,7352 },
 {   3,7352 }, {   4,7352 }, {   5,7352 }, {   6,7352 }, {   7,7352 },
 {   8,7352 }, {   9,7352 }, {  10,7352 }, {  11,7352 }, {  12,7352 },
 {  13,7352 }, {  14,7352 }, {  15,7352 }, {  16,7352 }, {  17,7352 },
 {  18,7352 }, {  19,7352 }, {  20,7352 }, {  21,7352 }, {  22,7352 },
 {  23,7352 }, {  24,7352 }, {  25,7352 }, {  26,7352 }, {  27,7352 },
 {  28,7352 }, {  29,7352 }, {  30,7352 }, {  31,7352 }, {  32,7352 },

 {  33,7352 }, {  34,7352 }, {  35,7352 }, {  36,7352 }, {  37,7352 },
 {  38,7352 }, {  39,4157 }, {  40,7352 }, {  41,7352 }, {  42,7352 },
 {  43,7352 }, {  44,7352 }, {  45,7352 }, {  46,7352 }, {  47,7352 },
 {  48,7352 }, {  49,7352 }, {  50,7352 }, {  51,7352 }, {  52,7352 },
 {  53,7352 }, {  54,7352 }, {  55,7352 }, {  56,7352 }, {  57,7352 },
 {  58,7352 }, {  59,7352 }, {  60,7352 }, {  61,7352 }, {  62,7352 },
 {  63,7352 }, {  64,7352 }, {  65,7352 }, {  66,7352 }, {  67,7352 },
 {  68,7352 }, {  69,7352 }, {  70,7352 }, {  71,7352 }, {  72,7352 },
 {  73,7352 }, {  74,7352 }, {  75,7352 }, {  76,7352 }, {  77,7352 },
 {  78,7352 }, {  79,7352 }, {  80,7352 }, {  81,7352 }, {  82,7352 },

 {  83,7352 }, {  84,7352 }, {  85,7352 }, {  86,7352 }, {  87,7352 },
 {  88,7352 }, {  89,7352 }, {  90,7352 }, {  91,7352 }, {  92,7352 },
 {  93,7352 }, {  94,7352 }, {  95,7352 }, {  96,7352 }, {  97,7352 },
 {  98,7352 }, {  99,7352 }, { 100,7352 }, { 101,7352 }, { 102,7352 },
 { 103,7352 }, { 104,7352 }, { 105,7352 }, { 106,7352 }, { 107,7352 },
 { 108,7352 }, { 109,7352 }, { 110,7352 }, { 111,7352 }, { 112,7352 },
 { 113,7352 }, { 114,7352 }, { 115,7352 }, { 116,7352 }, { 117,7352 },
 { 118,7352 }, { 119,7352 }, { 120,7352 }, { 121,7352 }, { 122,7352 },
 { 123,7352 }, { 124,7352 }, { 125,7352 }, { 126,7352 }, { 127,7352 },
 { 128,7352 }, { 129,7352 }, { 130,7352 }, { 131,7352 }, { 132,7352 },

 { 133,7352 }, { 134,7352 }, { 135,7352 }, { 136,7352 }, { 137,7352 },
 { 138,7352 }, { 139,7352 }, { 140,7352 }, { 141,7352 }, { 142,7352 },
 { 143,7352 }, { 144,7352 }, { 145,7352 }, { 146,7352 }, { 147,7352 },
 { 148,7352 }, { 149,7352 }, { 150,7352 }, { 151,7352 }, { 152,7352 },
 { 153,7352 }, { 154,7352 }, { 155,7352 }, { 156,7352 }, { 157,7352 },
 { 158,7352 }, { 159,7352 }, { 160,7352 }, { 161,7352 }, { 162,7352 },
 { 163,7352 }, { 164,7352 }, { 165,7352 }, { 166,7352 }, { 167,7352 },
 { 168,7352 }, { 169,7352 }, { 170,7352 }, { 171,7352 }, { 172,7352 },
 { 173,7352 }, { 174,7352 }, { 175,7352 }, { 176,7352 }, { 177,7352 },
 { 178,7352 }, { 179,7352 }, { 180,7352 }, { 181,7352 }, { 182,7352 },

 { 183,7352 }, { 184,7352 }, { 185,7352 }, { 186,7352 }, { 187,7352 },
 { 188,7352 }, { 189,7352 }, { 190,7352 }, { 191,7352 }, { 192,7352 },
 { 193,7352 }, { 194,7352 }, { 195,7352 }, { 196,7352 }, { 197,7352 },
 { 198,7352 }, { 199,7352 }, { 200,7352 }, { 201,7352 }, { 202,7352 },
 { 203,7352 }, { 204,7352 }, { 205,7352 }, { 206,7352 }, { 207,7352 },
 { 208,7352 }, { 209,7352 }, { 210,7352 }, { 211,7352 }, { 212,7352 },
 { 213,7352 }, { 214,7352 }, { 215,7352 }, { 216,7352 }, { 217,7352 },
 { 218,7352 }, { 219,7352 }, { 220,7352 }, { 221,7352 }, { 222,7352 },
 { 223,7352 }, { 224,7352 }, { 225,7352 }, { 226,7352 }, { 227,7352 },
 { 228,7352 }, { 229,7352 }, { 230,7352 }, { 231,7352 }, { 232,7352 },

 { 233,7352 }, { 234,7352 }, { 235,7352 }, { 236,7352 }, { 237,7352 },
 { 238,7352 }, { 239,7352 }, { 240,7352 }, { 241,7352 }, { 242,7352 },
 { 243,7352 }, { 244,7352 }, { 245,7352 }, { 246,7352 }, { 247,7352 },
 { 248,7352 }, { 249,7352 }, { 250,7352 }, { 251,7352 }, { 252,7352 },
 { 253,7352 }, { 254,7352 }, { 255,7352 }, { 256,7352 }, {   0,   9 },
 {   0,17915 }, {   1,7094 }, {   2,7094 }, {   3,7094 }, {   4,7094 },
 {   5,7094 }, {   6,7094 }, {   7,7094 }, {   8,7094 }, {   9,7094 },
 {  10,7094 }, {  11,7094 }, {  12,7094 }, {  13,7094 }, {  14,7094 },
 {  15,7094 }, {  16,7094 }, {  17,7094 }, {  18,7094 }, {  19,7094 },
 {  20,7094 }, {  21,7094 }, {  22,7094 }, {  23,7094 }, {  24,7094 },

 {  25,7094 }, {  26,7094 }, {  27,7094 }, {  28,7094 }, {  29,7094 },
 {  30,7094 }, {  31,7094 }, {  32,7094 }, {  33,7094 }, {  34,7094 },
 {  35,7094 }, {  36,7094 }, {  37,7094 }, {  38,7094 }, {  39,3899 },
 {  40,7094 }, {  41,7094 }, {  42,7094 }, {  43,7094 }, {  44,7094 },
 {  45,7094 }, {  46,7094 }, {  47,7094 }, {  48,7094 }, {  49,7094 },
 {  50,7094 }, {  51,7094 }, {  52,7094 }, {  53,7094 }, {  54,7094 },
 {  55,7094 }, {  56,7094 }, {  57,7094 }, {  58,7094 }, {  59,7094 },
 {  60,7094 }, {  61,7094 }, {  62,7094 }, {  63,7094 }, {  64,7094 },
 {  65,7094 }, {  66,7094 }, {  67,7094 }, {  68,7094 }, {  69,7094 },
 {  70,7094 }, {  71,7094 }, {  72,7094 }, {  73,7094 }, {  74,7094 },

 {  75,7094 }, {  76,7094 }, {  77,7094 }, {  78,7094 }, {  79,7094 },
 {  80,7094 }, {  81,7094 }, {  82,7094 }, {  83,7094 }, {  84,7094 },
 {  85,7094 }, {  86,7094 }, {  87,7094 }, {  88,7094 }, {  89,7094 },
 {  90,7094 }, {  91,7094 }, {  92,7094 }, {  93,7094 }, {  94,7094 },
 {  95,7094 }, {  96,7094 }, {  97,7094 }, {  98,7094 }, {  99,7094 },
 { 100,7094 }, { 101,7094 }, { 102,7094 }, { 103,7094 }, { 104,7094 },
 { 105,7094 }, { 106,7094 }, { 107,7094 }, { 108,7094 }, { 109,7094 },
 { 110,7094 }, { 111,7094 }, { 112,7094 }, { 113,7094 }, { 114,7094 },
 { 115,7094 }, { 116,7094 }, { 117,7094 }, { 118,7094 }, { 119,7094 },
 { 120,7094 }, { 121,7094 }, { 122,7094 }, { 123,7094 }, { 124,7094 },

 { 125,7094 }, { 126,7094 }, { 127,7094 }, { 128,7094 }, { 129,7094 },
 { 130,7094 }, { 131,7094 }, { 132,7094 }, { 133,7094 }, { 134,7094 },
 { 135,7094 }, { 136,7094 }, { 137,7094 }, { 138,7094 }, { 139,7094 },
 { 140,7094 }, { 141,7094 }, { 142,7094 }, { 143,7094 }, { 144,7094 },
 { 145,7094 }, { 146,7094 }, { 147,7094 }, { 148,7094 }, { 149,7094 },
 { 150,7094 }, { 151,7094 }, { 152,7094 }, { 153,7094 }, { 154,7094 },
 { 155,7094 }, { 156,7094 }, { 157,7094 }, { 158,7094 }, { 159,7094 },
 { 160,7094 }, { 161,7094 }, { 162,7094 }, { 163,7094 }, { 164,7094 },
 { 165,7094 }, { 166,7094 }, { 167,7094 }, { 168,7094 }, { 169,7094 },
 { 170,7094 }, { 171,7094 }, { 172,7094 }, { 173,7094 }, { 174,7094 },

 { 175,7094 }, { 176,7094 }, { 177,7094 }, { 178,7094 }, { 179,7094 },
 { 180,7094 }, { 181,7094 }, { 182,7094 }, { 183,7094 }, { 184,7094 },
 { 185,7094 }, { 186,7094 }, { 187,7094 }, { 188,7094 }, { 189,7094 },
 { 190,7094 }, { 191,7094 }, { 192,7094 }, { 193,7094 }, { 194,7094 },
 { 195,7094 }, { 196,7094 }, { 197,7094 }, { 198,7094 }, { 199,7094 },
 { 200,7094 }, { 201,7094 }, { 202,7094 }, { 203,7094 }, { 204,7094 },
 { 205,7094 }, { 206,7094 }, { 207,7094 }, { 208,7094 }, { 209,7094 },
 { 210,7094 }, { 211,7094 }, { 212,7094 }, { 213,7094 }, { 214,7094 },
 { 215,7094 }, { 216,7094 }, { 217,7094 }, { 218,7094 }, { 219,7094 },
 { 220,7094 }, { 221,7094 }, { 222,7094 }, { 223,7094 }, { 224,7094 },

 { 225,7094 }, { 226,7094 }, { 227,7094 }, { 228,7094 }, { 229,7094 },
 { 230,7094 }, { 231,7094 }, { 232,7094 }, { 233,7094 }, { 234,7094 },
 { 235,7094 }, { 236,7094 }, { 237,7094 }, { 238,7094 }, { 239,7094 },
 { 240,7094 }, { 241,7094 }, { 242,7094 }, { 243,7094 }, { 244,7094 },
 { 245,7094 }, { 246,7094 }, { 247,7094 }, { 248,7094 }, { 249,7094 },
 { 250,7094 }, { 251,7094 }, { 252,7094 }, { 253,7094 }, { 254,7094 },
 { 255,7094 }, { 256,7094 }, {   0,   0 }, {   0,17657 }, {   1,7094 },
 {   2,7094 }, {   3,7094 }, {   4,7094 }, {   5,7094 }, {   6,7094 },
 {   7,7094 }, {   8,7094 }, {   9,7094 }, {  10,7094 }, {  11,7094 },
 {  12,7094 }, {  13,7094 }, {  14,7094 }, {  15,7094 }, {  16,7094 },

 {  17,7094 }, {  18,7094 }, {  19,7094 }, {  20,7094 }, {  21,7094 },
 {  22,7094 }, {  23,7094 }, {  24,7094 }, {  25,7094 }, {  26,7094 },
 {  27,7094 }, {  28,7094 }, {  29,7094 }, {  30,7094 }, {  31,7094 },
 {  32,7094 }, {  33,7094 }, {  34,7094 }, {  35,7094 }, {  36,7094 },
 {  37,7094 }, {  38,7094 }, {  39,3670 }, {  40,7094 }, {  41,7094 },
 {  42,7094 }, {  43,7094 }, {  44,7094 }, {  45,7094 }, {  46,7094 },
 {  47,7094 }, {  48,7094 }, {  49,7094 }, {  50,7094 }, {  51,7094 },
 {  52,7094 }, {  53,7094 }, {  54,7094 }, {  55,7094 }, {  56,7094 },
 {  57,7094 }, {  58,7094 }, {  59,7094 }, {  60,7094 }, {  61,7094 },
 {  62,7094 }, {  63,7094 }, {  64,7094 }, {  65,7094 }, {  66,7094 },

 {  67,7094 }, {  68,7094 }, {  69,7094 }, {  70,7094 }, {  71,7094 },
 {  72,7094 }, {  73,7094 }, {  74,7094 }, {  75,7094 }, {  76,7094 },
 {  77,7094 }, {  78,7094 }, {  79,7094 }, {  80,7094 }, {  81,7094 },
 {  82,7094 }, {  83,7094 }, {  84,7094 }, {  85,7094 }, {  86,7094 },
 {  87,7094 }, {  88,7094 }, {  89,7094 }, {  90,7094 }, {  91,7094 },
 {  92,7094 }, {  93,7094 }, {  94,7094 }, {  95,7094 }, {  96,7094 },
 {  97,7094 }, {  98,7094 }, {  99,7094 }, { 100,7094 }, { 101,7094 },
 { 102,7094 }, { 103,7094 }, { 104,7094 }, { 105,7094 }, { 106,7094 },
 { 107,7094 }, { 108,7094 }, { 109,7094 }, { 110,7094 }, { 111,7094 },
 { 112,7094 }, { 113,7094 }, { 114,7094 }, { 115,7094 }, { 116,7094 },

 { 117,7094 }, { 118,7094 }, { 119,7094 }, { 120,7094 }, { 121,7094 },
 { 122,7094 }, { 123,7094 }, { 124,7094 }, { 125,7094 }, { 126,7094 },
 { 127,7094 }, { 128,7094 }, { 129,7094 }, { 130,7094 }, { 131,7094 },
 { 132,7094 }, { 133,7094 }, { 134,7094 }, { 135,7094 }, { 136,7094 },
 { 137,7094 }, { 138,7094 }, { 139,7094 }, { 140,7094 }, { 141,7094 },
 { 142,7094 }, { 143,7094 }, { 144,7094 }, { 145,7094 }, { 146,7094 },
 { 147,7094 }, { 148,7094 }, { 149,7094 }, { 150,7094 }, { 151,7094 },
 { 152,7094 }, { 153,7094 }, { 154,7094 }, { 155,7094 }, { 156,7094 },
 { 157,7094 }, { 158,7094 }, { 159,7094 }, { 160,7094 }, { 161,7094 },
 { 162,7094 }, { 163,7094 }, { 164,7094 }, { 165,7094 }, { 166,7094 },

 { 167,7094 }, { 168,7094 }, { 169,7094 }, { 170,7094 }, { 171,7094 },
 { 172,7094 }, { 173,7094 }, { 174,7094 }, { 175,7094 }, { 176,7094 },
 { 177,7094 }, { 178,7094 }, { 179,7094 }, { 180,7094 }, { 181,7094 },
 { 182,7094 }, { 183,7094 }, { 184,7094 }, { 185,7094 }, { 186,7094 },
 { 187,7094 }, { 188,7094 }, { 189,7094 }, { 190,7094 }, { 191,7094 },
 { 192,7094 }, { 193,7094 }, { 194,7094 }, { 195,7094 }, { 196,7094 },
 { 197,7094 }, { 198,7094 }, { 199,7094 }, { 200,7094 }, { 201,7094 },
 { 202,7094 }, { 203,7094 }, { 204,7094 }, { 205,7094 }, { 206,7094 },
 { 207,7094 }, { 208,7094 }, { 209,7094 }, { 210,7094 }, { 211,7094 },
 { 212,7094 }, { 213,7094 }, { 214,7094 }, { 215,7094 }, { 216,7094 },

 { 217,7094 }, { 218,7094 }, { 219,7094 }, { 220,7094 }, { 221,7094 },
 { 222,7094 }, { 223,7094 }, { 224,7094 }, { 225,7094 }, { 226,7094 },
 { 227,7094 }, { 228,7094 }, { 229,7094 }, { 230,7094 }, { 231,7094 },
 { 232,7094 }, { 233,7094 }, { 234,7094 }, { 235,7094 }, { 236,7094 },
 { 237,7094 }, { 238,7094 }, { 239,7094 }, { 240,7094 }, { 241,7094 },
 { 242,7094 }, { 243,7094 }, { 244,7094 }, { 245,7094 }, { 246,7094 },
 { 247,7094 }, { 248,7094 }, { 249,7094 }, { 250,7094 }, { 251,7094 },
 { 252,7094 }, { 253,7094 }, { 254,7094 }, { 255,7094 }, { 256,7094 },
 {   0,   0 }, {   0,17399 }, {   1,6836 }, {   2,6836 }, {   3,6836 },
 {   4,6836 }, {   5,6836 }, {   6,6836 }, {   7,6836 }, {   8,6836 },

 {   9,6836 }, {  10,6836 }, {  11,6836 }, {  12,6836 }, {  13,6836 },
 {  14,6836 }, {  15,6836 }, {  16,6836 }, {  17,6836 }, {  18,6836 },
 {  19,6836 }, {  20,6836 }, {  21,6836 }, {  22,6836 }, {  23,6836 },
 {  24,6836 }, {  25,6836 }, {  26,6836 }, {  27,6836 }, {  28,6836 },
 {  29,6836 }, {  30,6836 }, {  31,6836 }, {  32,6836 }, {  33,6836 },
 {  34,6836 }, {  35,6836 }, {  36,6836 }, {  37,6836 }, {  38,6836 },
 {  39,3412 }, {  40,6836 }, {  41,6836 }, {  42,6836 }, {  43,6836 },
 {  44,6836 }, {  45,6836 }, {  46,6836 }, {  47,6836 }, {  48,6836 },
 {  49,6836 }, {  50,6836 }, {  51,6836 }, {  52,6836 }, {  53,6836 },
 {  54,6836 }, {  55,6836 }, {  56,6836 }, {  57,6836 }, {  58,6836 },

 {  59,6836 }, {  60,6836 }, {  61,6836 }, {  62,6836 }, {  63,6836 },
 {  64,6836 }, {  65,6836 }, {  66,6836 }, {  67,6836 }, {  68,6836 },
 {  69,6836 }, {  70,6836 }, {  71,6836 }, {  72,6836 }, {  73,6836 },
 {  74,6836 }, {  75,6836 }, {  76,6836 }, {  77,6836 }, {  78,6836 },
 {  79,6836 }, {  80,6836 }, {  81,6836 }, {  82,6836 }, {  83,6836 },
 {  84,6836 }, {  85,6836 }, {  86,6836 }, {  87,6836 }, {  88,6836 },
 {  89,6836 }, {  90,6836 }, {  91,6836 }, {  92,6836 }, {  93,6836 },
 {  94,6836 }, {  95,6836 }, {  96,6836 }, {  97,6836 }, {  98,6836 },
 {  99,6836 }, { 100,6836 }, { 101,6836 }, { 102,6836 }, { 103,6836 },
 { 104,6836 }, { 105,6836 }, { 106,6836 }, { 107,6836 }, { 108,6836 },

 { 109,6836 }, { 110,6836 }, { 111,6836 }, { 112,6836 }, { 113,6836 },
 { 114,6836 }, { 115,6836 }, { 116,6836 }, { 117,6836 }, { 118,6836 },
 { 119,6836 }, { 120,6836 }, { 121,6836 }, { 122,6836 }, { 123,6836 },
 { 124,6836 }, { 125,6836 }, { 126,6836 }, { 127,6836 }, { 128,6836 },
 { 129,6836 }, { 130,6836 }, { 131,6836 }, { 132,6836 }, { 133,6836 },
 { 134,6836 }, { 135,6836 }, { 136,6836 }, { 137,6836 }, { 138,6836 },
 { 139,6836 }, { 140,6836 }, { 141,6836 }, { 142,6836 }, { 143,6836 },
 { 144,6836 }, { 145,6836 }, { 146,6836 }, { 147,6836 }, { 148,6836 },
 { 149,6836 }, { 150,6836 }, { 151,6836 }, { 152,6836 }, { 153,6836 },
 { 154,6836 }, { 155,6836 }, { 156,6836 }, { 157,6836 }, { 158,6836 },

 { 159,6836 }, { 160,6836 }, { 161,6836 }, { 162,6836 }, { 163,6836 },
 { 164,6836 }, { 165,6836 }, { 166,6836 }, { 167,6836 }, { 168,6836 },
 { 169,6836 }, { 170,6836 }, { 171,6836 }, { 172,6836 }, { 173,6836 },
 { 174,6836 }, { 175,6836 }, { 176,6836 }, { 177,6836 }, { 178,6836 },
 { 179,6836 }, { 180,6836 }, { 181,6836 }, { 182,6836 }, { 183,6836 },
 { 184,6836 }, { 185,6836 }, { 186,6836 }, { 187,6836 }, { 188,6836 },
 { 189,6836 }, { 190,6836 }, { 191,6836 }, { 192,6836 }, { 193,6836 },
 { 194,6836 }, { 195,6836 }, { 196,6836 }, { 197,6836 }, { 198,6836 },
 { 199,6836 }, { 200,6836 }, { 201,6836 }, { 202,6836 }, { 203,6836 },
 { 204,6836 }, { 205,6836 }, { 206,6836 }, { 207,6836 }, { 208,6836 },

 { 209,6836 }, { 210,6836 }, { 211,6836 }, { 212,6836 }, { 213,6836 },
 { 214,6836 }, { 215,6836 }, { 216,6836 }, { 217,6836 }, { 218,6836 },
 { 219,6836 }, { 220,6836 }, { 221,6836 }, { 222,6836 }, { 223,6836 },
 { 224,6836 }, { 225,6836 }, { 226,6836 }, { 227,6836 }, { 228,6836 },
 { 229,6836 }, { 230,6836 }, { 231,6836 }, { 232,6836 }, { 233,6836 },
 { 234,6836 }, { 235,6836 }, { 236,6836 }, { 237,6836 }, { 238,6836 },
 { 239,6836 }, { 240,6836 }, { 241,6836 }, { 242,6836 }, { 243,6836 },
 { 244,6836 }, { 245,6836 }, { 246,6836 }, { 247,6836 }, { 248,6836 },
 { 249,6836 }, { 250,6836 }, { 251,6836 }, { 252,6836 }, { 253,6836 },
 { 254,6836 }, { 255,6836 }, { 256,6836 }, {   0,  18 }, {   0,17141 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,6836 }, {  10,6841 },
 {  11,3156 }, {  12,6836 }, {  13,6857 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,6836 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  18 }, {   0,16883 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,6578 }, {  10,6583 }, {  11,2898 }, {  12,6578 },
 {  13,6599 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,6578 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,16625 }, {   1,6388 }, {   2,6388 }, {   3,6388 }, {   4,6388 },
 {   5,6388 }, {   6,6388 }, {   7,6388 }, {   8,6388 }, {   9,6388 },
 {  10,6646 }, {  11,6388 }, {  12,6388 }, {  13,6388 }, {  14,6388 },
 {  15,6388 }, {  16,6388 }, {  17,6388 }, {  18,6388 }, {  19,6388 },
 {  20,6388 }, {  21,6388 }, {  22,6388 }, {  23,6388 }, {  24,6388 },
 {  25,6388 }, {  26,6388 }, {  27,6388 }, {  28,6388 }, {  29,6388 },
 {  30,6388 }, {  31,6388 }, {  32,6388 }, {  33,6388 }, {  34,6388 },

 {  35,6388 }, {  36,6388 }, {  37,6388 }, {  38,6388 }, {  39,2645 },
 {  40,6388 }, {  41,6388 }, {  42,6388 }, {  43,6388 }, {  44,6388 },
 {  45,6388 }, {  46,6388 }, {  47,6388 }, {  48,6388 }, {  49,6388 },
 {  50,6388 }, {  51,6388 }, {  52,6388 }, {  53,6388 }, {  54,6388 },
 {  55,6388 }, {  56,6388 }, {  57,6388 }, {  58,6388 }, {  59,6388 },
 {  60,6388 }, {  61,6388 }, {  62,6388 }, {  63,6388 }, {  64,6388 },
 {  65,6388 }, {  66,6388 }, {  67,6388 }, {  68,6388 }, {  69,6388 },
 {  70,6388 }, {  71,6388 }, {  72,6388 }, {  73,6388 }, {  74,6388 },
 {  75,6388 }, {  76,6388 }, {  77,6388 }, {  78,6388 }, {  79,6388 },
 {  80,6388 }, {  81,6388 }, {  82,6388 }, {  83,6388 }, {  84,6388 },

 {  85,6388 }, {  86,6388 }, {  87,6388 }, {  88,6388 }, {  89,6388 },
 {  90,6388 }, {  91,6388 }, {  92,6904 }, {  93,6388 }, {  94,6388 },
 {  95,6388 }, {  96,6388 }, {  97,6388 }, {  98,6388 }, {  99,6388 },
 { 100,6388 }, { 101,6388 }, { 102,6388 }, { 103,6388 }, { 104,6388 },
 { 105,6388 }, { 106,6388 }, { 107,6388 }, { 108,6388 }, { 109,6388 },
 { 110,6388 }, { 111,6388 }, { 112,6388 }, { 113,6388 }, { 114,6388 },
 { 115,6388 }, { 116,6388 }, { 117,6388 }, { 118,6388 }, { 119,6388 },
 { 120,6388 }, { 121,6388 }, { 122,6388 }, { 123,6388 }, { 124,6388 },
 { 125,6388 }, { 126,6388 }, { 127,6388 }, { 128,6388 }, { 129,6388 },
 { 130,6388 }, { 131,6388 }, { 132,6388 }, { 133,6388 }, { 134,6388 },

 { 135,6388 }, { 136,6388 }, { 137,6388 }, { 138,6388 }, { 139,6388 },
 { 140,6388 }, { 141,6388 }, { 142,6388 }, { 143,6388 }, { 144,6388 },
 { 145,6388 }, { 146,6388 }, { 147,6388 }, { 148,6388 }, { 149,6388 },
 { 150,6388 }, { 151,6388 }, { 152,6388 }, { 153,6388 }, { 154,6388 },
 { 155,6388 }, { 156,6388 }, { 157,6388 }, { 158,6388 }, { 159,6388 },
 { 160,6388 }, { 161,6388 }, { 162,6388 }, { 163,6388 }, { 164,6388 },
 { 165,6388 }, { 166,6388 }, { 167,6388 }, { 168,6388 }, { 169,6388 },
 { 170,6388 }, { 171,6388 }, { 172,6388 }, { 173,6388 }, { 174,6388 },
 { 175,6388 }, { 176,6388 }, { 177,6388 }, { 178,6388 }, { 179,6388 },
 { 180,6388 }, { 181,6388 }, { 182,6388 }, { 183,6388 }, { 184,6388 },

 { 185,6388 }, { 186,6388 }, { 187,6388 }, { 188,6388 }, { 189,6388 },
 { 190,6388 }, { 191,6388 }, { 192,6388 }, { 193,6388 }, { 194,6388 },
 { 195,6388 }, { 196,6388 }, { 197,6388 }, { 198,6388 }, { 199,6388 },
 { 200,6388 }, { 201,6388 }, { 202,6388 }, { 203,6388 }, { 204,6388 },
 { 205,6388 }, { 206,6388 }, { 207,6388 }, { 208,6388 }, { 209,6388 },
 { 210,6388 }, { 211,6388 }, { 212,6388 }, { 213,6388 }, { 214,6388 },
 { 215,6388 }, { 216,6388 }, { 217,6388 }, { 218,6388 }, { 219,6388 },
 { 220,6388 }, { 221,6388 }, { 222,6388 }, { 223,6388 }, { 224,6388 },
 { 225,6388 }, { 226,6388 }, { 227,6388 }, { 228,6388 }, { 229,6388 },
 { 230,6388 }, { 231,6388 }, { 232,6388 }, { 233,6388 }, { 234,6388 },

 { 235,6388 }, { 236,6388 }, { 237,6388 }, { 238,6388 }, { 239,6388 },
 { 240,6388 }, { 241,6388 }, { 242,6388 }, { 243,6388 }, { 244,6388 },
 { 245,6388 }, { 246,6388 }, { 247,6388 }, { 248,6388 }, { 249,6388 },
 { 250,6388 }, { 251,6388 }, { 252,6388 }, { 253,6388 }, { 254,6388 },
 { 255,6388 }, { 256,6388 }, {   0,   0 }, {   0,16367 }, {   1,6130 },
 {   2,6130 }, {   3,6130 }, {   4,6130 }, {   5,6130 }, {   6,6130 },
 {   7,6130 }, {   8,6130 }, {   9,6130 }, {  10,6388 }, {  11,6130 },
 {  12,6130 }, {  13,6130 }, {  14,6130 }, {  15,6130 }, {  16,6130 },
 {  17,6130 }, {  18,6130 }, {  19,6130 }, {  20,6130 }, {  21,6130 },
 {  22,6130 }, {  23,6130 }, {  24,6130 }, {  25,6130 }, {  26,6130 },

 {  27,6130 }, {  28,6130 }, {  29,6130 }, {  30,6130 }, {  31,6130 },
 {  32,6130 }, {  33,6130 }, {  34,6130 }, {  35,6130 }, {  36,6130 },
 {  37,6130 }, {  38,6130 }, {  39,2387 }, {  40,6130 }, {  41,6130 },
 {  42,6130 }, {  43,6130 }, {  44,6130 }, {  45,6130 }, {  46,6130 },
 {  47,6130 }, {  48,6130 }, {  49,6130 }, {  50,6130 }, {  51,6130 },
 {  52,6130 }, {  53,6130 }, {  54,6130 }, {  55,6130 }, {  56,6130 },
 {  57,6130 }, {  58,6130 }, {  59,6130 }, {  60,6130 }, {  61,6130 },
 {  62,6130 }, {  63,6130 }, {  64,6130 }, {  65,6130 }, {  66,6130 },
 {  67,6130 }, {  68,6130 }, {  69,6130 }, {  70,6130 }, {  71,6130 },
 {  72,6130 }, {  73,6130 }, {  74,6130 }, {  75,6130 }, {  76,6130 },

 {  77,6130 }, {  78,6130 }, {  79,6130 }, {  80,6130 }, {  81,6130 },
 {  82,6130 }, {  83,6130 }, {  84,6130 }, {  85,6130 }, {  86,6130 },
 {  87,6130 }, {  88,6130 }, {  89,6130 }, {  90,6130 }, {  91,6130 },
 {  92,6646 }, {  93,6130 }, {  94,6130 }, {  95,6130 }, {  96,6130 },
 {  97,6130 }, {  98,6130 }, {  99,6130 }, { 100,6130 }, { 101,6130 },
 { 102,6130 }, { 103,6130 }, { 104,6130 }, { 105,6130 }, { 106,6130 },
 { 107,6130 }, { 108,6130 }, { 109,6130 }, { 110,6130 }, { 111,6130 },
 { 112,6130 }, { 113,6130 }, { 114,6130 }, { 115,6130 }, { 116,6130 },
 { 117,6130 }, { 118,6130 }, { 119,6130 }, { 120,6130 }, { 121,6130 },
 { 122,6130 }, { 123,6130 }, { 124,6130 }, { 125,6130 }, { 126,6130 },

 { 127,6130 }, { 128,6130 }, { 129,6130 }, { 130,6130 }, { 131,6130 },
 { 132,6130 }, { 133,6130 }, { 134,6130 }, { 135,6130 }, { 136,6130 },
 { 137,6130 }, { 138,6130 }, { 139,6130 }, { 140,6130 }, { 141,6130 },
 { 142,6130 }, { 143,6130 }, { 144,6130 }, { 145,6130 }, { 146,6130 },
 { 147,6130 }, { 148,6130 }, { 149,6130 }, { 150,6130 }, { 151,6130 },
 { 152,6130 }, { 153,6130 }, { 154,6130 }, { 155,6130 }, { 156,6130 },
 { 157,6130 }, { 158,6130 }, { 159,6130 }, { 160,6130 }, { 161,6130 },
 { 162,6130 }, { 163,6130 }, { 164,6130 }, { 165,6130 }, { 166,6130 },
 { 167,6130 }, { 168,6130 }, { 169,6130 }, { 170,6130 }, { 171,6130 },
 { 172,6130 }, { 173,6130 }, { 174,6130 }, { 175,6130 }, { 176,6130 },

 { 177,6130 }, { 178,6130 }, { 179,6130 }, { 180,6130 }, { 181,6130 },
 { 182,6130 }, { 183,6130 }, { 184,6130 }, { 185,6130 }, { 186,6130 },
 { 187,6130 }, { 188,6130 }, { 189,6130 }, { 190,6130 }, { 191,6130 },
 { 192,6130 }, { 193,6130 }, { 194,6130 }, { 195,6130 }, { 196,6130 },
 { 197,6130 }, { 198,6130 }, { 199,6130 }, { 200,6130 }, { 201,6130 },
 { 202,6130 }, { 203,6130 }, { 204,6130 }, { 205,6130 }, { 206,6130 },
 { 207,6130 }, { 208,6130 }, { 209,6130 }, { 210,6130 }, { 211,6130 },
 { 212,6130 }, { 213,6130 }, { 214,6130 }, { 215,6130 }, { 216,6130 },
 { 217,6130 }, { 218,6130 }, { 219,6130 }, { 220,6130 }, { 221,6130 },
 { 222,6130 }, { 223,6130 }, { 224,6130 }, { 225,6130 }, { 226,6130 },

 { 227,6130 }, { 228,6130 }, { 229,6130 }, { 230,6130 }, { 231,6130 },
 { 232,6130 }, { 233,6130 }, { 234,6130 }, { 235,6130 }, { 236,6130 },
 { 237,6130 }, { 238,6130 }, { 239,6130 }, { 240,6130 }, { 241,6130 },
 { 242,6130 }, { 243,6130 }, { 244,6130 }, { 245,6130 }, { 246,6130 },
 { 247,6130 }, { 248,6130 }, { 249,6130 }, { 250,6130 }, { 251,6130 },
 { 252,6130 }, { 253,6130 }, { 254,6130 }, { 255,6130 }, { 256,6130 },
 {   0,   0 }, {   0,16109 }, {   1,6646 }, {   2,6646 }, {   3,6646 },
 {   4,6646 }, {   5,6646 }, {   6,6646 }, {   7,6646 }, {   8,6646 },
 {   9,6646 }, {  10,6904 }, {  11,6646 }, {  12,6646 }, {  13,6646 },
 {  14,6646 }, {  15,6646 }, {  16,6646 }, {  17,6646 }, {  18,6646 },

 {  19,6646 }, {  20,6646 }, {  21,6646 }, {  22,6646 }, {  23,6646 },
 {  24,6646 }, {  25,6646 }, {  26,6646 }, {  27,6646 }, {  28,6646 },
 {  29,6646 }, {  30,6646 }, {  31,6646 }, {  32,6646 }, {  33,6646 },
 {  34,6646 }, {  35,6646 }, {  36,7162 }, {  37,6646 }, {  38,6646 },
 {  39,6646 }, {  40,6646 }, {  41,6646 }, {  42,6646 }, {  43,6646 },
 {  44,6646 }, {  45,6646 }, {  46,6646 }, {  47,6646 }, {  48,6646 },
 {  49,6646 }, {  50,6646 }, {  51,6646 }, {  52,6646 }, {  53,6646 },
 {  54,6646 }, {  55,6646 }, {  56,6646 }, {  57,6646 }, {  58,6646 },
 {  59,6646 }, {  60,6646 }, {  61,6646 }, {  62,6646 }, {  63,6646 },
 {  64,6646 }, {  65,6646 }, {  66,6646 }, {  67,6646 }, {  68,6646 },

 {  69,6646 }, {  70,6646 }, {  71,6646 }, {  72,6646 }, {  73,6646 },
 {  74,6646 }, {  75,6646 }, {  76,6646 }, {  77,6646 }, {  78,6646 },
 {  79,6646 }, {  80,6646 }, {  81,6646 }, {  82,6646 }, {  83,6646 },
 {  84,6646 }, {  85,6646 }, {  86,6646 }, {  87,6646 }, {  88,6646 },
 {  89,6646 }, {  90,6646 }, {  91,6646 }, {  92,6646 }, {  93,6646 },
 {  94,6646 }, {  95,6646 }, {  96,6646 }, {  97,6646 }, {  98,6646 },
 {  99,6646 }, { 100,6646 }, { 101,6646 }, { 102,6646 }, { 103,6646 },
 { 104,6646 }, { 105,6646 }, { 106,6646 }, { 107,6646 }, { 108,6646 },
 { 109,6646 }, { 110,6646 }, { 111,6646 }, { 112,6646 }, { 113,6646 },
 { 114,6646 }, { 115,6646 }, { 116,6646 }, { 117,6646 }, { 118,6646 },

 { 119,6646 }, { 120,6646 }, { 121,6646 }, { 122,6646 }, { 123,6646 },
 { 124,6646 }, { 125,6646 }, { 126,6646 }, { 127,6646 }, { 128,6646 },
 { 129,6646 }, { 130,6646 }, { 131,6646 }, { 132,6646 }, { 133,6646 },
 { 134,6646 }, { 135,6646 }, { 136,6646 }, { 137,6646 }, { 138,6646 },
 { 139,6646 }, { 140,6646 }, { 141,6646 }, { 142,6646 }, { 143,6646 },
 { 144,6646 }, { 145,6646 }, { 146,6646 }, { 147,6646 }, { 148,6646 },
 { 149,6646 }, { 150,6646 }, { 151,6646 }, { 152,6646 }, { 153,6646 },
 { 154,6646 }, { 155,6646 }, { 156,6646 }, { 157,6646 }, { 158,6646 },
 { 159,6646 }, { 160,6646 }, { 161,6646 }, { 162,6646 }, { 163,6646 },
 { 164,6646 }, { 165,6646 }, { 166,6646 }, { 167,6646 }, { 168,6646 },

 { 169,6646 }, { 170,6646 }, { 171,6646 }, { 172,6646 }, { 173,6646 },
 { 174,6646 }, { 175,6646 }, { 176,6646 }, { 177,6646 }, { 178,6646 },
 { 179,6646 }, { 180,6646 }, { 181,6646 }, { 182,6646 }, { 183,6646 },
 { 184,6646 }, { 185,6646 }, { 186,6646 }, { 187,6646 }, { 188,6646 },
 { 189,6646 }, { 190,6646 }, { 191,6646 }, { 192,6646 }, { 193,6646 },
 { 194,6646 }, { 195,6646 }, { 196,6646 }, { 197,6646 }, { 198,6646 },
 { 199,6646 }, { 200,6646 }, { 201,6646 }, { 202,6646 }, { 203,6646 },
 { 204,6646 }, { 205,6646 }, { 206,6646 }, { 207,6646 }, { 208,6646 },
 { 209,6646 }, { 210,6646 }, { 211,6646 }, { 212,6646 }, { 213,6646 },
 { 214,6646 }, { 215,6646 }, { 216,6646 }, { 217,6646 }, { 218,6646 },

 { 219,6646 }, { 220,6646 }, { 221,6646 }, { 222,6646 }, { 223,6646 },
 { 224,6646 }, { 225,6646 }, { 226,6646 }, { 227,6646 }, { 228,6646 },
 { 229,6646 }, { 230,6646 }, { 231,6646 }, { 232,6646 }, { 233,6646 },
 { 234,6646 }, { 235,6646 }, { 236,6646 }, { 237,6646 }, { 238,6646 },
 { 239,6646 }, { 240,6646 }, { 241,6646 }, { 242,6646 }, { 243,6646 },
 { 244,6646 }, { 245,6646 }, { 246,6646 }, { 247,6646 }, { 248,6646 },
 { 249,6646 }, { 250,6646 }, { 251,6646 }, { 252,6646 }, { 253,6646 },
 { 254,6646 }, { 255,6646 }, { 256,6646 }, {   0,   0 }, {   0,15851 },
 {   1,6388 }, {   2,6388 }, {   3,6388 }, {   4,6388 }, {   5,6388 },
 {   6,6388 }, {   7,6388 }, {   8,6388 }, {   9,6388 }, {  10,6646 },

 {  11,6388 }, {  12,6388 }, {  13,6388 }, {  14,6388 }, {  15,6388 },
 {  16,6388 }, {  17,6388 }, {  18,6388 }, {  19,6388 }, {  20,6388 },
 {  21,6388 }, {  22,6388 }, {  23,6388 }, {  24,6388 }, {  25,6388 },
 {  26,6388 }, {  27,6388 }, {  28,6388 }, {  29,6388 }, {  30,6388 },
 {  31,6388 }, {  32,6388 }, {  33,6388 }, {  34,6388 }, {  35,6388 },
 {  36,6904 }, {  37,6388 }, {  38,6388 }, {  39,6388 }, {  40,6388 },
 {  41,6388 }, {  42,6388 }, {  43,6388 }, {  44,6388 }, {  45,6388 },
 {  46,6388 }, {  47,6388 }, {  48,6388 }, {  49,6388 }, {  50,6388 },
 {  51,6388 }, {  52,6388 }, {  53,6388 }, {  54,6388 }, {  55,6388 },
 {  56,6388 }, {  57,6388 }, {  58,6388 }, {  59,6388 }, {  60,6388 },

 {  61,6388 }, {  62,6388 }, {  63,6388 }, {  64,6388 }, {  65,6388 },
 {  66,6388 }, {  67,6388 }, {  68,6388 }, {  69,6388 }, {  70,6388 },
 {  71,6388 }, {  72,6388 }, {  73,6388 }, {  74,6388 }, {  75,6388 },
 {  76,6388 }, {  77,6388 }, {  78,6388 }, {  79,6388 }, {  80,6388 },
 {  81,6388 }, {  82,6388 }, {  83,6388 }, {  84,6388 }, {  85,6388 },
 {  86,6388 }, {  87,6388 }, {  88,6388 }, {  89,6388 }, {  90,6388 },
 {  91,6388 }, {  92,6388 }, {  93,6388 }, {  94,6388 }, {  95,6388 },
 {  96,6388 }, {  97,6388 }, {  98,6388 }, {  99,6388 }, { 100,6388 },
 { 101,6388 }, { 102,6388 }, { 103,6388 }, { 104,6388 }, { 105,6388 },
 { 106,6388 }, { 107,6388 }, { 108,6388 }, { 109,6388 }, { 110,6388 },

 { 111,6388 }, { 112,6388 }, { 113,6388 }, { 114,6388 }, { 115,6388 },
 { 116,6388 }, { 117,6388 }, { 118,6388 }, { 119,6388 }, { 120,6388 },
 { 121,6388 }, { 122,6388 }, { 123,6388 }, { 124,6388 }, { 125,6388 },
 { 126,6388 }, { 127,6388 }, { 128,6388 }, { 129,6388 }, { 130,6388 },
 { 131,6388 }, { 132,6388 }, { 133,6388 }, { 134,6388 }, { 135,6388 },
 { 136,6388 }, { 137,6388 }, { 138,6388 }, { 139,6388 }, { 140,6388 },
 { 141,6388 }, { 142,6388 }, { 143,6388 }, { 144,6388 }, { 145,6388 },
 { 146,6388 }, { 147,6388 }, { 148,6388 }, { 149,6388 }, { 150,6388 },
 { 151,6388 }, { 152,6388 }, { 153,6388 }, { 154,6388 }, { 155,6388 },
 { 156,6388 }, { 157,6388 }, { 158,6388 }, { 159,6388 }, { 160,6388 },

 { 161,6388 }, { 162,6388 }, { 163,6388 }, { 164,6388 }, { 165,6388 },
 { 166,6388 }, { 167,6388 }, { 168,6388 }, { 169,6388 }, { 170,6388 },
 { 171,6388 }, { 172,6388 }, { 173,6388 }, { 174,6388 }, { 175,6388 },
 { 176,6388 }, { 177,6388 }, { 178,6388 }, { 179,6388 }, { 180,6388 },
 { 181,6388 }, { 182,6388 }, { 183,6388 }, { 184,6388 }, { 185,6388 },
 { 186,6388 }, { 187,6388 }, { 188,6388 }, { 189,6388 }, { 190,6388 },
 { 191,6388 }, { 192,6388 }, { 193,6388 }, { 194,6388 }, { 195,6388 },
 { 196,6388 }, { 197,6388 }, { 198,6388 }, { 199,6388 }, { 200,6388 },
 { 201,6388 }, { 202,6388 }, { 203,6388 }, { 204,6388 }, { 205,6388 },
 { 206,6388 }, { 207,6388 }, { 208,6388 }, { 209,6388 }, { 210,6388 },

 { 211,6388 }, { 212,6388 }, { 213,6388 }, { 214,6388 }, { 215,6388 },
 { 216,6388 }, { 217,6388 }, { 218,6388 }, { 219,6388 }, { 220,6388 },
 { 221,6388 }, { 222,6388 }, { 223,6388 }, { 224,6388 }, { 225,6388 },
 { 226,6388 }, { 227,6388 }, { 228,6388 }, { 229,6388 }, { 230,6388 },
 { 231,6388 }, { 232,6388 }, { 233,6388 }, { 234,6388 }, { 235,6388 },
 { 236,6388 }, { 237,6388 }, { 238,6388 }, { 239,6388 }, { 240,6388 },
 { 241,6388 }, { 242,6388 }, { 243,6388 }, { 244,6388 }, { 245,6388 },
 { 246,6388 }, { 247,6388 }, { 248,6388 }, { 249,6388 }, { 250,6388 },
 { 251,6388 }, { 252,6388 }, { 253,6388 }, { 254,6388 }, { 255,6388 },
 { 256,6388 }, {   0,   0 }, {   0,15593 }, {   1,4514 }, {   2,4514 },

 {   3,4514 }, {   4,4514 }, {   5,4514 }, {   6,4514 }, {   7,4514 },
 {   8,4514 }, {   9,4514 }, {  10,4514 }, {  11,4514 }, {  12,4514 },
 {  13,4514 }, {  14,4514 }, {  15,4514 }, {  16,4514 }, {  17,4514 },
 {  18,4514 }, {  19,4514 }, {  20,4514 }, {  21,4514 }, {  22,4514 },
 {  23,4514 }, {  24,4514 }, {  25,4514 }, {  26,4514 }, {  27,4514 },
 {  28,4514 }, {  29,4514 }, {  30,4514 }, {  31,4514 }, {  32,4514 },
 {  33,4514 }, {  34,1615 }, {  35,4514 }, {  36,4514 }, {  37,4514 },
 {  38,4514 }, {  39,4514 }, {  40,4514 }, {  41,4514 }, {  42,4514 },
 {  43,4514 }, {  44,4514 }, {  45,4514 }, {  46,4514 }, {  47,4514 },
 {  48,4514 }, {  49,4514 }, {  50,4514 }, {  51,4514 }, {  52,4514 },

 {  53,4514 }, {  54,4514 }, {  55,4514 }, {  56,4514 }, {  57,4514 },
 {  58,4514 }, {  59,4514 }, {  60,4514 }, {  61,4514 }, {  62,4514 },
 {  63,4514 }, {  64,4514 }, {  65,4514 }, {  66,4514 }, {  67,4514 },
 {  68,4514 }, {  69,4514 }, {  70,4514 }, {  71,4514 }, {  72,4514 },
 {  73,4514 }, {  74,4514 }, {  75,4514 }, {  76,4514 }, {  77,4514 },
 {  78,4514 }, {  79,4514 }, {  80,4514 }, {  81,4514 }, {  82,4514 },
 {  83,4514 }, {  84,4514 }, {  85,4514 }, {  86,4514 }, {  87,4514 },
 {  88,4514 }, {  89,4514 }, {  90,4514 }, {  91,4514 }, {  92,4514 },
 {  93,4514 }, {  94,4514 }, {  95,4514 }, {  96,4514 }, {  97,4514 },
 {  98,4514 }, {  99,4514 }, { 100,4514 }, { 101,4514 }, { 102,4514 },

 { 103,4514 }, { 104,4514 }, { 105,4514 }, { 106,4514 }, { 107,4514 },
 { 108,4514 }, { 109,4514 }, { 110,4514 }, { 111,4514 }, { 112,4514 },
 { 113,4514 }, { 114,4514 }, { 115,4514 }, { 116,4514 }, { 117,4514 },
 { 118,4514 }, { 119,4514 }, { 120,4514 }, { 121,4514 }, { 122,4514 },
 { 123,4514 }, { 124,4514 }, { 125,4514 }, { 126,4514 }, { 127,4514 },
 { 128,4514 }, { 129,4514 }, { 130,4514 }, { 131,4514 }, { 132,4514 },
 { 133,4514 }, { 134,4514 }, { 135,4514 }, { 136,4514 }, { 137,4514 },
 { 138,4514 }, { 139,4514 }, { 140,4514 }, { 141,4514 }, { 142,4514 },
 { 143,4514 }, { 144,4514 }, { 145,4514 }, { 146,4514 }, { 147,4514 },
 { 148,4514 }, { 149,4514 }, { 150,4514 }, { 151,4514 }, { 152,4514 },

 { 153,4514 }, { 154,4514 }, { 155,4514 }, { 156,4514 }, { 157,4514 },
 { 158,4514 }, { 159,4514 }, { 160,4514 }, { 161,4514 }, { 162,4514 },
 { 163,4514 }, { 164,4514 }, { 165,4514 }, { 166,4514 }, { 167,4514 },
 { 168,4514 }, { 169,4514 }, { 170,4514 }, { 171,4514 }, { 172,4514 },
 { 173,4514 }, { 174,4514 }, { 175,4514 }, { 176,4514 }, { 177,4514 },
 { 178,4514 }, { 179,4514 }, { 180,4514 }, { 181,4514 }, { 182,4514 },
 { 183,4514 }, { 184,4514 }, { 185,4514 }, { 186,4514 }, { 187,4514 },
 { 188,4514 }, { 189,4514 }, { 190,4514 }, { 191,4514 }, { 192,4514 },
 { 193,4514 }, { 194,4514 }, { 195,4514 }, { 196,4514 }, { 197,4514 },
 { 198,4514 }, { 199,4514 }, { 200,4514 }, { 201,4514 }, { 202,4514 },

 { 203,4514 }, { 204,4514 }, { 205,4514 }, { 206,4514 }, { 207,4514 },
 { 208,4514 }, { 209,4514 }, { 210,4514 }, { 211,4514 }, { 212,4514 },
 { 213,4514 }, { 214,4514 }, { 215,4514 }, { 216,4514 }, { 217,4514 },
 { 218,4514 }, { 219,4514 }, { 220,4514 }, { 221,4514 }, { 222,4514 },
 { 223,4514 }, { 224,4514 }, { 225,4514 }, { 226,4514 }, { 227,4514 },
 { 228,4514 }, { 229,4514 }, { 230,4514 }, { 231,4514 }, { 232,4514 },
 { 233,4514 }, { 234,4514 }, { 235,4514 }, { 236,4514 }, { 237,4514 },
 { 238,4514 }, { 239,4514 }, { 240,4514 }, { 241,4514 }, { 242,4514 },
 { 243,4514 }, { 244,4514 }, { 245,4514 }, { 246,4514 }, { 247,4514 },
 { 248,4514 }, { 249,4514 }, { 250,4514 }, { 251,4514 }, { 252,4514 },

 { 253,4514 }, { 254,4514 }, { 255,4514 }, { 256,4514 }, {   0,   0 },
 {   0,15335 }, {   1,4256 }, {   2,4256 }, {   3,4256 }, {   4,4256 },
 {   5,4256 }, {   6,4256 }, {   7,4256 }, {   8,4256 }, {   9,4256 },
 {  10,4256 }, {  11,4256 }, {  12,4256 }, {  13,4256 }, {  14,4256 },
 {  15,4256 }, {  16,4256 }, {  17,4256 }, {  18,4256 }, {  19,4256 },
 {  20,4256 }, {  21,4256 }, {  22,4256 }, {  23,4256 }, {  24,4256 },
 {  25,4256 }, {  26,4256 }, {  27,4256 }, {  28,4256 }, {  29,4256 },
 {  30,4256 }, {  31,4256 }, {  32,4256 }, {  33,4256 }, {  34,1357 },
 {  35,4256 }, {  36,4256 }, {  37,4256 }, {  38,4256 }, {  39,4256 },
 {  40,4256 }, {  41,4256 }, {  42,4256 }, {  43,4256 }, {  44,4256 },

 {  45,4256 }, {  46,4256 }, {  47,4256 }, {  48,4256 }, {  49,4256 },
 {  50,4256 }, {  51,4256 }, {  52,4256 }, {  53,4256 }, {  54,4256 },
 {  55,4256 }, {  56,4256 }, {  57,4256 }, {  58,4256 }, {  59,4256 },
 {  60,4256 }, {  61,4256 }, {  62,4256 }, {  63,4256 }, {  64,4256 },
 {  65,4256 }, {  66,4256 }, {  67,4256 }, {  68,4256 }, {  69,4256 },
 {  70,4256 }, {  71,4256 }, {  72,4256 }, {  73,4256 }, {  74,4256 },
 {  75,4256 }, {  76,4256 }, {  77,4256 }, {  78,4256 }, {  79,4256 },
 {  80,4256 }, {  81,4256 }, {  82,4256 }, {  83,4256 }, {  84,4256 },
 {  85,4256 }, {  86,4256 }, {  87,4256 }, {  88,4256 }, {  89,4256 },
 {  90,4256 }, {  91,4256 }, {  92,4256 }, {  93,4256 }, {  94,4256 },

 {  95,4256 }, {  96,4256 }, {  97,4256 }, {  98,4256 }, {  99,4256 },
 { 100,4256 }, { 101,4256 }, { 102,4256 }, { 103,4256 }, { 104,4256 },
 { 105,4256 }, { 106,4256 }, { 107,4256 }, { 108,4256 }, { 109,4256 },
 { 110,4256 }, { 111,4256 }, { 112,4256 }, { 113,4256 }, { 114,4256 },
 { 115,4256 }, { 116,4256 }, { 117,4256 }, { 118,4256 }, { 119,4256 },
 { 120,4256 }, { 121,4256 }, { 122,4256 }, { 123,4256 }, { 124,4256 },
 { 125,4256 }, { 126,4256 }, { 127,4256 }, { 128,4256 }, { 129,4256 },
 { 130,4256 }, { 131,4256 }, { 132,4256 }, { 133,4256 }, { 134,4256 },
 { 135,4256 }, { 136,4256 }, { 137,4256 }, { 138,4256 }, { 139,4256 },
 { 140,4256 }, { 141,4256 }, { 142,4256 }, { 143,4256 }, { 144,4256 },

 { 145,4256 }, { 146,4256 }, { 147,4256 }, { 148,4256 }, { 149,4256 },
 { 150,4256 }, { 151,4256 }, { 152,4256 }, { 153,4256 }, { 154,4256 },
 { 155,4256 }, { 156,4256 }, { 157,4256 }, { 158,4256 }, { 159,4256 },
 { 160,4256 }, { 161,4256 }, { 162,4256 }, { 163,4256 }, { 164,4256 },
 { 165,4256 }, { 166,4256 }, { 167,4256 }, { 168,4256 }, { 169,4256 },
 { 170,4256 }, { 171,4256 }, { 172,4256 }, { 173,4256 }, { 174,4256 },
 { 175,4256 }, { 176,4256 }, { 177,4256 }, { 178,4256 }, { 179,4256 },
 { 180,4256 }, { 181,4256 }, { 182,4256 }, { 183,4256 }, { 184,4256 },
 { 185,4256 }, { 186,4256 }, { 187,4256 }, { 188,4256 }, { 189,4256 },
 { 190,4256 }, { 191,4256 }, { 192,4256 }, { 193,4256 }, { 194,4256 },

 { 195,4256 }, { 196,4256 }, { 197,4256 }, { 198,4256 }, { 199,4256 },
 { 200,4256 }, { 201,4256 }, { 202,4256 }, { 203,4256 }, { 204,4256 },
 { 205,4256 }, { 206,4256 }, { 207,4256 }, { 208,4256 }, { 209,4256 },
 { 210,4256 }, { 211,4256 }, { 212,4256 }, { 213,4256 }, { 214,4256 },
 { 215,4256 }, { 216,4256 }, { 217,4256 }, { 218,4256 }, { 219,4256 },
 { 220,4256 }, { 221,4256 }, { 222,4256 }, { 223,4256 }, { 224,4256 },
 { 225,4256 }, { 226,4256 }, { 227,4256 }, { 228,4256 }, { 229,4256 },
 { 230,4256 }, { 231,4256 }, { 232,4256 }, { 233,4256 }, { 234,4256 },
 { 235,4256 }, { 236,4256 }, { 237,4256 }, { 238,4256 }, { 239,4256 },
 { 240,4256 }, { 241,4256 }, { 242,4256 }, { 243,4256 }, { 244,4256 },

 { 245,4256 }, { 246,4256 }, { 247,4256 }, { 248,4256 }, { 249,4256 },
 { 250,4256 }, { 251,4256 }, { 252,4256 }, { 253,4256 }, { 254,4256 },
 { 255,4256 }, { 256,4256 }, {   0,   0 }, {   0,15077 }, {   1,4514 },
 {   2,4514 }, {   3,4514 }, {   4,4514 }, {   5,4514 }, {   6,4514 },
 {   7,4514 }, {   8,4514 }, {   9,4514 }, {  10,4514 }, {  11,4514 },
 {  12,4514 }, {  13,4514 }, {  14,4514 }, {  15,4514 }, {  16,4514 },
 {  17,4514 }, {  18,4514 }, {  19,4514 }, {  20,4514 }, {  21,4514 },
 {  22,4514 }, {  23,4514 }, {  24,4514 }, {  25,4514 }, {  26,4514 },
 {  27,4514 }, {  28,4514 }, {  29,4514 }, {  30,4514 }, {  31,4514 },
 {  32,4514 }, {  33,4514 }, {  34,4514 }, {  35,4514 }, {  36,4514 },

 {  37,4514 }, {  38,4514 }, {  39,1090 }, {  40,4514 }, {  41,4514 },
 {  42,4514 }, {  43,4514 }, {  44,4514 }, {  45,4514 }, {  46,4514 },
 {  47,4514 }, {  48,4514 }, {  49,4514 }, {  50,4514 }, {  51,4514 },
 {  52,4514 }, {  53,4514 }, {  54,4514 }, {  55,4514 }, {  56,4514 },
 {  57,4514 }, {  58,4514 }, {  59,4514 }, {  60,4514 }, {  61,4514 },
 {  62,4514 }, {  63,4514 }, {  64,4514 }, {  65,4514 }, {  66,4514 },
 {  67,4514 }, {  68,4514 }, {  69,4514 }, {  70,4514 }, {  71,4514 },
 {  72,4514 }, {  73,4514 }, {  74,4514 }, {  75,4514 }, {  76,4514 },
 {  77,4514 }, {  78,4514 }, {  79,4514 }, {  80,4514 }, {  81,4514 },
 {  82,4514 }, {  83,4514 }, {  84,4514 }, {  85,4514 }, {  86,4514 },

 {  87,4514 }, {  88,4514 }, {  89,4514 }, {  90,4514 }, {  91,4514 },
 {  92,4514 }, {  93,4514 }, {  94,4514 }, {  95,4514 }, {  96,4514 },
 {  97,4514 }, {  98,4514 }, {  99,4514 }, { 100,4514 }, { 101,4514 },
 { 102,4514 }, { 103,4514 }, { 104,4514 }, { 105,4514 }, { 106,4514 },
 { 107,4514 }, { 108,4514 }, { 109,4514 }, { 110,4514 }, { 111,4514 },
 { 112,4514 }, { 113,4514 }, { 114,4514 }, { 115,4514 }, { 116,4514 },
 { 117,4514 }, { 118,4514 }, { 119,4514 }, { 120,4514 }, { 121,4514 },
 { 122,4514 }, { 123,4514 }, { 124,4514 }, { 125,4514 }, { 126,4514 },
 { 127,4514 }, { 128,4514 }, { 129,4514 }, { 130,4514 }, { 131,4514 },
 { 132,4514 }, { 133,4514 }, { 134,4514 }, { 135,4514 }, { 136,4514 },

 { 137,4514 }, { 138,4514 }, { 139,4514 }, { 140,4514 }, { 141,4514 },
 { 142,4514 }, { 143,4514 }, { 144,4514 }, { 145,4514 }, { 146,4514 },
 { 147,4514 }, { 148,4514 }, { 149,4514 }, { 150,4514 }, { 151,4514 },
 { 152,4514 }, { 153,4514 }, { 154,4514 }, { 155,4514 }, { 156,4514 },
 { 157,4514 }, { 158,4514 }, { 159,4514 }, { 160,4514 }, { 161,4514 },
 { 162,4514 }, { 163,4514 }, { 164,4514 }, { 165,4514 }, { 166,4514 },
 { 167,4514 }, { 168,4514 }, { 169,4514 }, { 170,4514 }, { 171,4514 },
 { 172,4514 }, { 173,4514 }, { 174,4514 }, { 175,4514 }, { 176,4514 },
 { 177,4514 }, { 178,4514 }, { 179,4514 }, { 180,4514 }, { 181,4514 },
 { 182,4514 }, { 183,4514 }, { 184,4514 }, { 185,4514 }, { 186,4514 },

 { 187,4514 }, { 188,4514 }, { 189,4514 }, { 190,4514 }, { 191,4514 },
 { 192,4514 }, { 193,4514 }, { 194,4514 }, { 195,4514 }, { 196,4514 },
 { 197,4514 }, { 198,4514 }, { 199,4514 }, { 200,4514 }, { 201,4514 },
 { 202,4514 }, { 203,4514 }, { 204,4514 }, { 205,4514 }, { 206,4514 },
 { 207,4514 }, { 208,4514 }, { 209,4514 }, { 210,4514 }, { 211,4514 },
 { 212,4514 }, { 213,4514 }, { 214,4514 }, { 215,4514 }, { 216,4514 },
 { 217,4514 }, { 218,4514 }, { 219,4514 }, { 220,4514 }, { 221,4514 },
 { 222,4514 }, { 223,4514 }, { 224,4514 }, { 225,4514 }, { 226,4514 },
 { 227,4514 }, { 228,4514 }, { 229,4514 }, { 230,4514 }, { 231,4514 },
 { 232,4514 }, { 233,4514 }, { 234,4514 }, { 235,4514 }, { 236,4514 },

 { 237,4514 }, { 238,4514 }, { 239,4514 }, { 240,4514 }, { 241,4514 },
 { 242,4514 }, { 243,4514 }, { 244,4514 }, { 245,4514 }, { 246,4514 },
 { 247,4514 }, { 248,4514 }, { 249,4514 }, { 250,4514 }, { 251,4514 },
 { 252,4514 }, { 253,4514 }, { 254,4514 }, { 255,4514 }, { 256,4514 },
 {   0,   0 }, {   0,14819 }, {   1,4256 }, {   2,4256 }, {   3,4256 },
 {   4,4256 }, {   5,4256 }, {   6,4256 }, {   7,4256 }, {   8,4256 },
 {   9,4256 }, {  10,4256 }, {  11,4256 }, {  12,4256 }, {  13,4256 },
 {  14,4256 }, {  15,4256 }, {  16,4256 }, {  17,4256 }, {  18,4256 },
 {  19,4256 }, {  20,4256 }, {  21,4256 }, {  22,4256 }, {  23,4256 },
 {  24,4256 }, {  25,4256 }, {  26,4256 }, {  27,4256 }, {  28,4256 },

 {  29,4256 }, {  30,4256 }, {  31,4256 }, {  32,4256 }, {  33,4256 },
 {  34,4256 }, {  35,4256 }, {  36,4256 }, {  37,4256 }, {  38,4256 },
 {  39, 832 }, {  40,4256 }, {  41,4256 }, {  42,4256 }, {  43,4256 },
 {  44,4256 }, {  45,4256 }, {  46,4256 }, {  47,4256 }, {  48,4256 },
 {  49,4256 }, {  50,4256 }, {  51,4256 }, {  52,4256 }, {  53,4256 },
 {  54,4256 }, {  55,4256 }, {  56,4256 }, {  57,4256 }, {  58,4256 },
 {  59,4256 }, {  60,4256 }, {  61,4256 }, {  62,4256 }, {  63,4256 },
 {  64,4256 }, {  65,4256 }, {  66,4256 }, {  67,4256 }, {  68,4256 },
 {  69,4256 }, {  70,4256 }, {  71,4256 }, {  72,4256 }, {  73,4256 },
 {  74,4256 }, {  75,4256 }, {  76,4256 }, {  77,4256 }, {  78,4256 },

 {  79,4256 }, {  80,4256 }, {  81,4256 }, {  82,4256 }, {  83,4256 },
 {  84,4256 }, {  85,4256 }, {  86,4256 }, {  87,4256 }, {  88,4256 },
 {  89,4256 }, {  90,4256 }, {  91,4256 }, {  92,4256 }, {  93,4256 },
 {  94,4256 }, {  95,4256 }, {  96,4256 }, {  97,4256 }, {  98,4256 },
 {  99,4256 }, { 100,4256 }, { 101,4256 }, { 102,4256 }, { 103,4256 },
 { 104,4256 }, { 105,4256 }, { 106,4256 }, { 107,4256 }, { 108,4256 },
 { 109,4256 }, { 110,4256 }, { 111,4256 }, { 112,4256 }, { 113,4256 },
 { 114,4256 }, { 115,4256 }, { 116,4256 }, { 117,4256 }, { 118,4256 },
 { 119,4256 }, { 120,4256 }, { 121,4256 }, { 122,4256 }, { 123,4256 },
 { 124,4256 }, { 125,4256 }, { 126,4256 }, { 127,4256 }, { 128,4256 },

 { 129,4256 }, { 130,4256 }, { 131,4256 }, { 132,4256 }, { 133,4256 },
 { 134,4256 }, { 135,4256 }, { 136,4256 }, { 137,4256 }, { 138,4256 },
 { 139,4256 }, { 140,4256 }, { 141,4256 }, { 142,4256 }, { 143,4256 },
 { 144,4256 }, { 145,4256 }, { 146,4256 }, { 147,4256 }, { 148,4256 },
 { 149,4256 }, { 150,4256 }, { 151,4256 }, { 152,4256 }, { 153,4256 },
 { 154,4256 }, { 155,4256 }, { 156,4256 }, { 157,4256 }, { 158,4256 },
 { 159,4256 }, { 160,4256 }, { 161,4256 }, { 162,4256 }, { 163,4256 },
 { 164,4256 }, { 165,4256 }, { 166,4256 }, { 167,4256 }, { 168,4256 },
 { 169,4256 }, { 170,4256 }, { 171,4256 }, { 172,4256 }, { 173,4256 },
 { 174,4256 }, { 175,4256 }, { 176,4256 }, { 177,4256 }, { 178,4256 },

 { 179,4256 }, { 180,4256 }, { 181,4256 }, { 182,4256 }, { 183,4256 },
 { 184,4256 }, { 185,4256 }, { 186,4256 }, { 187,4256 }, { 188,4256 },
 { 189,4256 }, { 190,4256 }, { 191,4256 }, { 192,4256 }, { 193,4256 },
 { 194,4256 }, { 195,4256 }, { 196,4256 }, { 197,4256 }, { 198,4256 },
 { 199,4256 }, { 200,4256 }, { 201,4256 }, { 202,4256 }, { 203,4256 },
 { 204,4256 }, { 205,4256 }, { 206,4256 }, { 207,4256 }, { 208,4256 },
 { 209,4256 }, { 210,4256 }, { 211,4256 }, { 212,4256 }, { 213,4256 },
 { 214,4256 }, { 215,4256 }, { 216,4256 }, { 217,4256 }, { 218,4256 },
 { 219,4256 }, { 220,4256 }, { 221,4256 }, { 222,4256 }, { 223,4256 },
 { 224,4256 }, { 225,4256 }, { 226,4256 }, { 227,4256 }, { 228,4256 },

 { 229,4256 }, { 230,4256 }, { 231,4256 }, { 232,4256 }, { 233,4256 },
 { 234,4256 }, { 235,4256 }, { 236,4256 }, { 237,4256 }, { 238,4256 },
 { 239,4256 }, { 240,4256 }, { 241,4256 }, { 242,4256 }, { 243,4256 },
 { 244,4256 }, { 245,4256 }, { 246,4256 }, { 247,4256 }, { 248,4256 },
 { 249,4256 }, { 250,4256 }, { 251,4256 }, { 252,4256 }, { 253,4256 },
 { 254,4256 }, { 255,4256 }, { 256,4256 }, {   0,   0 }, {   0,14561 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,14303 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  63 },
 {   0,14045 }, {   0,   1 }, {   0,14043 }, {   0,  38 }, {   0,14041 },

 {   0,   0 }, {   0,   1 }, {   0,14038 }, {   0,  54 }, {   0,14036 },
 {   0,   0 }, {   9,5098 }, {  10,5098 }, {   0,   0 }, {  12,5098 },
 {  13,5098 }, {   9,5093 }, {  10,5093 }, {   0,   0 }, {  12,5093 },
 {  13,5093 }, {   0,  13 }, {   0,14023 }, {   0,  53 }, {   0,14021 },
 {   0,   0 }, {   0,  53 }, {   0,14018 }, {   0,  16 }, {   0,14016 },
 {   0,   0 }, {   0,   6 }, {   0,14013 }, {   0,   0 }, {  32,5098 },
 {   0,   6 }, {   0,14009 }, {   0,   0 }, {   0,   0 }, {  32,5093 },
 {   0,  40 }, {   0,14004 }, {  33,5346 }, {   0,   0 }, {  35,5346 },
 {   0,   0 }, {  37,5346 }, {  38,5346 }, {   0,  54 }, {   0,13996 },
 {   0,   0 }, {  42,5346 }, {  43,5346 }, {   0,   0 }, {  45,5346 },

 {   0,   0 }, {  47,5346 }, {   0,  16 }, {   0,13987 }, {   0,  19 },
 {   0,13985 }, {   0,  18 }, {   0,13983 }, {   0,   0 }, {   0,  16 },
 {   0,13980 }, {   0,  41 }, {   0,13978 }, {   0,   0 }, {  60,5346 },
 {  61,5357 }, {  62,5346 }, {  63,5346 }, {  64,5346 }, {  42, 348 },
 {  34, 346 }, {   0,  25 }, {   0,13968 }, {  42,7050 }, {  47, 353 },
 {   0,  26 }, {   0,13964 }, {  33,5306 }, {   0,   0 }, {  35,5306 },
 {  58, 100 }, {  37,5306 }, {  38,5306 }, {  61, 102 }, {   0,   0 },
 {   0,   0 }, {  42,5306 }, {  43,5306 }, {   0,   0 }, {  45,5306 },
 {   0,   0 }, {  47,5306 }, {  39, 331 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 320 }, {   0,   0 }, {  94,5346 }, {  39, 324 },

 {  96,5346 }, {   0,   0 }, {  45,7994 }, {   0,   0 }, {  60,5306 },
 {  61,5306 }, {  62,5306 }, {  63,5306 }, {  64,5306 }, {   0,  63 },
 {   0,13930 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  25 }, {   0,13924 }, {   0,  32 }, {   0,13922 }, {   0,  46 },
 {   0,13920 }, {   0,  45 }, {   0,13918 }, {   0,  47 }, {   0,13916 },
 {   0,   8 }, {   0,13914 }, {   0,   0 }, { 124,5346 }, {   0,   0 },
 { 126,5346 }, {   0,  14 }, {   0,13908 }, {   0,  12 }, {   0,13906 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5306 }, {   0,   0 },
 {  96,5306 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5268 }, {  49,5268 },
 {  50,5268 }, {  51,5268 }, {  52,5268 }, {  53,5268 }, {  54,5268 },
 {  55,5268 }, {  56,5268 }, {  57,5268 }, { 124,5306 }, {   0,   0 },
 { 126,5306 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5331 }, {  66,5331 }, {  67,5331 }, {  68,5331 }, {  69,5331 },
 {  70,5331 }, {  71,5331 }, {  72,5331 }, {  73,5331 }, {  74,5331 },
 {  75,5331 }, {  76,5331 }, {  77,5331 }, {  78,5331 }, {  79,5331 },
 {  80,5331 }, {  81,5331 }, {  82,5331 }, {  83,5331 }, {  84,5331 },
 {  85,5331 }, {  86,5331 }, {  87,5331 }, {  88,5331 }, {  89,5331 },

 {  90,5331 }, {  85,9139 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5331 }, {   0,   0 }, {  97,5331 }, {  98,5331 }, {  99,5331 },
 { 100,5331 }, { 101,5331 }, { 102,5331 }, { 103,5331 }, { 104,5331 },
 { 105,5331 }, { 106,5331 }, { 107,5331 }, { 108,5331 }, { 109,5331 },
 { 110,5331 }, { 111,5331 }, { 112,5331 }, { 113,5331 }, { 114,5331 },
 { 115,5331 }, { 116,5331 }, { 117,5331 }, { 118,5331 }, { 119,5331 },
 { 120,5331 }, { 121,5331 }, { 122,5331 }, { 117,9162 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5331 }, { 129,5331 },
 { 130,5331 }, { 131,5331 }, { 132,5331 }, { 133,5331 }, { 134,5331 },
 { 135,5331 }, { 136,5331 }, { 137,5331 }, { 138,5331 }, { 139,5331 },

 { 140,5331 }, { 141,5331 }, { 142,5331 }, { 143,5331 }, { 144,5331 },
 { 145,5331 }, { 146,5331 }, { 147,5331 }, { 148,5331 }, { 149,5331 },
 { 150,5331 }, { 151,5331 }, { 152,5331 }, { 153,5331 }, { 154,5331 },
 { 155,5331 }, { 156,5331 }, { 157,5331 }, { 158,5331 }, { 159,5331 },
 { 160,5331 }, { 161,5331 }, { 162,5331 }, { 163,5331 }, { 164,5331 },
 { 165,5331 }, { 166,5331 }, { 167,5331 }, { 168,5331 }, { 169,5331 },
 { 170,5331 }, { 171,5331 }, { 172,5331 }, { 173,5331 }, { 174,5331 },
 { 175,5331 }, { 176,5331 }, { 177,5331 }, { 178,5331 }, { 179,5331 },
 { 180,5331 }, { 181,5331 }, { 182,5331 }, { 183,5331 }, { 184,5331 },
 { 185,5331 }, { 186,5331 }, { 187,5331 }, { 188,5331 }, { 189,5331 },

 { 190,5331 }, { 191,5331 }, { 192,5331 }, { 193,5331 }, { 194,5331 },
 { 195,5331 }, { 196,5331 }, { 197,5331 }, { 198,5331 }, { 199,5331 },
 { 200,5331 }, { 201,5331 }, { 202,5331 }, { 203,5331 }, { 204,5331 },
 { 205,5331 }, { 206,5331 }, { 207,5331 }, { 208,5331 }, { 209,5331 },
 { 210,5331 }, { 211,5331 }, { 212,5331 }, { 213,5331 }, { 214,5331 },
 { 215,5331 }, { 216,5331 }, { 217,5331 }, { 218,5331 }, { 219,5331 },
 { 220,5331 }, { 221,5331 }, { 222,5331 }, { 223,5331 }, { 224,5331 },
 { 225,5331 }, { 226,5331 }, { 227,5331 }, { 228,5331 }, { 229,5331 },
 { 230,5331 }, { 231,5331 }, { 232,5331 }, { 233,5331 }, { 234,5331 },
 { 235,5331 }, { 236,5331 }, { 237,5331 }, { 238,5331 }, { 239,5331 },

 { 240,5331 }, { 241,5331 }, { 242,5331 }, { 243,5331 }, { 244,5331 },
 { 245,5331 }, { 246,5331 }, { 247,5331 }, { 248,5331 }, { 249,5331 },
 { 250,5331 }, { 251,5331 }, { 252,5331 }, { 253,5331 }, { 254,5331 },
 { 255,5331 }, {   0,  53 }, {   0,13673 }, {   0,  44 }, {   0,13671 },
 {   0,  11 }, {   0,13669 }, {   0,   0 }, {   0,   0 }, {   0,   7 },
 {   0,13665 }, {   0,   0 }, {   0,  53 }, {   0,13662 }, {   0,   4 },
 {   0,13660 }, {   0,  42 }, {   0,13658 }, {   0,  20 }, {   0,13656 },
 {   0,   0 }, {   0,  18 }, {   0,13653 }, {   0,  17 }, {   0,13651 },
 {   0,  18 }, {   0,13649 }, {   0,  28 }, {   0,13647 }, {   0,  34 },
 {   0,13645 }, {   0,  53 }, {   0,13643 }, {   0,  58 }, {   0,13641 },

 {  33,4983 }, {   0,   0 }, {  35,4983 }, {  34,  38 }, {  37,4983 },
 {  38,4983 }, {   0,  39 }, {   0,13633 }, {  39,  50 }, {  42,4983 },
 {  43,4983 }, {  33,4972 }, {  45,4983 }, {  35,4972 }, {  47,4983 },
 {  37,4972 }, {  38,4972 }, {  42,   0 }, {   0,  15 }, {   0,13621 },
 {  42,4972 }, {  43,4972 }, {  47,   5 }, {  45,5320 }, {   0,   0 },
 {  47,4972 }, {   0,   0 }, {  60,4983 }, {  61,4983 }, {  62,4983 },
 {  63,4983 }, {  64,4983 }, {  45,7664 }, {   0,  29 }, {   0,13606 },
 {   0,   0 }, {  45,9939 }, {   0,   0 }, {  60,4972 }, {  61,4972 },
 {  62,4972 }, {  63,4972 }, {  64,4972 }, {  46,-277 }, {   0,   0 },
 {  48,5559 }, {  49,5559 }, {  50,5559 }, {  51,5559 }, {  52,5559 },

 {  53,5559 }, {  54,5559 }, {  55,5559 }, {  56,5559 }, {  57,5559 },
 {   0,  30 }, {   0,13584 }, {   0,  23 }, {   0,13582 }, {   0,  24 },
 {   0,13580 }, {  94,4983 }, {   0,   0 }, {  96,4983 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,13572 }, {   0,  56 },
 {   0,13570 }, {   0,   0 }, {  94,4972 }, {   0,   0 }, {  96,4972 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,4983 }, {   0,   0 }, { 126,4983 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  33,4882 }, { 124,4972 }, {  35,4882 }, { 126,4972 },
 {  37,4882 }, {  38,4882 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,5513 }, {  43,4882 }, {   0,   0 }, {  45,4882 }, {   0,   0 },
 {  47,4882 }, {  46,5513 }, {   0,   0 }, {  48,5577 }, {  49,5577 },
 {  50,5577 }, {  51,5577 }, {  52,5577 }, {  53,5577 }, {  54,5577 },
 {  55,5577 }, {  56,5577 }, {  57,5577 }, {  60,4882 }, {  61,4882 },
 {  62,4882 }, {  63,4882 }, {  64,4882 }, {   0,   0 }, {   0,  53 },
 {   0,13505 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  69,5599 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  53 }, {   0,13494 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,4882 }, {   0,   0 }, {  96,4882 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,4815 }, {   0,   0 },
 {  35,4815 }, { 101,5599 }, {  37,4815 }, {  38,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4815 }, {  43,4815 }, {  33,4804 },
 {  45,4815 }, {  35,4804 }, {  47,4815 }, {  37,4804 }, {  38,4804 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4804 }, {  43,4804 },
 {   0,   0 }, {  45,4804 }, { 124,4882 }, {  47,4804 }, { 126,4882 },
 {  60,4815 }, {  61,5574 }, {  62,5615 }, {  63,4815 }, {  64,4815 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,4804 }, {  61,4804 }, {  62,5671 }, {  63,4804 },
 {  64,4804 }, {   0,   0 }, {   0,  53 }, {   0,13427 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4815 },
 {   0,   0 }, {  96,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,4804 }, {   0,   0 }, {  96,4804 }, {   0,   0 }, {   0,  62 },
 {   0,13395 }, {  33,4737 }, {   0,   0 }, {  35,4737 }, {   0,   0 },

 {  37,4737 }, {  38,4737 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,4737 }, {  43,4737 }, {   0,   0 }, {  45,4737 }, { 124,4815 },
 {  47,4737 }, { 126,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,4804 }, {   0,   0 }, { 126,4804 }, {  60,4737 }, {  61,5615 },
 {  62,4737 }, {  63,4737 }, {  64,4737 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,5663 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5663 }, {  49,5663 },
 {  50,5663 }, {  51,5663 }, {  52,5663 }, {  53,5663 }, {  54,5663 },

 {  55,5663 }, {  56,5663 }, {  57,5663 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,4737 }, {   0,   0 }, {  96,4737 },
 {  65,5663 }, {  66,5663 }, {  67,5663 }, {  68,5663 }, {  69,5663 },
 {  70,5663 }, {  71,5663 }, {  72,5663 }, {  73,5663 }, {  74,5663 },
 {  75,5663 }, {  76,5663 }, {  77,5663 }, {  78,5663 }, {  79,5663 },
 {  80,5663 }, {  81,5663 }, {  82,5663 }, {  83,5663 }, {  84,5663 },
 {  85,5663 }, {  86,5663 }, {  87,5663 }, {  88,5663 }, {  89,5663 },
 {  90,5663 }, {   0,   0 }, { 124,4737 }, {   0,   0 }, { 126,4737 },
 {  95,5663 }, {   0,   0 }, {  97,5663 }, {  98,5663 }, {  99,5663 },
 { 100,5663 }, { 101,5663 }, { 102,5663 }, { 103,5663 }, { 104,5663 },

 { 105,5663 }, { 106,5663 }, { 107,5663 }, { 108,5663 }, { 109,5663 },
 { 110,5663 }, { 111,5663 }, { 112,5663 }, { 113,5663 }, { 114,5663 },
 { 115,5663 }, { 116,5663 }, { 117,5663 }, { 118,5663 }, { 119,5663 },
 { 120,5663 }, { 121,5663 }, { 122,5663 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5663 }, { 129,5663 },
 { 130,5663 }, { 131,5663 }, { 132,5663 }, { 133,5663 }, { 134,5663 },
 { 135,5663 }, { 136,5663 }, { 137,5663 }, { 138,5663 }, { 139,5663 },
 { 140,5663 }, { 141,5663 }, { 142,5663 }, { 143,5663 }, { 144,5663 },
 { 145,5663 }, { 146,5663 }, { 147,5663 }, { 148,5663 }, { 149,5663 },
 { 150,5663 }, { 151,5663 }, { 152,5663 }, { 153,5663 }, { 154,5663 },

 { 155,5663 }, { 156,5663 }, { 157,5663 }, { 158,5663 }, { 159,5663 },
 { 160,5663 }, { 161,5663 }, { 162,5663 }, { 163,5663 }, { 164,5663 },
 { 165,5663 }, { 166,5663 }, { 167,5663 }, { 168,5663 }, { 169,5663 },
 { 170,5663 }, { 171,5663 }, { 172,5663 }, { 173,5663 }, { 174,5663 },
 { 175,5663 }, { 176,5663 }, { 177,5663 }, { 178,5663 }, { 179,5663 },
 { 180,5663 }, { 181,5663 }, { 182,5663 }, { 183,5663 }, { 184,5663 },
 { 185,5663 }, { 186,5663 }, { 187,5663 }, { 188,5663 }, { 189,5663 },
 { 190,5663 }, { 191,5663 }, { 192,5663 }, { 193,5663 }, { 194,5663 },
 { 195,5663 }, { 196,5663 }, { 197,5663 }, { 198,5663 }, { 199,5663 },
 { 200,5663 }, { 201,5663 }, { 202,5663 }, { 203,5663 }, { 204,5663 },

 { 205,5663 }, { 206,5663 }, { 207,5663 }, { 208,5663 }, { 209,5663 },
 { 210,5663 }, { 211,5663 }, { 212,5663 }, { 213,5663 }, { 214,5663 },
 { 215,5663 }, { 216,5663 }, { 217,5663 }, { 218,5663 }, { 219,5663 },
 { 220,5663 }, { 221,5663 }, { 222,5663 }, { 223,5663 }, { 224,5663 },
 { 225,5663 }, { 226,5663 }, { 227,5663 }, { 228,5663 }, { 229,5663 },
 { 230,5663 }, { 231,5663 }, { 232,5663 }, { 233,5663 }, { 234,5663 },
 { 235,5663 }, { 236,5663 }, { 237,5663 }, { 238,5663 }, { 239,5663 },
 { 240,5663 }, { 241,5663 }, { 242,5663 }, { 243,5663 }, { 244,5663 },
 { 245,5663 }, { 246,5663 }, { 247,5663 }, { 248,5663 }, { 249,5663 },
 { 250,5663 }, { 251,5663 }, { 252,5663 }, { 253,5663 }, { 254,5663 },

 { 255,5663 }, {   0,  62 }, {   0,13138 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5406 }, {   0,   0 },
 {   0,   0 }, {  39,-776 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,5406 }, {  49,5406 }, {  50,5406 }, {  51,5406 }, {  52,5406 },
 {  53,5406 }, {  54,5406 }, {  55,5406 }, {  56,5406 }, {  57,5406 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5406 }, {  66,5406 }, {  67,5406 },
 {  68,5406 }, {  69,5406 }, {  70,5406 }, {  71,5406 }, {  72,5406 },
 {  73,5406 }, {  74,5406 }, {  75,5406 }, {  76,5406 }, {  77,5406 },
 {  78,5406 }, {  79,5406 }, {  80,5406 }, {  81,5406 }, {  82,5406 },
 {  83,5406 }, {  84,5406 }, {  85,5406 }, {  86,5406 }, {  87,5406 },
 {  88,5406 }, {  89,5406 }, {  90,5406 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5406 }, {   0,   0 }, {  97,5406 },

 {  98,5406 }, {  99,5406 }, { 100,5406 }, { 101,5406 }, { 102,5406 },
 { 103,5406 }, { 104,5406 }, { 105,5406 }, { 106,5406 }, { 107,5406 },
 { 108,5406 }, { 109,5406 }, { 110,5406 }, { 111,5406 }, { 112,5406 },
 { 113,5406 }, { 114,5406 }, { 115,5406 }, { 116,5406 }, { 117,5406 },
 { 118,5406 }, { 119,5406 }, { 120,5406 }, { 121,5406 }, { 122,5406 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5406 }, { 129,5406 }, { 130,5406 }, { 131,5406 }, { 132,5406 },
 { 133,5406 }, { 134,5406 }, { 135,5406 }, { 136,5406 }, { 137,5406 },
 { 138,5406 }, { 139,5406 }, { 140,5406 }, { 141,5406 }, { 142,5406 },
 { 143,5406 }, { 144,5406 }, { 145,5406 }, { 146,5406 }, { 147,5406 },

 { 148,5406 }, { 149,5406 }, { 150,5406 }, { 151,5406 }, { 152,5406 },
 { 153,5406 }, { 154,5406 }, { 155,5406 }, { 156,5406 }, { 157,5406 },
 { 158,5406 }, { 159,5406 }, { 160,5406 }, { 161,5406 }, { 162,5406 },
 { 163,5406 }, { 164,5406 }, { 165,5406 }, { 166,5406 }, { 167,5406 },
 { 168,5406 }, { 169,5406 }, { 170,5406 }, { 171,5406 }, { 172,5406 },
 { 173,5406 }, { 174,5406 }, { 175,5406 }, { 176,5406 }, { 177,5406 },
 { 178,5406 }, { 179,5406 }, { 180,5406 }, { 181,5406 }, { 182,5406 },
 { 183,5406 }, { 184,5406 }, { 185,5406 }, { 186,5406 }, { 187,5406 },
 { 188,5406 }, { 189,5406 }, { 190,5406 }, { 191,5406 }, { 192,5406 },
 { 193,5406 }, { 194,5406 }, { 195,5406 }, { 196,5406 }, { 197,5406 },

 { 198,5406 }, { 199,5406 }, { 200,5406 }, { 201,5406 }, { 202,5406 },
 { 203,5406 }, { 204,5406 }, { 205,5406 }, { 206,5406 }, { 207,5406 },
 { 208,5406 }, { 209,5406 }, { 210,5406 }, { 211,5406 }, { 212,5406 },
 { 213,5406 }, { 214,5406 }, { 215,5406 }, { 216,5406 }, { 217,5406 },
 { 218,5406 }, { 219,5406 }, { 220,5406 }, { 221,5406 }, { 222,5406 },
 { 223,5406 }, { 224,5406 }, { 225,5406 }, { 226,5406 }, { 227,5406 },
 { 228,5406 }, { 229,5406 }, { 230,5406 }, { 231,5406 }, { 232,5406 },
 { 233,5406 }, { 234,5406 }, { 235,5406 }, { 236,5406 }, { 237,5406 },
 { 238,5406 }, { 239,5406 }, { 240,5406 }, { 241,5406 }, { 242,5406 },
 { 243,5406 }, { 244,5406 }, { 245,5406 }, { 246,5406 }, { 247,5406 },

 { 248,5406 }, { 249,5406 }, { 250,5406 }, { 251,5406 }, { 252,5406 },
 { 253,5406 }, { 254,5406 }, { 255,5406 }, {   0,  62 }, {   0,12881 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,5149 }, {   0,   0 }, {   0,   0 }, {  39,-1027 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,5149 }, {  49,5149 }, {  50,5149 },
 {  51,5149 }, {  52,5149 }, {  53,5149 }, {  54,5149 }, {  55,5149 },
 {  56,5149 }, {  57,5149 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5149 },
 {  66,5149 }, {  67,5149 }, {  68,5149 }, {  69,5149 }, {  70,5149 },
 {  71,5149 }, {  72,5149 }, {  73,5149 }, {  74,5149 }, {  75,5149 },
 {  76,5149 }, {  77,5149 }, {  78,5149 }, {  79,5149 }, {  80,5149 },
 {  81,5149 }, {  82,5149 }, {  83,5149 }, {  84,5149 }, {  85,5149 },
 {  86,5149 }, {  87,5149 }, {  88,5149 }, {  89,5149 }, {  90,5149 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5149 },
 {   0,   0 }, {  97,5149 }, {  98,5149 }, {  99,5149 }, { 100,5149 },
 { 101,5149 }, { 102,5149 }, { 103,5149 }, { 104,5149 }, { 105,5149 },
 { 106,5149 }, { 107,5149 }, { 108,5149 }, { 109,5149 }, { 110,5149 },
 { 111,5149 }, { 112,5149 }, { 113,5149 }, { 114,5149 }, { 115,5149 },
 { 116,5149 }, { 117,5149 }, { 118,5149 }, { 119,5149 }, { 120,5149 },
 { 121,5149 }, { 122,5149 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5149 }, { 129,5149 }, { 130,5149 },
 { 131,5149 }, { 132,5149 }, { 133,5149 }, { 134,5149 }, { 135,5149 },
 { 136,5149 }, { 137,5149 }, { 138,5149 }, { 139,5149 }, { 140,5149 },

 { 141,5149 }, { 142,5149 }, { 143,5149 }, { 144,5149 }, { 145,5149 },
 { 146,5149 }, { 147,5149 }, { 148,5149 }, { 149,5149 }, { 150,5149 },
 { 151,5149 }, { 152,5149 }, { 153,5149 }, { 154,5149 }, { 155,5149 },
 { 156,5149 }, { 157,5149 }, { 158,5149 }, { 159,5149 }, { 160,5149 },
 { 161,5149 }, { 162,5149 }, { 163,5149 }, { 164,5149 }, { 165,5149 },
 { 166,5149 }, { 167,5149 }, { 168,5149 }, { 169,5149 }, { 170,5149 },
 { 171,5149 }, { 172,5149 }, { 173,5149 }, { 174,5149 }, { 175,5149 },
 { 176,5149 }, { 177,5149 }, { 178,5149 }, { 179,5149 }, { 180,5149 },
 { 181,5149 }, { 182,5149 }, { 183,5149 }, { 184,5149 }, { 185,5149 },
 { 186,5149 }, { 187,5149 }, { 188,5149 }, { 189,5149 }, { 190,5149 },

 { 191,5149 }, { 192,5149 }, { 193,5149 }, { 194,5149 }, { 195,5149 },
 { 196,5149 }, { 197,5149 }, { 198,5149 }, { 199,5149 }, { 200,5149 },
 { 201,5149 }, { 202,5149 }, { 203,5149 }, { 204,5149 }, { 205,5149 },
 { 206,5149 }, { 207,5149 }, { 208,5149 }, { 209,5149 }, { 210,5149 },
 { 211,5149 }, { 212,5149 }, { 213,5149 }, { 214,5149 }, { 215,5149 },
 { 216,5149 }, { 217,5149 }, { 218,5149 }, { 219,5149 }, { 220,5149 },
 { 221,5149 }, { 222,5149 }, { 223,5149 }, { 224,5149 }, { 225,5149 },
 { 226,5149 }, { 227,5149 }, { 228,5149 }, { 229,5149 }, { 230,5149 },
 { 231,5149 }, { 232,5149 }, { 233,5149 }, { 234,5149 }, { 235,5149 },
 { 236,5149 }, { 237,5149 }, { 238,5149 }, { 239,5149 }, { 240,5149 },

 { 241,5149 }, { 242,5149 }, { 243,5149 }, { 244,5149 }, { 245,5149 },
 { 246,5149 }, { 247,5149 }, { 248,5149 }, { 249,5149 }, { 250,5149 },
 { 251,5149 }, { 252,5149 }, { 253,5149 }, { 254,5149 }, { 255,5149 },
 {   0,  62 }, {   0,12624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  36,4892 }, {   0,   0 }, {   0,   0 },
 {  39,-1282 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4892 },
 {  49,4892 }, {  50,4892 }, {  51,4892 }, {  52,4892 }, {  53,4892 },
 {  54,4892 }, {  55,4892 }, {  56,4892 }, {  57,4892 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,4892 }, {  66,4892 }, {  67,4892 }, {  68,4892 },
 {  69,4892 }, {  70,4892 }, {  71,4892 }, {  72,4892 }, {  73,4892 },
 {  74,4892 }, {  75,4892 }, {  76,4892 }, {  77,4892 }, {  78,4892 },
 {  79,4892 }, {  80,4892 }, {  81,4892 }, {  82,4892 }, {  83,4892 },

 {  84,4892 }, {  85,4892 }, {  86,4892 }, {  87,4892 }, {  88,4892 },
 {  89,4892 }, {  90,4892 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,4892 }, {   0,   0 }, {  97,4892 }, {  98,4892 },
 {  99,4892 }, { 100,4892 }, { 101,4892 }, { 102,4892 }, { 103,4892 },
 { 104,4892 }, { 105,4892 }, { 106,4892 }, { 107,4892 }, { 108,4892 },
 { 109,4892 }, { 110,4892 }, { 111,4892 }, { 112,4892 }, { 113,4892 },
 { 114,4892 }, { 115,4892 }, { 116,4892 }, { 117,4892 }, { 118,4892 },
 { 119,4892 }, { 120,4892 }, { 121,4892 }, { 122,4892 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4892 },
 { 129,4892 }, { 130,4892 }, { 131,4892 }, { 132,4892 }, { 133,4892 },

 { 134,4892 }, { 135,4892 }, { 136,4892 }, { 137,4892 }, { 138,4892 },
 { 139,4892 }, { 140,4892 }, { 141,4892 }, { 142,4892 }, { 143,4892 },
 { 144,4892 }, { 145,4892 }, { 146,4892 }, { 147,4892 }, { 148,4892 },
 { 149,4892 }, { 150,4892 }, { 151,4892 }, { 152,4892 }, { 153,4892 },
 { 154,4892 }, { 155,4892 }, { 156,4892 }, { 157,4892 }, { 158,4892 },
 { 159,4892 }, { 160,4892 }, { 161,4892 }, { 162,4892 }, { 163,4892 },
 { 164,4892 }, { 165,4892 }, { 166,4892 }, { 167,4892 }, { 168,4892 },
 { 169,4892 }, { 170,4892 }, { 171,4892 }, { 172,4892 }, { 173,4892 },
 { 174,4892 }, { 175,4892 }, { 176,4892 }, { 177,4892 }, { 178,4892 },
 { 179,4892 }, { 180,4892 }, { 181,4892 }, { 182,4892 }, { 183,4892 },

 { 184,4892 }, { 185,4892 }, { 186,4892 }, { 187,4892 }, { 188,4892 },
 { 189,4892 }, { 190,4892 }, { 191,4892 }, { 192,4892 }, { 193,4892 },
 { 194,4892 }, { 195,4892 }, { 196,4892 }, { 197,4892 }, { 198,4892 },
 { 199,4892 }, { 200,4892 }, { 201,4892 }, { 202,4892 }, { 203,4892 },
 { 204,4892 }, { 205,4892 }, { 206,4892 }, { 207,4892 }, { 208,4892 },
 { 209,4892 }, { 210,4892 }, { 211,4892 }, { 212,4892 }, { 213,4892 },
 { 214,4892 }, { 215,4892 }, { 216,4892 }, { 217,4892 }, { 218,4892 },
 { 219,4892 }, { 220,4892 }, { 221,4892 }, { 222,4892 }, { 223,4892 },
 { 224,4892 }, { 225,4892 }, { 226,4892 }, { 227,4892 }, { 228,4892 },
 { 229,4892 }, { 230,4892 }, { 231,4892 }, { 232,4892 }, { 233,4892 },

 { 234,4892 }, { 235,4892 }, { 236,4892 }, { 237,4892 }, { 238,4892 },
 { 239,4892 }, { 240,4892 }, { 241,4892 }, { 242,4892 }, { 243,4892 },
 { 244,4892 }, { 245,4892 }, { 246,4892 }, { 247,4892 }, { 248,4892 },
 { 249,4892 }, { 250,4892 }, { 251,4892 }, { 252,4892 }, { 253,4892 },
 { 254,4892 }, { 255,4892 }, {   0,  62 }, {   0,12367 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,4635 },
 {   0,   0 }, {  38,-1304 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,4635 }, {  49,4635 }, {  50,4635 }, {  51,4635 },
 {  52,4635 }, {  53,4635 }, {  54,4635 }, {  55,4635 }, {  56,4635 },
 {  57,4635 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4635 }, {  66,4635 },
 {  67,4635 }, {  68,4635 }, {  69,4635 }, {  70,4635 }, {  71,4635 },
 {  72,4635 }, {  73,4635 }, {  74,4635 }, {  75,4635 }, {  76,4635 },

 {  77,4635 }, {  78,4635 }, {  79,4635 }, {  80,4635 }, {  81,4635 },
 {  82,4635 }, {  83,4635 }, {  84,4635 }, {  85,4635 }, {  86,4635 },
 {  87,4635 }, {  88,4635 }, {  89,4635 }, {  90,4635 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4635 }, {   0,   0 },
 {  97,4635 }, {  98,4635 }, {  99,4635 }, { 100,4635 }, { 101,4635 },
 { 102,4635 }, { 103,4635 }, { 104,4635 }, { 105,4635 }, { 106,4635 },
 { 107,4635 }, { 108,4635 }, { 109,4635 }, { 110,4635 }, { 111,4635 },
 { 112,4635 }, { 113,4635 }, { 114,4635 }, { 115,4635 }, { 116,4635 },
 { 117,4635 }, { 118,4635 }, { 119,4635 }, { 120,4635 }, { 121,4635 },
 { 122,4635 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, { 128,4635 }, { 129,4635 }, { 130,4635 }, { 131,4635 },
 { 132,4635 }, { 133,4635 }, { 134,4635 }, { 135,4635 }, { 136,4635 },
 { 137,4635 }, { 138,4635 }, { 139,4635 }, { 140,4635 }, { 141,4635 },
 { 142,4635 }, { 143,4635 }, { 144,4635 }, { 145,4635 }, { 146,4635 },
 { 147,4635 }, { 148,4635 }, { 149,4635 }, { 150,4635 }, { 151,4635 },
 { 152,4635 }, { 153,4635 }, { 154,4635 }, { 155,4635 }, { 156,4635 },
 { 157,4635 }, { 158,4635 }, { 159,4635 }, { 160,4635 }, { 161,4635 },
 { 162,4635 }, { 163,4635 }, { 164,4635 }, { 165,4635 }, { 166,4635 },
 { 167,4635 }, { 168,4635 }, { 169,4635 }, { 170,4635 }, { 171,4635 },
 { 172,4635 }, { 173,4635 }, { 174,4635 }, { 175,4635 }, { 176,4635 },

 { 177,4635 }, { 178,4635 }, { 179,4635 }, { 180,4635 }, { 181,4635 },
 { 182,4635 }, { 183,4635 }, { 184,4635 }, { 185,4635 }, { 186,4635 },
 { 187,4635 }, { 188,4635 }, { 189,4635 }, { 190,4635 }, { 191,4635 },
 { 192,4635 }, { 193,4635 }, { 194,4635 }, { 195,4635 }, { 196,4635 },
 { 197,4635 }, { 198,4635 }, { 199,4635 }, { 200,4635 }, { 201,4635 },
 { 202,4635 }, { 203,4635 }, { 204,4635 }, { 205,4635 }, { 206,4635 },
 { 207,4635 }, { 208,4635 }, { 209,4635 }, { 210,4635 }, { 211,4635 },
 { 212,4635 }, { 213,4635 }, { 214,4635 }, { 215,4635 }, { 216,4635 },
 { 217,4635 }, { 218,4635 }, { 219,4635 }, { 220,4635 }, { 221,4635 },
 { 222,4635 }, { 223,4635 }, { 224,4635 }, { 225,4635 }, { 226,4635 },

 { 227,4635 }, { 228,4635 }, { 229,4635 }, { 230,4635 }, { 231,4635 },
 { 232,4635 }, { 233,4635 }, { 234,4635 }, { 235,4635 }, { 236,4635 },
 { 237,4635 }, { 238,4635 }, { 239,4635 }, { 240,4635 }, { 241,4635 },
 { 242,4635 }, { 243,4635 }, { 244,4635 }, { 245,4635 }, { 246,4635 },
 { 247,4635 }, { 248,4635 }, { 249,4635 }, { 250,4635 }, { 251,4635 },
 { 252,4635 }, { 253,4635 }, { 254,4635 }, { 255,4635 }, {   0,  62 },
 {   0,12110 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,4378 }, {   0,   0 }, {   0,   0 }, {  39,-1559 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4378 }, {  49,4378 },
 {  50,4378 }, {  51,4378 }, {  52,4378 }, {  53,4378 }, {  54,4378 },
 {  55,4378 }, {  56,4378 }, {  57,4378 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4378 }, {  66,4378 }, {  67,4378 }, {  68,4378 }, {  69,4378 },

 {  70,4378 }, {  71,4378 }, {  72,4378 }, {  73,4378 }, {  74,4378 },
 {  75,4378 }, {  76,4378 }, {  77,4378 }, {  78,4378 }, {  79,4378 },
 {  80,4378 }, {  81,4378 }, {  82,4378 }, {  83,4378 }, {  84,4378 },
 {  85,4378 }, {  86,4378 }, {  87,4378 }, {  88,4378 }, {  89,4378 },
 {  90,4378 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,4378 }, {   0,   0 }, {  97,4378 }, {  98,4378 }, {  99,4378 },
 { 100,4378 }, { 101,4378 }, { 102,4378 }, { 103,4378 }, { 104,4378 },
 { 105,4378 }, { 106,4378 }, { 107,4378 }, { 108,4378 }, { 109,4378 },
 { 110,4378 }, { 111,4378 }, { 112,4378 }, { 113,4378 }, { 114,4378 },
 { 115,4378 }, { 116,4378 }, { 117,4378 }, { 118,4378 }, { 119,4378 },

 { 120,4378 }, { 121,4378 }, { 122,4378 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4378 }, { 129,4378 },
 { 130,4378 }, { 131,4378 }, { 132,4378 }, { 133,4378 }, { 134,4378 },
 { 135,4378 }, { 136,4378 }, { 137,4378 }, { 138,4378 }, { 139,4378 },
 { 140,4378 }, { 141,4378 }, { 142,4378 }, { 143,4378 }, { 144,4378 },
 { 145,4378 }, { 146,4378 }, { 147,4378 }, { 148,4378 }, { 149,4378 },
 { 150,4378 }, { 151,4378 }, { 152,4378 }, { 153,4378 }, { 154,4378 },
 { 155,4378 }, { 156,4378 }, { 157,4378 }, { 158,4378 }, { 159,4378 },
 { 160,4378 }, { 161,4378 }, { 162,4378 }, { 163,4378 }, { 164,4378 },
 { 165,4378 }, { 166,4378 }, { 167,4378 }, { 168,4378 }, { 169,4378 },

 { 170,4378 }, { 171,4378 }, { 172,4378 }, { 173,4378 }, { 174,4378 },
 { 175,4378 }, { 176,4378 }, { 177,4378 }, { 178,4378 }, { 179,4378 },
 { 180,4378 }, { 181,4378 }, { 182,4378 }, { 183,4378 }, { 184,4378 },
 { 185,4378 }, { 186,4378 }, { 187,4378 }, { 188,4378 }, { 189,4378 },
 { 190,4378 }, { 191,4378 }, { 192,4378 }, { 193,4378 }, { 194,4378 },
 { 195,4378 }, { 196,4378 }, { 197,4378 }, { 198,4378 }, { 199,4378 },
 { 200,4378 }, { 201,4378 }, { 202,4378 }, { 203,4378 }, { 204,4378 },
 { 205,4378 }, { 206,4378 }, { 207,4378 }, { 208,4378 }, { 209,4378 },
 { 210,4378 }, { 211,4378 }, { 212,4378 }, { 213,4378 }, { 214,4378 },
 { 215,4378 }, { 216,4378 }, { 217,4378 }, { 218,4378 }, { 219,4378 },

 { 220,4378 }, { 221,4378 }, { 222,4378 }, { 223,4378 }, { 224,4378 },
 { 225,4378 }, { 226,4378 }, { 227,4378 }, { 228,4378 }, { 229,4378 },
 { 230,4378 }, { 231,4378 }, { 232,4378 }, { 233,4378 }, { 234,4378 },
 { 235,4378 }, { 236,4378 }, { 237,4378 }, { 238,4378 }, { 239,4378 },
 { 240,4378 }, { 241,4378 }, { 242,4378 }, { 243,4378 }, { 244,4378 },
 { 245,4378 }, { 246,4378 }, { 247,4378 }, { 248,4378 }, { 249,4378 },
 { 250,4378 }, { 251,4378 }, { 252,4378 }, { 253,4378 }, { 254,4378 },
 { 255,4378 }, {   0,  10 }, {   0,11853 }, {   1,4378 }, {   2,4378 },
 {   3,4378 }, {   4,4378 }, {   5,4378 }, {   6,4378 }, {   7,4378 },
 {   8,4378 }, {   9,4378 }, {  10,4378 }, {  11,4378 }, {  12,4378 },

 {  13,4378 }, {  14,4378 }, {  15,4378 }, {  16,4378 }, {  17,4378 },
 {  18,4378 }, {  19,4378 }, {  20,4378 }, {  21,4378 }, {  22,4378 },
 {  23,4378 }, {  24,4378 }, {  25,4378 }, {  26,4378 }, {  27,4378 },
 {  28,4378 }, {  29,4378 }, {  30,4378 }, {  31,4378 }, {  32,4378 },
 {  33,4378 }, {  34,4378 }, {  35,4378 }, {  36,4378 }, {  37,4378 },
 {  38,4378 }, {   0,   0 }, {  40,4378 }, {  41,4378 }, {  42,4378 },
 {  43,4378 }, {  44,4378 }, {  45,4378 }, {  46,4378 }, {  47,4378 },
 {  48,4378 }, {  49,4378 }, {  50,4378 }, {  51,4378 }, {  52,4378 },
 {  53,4378 }, {  54,4378 }, {  55,4378 }, {  56,4378 }, {  57,4378 },
 {  58,4378 }, {  59,4378 }, {  60,4378 }, {  61,4378 }, {  62,4378 },

 {  63,4378 }, {  64,4378 }, {  65,4378 }, {  66,4378 }, {  67,4378 },
 {  68,4378 }, {  69,4378 }, {  70,4378 }, {  71,4378 }, {  72,4378 },
 {  73,4378 }, {  74,4378 }, {  75,4378 }, {  76,4378 }, {  77,4378 },
 {  78,4378 }, {  79,4378 }, {  80,4378 }, {  81,4378 }, {  82,4378 },
 {  83,4378 }, {  84,4378 }, {  85,4378 }, {  86,4378 }, {  87,4378 },
 {  88,4378 }, {  89,4378 }, {  90,4378 }, {  91,4378 }, {  92,4378 },
 {  93,4378 }, {  94,4378 }, {  95,4378 }, {  96,4378 }, {  97,4378 },
 {  98,4378 }, {  99,4378 }, { 100,4378 }, { 101,4378 }, { 102,4378 },
 { 103,4378 }, { 104,4378 }, { 105,4378 }, { 106,4378 }, { 107,4378 },
 { 108,4378 }, { 109,4378 }, { 110,4378 }, { 111,4378 }, { 112,4378 },

 { 113,4378 }, { 114,4378 }, { 115,4378 }, { 116,4378 }, { 117,4378 },
 { 118,4378 }, { 119,4378 }, { 120,4378 }, { 121,4378 }, { 122,4378 },
 { 123,4378 }, { 124,4378 }, { 125,4378 }, { 126,4378 }, { 127,4378 },
 { 128,4378 }, { 129,4378 }, { 130,4378 }, { 131,4378 }, { 132,4378 },
 { 133,4378 }, { 134,4378 }, { 135,4378 }, { 136,4378 }, { 137,4378 },
 { 138,4378 }, { 139,4378 }, { 140,4378 }, { 141,4378 }, { 142,4378 },
 { 143,4378 }, { 144,4378 }, { 145,4378 }, { 146,4378 }, { 147,4378 },
 { 148,4378 }, { 149,4378 }, { 150,4378 }, { 151,4378 }, { 152,4378 },
 { 153,4378 }, { 154,4378 }, { 155,4378 }, { 156,4378 }, { 157,4378 },
 { 158,4378 }, { 159,4378 }, { 160,4378 }, { 161,4378 }, { 162,4378 },

 { 163,4378 }, { 164,4378 }, { 165,4378 }, { 166,4378 }, { 167,4378 },
 { 168,4378 }, { 169,4378 }, { 170,4378 }, { 171,4378 }, { 172,4378 },
 { 173,4378 }, { 174,4378 }, { 175,4378 }, { 176,4378 }, { 177,4378 },
 { 178,4378 }, { 179,4378 }, { 180,4378 }, { 181,4378 }, { 182,4378 },
 { 183,4378 }, { 184,4378 }, { 185,4378 }, { 186,4378 }, { 187,4378 },
 { 188,4378 }, { 189,4378 }, { 190,4378 }, { 191,4378 }, { 192,4378 },
 { 193,4378 }, { 194,4378 }, { 195,4378 }, { 196,4378 }, { 197,4378 },
 { 198,4378 }, { 199,4378 }, { 200,4378 }, { 201,4378 }, { 202,4378 },
 { 203,4378 }, { 204,4378 }, { 205,4378 }, { 206,4378 }, { 207,4378 },
 { 208,4378 }, { 209,4378 }, { 210,4378 }, { 211,4378 }, { 212,4378 },

 { 213,4378 }, { 214,4378 }, { 215,4378 }, { 216,4378 }, { 217,4378 },
 { 218,4378 }, { 219,4378 }, { 220,4378 }, { 221,4378 }, { 222,4378 },
 { 223,4378 }, { 224,4378 }, { 225,4378 }, { 226,4378 }, { 227,4378 },
 { 228,4378 }, { 229,4378 }, { 230,4378 }, { 231,4378 }, { 232,4378 },
 { 233,4378 }, { 234,4378 }, { 235,4378 }, { 236,4378 }, { 237,4378 },
 { 238,4378 }, { 239,4378 }, { 240,4378 }, { 241,4378 }, { 242,4378 },
 { 243,4378 }, { 244,4378 }, { 245,4378 }, { 246,4378 }, { 247,4378 },
 { 248,4378 }, { 249,4378 }, { 250,4378 }, { 251,4378 }, { 252,4378 },
 { 253,4378 }, { 254,4378 }, { 255,4378 }, { 256,4378 }, {   0,   5 },
 {   0,11595 }, {   1,4378 }, {   2,4378 }, {   3,4378 }, {   4,4378 },

 {   5,4378 }, {   6,4378 }, {   7,4378 }, {   8,4378 }, {   9,4378 },
 {  10,4378 }, {  11,4378 }, {  12,4378 }, {  13,4378 }, {  14,4378 },
 {  15,4378 }, {  16,4378 }, {  17,4378 }, {  18,4378 }, {  19,4378 },
 {  20,4378 }, {  21,4378 }, {  22,4378 }, {  23,4378 }, {  24,4378 },
 {  25,4378 }, {  26,4378 }, {  27,4378 }, {  28,4378 }, {  29,4378 },
 {  30,4378 }, {  31,4378 }, {  32,4378 }, {  33,4378 }, {  34,4378 },
 {  35,4378 }, {  36,4378 }, {  37,4378 }, {  38,4378 }, {  39,4378 },
 {  40,4378 }, {  41,4378 }, {   0,   0 }, {  43,4378 }, {  44,4378 },
 {  45,4378 }, {  46,4378 }, {   0,   0 }, {  48,4378 }, {  49,4378 },
 {  50,4378 }, {  51,4378 }, {  52,4378 }, {  53,4378 }, {  54,4378 },

 {  55,4378 }, {  56,4378 }, {  57,4378 }, {  58,4378 }, {  59,4378 },
 {  60,4378 }, {  61,4378 }, {  62,4378 }, {  63,4378 }, {  64,4378 },
 {  65,4378 }, {  66,4378 }, {  67,4378 }, {  68,4378 }, {  69,4378 },
 {  70,4378 }, {  71,4378 }, {  72,4378 }, {  73,4378 }, {  74,4378 },
 {  75,4378 }, {  76,4378 }, {  77,4378 }, {  78,4378 }, {  79,4378 },
 {  80,4378 }, {  81,4378 }, {  82,4378 }, {  83,4378 }, {  84,4378 },
 {  85,4378 }, {  86,4378 }, {  87,4378 }, {  88,4378 }, {  89,4378 },
 {  90,4378 }, {  91,4378 }, {  92,4378 }, {  93,4378 }, {  94,4378 },
 {  95,4378 }, {  96,4378 }, {  97,4378 }, {  98,4378 }, {  99,4378 },
 { 100,4378 }, { 101,4378 }, { 102,4378 }, { 103,4378 }, { 104,4378 },

 { 105,4378 }, { 106,4378 }, { 107,4378 }, { 108,4378 }, { 109,4378 },
 { 110,4378 }, { 111,4378 }, { 112,4378 }, { 113,4378 }, { 114,4378 },
 { 115,4378 }, { 116,4378 }, { 117,4378 }, { 118,4378 }, { 119,4378 },
 { 120,4378 }, { 121,4378 }, { 122,4378 }, { 123,4378 }, { 124,4378 },
 { 125,4378 }, { 126,4378 }, { 127,4378 }, { 128,4378 }, { 129,4378 },
 { 130,4378 }, { 131,4378 }, { 132,4378 }, { 133,4378 }, { 134,4378 },
 { 135,4378 }, { 136,4378 }, { 137,4378 }, { 138,4378 }, { 139,4378 },
 { 140,4378 }, { 141,4378 }, { 142,4378 }, { 143,4378 }, { 144,4378 },
 { 145,4378 }, { 146,4378 }, { 147,4378 }, { 148,4378 }, { 149,4378 },
 { 150,4378 }, { 151,4378 }, { 152,4378 }, { 153,4378 }, { 154,4378 },

 { 155,4378 }, { 156,4378 }, { 157,4378 }, { 158,4378 }, { 159,4378 },
 { 160,4378 }, { 161,4378 }, { 162,4378 }, { 163,4378 }, { 164,4378 },
 { 165,4378 }, { 166,4378 }, { 167,4378 }, { 168,4378 }, { 169,4378 },
 { 170,4378 }, { 171,4378 }, { 172,4378 }, { 173,4378 }, { 174,4378 },
 { 175,4378 }, { 176,4378 }, { 177,4378 }, { 178,4378 }, { 179,4378 },
 { 180,4378 }, { 181,4378 }, { 182,4378 }, { 183,4378 }, { 184,4378 },
 { 185,4378 }, { 186,4378 }, { 187,4378 }, { 188,4378 }, { 189,4378 },
 { 190,4378 }, { 191,4378 }, { 192,4378 }, { 193,4378 }, { 194,4378 },
 { 195,4378 }, { 196,4378 }, { 197,4378 }, { 198,4378 }, { 199,4378 },
 { 200,4378 }, { 201,4378 }, { 202,4378 }, { 203,4378 }, { 204,4378 },

 { 205,4378 }, { 206,4378 }, { 207,4378 }, { 208,4378 }, { 209,4378 },
 { 210,4378 }, { 211,4378 }, { 212,4378 }, { 213,4378 }, { 214,4378 },
 { 215,4378 }, { 216,4378 }, { 217,4378 }, { 218,4378 }, { 219,4378 },
 { 220,4378 }, { 221,4378 }, { 222,4378 }, { 223,4378 }, { 224,4378 },
 { 225,4378 }, { 226,4378 }, { 227,4378 }, { 228,4378 }, { 229,4378 },
 { 230,4378 }, { 231,4378 }, { 232,4378 }, { 233,4378 }, { 234,4378 },
 { 235,4378 }, { 236,4378 }, { 237,4378 }, { 238,4378 }, { 239,4378 },
 { 240,4378 }, { 241,4378 }, { 242,4378 }, { 243,4378 }, { 244,4378 },
 { 245,4378 }, { 246,4378 }, { 247,4378 }, { 248,4378 }, { 249,4378 },
 { 250,4378 }, { 251,4378 }, { 252,4378 }, { 253,4378 }, { 254,4378 },

 { 255,4378 }, { 256,4378 }, {   0,   5 }, {   0,11337 }, {   1,4120 },
 {   2,4120 }, {   3,4120 }, {   4,4120 }, {   5,4120 }, {   6,4120 },
 {   7,4120 }, {   8,4120 }, {   9,4120 }, {  10,4120 }, {  11,4120 },
 {  12,4120 }, {  13,4120 }, {  14,4120 }, {  15,4120 }, {  16,4120 },
 {  17,4120 }, {  18,4120 }, {  19,4120 }, {  20,4120 }, {  21,4120 },
 {  22,4120 }, {  23,4120 }, {  24,4120 }, {  25,4120 }, {  26,4120 },
 {  27,4120 }, {  28,4120 }, {  29,4120 }, {  30,4120 }, {  31,4120 },
 {  32,4120 }, {  33,4120 }, {  34,4120 }, {  35,4120 }, {  36,4120 },
 {  37,4120 }, {  38,4120 }, {  39,4120 }, {  40,4120 }, {  41,4120 },
 {   0,   0 }, {  43,4120 }, {  44,4120 }, {  45,4120 }, {  46,4120 },

 {   0,   0 }, {  48,4120 }, {  49,4120 }, {  50,4120 }, {  51,4120 },
 {  52,4120 }, {  53,4120 }, {  54,4120 }, {  55,4120 }, {  56,4120 },
 {  57,4120 }, {  58,4120 }, {  59,4120 }, {  60,4120 }, {  61,4120 },
 {  62,4120 }, {  63,4120 }, {  64,4120 }, {  65,4120 }, {  66,4120 },
 {  67,4120 }, {  68,4120 }, {  69,4120 }, {  70,4120 }, {  71,4120 },
 {  72,4120 }, {  73,4120 }, {  74,4120 }, {  75,4120 }, {  76,4120 },
 {  77,4120 }, {  78,4120 }, {  79,4120 }, {  80,4120 }, {  81,4120 },
 {  82,4120 }, {  83,4120 }, {  84,4120 }, {  85,4120 }, {  86,4120 },
 {  87,4120 }, {  88,4120 }, {  89,4120 }, {  90,4120 }, {  91,4120 },
 {  92,4120 }, {  93,4120 }, {  94,4120 }, {  95,4120 }, {  96,4120 },

 {  97,4120 }, {  98,4120 }, {  99,4120 }, { 100,4120 }, { 101,4120 },
 { 102,4120 }, { 103,4120 }, { 104,4120 }, { 105,4120 }, { 106,4120 },
 { 107,4120 }, { 108,4120 }, { 109,4120 }, { 110,4120 }, { 111,4120 },
 { 112,4120 }, { 113,4120 }, { 114,4120 }, { 115,4120 }, { 116,4120 },
 { 117,4120 }, { 118,4120 }, { 119,4120 }, { 120,4120 }, { 121,4120 },
 { 122,4120 }, { 123,4120 }, { 124,4120 }, { 125,4120 }, { 126,4120 },
 { 127,4120 }, { 128,4120 }, { 129,4120 }, { 130,4120 }, { 131,4120 },
 { 132,4120 }, { 133,4120 }, { 134,4120 }, { 135,4120 }, { 136,4120 },
 { 137,4120 }, { 138,4120 }, { 139,4120 }, { 140,4120 }, { 141,4120 },
 { 142,4120 }, { 143,4120 }, { 144,4120 }, { 145,4120 }, { 146,4120 },

 { 147,4120 }, { 148,4120 }, { 149,4120 }, { 150,4120 }, { 151,4120 },
 { 152,4120 }, { 153,4120 }, { 154,4120 }, { 155,4120 }, { 156,4120 },
 { 157,4120 }, { 158,4120 }, { 159,4120 }, { 160,4120 }, { 161,4120 },
 { 162,4120 }, { 163,4120 }, { 164,4120 }, { 165,4120 }, { 166,4120 },
 { 167,4120 }, { 168,4120 }, { 169,4120 }, { 170,4120 }, { 171,4120 },
 { 172,4120 }, { 173,4120 }, { 174,4120 }, { 175,4120 }, { 176,4120 },
 { 177,4120 }, { 178,4120 }, { 179,4120 }, { 180,4120 }, { 181,4120 },
 { 182,4120 }, { 183,4120 }, { 184,4120 }, { 185,4120 }, { 186,4120 },
 { 187,4120 }, { 188,4120 }, { 189,4120 }, { 190,4120 }, { 191,4120 },
 { 192,4120 }, { 193,4120 }, { 194,4120 }, { 195,4120 }, { 196,4120 },

 { 197,4120 }, { 198,4120 }, { 199,4120 }, { 200,4120 }, { 201,4120 },
 { 202,4120 }, { 203,4120 }, { 204,4120 }, { 205,4120 }, { 206,4120 },
 { 207,4120 }, { 208,4120 }, { 209,4120 }, { 210,4120 }, { 211,4120 },
 { 212,4120 }, { 213,4120 }, { 214,4120 }, { 215,4120 }, { 216,4120 },
 { 217,4120 }, { 218,4120 }, { 219,4120 }, { 220,4120 }, { 221,4120 },
 { 222,4120 }, { 223,4120 }, { 224,4120 }, { 225,4120 }, { 226,4120 },
 { 227,4120 }, { 228,4120 }, { 229,4120 }, { 230,4120 }, { 231,4120 },
 { 232,4120 }, { 233,4120 }, { 234,4120 }, { 235,4120 }, { 236,4120 },
 { 237,4120 }, { 238,4120 }, { 239,4120 }, { 240,4120 }, { 241,4120 },
 { 242,4120 }, { 243,4120 }, { 244,4120 }, { 245,4120 }, { 246,4120 },

 { 247,4120 }, { 248,4120 }, { 249,4120 }, { 250,4120 }, { 251,4120 },
 { 252,4120 }, { 253,4120 }, { 254,4120 }, { 255,4120 }, { 256,4120 },
 {   0,  43 }, {   0,11079 }, {   1,4248 }, {   2,4248 }, {   3,4248 },
 {   4,4248 }, {   5,4248 }, {   6,4248 }, {   7,4248 }, {   8,4248 },
 {   9,4248 }, {  10,4248 }, {  11,4248 }, {  12,4248 }, {  13,4248 },
 {  14,4248 }, {  15,4248 }, {  16,4248 }, {  17,4248 }, {  18,4248 },
 {  19,4248 }, {  20,4248 }, {  21,4248 }, {  22,4248 }, {  23,4248 },
 {  24,4248 }, {  25,4248 }, {  26,4248 }, {  27,4248 }, {  28,4248 },
 {  29,4248 }, {  30,4248 }, {  31,4248 }, {  32,4248 }, {  33,4248 },
 {   0,   0 }, {  35,4248 }, {  36,4248 }, {  37,4248 }, {  38,4248 },

 {  39,4248 }, {  40,4248 }, {  41,4248 }, {  42,4248 }, {  43,4248 },
 {  44,4248 }, {  45,4248 }, {  46,4248 }, {  47,4248 }, {  48,4248 },
 {  49,4248 }, {  50,4248 }, {  51,4248 }, {  52,4248 }, {  53,4248 },
 {  54,4248 }, {  55,4248 }, {  56,4248 }, {  57,4248 }, {  58,4248 },
 {  59,4248 }, {  60,4248 }, {  61,4248 }, {  62,4248 }, {  63,4248 },
 {  64,4248 }, {  65,4248 }, {  66,4248 }, {  67,4248 }, {  68,4248 },
 {  69,4248 }, {  70,4248 }, {  71,4248 }, {  72,4248 }, {  73,4248 },
 {  74,4248 }, {  75,4248 }, {  76,4248 }, {  77,4248 }, {  78,4248 },
 {  79,4248 }, {  80,4248 }, {  81,4248 }, {  82,4248 }, {  83,4248 },
 {  84,4248 }, {  85,4248 }, {  86,4248 }, {  87,4248 }, {  88,4248 },

 {  89,4248 }, {  90,4248 }, {  91,4248 }, {  92,4248 }, {  93,4248 },
 {  94,4248 }, {  95,4248 }, {  96,4248 }, {  97,4248 }, {  98,4248 },
 {  99,4248 }, { 100,4248 }, { 101,4248 }, { 102,4248 }, { 103,4248 },
 { 104,4248 }, { 105,4248 }, { 106,4248 }, { 107,4248 }, { 108,4248 },
 { 109,4248 }, { 110,4248 }, { 111,4248 }, { 112,4248 }, { 113,4248 },
 { 114,4248 }, { 115,4248 }, { 116,4248 }, { 117,4248 }, { 118,4248 },
 { 119,4248 }, { 120,4248 }, { 121,4248 }, { 122,4248 }, { 123,4248 },
 { 124,4248 }, { 125,4248 }, { 126,4248 }, { 127,4248 }, { 128,4248 },
 { 129,4248 }, { 130,4248 }, { 131,4248 }, { 132,4248 }, { 133,4248 },
 { 134,4248 }, { 135,4248 }, { 136,4248 }, { 137,4248 }, { 138,4248 },

 { 139,4248 }, { 140,4248 }, { 141,4248 }, { 142,4248 }, { 143,4248 },
 { 144,4248 }, { 145,4248 }, { 146,4248 }, { 147,4248 }, { 148,4248 },
 { 149,4248 }, { 150,4248 }, { 151,4248 }, { 152,4248 }, { 153,4248 },
 { 154,4248 }, { 155,4248 }, { 156,4248 }, { 157,4248 }, { 158,4248 },
 { 159,4248 }, { 160,4248 }, { 161,4248 }, { 162,4248 }, { 163,4248 },
 { 164,4248 }, { 165,4248 }, { 166,4248 }, { 167,4248 }, { 168,4248 },
 { 169,4248 }, { 170,4248 }, { 171,4248 }, { 172,4248 }, { 173,4248 },
 { 174,4248 }, { 175,4248 }, { 176,4248 }, { 177,4248 }, { 178,4248 },
 { 179,4248 }, { 180,4248 }, { 181,4248 }, { 182,4248 }, { 183,4248 },
 { 184,4248 }, { 185,4248 }, { 186,4248 }, { 187,4248 }, { 188,4248 },

 { 189,4248 }, { 190,4248 }, { 191,4248 }, { 192,4248 }, { 193,4248 },
 { 194,4248 }, { 195,4248 }, { 196,4248 }, { 197,4248 }, { 198,4248 },
 { 199,4248 }, { 200,4248 }, { 201,4248 }, { 202,4248 }, { 203,4248 },
 { 204,4248 }, { 205,4248 }, { 206,4248 }, { 207,4248 }, { 208,4248 },
 { 209,4248 }, { 210,4248 }, { 211,4248 }, { 212,4248 }, { 213,4248 },
 { 214,4248 }, { 215,4248 }, { 216,4248 }, { 217,4248 }, { 218,4248 },
 { 219,4248 }, { 220,4248 }, { 221,4248 }, { 222,4248 }, { 223,4248 },
 { 224,4248 }, { 225,4248 }, { 226,4248 }, { 227,4248 }, { 228,4248 },
 { 229,4248 }, { 230,4248 }, { 231,4248 }, { 232,4248 }, { 233,4248 },
 { 234,4248 }, { 235,4248 }, { 236,4248 }, { 237,4248 }, { 238,4248 },

 { 239,4248 }, { 240,4248 }, { 241,4248 }, { 242,4248 }, { 243,4248 },
 { 244,4248 }, { 245,4248 }, { 246,4248 }, { 247,4248 }, { 248,4248 },
 { 249,4248 }, { 250,4248 }, { 251,4248 }, { 252,4248 }, { 253,4248 },
 { 254,4248 }, { 255,4248 }, { 256,4248 }, {   0,   9 }, {   0,10821 },
 {   1,4248 }, {   2,4248 }, {   3,4248 }, {   4,4248 }, {   5,4248 },
 {   6,4248 }, {   7,4248 }, {   8,4248 }, {   9,4248 }, {  10,4248 },
 {  11,4248 }, {  12,4248 }, {  13,4248 }, {  14,4248 }, {  15,4248 },
 {  16,4248 }, {  17,4248 }, {  18,4248 }, {  19,4248 }, {  20,4248 },
 {  21,4248 }, {  22,4248 }, {  23,4248 }, {  24,4248 }, {  25,4248 },
 {  26,4248 }, {  27,4248 }, {  28,4248 }, {  29,4248 }, {  30,4248 },

 {  31,4248 }, {  32,4248 }, {  33,4248 }, {  34,4248 }, {  35,4248 },
 {  36,4248 }, {  37,4248 }, {  38,4248 }, {   0,   0 }, {  40,4248 },
 {  41,4248 }, {  42,4248 }, {  43,4248 }, {  44,4248 }, {  45,4248 },
 {  46,4248 }, {  47,4248 }, {  48,4248 }, {  49,4248 }, {  50,4248 },
 {  51,4248 }, {  52,4248 }, {  53,4248 }, {  54,4248 }, {  55,4248 },
 {  56,4248 }, {  57,4248 }, {  58,4248 }, {  59,4248 }, {  60,4248 },
 {  61,4248 }, {  62,4248 }, {  63,4248 }, {  64,4248 }, {  65,4248 },
 {  66,4248 }, {  67,4248 }, {  68,4248 }, {  69,4248 }, {  70,4248 },
 {  71,4248 }, {  72,4248 }, {  73,4248 }, {  74,4248 }, {  75,4248 },
 {  76,4248 }, {  77,4248 }, {  78,4248 }, {  79,4248 }, {  80,4248 },

 {  81,4248 }, {  82,4248 }, {  83,4248 }, {  84,4248 }, {  85,4248 },
 {  86,4248 }, {  87,4248 }, {  88,4248 }, {  89,4248 }, {  90,4248 },
 {  91,4248 }, {  92,4248 }, {  93,4248 }, {  94,4248 }, {  95,4248 },
 {  96,4248 }, {  97,4248 }, {  98,4248 }, {  99,4248 }, { 100,4248 },
 { 101,4248 }, { 102,4248 }, { 103,4248 }, { 104,4248 }, { 105,4248 },
 { 106,4248 }, { 107,4248 }, { 108,4248 }, { 109,4248 }, { 110,4248 },
 { 111,4248 }, { 112,4248 }, { 113,4248 }, { 114,4248 }, { 115,4248 },
 { 116,4248 }, { 117,4248 }, { 118,4248 }, { 119,4248 }, { 120,4248 },
 { 121,4248 }, { 122,4248 }, { 123,4248 }, { 124,4248 }, { 125,4248 },
 { 126,4248 }, { 127,4248 }, { 128,4248 }, { 129,4248 }, { 130,4248 },

 { 131,4248 }, { 132,4248 }, { 133,4248 }, { 134,4248 }, { 135,4248 },
 { 136,4248 }, { 137,4248 }, { 138,4248 }, { 139,4248 }, { 140,4248 },
 { 141,4248 }, { 142,4248 }, { 143,4248 }, { 144,4248 }, { 145,4248 },
 { 146,4248 }, { 147,4248 }, { 148,4248 }, { 149,4248 }, { 150,4248 },
 { 151,4248 }, { 152,4248 }, { 153,4248 }, { 154,4248 }, { 155,4248 },
 { 156,4248 }, { 157,4248 }, { 158,4248 }, { 159,4248 }, { 160,4248 },
 { 161,4248 }, { 162,4248 }, { 163,4248 }, { 164,4248 }, { 165,4248 },
 { 166,4248 }, { 167,4248 }, { 168,4248 }, { 169,4248 }, { 170,4248 },
 { 171,4248 }, { 172,4248 }, { 173,4248 }, { 174,4248 }, { 175,4248 },
 { 176,4248 }, { 177,4248 }, { 178,4248 }, { 179,4248 }, { 180,4248 },

 { 181,4248 }, { 182,4248 }, { 183,4248 }, { 184,4248 }, { 185,4248 },
 { 186,4248 }, { 187,4248 }, { 188,4248 }, { 189,4248 }, { 190,4248 },
 { 191,4248 }, { 192,4248 }, { 193,4248 }, { 194,4248 }, { 195,4248 },
 { 196,4248 }, { 197,4248 }, { 198,4248 }, { 199,4248 }, { 200,4248 },
 { 201,4248 }, { 202,4248 }, { 203,4248 }, { 204,4248 }, { 205,4248 },
 { 206,4248 }, { 207,4248 }, { 208,4248 }, { 209,4248 }, { 210,4248 },
 { 211,4248 }, { 212,4248 }, { 213,4248 }, { 214,4248 }, { 215,4248 },
 { 216,4248 }, { 217,4248 }, { 218,4248 }, { 219,4248 }, { 220,4248 },
 { 221,4248 }, { 222,4248 }, { 223,4248 }, { 224,4248 }, { 225,4248 },
 { 226,4248 }, { 227,4248 }, { 228,4248 }, { 229,4248 }, { 230,4248 },

 { 231,4248 }, { 232,4248 }, { 233,4248 }, { 234,4248 }, { 235,4248 },
 { 236,4248 }, { 237,4248 }, { 238,4248 }, { 239,4248 }, { 240,4248 },
 { 241,4248 }, { 242,4248 }, { 243,4248 }, { 244,4248 }, { 245,4248 },
 { 246,4248 }, { 247,4248 }, { 248,4248 }, { 249,4248 }, { 250,4248 },
 { 251,4248 }, { 252,4248 }, { 253,4248 }, { 254,4248 }, { 255,4248 },
 { 256,4248 }, {   0,  21 }, {   0,10563 }, {   1,4248 }, {   2,4248 },
 {   3,4248 }, {   4,4248 }, {   5,4248 }, {   6,4248 }, {   7,4248 },
 {   8,4248 }, {   9,4248 }, {  10,4248 }, {  11,4248 }, {  12,4248 },
 {  13,4248 }, {  14,4248 }, {  15,4248 }, {  16,4248 }, {  17,4248 },
 {  18,4248 }, {  19,4248 }, {  20,4248 }, {  21,4248 }, {  22,4248 },

 {  23,4248 }, {  24,4248 }, {  25,4248 }, {  26,4248 }, {  27,4248 },
 {  28,4248 }, {  29,4248 }, {  30,4248 }, {  31,4248 }, {  32,4248 },
 {  33,4248 }, {  34,4248 }, {  35,4248 }, {  36,4248 }, {  37,4248 },
 {  38,4248 }, {   0,   0 }, {  40,4248 }, {  41,4248 }, {  42,4248 },
 {  43,4248 }, {  44,4248 }, {  45,4248 }, {  46,4248 }, {  47,4248 },
 {  48,4248 }, {  49,4248 }, {  50,4248 }, {  51,4248 }, {  52,4248 },
 {  53,4248 }, {  54,4248 }, {  55,4248 }, {  56,4248 }, {  57,4248 },
 {  58,4248 }, {  59,4248 }, {  60,4248 }, {  61,4248 }, {  62,4248 },
 {  63,4248 }, {  64,4248 }, {  65,4248 }, {  66,4248 }, {  67,4248 },
 {  68,4248 }, {  69,4248 }, {  70,4248 }, {  71,4248 }, {  72,4248 },

 {  73,4248 }, {  74,4248 }, {  75,4248 }, {  76,4248 }, {  77,4248 },
 {  78,4248 }, {  79,4248 }, {  80,4248 }, {  81,4248 }, {  82,4248 },
 {  83,4248 }, {  84,4248 }, {  85,4248 }, {  86,4248 }, {  87,4248 },
 {  88,4248 }, {  89,4248 }, {  90,4248 }, {  91,4248 }, {  92,4248 },
 {  93,4248 }, {  94,4248 }, {  95,4248 }, {  96,4248 }, {  97,4248 },
 {  98,4248 }, {  99,4248 }, { 100,4248 }, { 101,4248 }, { 102,4248 },
 { 103,4248 }, { 104,4248 }, { 105,4248 }, { 106,4248 }, { 107,4248 },
 { 108,4248 }, { 109,4248 }, { 110,4248 }, { 111,4248 }, { 112,4248 },
 { 113,4248 }, { 114,4248 }, { 115,4248 }, { 116,4248 }, { 117,4248 },
 { 118,4248 }, { 119,4248 }, { 120,4248 }, { 121,4248 }, { 122,4248 },

 { 123,4248 }, { 124,4248 }, { 125,4248 }, { 126,4248 }, { 127,4248 },
 { 128,4248 }, { 129,4248 }, { 130,4248 }, { 131,4248 }, { 132,4248 },
 { 133,4248 }, { 134,4248 }, { 135,4248 }, { 136,4248 }, { 137,4248 },
 { 138,4248 }, { 139,4248 }, { 140,4248 }, { 141,4248 }, { 142,4248 },
 { 143,4248 }, { 144,4248 }, { 145,4248 }, { 146,4248 }, { 147,4248 },
 { 148,4248 }, { 149,4248 }, { 150,4248 }, { 151,4248 }, { 152,4248 },
 { 153,4248 }, { 154,4248 }, { 155,4248 }, { 156,4248 }, { 157,4248 },
 { 158,4248 }, { 159,4248 }, { 160,4248 }, { 161,4248 }, { 162,4248 },
 { 163,4248 }, { 164,4248 }, { 165,4248 }, { 166,4248 }, { 167,4248 },
 { 168,4248 }, { 169,4248 }, { 170,4248 }, { 171,4248 }, { 172,4248 },

 { 173,4248 }, { 174,4248 }, { 175,4248 }, { 176,4248 }, { 177,4248 },
 { 178,4248 }, { 179,4248 }, { 180,4248 }, { 181,4248 }, { 182,4248 },
 { 183,4248 }, { 184,4248 }, { 185,4248 }, { 186,4248 }, { 187,4248 },
 { 188,4248 }, { 189,4248 }, { 190,4248 }, { 191,4248 }, { 192,4248 },
 { 193,4248 }, { 194,4248 }, { 195,4248 }, { 196,4248 }, { 197,4248 },
 { 198,4248 }, { 199,4248 }, { 200,4248 }, { 201,4248 }, { 202,4248 },
 { 203,4248 }, { 204,4248 }, { 205,4248 }, { 206,4248 }, { 207,4248 },
 { 208,4248 }, { 209,4248 }, { 210,4248 }, { 211,4248 }, { 212,4248 },
 { 213,4248 }, { 214,4248 }, { 215,4248 }, { 216,4248 }, { 217,4248 },
 { 218,4248 }, { 219,4248 }, { 220,4248 }, { 221,4248 }, { 222,4248 },

 { 223,4248 }, { 224,4248 }, { 225,4248 }, { 226,4248 }, { 227,4248 },
 { 228,4248 }, { 229,4248 }, { 230,4248 }, { 231,4248 }, { 232,4248 },
 { 233,4248 }, { 234,4248 }, { 235,4248 }, { 236,4248 }, { 237,4248 },
 { 238,4248 }, { 239,4248 }, { 240,4248 }, { 241,4248 }, { 242,4248 },
 { 243,4248 }, { 244,4248 }, { 245,4248 }, { 246,4248 }, { 247,4248 },
 { 248,4248 }, { 249,4248 }, { 250,4248 }, { 251,4248 }, { 252,4248 },
 { 253,4248 }, { 254,4248 }, { 255,4248 }, { 256,4248 }, {   0,  18 },
 {   0,10305 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  18 },
 {   0,10300 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,4248 },
 {  10,4253 }, {   0,   0 }, {  12,4248 }, {  13,4253 }, {   9,4264 },

 {  10,4264 }, {   0,   0 }, {  12,4264 }, {  13,4264 }, {   0,   0 },
 {   0,  18 }, {   0,10284 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   9,4248 }, {  10,4248 }, {  32,4248 }, {  12,4248 }, {  13,4248 },
 {   0,   0 }, {   0,   0 }, {  32,4264 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-3351 },
 {  45,-3348 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-3349 }, {   0,   0 }, {   0,   0 }, {  32,4248 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-3367 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  45,-3365 }, {   0,  22 }, {   0,10237 }, {   1,4506 },
 {   2,4506 }, {   3,4506 }, {   4,4506 }, {   5,4506 }, {   6,4506 },
 {   7,4506 }, {   8,4506 }, {   9,4506 }, {  10,4506 }, {  11,4506 },
 {  12,4506 }, {  13,4506 }, {  14,4506 }, {  15,4506 }, {  16,4506 },
 {  17,4506 }, {  18,4506 }, {  19,4506 }, {  20,4506 }, {  21,4506 },
 {  22,4506 }, {  23,4506 }, {  24,4506 }, {  25,4506 }, {  26,4506 },
 {  27,4506 }, {  28,4506 }, {  29,4506 }, {  30,4506 }, {  31,4506 },
 {  32,4506 }, {  33,4506 }, {  34,4506 }, {  35,4506 }, {  36,4506 },
 {  37,4506 }, {  38,4506 }, {   0,   0 }, {  40,4506 }, {  41,4506 },
 {  42,4506 }, {  43,4506 }, {  44,4506 }, {  45,4506 }, {  46,4506 },

 {  47,4506 }, {  48,4506 }, {  49,4506 }, {  50,4506 }, {  51,4506 },
 {  52,4506 }, {  53,4506 }, {  54,4506 }, {  55,4506 }, {  56,4506 },
 {  57,4506 }, {  58,4506 }, {  59,4506 }, {  60,4506 }, {  61,4506 },
 {  62,4506 }, {  63,4506 }, {  64,4506 }, {  65,4506 }, {  66,4506 },
 {  67,4506 }, {  68,4506 }, {  69,4506 }, {  70,4506 }, {  71,4506 },
 {  72,4506 }, {  73,4506 }, {  74,4506 }, {  75,4506 }, {  76,4506 },
 {  77,4506 }, {  78,4506 }, {  79,4506 }, {  80,4506 }, {  81,4506 },
 {  82,4506 }, {  83,4506 }, {  84,4506 }, {  85,4506 }, {  86,4506 },
 {  87,4506 }, {  88,4506 }, {  89,4506 }, {  90,4506 }, {  91,4506 },
 {   0,   0 }, {  93,4506 }, {  94,4506 }, {  95,4506 }, {  96,4506 },

 {  97,4506 }, {  98,4506 }, {  99,4506 }, { 100,4506 }, { 101,4506 },
 { 102,4506 }, { 103,4506 }, { 104,4506 }, { 105,4506 }, { 106,4506 },
 { 107,4506 }, { 108,4506 }, { 109,4506 }, { 110,4506 }, { 111,4506 },
 { 112,4506 }, { 113,4506 }, { 114,4506 }, { 115,4506 }, { 116,4506 },
 { 117,4506 }, { 118,4506 }, { 119,4506 }, { 120,4506 }, { 121,4506 },
 { 122,4506 }, { 123,4506 }, { 124,4506 }, { 125,4506 }, { 126,4506 },
 { 127,4506 }, { 128,4506 }, { 129,4506 }, { 130,4506 }, { 131,4506 },
 { 132,4506 }, { 133,4506 }, { 134,4506 }, { 135,4506 }, { 136,4506 },
 { 137,4506 }, { 138,4506 }, { 139,4506 }, { 140,4506 }, { 141,4506 },
 { 142,4506 }, { 143,4506 }, { 144,4506 }, { 145,4506 }, { 146,4506 },

 { 147,4506 }, { 148,4506 }, { 149,4506 }, { 150,4506 }, { 151,4506 },
 { 152,4506 }, { 153,4506 }, { 154,4506 }, { 155,4506 }, { 156,4506 },
 { 157,4506 }, { 158,4506 }, { 159,4506 }, { 160,4506 }, { 161,4506 },
 { 162,4506 }, { 163,4506 }, { 164,4506 }, { 165,4506 }, { 166,4506 },
 { 167,4506 }, { 168,4506 }, { 169,4506 }, { 170,4506 }, { 171,4506 },
 { 172,4506 }, { 173,4506 }, { 174,4506 }, { 175,4506 }, { 176,4506 },
 { 177,4506 }, { 178,4506 }, { 179,4506 }, { 180,4506 }, { 181,4506 },
 { 182,4506 }, { 183,4506 }, { 184,4506 }, { 185,4506 }, { 186,4506 },
 { 187,4506 }, { 188,4506 }, { 189,4506 }, { 190,4506 }, { 191,4506 },
 { 192,4506 }, { 193,4506 }, { 194,4506 }, { 195,4506 }, { 196,4506 },

 { 197,4506 }, { 198,4506 }, { 199,4506 }, { 200,4506 }, { 201,4506 },
 { 202,4506 }, { 203,4506 }, { 204,4506 }, { 205,4506 }, { 206,4506 },
 { 207,4506 }, { 208,4506 }, { 209,4506 }, { 210,4506 }, { 211,4506 },
 { 212,4506 }, { 213,4506 }, { 214,4506 }, { 215,4506 }, { 216,4506 },
 { 217,4506 }, { 218,4506 }, { 219,4506 }, { 220,4506 }, { 221,4506 },
 { 222,4506 }, { 223,4506 }, { 224,4506 }, { 225,4506 }, { 226,4506 },
 { 227,4506 }, { 228,4506 }, { 229,4506 }, { 230,4506 }, { 231,4506 },
 { 232,4506 }, { 233,4506 }, { 234,4506 }, { 235,4506 }, { 236,4506 },
 { 237,4506 }, { 238,4506 }, { 239,4506 }, { 240,4506 }, { 241,4506 },
 { 242,4506 }, { 243,4506 }, { 244,4506 }, { 245,4506 }, { 246,4506 },

 { 247,4506 }, { 248,4506 }, { 249,4506 }, { 250,4506 }, { 251,4506 },
 { 252,4506 }, { 253,4506 }, { 254,4506 }, { 255,4506 }, { 256,4506 },
 {   0,  22 }, {   0,9979 }, {   1,4248 }, {   2,4248 }, {   3,4248 },
 {   4,4248 }, {   5,4248 }, {   6,4248 }, {   7,4248 }, {   8,4248 },
 {   9,4248 }, {  10,4248 }, {  11,4248 }, {  12,4248 }, {  13,4248 },
 {  14,4248 }, {  15,4248 }, {  16,4248 }, {  17,4248 }, {  18,4248 },
 {  19,4248 }, {  20,4248 }, {  21,4248 }, {  22,4248 }, {  23,4248 },
 {  24,4248 }, {  25,4248 }, {  26,4248 }, {  27,4248 }, {  28,4248 },
 {  29,4248 }, {  30,4248 }, {  31,4248 }, {  32,4248 }, {  33,4248 },
 {  34,4248 }, {  35,4248 }, {  36,4248 }, {  37,4248 }, {  38,4248 },

 {   0,   0 }, {  40,4248 }, {  41,4248 }, {  42,4248 }, {  43,4248 },
 {  44,4248 }, {  45,4248 }, {  46,4248 }, {  47,4248 }, {  48,4248 },
 {  49,4248 }, {  50,4248 }, {  51,4248 }, {  52,4248 }, {  53,4248 },
 {  54,4248 }, {  55,4248 }, {  56,4248 }, {  57,4248 }, {  58,4248 },
 {  59,4248 }, {  60,4248 }, {  61,4248 }, {  62,4248 }, {  63,4248 },
 {  64,4248 }, {  65,4248 }, {  66,4248 }, {  67,4248 }, {  68,4248 },
 {  69,4248 }, {  70,4248 }, {  71,4248 }, {  72,4248 }, {  73,4248 },
 {  74,4248 }, {  75,4248 }, {  76,4248 }, {  77,4248 }, {  78,4248 },
 {  79,4248 }, {  80,4248 }, {  81,4248 }, {  82,4248 }, {  83,4248 },
 {  84,4248 }, {  85,4248 }, {  86,4248 }, {  87,4248 }, {  88,4248 },

 {  89,4248 }, {  90,4248 }, {  91,4248 }, {   0,   0 }, {  93,4248 },
 {  94,4248 }, {  95,4248 }, {  96,4248 }, {  97,4248 }, {  98,4248 },
 {  99,4248 }, { 100,4248 }, { 101,4248 }, { 102,4248 }, { 103,4248 },
 { 104,4248 }, { 105,4248 }, { 106,4248 }, { 107,4248 }, { 108,4248 },
 { 109,4248 }, { 110,4248 }, { 111,4248 }, { 112,4248 }, { 113,4248 },
 { 114,4248 }, { 115,4248 }, { 116,4248 }, { 117,4248 }, { 118,4248 },
 { 119,4248 }, { 120,4248 }, { 121,4248 }, { 122,4248 }, { 123,4248 },
 { 124,4248 }, { 125,4248 }, { 126,4248 }, { 127,4248 }, { 128,4248 },
 { 129,4248 }, { 130,4248 }, { 131,4248 }, { 132,4248 }, { 133,4248 },
 { 134,4248 }, { 135,4248 }, { 136,4248 }, { 137,4248 }, { 138,4248 },

 { 139,4248 }, { 140,4248 }, { 141,4248 }, { 142,4248 }, { 143,4248 },
 { 144,4248 }, { 145,4248 }, { 146,4248 }, { 147,4248 }, { 148,4248 },
 { 149,4248 }, { 150,4248 }, { 151,4248 }, { 152,4248 }, { 153,4248 },
 { 154,4248 }, { 155,4248 }, { 156,4248 }, { 157,4248 }, { 158,4248 },
 { 159,4248 }, { 160,4248 }, { 161,4248 }, { 162,4248 }, { 163,4248 },
 { 164,4248 }, { 165,4248 }, { 166,4248 }, { 167,4248 }, { 168,4248 },
 { 169,4248 }, { 170,4248 }, { 171,4248 }, { 172,4248 }, { 173,4248 },
 { 174,4248 }, { 175,4248 }, { 176,4248 }, { 177,4248 }, { 178,4248 },
 { 179,4248 }, { 180,4248 }, { 181,4248 }, { 182,4248 }, { 183,4248 },
 { 184,4248 }, { 185,4248 }, { 186,4248 }, { 187,4248 }, { 188,4248 },

 { 189,4248 }, { 190,4248 }, { 191,4248 }, { 192,4248 }, { 193,4248 },
 { 194,4248 }, { 195,4248 }, { 196,4248 }, { 197,4248 }, { 198,4248 },
 { 199,4248 }, { 200,4248 }, { 201,4248 }, { 202,4248 }, { 203,4248 },
 { 204,4248 }, { 205,4248 }, { 206,4248 }, { 207,4248 }, { 208,4248 },
 { 209,4248 }, { 210,4248 }, { 211,4248 }, { 212,4248 }, { 213,4248 },
 { 214,4248 }, { 215,4248 }, { 216,4248 }, { 217,4248 }, { 218,4248 },
 { 219,4248 }, { 220,4248 }, { 221,4248 }, { 222,4248 }, { 223,4248 },
 { 224,4248 }, { 225,4248 }, { 226,4248 }, { 227,4248 }, { 228,4248 },
 { 229,4248 }, { 230,4248 }, { 231,4248 }, { 232,4248 }, { 233,4248 },
 { 234,4248 }, { 235,4248 }, { 236,4248 }, { 237,4248 }, { 238,4248 },

 { 239,4248 }, { 240,4248 }, { 241,4248 }, { 242,4248 }, { 243,4248 },
 { 244,4248 }, { 245,4248 }, { 246,4248 }, { 247,4248 }, { 248,4248 },
 { 249,4248 }, { 250,4248 }, { 251,4248 }, { 252,4248 }, { 253,4248 },
 { 254,4248 }, { 255,4248 }, { 256,4248 }, {   0,  31 }, {   0,9721 },
 {   1,-3926 }, {   2,-3926 }, {   3,-3926 }, {   4,-3926 }, {   5,-3926 },
 {   6,-3926 }, {   7,-3926 }, {   8,-3926 }, {   9,-3926 }, {  10,-3926 },
 {  11,-3926 }, {  12,-3926 }, {  13,-3926 }, {  14,-3926 }, {  15,-3926 },
 {  16,-3926 }, {  17,-3926 }, {  18,-3926 }, {  19,-3926 }, {  20,-3926 },
 {  21,-3926 }, {  22,-3926 }, {  23,-3926 }, {  24,-3926 }, {  25,-3926 },
 {  26,-3926 }, {  27,-3926 }, {  28,-3926 }, {  29,-3926 }, {  30,-3926 },

 {  31,-3926 }, {  32,-3926 }, {  33,-3926 }, {  34,-3926 }, {  35,-3926 },
 {  36,-3926 }, {  37,-3926 }, {  38,-3926 }, {  39,-3926 }, {  40,-3926 },
 {  41,-3926 }, {  42,-3926 }, {  43,-3926 }, {  44,-3926 }, {  45,-3926 },
 {  46,-3926 }, {  47,-3926 }, {  48,4248 }, {  49,4248 }, {  50,4248 },
 {  51,4248 }, {  52,4248 }, {  53,4248 }, {  54,4248 }, {  55,4248 },
 {  56,-3926 }, {  57,-3926 }, {  58,-3926 }, {  59,-3926 }, {  60,-3926 },
 {  61,-3926 }, {  62,-3926 }, {  63,-3926 }, {  64,-3926 }, {  65,-3926 },
 {  66,-3926 }, {  67,-3926 }, {  68,-3926 }, {  69,-3926 }, {  70,-3926 },
 {  71,-3926 }, {  72,-3926 }, {  73,-3926 }, {  74,-3926 }, {  75,-3926 },
 {  76,-3926 }, {  77,-3926 }, {  78,-3926 }, {  79,-3926 }, {  80,-3926 },

 {  81,-3926 }, {  82,-3926 }, {  83,-3926 }, {  84,-3926 }, {  85,4256 },
 {  86,-3926 }, {  87,-3926 }, {  88,-3926 }, {  89,-3926 }, {  90,-3926 },
 {  91,-3926 }, {  92,-3926 }, {  93,-3926 }, {  94,-3926 }, {  95,-3926 },
 {  96,-3926 }, {  97,-3926 }, {  98,-3926 }, {  99,-3926 }, { 100,-3926 },
 { 101,-3926 }, { 102,-3926 }, { 103,-3926 }, { 104,-3926 }, { 105,-3926 },
 { 106,-3926 }, { 107,-3926 }, { 108,-3926 }, { 109,-3926 }, { 110,-3926 },
 { 111,-3926 }, { 112,-3926 }, { 113,-3926 }, { 114,-3926 }, { 115,-3926 },
 { 116,-3926 }, { 117,4279 }, { 118,-3926 }, { 119,-3926 }, { 120,4317 },
 { 121,-3926 }, { 122,-3926 }, { 123,-3926 }, { 124,-3926 }, { 125,-3926 },
 { 126,-3926 }, { 127,-3926 }, { 128,-3926 }, { 129,-3926 }, { 130,-3926 },

 { 131,-3926 }, { 132,-3926 }, { 133,-3926 }, { 134,-3926 }, { 135,-3926 },
 { 136,-3926 }, { 137,-3926 }, { 138,-3926 }, { 139,-3926 }, { 140,-3926 },
 { 141,-3926 }, { 142,-3926 }, { 143,-3926 }, { 144,-3926 }, { 145,-3926 },
 { 146,-3926 }, { 147,-3926 }, { 148,-3926 }, { 149,-3926 }, { 150,-3926 },
 { 151,-3926 }, { 152,-3926 }, { 153,-3926 }, { 154,-3926 }, { 155,-3926 },
 { 156,-3926 }, { 157,-3926 }, { 158,-3926 }, { 159,-3926 }, { 160,-3926 },
 { 161,-3926 }, { 162,-3926 }, { 163,-3926 }, { 164,-3926 }, { 165,-3926 },
 { 166,-3926 }, { 167,-3926 }, { 168,-3926 }, { 169,-3926 }, { 170,-3926 },
 { 171,-3926 }, { 172,-3926 }, { 173,-3926 }, { 174,-3926 }, { 175,-3926 },
 { 176,-3926 }, { 177,-3926 }, { 178,-3926 }, { 179,-3926 }, { 180,-3926 },

 { 181,-3926 }, { 182,-3926 }, { 183,-3926 }, { 184,-3926 }, { 185,-3926 },
 { 186,-3926 }, { 187,-3926 }, { 188,-3926 }, { 189,-3926 }, { 190,-3926 },
 { 191,-3926 }, { 192,-3926 }, { 193,-3926 }, { 194,-3926 }, { 195,-3926 },
 { 196,-3926 }, { 197,-3926 }, { 198,-3926 }, { 199,-3926 }, { 200,-3926 },
 { 201,-3926 }, { 202,-3926 }, { 203,-3926 }, { 204,-3926 }, { 205,-3926 },
 { 206,-3926 }, { 207,-3926 }, { 208,-3926 }, { 209,-3926 }, { 210,-3926 },
 { 211,-3926 }, { 212,-3926 }, { 213,-3926 }, { 214,-3926 }, { 215,-3926 },
 { 216,-3926 }, { 217,-3926 }, { 218,-3926 }, { 219,-3926 }, { 220,-3926 },
 { 221,-3926 }, { 222,-3926 }, { 223,-3926 }, { 224,-3926 }, { 225,-3926 },
 { 226,-3926 }, { 227,-3926 }, { 228,-3926 }, { 229,-3926 }, { 230,-3926 },

 { 231,-3926 }, { 232,-3926 }, { 233,-3926 }, { 234,-3926 }, { 235,-3926 },
 { 236,-3926 }, { 237,-3926 }, { 238,-3926 }, { 239,-3926 }, { 240,-3926 },
 { 241,-3926 }, { 242,-3926 }, { 243,-3926 }, { 244,-3926 }, { 245,-3926 },
 { 246,-3926 }, { 247,-3926 }, { 248,-3926 }, { 249,-3926 }, { 250,-3926 },
 { 251,-3926 }, { 252,-3926 }, { 253,-3926 }, { 254,-3926 }, { 255,-3926 },
 { 256,-3926 }, {   0,  35 }, {   0,9463 }, {   1,4163 }, {   2,4163 },
 {   3,4163 }, {   4,4163 }, {   5,4163 }, {   6,4163 }, {   7,4163 },
 {   8,4163 }, {   9,4163 }, {  10,4163 }, {  11,4163 }, {  12,4163 },
 {  13,4163 }, {  14,4163 }, {  15,4163 }, {  16,4163 }, {  17,4163 },
 {  18,4163 }, {  19,4163 }, {  20,4163 }, {  21,4163 }, {  22,4163 },

 {  23,4163 }, {  24,4163 }, {  25,4163 }, {  26,4163 }, {  27,4163 },
 {  28,4163 }, {  29,4163 }, {  30,4163 }, {  31,4163 }, {  32,4163 },
 {  33,4163 }, {  34,4163 }, {  35,4163 }, {   0,   0 }, {  37,4163 },
 {  38,4163 }, {  39,4163 }, {  40,4163 }, {  41,4163 }, {  42,4163 },
 {  43,4163 }, {  44,4163 }, {  45,4163 }, {  46,4163 }, {  47,4163 },
 {  48,4163 }, {  49,4163 }, {  50,4163 }, {  51,4163 }, {  52,4163 },
 {  53,4163 }, {  54,4163 }, {  55,4163 }, {  56,4163 }, {  57,4163 },
 {  58,4163 }, {  59,4163 }, {  60,4163 }, {  61,4163 }, {  62,4163 },
 {  63,4163 }, {  64,4163 }, {  65,4163 }, {  66,4163 }, {  67,4163 },
 {  68,4163 }, {  69,4163 }, {  70,4163 }, {  71,4163 }, {  72,4163 },

 {  73,4163 }, {  74,4163 }, {  75,4163 }, {  76,4163 }, {  77,4163 },
 {  78,4163 }, {  79,4163 }, {  80,4163 }, {  81,4163 }, {  82,4163 },
 {  83,4163 }, {  84,4163 }, {  85,4163 }, {  86,4163 }, {  87,4163 },
 {  88,4163 }, {  89,4163 }, {  90,4163 }, {  91,4163 }, {  92,4163 },
 {  93,4163 }, {  94,4163 }, {  95,4163 }, {  96,4163 }, {  97,4163 },
 {  98,4163 }, {  99,4163 }, { 100,4163 }, { 101,4163 }, { 102,4163 },
 { 103,4163 }, { 104,4163 }, { 105,4163 }, { 106,4163 }, { 107,4163 },
 { 108,4163 }, { 109,4163 }, { 110,4163 }, { 111,4163 }, { 112,4163 },
 { 113,4163 }, { 114,4163 }, { 115,4163 }, { 116,4163 }, { 117,4163 },
 { 118,4163 }, { 119,4163 }, { 120,4163 }, { 121,4163 }, { 122,4163 },

 { 123,4163 }, { 124,4163 }, { 125,4163 }, { 126,4163 }, { 127,4163 },
 { 128,4163 }, { 129,4163 }, { 130,4163 }, { 131,4163 }, { 132,4163 },
 { 133,4163 }, { 134,4163 }, { 135,4163 }, { 136,4163 }, { 137,4163 },
 { 138,4163 }, { 139,4163 }, { 140,4163 }, { 141,4163 }, { 142,4163 },
 { 143,4163 }, { 144,4163 }, { 145,4163 }, { 146,4163 }, { 147,4163 },
 { 148,4163 }, { 149,4163 }, { 150,4163 }, { 151,4163 }, { 152,4163 },
 { 153,4163 }, { 154,4163 }, { 155,4163 }, { 156,4163 }, { 157,4163 },
 { 158,4163 }, { 159,4163 }, { 160,4163 }, { 161,4163 }, { 162,4163 },
 { 163,4163 }, { 164,4163 }, { 165,4163 }, { 166,4163 }, { 167,4163 },
 { 168,4163 }, { 169,4163 }, { 170,4163 }, { 171,4163 }, { 172,4163 },

 { 173,4163 }, { 174,4163 }, { 175,4163 }, { 176,4163 }, { 177,4163 },
 { 178,4163 }, { 179,4163 }, { 180,4163 }, { 181,4163 }, { 182,4163 },
 { 183,4163 }, { 184,4163 }, { 185,4163 }, { 186,4163 }, { 187,4163 },
 { 188,4163 }, { 189,4163 }, { 190,4163 }, { 191,4163 }, { 192,4163 },
 { 193,4163 }, { 194,4163 }, { 195,4163 }, { 196,4163 }, { 197,4163 },
 { 198,4163 }, { 199,4163 }, { 200,4163 }, { 201,4163 }, { 202,4163 },
 { 203,4163 }, { 204,4163 }, { 205,4163 }, { 206,4163 }, { 207,4163 },
 { 208,4163 }, { 209,4163 }, { 210,4163 }, { 211,4163 }, { 212,4163 },
 { 213,4163 }, { 214,4163 }, { 215,4163 }, { 216,4163 }, { 217,4163 },
 { 218,4163 }, { 219,4163 }, { 220,4163 }, { 221,4163 }, { 222,4163 },

 { 223,4163 }, { 224,4163 }, { 225,4163 }, { 226,4163 }, { 227,4163 },
 { 228,4163 }, { 229,4163 }, { 230,4163 }, { 231,4163 }, { 232,4163 },
 { 233,4163 }, { 234,4163 }, { 235,4163 }, { 236,4163 }, { 237,4163 },
 { 238,4163 }, { 239,4163 }, { 240,4163 }, { 241,4163 }, { 242,4163 },
 { 243,4163 }, { 244,4163 }, { 245,4163 }, { 246,4163 }, { 247,4163 },
 { 248,4163 }, { 249,4163 }, { 250,4163 }, { 251,4163 }, { 252,4163 },
 { 253,4163 }, { 254,4163 }, { 255,4163 }, { 256,4163 }, {   0,  35 },
 {   0,9205 }, {   1,3905 }, {   2,3905 }, {   3,3905 }, {   4,3905 },
 {   5,3905 }, {   6,3905 }, {   7,3905 }, {   8,3905 }, {   9,3905 },
 {  10,3905 }, {  11,3905 }, {  12,3905 }, {  13,3905 }, {  14,3905 },

 {  15,3905 }, {  16,3905 }, {  17,3905 }, {  18,3905 }, {  19,3905 },
 {  20,3905 }, {  21,3905 }, {  22,3905 }, {  23,3905 }, {  24,3905 },
 {  25,3905 }, {  26,3905 }, {  27,3905 }, {  28,3905 }, {  29,3905 },
 {  30,3905 }, {  31,3905 }, {  32,3905 }, {  33,3905 }, {  34,3905 },
 {  35,3905 }, {   0,   0 }, {  37,3905 }, {  38,3905 }, {  39,3905 },
 {  40,3905 }, {  41,3905 }, {  42,3905 }, {  43,3905 }, {  44,3905 },
 {  45,3905 }, {  46,3905 }, {  47,3905 }, {  48,3905 }, {  49,3905 },
 {  50,3905 }, {  51,3905 }, {  52,3905 }, {  53,3905 }, {  54,3905 },
 {  55,3905 }, {  56,3905 }, {  57,3905 }, {  58,3905 }, {  59,3905 },
 {  60,3905 }, {  61,3905 }, {  62,3905 }, {  63,3905 }, {  64,3905 },

 {  65,3905 }, {  66,3905 }, {  67,3905 }, {  68,3905 }, {  69,3905 },
 {  70,3905 }, {  71,3905 }, {  72,3905 }, {  73,3905 }, {  74,3905 },
 {  75,3905 }, {  76,3905 }, {  77,3905 }, {  78,3905 }, {  79,3905 },
 {  80,3905 }, {  81,3905 }, {  82,3905 }, {  83,3905 }, {  84,3905 },
 {  85,3905 }, {  86,3905 }, {  87,3905 }, {  88,3905 }, {  89,3905 },
 {  90,3905 }, {  91,3905 }, {  92,3905 }, {  93,3905 }, {  94,3905 },
 {  95,3905 }, {  96,3905 }, {  97,3905 }, {  98,3905 }, {  99,3905 },
 { 100,3905 }, { 101,3905 }, { 102,3905 }, { 103,3905 }, { 104,3905 },
 { 105,3905 }, { 106,3905 }, { 107,3905 }, { 108,3905 }, { 109,3905 },
 { 110,3905 }, { 111,3905 }, { 112,3905 }, { 113,3905 }, { 114,3905 },

 { 115,3905 }, { 116,3905 }, { 117,3905 }, { 118,3905 }, { 119,3905 },
 { 120,3905 }, { 121,3905 }, { 122,3905 }, { 123,3905 }, { 124,3905 },
 { 125,3905 }, { 126,3905 }, { 127,3905 }, { 128,3905 }, { 129,3905 },
 { 130,3905 }, { 131,3905 }, { 132,3905 }, { 133,3905 }, { 134,3905 },
 { 135,3905 }, { 136,3905 }, { 137,3905 }, { 138,3905 }, { 139,3905 },
 { 140,3905 }, { 141,3905 }, { 142,3905 }, { 143,3905 }, { 144,3905 },
 { 145,3905 }, { 146,3905 }, { 147,3905 }, { 148,3905 }, { 149,3905 },
 { 150,3905 }, { 151,3905 }, { 152,3905 }, { 153,3905 }, { 154,3905 },
 { 155,3905 }, { 156,3905 }, { 157,3905 }, { 158,3905 }, { 159,3905 },
 { 160,3905 }, { 161,3905 }, { 162,3905 }, { 163,3905 }, { 164,3905 },

 { 165,3905 }, { 166,3905 }, { 167,3905 }, { 168,3905 }, { 169,3905 },
 { 170,3905 }, { 171,3905 }, { 172,3905 }, { 173,3905 }, { 174,3905 },
 { 175,3905 }, { 176,3905 }, { 177,3905 }, { 178,3905 }, { 179,3905 },
 { 180,3905 }, { 181,3905 }, { 182,3905 }, { 183,3905 }, { 184,3905 },
 { 185,3905 }, { 186,3905 }, { 187,3905 }, { 188,3905 }, { 189,3905 },
 { 190,3905 }, { 191,3905 }, { 192,3905 }, { 193,3905 }, { 194,3905 },
 { 195,3905 }, { 196,3905 }, { 197,3905 }, { 198,3905 }, { 199,3905 },
 { 200,3905 }, { 201,3905 }, { 202,3905 }, { 203,3905 }, { 204,3905 },
 { 205,3905 }, { 206,3905 }, { 207,3905 }, { 208,3905 }, { 209,3905 },
 { 210,3905 }, { 211,3905 }, { 212,3905 }, { 213,3905 }, { 214,3905 },

 { 215,3905 }, { 216,3905 }, { 217,3905 }, { 218,3905 }, { 219,3905 },
 { 220,3905 }, { 221,3905 }, { 222,3905 }, { 223,3905 }, { 224,3905 },
 { 225,3905 }, { 226,3905 }, { 227,3905 }, { 228,3905 }, { 229,3905 },
 { 230,3905 }, { 231,3905 }, { 232,3905 }, { 233,3905 }, { 234,3905 },
 { 235,3905 }, { 236,3905 }, { 237,3905 }, { 238,3905 }, { 239,3905 },
 { 240,3905 }, { 241,3905 }, { 242,3905 }, { 243,3905 }, { 244,3905 },
 { 245,3905 }, { 246,3905 }, { 247,3905 }, { 248,3905 }, { 249,3905 },
 { 250,3905 }, { 251,3905 }, { 252,3905 }, { 253,3905 }, { 254,3905 },
 { 255,3905 }, { 256,3905 }, {   0,  37 }, {   0,8947 }, {   0,   1 },
 {   0,8945 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 },
 {  10,   0 }, {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,   0 }, {   0,   0 }, {  36,-4698 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3905 }, {  66,3905 },
 {  67,3905 }, {  68,3905 }, {  69,3905 }, {  70,3905 }, {  71,3905 },
 {  72,3905 }, {  73,3905 }, {  74,3905 }, {  75,3905 }, {  76,3905 },
 {  77,3905 }, {  78,3905 }, {  79,3905 }, {  80,3905 }, {  81,3905 },
 {  82,3905 }, {  83,3905 }, {  84,3905 }, {  85,3905 }, {  86,3905 },
 {  87,3905 }, {  88,3905 }, {  89,3905 }, {  90,3905 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3905 }, {   0,   0 },
 {  97,3905 }, {  98,3905 }, {  99,3905 }, { 100,3905 }, { 101,3905 },
 { 102,3905 }, { 103,3905 }, { 104,3905 }, { 105,3905 }, { 106,3905 },

 { 107,3905 }, { 108,3905 }, { 109,3905 }, { 110,3905 }, { 111,3905 },
 { 112,3905 }, { 113,3905 }, { 114,3905 }, { 115,3905 }, { 116,3905 },
 { 117,3905 }, { 118,3905 }, { 119,3905 }, { 120,3905 }, { 121,3905 },
 { 122,3905 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,3905 }, { 129,3905 }, { 130,3905 }, { 131,3905 },
 { 132,3905 }, { 133,3905 }, { 134,3905 }, { 135,3905 }, { 136,3905 },
 { 137,3905 }, { 138,3905 }, { 139,3905 }, { 140,3905 }, { 141,3905 },
 { 142,3905 }, { 143,3905 }, { 144,3905 }, { 145,3905 }, { 146,3905 },
 { 147,3905 }, { 148,3905 }, { 149,3905 }, { 150,3905 }, { 151,3905 },
 { 152,3905 }, { 153,3905 }, { 154,3905 }, { 155,3905 }, { 156,3905 },

 { 157,3905 }, { 158,3905 }, { 159,3905 }, { 160,3905 }, { 161,3905 },
 { 162,3905 }, { 163,3905 }, { 164,3905 }, { 165,3905 }, { 166,3905 },
 { 167,3905 }, { 168,3905 }, { 169,3905 }, { 170,3905 }, { 171,3905 },
 { 172,3905 }, { 173,3905 }, { 174,3905 }, { 175,3905 }, { 176,3905 },
 { 177,3905 }, { 178,3905 }, { 179,3905 }, { 180,3905 }, { 181,3905 },
 { 182,3905 }, { 183,3905 }, { 184,3905 }, { 185,3905 }, { 186,3905 },
 { 187,3905 }, { 188,3905 }, { 189,3905 }, { 190,3905 }, { 191,3905 },
 { 192,3905 }, { 193,3905 }, { 194,3905 }, { 195,3905 }, { 196,3905 },
 { 197,3905 }, { 198,3905 }, { 199,3905 }, { 200,3905 }, { 201,3905 },
 { 202,3905 }, { 203,3905 }, { 204,3905 }, { 205,3905 }, { 206,3905 },

 { 207,3905 }, { 208,3905 }, { 209,3905 }, { 210,3905 }, { 211,3905 },
 { 212,3905 }, { 213,3905 }, { 214,3905 }, { 215,3905 }, { 216,3905 },
 { 217,3905 }, { 218,3905 }, { 219,3905 }, { 220,3905 }, { 221,3905 },
 { 222,3905 }, { 223,3905 }, { 224,3905 }, { 225,3905 }, { 226,3905 },
 { 227,3905 }, { 228,3905 }, { 229,3905 }, { 230,3905 }, { 231,3905 },
 { 232,3905 }, { 233,3905 }, { 234,3905 }, { 235,3905 }, { 236,3905 },
 { 237,3905 }, { 238,3905 }, { 239,3905 }, { 240,3905 }, { 241,3905 },
 { 242,3905 }, { 243,3905 }, { 244,3905 }, { 245,3905 }, { 246,3905 },
 { 247,3905 }, { 248,3905 }, { 249,3905 }, { 250,3905 }, { 251,3905 },
 { 252,3905 }, { 253,3905 }, { 254,3905 }, { 255,3905 }, {   0,  54 },

 {   0,8690 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  52 }, {   0,8679 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  55 }, {   0,8662 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 }, {  33, -11 },
 {  45,   0 }, {  35, -11 }, {  47,   0 }, {  37, -11 }, {  38, -11 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42, -11 }, {  43, -11 },
 {   0,   0 }, {  45, -11 }, {   0,   0 }, {  47, -11 }, {   0,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60, -11 }, {  61, -11 }, {  62, -11 }, {  63, -11 },
 {  64, -11 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  33 }, {   0,8599 }, {   0,   0 }, {   0,   0 }, {  94,   0 },
 {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94, -11 }, {   0,   0 }, {  96, -11 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 },
 {   0,   0 }, { 126,   0 }, {  36,-5323 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124, -11 }, {   0,   0 }, { 126, -11 }, {   0,   0 }, {  48,3896 },
 {  49,3896 }, {  50,3896 }, {  51,3896 }, {  52,3896 }, {  53,3896 },
 {  54,3896 }, {  55,3896 }, {  56,3896 }, {  57,3896 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3896 }, {  66,3896 }, {  67,3896 }, {  68,3896 },
 {  69,3896 }, {  70,3896 }, {  71,3896 }, {  72,3896 }, {  73,3896 },
 {  74,3896 }, {  75,3896 }, {  76,3896 }, {  77,3896 }, {  78,3896 },
 {  79,3896 }, {  80,3896 }, {  81,3896 }, {  82,3896 }, {  83,3896 },
 {  84,3896 }, {  85,3896 }, {  86,3896 }, {  87,3896 }, {  88,3896 },
 {  89,3896 }, {  90,3896 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,3896 }, {   0,   0 }, {  97,3896 }, {  98,3896 },
 {  99,3896 }, { 100,3896 }, { 101,3896 }, { 102,3896 }, { 103,3896 },
 { 104,3896 }, { 105,3896 }, { 106,3896 }, { 107,3896 }, { 108,3896 },

 { 109,3896 }, { 110,3896 }, { 111,3896 }, { 112,3896 }, { 113,3896 },
 { 114,3896 }, { 115,3896 }, { 116,3896 }, { 117,3896 }, { 118,3896 },
 { 119,3896 }, { 120,3896 }, { 121,3896 }, { 122,3896 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,3896 },
 { 129,3896 }, { 130,3896 }, { 131,3896 }, { 132,3896 }, { 133,3896 },
 { 134,3896 }, { 135,3896 }, { 136,3896 }, { 137,3896 }, { 138,3896 },
 { 139,3896 }, { 140,3896 }, { 141,3896 }, { 142,3896 }, { 143,3896 },
 { 144,3896 }, { 145,3896 }, { 146,3896 }, { 147,3896 }, { 148,3896 },
 { 149,3896 }, { 150,3896 }, { 151,3896 }, { 152,3896 }, { 153,3896 },
 { 154,3896 }, { 155,3896 }, { 156,3896 }, { 157,3896 }, { 158,3896 },

 { 159,3896 }, { 160,3896 }, { 161,3896 }, { 162,3896 }, { 163,3896 },
 { 164,3896 }, { 165,3896 }, { 166,3896 }, { 167,3896 }, { 168,3896 },
 { 169,3896 }, { 170,3896 }, { 171,3896 }, { 172,3896 }, { 173,3896 },
 { 174,3896 }, { 175,3896 }, { 176,3896 }, { 177,3896 }, { 178,3896 },
 { 179,3896 }, { 180,3896 }, { 181,3896 }, { 182,3896 }, { 183,3896 },
 { 184,3896 }, { 185,3896 }, { 186,3896 }, { 187,3896 }, { 188,3896 },
 { 189,3896 }, { 190,3896 }, { 191,3896 }, { 192,3896 }, { 193,3896 },
 { 194,3896 }, { 195,3896 }, { 196,3896 }, { 197,3896 }, { 198,3896 },
 { 199,3896 }, { 200,3896 }, { 201,3896 }, { 202,3896 }, { 203,3896 },
 { 204,3896 }, { 205,3896 }, { 206,3896 }, { 207,3896 }, { 208,3896 },

 { 209,3896 }, { 210,3896 }, { 211,3896 }, { 212,3896 }, { 213,3896 },
 { 214,3896 }, { 215,3896 }, { 216,3896 }, { 217,3896 }, { 218,3896 },
 { 219,3896 }, { 220,3896 }, { 221,3896 }, { 222,3896 }, { 223,3896 },
 { 224,3896 }, { 225,3896 }, { 226,3896 }, { 227,3896 }, { 228,3896 },
 { 229,3896 }, { 230,3896 }, { 231,3896 }, { 232,3896 }, { 233,3896 },
 { 234,3896 }, { 235,3896 }, { 236,3896 }, { 237,3896 }, { 238,3896 },
 { 239,3896 }, { 240,3896 }, { 241,3896 }, { 242,3896 }, { 243,3896 },
 { 244,3896 }, { 245,3896 }, { 246,3896 }, { 247,3896 }, { 248,3896 },
 { 249,3896 }, { 250,3896 }, { 251,3896 }, { 252,3896 }, { 253,3896 },
 { 254,3896 }, { 255,3896 }, {   0,   1 }, {   0,8342 }, {   1,3896 },

 {   2,3896 }, {   3,3896 }, {   4,3896 }, {   5,3896 }, {   6,3896 },
 {   7,3896 }, {   8,3896 }, {   9,3896 }, {   0,   0 }, {  11,3896 },
 {  12,3896 }, {   0,   0 }, {  14,3896 }, {  15,3896 }, {  16,3896 },
 {  17,3896 }, {  18,3896 }, {  19,3896 }, {  20,3896 }, {  21,3896 },
 {  22,3896 }, {  23,3896 }, {  24,3896 }, {  25,3896 }, {  26,3896 },
 {  27,3896 }, {  28,3896 }, {  29,3896 }, {  30,3896 }, {  31,3896 },
 {  32,3896 }, {  33,4154 }, {  34,3896 }, {  35,4154 }, {  36,3896 },
 {  37,4154 }, {  38,4154 }, {  39,3896 }, {  40,3896 }, {  41,3896 },
 {  42,4154 }, {  43,4154 }, {  44,3896 }, {  45,4154 }, {  46,3896 },
 {  47,4154 }, {  48,3896 }, {  49,3896 }, {  50,3896 }, {  51,3896 },

 {  52,3896 }, {  53,3896 }, {  54,3896 }, {  55,3896 }, {  56,3896 },
 {  57,3896 }, {  58,3896 }, {  59,3896 }, {  60,4154 }, {  61,4154 },
 {  62,4154 }, {  63,4154 }, {  64,4154 }, {  65,3896 }, {  66,3896 },
 {  67,3896 }, {  68,3896 }, {  69,3896 }, {  70,3896 }, {  71,3896 },
 {  72,3896 }, {  73,3896 }, {  74,3896 }, {  75,3896 }, {  76,3896 },
 {  77,3896 }, {  78,3896 }, {  79,3896 }, {  80,3896 }, {  81,3896 },
 {  82,3896 }, {  83,3896 }, {  84,3896 }, {  85,3896 }, {  86,3896 },
 {  87,3896 }, {  88,3896 }, {  89,3896 }, {  90,3896 }, {  91,3896 },
 {  92,3896 }, {  93,3896 }, {  94,4154 }, {  95,3896 }, {  96,4154 },
 {  97,3896 }, {  98,3896 }, {  99,3896 }, { 100,3896 }, { 101,3896 },

 { 102,3896 }, { 103,3896 }, { 104,3896 }, { 105,3896 }, { 106,3896 },
 { 107,3896 }, { 108,3896 }, { 109,3896 }, { 110,3896 }, { 111,3896 },
 { 112,3896 }, { 113,3896 }, { 114,3896 }, { 115,3896 }, { 116,3896 },
 { 117,3896 }, { 118,3896 }, { 119,3896 }, { 120,3896 }, { 121,3896 },
 { 122,3896 }, { 123,3896 }, { 124,4154 }, { 125,3896 }, { 126,4154 },
 { 127,3896 }, { 128,3896 }, { 129,3896 }, { 130,3896 }, { 131,3896 },
 { 132,3896 }, { 133,3896 }, { 134,3896 }, { 135,3896 }, { 136,3896 },
 { 137,3896 }, { 138,3896 }, { 139,3896 }, { 140,3896 }, { 141,3896 },
 { 142,3896 }, { 143,3896 }, { 144,3896 }, { 145,3896 }, { 146,3896 },
 { 147,3896 }, { 148,3896 }, { 149,3896 }, { 150,3896 }, { 151,3896 },

 { 152,3896 }, { 153,3896 }, { 154,3896 }, { 155,3896 }, { 156,3896 },
 { 157,3896 }, { 158,3896 }, { 159,3896 }, { 160,3896 }, { 161,3896 },
 { 162,3896 }, { 163,3896 }, { 164,3896 }, { 165,3896 }, { 166,3896 },
 { 167,3896 }, { 168,3896 }, { 169,3896 }, { 170,3896 }, { 171,3896 },
 { 172,3896 }, { 173,3896 }, { 174,3896 }, { 175,3896 }, { 176,3896 },
 { 177,3896 }, { 178,3896 }, { 179,3896 }, { 180,3896 }, { 181,3896 },
 { 182,3896 }, { 183,3896 }, { 184,3896 }, { 185,3896 }, { 186,3896 },
 { 187,3896 }, { 188,3896 }, { 189,3896 }, { 190,3896 }, { 191,3896 },
 { 192,3896 }, { 193,3896 }, { 194,3896 }, { 195,3896 }, { 196,3896 },
 { 197,3896 }, { 198,3896 }, { 199,3896 }, { 200,3896 }, { 201,3896 },

 { 202,3896 }, { 203,3896 }, { 204,3896 }, { 205,3896 }, { 206,3896 },
 { 207,3896 }, { 208,3896 }, { 209,3896 }, { 210,3896 }, { 211,3896 },
 { 212,3896 }, { 213,3896 }, { 214,3896 }, { 215,3896 }, { 216,3896 },
 { 217,3896 }, { 218,3896 }, { 219,3896 }, { 220,3896 }, { 221,3896 },
 { 222,3896 }, { 223,3896 }, { 224,3896 }, { 225,3896 }, { 226,3896 },
 { 227,3896 }, { 228,3896 }, { 229,3896 }, { 230,3896 }, { 231,3896 },
 { 232,3896 }, { 233,3896 }, { 234,3896 }, { 235,3896 }, { 236,3896 },
 { 237,3896 }, { 238,3896 }, { 239,3896 }, { 240,3896 }, { 241,3896 },
 { 242,3896 }, { 243,3896 }, { 244,3896 }, { 245,3896 }, { 246,3896 },
 { 247,3896 }, { 248,3896 }, { 249,3896 }, { 250,3896 }, { 251,3896 },

 { 252,3896 }, { 253,3896 }, { 254,3896 }, { 255,3896 }, { 256,3896 },
 {   0,  57 }, {   0,8084 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   2 }, {   0,8059 }, {   0,  57 }, {   0,8057 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  33,4129 },
 {   0,   0 }, {  35,4129 }, {   0,   0 }, {  37,4129 }, {  38,4129 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4129 }, {  43,4129 },
 {  69, 113 }, {  45,4129 }, {   0,   0 }, {  47,4129 }, {  46,-5584 },
 {   0,   0 }, {  48,4129 }, {  49,4129 }, {  50,4129 }, {  51,4129 },
 {  52,4129 }, {  53,4129 }, {  54,4129 }, {  55,4129 }, {  56,4129 },
 {  57,4129 }, {  60,4129 }, {  61,4129 }, {  62,4129 }, {  63,4129 },
 {  64,4129 }, {   0,  56 }, {   0,7993 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  69,  86 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 101, 113 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  60 }, {   0,7971 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,4129 }, {   0,   0 }, {  96,4129 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 101,  86 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46, -64 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },

 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 { 124,4129 }, {   0,   0 }, { 126,4129 }, {   0,  49 }, {   0,7931 },
 {   0,   0 }, {   0,   0 }, {  43,4065 }, {   0,   0 }, {  45,4065 },
 {   0,   0 }, {  69,  22 }, {  48,4107 }, {  49,4107 }, {  50,4107 },
 {  51,4107 }, {  52,4107 }, {  53,4107 }, {  54,4107 }, {  55,4107 },
 {  56,4107 }, {  57,4107 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,-759 }, {   0,   0 }, {  35,-759 },
 {   0,   0 }, {  37,-759 }, {  38,-759 }, { 101,  22 }, {   0,  51 },

 {   0,7890 }, {  42,-759 }, {  43,-759 }, {   0,   0 }, {  45,-759 },
 {   0,   0 }, {  47,-759 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-759 },
 {  61,-759 }, {  62,-759 }, {  63,-759 }, {  64,-759 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-800 }, {   0,   0 },
 {  35,-800 }, {   0,   0 }, {  37,-800 }, {  38,-800 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,-800 }, {  43,-800 }, {   0,   0 },
 {  45,-800 }, {   0,   0 }, {  47,-800 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-759 }, {   0,   0 },
 {  96,-759 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,-800 }, {  61,-800 }, {  62,-800 }, {  63,-800 }, {  64,-800 },
 {   0,   0 }, {   0,  48 }, {   0,7823 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  50 }, {   0,7812 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-759 }, {   0,   0 },
 { 126,-759 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-800 },
 {   0,   0 }, {  96,-800 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  33,-867 }, {   0,   0 }, {  35,-867 }, {   0,   0 }, {  37,-867 },
 {  38,-867 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-867 },
 {  43,-867 }, {  33,-878 }, {  45,-867 }, {  35,-878 }, {  47,-867 },
 {  37,-878 }, {  38,-878 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,-878 }, {  43,-878 }, {   0,   0 }, {  45,-878 }, { 124,-800 },
 {  47,-878 }, { 126,-800 }, {  60,-867 }, {  61,-867 }, {  62,-867 },
 {  63,-867 }, {  64,-867 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-878 }, {  61,-878 },
 {  62,-878 }, {  63,-878 }, {  64,-878 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  62 }, {   0,7732 }, {   0,   0 },
 {   0,   0 }, {  94,-867 }, {   0,   0 }, {  96,-867 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-878 }, {   0,   0 }, {  96,-878 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,-867 }, {   0,   0 }, { 126,-867 }, {  36,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 124,-878 }, {   0,   0 }, { 126,-878 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },

 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },

 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },

 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  10 },
 {   0,7475 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },

 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },

 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },

 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },

 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },

 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,   5 }, {   0,7217 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },

 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {   0,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },

 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },

 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },

 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },

 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   3 }, {   0,6959 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,3121 },
 {   0,   0 }, {  35,3121 }, {   0,   0 }, {  37,3121 }, {  38,3121 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,3121 }, {  43,3121 },
 {   0,   0 }, {  45,3121 }, {   0,   0 }, {  47,3121 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,3121 }, {  61,3121 }, {  62,3121 }, {  63,3121 },
 {  64,3121 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,3121 }, {   0,   0 }, {  96,3121 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,3121 }, {   0,   0 }, { 126,3121 }, {   0,  43 }, {   0,6831 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },

 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },

 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },

 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },

 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },

 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   9 }, {   0,6573 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },

 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },

 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },

 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },

 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },

 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  21 },
 {   0,6315 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },

 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },

 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },

 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },

 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },

 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  18 }, {   0,6057 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  18 }, {   0,6052 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   5 }, {   0,   0 },
 {  12,   0 }, {  13,   5 }, {   9,  16 }, {  10,  16 }, {   0,   0 },

 {  12,  16 }, {  13,  16 }, {   0,   0 }, {   0,  18 }, {   0,6036 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {  32,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {  32,  16 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-7599 }, {  45,-7596 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-7597 }, {   0,   0 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-7615 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-7613 },

 {   0,  18 }, {   0,5989 }, {   1,2537 }, {   2,2537 }, {   3,2537 },
 {   4,2537 }, {   5,2537 }, {   6,2537 }, {   7,2537 }, {   8,2537 },
 {   9,2795 }, {  10, -63 }, {  11,2537 }, {  12,2795 }, {  13, -63 },
 {  14,2537 }, {  15,2537 }, {  16,2537 }, {  17,2537 }, {  18,2537 },
 {  19,2537 }, {  20,2537 }, {  21,2537 }, {  22,2537 }, {  23,2537 },
 {  24,2537 }, {  25,2537 }, {  26,2537 }, {  27,2537 }, {  28,2537 },
 {  29,2537 }, {  30,2537 }, {  31,2537 }, {  32,2795 }, {  33,2537 },
 {  34,2537 }, {  35,2537 }, {  36,2537 }, {  37,2537 }, {  38,2537 },
 {  39,2537 }, {  40,2537 }, {  41,2537 }, {  42,2537 }, {  43,2537 },
 {  44,2537 }, {  45,3053 }, {  46,2537 }, {  47,2537 }, {  48,2537 },

 {  49,2537 }, {  50,2537 }, {  51,2537 }, {  52,2537 }, {  53,2537 },
 {  54,2537 }, {  55,2537 }, {  56,2537 }, {  57,2537 }, {  58,2537 },
 {  59,2537 }, {  60,2537 }, {  61,2537 }, {  62,2537 }, {  63,2537 },
 {  64,2537 }, {  65,2537 }, {  66,2537 }, {  67,2537 }, {  68,2537 },
 {  69,2537 }, {  70,2537 }, {  71,2537 }, {  72,2537 }, {  73,2537 },
 {  74,2537 }, {  75,2537 }, {  76,2537 }, {  77,2537 }, {  78,2537 },
 {  79,2537 }, {  80,2537 }, {  81,2537 }, {  82,2537 }, {  83,2537 },
 {  84,2537 }, {  85,2537 }, {  86,2537 }, {  87,2537 }, {  88,2537 },
 {  89,2537 }, {  90,2537 }, {  91,2537 }, {  92,2537 }, {  93,2537 },
 {  94,2537 }, {  95,2537 }, {  96,2537 }, {  97,2537 }, {  98,2537 },

 {  99,2537 }, { 100,2537 }, { 101,2537 }, { 102,2537 }, { 103,2537 },
 { 104,2537 }, { 105,2537 }, { 106,2537 }, { 107,2537 }, { 108,2537 },
 { 109,2537 }, { 110,2537 }, { 111,2537 }, { 112,2537 }, { 113,2537 },
 { 114,2537 }, { 115,2537 }, { 116,2537 }, { 117,2537 }, { 118,2537 },
 { 119,2537 }, { 120,2537 }, { 121,2537 }, { 122,2537 }, { 123,2537 },
 { 124,2537 }, { 125,2537 }, { 126,2537 }, { 127,2537 }, { 128,2537 },
 { 129,2537 }, { 130,2537 }, { 131,2537 }, { 132,2537 }, { 133,2537 },
 { 134,2537 }, { 135,2537 }, { 136,2537 }, { 137,2537 }, { 138,2537 },
 { 139,2537 }, { 140,2537 }, { 141,2537 }, { 142,2537 }, { 143,2537 },
 { 144,2537 }, { 145,2537 }, { 146,2537 }, { 147,2537 }, { 148,2537 },

 { 149,2537 }, { 150,2537 }, { 151,2537 }, { 152,2537 }, { 153,2537 },
 { 154,2537 }, { 155,2537 }, { 156,2537 }, { 157,2537 }, { 158,2537 },
 { 159,2537 }, { 160,2537 }, { 161,2537 }, { 162,2537 }, { 163,2537 },
 { 164,2537 }, { 165,2537 }, { 166,2537 }, { 167,2537 }, { 168,2537 },
 { 169,2537 }, { 170,2537 }, { 171,2537 }, { 172,2537 }, { 173,2537 },
 { 174,2537 }, { 175,2537 }, { 176,2537 }, { 177,2537 }, { 178,2537 },
 { 179,2537 }, { 180,2537 }, { 181,2537 }, { 182,2537 }, { 183,2537 },
 { 184,2537 }, { 185,2537 }, { 186,2537 }, { 187,2537 }, { 188,2537 },
 { 189,2537 }, { 190,2537 }, { 191,2537 }, { 192,2537 }, { 193,2537 },
 { 194,2537 }, { 195,2537 }, { 196,2537 }, { 197,2537 }, { 198,2537 },

 { 199,2537 }, { 200,2537 }, { 201,2537 }, { 202,2537 }, { 203,2537 },
 { 204,2537 }, { 205,2537 }, { 206,2537 }, { 207,2537 }, { 208,2537 },
 { 209,2537 }, { 210,2537 }, { 211,2537 }, { 212,2537 }, { 213,2537 },
 { 214,2537 }, { 215,2537 }, { 216,2537 }, { 217,2537 }, { 218,2537 },
 { 219,2537 }, { 220,2537 }, { 221,2537 }, { 222,2537 }, { 223,2537 },
 { 224,2537 }, { 225,2537 }, { 226,2537 }, { 227,2537 }, { 228,2537 },
 { 229,2537 }, { 230,2537 }, { 231,2537 }, { 232,2537 }, { 233,2537 },
 { 234,2537 }, { 235,2537 }, { 236,2537 }, { 237,2537 }, { 238,2537 },
 { 239,2537 }, { 240,2537 }, { 241,2537 }, { 242,2537 }, { 243,2537 },
 { 244,2537 }, { 245,2537 }, { 246,2537 }, { 247,2537 }, { 248,2537 },

 { 249,2537 }, { 250,2537 }, { 251,2537 }, { 252,2537 }, { 253,2537 },
 { 254,2537 }, { 255,2537 }, { 256,2537 }, {   0,  22 }, {   0,5731 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },

 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },

 {  91,   0 }, {   0,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },

 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },

 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },

 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  29 }, {   0,5473 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,5465 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,5442 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,2795 }, {  49,2795 }, {  50,2795 }, {  51,2795 }, {  52,2795 },
 {  53,2795 }, {  54,2795 }, {  55,2795 }, {  48,2795 }, {  49,2795 },
 {  50,2795 }, {  51,2795 }, {  52,2795 }, {  53,2795 }, {  54,2795 },
 {  55,2795 }, {  56,2795 }, {  57,2795 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,5404 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,2795 }, {  66,2795 }, {  67,2795 }, {  68,2795 }, {  69,2795 },
 {  70,2795 }, {  48,2795 }, {  49,2795 }, {  50,2795 }, {  51,2795 },

 {  52,2795 }, {  53,2795 }, {  54,2795 }, {  55,2795 }, {  56,2795 },
 {  57,2795 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2795 }, {  66,2795 },
 {  67,2795 }, {  68,2795 }, {  69,2795 }, {  70,2795 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,2795 }, {  98,2795 }, {  99,2795 },
 { 100,2795 }, { 101,2795 }, { 102,2795 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2795 },
 {  49,2795 }, {  50,2795 }, {  51,2795 }, {  52,2795 }, {  53,2795 },
 {  54,2795 }, {  55,2795 }, {  56,2795 }, {  57,2795 }, {   0,   0 },
 {  97,2795 }, {  98,2795 }, {  99,2795 }, { 100,2795 }, { 101,2795 },

 { 102,2795 }, {  65,2795 }, {  66,2795 }, {  67,2795 }, {  68,2795 },
 {  69,2795 }, {  70,2795 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,2795 }, {  98,2795 },
 {  99,2795 }, { 100,2795 }, { 101,2795 }, { 102,2795 }, {   0,  35 },
 {   0,5300 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },

 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },

 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },

 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },

 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },

 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  36 }, {   0,5042 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-8603 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,2505 }, {  49,2505 }, {  50,2505 }, {  51,2505 },

 {  52,2505 }, {  53,2505 }, {  54,2505 }, {  55,2505 }, {  56,2505 },
 {  57,2505 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2505 }, {  66,2505 },
 {  67,2505 }, {  68,2505 }, {  69,2505 }, {  70,2505 }, {  71,2505 },
 {  72,2505 }, {  73,2505 }, {  74,2505 }, {  75,2505 }, {  76,2505 },
 {  77,2505 }, {  78,2505 }, {  79,2505 }, {  80,2505 }, {  81,2505 },
 {  82,2505 }, {  83,2505 }, {  84,2505 }, {  85,2505 }, {  86,2505 },
 {  87,2505 }, {  88,2505 }, {  89,2505 }, {  90,2505 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2505 }, {   0,   0 },
 {  97,2505 }, {  98,2505 }, {  99,2505 }, { 100,2505 }, { 101,2505 },

 { 102,2505 }, { 103,2505 }, { 104,2505 }, { 105,2505 }, { 106,2505 },
 { 107,2505 }, { 108,2505 }, { 109,2505 }, { 110,2505 }, { 111,2505 },
 { 112,2505 }, { 113,2505 }, { 114,2505 }, { 115,2505 }, { 116,2505 },
 { 117,2505 }, { 118,2505 }, { 119,2505 }, { 120,2505 }, { 121,2505 },
 { 122,2505 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,2505 }, { 129,2505 }, { 130,2505 }, { 131,2505 },
 { 132,2505 }, { 133,2505 }, { 134,2505 }, { 135,2505 }, { 136,2505 },
 { 137,2505 }, { 138,2505 }, { 139,2505 }, { 140,2505 }, { 141,2505 },
 { 142,2505 }, { 143,2505 }, { 144,2505 }, { 145,2505 }, { 146,2505 },
 { 147,2505 }, { 148,2505 }, { 149,2505 }, { 150,2505 }, { 151,2505 },

 { 152,2505 }, { 153,2505 }, { 154,2505 }, { 155,2505 }, { 156,2505 },
 { 157,2505 }, { 158,2505 }, { 159,2505 }, { 160,2505 }, { 161,2505 },
 { 162,2505 }, { 163,2505 }, { 164,2505 }, { 165,2505 }, { 166,2505 },
 { 167,2505 }, { 168,2505 }, { 169,2505 }, { 170,2505 }, { 171,2505 },
 { 172,2505 }, { 173,2505 }, { 174,2505 }, { 175,2505 }, { 176,2505 },
 { 177,2505 }, { 178,2505 }, { 179,2505 }, { 180,2505 }, { 181,2505 },
 { 182,2505 }, { 183,2505 }, { 184,2505 }, { 185,2505 }, { 186,2505 },
 { 187,2505 }, { 188,2505 }, { 189,2505 }, { 190,2505 }, { 191,2505 },
 { 192,2505 }, { 193,2505 }, { 194,2505 }, { 195,2505 }, { 196,2505 },
 { 197,2505 }, { 198,2505 }, { 199,2505 }, { 200,2505 }, { 201,2505 },

 { 202,2505 }, { 203,2505 }, { 204,2505 }, { 205,2505 }, { 206,2505 },
 { 207,2505 }, { 208,2505 }, { 209,2505 }, { 210,2505 }, { 211,2505 },
 { 212,2505 }, { 213,2505 }, { 214,2505 }, { 215,2505 }, { 216,2505 },
 { 217,2505 }, { 218,2505 }, { 219,2505 }, { 220,2505 }, { 221,2505 },
 { 222,2505 }, { 223,2505 }, { 224,2505 }, { 225,2505 }, { 226,2505 },
 { 227,2505 }, { 228,2505 }, { 229,2505 }, { 230,2505 }, { 231,2505 },
 { 232,2505 }, { 233,2505 }, { 234,2505 }, { 235,2505 }, { 236,2505 },
 { 237,2505 }, { 238,2505 }, { 239,2505 }, { 240,2505 }, { 241,2505 },
 { 242,2505 }, { 243,2505 }, { 244,2505 }, { 245,2505 }, { 246,2505 },
 { 247,2505 }, { 248,2505 }, { 249,2505 }, { 250,2505 }, { 251,2505 },

 { 252,2505 }, { 253,2505 }, { 254,2505 }, { 255,2505 }, {   0,  27 },
 {   0,4785 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,4762 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2505 }, {  49,2505 },
 {  50,2505 }, {  51,2505 }, {  52,2505 }, {  53,2505 }, {  54,2505 },
 {  55,2505 }, {  56,2505 }, {  57,2505 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,2505 }, {  66,2505 }, {  67,2505 }, {  68,2505 }, {  69,2505 },
 {  70,2505 }, {  48,2505 }, {  49,2505 }, {  50,2505 }, {  51,2505 },
 {  52,2505 }, {  53,2505 }, {  54,2505 }, {  55,2505 }, {  56,2505 },
 {  57,2505 }, {   0,  33 }, {   0,4703 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2505 }, {  66,2505 },
 {  67,2505 }, {  68,2505 }, {  69,2505 }, {  70,2505 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  97,2505 }, {  98,2505 }, {  99,2505 },
 { 100,2505 }, { 101,2505 }, { 102,2505 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-9219 }, {   0,   0 },
 {  97,2505 }, {  98,2505 }, {  99,2505 }, { 100,2505 }, { 101,2505 },
 { 102,2505 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,   1 }, {   0,4446 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },

 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 },
 {  11,   0 }, {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },

 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },

 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },

 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },

 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },

 { 256,   0 }, {   0,   1 }, {   0,4188 }, {   1,-258 }, {   2,-258 },
 {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 },
 {   8,-258 }, {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 },
 {   0,   0 }, {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 },
 {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 },
 {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 },
 {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 },
 {  33,   0 }, {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 },
 {  38,   0 }, {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 },
 {  43,   0 }, {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 },

 {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 },
 {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 },
 {  58,-258 }, {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 },
 {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 },
 {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 },
 {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 },
 {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 },
 {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 },
 {  93,-258 }, {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 },

 {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 },
 { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 },
 { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 },
 { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 },
 { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 },
 { 123,-258 }, { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 },
 { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 },
 { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 },
 { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 },
 { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 },

 { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 },
 { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 },
 { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 },
 { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 },
 { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 },
 { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 },
 { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 },
 { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 },
 { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 },
 { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 },

 { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 },
 { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 },
 { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 },
 { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 },
 { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 },
 { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 },
 { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 },
 { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 },
 { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 },
 { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 },

 { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 },
 { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,   2 },
 {   0,3930 }, {   0,  57 }, {   0,3928 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  61 }, {   0,3906 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 },
 {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {   0,  59 }, {   0,3864 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  69,-4043 }, {  48,  42 }, {  49,  42 }, {  50,  42 },
 {  51,  42 }, {  52,  42 }, {  53,  42 }, {  54,  42 }, {  55,  42 },
 {  56,  42 }, {  57,  42 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   3 }, {   0,3838 }, {   0,   0 }, {  94,   0 },
 {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 101,-4043 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, { 124,   0 },
 {  33,   0 }, { 126,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {   0,   0 }, {  45,   0 }, {   0,   0 }, {  47,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,  18 },
 {   0,3710 }, {   1,1557 }, {   2,1557 }, {   3,1557 }, {   4,1557 },
 {   5,1557 }, {   6,1557 }, {   7,1557 }, {   8,1557 }, {   9,1815 },
 {  10,2073 }, {  11,1557 }, {  12,1815 }, {  13,2073 }, {  14,1557 },
 {  15,1557 }, {  16,1557 }, {  17,1557 }, {  18,1557 }, {  19,1557 },

 {  20,1557 }, {  21,1557 }, {  22,1557 }, {  23,1557 }, {  24,1557 },
 {  25,1557 }, {  26,1557 }, {  27,1557 }, {  28,1557 }, {  29,1557 },
 {  30,1557 }, {  31,1557 }, {  32,1815 }, {  33,1557 }, {  34,1557 },
 {  35,1557 }, {  36,1557 }, {  37,1557 }, {  38,1557 }, {  39,1557 },
 {  40,1557 }, {  41,1557 }, {  42,1557 }, {  43,1557 }, {  44,1557 },
 {  45,2120 }, {  46,1557 }, {  47,1557 }, {  48,1557 }, {  49,1557 },
 {  50,1557 }, {  51,1557 }, {  52,1557 }, {  53,1557 }, {  54,1557 },
 {  55,1557 }, {  56,1557 }, {  57,1557 }, {  58,1557 }, {  59,1557 },
 {  60,1557 }, {  61,1557 }, {  62,1557 }, {  63,1557 }, {  64,1557 },
 {  65,1557 }, {  66,1557 }, {  67,1557 }, {  68,1557 }, {  69,1557 },

 {  70,1557 }, {  71,1557 }, {  72,1557 }, {  73,1557 }, {  74,1557 },
 {  75,1557 }, {  76,1557 }, {  77,1557 }, {  78,1557 }, {  79,1557 },
 {  80,1557 }, {  81,1557 }, {  82,1557 }, {  83,1557 }, {  84,1557 },
 {  85,1557 }, {  86,1557 }, {  87,1557 }, {  88,1557 }, {  89,1557 },
 {  90,1557 }, {  91,1557 }, {  92,1557 }, {  93,1557 }, {  94,1557 },
 {  95,1557 }, {  96,1557 }, {  97,1557 }, {  98,1557 }, {  99,1557 },
 { 100,1557 }, { 101,1557 }, { 102,1557 }, { 103,1557 }, { 104,1557 },
 { 105,1557 }, { 106,1557 }, { 107,1557 }, { 108,1557 }, { 109,1557 },
 { 110,1557 }, { 111,1557 }, { 112,1557 }, { 113,1557 }, { 114,1557 },
 { 115,1557 }, { 116,1557 }, { 117,1557 }, { 118,1557 }, { 119,1557 },

 { 120,1557 }, { 121,1557 }, { 122,1557 }, { 123,1557 }, { 124,1557 },
 { 125,1557 }, { 126,1557 }, { 127,1557 }, { 128,1557 }, { 129,1557 },
 { 130,1557 }, { 131,1557 }, { 132,1557 }, { 133,1557 }, { 134,1557 },
 { 135,1557 }, { 136,1557 }, { 137,1557 }, { 138,1557 }, { 139,1557 },
 { 140,1557 }, { 141,1557 }, { 142,1557 }, { 143,1557 }, { 144,1557 },
 { 145,1557 }, { 146,1557 }, { 147,1557 }, { 148,1557 }, { 149,1557 },
 { 150,1557 }, { 151,1557 }, { 152,1557 }, { 153,1557 }, { 154,1557 },
 { 155,1557 }, { 156,1557 }, { 157,1557 }, { 158,1557 }, { 159,1557 },
 { 160,1557 }, { 161,1557 }, { 162,1557 }, { 163,1557 }, { 164,1557 },
 { 165,1557 }, { 166,1557 }, { 167,1557 }, { 168,1557 }, { 169,1557 },

 { 170,1557 }, { 171,1557 }, { 172,1557 }, { 173,1557 }, { 174,1557 },
 { 175,1557 }, { 176,1557 }, { 177,1557 }, { 178,1557 }, { 179,1557 },
 { 180,1557 }, { 181,1557 }, { 182,1557 }, { 183,1557 }, { 184,1557 },
 { 185,1557 }, { 186,1557 }, { 187,1557 }, { 188,1557 }, { 189,1557 },
 { 190,1557 }, { 191,1557 }, { 192,1557 }, { 193,1557 }, { 194,1557 },
 { 195,1557 }, { 196,1557 }, { 197,1557 }, { 198,1557 }, { 199,1557 },
 { 200,1557 }, { 201,1557 }, { 202,1557 }, { 203,1557 }, { 204,1557 },
 { 205,1557 }, { 206,1557 }, { 207,1557 }, { 208,1557 }, { 209,1557 },
 { 210,1557 }, { 211,1557 }, { 212,1557 }, { 213,1557 }, { 214,1557 },
 { 215,1557 }, { 216,1557 }, { 217,1557 }, { 218,1557 }, { 219,1557 },

 { 220,1557 }, { 221,1557 }, { 222,1557 }, { 223,1557 }, { 224,1557 },
 { 225,1557 }, { 226,1557 }, { 227,1557 }, { 228,1557 }, { 229,1557 },
 { 230,1557 }, { 231,1557 }, { 232,1557 }, { 233,1557 }, { 234,1557 },
 { 235,1557 }, { 236,1557 }, { 237,1557 }, { 238,1557 }, { 239,1557 },
 { 240,1557 }, { 241,1557 }, { 242,1557 }, { 243,1557 }, { 244,1557 },
 { 245,1557 }, { 246,1557 }, { 247,1557 }, { 248,1557 }, { 249,1557 },
 { 250,1557 }, { 251,1557 }, { 252,1557 }, { 253,1557 }, { 254,1557 },
 { 255,1557 }, { 256,1557 }, {   0,  18 }, {   0,3452 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9, 258 }, {  10,-2600 }, {  11,   0 },

 {  12, 258 }, {  13,-2600 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32, 258 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45, 516 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },

 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },

 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },

 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },

 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  18 }, {   0,3194 }, {   1,-258 }, {   2,-258 }, {   3,-258 },

 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   9,   0 }, {  10,-2858 }, {  11,-258 }, {  12,   0 }, {  13,-2858 },
 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },
 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 },
 {  34,-258 }, {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 },
 {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 },
 {  44,-258 }, {  45, 258 }, {  46,-258 }, {  47,-258 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },

 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 },
 {  59,-258 }, {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 },
 {  64,-258 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },
 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },
 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },
 {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 },
 {  94,-258 }, {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },

 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },
 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 },
 { 124,-258 }, { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },
 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },
 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },
 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },

 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },
 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },
 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },
 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },
 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },
 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },

 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },
 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },
 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },
 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },
 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },
 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },

 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  18 }, {   0,2936 },
 {   1,-516 }, {   2,-516 }, {   3,-516 }, {   4,-516 }, {   5,-516 },
 {   6,-516 }, {   7,-516 }, {   8,-516 }, {   9,-258 }, {  10,-3116 },
 {  11,-516 }, {  12,-258 }, {  13,-3116 }, {  14,-516 }, {  15,-516 },
 {  16,-516 }, {  17,-516 }, {  18,-516 }, {  19,-516 }, {  20,-516 },
 {  21,-516 }, {  22,-516 }, {  23,-516 }, {  24,-516 }, {  25,-516 },
 {  26,-516 }, {  27,-516 }, {  28,-516 }, {  29,-516 }, {  30,-516 },
 {  31,-516 }, {  32,-258 }, {  33,-516 }, {  34,-516 }, {  35,-516 },
 {  36,-516 }, {  37,-516 }, {  38,-516 }, {  39,-516 }, {  40,-516 },
 {  41,-516 }, {  42,-516 }, {  43,-516 }, {  44,-516 }, {  45,1604 },

 {  46,-516 }, {  47,-516 }, {  48,-516 }, {  49,-516 }, {  50,-516 },
 {  51,-516 }, {  52,-516 }, {  53,-516 }, {  54,-516 }, {  55,-516 },
 {  56,-516 }, {  57,-516 }, {  58,-516 }, {  59,-516 }, {  60,-516 },
 {  61,-516 }, {  62,-516 }, {  63,-516 }, {  64,-516 }, {  65,-516 },
 {  66,-516 }, {  67,-516 }, {  68,-516 }, {  69,-516 }, {  70,-516 },
 {  71,-516 }, {  72,-516 }, {  73,-516 }, {  74,-516 }, {  75,-516 },
 {  76,-516 }, {  77,-516 }, {  78,-516 }, {  79,-516 }, {  80,-516 },
 {  81,-516 }, {  82,-516 }, {  83,-516 }, {  84,-516 }, {  85,-516 },
 {  86,-516 }, {  87,-516 }, {  88,-516 }, {  89,-516 }, {  90,-516 },
 {  91,-516 }, {  92,-516 }, {  93,-516 }, {  94,-516 }, {  95,-516 },

 {  96,-516 }, {  97,-516 }, {  98,-516 }, {  99,-516 }, { 100,-516 },
 { 101,-516 }, { 102,-516 }, { 103,-516 }, { 104,-516 }, { 105,-516 },
 { 106,-516 }, { 107,-516 }, { 108,-516 }, { 109,-516 }, { 110,-516 },
 { 111,-516 }, { 112,-516 }, { 113,-516 }, { 114,-516 }, { 115,-516 },
 { 116,-516 }, { 117,-516 }, { 118,-516 }, { 119,-516 }, { 120,-516 },
 { 121,-516 }, { 122,-516 }, { 123,-516 }, { 124,-516 }, { 125,-516 },
 { 126,-516 }, { 127,-516 }, { 128,-516 }, { 129,-516 }, { 130,-516 },
 { 131,-516 }, { 132,-516 }, { 133,-516 }, { 134,-516 }, { 135,-516 },
 { 136,-516 }, { 137,-516 }, { 138,-516 }, { 139,-516 }, { 140,-516 },
 { 141,-516 }, { 142,-516 }, { 143,-516 }, { 144,-516 }, { 145,-516 },

 { 146,-516 }, { 147,-516 }, { 148,-516 }, { 149,-516 }, { 150,-516 },
 { 151,-516 }, { 152,-516 }, { 153,-516 }, { 154,-516 }, { 155,-516 },
 { 156,-516 }, { 157,-516 }, { 158,-516 }, { 159,-516 }, { 160,-516 },
 { 161,-516 }, { 162,-516 }, { 163,-516 }, { 164,-516 }, { 165,-516 },
 { 166,-516 }, { 167,-516 }, { 168,-516 }, { 169,-516 }, { 170,-516 },
 { 171,-516 }, { 172,-516 }, { 173,-516 }, { 174,-516 }, { 175,-516 },
 { 176,-516 }, { 177,-516 }, { 178,-516 }, { 179,-516 }, { 180,-516 },
 { 181,-516 }, { 182,-516 }, { 183,-516 }, { 184,-516 }, { 185,-516 },
 { 186,-516 }, { 187,-516 }, { 188,-516 }, { 189,-516 }, { 190,-516 },
 { 191,-516 }, { 192,-516 }, { 193,-516 }, { 194,-516 }, { 195,-516 },

 { 196,-516 }, { 197,-516 }, { 198,-516 }, { 199,-516 }, { 200,-516 },
 { 201,-516 }, { 202,-516 }, { 203,-516 }, { 204,-516 }, { 205,-516 },
 { 206,-516 }, { 207,-516 }, { 208,-516 }, { 209,-516 }, { 210,-516 },
 { 211,-516 }, { 212,-516 }, { 213,-516 }, { 214,-516 }, { 215,-516 },
 { 216,-516 }, { 217,-516 }, { 218,-516 }, { 219,-516 }, { 220,-516 },
 { 221,-516 }, { 222,-516 }, { 223,-516 }, { 224,-516 }, { 225,-516 },
 { 226,-516 }, { 227,-516 }, { 228,-516 }, { 229,-516 }, { 230,-516 },
 { 231,-516 }, { 232,-516 }, { 233,-516 }, { 234,-516 }, { 235,-516 },
 { 236,-516 }, { 237,-516 }, { 238,-516 }, { 239,-516 }, { 240,-516 },
 { 241,-516 }, { 242,-516 }, { 243,-516 }, { 244,-516 }, { 245,-516 },

 { 246,-516 }, { 247,-516 }, { 248,-516 }, { 249,-516 }, { 250,-516 },
 { 251,-516 }, { 252,-516 }, { 253,-516 }, { 254,-516 }, { 255,-516 },
 { 256,-516 }, {   0,  29 }, {   0,2678 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,2670 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,2647 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-10928 }, {  49,-10928 }, {  50,-10928 }, {  51,-10928 }, {  52,-10928 },
 {  53,-10928 }, {  54,-10928 }, {  55,-10928 }, {  48,1596 }, {  49,1596 },
 {  50,1596 }, {  51,1596 }, {  52,1596 }, {  53,1596 }, {  54,1596 },
 {  55,1596 }, {  56,1596 }, {  57,1596 }, {   0,   0 }, {   0,   0 },
 {   0,  30 }, {   0,2609 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1596 }, {  66,1596 }, {  67,1596 }, {  68,1596 }, {  69,1596 },
 {  70,1596 }, {  48,1596 }, {  49,1596 }, {  50,1596 }, {  51,1596 },
 {  52,1596 }, {  53,1596 }, {  54,1596 }, {  55,1596 }, {  56,1596 },

 {  57,1596 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1596 }, {  66,1596 },
 {  67,1596 }, {  68,1596 }, {  69,1596 }, {  70,1596 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,1596 }, {  98,1596 }, {  99,1596 },
 { 100,1596 }, { 101,1596 }, { 102,1596 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-10975 },
 {  49,-10975 }, {  50,-10975 }, {  51,-10975 }, {  52,-10975 }, {  53,-10975 },
 {  54,-10975 }, {  55,-10975 }, {  56,-10975 }, {  57,-10975 }, {   0,   0 },
 {  97,1596 }, {  98,1596 }, {  99,1596 }, { 100,1596 }, { 101,1596 },
 { 102,1596 }, {  65,-10975 }, {  66,-10975 }, {  67,-10975 }, {  68,-10975 },

 {  69,-10975 }, {  70,-10975 }, {   0,  36 }, {   0,2537 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-10975 }, {  98,-10975 },
 {  99,-10975 }, { 100,-10975 }, { 101,-10975 }, { 102,-10975 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-11108 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 },

 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },

 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },

 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },

 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  27 },
 {   0,2280 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,2257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1267 }, {  49,1267 },
 {  50,1267 }, {  51,1267 }, {  52,1267 }, {  53,1267 }, {  54,1267 },
 {  55,1267 }, {  56,1267 }, {  57,1267 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1267 }, {  66,1267 }, {  67,1267 }, {  68,1267 }, {  69,1267 },
 {  70,1267 }, {  48,1267 }, {  49,1267 }, {  50,1267 }, {  51,1267 },
 {  52,1267 }, {  53,1267 }, {  54,1267 }, {  55,1267 }, {  56,1267 },
 {  57,1267 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1267 }, {  66,1267 },

 {  67,1267 }, {  68,1267 }, {  69,1267 }, {  70,1267 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,1267 }, {  98,1267 }, {  99,1267 },
 { 100,1267 }, { 101,1267 }, { 102,1267 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,1267 }, {  98,1267 }, {  99,1267 }, { 100,1267 }, { 101,1267 },
 { 102,1267 }, {   0,  18 }, {   0,2153 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9, 258 }, {  10, 516 }, {  11,   0 }, {  12, 258 },

 {  13, 516 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45, 563 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 },
 {   0,1895 }, {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 },

 {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 },
 {  10, 258 }, {  11,-258 }, {  12,   0 }, {  13, 258 }, {  14,-258 },
 {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 },
 {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 },
 {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 },
 {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 },
 {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 },
 {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 },
 {  45, 305 }, {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 },
 {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 },

 {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 },
 {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 },
 {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 },
 {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 },
 {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 },
 {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 },
 {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 },
 {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 },
 {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 },
 { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 },

 { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 },
 { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 },
 { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 },
 { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 },
 { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 },
 { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 },
 { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 },
 { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 },
 { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 },
 { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 },

 { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 },
 { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 },
 { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 },
 { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 },
 { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 },
 { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 },
 { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 },
 { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 },
 { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 },
 { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 },

 { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 },
 { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 },
 { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 },
 { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 },
 { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 },
 { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 },
 { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 },
 { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 },
 { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 },
 { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 },

 { 255,-258 }, { 256,-258 }, {   0,  18 }, {   0,1637 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,-4399 }, {  10,-4399 }, {   0,   0 },
 {  12,-4399 }, {  13,-4399 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,-4399 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-12014 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-12012 }, {   0,  18 },

 {   0,1590 }, {   1,-563 }, {   2,-563 }, {   3,-563 }, {   4,-563 },
 {   5,-563 }, {   6,-563 }, {   7,-563 }, {   8,-563 }, {   9,-305 },
 {  10, -47 }, {  11,-563 }, {  12,-305 }, {  13, -47 }, {  14,-563 },
 {  15,-563 }, {  16,-563 }, {  17,-563 }, {  18,-563 }, {  19,-563 },
 {  20,-563 }, {  21,-563 }, {  22,-563 }, {  23,-563 }, {  24,-563 },
 {  25,-563 }, {  26,-563 }, {  27,-563 }, {  28,-563 }, {  29,-563 },
 {  30,-563 }, {  31,-563 }, {  32,-305 }, {  33,-563 }, {  34,-563 },
 {  35,-563 }, {  36,-563 }, {  37,-563 }, {  38,-563 }, {  39,-563 },
 {  40,-563 }, {  41,-563 }, {  42,-563 }, {  43,-563 }, {  44,-563 },
 {  45, 704 }, {  46,-563 }, {  47,-563 }, {  48,-563 }, {  49,-563 },

 {  50,-563 }, {  51,-563 }, {  52,-563 }, {  53,-563 }, {  54,-563 },
 {  55,-563 }, {  56,-563 }, {  57,-563 }, {  58,-563 }, {  59,-563 },
 {  60,-563 }, {  61,-563 }, {  62,-563 }, {  63,-563 }, {  64,-563 },
 {  65,-563 }, {  66,-563 }, {  67,-563 }, {  68,-563 }, {  69,-563 },
 {  70,-563 }, {  71,-563 }, {  72,-563 }, {  73,-563 }, {  74,-563 },
 {  75,-563 }, {  76,-563 }, {  77,-563 }, {  78,-563 }, {  79,-563 },
 {  80,-563 }, {  81,-563 }, {  82,-563 }, {  83,-563 }, {  84,-563 },
 {  85,-563 }, {  86,-563 }, {  87,-563 }, {  88,-563 }, {  89,-563 },
 {  90,-563 }, {  91,-563 }, {  92,-563 }, {  93,-563 }, {  94,-563 },
 {  95,-563 }, {  96,-563 }, {  97,-563 }, {  98,-563 }, {  99,-563 },

 { 100,-563 }, { 101,-563 }, { 102,-563 }, { 103,-563 }, { 104,-563 },
 { 105,-563 }, { 106,-563 }, { 107,-563 }, { 108,-563 }, { 109,-563 },
 { 110,-563 }, { 111,-563 }, { 112,-563 }, { 113,-563 }, { 114,-563 },
 { 115,-563 }, { 116,-563 }, { 117,-563 }, { 118,-563 }, { 119,-563 },
 { 120,-563 }, { 121,-563 }, { 122,-563 }, { 123,-563 }, { 124,-563 },
 { 125,-563 }, { 126,-563 }, { 127,-563 }, { 128,-563 }, { 129,-563 },
 { 130,-563 }, { 131,-563 }, { 132,-563 }, { 133,-563 }, { 134,-563 },
 { 135,-563 }, { 136,-563 }, { 137,-563 }, { 138,-563 }, { 139,-563 },
 { 140,-563 }, { 141,-563 }, { 142,-563 }, { 143,-563 }, { 144,-563 },
 { 145,-563 }, { 146,-563 }, { 147,-563 }, { 148,-563 }, { 149,-563 },

 { 150,-563 }, { 151,-563 }, { 152,-563 }, { 153,-563 }, { 154,-563 },
 { 155,-563 }, { 156,-563 }, { 157,-563 }, { 158,-563 }, { 159,-563 },
 { 160,-563 }, { 161,-563 }, { 162,-563 }, { 163,-563 }, { 164,-563 },
 { 165,-563 }, { 166,-563 }, { 167,-563 }, { 168,-563 }, { 169,-563 },
 { 170,-563 }, { 171,-563 }, { 172,-563 }, { 173,-563 }, { 174,-563 },
 { 175,-563 }, { 176,-563 }, { 177,-563 }, { 178,-563 }, { 179,-563 },
 { 180,-563 }, { 181,-563 }, { 182,-563 }, { 183,-563 }, { 184,-563 },
 { 185,-563 }, { 186,-563 }, { 187,-563 }, { 188,-563 }, { 189,-563 },
 { 190,-563 }, { 191,-563 }, { 192,-563 }, { 193,-563 }, { 194,-563 },
 { 195,-563 }, { 196,-563 }, { 197,-563 }, { 198,-563 }, { 199,-563 },

 { 200,-563 }, { 201,-563 }, { 202,-563 }, { 203,-563 }, { 204,-563 },
 { 205,-563 }, { 206,-563 }, { 207,-563 }, { 208,-563 }, { 209,-563 },
 { 210,-563 }, { 211,-563 }, { 212,-563 }, { 213,-563 }, { 214,-563 },
 { 215,-563 }, { 216,-563 }, { 217,-563 }, { 218,-563 }, { 219,-563 },
 { 220,-563 }, { 221,-563 }, { 222,-563 }, { 223,-563 }, { 224,-563 },
 { 225,-563 }, { 226,-563 }, { 227,-563 }, { 228,-563 }, { 229,-563 },
 { 230,-563 }, { 231,-563 }, { 232,-563 }, { 233,-563 }, { 234,-563 },
 { 235,-563 }, { 236,-563 }, { 237,-563 }, { 238,-563 }, { 239,-563 },
 { 240,-563 }, { 241,-563 }, { 242,-563 }, { 243,-563 }, { 244,-563 },
 { 245,-563 }, { 246,-563 }, { 247,-563 }, { 248,-563 }, { 249,-563 },

 { 250,-563 }, { 251,-563 }, { 252,-563 }, { 253,-563 }, { 254,-563 },
 { 255,-563 }, { 256,-563 }, {   0,  18 }, {   0,1332 }, {   1,-2120 },
 {   2,-2120 }, {   3,-2120 }, {   4,-2120 }, {   5,-2120 }, {   6,-2120 },
 {   7,-2120 }, {   8,-2120 }, {   9,-1862 }, {  10,-4720 }, {  11,-2120 },
 {  12,-1862 }, {  13,-4720 }, {  14,-2120 }, {  15,-2120 }, {  16,-2120 },
 {  17,-2120 }, {  18,-2120 }, {  19,-2120 }, {  20,-2120 }, {  21,-2120 },
 {  22,-2120 }, {  23,-2120 }, {  24,-2120 }, {  25,-2120 }, {  26,-2120 },
 {  27,-2120 }, {  28,-2120 }, {  29,-2120 }, {  30,-2120 }, {  31,-2120 },
 {  32,-1862 }, {  33,-2120 }, {  34,-2120 }, {  35,-2120 }, {  36,-2120 },
 {  37,-2120 }, {  38,-2120 }, {  39,-2120 }, {  40,-2120 }, {  41,-2120 },

 {  42,-2120 }, {  43,-2120 }, {  44,-2120 }, {  45,   0 }, {  46,-2120 },
 {  47,-2120 }, {  48,-2120 }, {  49,-2120 }, {  50,-2120 }, {  51,-2120 },
 {  52,-2120 }, {  53,-2120 }, {  54,-2120 }, {  55,-2120 }, {  56,-2120 },
 {  57,-2120 }, {  58,-2120 }, {  59,-2120 }, {  60,-2120 }, {  61,-2120 },
 {  62,-2120 }, {  63,-2120 }, {  64,-2120 }, {  65,-2120 }, {  66,-2120 },
 {  67,-2120 }, {  68,-2120 }, {  69,-2120 }, {  70,-2120 }, {  71,-2120 },
 {  72,-2120 }, {  73,-2120 }, {  74,-2120 }, {  75,-2120 }, {  76,-2120 },
 {  77,-2120 }, {  78,-2120 }, {  79,-2120 }, {  80,-2120 }, {  81,-2120 },
 {  82,-2120 }, {  83,-2120 }, {  84,-2120 }, {  85,-2120 }, {  86,-2120 },
 {  87,-2120 }, {  88,-2120 }, {  89,-2120 }, {  90,-2120 }, {  91,-2120 },

 {  92,-2120 }, {  93,-2120 }, {  94,-2120 }, {  95,-2120 }, {  96,-2120 },
 {  97,-2120 }, {  98,-2120 }, {  99,-2120 }, { 100,-2120 }, { 101,-2120 },
 { 102,-2120 }, { 103,-2120 }, { 104,-2120 }, { 105,-2120 }, { 106,-2120 },
 { 107,-2120 }, { 108,-2120 }, { 109,-2120 }, { 110,-2120 }, { 111,-2120 },
 { 112,-2120 }, { 113,-2120 }, { 114,-2120 }, { 115,-2120 }, { 116,-2120 },
 { 117,-2120 }, { 118,-2120 }, { 119,-2120 }, { 120,-2120 }, { 121,-2120 },
 { 122,-2120 }, { 123,-2120 }, { 124,-2120 }, { 125,-2120 }, { 126,-2120 },
 { 127,-2120 }, { 128,-2120 }, { 129,-2120 }, { 130,-2120 }, { 131,-2120 },
 { 132,-2120 }, { 133,-2120 }, { 134,-2120 }, { 135,-2120 }, { 136,-2120 },
 { 137,-2120 }, { 138,-2120 }, { 139,-2120 }, { 140,-2120 }, { 141,-2120 },

 { 142,-2120 }, { 143,-2120 }, { 144,-2120 }, { 145,-2120 }, { 146,-2120 },
 { 147,-2120 }, { 148,-2120 }, { 149,-2120 }, { 150,-2120 }, { 151,-2120 },
 { 152,-2120 }, { 153,-2120 }, { 154,-2120 }, { 155,-2120 }, { 156,-2120 },
 { 157,-2120 }, { 158,-2120 }, { 159,-2120 }, { 160,-2120 }, { 161,-2120 },
 { 162,-2120 }, { 163,-2120 }, { 164,-2120 }, { 165,-2120 }, { 166,-2120 },
 { 167,-2120 }, { 168,-2120 }, { 169,-2120 }, { 170,-2120 }, { 171,-2120 },
 { 172,-2120 }, { 173,-2120 }, { 174,-2120 }, { 175,-2120 }, { 176,-2120 },
 { 177,-2120 }, { 178,-2120 }, { 179,-2120 }, { 180,-2120 }, { 181,-2120 },
 { 182,-2120 }, { 183,-2120 }, { 184,-2120 }, { 185,-2120 }, { 186,-2120 },
 { 187,-2120 }, { 188,-2120 }, { 189,-2120 }, { 190,-2120 }, { 191,-2120 },

 { 192,-2120 }, { 193,-2120 }, { 194,-2120 }, { 195,-2120 }, { 196,-2120 },
 { 197,-2120 }, { 198,-2120 }, { 199,-2120 }, { 200,-2120 }, { 201,-2120 },
 { 202,-2120 }, { 203,-2120 }, { 204,-2120 }, { 205,-2120 }, { 206,-2120 },
 { 207,-2120 }, { 208,-2120 }, { 209,-2120 }, { 210,-2120 }, { 211,-2120 },
 { 212,-2120 }, { 213,-2120 }, { 214,-2120 }, { 215,-2120 }, { 216,-2120 },
 { 217,-2120 }, { 218,-2120 }, { 219,-2120 }, { 220,-2120 }, { 221,-2120 },
 { 222,-2120 }, { 223,-2120 }, { 224,-2120 }, { 225,-2120 }, { 226,-2120 },
 { 227,-2120 }, { 228,-2120 }, { 229,-2120 }, { 230,-2120 }, { 231,-2120 },
 { 232,-2120 }, { 233,-2120 }, { 234,-2120 }, { 235,-2120 }, { 236,-2120 },
 { 237,-2120 }, { 238,-2120 }, { 239,-2120 }, { 240,-2120 }, { 241,-2120 },

 { 242,-2120 }, { 243,-2120 }, { 244,-2120 }, { 245,-2120 }, { 246,-2120 },
 { 247,-2120 }, { 248,-2120 }, { 249,-2120 }, { 250,-2120 }, { 251,-2120 },
 { 252,-2120 }, { 253,-2120 }, { 254,-2120 }, { 255,-2120 }, { 256,-2120 },
 {   0,  27 }, {   0,1074 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,1051 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48, 446 },
 {  49, 446 }, {  50, 446 }, {  51, 446 }, {  52, 446 }, {  53, 446 },
 {  54, 446 }, {  55, 446 }, {  56, 446 }, {  57, 446 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0,1013 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 446 }, {  66, 446 }, {  67, 446 }, {  68, 446 },
 {  69, 446 }, {  70, 446 }, {  48, 446 }, {  49, 446 }, {  50, 446 },
 {  51, 446 }, {  52, 446 }, {  53, 446 }, {  54, 446 }, {  55, 446 },
 {  56, 446 }, {  57, 446 }, {   0,   0 }, {   0,   0 }, {   0,  27 },

 {   0, 990 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 446 },
 {  66, 446 }, {  67, 446 }, {  68, 446 }, {  69, 446 }, {  70, 446 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 446 }, {  98, 446 },
 {  99, 446 }, { 100, 446 }, { 101, 446 }, { 102, 446 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 446 }, {  49, 446 }, {  50, 446 }, {  51, 446 }, {  52, 446 },
 {  53, 446 }, {  54, 446 }, {  55, 446 }, {  56, 446 }, {  57, 446 },
 {   0,   0 }, {  97, 446 }, {  98, 446 }, {  99, 446 }, { 100, 446 },
 { 101, 446 }, { 102, 446 }, {  65, 446 }, {  66, 446 }, {  67, 446 },
 {  68, 446 }, {  69, 446 }, {  70, 446 }, {  48, 446 }, {  49, 446 },

 {  50, 446 }, {  51, 446 }, {  52, 446 }, {  53, 446 }, {  54, 446 },
 {  55, 446 }, {  56, 446 }, {  57, 446 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 446 }, {  66, 446 }, {  67, 446 }, {  68, 446 }, {  69, 446 },
 {  70, 446 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 446 },
 {  98, 446 }, {  99, 446 }, { 100, 446 }, { 101, 446 }, { 102, 446 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97, 446 }, {  98, 446 }, {  99, 446 },

 { 100, 446 }, { 101, 446 }, { 102, 446 }, {   0,  18 }, {   0, 886 },
 {   1,-1267 }, {   2,-1267 }, {   3,-1267 }, {   4,-1267 }, {   5,-1267 },
 {   6,-1267 }, {   7,-1267 }, {   8,-1267 }, {   9,-1009 }, {  10,-751 },
 {  11,-1267 }, {  12,-1009 }, {  13,-751 }, {  14,-1267 }, {  15,-1267 },
 {  16,-1267 }, {  17,-1267 }, {  18,-1267 }, {  19,-1267 }, {  20,-1267 },
 {  21,-1267 }, {  22,-1267 }, {  23,-1267 }, {  24,-1267 }, {  25,-1267 },
 {  26,-1267 }, {  27,-1267 }, {  28,-1267 }, {  29,-1267 }, {  30,-1267 },
 {  31,-1267 }, {  32,-1009 }, {  33,-1267 }, {  34,-1267 }, {  35,-1267 },
 {  36,-1267 }, {  37,-1267 }, {  38,-1267 }, {  39,-1267 }, {  40,-1267 },
 {  41,-1267 }, {  42,-1267 }, {  43,-1267 }, {  44,-1267 }, {  45,   0 },

 {  46,-1267 }, {  47,-1267 }, {  48,-1267 }, {  49,-1267 }, {  50,-1267 },
 {  51,-1267 }, {  52,-1267 }, {  53,-1267 }, {  54,-1267 }, {  55,-1267 },
 {  56,-1267 }, {  57,-1267 }, {  58,-1267 }, {  59,-1267 }, {  60,-1267 },
 {  61,-1267 }, {  62,-1267 }, {  63,-1267 }, {  64,-1267 }, {  65,-1267 },
 {  66,-1267 }, {  67,-1267 }, {  68,-1267 }, {  69,-1267 }, {  70,-1267 },
 {  71,-1267 }, {  72,-1267 }, {  73,-1267 }, {  74,-1267 }, {  75,-1267 },
 {  76,-1267 }, {  77,-1267 }, {  78,-1267 }, {  79,-1267 }, {  80,-1267 },
 {  81,-1267 }, {  82,-1267 }, {  83,-1267 }, {  84,-1267 }, {  85,-1267 },
 {  86,-1267 }, {  87,-1267 }, {  88,-1267 }, {  89,-1267 }, {  90,-1267 },
 {  91,-1267 }, {  92,-1267 }, {  93,-1267 }, {  94,-1267 }, {  95,-1267 },

 {  96,-1267 }, {  97,-1267 }, {  98,-1267 }, {  99,-1267 }, { 100,-1267 },
 { 101,-1267 }, { 102,-1267 }, { 103,-1267 }, { 104,-1267 }, { 105,-1267 },
 { 106,-1267 }, { 107,-1267 }, { 108,-1267 }, { 109,-1267 }, { 110,-1267 },
 { 111,-1267 }, { 112,-1267 }, { 113,-1267 }, { 114,-1267 }, { 115,-1267 },
 { 116,-1267 }, { 117,-1267 }, { 118,-1267 }, { 119,-1267 }, { 120,-1267 },
 { 121,-1267 }, { 122,-1267 }, { 123,-1267 }, { 124,-1267 }, { 125,-1267 },
 { 126,-1267 }, { 127,-1267 }, { 128,-1267 }, { 129,-1267 }, { 130,-1267 },
 { 131,-1267 }, { 132,-1267 }, { 133,-1267 }, { 134,-1267 }, { 135,-1267 },
 { 136,-1267 }, { 137,-1267 }, { 138,-1267 }, { 139,-1267 }, { 140,-1267 },
 { 141,-1267 }, { 142,-1267 }, { 143,-1267 }, { 144,-1267 }, { 145,-1267 },

 { 146,-1267 }, { 147,-1267 }, { 148,-1267 }, { 149,-1267 }, { 150,-1267 },
 { 151,-1267 }, { 152,-1267 }, { 153,-1267 }, { 154,-1267 }, { 155,-1267 },
 { 156,-1267 }, { 157,-1267 }, { 158,-1267 }, { 159,-1267 }, { 160,-1267 },
 { 161,-1267 }, { 162,-1267 }, { 163,-1267 }, { 164,-1267 }, { 165,-1267 },
 { 166,-1267 }, { 167,-1267 }, { 168,-1267 }, { 169,-1267 }, { 170,-1267 },
 { 171,-1267 }, { 172,-1267 }, { 173,-1267 }, { 174,-1267 }, { 175,-1267 },
 { 176,-1267 }, { 177,-1267 }, { 178,-1267 }, { 179,-1267 }, { 180,-1267 },
 { 181,-1267 }, { 182,-1267 }, { 183,-1267 }, { 184,-1267 }, { 185,-1267 },
 { 186,-1267 }, { 187,-1267 }, { 188,-1267 }, { 189,-1267 }, { 190,-1267 },
 { 191,-1267 }, { 192,-1267 }, { 193,-1267 }, { 194,-1267 }, { 195,-1267 },

 { 196,-1267 }, { 197,-1267 }, { 198,-1267 }, { 199,-1267 }, { 200,-1267 },
 { 201,-1267 }, { 202,-1267 }, { 203,-1267 }, { 204,-1267 }, { 205,-1267 },
 { 206,-1267 }, { 207,-1267 }, { 208,-1267 }, { 209,-1267 }, { 210,-1267 },
 { 211,-1267 }, { 212,-1267 }, { 213,-1267 }, { 214,-1267 }, { 215,-1267 },
 { 216,-1267 }, { 217,-1267 }, { 218,-1267 }, { 219,-1267 }, { 220,-1267 },
 { 221,-1267 }, { 222,-1267 }, { 223,-1267 }, { 224,-1267 }, { 225,-1267 },
 { 226,-1267 }, { 227,-1267 }, { 228,-1267 }, { 229,-1267 }, { 230,-1267 },
 { 231,-1267 }, { 232,-1267 }, { 233,-1267 }, { 234,-1267 }, { 235,-1267 },
 { 236,-1267 }, { 237,-1267 }, { 238,-1267 }, { 239,-1267 }, { 240,-1267 },
 { 241,-1267 }, { 242,-1267 }, { 243,-1267 }, { 244,-1267 }, { 245,-1267 },

 { 246,-1267 }, { 247,-1267 }, { 248,-1267 }, { 249,-1267 }, { 250,-1267 },
 { 251,-1267 }, { 252,-1267 }, { 253,-1267 }, { 254,-1267 }, { 255,-1267 },
 { 256,-1267 }, {   0,  27 }, {   0, 628 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0, 605 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 }, {  52, 143 },
 {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 }, {  57, 143 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 567 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 143 }, {  66, 143 }, {  67, 143 },
 {  68, 143 }, {  69, 143 }, {  70, 143 }, {  48,-12977 }, {  49,-12977 },
 {  50,-12977 }, {  51,-12977 }, {  52,-12977 }, {  53,-12977 }, {  54,-12977 },
 {  55,-12977 }, {  56,-12977 }, {  57,-12977 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0, 544 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,-12977 }, {  66,-12977 }, {  67,-12977 }, {  68,-12977 }, {  69,-12977 },
 {  70,-12977 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 143 },
 {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 }, { 102, 143 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 105 }, {  49, 105 }, {  50, 105 }, {  51, 105 },
 {  52, 105 }, {  53, 105 }, {  54, 105 }, {  55, 105 }, {  56, 105 },
 {  57, 105 }, {   0,   0 }, {  97,-12977 }, {  98,-12977 }, {  99,-12977 },
 { 100,-12977 }, { 101,-12977 }, { 102,-12977 }, {  65, 105 }, {  66, 105 },
 {  67, 105 }, {  68, 105 }, {  69, 105 }, {  70, 105 }, {  48,-13036 },
 {  49,-13036 }, {  50,-13036 }, {  51,-13036 }, {  52,-13036 }, {  53,-13036 },

 {  54,-13036 }, {  55,-13036 }, {  56,-13036 }, {  57,-13036 }, {   0,  27 },
 {   0, 485 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-13036 }, {  66,-13036 }, {  67,-13036 }, {  68,-13036 },
 {  69,-13036 }, {  70,-13036 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97, 105 }, {  98, 105 }, {  99, 105 }, { 100, 105 }, { 101, 105 },
 { 102, 105 }, {   0,   0 }, {   0,  27 }, {   0, 462 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-13036 }, {  98,-13036 },
 {  99,-13036 }, { 100,-13036 }, { 101,-13036 }, { 102,-13036 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  61 }, {  49,  61 },
 {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 },
 {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0, 424 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 },
 {  70,  61 }, {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 },
 {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 },
 {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 401 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 },
 {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 },
 { 100,  61 }, { 101,  61 }, { 102,  61 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  82 },
 {  49,  82 }, {  50,  82 }, {  51,  82 }, {  52,  82 }, {  53,  82 },
 {  54,  82 }, {  55,  82 }, {  56,  82 }, {  57,  82 }, {   0,   0 },
 {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 },
 { 102,  61 }, {  65,  82 }, {  66,  82 }, {  67,  82 }, {  68,  82 },
 {  69,  82 }, {  70,  82 }, {  48,  82 }, {  49,  82 }, {  50,  82 },
 {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 },
 {  56,  82 }, {  57,  82 }, {   0,  27 }, {   0, 342 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  82 },
 {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  82 }, {  98,  82 },
 {  99,  82 }, { 100,  82 }, { 101,  82 }, { 102,  82 }, {   0,   0 },
 {   0,  27 }, {   0, 319 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 },
 { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 },

 {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 },
 {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 281 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 },
 {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 }, {  48,  61 },
 {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 },
 {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0, 258 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 },
 {  69,  61 }, {  70,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 },

 { 102,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-13301 }, {  49,-13301 }, {  50,-13301 },
 {  51,-13301 }, {  52,-13301 }, {  53,-13301 }, {  54,-13301 }, {  55,-13301 },
 {  56,-13301 }, {  57,-13301 }, {   0,   0 }, {  97,  61 }, {  98,  61 },
 {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 }, {  65,-13301 },
 {  66,-13301 }, {  67,-13301 }, {  68,-13301 }, {  69,-13301 }, {  70,-13301 },
 {  48,-13322 }, {  49,-13322 }, {  50,-13322 }, {  51,-13322 }, {  52,-13322 },
 {  53,-13322 }, {  54,-13322 }, {  55,-13322 }, {  56,-13322 }, {  57,-13322 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-13322 }, {  66,-13322 }, {  67,-13322 },

 {  68,-13322 }, {  69,-13322 }, {  70,-13322 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,-13301 }, {  98,-13301 }, {  99,-13301 }, { 100,-13301 },
 { 101,-13301 }, { 102,-13301 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-13322 },
 {  98,-13322 }, {  99,-13322 }, { 100,-13322 }, { 101,-13322 }, { 102,-13322 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 257,  65 },
 {   1,   0 },    };

static const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 46 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;
bool		escape_string_warning = true;
bool		standard_conforming_strings = true;

/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 5220 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal numeric string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal number */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/* we no longer allow unary minus in numbers.
 * instead we pass it separately to parser. there it gets
 * coerced via doNegate() -- Leon aug 20 1999
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail1} and {realfail2} are added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 5368 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 416 "scan.l"


#line 5664 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 418 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 422 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 3:
YY_RULE_SETUP
#line 432 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 438 "scan.l"
{
					if (yyextra->xcdepth <= 0)
						BEGIN(INITIAL);
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 445 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 449 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 453 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 457 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 8:
YY_RULE_SETUP
#line 462 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 9:
/* rule 9 can match eol */
#line 475 "scan.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 475 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 478 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 480 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 492 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 494 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						return IDENT;
					}
				}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 520 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 530 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 537 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when standard_conforming_strings is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 549 "scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 561 "scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
#line 570 "scan.l"
case 19:
/* rule 19 can match eol */
#line 571 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 571 "scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 608 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 611 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 614 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 617 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 645 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 25:
#line 666 "scan.l"
case 26:
/* rule 26 can match eol */
#line 667 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 667 "scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 672 "scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 681 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 697 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 705 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 713 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 717 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 719 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 725 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 732 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 752 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 755 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 758 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 762 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 764 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 769 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 774 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 786 "scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					return UIDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 794 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 797 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 800 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 802 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 814 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 819 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 824 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 829 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 834 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 839 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 844 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 850 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 856 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 861 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 969 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 975 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 979 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 984 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 990 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 995 "scan.l"
{
					/*
					 * throw back the [Ee], and figure out whether what
					 * remains is an {integer} or {decimal}.
					 */
					yyless(yyleng - 1);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1004 "scan.l"
{
					/* throw back the [Ee][+-], and proceed as above */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval);
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1012 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1037 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1042 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1047 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 6584 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

YYLTYPE *yyget_lloc  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylloc;
}
    
void yyset_lloc (YYLTYPE *  yylloc_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylloc = yylloc_param;
}
    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1047 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = (void *) scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		do
		{
			yyextra->literalalloc *= 2;
		} while ((yyextra->literallen + yleng) >= yyextra->literalalloc);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}

void
core_yyfree(void *ptr, core_yyscan_t yyscanner)
{
	if (ptr)
		pfree(ptr);
}

