/*
 * Unix SMB/CIFS implementation.
 * Copyright (C) Volker Lendecke 2018
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBSMB_DSGETDCNAME_H__
#define __LIBSMB_DSGETDCNAME_H__

#include "replace.h"
#include <talloc.h>
#include "librpc/gen_ndr/misc.h"

struct netr_DsRGetDCNameInfo;
struct messaging_context;

NTSTATUS dsgetdcname(TALLOC_CTX *mem_ctx,
		     struct messaging_context *msg_ctx,
		     const char *domain_name,
		     const struct GUID *domain_guid,
		     const char *site_name,
		     uint32_t flags,
		     struct netr_DsRGetDCNameInfo **info);

NTSTATUS dsgetonedcname(TALLOC_CTX *mem_ctx,
			struct messaging_context *msg_ctx,
			const char *domain_name,
			const char *dcname,
			uint32_t flags,
			struct netr_DsRGetDCNameInfo **info);
#endif
