/*
 * Copyright (c) 1997-2004 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Portions Copyright (c) 2009 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "krb5_locl.h"

KRB5_LIB_VARIABLE const char *const krb5_config_file =
#ifdef KRB5_DEFAULT_CONFIG_FILE
KRB5_DEFAULT_CONFIG_FILE
#else
#ifdef __APPLE__
"~/Library/Preferences/com.apple.Kerberos.plist" PATH_SEP
"/Library/Preferences/com.apple.Kerberos.plist" PATH_SEP
"~/Library/Preferences/edu.mit.Kerberos" PATH_SEP
"/Library/Preferences/edu.mit.Kerberos" PATH_SEP
#endif	/* __APPLE__ */
"~/.krb5/config" PATH_SEP
SYSCONFDIR "/krb5.conf" PATH_SEP
#ifdef _WIN32
"%{COMMON_APPDATA}/Kerberos/krb5.conf" PATH_SEP
"%{WINDOWS}/krb5.ini"
#else /* _WIN32 */
"/etc/krb5.conf"
#endif /* _WIN32 */
#endif /* KRB5_DEFAULT_CONFIG_FILE */
;

KRB5_LIB_VARIABLE const char *const krb5_defkeyname = KEYTAB_DEFAULT;

KRB5_LIB_VARIABLE const char *const krb5_cc_type_api = "API";
KRB5_LIB_VARIABLE const char *const krb5_cc_type_file = "FILE";
KRB5_LIB_VARIABLE const char *const krb5_cc_type_memory = "MEMORY";
KRB5_LIB_VARIABLE const char *const krb5_cc_type_kcm = "KCM";
KRB5_LIB_VARIABLE const char *const krb5_cc_type_scc = "SCC";
KRB5_LIB_VARIABLE const char *const krb5_cc_type_dcc = "DIR";
KRB5_LIB_VARIABLE const char *const krb5_cc_type_keyring = "KEYRING";
