/* $Id: transcript.h 224642 2021-08-25 22:03:29Z twu $ */
#ifndef TRANSCRIPT_INCLUDED
#define TRANSCRIPT_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "filestring.h"
#include "list.h"
#include "intlist.h"
#include "bool.h"
#include "genomicpos.h"
#include "iit-read-univ.h"
#include "outputtype.h"
#include "transcriptome.h"
#include "listpool.h"
#include "bitvector.h"


/* Ordered for preference in choosing among hitpairs, but order for accept_velocity is different */
typedef enum {V_CRYPTIC, V_RETAINED, V_UTR, V_AMBIGUOUS, V_SPLICED} Transcript_velocity_T;

#define T Transcript_T
typedef struct T *T;

extern int Transcript_num (T this);
extern int Transcript_start (T this);
extern int Transcript_end (T this);
extern int Transcript_length (T this);
extern int Transcript_genestrand (T this);
extern Transcript_velocity_T Transcript_velocity (T this);

extern void
Transcript_setup (int pairmax_transcriptome_in, int expected_pairlength_in,
		  Outputtype_T output_type_in, Transcriptome_T transcriptome_in,
		  Univ_IIT_T transcript_iit_in);

extern void
Transcript_free (T *old);
extern void
Transcript_gc (List_T *list);
extern T
Transcript_new_need_exons (int num, int transcript_genestrand, int nexons,
			    int trstart, int trend, int trlength,
			    int trim_low, int trim_high, Listpool_T listpool);
extern T
Transcript_new_with_exons (int num, int transcript_genestrand, int nexons,
			    int trstart, int trend, int trlength,
			    int querystart, int queryend, int querylength,
			    List_T exons, Bitvector_T cryptic_introns,
			    Bitvector_T retained_introns, Bitvector_T spliced_introns,
			    bool utr5p, bool utr3p);

extern T
Transcript_copy (T old, Listpool_T listpool);
extern List_T
Transcript_copy_list (List_T old, Listpool_T listpool);
extern bool
Transcript_trim (T this, int trim_low_adj, int trim_high_adj, Listpool_T listpool);

extern bool
Transcript_extend_utr5p (List_T transcripts);
extern bool
Transcript_extend_utr3p (List_T transcripts);

extern bool
Transcript_in_list_p (T x, List_T list);
extern void
Transcript_print_nums (List_T list);
extern void
Transcript_print_list_debug (List_T list);

extern bool
Transcript_concordant_p (List_T transcripts5, List_T transcripts3);

extern List_T
Transcript_singleend_inconsistent (List_T transcripts, Listpool_T listpool, bool consistent_found_p);
extern List_T
Transcript_concordant_consistent (List_T transcripts5, List_T transcripts3,
				  int querylength5, int querylength3,
				  Listpool_T listpool, bool plusp, bool first_read_p);
extern List_T
Transcript_concordant_inconsistent (List_T transcripts5_spliced, List_T transcripts5_unspliced,
				    List_T transcripts3_spliced, List_T transcripts3_unspliced,
				    int querylength5, int querylength3, int pairedlength,
				    Listpool_T listpool, bool plusp, bool first_read_p,
				    bool consistent_found_p);

extern void
Transcript_print_list (Filestring_T fp, List_T transcripts,
		       Univ_IIT_T transcript_iit, char *header);
extern void
Transcript_dump_list_stdout (List_T transcripts);

#undef T
#endif

