/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.regex.Pattern;
import org.broad.tribble.AbstractFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.util.ParsingUtils;

public abstract class AsciiFeatureCodec<T extends Feature>
extends AbstractFeatureCodec<T> {
    private final AsciiLineReader lineReader = new AsciiLineReader();
    protected Pattern splitPattern = Pattern.compile("\\t");

    protected AsciiFeatureCodec(Class<T> myClass) {
        super(myClass);
    }

    @Override
    public Feature decodeLoc(PositionalBufferedStream stream) throws IOException {
        String line = this.readLine(stream);
        try {
            return this.decodeLoc(line);
        }
        catch (RuntimeException e) {
            String msg = "\nLine: " + line;
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public T decode(PositionalBufferedStream stream) throws IOException {
        String line = this.readLine(stream);
        try {
            return this.decode(line);
        }
        catch (RuntimeException e) {
            String msg = "\nLine: " + line;
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream stream) throws IOException {
        AsciiLineReader br = new AsciiLineReader(stream);
        return new FeatureCodecHeader(this.readHeader(br), 0L);
    }

    private final String readLine(PositionalBufferedStream stream) throws IOException {
        return this.lineReader.readLine(stream);
    }

    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public T decode(String[] tokens) {
        String line = ParsingUtils.join("\t", tokens);
        return this.decode(line);
    }

    public abstract T decode(String var1);

    public Object readHeader(LineReader reader) {
        return null;
    }
}

