/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayAssert
extends ArrayAssert<long[]> {
    protected LongArrayAssert(long ... actual) {
        super(actual);
    }

    public LongArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public LongArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public LongArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    public LongArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public LongArrayAssert contains(long ... values) {
        this.isNotNull();
        this.validateIsNotNull(values);
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public LongArrayAssert containsOnly(long ... values) {
        this.isNotNull();
        this.validateIsNotNull(values);
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public LongArrayAssert excludes(long ... values) {
        this.isNotNull();
        this.validateIsNotNull(values);
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    private void validateIsNotNull(long[] values) {
        if (values == null) {
            throw new NullPointerException(this.formattedErrorMessage("the given array of longs should not be null"));
        }
    }

    public LongArrayAssert satisfies(Condition<long[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public LongArrayAssert doesNotSatisfy(Condition<long[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public LongArrayAssert is(Condition<long[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public LongArrayAssert isNot(Condition<long[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public LongArrayAssert isNotNull() {
        this.assertThatActualIsNotNull();
        return this;
    }

    public LongArrayAssert isNotEmpty() {
        this.assertThatActualIsNotEmpty();
        return this;
    }

    public LongArrayAssert isEqualTo(long[] expected) {
        if (Arrays.equals((long[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public LongArrayAssert isNotEqualTo(long[] array) {
        if (!Arrays.equals((long[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public LongArrayAssert hasSize(int expected) {
        this.assertThatActualHasSize(expected);
        return this;
    }

    public LongArrayAssert isSameAs(long[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public LongArrayAssert isNotSameAs(long[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    public LongArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

