/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeChildOfPathCountQuery;
import org.fest.swing.timing.Condition;
import org.fest.util.Strings;

class JTreeChildrenShowUpCondition
extends Condition {
    private JTree tree;
    private TreePath path;

    static JTreeChildrenShowUpCondition untilChildrenShowUp(JTree tree, TreePath path) {
        return new JTreeChildrenShowUpCondition(tree, path);
    }

    private JTreeChildrenShowUpCondition(JTree tree, TreePath path) {
        super(Strings.concat((Object[])new Object[]{path.toString(), " to show"}));
        this.tree = tree;
        this.path = path;
    }

    @RunsInEDT
    public boolean test() {
        return JTreeChildOfPathCountQuery.childCount(this.tree, this.path) != 0;
    }

    protected void done() {
        this.tree = null;
        this.path = null;
    }
}

