/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JSpinnerDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSpinnerFixture
extends ComponentFixture<JSpinner>
implements CommonComponentFixture,
JComponentFixture,
JPopupMenuInvokerFixture {
    private JSpinnerDriver driver;

    public JSpinnerFixture(Robot robot, String spinnerName) {
        super(robot, spinnerName, JSpinner.class);
        this.createDriver();
    }

    public JSpinnerFixture(Robot robot, JSpinner target) {
        super(robot, target);
        this.createDriver();
    }

    private void createDriver() {
        this.driver(new JSpinnerDriver(this.robot));
    }

    protected final void driver(JSpinnerDriver newDriver) {
        JSpinnerFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    public JSpinnerFixture increment(int times) {
        this.driver.increment((JSpinner)this.target, times);
        return this;
    }

    public JSpinnerFixture increment() {
        this.driver.increment((JSpinner)this.target);
        return this;
    }

    public JSpinnerFixture decrement(int times) {
        this.driver.decrement((JSpinner)this.target, times);
        return this;
    }

    public JSpinnerFixture decrement() {
        this.driver.decrement((JSpinner)this.target);
        return this;
    }

    public JSpinnerFixture enterText(String text) {
        this.driver.enterText((JSpinner)this.target, text);
        return this;
    }

    public JSpinnerFixture enterTextAndCommit(String text) {
        this.driver.enterTextAndCommit((JSpinner)this.target, text);
        return this;
    }

    public Object select(Object value) {
        this.driver.selectValue((JSpinner)this.target, value);
        return this;
    }

    @Override
    public JSpinnerFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JSpinnerFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JSpinnerFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JSpinnerFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JSpinnerFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JSpinnerFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JSpinnerFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JSpinnerFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JSpinnerFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    public JSpinnerFixture requireValue(Object value) {
        this.driver.requireValue((JSpinner)this.target, value);
        return this;
    }

    public String text() {
        return this.driver.textOf((JSpinner)this.target);
    }

    @Override
    public JSpinnerFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JSpinnerFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }
}

