/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.regex.Pattern;
import org.fest.swing.util.Patterns;
import org.fest.swing.util.Strings;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;

public class PatternTextMatcher
implements TextMatcher {
    private final Pattern[] patterns;

    public PatternTextMatcher(Pattern ... patterns) {
        if (patterns == null) {
            throw new NullPointerException("The array of patterns should not be null");
        }
        if (Arrays.isEmpty((Object[])patterns)) {
            throw new IllegalArgumentException("The array of patterns should not be empty");
        }
        this.patterns = patterns;
    }

    public boolean isMatching(String text) {
        for (Pattern pattern : this.patterns) {
            if (!Strings.match(pattern, text)) continue;
            return true;
        }
        return false;
    }

    public String description() {
        if (this.onlyOnePattern()) {
            return "pattern";
        }
        return "patterns";
    }

    public String formattedValues() {
        if (this.onlyOnePattern()) {
            return org.fest.util.Strings.quote((String)this.patterns[0].pattern());
        }
        return Patterns.format(this.patterns);
    }

    private boolean onlyOnePattern() {
        return this.patterns.length == 1;
    }
}

