#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Tuesday 15 February 2011 10:24:37 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/CADD/workflows/visualization/VSResults_0.1_pmvnet.py,v 1.1 2011/04/15 16:21:41 nadya Exp $
#
# $Id: VSResults_0.1_pmvnet.py,v 1.1 2011/04/15 16:21:41 nadya Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node GetReceptors ##
    from Vision.StandardNodes import Generic
    GetReceptors_0 = Generic(constrkw={}, name='GetReceptors', library=stdlib)
    masterNet.addNode(GetReceptors_0,12,104)
    apply(GetReceptors_0.addInputPort, (), {'singleConnection': True, 'name': 'directory', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetReceptors_0.addOutputPort, (), {'name': 'filelist', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    apply(GetReceptors_0.addOutputPort, (), {'name': 'filelist_paths', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    code = """def doit(self, directory):
    import glob, os
    match_str = "*"
    if directory is not None:
        cwd = os.getcwd()
        os.chdir(directory)
    try:
        pdirs = glob.glob(match_str)
        values = []

        for i in pdirs:
            if os.path.exists(i + os.sep + '''summarize_results.txt'''):
                values.append(i)
            
        filenames = [ os.path.join(directory, x) for x in values ]
        self.outputData(filelist=values, filelist_paths=filenames)
    finally:
        if directory is not None:
            os.chdir(cwd)































## to ouput data on port filelist_paths use
## self.outputData(filelist_paths=data)



















"""
    GetReceptors_0.configure(function=code)
    apply(GetReceptors_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named GetReceptors in network masterNet"
    print_exc()
    GetReceptors_0=None

try:
    ## saving node ReceptorList ##
    from Vision.StandardNodes import ScrolledListNE
    ReceptorList_1 = ScrolledListNE(constrkw={}, name='ReceptorList', library=stdlib)
    masterNet.addNode(ReceptorList_1,13,163)
    apply(ReceptorList_1.inputPortByName['selection'].widget.configure, (), {'choices': ['2HTY_A', '2HU4_B']})
    ReceptorList_1.inputPortByName['selection'].widget.set(r"", run=False)
    code = """def doit(self, valueList, nameList, selection):
    widget = self.inputPorts[2].widget

    # do we run the first time, and have been restored from a network? (then
    # we have both valueList and selection specified)

    if self.inputPorts[0].hasNewValidData():
        selection = None
    
    if valueList and selection and self.firstRun is True:
        self.firstRun = False
        self.objectList = valueList
        self.nameList = nameList
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)
        return

    # only rebuild widget if we receive a new valueList
    if self.inputPorts[0].hasNewValidData() or self.inputPorts[1].hasNewValidData():
        if valueList != self.objectList or self.nameList != nameList:
            self.objectList = valueList
            self.nameList = nameList
            if nameList:
                vList = nameList
            else:
                vList = []
                for data in valueList:
                    if type(data) == types.StringType:
                        vList.append(data)
                    else:
                        vList.append(repr(data))
            if widget is not None:
                widget.setlist(vList)
                widget.configure(choices=vList)
                widget.widget.setentry('''''')
            return

    if selection:
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)

"""
    ReceptorList_1.configure(function=code)
    apply(ReceptorList_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ScrolledListNE named ReceptorList in network masterNet"
    print_exc()
    ReceptorList_1=None

try:
    ## saving node GetLigands ##
    from Vision.StandardNodes import Generic
    GetLigands_2 = Generic(constrkw={}, name='GetLigands', library=stdlib)
    masterNet.addNode(GetLigands_2,245,106)
    apply(GetLigands_2.addInputPort, (), {'singleConnection': True, 'name': 'receptor', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetLigands_2.addInputPort, (), {'singleConnection': True, 'name': 'receptorlist', 'cast': True, 'datatype': 'list', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan', 'originalDatatype': 'None'})
    apply(GetLigands_2.addOutputPort, (), {'name': 'ligandlist', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    apply(GetLigands_2.addOutputPort, (), {'name': 'ligandlist_paths', 'datatype': 'list', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
    apply(GetLigands_2.addOutputPort, (), {'name': 'liganddir', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, receptor, receptorlist):
        ligandlist = []
        ligandlist_paths = []
        
        for i in receptorlist:
            if os.path.basename(i) == receptor:
                liganddir = i
                break

        lf = liganddir + os.sep + '''summarize_results.txt'''

        f = open(lf)
        f.readline()

        for i in f.readlines():
            ligand = os.path.basename(str(i).split(''',''')[0])
            ligandlist.append(ligand)
            ligandlist_paths.append(liganddir + os.sep + ligand)
        
        f.close()
            
	pass
## to ouput data on port ligandlist use
        self.outputData(ligandlist=ligandlist, ligandlist_paths=ligandlist_paths, liganddir=liganddir)
## to ouput data on port ligandlist_paths use
## self.outputData(ligandlist_paths=data)
## to ouput data on port liganddir use
## self.outputData(liganddir=data)




















"""
    GetLigands_2.configure(function=code)
    apply(GetLigands_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named GetLigands in network masterNet"
    print_exc()
    GetLigands_2=None

try:
    ## saving node LoadMolecule5 ##
    from NetworkEditor.macros import MacroNode
    LoadMolecule5_3 = MacroNode(name='LoadMolecule5')
    masterNet.addNode(LoadMolecule5_3, 451, 480)
    output_Ports_5 = LoadMolecule5_3.macroNetwork.opNode
    apply(output_Ports_5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_5.move(235, 451)
    from Vision.StandardNodes import Eval
    abs_path_6 = Eval(constrkw={}, name='abs_path', library=stdlib)
    LoadMolecule5_3.macroNetwork.addNode(abs_path_6,260,76)
    apply(abs_path_6.inputPortByName['in1'].configure, (), {'datatype': 'string', 'defaultValue': None, 'required': True, 'originalDatatype': 'None'})
    apply(abs_path_6.outputPortByName['result'].configure, (), {'datatype': 'string'})
    abs_path_6.inputPortByName['command'].widget.set(r"os.path.abspath(in1)", run=False)
    abs_path_6.inputPortByName['importString'].widget.set(r"", run=False)
    apply(abs_path_6.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Vision.StandardNodes import Generic
    FindMolPath_7 = Generic(constrkw={}, name='FindMolPath', library=stdlib)
    LoadMolecule5_3.macroNetwork.addNode(FindMolPath_7,217,149)
    apply(FindMolPath_7.addInputPort, (), {'singleConnection': True, 'name': 'molname', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(FindMolPath_7.addInputPort, (), {'singleConnection': True, 'name': 'directory', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(FindMolPath_7.addOutputPort, (), {'name': 'molpath', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    code = """def doit(self, molname, directory):
        for d in os.listdir(directory):
            da = os.path.join(directory, d)
            if os.path.isdir(da):
                pdbqt = da + os.sep + molname + '''.pdbqt'''
                pdb = da + os.sep + molname + '''.pdb'''
        
                if os.path.exists(pdbqt):
                    self.outputData(molpath=pdbqt)
                elif os.path.exists(pdb):
                    self.outputData(molpath=pdb)
                else:
                    self.outputData(molpath="")
## to ouput data on port molpath use
#        self.outputData(molpath="")































"""
    FindMolPath_7.configure(function=code)
    apply(FindMolPath_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_8 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    LoadMolecule5_3.macroNetwork.addNode(Pmv_8,101,189)
    Pmv_8.inputPortByName['cmdName'].widget.set(r"readMolecule", run=False)
    Pmv_8.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    readMolecule_9 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.readMolecule, namedArgs={'parser': None}, posArgsNames=['filename'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.readMolecule', 'namedArgs': {'parser': None}, 'posArgsNames': ['filename']}, name='readMolecule', library=pmvlib)
    LoadMolecule5_3.macroNetwork.addNode(readMolecule_9,199,248)
    apply(readMolecule_9.inputPortByName['filename'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(readMolecule_9.inputPortByName['parser'].configure, (), {'defaultValue': None})
    apply(readMolecule_9.configure, (), {'specialPortsVisible': True})
    readMolecule_9.inputPortByName['importString'].widget.set(r"", run=False)
    apply(readMolecule_9.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_10 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    LoadMolecule5_3.macroNetwork.addNode(Pmv_10,101,293)
    Pmv_10.inputPortByName['cmdName'].widget.set(r"computeMSMS", run=False)
    Pmv_10.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    computeMSMS_11 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'noHetatm': False, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': {'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'noHetatm': False, 'display': True, 'pRadius': 1.5}, 'posArgsNames': ['nodes']}, name='computeMSMS', library=pmvlib)
    LoadMolecule5_3.macroNetwork.addNode(computeMSMS_11,200,352)
    apply(computeMSMS_11.inputPortByName['nodes'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(computeMSMS_11.inputPortByName['hdensity'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.inputPortByName['hdset'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.inputPortByName['surfName'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.inputPortByName['density'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.inputPortByName['perMol'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.inputPortByName['display'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.inputPortByName['pRadius'].configure, (), {'defaultValue': None})
    apply(computeMSMS_11.configure, (), {'specialPortsVisible': True})
    computeMSMS_11.inputPortByName['importString'].widget.set(r"", run=False)
    computeMSMS_11.inputPortByName['hdensity'].widget.set(6.0, run=False)
    computeMSMS_11.inputPortByName['hdset'].widget.set(r"None", run=False)
    computeMSMS_11.inputPortByName['surfName'].widget.set(r"MSMS-MOL", run=False)
    computeMSMS_11.inputPortByName['density'].widget.set(3.0, run=False)
    computeMSMS_11.inputPortByName['perMol'].widget.set(1, run=False)
    computeMSMS_11.inputPortByName['noHetatm'].widget.set(0, run=False)
    computeMSMS_11.inputPortByName['display'].widget.set(1, run=False)
    computeMSMS_11.inputPortByName['pRadius'].widget.set(1.5, run=False)
    apply(computeMSMS_11.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    deleteAllMolecules_12 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.deleteAllMolecules, constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.deleteAllMolecules'}, name='deleteAllMolecules', library=pmvlib)
    LoadMolecule5_3.macroNetwork.addNode(deleteAllMolecules_12,358,153)
    apply(deleteAllMolecules_12.configure, (), {'specialPortsVisible': True})
    deleteAllMolecules_12.inputPortByName['importString'].widget.set(r"", run=False)
    apply(deleteAllMolecules_12.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_13 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    LoadMolecule5_3.macroNetwork.addNode(Pmv_13,387,60)
    Pmv_13.inputPortByName['cmdName'].widget.set(r"deleteAllMolecules", run=False)
    Pmv_13.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_13.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network LoadMolecule5 ##
    LoadMolecule5_3.macroNetwork.freeze()
    input_Ports_4 = LoadMolecule5_3.macroNetwork.ipNode
    if input_Ports_4 is not None and FindMolPath_7 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                input_Ports_4, FindMolPath_7, "new", "molname", blocking=True
                , splitratio=[0.67694924181626903, 0.22784911266549582])
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and FindMolPath_7 in network LoadMolecule5_3.macroNetwork"
    if input_Ports_4 is not None and abs_path_6 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                input_Ports_4, abs_path_6, "new", "in1", blocking=True
                , splitratio=[0.74684717272792378, 0.70618943139915813])
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and abs_path_6 in network LoadMolecule5_3.macroNetwork"
    if abs_path_6 is not None and FindMolPath_7 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                abs_path_6, FindMolPath_7, "result", "directory", blocking=True
                , splitratio=[0.74896498645804965, 0.31322600506795284])
        except:
            print "WARNING: failed to restore connection between abs_path_6 and FindMolPath_7 in network LoadMolecule5_3.macroNetwork"
    if Pmv_8 is not None and readMolecule_9 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                Pmv_8, readMolecule_9, "cmd", "command", blocking=True
                , splitratio=[0.20198223086616679, 0.29898362394376937])
        except:
            print "WARNING: failed to restore connection between Pmv_8 and readMolecule_9 in network LoadMolecule5_3.macroNetwork"
    if FindMolPath_7 is not None and readMolecule_9 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                FindMolPath_7, readMolecule_9, "molpath", "filename", blocking=True
                , splitratio=[0.21636244059584375, 0.72623026114617018])
        except:
            print "WARNING: failed to restore connection between FindMolPath_7 and readMolecule_9 in network LoadMolecule5_3.macroNetwork"
    if Pmv_10 is not None and computeMSMS_11 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                Pmv_10, computeMSMS_11, "cmd", "command", blocking=True
                , splitratio=[0.51805666489740432, 0.65872140393229073])
        except:
            print "WARNING: failed to restore connection between Pmv_10 and computeMSMS_11 in network LoadMolecule5_3.macroNetwork"
    if input_Ports_4 is not None and computeMSMS_11 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                input_Ports_4, computeMSMS_11, "FindMolPath_molname", "nodes", blocking=True
                , splitratio=[0.52821761384014243, 0.62344925894625258])
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and computeMSMS_11 in network LoadMolecule5_3.macroNetwork"
    if readMolecule_9 is not None and computeMSMS_11 is not None:
        try:
            LoadMolecule5_3.macroNetwork.specialConnectNodes(
                readMolecule_9, computeMSMS_11, "trigger", "runNode", blocking=True
                , splitratio=[0.53056199344731425, 0.35524187431681792])
        except:
            print "WARNING: failed to restore connection between readMolecule_9 and computeMSMS_11 in network LoadMolecule5_3.macroNetwork"
    if Pmv_13 is not None and deleteAllMolecules_12 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                Pmv_13, deleteAllMolecules_12, "cmd", "command", blocking=True
                , splitratio=[0.66024693919479915, 0.62418992981442756])
        except:
            print "WARNING: failed to restore connection between Pmv_13 and deleteAllMolecules_12 in network LoadMolecule5_3.macroNetwork"
    if deleteAllMolecules_12 is not None and readMolecule_9 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                deleteAllMolecules_12, readMolecule_9, "result", "parser", blocking=True
                , splitratio=[0.32991431199869631, 0.4313515641191642])
        except:
            print "WARNING: failed to restore connection between deleteAllMolecules_12 and readMolecule_9 in network LoadMolecule5_3.macroNetwork"
    output_Ports_5 = LoadMolecule5_3.macroNetwork.opNode
    if FindMolPath_7 is not None and output_Ports_5 is not None:
        try:
            LoadMolecule5_3.macroNetwork.connectNodes(
                FindMolPath_7, output_Ports_5, "molpath", "new", blocking=True
                , splitratio=[0.59721511886821532, 0.46900469791423793])
        except:
            print "WARNING: failed to restore connection between FindMolPath_7 and output_Ports_5 in network LoadMolecule5_3.macroNetwork"
    LoadMolecule5_3.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_4.outputPorts[1].configure(name='FindMolPath_molname')
    input_Ports_4.outputPorts[2].configure(name='abs_path_in1')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_5.inputPorts[1].configure(singleConnection='auto')
    output_Ports_5.inputPorts[1].configure(name='FindMolPath_molpath')
    LoadMolecule5_3.inputPorts[0].configure(name='FindMolPath_molname')
    LoadMolecule5_3.inputPorts[0].configure(datatype='string')
    LoadMolecule5_3.inputPorts[1].configure(name='abs_path_in1')
    LoadMolecule5_3.inputPorts[1].configure(datatype='string')
    ## configure MacroNode input ports
    LoadMolecule5_3.outputPorts[0].configure(name='FindMolPath_molpath')
    LoadMolecule5_3.outputPorts[0].configure(datatype='string')
    ## configure MacroNode output ports
    LoadMolecule5_3.shrink()
    apply(LoadMolecule5_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named LoadMolecule5 in network masterNet"
    print_exc()
    LoadMolecule5_3=None

try:
    ## saving node ShowConformations6 ##
    from NetworkEditor.macros import MacroNode
    ShowConformations6_14 = MacroNode(name='ShowConformations6')
    masterNet.addNode(ShowConformations6_14, 543, 541)
    output_Ports_16 = ShowConformations6_14.macroNetwork.opNode
    apply(output_Ports_16.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    output_Ports_16.move(220, 365)
    from Vision.StandardNodes import Generic
    GetLigandDLG_17 = Generic(constrkw={}, name='GetLigandDLG', library=stdlib)
    ShowConformations6_14.macroNetwork.addNode(GetLigandDLG_17,253,127)
    apply(GetLigandDLG_17.addInputPort, (), {'singleConnection': True, 'name': 'ligand_name', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetLigandDLG_17.addInputPort, (), {'singleConnection': True, 'name': 'ligand_dir', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetLigandDLG_17.addOutputPort, (), {'name': 'ligand_dlg', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(GetLigandDLG_17.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, ligand_name, ligand_dir):
        ligand_dlg = ligand_dir + os.sep + ligand_name + os.sep + ligand_name + '''.dlg'''

        if not os.path.exists(ligand_dlg):
            ligand_dlg = ligand_dir + os.sep + ligand_name + os.sep + '''outlog.dlg'''

        if not os.path.exists(ligand_dlg):
            print "ERROR: NO ligand dlg found in " + ligand_dir + os.sep + ligand_name + os.sep
            
	pass
## to ouput data on port ligand_dlg use
        self.outputData(ligand_dlg=ligand_dlg)








"""
    GetLigandDLG_17.configure(function=code)
    apply(GetLigandDLG_17.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_18 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ShowConformations6_14.macroNetwork.addNode(Pmv_18,58,145)
    Pmv_18.inputPortByName['cmdName'].widget.set(r"AD41analyze_readDLG", run=False)
    Pmv_18.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_18.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    AD41analyze_readDLG_19 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.AD41analyze_readDLG, namedArgs={'ask': 1, 'addToPrevious': 0}, posArgsNames=['dlgFile'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.AD41analyze_readDLG', 'namedArgs': {'ask': 1, 'addToPrevious': 0}, 'posArgsNames': ['dlgFile']}, name='AD41analyze_readDLG', library=pmvlib)
    ShowConformations6_14.macroNetwork.addNode(AD41analyze_readDLG_19,237,211)
    apply(AD41analyze_readDLG_19.inputPortByName['dlgFile'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(AD41analyze_readDLG_19.inputPortByName['ask'].configure, (), {'defaultValue': None})
    apply(AD41analyze_readDLG_19.inputPortByName['addToPrevious'].configure, (), {'defaultValue': None})
    apply(AD41analyze_readDLG_19.configure, (), {'specialPortsVisible': True})
    AD41analyze_readDLG_19.inputPortByName['importString'].widget.set(r"", run=False)
    AD41analyze_readDLG_19.inputPortByName['ask'].widget.set(1, run=False)
    AD41analyze_readDLG_19.inputPortByName['addToPrevious'].widget.set(0, run=False)
    apply(AD41analyze_readDLG_19.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_20 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ShowConformations6_14.macroNetwork.addNode(Pmv_20,59,225)
    Pmv_20.inputPortByName['cmdName'].widget.set(r"AD41analyze_showStates", run=False)
    Pmv_20.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_20.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    AD41analyze_showStates_21 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.AD41analyze_showStates, namedArgs={'log': 1}, posArgsNames=['mol'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.AD41analyze_showStates', 'namedArgs': {'log': 1}, 'posArgsNames': ['mol']}, name='AD41analyze_showStates', library=pmvlib)
    ShowConformations6_14.macroNetwork.addNode(AD41analyze_showStates_21,200,285)
    apply(AD41analyze_showStates_21.inputPortByName['mol'].configure, (), {'datatype': 'string', 'defaultValue': None, 'originalDatatype': 'None'})
    apply(AD41analyze_showStates_21.inputPortByName['log'].configure, (), {'defaultValue': None})
    apply(AD41analyze_showStates_21.configure, (), {'specialPortsVisible': True})
    AD41analyze_showStates_21.inputPortByName['importString'].widget.set(r"", run=False)
    AD41analyze_showStates_21.inputPortByName['log'].widget.set(1, run=False)
    apply(AD41analyze_showStates_21.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    GetMolList_22 = Generic(constrkw={}, name='GetMolList', library=stdlib)
    ShowConformations6_14.macroNetwork.addNode(GetMolList_22,374,126)
    apply(GetMolList_22.addInputPort, (), {'singleConnection': True, 'name': 'Pmv', 'cast': True, 'datatype': 'PmvInstance', 'defaultValue': None, 'required': True, 'height': 12, 'width': 12, 'shape': 'circle', 'color': '#7A7AFF', 'originalDatatype': 'None'})
    apply(GetMolList_22.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': True, 'datatype': 'string', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(GetMolList_22.addInputPort, (), {'singleConnection': True, 'name': 'in2', 'cast': True, 'datatype': 'None', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(GetMolList_22.addOutputPort, (), {'name': 'out0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(GetMolList_22.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, Pmv, in1, in2):
        assert Pmv is not None
        receptor = os.path.basename(in2)
        receptor = receptor.split('''.''')[0]

        all = map(lambda x: x.name, Pmv.Mols)
        #count = 0

        #for i in all:
        #    if i != in1 or i != in2:
        #        count = count + 1
        #        all.remove(i)
                #if count == 2:
                #    break

        #Pmv.showMolecules(all, negate=True, log=0)
        
        mols = list()

        for i in all:
            if i != in1 and i != receptor:
                mols.append(i)

        Pmv.showMolecules(mols, negate=True, log=0)
        #Pmv.showMolecules(negate=True, log=0)

	pass
## to ouput data on port out0 use
        self.outputData(out0=mols)

































"""
    GetMolList_22.configure(function=code)
    apply(GetMolList_22.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1, 'expanded': False})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_23 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ShowConformations6_14.macroNetwork.addNode(Pmv_23,375,42)
    apply(Pmv_23.inputPortByName['cmdName'].configure, (), {'defaultValue': None})
    apply(Pmv_23.inputPortByName['molecules'].configure, (), {'defaultValue': None})
    Pmv_23.inputPortByName['cmdName'].widget.set(r"", run=False)
    Pmv_23.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_23.configure, (), {'paramPanelImmediate': 1, 'expanded': False})

    ## saving connections for network ShowConformations6 ##
    ShowConformations6_14.macroNetwork.freeze()
    input_Ports_15 = ShowConformations6_14.macroNetwork.ipNode
    if input_Ports_15 is not None and GetLigandDLG_17 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                input_Ports_15, GetLigandDLG_17, "new", "ligand_name", blocking=True
                , splitratio=[0.3098536280134469, 0.48565093299230189])
        except:
            print "WARNING: failed to restore connection between input_Ports_15 and GetLigandDLG_17 in network ShowConformations6_14.macroNetwork"
    if input_Ports_15 is not None and GetLigandDLG_17 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                input_Ports_15, GetLigandDLG_17, "new", "ligand_dir", blocking=True
                , splitratio=[0.33601172059588991, 0.62781207392950156])
        except:
            print "WARNING: failed to restore connection between input_Ports_15 and GetLigandDLG_17 in network ShowConformations6_14.macroNetwork"
    if Pmv_18 is not None and AD41analyze_readDLG_19 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                Pmv_18, AD41analyze_readDLG_19, "cmd", "command", blocking=True
                , splitratio=[0.69124752996188765, 0.74417941624282569])
        except:
            print "WARNING: failed to restore connection between Pmv_18 and AD41analyze_readDLG_19 in network ShowConformations6_14.macroNetwork"
    if GetLigandDLG_17 is not None and AD41analyze_readDLG_19 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                GetLigandDLG_17, AD41analyze_readDLG_19, "ligand_dlg", "dlgFile", blocking=True
                , splitratio=[0.30237922682451068, 0.37504940304702639])
        except:
            print "WARNING: failed to restore connection between GetLigandDLG_17 and AD41analyze_readDLG_19 in network ShowConformations6_14.macroNetwork"
    if Pmv_20 is not None and AD41analyze_showStates_21 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                Pmv_20, AD41analyze_showStates_21, "cmd", "command", blocking=True
                , splitratio=[0.67750223926482356, 0.3916492569990021])
        except:
            print "WARNING: failed to restore connection between Pmv_20 and AD41analyze_showStates_21 in network ShowConformations6_14.macroNetwork"
    if input_Ports_15 is not None and AD41analyze_showStates_21 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                input_Ports_15, AD41analyze_showStates_21, "GetLigandDLG_ligand_name", "mol", blocking=True
                , splitratio=[0.48195714670172196, 0.48045452051969201])
        except:
            print "WARNING: failed to restore connection between input_Ports_15 and AD41analyze_showStates_21 in network ShowConformations6_14.macroNetwork"
    if AD41analyze_readDLG_19 is not None and AD41analyze_showStates_21 is not None:
        try:
            ShowConformations6_14.macroNetwork.specialConnectNodes(
                AD41analyze_readDLG_19, AD41analyze_showStates_21, "trigger", "runNode", blocking=True
                , splitratio=[0.69705190112635451, 0.37248312577637505])
        except:
            print "WARNING: failed to restore connection between AD41analyze_readDLG_19 and AD41analyze_showStates_21 in network ShowConformations6_14.macroNetwork"
    if Pmv_23 is not None and GetMolList_22 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                Pmv_23, GetMolList_22, "PMV", "Pmv", blocking=True
                , splitratio=[0.22281755983671137, 0.33186887241855467])
        except:
            print "WARNING: failed to restore connection between Pmv_23 and GetMolList_22 in network ShowConformations6_14.macroNetwork"
    if input_Ports_15 is not None and GetMolList_22 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                input_Ports_15, GetMolList_22, "GetLigandDLG_ligand_name", "in1", blocking=True
                , splitratio=[0.41038366697012862, 0.62996532422459084])
        except:
            print "WARNING: failed to restore connection between input_Ports_15 and GetMolList_22 in network ShowConformations6_14.macroNetwork"
    if input_Ports_15 is not None and GetMolList_22 is not None:
        try:
            ShowConformations6_14.macroNetwork.connectNodes(
                input_Ports_15, GetMolList_22, "new", "in2", blocking=True
                , splitratio=[0.66011397806266103, 0.33140888638371957])
        except:
            print "WARNING: failed to restore connection between input_Ports_15 and GetMolList_22 in network ShowConformations6_14.macroNetwork"
    ShowConformations6_14.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_15.outputPorts[1].configure(name='GetLigandDLG_ligand_name')
    input_Ports_15.outputPorts[2].configure(name='GetLigandDLG_ligand_dir')
    input_Ports_15.outputPorts[3].configure(name='GetMolList_in2')
    ShowConformations6_14.inputPorts[0].configure(name='GetLigandDLG_ligand_name')
    ShowConformations6_14.inputPorts[0].configure(datatype='string')
    ShowConformations6_14.inputPorts[1].configure(name='GetLigandDLG_ligand_dir')
    ShowConformations6_14.inputPorts[1].configure(datatype='string')
    ShowConformations6_14.inputPorts[2].configure(name='GetMolList_in2')
    ShowConformations6_14.inputPorts[2].configure(datatype='string')
    ## configure MacroNode input ports
    ## configure MacroNode output ports
    ShowConformations6_14.shrink()
    apply(ShowConformations6_14.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MacroNode named ShowConformations6 in network masterNet"
    print_exc()
    ShowConformations6_14=None

try:
    ## saving node LigandList ##
    from Vision.StandardNodes import ScrolledListNE
    LigandList_24 = ScrolledListNE(constrkw={}, name='LigandList', library=stdlib)
    masterNet.addNode(LigandList_24,246,161)
    apply(LigandList_24.inputPortByName['selection'].widget.configure, (), {'choices': ['diversity0004', 'diversity0005', 'diversity0003', 'diversity0001', 'diversity0002', 'diversity0006']})
    LigandList_24.inputPortByName['selection'].widget.set(r"", run=False)
    code = """def doit(self, valueList, nameList, selection):
    widget = self.inputPorts[2].widget

    # do we run the first time, and have been restored from a network? (then
    # we have both valueList and selection specified)

    if self.inputPorts[0].hasNewValidData():
        selection = None
        
    if valueList and selection and self.firstRun is True:
        self.firstRun = False
        self.objectList = valueList
        self.nameList = nameList
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)
        return

    # only rebuild widget if we receive a new valueList
    if self.inputPorts[0].hasNewValidData() or self.inputPorts[1].hasNewValidData():
        if valueList != self.objectList or self.nameList != nameList:
            self.objectList = valueList
            self.nameList = nameList
            if nameList:
                vList = nameList
            else:
                vList = []
                for data in valueList:
                    if type(data) == types.StringType:
                        vList.append(data)
                    else:
                        vList.append(repr(data))
            if widget is not None:
                widget.setlist(vList)
                widget.configure(choices=vList)
                widget.widget.setentry('''''')
            return

    if selection:
        data = self.getData(selection, nameList)
        if data is not None:
            self.outputData(selection=data)

"""
    LigandList_24.configure(function=code)
    apply(LigandList_24.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ScrolledListNE named LigandList in network masterNet"
    print_exc()
    LigandList_24=None

try:
    ## saving node VSOutputDirectory ##
    from Vision.StandardNodes import DirBrowserNE
    VSOutputDirectory_25 = DirBrowserNE(constrkw={}, name='VSOutputDirectory', library=stdlib)
    masterNet.addNode(VSOutputDirectory_25,10,4)
    VSOutputDirectory_25.inputPortByName['directory'].widget.set(r"VSResults_0.1_input", run=False)
    apply(VSOutputDirectory_25.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DirBrowserNE named VSOutputDirectory in network masterNet"
    print_exc()
    VSOutputDirectory_25=None

#masterNet.run()
masterNet.freeze()

## saving connections for network VSResults-0.1 ##
if GetReceptors_0 is not None and ReceptorList_1 is not None:
    try:
        masterNet.connectNodes(
            GetReceptors_0, ReceptorList_1, "filelist", "valueList", blocking=True
            , splitratio=[0.48905913647612814, 0.29360410336373438])
    except:
        print "WARNING: failed to restore connection between GetReceptors_0 and ReceptorList_1 in network masterNet"
if ReceptorList_1 is not None and GetLigands_2 is not None:
    try:
        masterNet.connectNodes(
            ReceptorList_1, GetLigands_2, "selection", "receptor", blocking=True
            , splitratio=[0.42538364036717291, 0.58358889034815098])
    except:
        print "WARNING: failed to restore connection between ReceptorList_1 and GetLigands_2 in network masterNet"
if GetReceptors_0 is not None and GetLigands_2 is not None:
    try:
        masterNet.connectNodes(
            GetReceptors_0, GetLigands_2, "filelist_paths", "receptorlist", blocking=True
            , splitratio=[0.36424339756927371, 0.30463602511408611])
    except:
        print "WARNING: failed to restore connection between GetReceptors_0 and GetLigands_2 in network masterNet"
LoadMolecule5_3 = masterNet.nodes[3]
ShowConformations6_14 = masterNet.nodes[4]
if LoadMolecule5_3 is not None and ShowConformations6_14 is not None:
    try:
        masterNet.connectNodes(
            LoadMolecule5_3, ShowConformations6_14, "FindMolPath_molpath", "GetMolList_in2", blocking=True
            , splitratio=[0.42667541388043656, 0.68263435741014988])
    except:
        print "WARNING: failed to restore connection between LoadMolecule5_3 and ShowConformations6_14 in network masterNet"
if GetLigands_2 is not None and LigandList_24 is not None:
    try:
        masterNet.connectNodes(
            GetLigands_2, LigandList_24, "ligandlist", "valueList", blocking=True
            , splitratio=[0.43348589067232524, 0.71851748283944694])
    except:
        print "WARNING: failed to restore connection between GetLigands_2 and LigandList_24 in network masterNet"
if ReceptorList_1 is not None and LoadMolecule5_3 is not None:
    try:
        masterNet.connectNodes(
            ReceptorList_1, LoadMolecule5_3, "selection", "FindMolPath_molname", blocking=True
            , splitratio=[0.45144502057638469, 0.25103051955449046])
    except:
        print "WARNING: failed to restore connection between ReceptorList_1 and LoadMolecule5_3 in network masterNet"
if VSOutputDirectory_25 is not None and LoadMolecule5_3 is not None:
    try:
        masterNet.connectNodes(
            VSOutputDirectory_25, LoadMolecule5_3, "AbsPath_directory", "abs_path_in1", blocking=True
            , splitratio=[0.22052704406206425, 0.59085497893808769])
    except:
        print "WARNING: failed to restore connection between VSOutputDirectory_25 and LoadMolecule5_3 in network masterNet"
if LigandList_24 is not None and ShowConformations6_14 is not None:
    try:
        masterNet.connectNodes(
            LigandList_24, ShowConformations6_14, "selection", "GetLigandDLG_ligand_name", blocking=True
            , splitratio=[0.29779314820077629, 0.65106503390095383])
    except:
        print "WARNING: failed to restore connection between LigandList_24 and ShowConformations6_14 in network masterNet"
if GetLigands_2 is not None and ShowConformations6_14 is not None:
    try:
        masterNet.connectNodes(
            GetLigands_2, ShowConformations6_14, "liganddir", "GetLigandDLG_ligand_dir", blocking=True
            , splitratio=[0.56416893580956851, 0.32973982963985227])
    except:
        print "WARNING: failed to restore connection between GetLigands_2 and ShowConformations6_14 in network masterNet"
if VSOutputDirectory_25 is not None and GetReceptors_0 is not None:
    try:
        masterNet.connectNodes(
            VSOutputDirectory_25, GetReceptors_0, "AbsPath_directory", "directory", blocking=True
            , splitratio=[0.41364431314011513, 0.61325277014217927])
    except:
        print "WARNING: failed to restore connection between VSOutputDirectory_25 and GetReceptors_0 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

