!{\src2tex{textfont=tt}}
!!****f* ABINIT/initmpi_fft
!! NAME
!! initmpi_fft
!!
!! FUNCTION
!! Initialize the mpi informations for the ground-state datasets
!!
!! COPYRIGHT
!! Copyright (C) 2002-2007 ABINIT group (AR, XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!  mpi_enreg=informations about MPI parallelization
!!
!! OUTPUT
!!  mpi_enreg=informations about MPI parallelization
!!    mpi_enreg%fft_comm(nkpt)=comm array of FFT set
!!    mpi_enreg%fft_group(nkpt)=group array of FFT set
!!    mpi_enreg%me_fft=index of the processor in the FFT set
!!    mpi_enreg%nproc_fft=number of processors int the FFT set
!!
!! SIDE EFFECTS
!!
!! TODO
!!
!! PARENTS
!!      gstate,invars2m,respfn
!!
!! CHILDREN
!!      leave_new,mpi_cart_coords,mpi_cart_create,mpi_cart_sub,mpi_comm_create
!!      mpi_comm_group,mpi_comm_rank,mpi_comm_size,mpi_group_incl
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine initmpi_fft(dtset,mpi_enreg)

 use defs_basis
 use defs_infos
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi, except_this_one => initmpi_fft
#endif
!End of the abilint section

 implicit none

#if defined MPI || defined MPI_FFT
           include 'mpif.h'
#endif
!Arguments ------------------------------------
 type(dataset_type),intent(in) :: dtset
 type(MPI_type),intent(inout) :: mpi_enreg

!Local variables-------------------------------
!no_abirules
#if defined MPI || defined MPI_FFT
           integer :: nkpt,nsppol
          !Variables introduced for MPI version
           integer :: iblock,ierr,ifft,iikpt,iiproc,iproc,iproc_max,iproc_min,irank,isppol
           !Variables introduced for the bandFFT version
           logical :: reorder
           logical, allocatable :: periode(:), keepdim(:)
           integer, allocatable :: coords(:)
           integer :: np_fft, np_band, np_test
           integer,allocatable :: ranks(:)
#endif
! ***********************************************************************

!DEBUG
! write(6,*)' initmpi_fft : enter'
!stop
!ENDDEBUG

#if defined MPI_FFT
 mpi_enreg%mode_para='b'
 mpi_enreg%fft_option_lob=1

 mpi_enreg%paralbd=0
 mpi_enreg%paral_fft=1
 if (dtset%fft_opt_lob /= 0) mpi_enreg%fft_option_lob=dtset%fft_opt_lob
#endif
!Set up information for FFT parallelism

#if defined MPI || defined MPI_FFT
        nkpt=dtset%nkpt
        nsppol=dtset%nsppol
        call MPI_COMM_SIZE(MPI_COMM_WORLD,mpi_enreg%nproc,ierr)
        call MPI_COMM_RANK(MPI_COMM_WORLD,mpi_enreg%me,ierr)
#endif
#if defined MPI_FFT
! modif le 17/09/2004 sera a remettre
!              if(modulo(mpi_enreg%nproc,nkpt)/=0)then
!                   write(message,'(6a,i5,a,i5)') ch10,&
!&   ' initmpi_fft : BUG -',ch10,&
!&   '  The number of processors, nproc, should be',&
!&   '  a multiple of the number of nkpt for the FFT, nkpt.',&
!&   '  However, nproc=',mpi_enreg%nproc,' and nkpt=',nkpt
!                   call wrtout(06,message,'COLL')
!                   call leave_new('COLL')
!                end if
#endif
#if defined MPI_FFT
! modif le 17/09/2004 sera a remettre
!!!            mpi_enreg%nproc_fft=mpi_enreg%nproc/nkpt
             mpi_enreg%nproc_fft=mpi_enreg%nproc
#endif
#if defined MPI
            mpi_enreg%nproc_fft=1
#endif

#if defined MPI || defined MPI_FFT
            if(mpi_enreg%nproc_fft == 0) mpi_enreg%nproc_fft=1
!           Creation of groups of communicators
            allocate(mpi_enreg%fft_comm(nkpt*nsppol))
            allocate(mpi_enreg%fft_group(nkpt*nsppol))
            call MPI_COMM_GROUP(MPI_COMM_WORLD,mpi_enreg%world_group,ierr)
            iproc=1
#endif

! a terme, le paragraphe suivant pourra etre supprime et le second
! debutera avec if defined MPI_FFT || defined MPI
#if defined MPI_FFT
            allocate(ranks(mpi_enreg%nproc_fft))
            do isppol=1,nsppol
             do iikpt=1,nkpt*nsppol
! a enlever plus tard
!              iproc=1
! in which block I am ?
!              iblock=mpi_enreg%me / mpi_enreg%nproc_fft +1
              do irank=iproc,iproc + mpi_enreg%nproc_fft -1
!               ranks(irank)=irank+mpi_enreg%nproc_fft*(iblock-1)-1
               ranks(irank)=irank-1
               if (ranks(irank)==mpi_enreg%me) then
                mpi_enreg%num_group_fft=iikpt
               end if
              end do
!!! a remettre plus tard
!!!!               iproc=iproc+mpi_enreg%nproc_fft
              call MPI_GROUP_INCL(mpi_enreg%world_group,mpi_enreg%nproc_fft,  &
&              ranks,mpi_enreg%fft_group(iikpt+(isppol-1)*nkpt),ierr)
              call MPI_COMM_CREATE(MPI_COMM_WORLD,mpi_enreg%fft_group(iikpt+(isppol-1)*nkpt), &
&              mpi_enreg%fft_comm(iikpt+(isppol-1)*nkpt),ierr)
             end do
            end do
            call MPI_COMM_RANK(mpi_enreg%fft_comm(mpi_enreg%num_group_fft),&
&              mpi_enreg%me_fft,ierr)
            if (mpi_enreg%me_fft==0) then
                    mpi_enreg%master_fft=mpi_enreg%me
                else
                mpi_enreg%master_fft=-1
            end if
            call MPI_COMM_SIZE(mpi_enreg%fft_comm(mpi_enreg%num_group_fft),&
&              mpi_enreg%nproc_fft,ierr)
            deallocate(ranks)
! write(6,*) mpi_enreg%mode_para
 if(mpi_enreg%mode_para=='b') then
  np_fft=dtset%npfft
  np_band=dtset%npband
  write(6,*) 'npfft and npband',np_fft,np_band
  if(modulo(dtset%ngfft(2),np_fft)/=0)then
   write(6,'(8a,i5,a,i5)') ch10,&
&   ' initmpi_fft : BUG -',ch10,&
&   '  The number of FFT processors, npfft, should be',ch10,&
&   '  a multiple of the number of ngfft(2).',ch10,&
&   '  However, npfft=',np_fft,' and ngfft(2)=',dtset%ngfft(2)
   call leave_new('PERS')
  end if
  do iikpt=1,nkpt*nsppol
   if(modulo(dtset%nband(iikpt),np_band)/=0)then
    write(6,'(8a,i5,a,i5)') ch10,&
&    ' initmpi_fft : BUG -',ch10,&
&    '  The number of band processors, npband, should be',ch10,&
&    '  a multiple of the number of nband.',ch10,&
&    '  However, npband=',np_band,' and nband=',dtset%nband
    call leave_new('PERS')
   end if
  end do
  if(np_fft*np_band /= mpi_enreg%nproc)then
   write(6,'(8a,i5,a,i5,a,i5)') ch10,&
&   ' initmpi_fft : BUG -',ch10,&
&   '  The number of band*FFT processors, npband*npfft, should be',ch10,&
&   '  equal to the total number of processors, nproc.',ch10,&
&   '  However, npband=',np_band,' npfft =',np_fft,' and nproc=',mpi_enreg%nproc
   call leave_new('PERS')
  end if
  mpi_enreg%dimcart=2
  allocate(mpi_enreg%sizecart(mpi_enreg%dimcart),periode(mpi_enreg%dimcart),&
&          mpi_enreg%coords(mpi_enreg%dimcart))
  mpi_enreg%sizecart(1)=np_fft
  mpi_enreg%sizecart(2)=np_band
  periode(:)=.false.
  reorder=.false.
! create the cartesian grid with commcart as a communicator.
  call MPI_CART_CREATE(MPI_COMM_WORLD,mpi_enreg%dimcart,mpi_enreg%sizecart,periode,&
&  reorder,mpi_enreg%commcart,ierr)
! Find the index and coordinates of the current  processor
  call MPI_COMM_RANK(mpi_enreg%commcart, mpi_enreg%me_cart, ierr)
  call MPI_CART_COORDS(mpi_enreg%commcart, mpi_enreg%me_cart,  mpi_enreg%dimcart, &
&  mpi_enreg%coords, ierr)
! Create the communicator for space (Fourier) distribution
  allocate(keepdim(mpi_enreg%dimcart))
  keepdim(1)=.true.
  keepdim(2)=.false.
  call MPI_CART_SUB(mpi_enreg%commcart, keepdim, mpi_enreg%comm_fft,ierr)
  call MPI_COMM_SIZE(mpi_enreg%comm_fft,np_test, ierr)
!  write(6,*) 'mpi_enreg%sizecart(1),np_fft',mpi_enreg%sizecart(1), np_test
! Create the communicator for band distribution
  keepdim(1)=.false.
  keepdim(2)=.true.
  call MPI_CART_SUB(mpi_enreg%commcart, keepdim, mpi_enreg%comm_band,ierr)
! Define the correspondance with the fft
  mpi_enreg%me_fft=mpi_enreg%coords(1)
  mpi_enreg%me_band=mpi_enreg%coords(2)
  mpi_enreg%nproc_fft=np_fft
  mpi_enreg%nproc_band=np_band
!  write(6,*) 'in initmpi: me_fft and me_band are',mpi_enreg%me_fft,mpi_enreg%me_band
 end if
#endif

#if defined MPI
            mpi_enreg%master_fft=-1
            do isppol=1,nsppol
                    do iikpt=1,nkpt
                     if (mpi_enreg%parareel==0) then
                        iproc_min=minval(mpi_enreg%proc_distrb(iikpt,:,isppol))
                        iproc_max=maxval(mpi_enreg%proc_distrb(iikpt,:,isppol))
                        if (mpi_enreg%me == iproc_min) then
                                mpi_enreg%master_fft=mpi_enreg%me
                        end if
                           allocate(ranks(iproc_max-iproc_min+1))
                        iiproc=1
                        do iproc=iproc_min,iproc_max
                                 ranks(iiproc)=iproc
                                iiproc=iiproc+1
                        end do

!                       With MPI on SGI machine "Spinoza", there is a limitation
!                       of the number of groups that can be defined. When MPI_FFT
!                       is not used, there is actually no reason to define
!                       the following groups (in the present implementation). So,
!                       these lines can be skipped.
#if !defined FC_MIPSPRO
                          call MPI_GROUP_INCL(mpi_enreg%world_group,&
&                        iproc_max-iproc_min+1,&
&                        ranks,mpi_enreg%fft_group(iikpt+(isppol-1)*nkpt),ierr)
                        call MPI_COMM_CREATE(MPI_COMM_WORLD, &
&                        mpi_enreg%fft_group(iikpt+(isppol-1)*nkpt),&
&                        mpi_enreg%fft_comm(iikpt+(isppol-1)*nkpt),ierr)
#endif
                        deallocate(ranks)

                    else
                        iproc_min=mpi_enreg%proc_distrb_para(mpi_enreg%ipara,iikpt)
                        allocate(ranks(1))
                        ranks(1)=iproc_min
                        call MPI_GROUP_INCL(mpi_enreg%world_group,&
&                        1,ranks,mpi_enreg%fft_group(iikpt+(isppol-1)*nkpt),ierr)
                        call MPI_COMM_CREATE(MPI_COMM_WORLD, &
&                        mpi_enreg%fft_group(iikpt+(isppol-1)*nkpt),&
&                        mpi_enreg%fft_comm(iikpt+(isppol-1)*nkpt),ierr)
                        deallocate(ranks)
                    end if
                end do
            end do
!            mpi_enreg%num_group_fft=
#endif


#if defined MPI || defined MPI_FFT
! creation of master_communicator
           if (mpi_enreg%paral_fft == 0) then
                allocate(ranks(mpi_enreg%nproc))
                do iproc=0,mpi_enreg%nproc-1
                        ranks(iproc+1)=iproc
                end do
                call MPI_GROUP_INCL(mpi_enreg%world_group,mpi_enreg%nproc,ranks, &
&                mpi_enreg%fft_master_group,ierr)
                call MPI_COMM_CREATE(MPI_COMM_WORLD,mpi_enreg%fft_master_group,&
&                mpi_enreg%fft_master_comm,ierr)
                deallocate(ranks)
                else
! only one proc per group_fft
!!! a remettre quand on fera la merge des MPI et MPI_FFT
! pour l'instant, le communicateur master de chaque FFT est toujours le proc 0
!                    allocate(ranks(nkpt*nsppol))
!                do isppol=1,nsppol
!                            do iikpt=1,nkpt
!                                ranks(iikpt+(isppol-1)*nkpt)=minval(mpi_enreg%proc_distrb(iikpt,:,isppol))
!                        end do
!                end do
                allocate(ranks(1))
                ranks(1)=0
!!!!                  call MPI_GROUP_INCL(mpi_enreg%world_group,nkpt*nsppol,ranks, &
!!!!&                mpi_enreg%fft_master_group,ierr)
                  call MPI_GROUP_INCL(mpi_enreg%world_group,1,ranks, &
&                mpi_enreg%fft_master_group,ierr)
!               call MPI_COMM_CREATE(MPI_COMM_WORLD,mpi_enreg%fft_master_group,&
!&                mpi_enreg%fft_master_comm,ierr)
                mpi_enreg%fft_master_comm=MPI_COMM_SELF
                   deallocate(ranks)
           end if
#endif

  if (mpi_enreg%paral_compil_fft==1 .and. dtset%mgfft /=0) then
!  creation of arrays for FFT parallelization
   allocate(mpi_enreg%nplanes_fft(dtset%nkpt))
!   write(6,*)'initmpi_fft dtset%ngfft(2)',dtset%ngfft(2)
   allocate(mpi_enreg%ind_fft_planes(dtset%nkpt,dtset%ngfft(2)))
!   write(6,*)'initmpi_fft alloc taille',dtset%ngfft(2)
  end if

!DEBUG
! write(6,*)' initmpi_fft : exit'
!ENDDEBUG

end subroutine initmpi_fft
!!***
