!!****m* ABINIT/interfaces_21drive
!! NAME
!! interfaces_21drive
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/21drive
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_21drive

 interface
  subroutine afterscfloop(atindx,atindx1,cg,computed_forces,cpus,&  
&  deltae,diffor,dtefield,dtfil,dtset,eigen,energies,etotal,&  
&  favg,fcart,filapp,filfft,forold,fred,gresid,grewtn,grhf,&  
&  grxc,gsqcut,hdr,indsym,&  
&  istep,kg,kxc,maxfor,mgfftf,&  
&  moved_atm_inside,mpi_enreg,&  
&  n3xccc,nattyp,&  
&  nfftf,ngfft,ngfftf,nhat,nkxc,npwarr,nvresid,&  
&  occ,optres,optxc,paw_ij,pawang,pawfgr,pawfgrtab,pawrhoij,pawtab,pel,pel_cg,&  
&  ph1d,ph1df,pion,prtfor,psps,pwind,pwind_alloc,pwnsfac,res2,resid,residm,results_gs,&  
&  rhocore,rhog,rhor,rhore,rhototp,&  
&  rprimd,stress_needed,strsxc,strten,symrec,synlgr,tollist,usexcnhat,&  
&  vhartr,vpsp,vxc,vxcavg,wffnow,wfs,xccc3d,xred,xred_old,ylm,ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(inout) :: computed_forces
   integer,intent(in) :: istep
   integer,intent(in) :: mgfftf
   integer,intent(in) :: moved_atm_inside
   integer,intent(in) :: n3xccc
   integer,intent(in) :: nfftf
   integer,intent(in) :: nkxc
   integer,intent(in) :: optres
   integer,intent(in) :: optxc
   integer,intent(in) :: prtfor
   integer,intent(in) :: pwind_alloc
   integer,intent(in) :: stress_needed
   integer,intent(in) :: usexcnhat
   real(dp),intent(in) :: cpus
   real(dp),intent(in) :: deltae
   real(dp),intent(inout) :: diffor
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   type(energies_type), intent(inout) :: energies
   real(dp),intent(inout) :: etotal
   character(len=fnlen),intent(in) :: filapp
   character(len=fnlen),intent(in) :: filfft
   real(dp),intent(in) :: gsqcut
   type(hdr_type),intent(inout) :: hdr
   real(dp),intent(inout) :: maxfor
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type),intent(in) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   real(dp),intent(in) :: res2
   real(dp),intent(in) :: residm
   type(results_gs_type),intent(inout) :: results_gs
   real(dp),intent(inout) :: vxcavg
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_wf_type), intent(inout) :: wfs
   real(dp),intent(out) :: favg(3)
   integer,intent(in) :: ngfft(18)
   integer,intent(in) :: ngfftf(18)
   real(dp),intent(inout) :: pel(3)
   real(dp),intent(in) :: pel_cg(3)
   real(dp),intent(inout) :: pion(3)
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(inout) :: strsxc(6)
   real(dp),intent(out) :: strten(6)
   real(dp),intent(in) :: tollist(12)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp),intent(in) :: cg(2,dtset%mpw*dtset%nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp),intent(in) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp),intent(out) :: fcart(3,dtset%natom)
   real(dp),intent(inout) :: forold(3,dtset%natom)
   real(dp),intent(out) :: fred(3,dtset%natom)
   real(dp),intent(out) :: gresid(3,dtset%natom)
   real(dp),intent(in) :: grewtn(3,dtset%natom)
   real(dp),intent(out) :: grhf(3,dtset%natom)
   real(dp),intent(out) :: grxc(3,dtset%natom)
   integer,intent(in) :: indsym(4,dtset%nsym,dtset%natom)
   integer,intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   real(dp),intent(out) :: kxc(nfftf,nkxc)
   integer,intent(in) :: nattyp(dtset%ntypat)
   real(dp),intent(inout) :: nhat(nfftf,dtset%nspden*psps%usepaw)
   integer,intent(in) :: npwarr(dtset%nkpt)
   real(dp),intent(inout) :: nvresid(nfftf,dtset%nspden)
   real(dp),intent(in) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(paw_ij_type),intent(in) :: paw_ij(dtset%natom*psps%usepaw)
   type(pawfgrtab_type),intent(inout) :: pawfgrtab(dtset%ntypat*psps%usepaw)
   type(pawrhoij_type),intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type),intent(in) :: pawtab(dtset%ntypat*psps%usepaw)
   real(dp),intent(inout) :: ph1d(2,3*(2*dtset%mgfft+1)*dtset%natom)
   real(dp),intent(inout) :: ph1df(2,3*(2*dtset%mgfft+1)*dtset%natom)
   integer,intent(in) :: pwind(pwind_alloc,2,3)
   real(dp),intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp),intent(in) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp),intent(in) :: rhocore(nfftf)
   real(dp),intent(inout) :: rhog(2,nfftf)
   real(dp),intent(inout) :: rhor(nfftf,dtset%nspden)
   real(dp),intent(in) :: rhore(nfftf,dtset%nspden)
   real(dp),intent(in) :: rhototp(nfftf)
   integer,intent(in) :: symrec(3,3,dtset%nsym)
   real(dp),intent(out) :: synlgr(3,dtset%natom)
   real(dp),intent(inout) :: vhartr(dtset%nfft)
   real(dp),intent(in) :: vpsp(nfftf)
   real(dp),intent(inout) :: vxc(nfftf,dtset%nspden)
   real(dp),intent(inout) :: xccc3d(n3xccc)
   real(dp),intent(inout) :: xred(3,dtset%natom)
   real(dp),intent(out) :: xred_old(3,dtset%natom)
   real(dp),intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp),intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine afterscfloop
 end interface

 interface
  subroutine brdmin(acell,atindx,atindx1,cg,cpus,densymop_gs,dtefield,dtfil,&  
&  dtset,ecore,eigen,hdr,indsym,initialized,irrzon,&  
&  kg,mpi_enreg,mxfh,&  
&  nattyp,nfftf,npwarr,nspinor,nxfh,occ,&  
&  pawang,pawfgr,pawrad,pawrhoij,pawtab,phnons,psps,pwind,pwind_alloc,pwnsfac,resid,results_gs,&  
&  rhog,rhor,rprim,symrec,wffnew,wffnow,vel,wvl,&  
&  xfhist,xred,xred_old,ylm,ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(inout) :: initialized
   integer,intent(in) :: mxfh
   integer,intent(in) :: nfftf
   integer,intent(inout) :: nspinor
   integer,intent(inout) :: nxfh
   integer,intent(in) :: pwind_alloc
   real(dp),intent(in) :: cpus
   type(dens_sym_operator_type),intent(inout) :: densymop_gs
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecore
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   type(results_gs_type),intent(out) :: results_gs
   type(wffile_type),intent(inout) :: wffnew
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_data), intent(inout) :: wvl
   real(dp), intent(inout) :: acell(3)
   real(dp), intent(inout) :: rprim(3,3)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp), intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp), intent(out) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   integer,intent(inout) :: indsym(4,dtset%nsym,dtset%natom)
   integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,dtset%nspden/dtset%nsppol)
   integer, intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   integer, intent(in) :: nattyp(psps%ntypat)
   integer, intent(in) :: npwarr(dtset%nkpt)
   real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type), intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type), intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type), intent(in) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp), intent(inout) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),dtset%nspden/dtset%nsppol)
   integer, intent(in) :: pwind(pwind_alloc,2,3)
   real(dp), intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp), intent(inout) :: rhog(2,nfftf)
   real(dp), intent(inout) :: rhor(nfftf,dtset%nspden)
   integer, intent(inout) :: symrec(3,3,dtset%nsym)
   real(dp), intent(in) :: vel(3,dtset%natom)
   real(dp), intent(inout) :: xfhist(3,dtset%natom+4,2,mxfh)
   real(dp), intent(inout) :: xred(3,dtset%natom)
   real(dp), intent(inout) :: xred_old(3,dtset%natom)
   real(dp), intent(inout) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp), intent(inout) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine brdmin
 end interface

 interface
  subroutine delocint(acell,atindx,atindx1,cg,cpus,densymop_gs,dtefield,dtfil,&  
&  dtset,ecore,eigen,hdr,indsym,initialized,irrzon,&  
&  kg,mpi_enreg,mxfh,&  
&  nattyp,nfftf,npwarr,nspinor,nxfh,occ,&  
&  pawang,pawfgr,pawrad,pawrhoij,pawtab,phnons,psps,pwind,pwind_alloc,pwnsfac,resid,results_gs,&  
&  rhog,rhor,rprim,symrec,wffnew,wffnow,vel,wvl,&  
&  xfhist,xred,xred_old,ylm,ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(inout) :: initialized
   integer,intent(in) :: mxfh
   integer,intent(in) :: nfftf
   integer,intent(inout) :: nspinor
   integer,intent(inout) :: nxfh
   integer,intent(in) :: pwind_alloc
   real(dp),intent(in) :: cpus
   type(dens_sym_operator_type),intent(inout) :: densymop_gs
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecore
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   type(results_gs_type),intent(out) :: results_gs
   type(wffile_type),intent(inout) :: wffnew
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_data), intent(inout) :: wvl
   real(dp), intent(inout) :: acell(3)
   real(dp), intent(inout) :: rprim(3,3)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp), intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp), intent(out) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   integer,intent(inout) :: indsym(4,dtset%nsym,dtset%natom)
   integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,dtset%nspden/dtset%nsppol)
   integer, intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   integer, intent(in) :: nattyp(psps%ntypat)
   integer, intent(in) :: npwarr(dtset%nkpt)
   real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type), intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type), intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type), intent(in) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp), intent(inout) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),dtset%nspden/dtset%nsppol)
   integer, intent(in) :: pwind(pwind_alloc,2,3)
   real(dp), intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp), intent(inout) :: rhog(2,nfftf)
   real(dp), intent(inout) :: rhor(nfftf,dtset%nspden)
   integer, intent(inout) :: symrec(3,3,dtset%nsym)
   real(dp), intent(in) :: vel(3,dtset%natom)
   real(dp), intent(inout) :: xfhist(3,dtset%natom+4,2,mxfh)
   real(dp), intent(inout) :: xred(3,dtset%natom)
   real(dp), intent(inout) :: xred_old(3,dtset%natom)
   real(dp), intent(inout) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp), intent(inout) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine delocint
 end interface

 interface
  subroutine diisRelax(atindx, atindx1, cg, cpus, densymop_gs, dtefield,&  
&  dtfil, dtset, ecore, eigen, hdr, iapp, indsym, initialized,&  
&  irrzon, kg, mpi_enreg, nattyp, nfftf, npwarr, nspinor, occ, pawang,&  
&  pawfgr, pawrad, pawrhoij, pawtab, phnons, psps, pwind, pwind_alloc, pwnsfac,&  
&  resid, results_gs, rhog, rhor, rprimd, symrec,&  
&  wffnew, wffnow, wvl, xred, xred_old, ylm, ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iapp
   integer,intent(inout) :: initialized
   integer,intent(in) :: nfftf
   integer,intent(inout) :: nspinor
   integer,intent(in) :: pwind_alloc
   real(dp),intent(in) :: cpus
   type(dens_sym_operator_type),intent(inout) :: densymop_gs
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecore
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   type(results_gs_type),intent(inout) :: results_gs
   type(wffile_type),intent(inout) :: wffnew
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_data), intent(inout) :: wvl
   real(dp), intent(in) :: rprimd(3,3)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp), intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp), intent(inout) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   integer,intent(inout) :: indsym(4,dtset%nsym,dtset%natom)
   integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,dtset%nspden/dtset%nsppol)
   integer, intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   integer, intent(in) :: nattyp(psps%ntypat)
   integer, intent(in) :: npwarr(dtset%nkpt)
   real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type), intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type), intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type), intent(in) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp), intent(inout) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),dtset%nspden/dtset%nsppol)
   integer, intent(in) :: pwind(pwind_alloc,2,3)
   real(dp), intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp), intent(inout) :: rhog(2,nfftf)
   real(dp), intent(inout) :: rhor(nfftf,dtset%nspden)
   integer, intent(inout) :: symrec(3,3,dtset%nsym)
   real(dp), intent(inout) :: xred(3,dtset%natom)
   real(dp), intent(inout) :: xred_old(3,dtset%natom)
   real(dp), intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp), intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine diisRelax
 end interface

 interface
  subroutine driver(codvsn,cpui,dtfil,dtsets,filnam,filstat,&  
&  mpi_enreg,ndtset,ndtset_alloc,npsp,pspheads,results_out,walli)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ndtset
   integer,intent(in) :: ndtset_alloc
   integer,intent(in) :: npsp
   character(len=6),intent(in) :: codvsn
   real(dp),intent(in) :: cpui
   type(datafiles_type),intent(inout) :: dtfil
   character(len=fnlen),intent(in) :: filstat
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: walli
   character(len=fnlen),intent(in) :: filnam(5)
   type(dataset_type),intent(in) :: dtsets(0:ndtset_alloc)
   type(pspheader_type),intent(in) :: pspheads(npsp)
   type(results_out_type),intent(inout) :: results_out(0:ndtset_alloc)
  end subroutine driver
 end interface

 interface
  subroutine drivergw(codvsn,cpui,dtfil,dtsets,filnam,filstat,&  
&  mpi_enreg,ndtset,ndtset_alloc,npsp,pspheads,results_out,walli)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ndtset
   integer,intent(in) :: ndtset_alloc
   integer,intent(in) :: npsp
   character(len=6),intent(in) :: codvsn
   real(dp),intent(in) :: cpui
   type(datafiles_type),intent(inout) :: dtfil
   character(len=fnlen),intent(in) :: filstat
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: walli
   character(len=fnlen),intent(in) :: filnam(5)
   type(dataset_type),intent(in) :: dtsets(0:ndtset_alloc)
   type(pspheader_type),intent(in) :: pspheads(npsp)
   type(results_out_type),intent(inout) :: results_out(0:ndtset_alloc)
  end subroutine drivergw
 end interface

 interface
  subroutine elpolariz(atindx1,cg,dtefield,dtfil,dtset,etotal,enefield,gprimd,hdr,&  
&  kg,mband,mgfft,mkmem,mpi_enreg,mpw,natom,nattyp,nkpt,&  
&  npwarr,nspinor,nsppol,ntypat,pel,pel_cg,pion,psps,pwind,pwind_alloc,&  
&  pwnsfac,rprimd,ucvol,wffnow,xred)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: mband
   integer,intent(in) :: mgfft
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(in) :: natom
   integer,intent(in) :: nkpt
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: ntypat
   integer,intent(in) :: pwind_alloc
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   real(dp),intent(inout) :: enefield
   real(dp),intent(inout) :: etotal
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pseudopotential_type),intent(in) :: psps
   real(dp),intent(in) :: ucvol
   type(wffile_type),intent(inout) :: wffnow
   real(dp),intent(in) :: gprimd(3,3)
   real(dp),intent(inout) :: pel(3)
   real(dp),intent(in) :: pel_cg(3)
   real(dp),intent(inout) :: pion(3)
   real(dp),intent(in) :: rprimd(3,3)
   integer,intent(in) :: atindx1(natom)
   real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: nattyp(ntypat)
   integer,intent(in) :: npwarr(nkpt)
   integer,intent(in) :: pwind(pwind_alloc,2,3)
   real(dp),intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp),intent(inout) :: xred(3,natom)
  end subroutine elpolariz
 end interface

 interface
  subroutine gstate(acell,codvsn,cpui,dtfil,dtset,iexit,&  
&  mpi_enreg,&  
&  npwtot,nspinor,&  
&  occ,pawang,pawrad,pawtab,psps,results_gs,rprim,vel,walli,xred)
   use defs_basis
   use defs_datatypes
   integer,intent(inout) :: iexit
   integer,intent(inout) :: nspinor
   character(len=6),intent(in) :: codvsn
   real(dp),intent(in) :: cpui
   type(datafiles_type),intent(inout) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(inout) :: pawang
   type(pseudopotential_type),intent(inout) :: psps
   type(results_gs_type),intent(out) :: results_gs
   real(dp),intent(in) :: walli
   real(dp),intent(inout) :: acell(3)
   real(dp),intent(inout) :: rprim(3,3)
   integer,intent(out) :: npwtot(dtset%nkpt)
   real(dp),intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type),intent(inout) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawtab_type),intent(inout) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp),intent(inout) :: vel(3,dtset%natom)
   real(dp),intent(inout) :: xred(3,dtset%natom)
  end subroutine gstate
 end interface

 interface
  subroutine handle_err_netcdf(status)
   integer,intent(in) :: status
  end subroutine handle_err_netcdf
 end interface

 interface
  subroutine loop3dte(blkflg,cg,cgindex,dtfil,dtset,d3lo,&  
&  etotal,gmet,gprimd,gsqcut,gsqcut_eff,&  
&  hdr,kg,kneigh,kptindex,kpt3,kxc,k3xc,mband,mgfft,mkmem,mkmem_max,mk1mem,&  
&  mpert,mpi_enreg,mpw,mvwtk,natom,nfft,nkpt,nkpt3,nkxc,nneigh,nspinor,nsppol,&  
&  npwarr,occ,psps,pwind,&  
&  rfpert,rmet,rprimd,tmpfil,ucvol,xred)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: mband
   integer,intent(in) :: mgfft
   integer,intent(in) :: mk1mem
   integer,intent(in) :: mkmem
   integer,intent(in) :: mkmem_max
   integer,intent(in) :: mpert
   integer,intent(in) :: mpw
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nkpt
   integer,intent(in) :: nkpt3
   integer,intent(in) :: nkxc
   integer,intent(in) :: nneigh
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(inout) :: etotal
   real(dp),intent(in) :: gsqcut
   real(dp),intent(in) :: gsqcut_eff
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pseudopotential_type),intent(in) :: psps
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   real(dp),intent(in) :: rmet(3,3)
   real(dp),intent(in) :: rprimd(3,3)
   character(len=fnlen),intent(in) :: tmpfil(12)
   integer,intent(out) :: blkflg(3,mpert,3,mpert,3,mpert)
   real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   integer,intent(in) :: cgindex(nkpt,nsppol)
   real(dp),intent(out) :: d3lo(2,3,mpert,3,mpert,3,mpert)
   real(dp),intent(in) :: k3xc(nfft)
   integer,intent(in) :: kg(3,mk1mem*mpw)
   integer,intent(in) :: kneigh(30,nkpt)
   real(dp),intent(in) :: kpt3(3,nkpt3)
   integer,intent(in) :: kptindex(2,nkpt3)
   real(dp),intent(in) :: kxc(nfft,nkxc)
   real(dp),intent(in) :: mvwtk(30,nkpt)
   integer,intent(in) :: npwarr(nkpt)
   real(dp),intent(inout) :: occ(mband*nkpt*nsppol)
   integer,intent(in) :: pwind(mpw,nneigh,mkmem)
   integer,intent(in) :: rfpert(3,mpert,3,mpert,3,mpert)
   real(dp),intent(in) :: xred(3,natom)
  end subroutine loop3dte
 end interface

 interface
  subroutine moldyn(acell,amass,atindx,atindx1,cg,cpus,densymop_gs,&  
&  dtefield,dtfil,dtset,ecore,eigen,hdr,indsym,initialized,&  
&  irrzon,kg,mpi_enreg,mxfh,nattyp,nfftf,npwarr,nspinor,nxfh,occ,&  
&  pawang,pawfgr,pawrad,pawrhoij,pawtab,&  
&  phnons,psps,pwind,pwind_alloc,pwnsfac,resid,results_gs,rhog,rhor,rprim,&  
&  symrec,wffnew,wffnow,vel,wvl,xfhist,xred,xred_old,ylm,ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(inout) :: initialized
   integer,intent(in) :: mxfh
   integer,intent(in) :: nfftf
   integer,intent(inout) :: nspinor
   integer,intent(inout) :: nxfh
   integer,intent(in) :: pwind_alloc
   real(dp),intent(in) :: cpus
   type(dens_sym_operator_type),intent(inout) :: densymop_gs
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecore
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   type(results_gs_type),intent(out) :: results_gs
   type(wffile_type),intent(inout) :: wffnew
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_data), intent(inout) :: wvl
   real(dp),intent(inout) :: acell(3)
   real(dp),intent(inout) :: rprim(3,3)
   real(dp),intent(in) :: amass(dtset%natom)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp),intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp),intent(out) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   integer,intent(inout) :: indsym(4,dtset%nsym,dtset%natom)
   integer,intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,dtset%nspden/dtset%nsppol)
   integer,intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   integer,intent(in) :: nattyp(psps%ntypat)
   integer,intent(in) :: npwarr(dtset%nkpt)
   real(dp),intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type),intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type),intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type),intent(in) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp),intent(inout) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),dtset%nspden/dtset%nsppol)
   integer,intent(in) :: pwind(pwind_alloc,2,3)
   real(dp),intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp),intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp),intent(inout) :: rhog(2,nfftf)
   real(dp),intent(inout) :: rhor(nfftf,dtset%nspden)
   integer,intent(inout) :: symrec(3,3,dtset%nsym)
   real(dp),intent(inout) :: vel(3,dtset%natom)
   real(dp),intent(inout) :: xfhist(3,dtset%natom+4,2,mxfh)
   real(dp),intent(inout) :: xred(3,dtset%natom)
   real(dp),intent(inout) :: xred_old(3,dtset%natom)
   real(dp),intent(inout) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp),intent(inout) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine moldyn
 end interface

 interface
  subroutine move(amass,atindx,atindx1,cg,cpus,densymop_gs,dtefield,dtfil,dtset,&  
&  ecore,eigen,hdr,indsym,initialized,irrzon,&  
&  kg,mpi_enreg,&  
&  nattyp,nfftf,npwarr,nspinor,occ,&  
&  pawang,pawfgr,pawrad,pawrhoij,pawtab,&  
&  phnons,psps,pwind,pwind_alloc,pwnsfac,resid,results_gs,rhog,rhor,rprimd,&  
&  symrec,wffnew,wffnow,vel,wvl,xred,xred_old,ylm,ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(inout) :: initialized
   integer,intent(in) :: nfftf
   integer,intent(inout) :: nspinor
   integer,intent(in) :: pwind_alloc
   real(dp),intent(in) :: cpus
   type(dens_sym_operator_type),intent(inout) :: densymop_gs
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecore
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   type(results_gs_type),intent(out) :: results_gs
   type(wffile_type),intent(inout) :: wffnew
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_data), intent(inout) :: wvl
   real(dp), intent(in) :: rprimd(3,3)
   real(dp), intent(in) :: amass(dtset%natom)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp), intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp), intent(out) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   integer,intent(inout) :: indsym(4,dtset%nsym,dtset%natom)
   integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,dtset%nspden/dtset%nsppol)
   integer, intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   integer, intent(in) :: nattyp(psps%ntypat)
   integer, intent(in) :: npwarr(dtset%nkpt)
   real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type), intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type), intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type), intent(in) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp), intent(inout) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),dtset%nspden/dtset%nsppol)
   integer, intent(in) :: pwind(pwind_alloc,2,3)
   real(dp), intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp), intent(inout) :: rhog(2,nfftf)
   real(dp), intent(inout) :: rhor(nfftf,dtset%nspden)
   integer, intent(inout) :: symrec(3,3,dtset%nsym)
   real(dp), intent(inout) :: vel(3,dtset%natom)
   real(dp), intent(inout) :: xred(3,dtset%natom)
   real(dp), intent(inout) :: xred_old(3,dtset%natom)
   real(dp), intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp), intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine move
 end interface

 interface
  subroutine nonlinear(codvsn,dtfil,dtset,etotal,iexit,&  
&  mband,mgfft,mkmem,mpi_enreg,mpw,natom,nfft,nkpt,npwtot,nspden,&  
&  nspinor,nsppol,nsym,occ,pawrad,pawtab,psps,xred)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iexit
   integer,intent(in) :: mband
   integer,intent(in) :: mgfft
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpw
   integer,intent(inout) :: natom
   integer,intent(in) :: nfft
   integer,intent(inout) :: nkpt
   integer,intent(inout) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(inout) :: nsppol
   integer,intent(inout) :: nsym
   character(len=6),intent(in) :: codvsn
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(inout) :: etotal
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pseudopotential_type),intent(inout) :: psps
   integer,intent(out) :: npwtot(nkpt)
   real(dp),intent(inout) :: occ(mband*nkpt*nsppol)
   type(pawrad_type),intent(inout) :: pawrad(psps%ntypat,psps%usepaw)
   type(pawtab_type),intent(inout) :: pawtab(psps%ntypat,psps%usepaw)
   real(dp),intent(inout) :: xred(3,natom)
  end subroutine nonlinear
 end interface

 interface
  subroutine outscfcv(atindx,atindx1,cg,compch_fft,compch_sph,dtfil,dtset,ecut,eigen,etotal,&  
&  fermie,filapp,gmet,gprimd,gsqcut,hdr,kg,&  
&  kssform,mband,mgfftc,mkmem,mpi_enreg,mpsang,mpw,natom,&  
&  nattyp,nfft,ngfft,nhat,nkpt,npwarr,nspden,nspinor,nsppol,nsym,ntypat,n3xccc,occ,&  
&  pawang,pawfgr,pawfgrtab,pawrad,pawrhoij,pawtab,paw_ij,ph1dc,prtvol,psps,rhog,rhor,rmet,rprimd,&  
&  ucvol,usexcnhat,wffnow,vhartr,vtrial,vxc,vxcavg,xccc3d,xred,ylm)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: kssform
   integer,intent(in) :: mband
   integer,intent(in) :: mgfftc
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpsang
   integer,intent(in) :: mpw
   integer,intent(in) :: n3xccc
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nkpt
   integer,intent(in) :: nspden
   integer,intent(inout) :: nspinor
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   integer,intent(in) :: ntypat
   integer,intent(in) :: prtvol
   integer,intent(in) :: usexcnhat
   real(dp),intent(in) :: compch_fft
   real(dp),intent(in) :: compch_sph
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecut
   real(dp),intent(inout) :: etotal
   real(dp),intent(in) :: fermie
   character(len=fnlen),intent(inout) :: filapp
   real(dp),intent(in) :: gsqcut
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type),intent(in) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   real(dp),intent(in) :: ucvol
   real(dp),intent(inout) :: vxcavg
   type(wffile_type),intent(inout) :: wffnow
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   integer,intent(in) :: ngfft(18)
   real(dp),intent(in) :: rmet(3,3)
   real(dp),intent(in) :: rprimd(3,3)
   integer,intent(in) :: atindx(natom)
   integer,intent(in) :: atindx1(natom)
   real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: nattyp(ntypat)
   real(dp),intent(inout) :: nhat(nfft,nspden*psps%usepaw)
   integer,intent(in) :: npwarr(nkpt)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   type(paw_ij_type),intent(in) :: paw_ij(natom)
   type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
   type(pawrad_type),intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type),intent(in) :: pawrhoij(natom*psps%usepaw)
   type(pawtab_type),intent(in) :: pawtab(ntypat*psps%usepaw)
   real(dp),intent(in) :: ph1dc(2,3*(2*mgfftc+1)*natom)
   real(dp),intent(inout) :: rhog(nfft,nspden)
   real(dp),intent(inout) :: rhor(nfft,nspden)
   real(dp),intent(in) :: vhartr(nfft)
   real(dp),intent(inout) :: vtrial(nfft,nsppol)
   real(dp),intent(inout) :: vxc(nfft,nsppol)
   real(dp),intent(in) :: xccc3d(n3xccc)
   real(dp),intent(inout) :: xred(3,natom)
   real(dp),intent(in) :: ylm(mpw*mkmem,mpsang*mpsang*psps%useylm)
  end subroutine outscfcv
 end interface

 interface
  subroutine scfcv(atindx,atindx1,cg,cpus,densymop_gs,dtefield,dtfil,&  
&  dtset,ecore,eigen,hdr,iapp,indsym,initialized,&  
&  irrzon,kg,mpi_enreg,nattyp,nfftf,npwarr,nspinor,occ,&  
&  pawang,pawfgr,pawrad,pawrhoij,pawtab,&  
&  phnons,psps,pwind,pwind_alloc,pwnsfac,resid,results_gs,rhog,rhor,rprimd,&  
&  symrec,wffnew,wffnow,wvl,xred,xred_old,ylm,ylmgr)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iapp
   integer,intent(inout) :: initialized
   integer,intent(in) :: nfftf
   integer,intent(inout) :: nspinor
   integer,intent(in) :: pwind_alloc
   real(dp),intent(in) :: cpus
   type(dens_sym_operator_type),intent(inout) :: densymop_gs
   type(efield_type),intent(inout) :: dtefield
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   real(dp),intent(in) :: ecore
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   type(pawfgr_type) :: pawfgr
   type(pseudopotential_type),intent(in) :: psps
   type(results_gs_type),intent(inout) :: results_gs
   type(wffile_type),intent(inout) :: wffnew
   type(wffile_type),intent(inout) :: wffnow
   type(wvl_data), intent(inout) :: wvl
   real(dp), intent(in) :: rprimd(3,3)
   integer,intent(in) :: atindx(dtset%natom)
   integer,intent(in) :: atindx1(dtset%natom)
   real(dp), intent(inout) :: cg(2,dtset%mpw*nspinor*dtset%mband*dtset%mkmem*dtset%nsppol)
   real(dp), intent(inout) :: eigen(dtset%mband*dtset%nkpt*dtset%nsppol)
   integer,intent(inout) :: indsym(4,dtset%nsym,dtset%natom)
   integer, intent(inout) :: irrzon(dtset%nfft**(1-1/dtset%nsym),2,dtset%nspden/dtset%nsppol)
   integer, intent(in) :: kg(3,dtset%mpw*dtset%mkmem)
   integer, intent(in) :: nattyp(psps%ntypat)
   integer, intent(in) :: npwarr(dtset%nkpt)
   real(dp), intent(inout) :: occ(dtset%mband*dtset%nkpt*dtset%nsppol)
   type(pawrad_type), intent(in) :: pawrad(psps%ntypat*psps%usepaw)
   type(pawrhoij_type), intent(inout) :: pawrhoij(dtset%natom*psps%usepaw)
   type(pawtab_type), intent(in) :: pawtab(psps%ntypat*psps%usepaw)
   real(dp), intent(inout) :: phnons(2,dtset%nfft**(1-1/dtset%nsym),dtset%nspden/dtset%nsppol)
   integer, intent(in) :: pwind(pwind_alloc,2,3)
   real(dp), intent(in) :: pwnsfac(2,pwind_alloc)
   real(dp), intent(out) :: resid(dtset%mband*dtset%nkpt*dtset%nsppol)
   real(dp), intent(inout) :: rhog(2,nfftf)
   real(dp), intent(inout) :: rhor(nfftf,dtset%nspden)
   integer, intent(inout) :: symrec(3,3,dtset%nsym)
   real(dp), intent(inout) :: xred(3,dtset%natom)
   real(dp), intent(inout) :: xred_old(3,dtset%natom)
   real(dp), intent(in) :: ylm(dtset%mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
   real(dp), intent(in) :: ylmgr(dtset%mpw*dtset%mkmem,3,psps%mpsang*psps%mpsang*psps%useylm)
  end subroutine scfcv
 end interface

 interface
  subroutine screening(acell,dtfil,dtset,mpi_enreg,rprim)
   use defs_basis
   use defs_datatypes
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: acell(3)
   real(dp),intent(in) :: rprim(3,3)
  end subroutine screening
 end interface

 interface
  subroutine sigma(acell,dtfil,dtset,mpi_enreg,rprim)
   use defs_basis
   use defs_datatypes
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(inout) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: acell(3)
   real(dp),intent(in) :: rprim(3,3)
  end subroutine sigma
 end interface

 interface
  subroutine testfi(etotal,filnam,filstat,fred,natom,strten,xred)
   use defs_basis
   integer,intent(in) :: natom
   real(dp),intent(in) :: etotal
   character(len=fnlen),intent(in) :: filstat
   character(len=fnlen),intent(in) :: filnam(5)
   real(dp),intent(in) :: strten(6)
   real(dp),intent(in) :: fred(3,natom)
   real(dp),intent(in) :: xred(3,natom)
  end subroutine testfi
 end interface

 interface
  subroutine timana(mpi_enreg,natom,nband,ndtset,nfft,nkpt,npwtot,nsppol,timopt)
   use defs_datatypes
   integer,intent(in) :: natom
   integer,intent(in) :: ndtset
   integer,intent(in) :: nfft
   integer,intent(in) :: nkpt
   integer,intent(in) :: nsppol
   integer,intent(in) :: timopt
   type(MPI_type),intent(inout) :: mpi_enreg
   integer,intent(in) :: nband(nkpt*nsppol)
   integer,intent(in) :: npwtot(nkpt)
  end subroutine timana
 end interface

 interface
  subroutine vtorhotf(densymop_gs,dtfil,dtset,ek,enl,entropy,fermie,grnl,&  
&  irrzon,mpi_enreg,natom,nfft,nspden,nsppol,nsym,phnons,rhog,rhor,ucvol,vtrial)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nspden
   integer,intent(in) :: nsppol
   integer,intent(in) :: nsym
   type(dens_sym_operator_type),intent(in) :: densymop_gs
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   real(dp),intent(out) :: ek
   real(dp),intent(out) :: enl
   real(dp),intent(out) :: entropy
   real(dp),intent(out) :: fermie
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   real(dp),intent(out) :: grnl(3*natom)
   integer,intent(in) :: irrzon((dtset%ngfft(1)*dtset%ngfft(1)*dtset%ngfft(1))**(1-1/nsym), &
   &         2,nspden/nsppol)
   real(dp),intent(in) :: phnons(2,(dtset%ngfft(1)*dtset%ngfft(1)*dtset%ngfft(1))**(1-1/nsym), &
   &         nspden/nsppol)
   real(dp),intent(inout) :: rhog(2,nfft)
   real(dp),intent(inout) :: rhor(nfft,nspden)
   real(dp),intent(in) :: vtrial(nfft,nspden)
  end subroutine vtorhotf
 end interface

 interface
  function zfermim12(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermim12
  end function zfermim12
 end interface

 interface
  function zfermi12(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermi12
  end function zfermi12
 end interface

 interface
  function zfermi1(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermi1
  end function zfermi1
 end interface

 interface
  function zfermi32(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermi32
  end function zfermi32
 end interface

 interface
  function zfermi2(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermi2
  end function zfermi2
 end interface

 interface
  function zfermi52(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermi52
  end function zfermi52
 end interface

 interface
  function zfermi3(xx)
   use defs_basis
   real(dp), intent(in) :: xx
   real(dp) :: zfermi3
  end function zfermi3
 end interface

 interface
  function ifermim12(ff)
   use defs_basis
   real(dp), intent(in) :: ff
   real(dp) :: ifermim12
  end function ifermim12
 end interface

 interface
  function ifermi12(ff)
   use defs_basis
   real(dp), intent(in) :: ff
   real(dp) :: ifermi12
  end function ifermi12
 end interface

 interface
  function ifermi32(ff)
   use defs_basis
   real(dp), intent(in) :: ff
   real(dp) :: ifermi32
  end function ifermi32
 end interface

 interface
  function ifermi52(ff)
   use defs_basis
   real(dp), intent(in) :: ff
   real(dp) :: ifermi52
  end function ifermi52
 end interface

 interface
  function fp12a1 (x)
   use defs_basis
   real(dp) :: fp12a1
   real(dp)  :: x
  end function fp12a1
 end interface

 interface
  function fp32a1 (x)
   use defs_basis
   real(dp) :: fp32a1
   real(dp)  :: x
  end function fp32a1
 end interface

 interface
  function xp12a1 (y)
   use defs_basis
   real(dp) :: xp12a1
   real(dp)  :: y
  end function xp12a1
 end interface

 interface
  function fm12a1 (x)
   use defs_basis
   real(dp) :: fm12a1
   real(dp)  :: x
  end function fm12a1
 end interface

 interface
  subroutine fm12a1t (cktf,rtnewt,tsmear,vtrial,rhor_middx,rhor_mid,&  
&  nfft)
   use defs_basis
   integer :: nfft
   real(dp)  :: cktf
   real(dp)  :: rtnewt
   real(dp)  :: tsmear
   real(dp) :: rhor_mid(nfft)
   real(dp) :: rhor_middx(nfft)
   real(dp) :: vtrial(nfft)
  end subroutine fm12a1t
 end interface

 interface
  subroutine wannier(dtfil,dtset,iexit,mband,mpi_enreg,nkpt,nsppol)
   use defs_datatypes
   integer,intent(in) :: iexit
   integer,intent(in) :: mband
   integer,intent(in) :: nkpt
   integer,intent(in) :: nsppol
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
  end subroutine wannier
 end interface

 interface
  subroutine write_header_moldynnetcdf(dtfil, dtset, natom, ncoord, nelt_strten)
   use defs_datatypes
   integer,intent(in) :: natom
   integer,intent(in) :: ncoord
   integer,intent(in) :: nelt_strten
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
  end subroutine write_header_moldynnetcdf
 end interface

 interface
  subroutine write_moldynvaluenetcdf(amass, itime1, dtfil, dtset, Epot, Ekin,  nbat,&  
&  nbdir, nb1, pos, cel, stress, rprimd, ucvol)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: itime1
   integer,intent(in) :: nb1
   integer,intent(in) :: nbat
   integer,intent(in) :: nbdir
   real(dp),intent(in) :: Ekin
   real(dp),intent(in) :: Epot
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(in) :: amass(nbat)
   real(dp),intent(in) :: cel(nbdir,nbat)
   real(dp),intent(in) :: pos(nbdir,nbat)
   real(dp),intent(in) :: stress(nb1)
  end subroutine write_moldynvaluenetcdf
 end interface

end module interfaces_21drive
!!***
