/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _update_h
#define _update_h

#ifdef update_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Main loop of the program. Returns when there are no more viewers.
 * @param frame_rate Requested frame rate on each viewer (Hz).
 */
EXTERN void update_loop(int frame_rate);

/**
 * Update the variable curTime with the current time in seconds with the 0 set
 * as the time the program was started (this to prevent the number to become too
 * large, so loosing in precision). This clock is monotonic, that is curTime
 * never decreases.
 */
EXTERN void update_simulationTime(void);

#undef EXTERN
#endif
