#ifndef	__ACR38IOCTRL_H__
#define	__ACR38IOCTRL_H__

typedef enum
{
	ACR38_IO_CTRL_SET_CARD_TYPE = 0x0
} ACR38_IO_CTRL_TYPE;

/****** I/O Control Code + Data Structure ******/

/* ACR38_IO_CTRL_SET_CARD_TYPE */
typedef enum
{
	READER_CARD_TYPE_MCU			= 0x0,
	READER_CARD_TYPE_1K_16K			= 0x1,
	READER_CARD_TYPE_32K_1024K		= 0x2,
	READER_CARD_TYPE_AT88SC153		= 0x03,
	READER_CARD_TYPE_AT88SC1608		= 0x04,
	READER_CARD_TYPE_SLE4418_4428	= 0x05,
	READER_CARD_TYPE_SLE4432_4442	= 0x06,
	READER_CARD_TYPE_MCU_T0			= 0x0C,
	READER_CARD_TYPE_MCU_T1			= 0x0D
} ACR38_READER_CARD_TYPE, *PACR38_READER_CARD_TYPE;

typedef struct
{
	ACR38_READER_CARD_TYPE	type;
} ACR38_SET_CARD_TYPE_DATA, *PACR38_SET_CARD_TYPE_DATA
__attribute__ ((packed));

/****** I/O Control Code Common Structure ******/
typedef struct
{
	ACR38_IO_CTRL_TYPE	type;
	union
	{
		ACR38_SET_CARD_TYPE_DATA	setCardTypeData;
	};
} ACR38_IO_CTRL, *PACR38_IO_CTRL
__attribute__ ((packed));

#endif	/* __ACR38IOCTRL_H__ */
