/*
 *       File name:  aghermann/ui/globals.cc
 *         Project:  Aghermann
 *          Author:  Andrei Zavada <johnhommer@gmail.com>
 * Initial version:  2013-08-10
 *
 *         Purpose:  global UI-related variables
 *
 *         License:  GPL
 */

#include <gtk/gtk.h>
#include "project_strings.h"
#include "globals.hh"

using namespace std;
using namespace agh::ui::global;

char    agh::ui::global::buf[AGH_BUF_SIZE];

GdkDevice
        *agh::ui::global::client_pointer;

UniqueApp
        *agh::ui::global::unique_app;

GtkWindow
        *agh::ui::global::main_window;

double  agh::ui::global::hdpmm,
        agh::ui::global::vdpmm;


// unique

void
agh::ui::global::
set_unique_app_window( GtkWindow* w)
{
        unique_app_watch_window(
                unique_app,
                main_window = w);
}

// own init

int
agh::ui::global::
prepare_for_expdesign()
{
      // tell me what they are
        client_pointer =
                gdk_device_manager_get_client_pointer(
                        gdk_display_get_device_manager( gdk_display_get_default()));

        {
                auto scr = gdk_screen_get_default();

                hdpmm = (double)gdk_screen_get_width ( scr) / gdk_screen_get_width_mm ( scr);
                vdpmm = (double)gdk_screen_get_height( scr) / gdk_screen_get_height_mm( scr);
                gdk_screen_set_resolution( scr, (hdpmm + vdpmm)/2);
        }

        GResource
                *gresource
                = g_resource_load(
                        PACKAGE_DATADIR "/" PACKAGE "/" AGH_UI_GRESOURCE_FILE,
                        NULL);
        if ( !gresource ) {
                fprintf( stderr, "Bad or missing " PACKAGE_DATADIR "/" PACKAGE "/" AGH_UI_GRESOURCE_FILE);
                return -1;
        }
        g_resources_register( gresource);

        return 0;
}




// Local Variables:
// Mode: c++
// indent-tabs-mode: nil
// tab-width: 8
// c-basic-offset: 8
// End:

