#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Ansible module to manage CheckPoint Firewall (c) 2019
#
# Ansible is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ansible is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <http://www.gnu.org/licenses/>.
#

from __future__ import (absolute_import, division, print_function)

__metaclass__ = type

ANSIBLE_METADATA = {'metadata_version': '1.1',
                    'status': ['preview'],
                    'supported_by': 'community'}

DOCUMENTATION = """
---
module: cp_mgmt_set_gateway_global_use
short_description: Enable or disable global usage on a specific target.
description:
  - Enable or disable global usage on a specific target.
  - This command is available only after logging in to the System Data domain
  - All operations are performed over Web Services API.
version_added: "6.0.0"
author: "Eden Brillant (@chkp-edenbr)"
options:
  enabled:
    description:
      - Indicates whether global use is enabled on the target.
    type: bool
    required: True
  target:
    description:
      - On what target to execute this command. Target may be identified by its object name, or object unique identifier.
    type: str
    required: True
extends_documentation_fragment: check_point.mgmt.checkpoint_commands
"""

EXAMPLES = """
- name: set-gateway-global-use
  cp_mgmt_set_gateway_global_use:
    enabled: true
    target: vpn_gw
"""

RETURN = """
cp_mgmt_set_gateway_global_use:
  description: The checkpoint set-gateway-global-use output.
  returned: always.
  type: dict
"""

from ansible.module_utils.basic import AnsibleModule
from ansible_collections.check_point.mgmt.plugins.module_utils.checkpoint import checkpoint_argument_spec_for_commands, api_command


def main():
    argument_spec = dict(
        enabled=dict(type='bool', required=True),
        target=dict(type='str', required=True)
    )
    argument_spec.update(checkpoint_argument_spec_for_commands)

    module = AnsibleModule(argument_spec=argument_spec)

    command = "set-gateway-global-use"

    result = api_command(module, command)
    module.exit_json(**result)


if __name__ == '__main__':
    main()
