// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ModelBuilder_h__
#define __ModelBuilder_h__

#ifdef ACMODEL
#include "Elements.h"
#else
#include "JoinPointModel.h"
#endif
#include "TransformInfo.h"

namespace Puma {
  class CTranslationUnit;
  class CSemDatabase;
  class CStructure;
  class CScopeInfo;
  class ACAspectInfo;
  class ACIntroductionInfo;
  class ACSliceInfo;
  class ErrorStream;
  class VerboseMgr;
}
using namespace Puma;

class ACConfig;

struct AccessInfo {
  CAttributeInfo *_info;
  CTree *_tree;
  AccessInfo () {}
  AccessInfo (CAttributeInfo *info, CTree *tree) :
    _info (info), _tree (tree) {}
  
};

#ifdef ACMODEL
/* helper classes to merge the TI_ classes into the JPL_ classes, i.e. to
 * extend the join point model elements by transformation infos
 */
 
class TU_Type : public ACM_Type, public TI_Type {
public:
  TU_Type () : ACM_Type () { transform_info (this); }
  ~TU_Type () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Namespace : public ACM_Namespace, public TI_Namespace {
public:
  TU_Namespace () : ACM_Namespace () { transform_info (this); }
  ~TU_Namespace () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Class : public ACM_Class, public TI_Class {
public:
  TU_Class () : ACM_Class () { transform_info (this); }
  ~TU_Class () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Aspect : public ACM_Aspect, public TI_Aspect {
public:
  TU_Aspect () : ACM_Aspect () { transform_info (this); }
  ~TU_Aspect () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Function : public ACM_Function, public TI_Function {
public:
  TU_Function () : ACM_Function () { transform_info (this); }
  ~TU_Function () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_AdviceCode : public ACM_AdviceCode, public TI_AdviceCode {
public:
  TU_AdviceCode () : ACM_AdviceCode () { transform_info (this); }
  ~TU_AdviceCode () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_ClassSlice : public ACM_ClassSlice, public TI_ClassSlice {
public:
  TU_ClassSlice () : ACM_ClassSlice () { transform_info (this); }
  ~TU_ClassSlice () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_MethodCall : public ACM_Call, public TI_MethodCall {
public:
  TU_MethodCall () { transform_info (this); }
  ~TU_MethodCall () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Method : public ACM_Execution, public TI_Method {
public:
  TU_Method () { transform_info (this); }
  ~TU_Method () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Construction : public ACM_Construction, public TI_Construction {
public:
  TU_Construction () { transform_info (this); }
  ~TU_Construction () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Destruction : public ACM_Destruction, public TI_Destruction {
public:
  TU_Destruction () { transform_info (this); }
  ~TU_Destruction () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Introduction : public ACM_Introduction, public TI_Introduction {
public:
  TU_Introduction () { transform_info (this); }
  ~TU_Introduction () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_Order : public ACM_Order, public TI_Order {
public:
  TU_Order () { transform_info (this); }
  ~TU_Order () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

class TU_PointcutExpr : public ACM_PointcutExpr, public TI_PointcutExpr {
public:
  TU_PointcutExpr () { transform_info (this); }
  ~TU_PointcutExpr () { transform_info (0); }
  virtual ModelNode &jpl () { return *this; }
};

#endif

class ModelBuilder : public 
#ifdef ACMODEL
ProjectModel
#else
JoinPointModel
#endif
{

  VerboseMgr &_vm;
  ErrorStream &_err;
  ACConfig &_conf;
#ifdef ACMODEL
  ACM_TUnit *_tunit_file;
#else
  File *_tunit_file;
#endif
  int _phase;
  CSemDatabase *_db;

  // map needed to check if a file is already known
#ifdef ACMODEL
  typedef map<Unit*, ACM_File*> FileMap;
#else
  typedef map<Unit*, File*> FileMap;
#endif
  typedef FileMap::value_type FileMapPair;
  FileMap _file_map;
  int _tunit_len;

  // TODO: temporary solution
  list<AccessInfo> _access_infos;
  
  int _time;

  void build (CTranslationUnit& tunit);
#ifdef ACMODEL
  void build (CStructure &structure, ACM_Name *jpl = 0);
  void advice_infos (ACM_Aspect *jpl_aspect, ACAspectInfo *acai);
  void check (ACM_Aspect *jpl_aspect, ACIntroductionInfo *acii, ACM_Introduction *intro);
#else
  void build (CStructure &structure, JPL_Name *jpl = 0);
  void advice_infos (JPL_Aspect *jpl_aspect, ACAspectInfo *acai);
  void check (JPL_Aspect *jpl_aspect, ACIntroductionInfo *acii, JPL_Introduction *intro);
#endif
  
  // determine a model element filename for a unit
  string model_filename (FileUnit *unit);
  
  // get the modification time of a file (UNIX Epoch value)
  long modification_time (FileUnit *unit);

public:
  ModelBuilder (VerboseMgr &vm, ErrorStream &err, ACConfig &conf) :
    _vm (vm), _err (err), _conf (conf), _phase (0) {}
  void set_db (CSemDatabase *db) { _db = db; }
  CSemDatabase *get_db () const { return _db; }
  void setup_phase1 (CTranslationUnit& tunit, int tunit_len);
  void setup_phase2 (CTranslationUnit& tunit, list<CTree*> &ah_trees);
  bool is_valid_model_class (CClassInfo *ci) const;
  bool is_intro_target (CClassInfo *ci) const;
  bool is_valid_model_function (CFunctionInfo *fi) const;
  bool is_valid_model_namespace (CNamespaceInfo *ni) const;

  bool inside_template (CScopeInfo *scope) const;
  bool inside_template_instance (CScopeInfo *scope) const;

  // create a type in the join point model from a Puma node
  TU_Type *register_type (CTypeInfo *ti);

#ifdef ACMODEL
  // get the translation unit as a model object
  ACM_TUnit *tunit_file () const { return _tunit_file; }

  // create a function in the join point model from a Puma node
  TU_Function *register_function (CFunctionInfo *fi, ACM_Name *parent = 0);
  
  // create a class slice in the join point model from a Puma node
  TU_ClassSlice *register_class_slice (ACSliceInfo *acsi, ACM_Name *parent = 0);

  // create a class in the join point model from a Puma node
  TU_Class *register_class (CClassInfo *ci, ACM_Name *parent = 0);

  // create an aspect in the join point model from a Puma node
  TU_Aspect *register_aspect (ACAspectInfo *ai, ACM_Name *parent = 0);

  // create a Namespace in the join point model from a Puma node
  TU_Namespace *register_namespace (CNamespaceInfo *ni, ACM_Name *parent = 0);

  // create a new call join point in the join point model
  TU_MethodCall *register_call (CFunctionInfo *called, CT_Call *call_node,
    CObjectInfo *caller, int local_id);

  // create a new execution join point
  TU_Method *register_execution (ACM_Function *ef);
  
  // create a new construction join point
  TU_Construction *register_construction (ACM_Function *cf);
  
  // create a new construction join point
  TU_Destruction *register_destruction (ACM_Function *df);
  
  // TODO: temporary solution for dac++
  void register_attr_access (CAttributeInfo *attr, CTree *node);

  // register the scope of a given element
  ACM_Name *register_scope (CObjectInfo *obj);
  
  // extended types...
  // factory methods that remember all objects of this model
  virtual TU_Type *newType() { return remember (new TU_Type, JPTI_Type); }
  virtual TU_Namespace *newNamespace() { return remember (new TU_Namespace, JPTI_Namespace); }
  virtual TU_Function *newFunction() { return remember (new TU_Function, JPTI_Function); }
  virtual TU_Class *newClass() { return remember (new TU_Class, JPTI_Class); }
  virtual TU_ClassSlice *newClassSlice() { return remember (new TU_ClassSlice, JPTI_ClassSlice); }
  virtual TU_MethodCall *newCall() { return remember (new TU_MethodCall, JPTI_Call); }
  virtual TU_Method *newExecution() { return remember (new TU_Method, JPTI_Execution); }
  virtual TU_Construction *newConstruction() { return remember (new TU_Construction, JPTI_Construction); }
  virtual TU_Destruction *newDestruction() { return remember (new TU_Destruction, JPTI_Destruction); }
  virtual TU_PointcutExpr *newPointcutExpr() { return remember (new TU_PointcutExpr, JPTI_PointcutExpr); }
  virtual TU_AdviceCode *newAdviceCode() { return remember (new TU_AdviceCode, JPTI_AdviceCode); }
  virtual TU_Introduction *newIntroduction() { return remember (new TU_Introduction, JPTI_Introduction); }
  virtual TU_Order *newOrder() { return remember (new TU_Order, JPTI_Order); }
  virtual TU_Aspect *newAspect() { return remember (new TU_Aspect, JPTI_Aspect); }

#else
  // get the translation unit as a model object
  File *tunit_file () const { return _tunit_file; }

  // create a function in the join point model from a Puma node
  TU_Function *register_function (CFunctionInfo *fi, JPL_Name *parent = 0);
  
  // create a class slice in the join point model from a Puma node
  TU_ClassSlice *register_class_slice (ACSliceInfo *acsi, JPL_Name *parent = 0);

  // create a class in the join point model from a Puma node
  TU_Class *register_class (CClassInfo *ci, JPL_Name *parent = 0);

  // create an aspect in the join point model from a Puma node
  TU_Aspect *register_aspect (ACAspectInfo *ai, JPL_Name *parent = 0);

  // create a Namespace in the join point model from a Puma node
  TU_Namespace *register_namespace (CNamespaceInfo *ni, JPL_Name *parent = 0);

  // create a new call join point in the join point model
  TU_MethodCall *register_call (CFunctionInfo *called, CT_Call *call_node,
    CObjectInfo *caller, int local_id);

  // create a new execution join point
  TU_Method *register_execution (JPL_Function *ef);
  
  // create a new construction join point
  TU_Construction *register_construction (JPL_Function *cf);
  
  // create a new construction join point
  TU_Destruction *register_destruction (JPL_Function *df);
  
  // TODO: temporary solution for dac++
  void register_attr_access (CAttributeInfo *attr, CTree *node);

  // register the scope of a given element
  JPL_Name *register_scope (CObjectInfo *obj);
#endif

  // return the name of the scope of an object
  static string scope_name (CObjectInfo *oi);
  
  // return the scope of an object
  static CScopeInfo *scope_obj (CObjectInfo *oi);

  // add the source location to a model element by using a given CObjectInfo
#ifdef ACMODEL
  void add_source_loc (ACM_Any *name, CObjectInfo *obj, XSourceLocKind kind = XSLK_NONE) {
#else
  void add_source_loc (JoinPointLoc *name, CObjectInfo *obj, SourceLocKind kind = SLK_NONE) {
#endif
    add_source_loc (name, obj->Tree (), kind);
  }

  // add the source location to a model element by using the syntax tree node
#ifdef ACMODEL
  void add_source_loc (ACM_Any *name, CTree *tree, XSourceLocKind kind = XSLK_NONE);
#else
  void add_source_loc (JoinPointLoc *name, CTree *tree, SourceLocKind kind = SLK_NONE);
#endif  
  // determine the file unit, which contains a specific syntax (sub-)tree
  FileUnit *source_unit (CTree *tree);
  
  // TODO: temporary solution
  const list<AccessInfo> &access_infos () const { return _access_infos; }
};

#endif
