/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import org.aspectj.internal.tools.build.Module;
import org.aspectj.internal.tools.build.Util;

public class ProductModule {
    private static final String DIST = "dist";
    public final File productDir;
    public final File replaceFile;
    public final String relativePath;
    public final Module module;
    public final boolean assembleAll;

    public ProductModule(File productDir, File replaceFile, Module module, boolean assembleAll) {
        this.replaceFile = replaceFile;
        this.module = module;
        this.productDir = productDir;
        this.assembleAll = assembleAll;
        Util.iaxIfNull(module, "module");
        Util.iaxIfNotCanReadDir(productDir, "productDir");
        Util.iaxIfNotCanReadFile(replaceFile, "replaceFile");
        String productDirPath = productDir.getAbsolutePath();
        String replaceFilePath = replaceFile.getAbsolutePath();
        if (!replaceFilePath.startsWith(productDirPath)) {
            String m = "\"" + replaceFilePath + "\" does not start with \"" + productDirPath + "\"";
            throw new IllegalArgumentException(m);
        }
        if (!(replaceFilePath = replaceFilePath.substring(1 + productDirPath.length())).startsWith(DIST)) {
            String m = "\"" + replaceFilePath + "\" does not start with \"" + DIST + "\"";
            throw new IllegalArgumentException(m);
        }
        this.relativePath = replaceFilePath.substring(1 + DIST.length());
    }

    public String toString() {
        return "" + this.module + " for " + this.productDir;
    }
}

