/*
    serialport library C++ wrapper

    The MIT License (MIT)

    Copyright (c) 2013-2015 Frédéric Meslin, Florent Touchard
    Email: fredericmeslin@hotmail.com
    Website: www.fredslab.net
    Twitter: @marzacdev

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef _SERIALPORT_HPP_
#define _SERIALPORT_HPP_

#include "serialport.h"

class SerialPort {
    private:
        SERIALPORT_HANDLE_TYPE handle;
    protected:
        SerialPort(SERIALPORT_HANDLE_TYPE handle) : handle(handle) {}
        void close() {serialportClose(handle);}
    public:
        virtual ~SerialPort() {close();}
        bool setBaudrate(int baudrate) {return serialportSetBaudrate(handle, baudrate);}
        int write(const char * buffer, size_t len) {return serialportWrite(handle, buffer, len);}
        int read(char * buffer, size_t len, unsigned int timeout_ms) {return serialportRead(handle, buffer, len, timeout_ms);}
        friend class SerialPortController;
};


class SerialPortController {
    private:
        inline static SerialPortController * singleton_ = 0;
        SerialPortController() {serialportEnumerate();}
    public:
        static SerialPortController & singleton() {
            if (singleton_==0) singleton_ = new SerialPortController();
            return * singleton_;
        }
        virtual ~SerialPortController() {serialportTerminate();}
        
        int enumerate() {return serialportEnumerate();}
        int getNoPorts() {return serialportGetNoPorts();}
        const char * getPortName(int index) {return serialportGetPortName(index);}
        const char * getInternalName(int index) {return serialportGetInternalName(index);}
        int findPort(const char * name) {return serialportFindPort(name);}
        SerialPort * open(int index, int baudrate) {
            SERIALPORT_HANDLE_TYPE handle;
            handle = serialportOpen(index, baudrate);
            if (handle == SERIALPORT_HANDLE_INVALID) return 0;
            return new SerialPort(handle);
        }
        SerialPort * open(const char * name, int baudrate) {
            return open(findPort(name), baudrate);
        }
};



#endif
