<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2015                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2015
 *
 * Generated from xml/schema/CRM/Contribute/Product.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Contribute_DAO_Product extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_product';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Required product/premium name
   *
   * @var string
   */
  public $name;
  /**
   * Optional description of the product/premium.
   *
   * @var text
   */
  public $description;
  /**
   * Optional product sku or code.
   *
   * @var string
   */
  public $sku;
  /**
   * Store comma-delimited list of color, size, etc. options for the product.
   *
   * @var text
   */
  public $options;
  /**
   * Full or relative URL to uploaded image - fullsize.
   *
   * @var string
   */
  public $image;
  /**
   * Full or relative URL to image thumbnail.
   *
   * @var string
   */
  public $thumbnail;
  /**
   * Sell price or market value for premiums. For tax-deductible contributions, this will be stored as non_deductible_amount in the contribution record.
   *
   * @var float
   */
  public $price;
  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;
  /**
   * FK to Financial Type.
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * Minimum contribution required to be eligible to select this premium.
   *
   * @var float
   */
  public $min_contribution;
  /**
   * Actual cost of this product. Useful to determine net return from sale or using this as an incentive.
   *
   * @var float
   */
  public $cost;
  /**
   * Disabling premium removes it from the premiums_premium join table below.
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Rolling means we set start/end based on current day, fixed means we set start/end for current year or month
   (e.g. 1 year + fixed -> we would set start/end for 1/1/06 thru 12/31/06 for any premium chosen in 2006)
   *
   * @var string
   */
  public $period_type;
  /**
   * Month and day (MMDD) that fixed period type subscription or membership starts.
   *
   * @var int
   */
  public $fixed_period_start_day;
  /**
   *
   * @var string
   */
  public $duration_unit;
  /**
   * Number of units for total duration of subscription, service, membership (e.g. 12 Months).
   *
   * @var int
   */
  public $duration_interval;
  /**
   * Frequency unit and interval allow option to store actual delivery frequency for a subscription or service.
   *
   * @var string
   */
  public $frequency_unit;
  /**
   * Number of units for delivery frequency of subscription, service, membership (e.g. every 3 Months).
   *
   * @var int
   */
  public $frequency_interval;
  /**
   * class constructor
   *
   * @return civicrm_product
   */
  function __construct()
  {
    $this->__table = 'civicrm_product';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'financial_type_id', 'civicrm_financial_type', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Product ID') ,
          'required' => true,
        ) ,
        'product_name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Product Name') ,
          'description' => 'Required product/premium name',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'export' => true,
          'where' => 'civicrm_product.name',
          'headerPattern' => '',
          'dataPattern' => '',
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Description') ,
          'description' => 'Optional description of the product/premium.',
        ) ,
        'sku' => array(
          'name' => 'sku',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('SKU') ,
          'description' => 'Optional product sku or code.',
          'maxlength' => 50,
          'size' => CRM_Utils_Type::BIG,
          'export' => true,
          'where' => 'civicrm_product.sku',
          'headerPattern' => '',
          'dataPattern' => '',
        ) ,
        'options' => array(
          'name' => 'options',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Options') ,
          'description' => 'Store comma-delimited list of color, size, etc. options for the product.',
        ) ,
        'image' => array(
          'name' => 'image',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Image') ,
          'description' => 'Full or relative URL to uploaded image - fullsize.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'thumbnail' => array(
          'name' => 'thumbnail',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Thumbnail') ,
          'description' => 'Full or relative URL to image thumbnail.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'price' => array(
          'name' => 'price',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Price') ,
          'description' => 'Sell price or market value for premiums. For tax-deductible contributions, this will be stored as non_deductible_amount in the contribution record.',
          'precision' => array(
            20,
            2
          ) ,
        ) ,
        'currency' => array(
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Currency') ,
          'description' => '3 character string, value from config setting or input via user.',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'numeric_code',
          )
        ) ,
        'financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type') ,
          'description' => 'FK to Financial Type.',
          'default' => 'NULL',
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'min_contribution' => array(
          'name' => 'min_contribution',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Minimum Contribution') ,
          'description' => 'Minimum contribution required to be eligible to select this premium.',
          'precision' => array(
            20,
            2
          ) ,
        ) ,
        'cost' => array(
          'name' => 'cost',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Cost') ,
          'description' => 'Actual cost of this product. Useful to determine net return from sale or using this as an incentive.',
          'precision' => array(
            20,
            2
          ) ,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Active') ,
          'description' => 'Disabling premium removes it from the premiums_premium join table below.',
          'required' => true,
        ) ,
        'period_type' => array(
          'name' => 'period_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Period Type') ,
          'description' => 'Rolling means we set start/end based on current day, fixed means we set start/end for current year or month
      (e.g. 1 year + fixed -> we would set start/end for 1/1/06 thru 12/31/06 for any premium chosen in 2006) ',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'rolling',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::periodType',
          )
        ) ,
        'fixed_period_start_day' => array(
          'name' => 'fixed_period_start_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Fixed Period Start Day') ,
          'description' => 'Month and day (MMDD) that fixed period type subscription or membership starts.',
          'default' => '0101',
        ) ,
        'duration_unit' => array(
          'name' => 'duration_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Duration Unit') ,
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'year',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::getPremiumUnits',
          )
        ) ,
        'duration_interval' => array(
          'name' => 'duration_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Duration Interval') ,
          'description' => 'Number of units for total duration of subscription, service, membership (e.g. 12 Months).',
        ) ,
        'frequency_unit' => array(
          'name' => 'frequency_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Frequency Unit') ,
          'description' => 'Frequency unit and interval allow option to store actual delivery frequency for a subscription or service.',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'month',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::getPremiumUnits',
          )
        ) ,
        'frequency_interval' => array(
          'name' => 'frequency_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Frequency Interval') ,
          'description' => 'Number of units for delivery frequency of subscription, service, membership (e.g. every 3 Months).',
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'id',
        'name' => 'product_name',
        'description' => 'description',
        'sku' => 'sku',
        'options' => 'options',
        'image' => 'image',
        'thumbnail' => 'thumbnail',
        'price' => 'price',
        'currency' => 'currency',
        'financial_type_id' => 'financial_type_id',
        'min_contribution' => 'min_contribution',
        'cost' => 'cost',
        'is_active' => 'is_active',
        'period_type' => 'period_type',
        'fixed_period_start_day' => 'fixed_period_start_day',
        'duration_unit' => 'duration_unit',
        'duration_interval' => 'duration_interval',
        'frequency_unit' => 'frequency_unit',
        'frequency_interval' => 'frequency_interval',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['product'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['product'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
