/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Julien 'Lta' BALLET <contact@lta.io>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2018
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: libdsm.h 2986 2018-01-26 00:26:30Z brachman $
 */

#ifndef __LIBDSM_H_
#define __LIBDSM_H_

#ifndef MAYBE_UNUSED
#define MAYBE_UNUSED   __attribute__ ((__unused__))
#endif

#define LIBDSM_VERSION_CURRENT  0
#define LIBDSM_VERSION_REVISION 2
#define LIBDSM_VERSION_AGE      7

#ifdef ORIG
/*
 * The original ABI versioning scheme...
 */
#define LIBDSM_VERSION_CURRENT  3
#define LIBDSM_VERSION_REVISION 1
#define LIBDSM_VERSION_AGE      0
#endif

#include "libdsm/netbios_ns.h"
#include "libdsm/netbios_defs.h"
#include "libdsm/smb_types.h"
#include "libdsm/smb_session.h"
#include "libdsm/smb_share.h"
#include "libdsm/smb_file.h"
#include "libdsm/smb_stat.h"
#include "libdsm/smb_dir.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int local_ntlm_auth_libdsm(char *username, char *password, char *aux,
								  int smb_port, char *smb_server,
								  char *smb_domain, char *smb_workgroup,
								  int *is_guest, char **errmsg);
extern char *libdsm_version_string(void);

#ifdef __cplusplus
}
#endif

#endif
