﻿/* Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com */

using Db4objects.Db4o.Internal.Caching;
using Db4objects.Db4o.IO;

namespace Db4odoc.Storage
{
    class FullLRUCachingStorage : CachingStorage
    {
        private int _pageCount = 64;

        public FullLRUCachingStorage(IStorage storage)
            : base(storage)
        {

        }

        public FullLRUCachingStorage(IStorage storage, int pageCount, int pageSize)
            : base(storage, pageCount, pageSize)
        {
            _pageCount = pageCount;
        }


        protected override ICache4 NewCache()
        {
            // for a simple LRU algorythm use CacheFactory.NewLRUCache(_pageCount);
            return CacheFactory.New2QXCache(_pageCount);
        }
    }
}
