#include "types.h"
#include "dballe/core/query.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace python {

void query_setpy(core::Query& query, const char* key, unsigned len, PyObject* val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            query.level.l1     = dballe_int_from_python(val);
                            break;
                        case '2':
                            query.level.l2     = dballe_int_from_python(val);
                            break;
                        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            query.trange.p1    = dballe_int_from_python(val);
                            break;
                        case '2':
                            query.trange.p2    = dballe_int_from_python(val);
                            break;
                        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                { int ival = dballe_int_lat_from_python(val); query.latrange.set(ival, ival); }
                            } else {
                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                { int ival = dballe_int_lon_from_python(val); query.lonrange.set(ival, ival); }
                            } else {
                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                            }
                            break;
                        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        query.dtrange.min.day    = query.dtrange.max.day    = datetime_int8_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        query.dtrange.min.minute = query.dtrange.max.minute = datetime_int8_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        query.dtrange.min.second = query.dtrange.max.second = datetime_int8_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        query.varcodes.clear(); query.varcodes.insert(varcode_from_python(val));
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        query.dtrange.min.year   = query.dtrange.max.year   = datetime_int16_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        query.dtrange.min.hour   = query.dtrange.max.hour   = datetime_int8_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        query.ident = ident_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        query.dtrange.min.month  = query.dtrange.max.month  = datetime_int8_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        query.query = dballe_nullable_string_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'i':
                            if (memcmp(key + 2, "mit", 3) == 0) {
                                query.limit = dballe_int_from_python(val);
                            } else {
                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                            }
                            break;
                        case 'e':
                            if (memcmp(key + 2, "vel", 3) == 0) {
                                query.level = level_from_python(val);
                            } else {
                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                            }
                            break;
                        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        query.report = dballe_nullable_string_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        query.ana_id = dballe_int_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        query.mobile = bool_from_python(val) ? 1 : 0;
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            query.latrange.set(query.latrange.imin, dballe_int_lat_from_python(val));
                                        } else {
                                            PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            query.latrange.set(dballe_int_lat_from_python(val), query.latrange.imax);
                                        } else {
                                            PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                        }
                                        break;
                                    default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                            } else {
                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            query.lonrange.imax = dballe_int_lon_from_python(val);
                                        } else {
                                            PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            query.lonrange.imin = dballe_int_lon_from_python(val);
                                        } else {
                                            PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                        }
                                        break;
                                    default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                            } else {
                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                            }
                            break;
                        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    query.dtrange.max.day    = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    query.dtrange.min.day    = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    query.dtrange.max.second = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    query.dtrange.min.second = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        query.trange = trange_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    query.priomax = dballe_int_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    query.priomin = dballe_int_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    query.dtrange.max.year   = datetime_int16_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    query.dtrange.min.year   = datetime_int16_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    query.dtrange.max.hour   = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    query.dtrange.min.hour   = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    query.dtrange.max.minute = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    query.dtrange.min.minute = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        query.varcodes = varcodes_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        query.priomin = query.priomax = dballe_int_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        query.report = dballe_nullable_string_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    query.dtrange.max.month  = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    query.dtrange.min.month  = datetime_int8_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "atetime", 7) == 0) {
                        query.dtrange.min = query.dtrange.max = datetime_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                query.level.ltype1 = dballe_int_from_python(val);
                                break;
                            case '2':
                                query.level.ltype2 = dballe_int_from_python(val);
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        query.trange.pind  = dballe_int_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        query.ana_filter = dballe_nullable_string_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "at", 2) == 0) {
                        switch (key[3]) {
                            case 'a':
                                if (memcmp(key + 4, "_filter", 7) == 0) {
                                    query.data_filter = dballe_nullable_string_from_python(val);
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            case 'e':
                                if (memcmp(key + 4, "timem", 5) == 0) {
                                    switch (key[9]) {
                                        case 'i':
                                            if (key[10] == 'n') {
                                                query.dtrange.min = datetime_from_python(val);
                                            } else {
                                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                            }
                                            break;
                                        case 'a':
                                            if (key[10] == 'x') {
                                                query.dtrange.max = datetime_from_python(val);
                                            } else {
                                                PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                            }
                                            break;
                                        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                    }
                                } else {
                                    PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                                }
                                break;
                            default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                        }
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        query.attr_filter = dballe_nullable_string_from_python(val);
                    } else {
                        PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
                    }
                    break;
                default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
            }
            break;
        default: PyErr_Format(PyExc_KeyError, "key %s not valid for a query", key); throw PythonException();
    }
}

}
}
