/*
	Copyright (c) 1999, 2000, 2001 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifndef _DBPLAYLIST_H_
#define _DBPLAYLIST_H_

#define NUM_SONGLIST_COLUMNS   2

#define XMMS_EXT_STR           "#EXT"

#define SONG_TITLE             "Song Name"
#define PLAYER_TITLE           "Player"
#define PLAYER1_STR            "Player 1"
#define PLAYER2_STR            "Player 2"
#define FULL_CUE_STR           "Full Cue"
#define LOAD_STR               "Load List"
#define SAVE_STR               "Save List"
#define DELETE_STR             "Delete"
#define CUE_UP_STR             "Cue /\\"
#define CUE_DOWN_STR           "Cue \\/"
#define CUE_SWAP_STR           "Swap Plyr"
#define PLAYER_UNDERLINE_SET   "________"
#define PLAYER_UNDERLINE_CLEAR ""

#define UPDATE_GUI_TIMEOUT  1000

#define FREEZE_LIST(a) 		   gtk_clist_freeze((GtkCList *)a); 
#define THAW_LIST(a)		   gtk_clist_thaw((GtkCList *)a);


enum {
	DROP_STRING,
	DROP_PLAINTEXT,
	DROP_URLENCODED
};


typedef struct player_s
{
	gint        index;
	GtkWidget * opt;
	
}player_id;

typedef struct songdata_s
{
	char * name;
	char * path;
	gint   played;
	gint   player;
	gint   xmms_session_id;
} song_data;


void set_drag_highlight(GtkWidget * w, gint row);
void set_cue_highlight(GtkWidget * w);
void clear_highlight(GtkWidget *w, gint row);
int  update_players(gpointer * data);

void setup_next_song();

#endif /* _DBPLAYLIST_H_*/
