/*
 *  commandhandlers.h
 *  backend
 *
 *  Created by Mikael Gransell on 2/28/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */


#ifndef COMMAND_HANDLERS_H_
#define COMMAND_HANDLERS_H_

#include <string>
#include <list>
#include <map>

#include <rpcdriver/rpccommandhandler.h>

#include <rpcdriver/rpcdriver.h>
namespace dcqt_backend
{
#define DEF_RPC_FUNC(classname,name,numparam) \
class classname : public rpc::RpcCommandHandler \
{\
public:\
classname(boost::function<void( int, const rpc::CmdPtr&)> sender ) : rpc::RpcCommandHandler( name, sender, NUM_PARAMS ) {}\
virtual void handleCommand(int clientId,const std::list<boost::any>& params);\
private:\
static const short NUM_PARAMS = numparam;\
};

class AuthenticateCmdHandler : public rpc::RpcCommandHandler
{
	public:
		AuthenticateCmdHandler(	boost::function<void( int, const rpc::CmdPtr&)> sender, std::string& aPassword, rpc::RpcDriverPtr aDriver ) :
			rpc::RpcCommandHandler("authenticate", sender, NUM_PARAMS ), password(aPassword),driver(aDriver) {}
		
		virtual void handleCommand(int clientId, const std::list<boost::any>& params);
	private:
		static const short NUM_PARAMS = 1;	
		std::string password;
		rpc::RpcDriverPtr driver;
		std::map<int,time_t> clientAccessMap;
};

/**
 * Handles the createSession command. 
 */
class CreateSessionCmdHandler : public rpc::RpcCommandHandler
{
public:
	CreateSessionCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender ) 
	: rpc::RpcCommandHandler( "createSession", sender, NUM_PARAMS )
	{}
	
	/**
	 * Extracts the url of the hub we should connect to and calls
	 * the session manager to connect to the given url.
	 * @param cmdName
	 */
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

/**
* Handles the closeSession command. 
 */
class CloseSessionCmdHandler : public rpc::RpcCommandHandler
{
public:
	CloseSessionCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender ) 
	: rpc::RpcCommandHandler( "closeSession", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

/**
* Handles the requestRunningSessions command. 
 */
class RequestRunningSessionsCmdHandler : public rpc::RpcCommandHandler
{
public:
	RequestRunningSessionsCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender ) 
	: rpc::RpcCommandHandler( "requestRunningSessions", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 0;
};

/**
 * Handles the getSharedDirectories command. 
 */
class GetSharedDirectoriesCmdHandler : public rpc::RpcCommandHandler
{
public:
	GetSharedDirectoriesCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "getSharedDirectories", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 0;
};

/**
 * Handles the sendPassword command. 
 */
class SendPasswordCmdHandler : public rpc::RpcCommandHandler
{
public:
	SendPasswordCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "sendPassword", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 2;
};


/**
* Handles the sendChat command. 
 */
class SendChatCmdHandler : public rpc::RpcCommandHandler
{
public:
	SendChatCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "sendChat", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 2;
};

/**
* Handles the sendChat command. 
 */
class SearchCmdHandler : public rpc::RpcCommandHandler
{
public:
	SearchCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "search", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 5;
};

/**
* Handles the addShare command. 
 */
class AddShareCmdHandler : public rpc::RpcCommandHandler
{
public:
	AddShareCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "addShare", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 2;
};

/**
* Handles the removeShare command. 
 */
class RemoveShareCmdHandler : public rpc::RpcCommandHandler
{
public:
	RemoveShareCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "removeShare", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

/**
* Handles the downloadFile command. 
 */
class DownloadFileCmdHandler : public rpc::RpcCommandHandler
{
public:
	DownloadFileCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "downloadFile", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 5;
};

/**
* Handles the getUserFileList command. 
 */

class GetUserFileListCmdHandler : public rpc::RpcCommandHandler
{
public:
	GetUserFileListCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "getUserFileList", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

/**
* Handles the getHubList command. 
 */
class GetHubListCmdHandler : public rpc::RpcCommandHandler
{
public:
	GetHubListCmdHandler( boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "getHubList", sender, NUM_PARAMS )
	{}
	
	virtual void handleCommand(int clientId,
							   const std::list<boost::any>& params);
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

class TestBoolHandler : public rpc::RpcCommandHandler
{
public:
	TestBoolHandler(boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "testbool", sender, NUM_PARAMS ) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
	
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

class ConnectToUserCmdHandler : public rpc::RpcCommandHandler
{
public:
	ConnectToUserCmdHandler(boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "connectToUser", sender, NUM_PARAMS ) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
	
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

class RemoveQueueItemCmdHandler : public rpc::RpcCommandHandler
{
public:
	RemoveQueueItemCmdHandler(boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "removeQueueItem", sender, NUM_PARAMS ) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
	
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};


class AddFavoriteHubCmdHandler : public rpc::RpcCommandHandler
{
public:
	AddFavoriteHubCmdHandler(boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "addFavouriteHub", sender, NUM_PARAMS ) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
	
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 7;
};

class RemoveFavoriteHubCmdHandler : public rpc::RpcCommandHandler
{
public:
	RemoveFavoriteHubCmdHandler(boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "removeFavouriteHub", sender, NUM_PARAMS ) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
	
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 1;
};

class GetFavHubsHandler : public rpc::RpcCommandHandler
{
public:
	GetFavHubsHandler(boost::function<void( int, const rpc::CmdPtr&)> sender )
	: rpc::RpcCommandHandler( "getFavouriteHubs", sender, NUM_PARAMS ) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
	
	
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 0;
};


class DieCmdHandler : public rpc::RpcCommandHandler
{
public:
	DieCmdHandler(boost::function<void( int, const rpc::CmdPtr&)> sender,rpc::RpcDriverPtr aDriver )
	: rpc::RpcCommandHandler( "die", sender, NUM_PARAMS ), driver(aDriver) {}
	
	virtual void handleCommand(int clientId,const std::list<boost::any>& params);
		
private:	
	/// The amount of params that we should receive
	static const short NUM_PARAMS = 0;
	rpc::RpcDriverPtr driver;
};

DEF_RPC_FUNC(GetSettingsHandler,"getSettings",1);
DEF_RPC_FUNC(SetSettingsHandler,"setSettings",2);
DEF_RPC_FUNC(RemoveSourceHandler,"removeSource",2);
}

#endif
