/*******************************************************************************

  Intel Data Center Bridging (DCB) Software
  Copyright(c) 2007-2009 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  e1000-eedc Mailing List <e1000-eedc@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#ifndef _DRV_CFG_H
#define _DRV_CFG_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <asm/types.h>
#include <asm/errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include <linux/dcbnl.h>

enum strict_prio_type {
	prio_none = 0,
	prio_group,
	prio_link
};

struct tc_config {
	__u8 pgid;
	__u8 up_to_tc_bitmap;
	__u8 prio_type;
	__u8 tc_percent;
};

/* Data structures (and macros) needed that are not including in any library. */

#define NLA_HDRLEN           ((int) NLA_ALIGN(sizeof(struct nlattr)))
#define NLA_DATA(nla)        ((void *)((char*)(nla) + NLA_HDRLEN))
#define NLA_PAYLOAD(len)     (len - NLA_HDRLEN)



/* Maximum size of response requested or message sent */
#define MAX_MSG_SIZE    1024

int get_drv_if_socket(void);
int get_perm_hwaddr(const char *ifname, u8 *buf_perm, u8 *buf_san);
int set_hw_state(char *device_name, int dcb_state);
int get_hw_state(char *device_name, int *dcb_state);
int init_drv_if(void);
boolean_t check_port_dcb_mode(char *device_name);

#endif
