/*******************************************************************************

  Intel Data Center Bridging (DCB) Software
  Copyright(c) 2007-2009 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  e1000-eedc Mailing List <e1000-eedc@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#ifndef TLV_H
#define TLV_H

#define ADDR2TLVSTR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define TLVSTR "%02x%02x%02x%02x%02x%02x"   /* Localization OK */

#include "dcb_osdep.h"
#include "ports.h"
#include "dcb_types.h"

/* Bit Mappers */
#define BIT0 0x01
#define BIT1 0x02
#define BIT2 0x04
#define BIT3 0x08
#define BIT4 0x10
#define BIT5 0x20
#define BIT6 0x40
#define BIT7 0x80

/* TLV types */
#define CHASSIS_ID_TLV    1
#define PORT_ID_TLV       2
#define TIME_TO_LIVE_TLV  3
#define ORG_SPECIFIC_TLV  127
#define END_OF_LLDPDU_TLV 0

#define TYPE_0   0
#define TYPE_1   1
#define TYPE_2   2
#define TYPE_3   3
#define TYPE_4   4
#define TYPE_5   5
#define TYPE_6   6
#define TYPE_7   7
#define TYPE_8   8
#define TYPE_127 127

/* Received TLV types */
#define RCVD_LLDP_TLV_TYPE0         0x0001
#define RCVD_LLDP_TLV_TYPE1         0x0002
#define RCVD_LLDP_TLV_TYPE2         0x0004
#define RCVD_LLDP_TLV_TYPE3         0x0008
#define RCVD_LLDP_TLV_TYPE4         0x0010
#define RCVD_LLDP_TLV_TYPE5         0x0020
#define RCVD_LLDP_TLV_TYPE6         0x0040
#define RCVD_LLDP_TLV_TYPE7         0x0080
#define RCVD_LLDP_TLV_TYPE8         0x0100
#define RCVD_LLDP_DCBX1_TLV         0x0200
#define RCVD_LLDP_DCBX2_TLV         0x0400

#define RCVD_DCBX1_TLV_CTRL         0x0001
#define RCVD_DCBX2_TLV_CTRL         0x0002
#define RCVD_DCBX_TLV_PG            0x0004
#define RCVD_DCBX_TLV_PFC           0x0008
#define RCVD_DCBX_TLV_APP           0x0020
#define RCVD_DCBX_TLV_LLINK         0x0040

/* Chassis subtypes */
#define CHASSIS_ID_CHASSIS_COMPONENT 1
#define CHASSIS_ID_INTERFACE_ALIAS   2
#define CHASSIS_ID_PORT_COMPONENT    3
#define CHASSIS_ID_MAC_ADDRESS       4
#define CHASSIS_ID_NETWORK_ADDRESS   5
#define CHASSIS_ID_INTERFACE_NAME    6
#define CHASSIS_ID_LOCALLY_ASSIGNED  7

/* Port subtype */
#define PORT_ID_INTERFACE_ALIAS  1
#define PORT_ID_PORT_COMPONENT   2
#define PORT_ID_MAC_ADDRESS      3
#define PORT_ID_NETWORK_ADDRESS  4
#define PORT_ID_INTERFACE_NAME   5
#define PORT_ID_AGENT_CIRCUIT_ID 6
#define PORT_ID_LOCALLY_ASSIGNED 7

/* DCB TLV Definitions */
#define DCB_CONTROL_TLV                1
#define DCB_PRIORITY_GROUPS_TLV        2
#define DCB_PRIORITY_FLOW_CONTROL_TLV  3
#define DCB_BCN_TLV                    4
#define DCB_APPLICATION_TLV            5
#define DCB_LLINK_TLV                  6

#define DCB_CONTROL_TLV2               1
#define DCB_PRIORITY_GROUPS_TLV2       2
#define DCB_PRIORITY_FLOW_CONTROL_TLV2 3
#define DCB_APPLICATION_TLV2           4

/* Protocol EtherTypes */
#define PROTO_ID_FCOE                  0x0689 /* network byte order */
#define PROTO_ID_FIP                   0x1489 /* network byte order */

/* Protocol Selector Field */
#define PROTO_ID_L2_ETH_TYPE           0x00
#define PROTO_ID_SOCK_NUM              0x01
#define PROTO_ID_RESERVED1             0x02
#define PROTO_ID_RESERVED2             0x03

#define PROTO_ID_OUI_MASK              0xFC
#define PROTO_ID_SF_TYPE               0x03

enum {
	CURRENT_PEER,
	LAST_PEER
};

#pragma pack(1) /*packon*/
struct dcb_control_info {
	u8  oper_version;
	u8  max_version;
	u32 seqno;
	u32 ackno;
};
#pragma pack() /*packoff*/

/* DCBX CTRL TLV byte offsets */
#define DCBX_CTRL_OPER_VER_OFFSET   0
#define DCBX_CTRL_MAX_VER_OFFSET    (DCBX_CTRL_OPER_VER_OFFSET + sizeof(u8))
#define DCBX_CTRL_SEQNO_OFFSET      (DCBX_CTRL_MAX_VER_OFFSET + sizeof(u8))
#define DCBX_CTRL_ACKNO_OFFSET      (DCBX_CTRL_SEQNO_OFFSET + sizeof(u32))
#define DCBX_CTRL_LEN               sizeof(struct dcb_control_info)

struct dcbx_tlv_header {
	u8 oper_version;
	u8 max_version;
	u8 ewe;
	u8 sub_type;
};

/* DCBX TLV HEADER byte offsets */
#define DCBX_HDR_OPER_VERSION_OFFSET    0
#define DCBX_HDR_MAX_VERSION_OFFSET     1
#define DCBX_HDR_EWE_OFFSET             2
#define DCBX_HDR_SUB_TYPE_OFFSET        3

#define DCB_PGID_BYTES                  MAX_BANDWIDTH_GROUPS/2

#pragma pack(1) /*packon*/
struct dcbx1_pg_cfg {
	u8 pg_percent[MAX_BANDWIDTH_GROUPS];/* % of link BW per BWG */
	struct {
		u8  byte1;
			/* :3 BWG ID */
			/* :2 strict_prio 2 (1: LSP, 2: GSP, 3: reserved */
			/* :3 padding */
		u8  byte2;                /* percentage of BWG bandwidth */
	} up_cfg[MAX_USER_PRIORITIES];/* Index is user priority */
};
struct dcbx2_pg_cfg {
	u8 pg_ids[DCB_PGID_BYTES];
	/* byte 0 :4 PG ID for UP 0 */
	/*        :4 PG ID for UP 1 */ 
	/* byte 1 :4 PG ID for UP 2 */
	/*        :4 PG ID for UP 3 */ 
	/* byte 2 :4 PG ID for UP 4 */
	/*        :4 PG ID for UP 5 */ 
	/* byte 3 :4 PG ID for UP 6 */
	/*        :4 PG ID for UP 7 */ 
	u8 pg_percent[MAX_BANDWIDTH_GROUPS];/* % of link BW per PGID */
	u8 num_tcs; 
};
#pragma pack() /*packoff*/
/* DCBX PG TLV byte offsets */
#define DCBX1_PG_PERCENT_OFFSET     sizeof(struct dcbx_tlv_header)
#define DCBX1_PG_SETTINGS_OFFSET    (DCBX1_PG_PERCENT_OFFSET + \
				 sizeof(u8)*MAX_BANDWIDTH_GROUPS)
#define BYTE1_OFFSET                 0
#define BYTE2_OFFSET                 1

#define DCBX2_PG_PGID_UP            sizeof(struct dcbx_tlv_header)
#define DCBX2_PG_PERCENT_OFFSET     (DCBX2_PG_PGID_UP + \
					sizeof(u8)*DCB_PGID_BYTES)
#define DCBX2_PG_NUM_TC_OFFSET      (DCBX2_PG_PERCENT_OFFSET + \
					sizeof(u8)*MAX_BANDWIDTH_GROUPS)

#pragma pack(1) /*packon*/
struct dcbx1_pfc_cfg {
	u8 admin_map; /* bitmap of admin mode, bit position is user priority */
};
struct dcbx2_pfc_cfg {
	u8 admin_map; /* bitmap of admin mode, bit position is user priority */
	u8 num_tcs; 
};
#pragma pack() /*packoff*/

/* DCBX PFC TLV byte offsets */
#define DCBX_PFC_MAP_OFFSET            sizeof(struct dcbx_tlv_header)
#define DCBX2_PFC__NUM_TC_OFFSET      (DCBX_PFC_MAP_OFFSET + sizeof(u8))

#pragma pack(1) /*packon*/
struct dcbx2_app_cfg {
	u16 prot_id;
	u8  byte1;
		/* :6 high 7 bits of OUI */
		/* :2 selector field */
	u16 low_oui; /* low 16 bits of OUI */
	u8  up_map;
};
#pragma pack() /*packoff*/
/* DCBX APP TLV byte offsets */
#define DCBX1_APP_DATA_OFFSET          sizeof(struct dcbx_tlv_header)
#define DCBX2_APP_DATA_OFFSET          sizeof(struct dcbx_tlv_header)
/* To support looping, these do *not* include the header */
#define DCBX2_APP_PROTO_OFFSET         0
#define DCBX2_APP_BYTE1_OFFSET         (DCBX2_APP_PROTO_OFFSET + sizeof(u16))
#define DCBX2_APP_LOW_OUI_OFFSET1      (DCBX2_APP_BYTE1_OFFSET + sizeof(u8))
#define DCBX2_APP_LOW_OUI_OFFSET2      (DCBX2_APP_LOW_OUI_OFFSET1 + sizeof(u8))
#define DCBX2_APP_UP_MAP_OFFSET        (DCBX2_APP_LOW_OUI_OFFSET2 + sizeof(u8))

#pragma pack(1) /*packon*/
struct dcbx1_pg_info {
	struct dcbx_tlv_header hdr;
	struct dcbx1_pg_cfg data;
};
struct dcbx2_pg_info {
	struct dcbx_tlv_header hdr;
	struct dcbx2_pg_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX1_PG_LEN                    sizeof(struct dcbx1_pg_info)
#define DCBX2_PG_LEN                    sizeof(struct dcbx2_pg_info)

#pragma pack(1) /*packon*/
struct dcbx1_pfc_info {
	struct dcbx_tlv_header hdr;
	struct dcbx1_pfc_cfg data;
};
struct dcbx2_pfc_info {
	struct dcbx_tlv_header hdr;
	struct dcbx2_pfc_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX1_PFC_LEN                  sizeof(struct dcbx1_pfc_info)
#define DCBX2_PFC_LEN                  sizeof(struct dcbx2_pfc_info)

#pragma pack(1) /*packon*/
struct dcbx1_app_info {
	struct dcbx_tlv_header hdr;
	u8 data[];
};
struct dcbx2_app_info {
	struct dcbx_tlv_header hdr;
	struct dcbx2_app_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX1_APP_LEN                  DCBX1_APP_DATA_OFFSET
#define DCBX2_APP_LEN                  sizeof(struct dcbx2_app_info)
#define DCBX2_APP_SIZE                 sizeof(struct dcbx2_app_cfg)

#pragma pack(1) /*packon*/
struct dcbx_llink_cfg {
	u8 byte1; /* :1 - logical link status */
};            /* :7 - reserved */
#pragma pack() /*packoff*/

/* DCB_TLV TYPE 6 byte offset */
#define DCBX_LLINK_STATUS_OFFSET       sizeof(struct dcbx_tlv_header)

#pragma pack(1) /*packon*/
struct dcbx_llink_info {
	struct dcbx_tlv_header hdr;
	struct dcbx_llink_cfg data;
};
#pragma pack() /*packoff*/
#define DCBX_LLINK_LEN                 sizeof(struct dcbx_llink_info)

struct packed_tlv {
	u16 size;     /* Of the entire tlv block */
	u8 *tlv;      /* tlv block */
};

struct unpacked_tlv {
	u8  type;
	u16 length;
	u8  *info;
};

/* Organizationally Unique Identifier */
#define DCB_OUI_LEN     3
#define OUI_SUBTYPE_LEN 1

struct dcb_tlv {
	u8 oui[DCB_OUI_LEN];
	u8 oui_subtype;
};

struct packed_tlv *pack_tlv(struct unpacked_tlv *tlv);
struct unpacked_tlv *unpack_tlv(struct packed_tlv *tlv);

struct unpacked_tlv *free_unpkd_tlv(struct unpacked_tlv *tlv);
struct packed_tlv *free_pkd_tlv(struct packed_tlv *tlv);
struct unpacked_tlv *create_tlv(void);

struct unpacked_tlv *bld_end_tlv(void);
struct unpacked_tlv *bld_chassis_tlv(struct port *port);
struct unpacked_tlv *bld_portid_tlv(struct port *port);
struct unpacked_tlv *bld_ttl_tlv(struct port *port);

struct unpacked_tlv *bld_dcbx1_tlv(struct port *port);
struct unpacked_tlv *bld_dcbx2_tlv(struct port *port);

struct unpacked_tlv *bld_dcbx_ctrl_tlv(struct port *port);
struct unpacked_tlv *bld_dcbx1_pg_tlv(struct port *port, boolean_t *success);
struct unpacked_tlv *bld_dcbx2_pg_tlv(struct port *port, boolean_t *success);
struct unpacked_tlv *bld_dcbx1_pfc_tlv(struct port *port, boolean_t *success);
struct unpacked_tlv *bld_dcbx2_pfc_tlv(struct port *port, boolean_t *success);
struct unpacked_tlv *bld_dcbx1_app_tlv(struct port *port, u32 sub_type,
					boolean_t *success);
struct unpacked_tlv *bld_dcbx2_app_tlv(struct port *port, u32 sub_type,
					boolean_t *success);
struct unpacked_tlv *bld_dcbx_llink_tlv(struct port *port, u32 sub_type,
					boolean_t *success);

int tlv_ok(struct unpacked_tlv *tlv);

#endif /* TLVS_H */
