from typing import Literal

DEFAULT_MANIFEST_VERSION = "0.1"
SUPPORTED_MANIFEST_VERSIONS = frozenset(["0.1"])
ManifestVersion = Literal["0.1"]
assert DEFAULT_MANIFEST_VERSION in SUPPORTED_MANIFEST_VERSIONS

MK_MANIFEST_VERSION = "manifest-version"
MK_PACKAGES = "packages"

MK_BUILDS = "builds"

MK_INSTALLATIONS = "installations"
MK_INSTALLATIONS_INSTALL = "install"
MK_INSTALLATIONS_MULTI_DEST_INSTALL = "multi-dest-install"
MK_INSTALLATIONS_INSTALL_DOCS = "install-docs"
MK_INSTALLATIONS_INSTALL_EXAMPLES = "install-examples"
MK_INSTALLATIONS_INSTALL_MAN = "install-man"
MK_INSTALLATIONS_DISCARD = "discard"

MK_INSTALLATIONS_INSTALL_SOURCE = "source"
MK_INSTALLATIONS_INSTALL_SOURCES = "sources"
MK_INSTALLATIONS_INSTALL_DEST_DIR = "dest-dir"
MK_INSTALLATIONS_INSTALL_AS = "as"
MK_INSTALLATIONS_INSTALL_INTO = "into"

MK_INSTALLATIONS_INSTALL_MAN_LANGUAGE = "language"

MK_CONDITION_WHEN = "when"
MK_CONDITION_ARCH_MATCHES = "arch-matches"
MK_CONDITION_BUILD_PROFILES_MATCHES = "build-profiles-matches"

MK_TRANSFORMATIONS = "transformations"

MK_TRANSFORMATIONS_CREATE_SYMLINK = "create-symlink"
MK_TRANSFORMATIONS_CREATE_SYMLINK_LINK_PATH = "path"
MK_TRANSFORMATIONS_CREATE_SYMLINK_LINK_TARGET = "target"

MK_INSTALLATION_SEARCH_DIRS = "installation-search-dirs"

MK_BINARY_VERSION = "binary-version"

MK_SERVICES = "services"

MK_CONFFILE_MANAGEMENT = "conffile-management"
MK_CONFFILE_MANAGEMENT_REMOVE = "remove"
MK_CONFFILE_MANAGEMENT_RENAME = "rename"

MK_CONFFILE_MANAGEMENT_REMOVE_PATH = "path"
MK_CONFFILE_MANAGEMENT_RENAME_SOURCE = "source"
MK_CONFFILE_MANAGEMENT_RENAME_TARGET = "target"

MK_CONFFILE_MANAGEMENT_X_PRIOR_TO_VERSION = "prior-to-version"
MK_CONFFILE_MANAGEMENT_X_OWNING_PACKAGE = "owning-package"

MK_MANIFEST_DEFINITIONS = "definitions"
MK_MANIFEST_VARIABLES = "variables"

MK_MANIFEST_REMOVE_DURING_CLEAN = "remove-during-clean"
