# packages/lorsm/www/md/rightsmd/rights_caor.tcl

ad_page_contract {

    Add/Edit Rights MD Copyright or other Restrictions

    @author Gerard Low (glow5809@mail.usyd.edu.au)
    @author Ernie Ghiglione (ErnieG@mm.st)
    @creation-date 16 October 2004
    @cvs-id $Id: rights_caor.tcl,v 1.4 2008/12/12 14:25:38 juanf Exp $

} {
    ims_md_id:integer
} -properties {
} -validate {
} -errors {
}

# set context & title
set context [list \
                [list \
                    [export_vars -base ".." ims_md_id] \
                    "[_ lorsm.IMS_Metadata_Editor]"] \

                [list \
                    [export_vars -base "../rightsmd" ims_md_id] \
                    "[_ lorsm.Rights_MD]"] \

                " <#_Add/Edit Copyrights or other Restrictions #>"]
set title "[_ lorsm.lt_Edit_Rights_MD_Copyri]"

# Form
ad_form \
    -name rightsmd_caor \
    -cancel_url ../rightsmd?ims_md_id=$ims_md_id \
    -mode edit \
    -form {
        {caor_s:text,nospell
            {html {size 10}}
            {help_text "[_ lorsm.lt_Source_of_vocabulary_]"}
            {label "[_ lorsm.Source]"}
        }

        {caor_v:text,nospell
            {html {size 10}}
            {help_text "[_ lorsm.lt_Whether_copyright_or_]"}
            {label "[_ lorsm.lt_Copyright_or_other_Re]"}
        }

    {ims_md_id:text(hidden) {value $ims_md_id}}

    } -on_submit {
        # check if the Rights Copyright details already exist...

        if {[db_0or1row select_type {}]} {
            db_dml do_update {}
        } else {
            db_dml do_insert {}
        }

    } -after_submit {
        ad_returnredirect [export_vars -base "../rightsmd" {ims_md_id}]
        ad_script_abort
    }

# Rights Copyright or other Restrictions
template::list::create \
    -name d_ri_caor \
    -multirow d_ri_caor \
    -no_data "[_ lorsm.lt_No_Copyright_or_other]" \
    -html { align right style "width: 100%;" } \
    -elements {
        caor { label "[_ lorsm.Copyright_Info]" }
    }

db_multirow d_ri_caor select_ri_caor {}
