#! /bin/bash

# Determine what translations are less than 10% translated

for doc in about-edubuntu
do
	numstrings=`LANG=C msgfmt --statistics ${doc}/po/*.pot 2>&1 | sed -r 's/^.* ([[:digit:]]+) untranslated.*$$/\1/'`
	for lang in `ls ${doc}/`
	do
		if [ -e ${doc}/po/${lang}.po ]
		then
			translated=`LANG=C msgfmt -o /dev/null --statistics ${doc}/po/${lang}.po 2>&1| cut -f1 -d\ `
			if [ "`echo "${translated}./${numstrings} > 0.1" | bc -l`" = "0" ]
			then
				echo "${doc} ${lang} is less than 10% translated"
				continue
			fi
		fi
	done
done
