/*
 * $Id: sig_telephone.h,v 1.26 2012-03-06 14:46:50 siflkres Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_TELEPHONE_H_INCLUDED
#define __SIG_TELEPHONE_H_INCLUDED

#include <inttypes.h>
#include <stdio.h>

#include "sig_gen.h"

/**
 * protocol for telephone line.
 */

/** possible message kinds */
enum sig_telephone_protocol {
	SIG_TELE_DIAL, 		  /**< dial a number */
	SIG_TELE_CONNECT,	  /**< connected with peer */
	SIG_TELE_INVALID_NUMBER,  /**< number invalid */
	SIG_TELE_HANGUP,	  /**< terminate a connection */
	SIG_TELE_LIFT,		  /**< "lift the receiver" */
	SIG_TELE_BUSY,		  /**< line is busy or peer has hung up */
	SIG_TELE_DIALTONE,	  /**< line is usable (dialtone) */
	SIG_TELE_RING,		  /**< incoming call */
	SIG_TELE_DATA		  /**< Modem-DATA-packet */
};

/** callbacks for telephone signal */
struct sig_telephone_funcs {

	/** will be called, if data get's recieved through
	 *  telephone signal.
	 *  @param s instance.
	 *  @param data received byte of data
	 */
	void (*recv_data)(void *s, uint8_t data);

	/** will be called, if a control message is receieved through
         *  telephone signal.
	 *  @param s instance.
	 *  @param event event that occured.
	 */
	void (*recv_ctrl)(void *s, enum sig_telephone_protocol event);

	/** will be called, if a number was dialed. Only the telephone-
	 *  exchange will be interested in this callback.
	 *  @param s instance.
	 *  @param number number that was dialed.
	 */
	void (*recv_dial)(void *s, uint32_t number);
};

/** structure with callbacks. */
struct sig_telephone {
	/** magic number */
	enum sig_gen_type type;
	/** members participating on one signal */
	struct {
		/** object data */
		void *s;
		/** registered callbacks */
		const struct sig_telephone_funcs *f;
	} member[10];
	/** number of members */
	unsigned int nmembers;
};

/** send data to other participants.
 *  @param b sig_telephone object
 *  @param s sender object
 *  @param data one byte of data to send.
 */
extern void
sig_telephone_send_data(const struct sig_telephone* b, void *s, uint8_t data);


/** send a control packet to other participants.
 *  @param b sig_telephone object
 *  @param s sender object
 *  @param proto kind of control message.
 */
extern void
sig_telephone_send_ctrl(const struct sig_telephone *b, void *s, 
			enum sig_telephone_protocol proto);


/** dial a number.
 *  @param b sig_telephone object.
 *  @param s sender object.
 *  @param number number to dial.
 */
extern void
sig_telephone_dial(const struct sig_telephone *b, void *s, uint32_t number);


/** connect to telephone signal
 *  @param b signal object.
 *  @param s sender object.
 *  @param f callback functions.
 */
extern void
sig_telephone_connect(struct sig_telephone *b, void *s,
		const struct sig_telephone_funcs *f);

extern struct sig_telephone *
sig_telephone_create(const char *name);
extern void
sig_telephone_destroy(struct sig_telephone *sig);

extern void
sig_telephone_suspend(struct sig_telephone *b, FILE *fSig);
extern void
sig_telephone_resume(struct sig_telephone *b, FILE *fSig);

#endif /* __SIG_TELEPHONE_H_INCLUDED */
