/*
 * $Id: arch_gen_cpu_x86.h,v 1.12 2012-02-22 09:27:19 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <stdio.h>
#include "sig_manage.h"
#if defined(CONFIG_CPU_SOCKET_ISA)
#include "sig_boolean.h"
#include "sig_boolean_or.h"
#include "sig_isa_bus.h"
#elif defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
#include "sig_host_bus.h"
#elif defined(CONFIG_CPU_SOCKET_775)
#include "sig_host775_bus.h"
#else
#error "Unknown socket."
#endif

extern void *
NAME_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_boolean *port_n_reset,
#if 80386 < CONFIG_CPU
	struct sig_boolean *port_n_init,
#endif
	struct sig_boolean_or *port_irq,
	struct sig_boolean_or *port_nmi,
#if 80386 <= CONFIG_CPU
	struct sig_boolean *port_smi,
#endif
	struct sig_boolean_or *port_n_ferr,
	struct sig_boolean *port_n_ignne,
#if 80386 <= CONFIG_CPU
	struct sig_boolean *port_a20,
#endif
#if 80486 <= CONFIG_CPU && CONFIG_CPU_APIC_SUPPORT
	struct sig_icc_bus *port_icc,
#endif
#if defined(CONFIG_CPU_SOCKET_ISA)
	struct sig_isa_bus_main *port_bus
#elif defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	struct sig_host_bus_main *port_bus
#elif defined(CONFIG_CPU_SOCKET_775)
	struct sig_host775_bus_main *port_bus
#else
#error "Unknown socket."
#endif
);
extern void
NAME_(destroy)(void *_cpssp);

extern void
NAME_(suspend)(void *_cpssp, FILE *fComp);

extern void
NAME_(resume)(void *_cpssp, FILE *fComp);
