/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractColumnMaxValueIncrementer;

public class DerbyMaxValueIncrementer
extends AbstractColumnMaxValueIncrementer {
    private static final String DEFAULT_DUMMY_NAME = "dummy";
    private String dummyName = "dummy";
    private long[] valueCache;
    private int nextValueIndex = -1;

    public DerbyMaxValueIncrementer() {
    }

    public DerbyMaxValueIncrementer(DataSource dataSource, String incrementerName, String columnName) {
        super(dataSource, incrementerName, columnName);
        this.dummyName = DEFAULT_DUMMY_NAME;
    }

    public DerbyMaxValueIncrementer(DataSource dataSource, String incrementerName, String columnName, String dummyName) {
        super(dataSource, incrementerName, columnName);
        this.dummyName = dummyName;
    }

    public void setDummyName(String dummyName) {
        this.dummyName = dummyName;
    }

    public String getDummyName() {
        return this.dummyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.nextValueIndex >= 0) {
            if (this.nextValueIndex < this.getCacheSize()) return this.valueCache[this.nextValueIndex++];
        }
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        Statement stmt = null;
        try {
            try {
                stmt = con.createStatement();
                DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
                this.valueCache = new long[this.getCacheSize()];
                this.nextValueIndex = 0;
                for (int i = 0; i < this.getCacheSize(); ++i) {
                    Object var6_6;
                    stmt.executeUpdate("insert into " + this.getIncrementerName() + " (" + this.getDummyName() + ") values(null)");
                    ResultSet rs = stmt.executeQuery("select IDENTITY_VAL_LOCAL() from " + this.getIncrementerName());
                    try {
                        if (!rs.next()) {
                            throw new DataAccessResourceFailureException("IDENTITY_VAL_LOCAL() failed after executing an update");
                        }
                        this.valueCache[i] = rs.getLong(1);
                        var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        var6_6 = null;
                        JdbcUtils.closeResultSet(rs);
                        throw throwable;
                    }
                    JdbcUtils.closeResultSet(rs);
                }
                long l = this.valueCache[this.valueCache.length - 1];
                stmt.executeUpdate("delete from " + this.getIncrementerName() + " where " + this.getColumnName() + " < " + l);
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not obtain IDENTITY value", ex);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JdbcUtils.closeStatement(stmt);
            DataSourceUtils.releaseConnection(con, this.getDataSource());
            throw throwable;
        }
        JdbcUtils.closeStatement(stmt);
        DataSourceUtils.releaseConnection(con, this.getDataSource());
        return this.valueCache[this.nextValueIndex++];
    }
}

