/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.lang.reflect.Constructor;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import visad.Display;
import visad.DisplayRealType;
import visad.VisADError;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.VisADCanvasJ3D;

public class TwoDDisplayRendererJ3D
extends DisplayRendererJ3D {
    private Object not_destroyed = new Object();
    private ColoringAttributes box_color = null;
    private ColoringAttributes cursor_color = null;
    private LineAttributes box_line = null;
    private LineAttributes cursor_line = null;
    private Class mouseBehaviorJ3DClass = null;
    private MouseBehaviorJ3D mouse = null;
    private static final float[] box_verts = new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f};
    private static final float[] cursor_verts = new float[]{0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f};

    public TwoDDisplayRendererJ3D() {
        this.mouseBehaviorJ3DClass = MouseBehaviorJ3D.class;
    }

    public TwoDDisplayRendererJ3D(Class mbj3dClass) {
        this.mouseBehaviorJ3DClass = mbj3dClass;
    }

    public void destroy() {
        this.not_destroyed = null;
        this.box_color = null;
        this.cursor_color = null;
        this.mouse = null;
        super.destroy();
    }

    public boolean getMode2D() {
        return true;
    }

    public boolean legalDisplayScalar(DisplayRealType type) {
        if (Display.ZAxis.equals(type) || Display.Latitude.equals(type)) {
            return false;
        }
        return super.legalDisplayScalar(type);
    }

    public BranchGroup createSceneGraph(View v, TransformGroup vpt, VisADCanvasJ3D c) {
        if (this.not_destroyed == null) {
            return null;
        }
        BranchGroup root = this.getRoot();
        if (root != null) {
            return root;
        }
        try {
            Class[] param = new Class[]{DisplayRendererJ3D.class};
            Constructor mbConstructor = this.mouseBehaviorJ3DClass.getConstructor(param);
            this.mouse = (MouseBehaviorJ3D)mbConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new VisADError("cannot construct " + this.mouseBehaviorJ3DClass);
        }
        this.getDisplay().setMouseBehavior(this.mouse);
        this.box_color = new ColoringAttributes();
        this.cursor_color = new ColoringAttributes();
        root = this.createBasicSceneGraph(v, vpt, c, this.mouse, this.box_color, this.cursor_color);
        TransformGroup trans = this.getTrans();
        LineArray box_geometry = new LineArray(8, 1);
        box_geometry.setCapability(2);
        box_geometry.setCapability(0);
        box_geometry.setCapability(8);
        box_geometry.setCapability(17);
        box_geometry.setCapability(4);
        box_geometry.setCapability(6);
        box_geometry.setCapability(1);
        box_geometry.setCoordinates(0, box_verts);
        Appearance box_appearance = new Appearance();
        this.box_line = new LineAttributes();
        this.box_line.setCapability(1);
        box_appearance.setLineAttributes(this.box_line);
        this.box_color.setCapability(0);
        this.box_color.setCapability(1);
        float[] ctlBox = this.getRendererControl().getBoxColor();
        this.box_color.setColor(ctlBox[0], ctlBox[1], ctlBox[2]);
        box_appearance.setColoringAttributes(this.box_color);
        Shape3D box = new Shape3D((Geometry)box_geometry, box_appearance);
        box.setCapability(12);
        box.setCapability(14);
        BranchGroup box_on = this.getBoxOnBranch();
        box_on.addChild((Node)box);
        Appearance cursor_appearance = new Appearance();
        this.cursor_line = new LineAttributes();
        this.cursor_line.setCapability(1);
        cursor_appearance.setLineAttributes(this.cursor_line);
        this.cursor_color.setCapability(0);
        this.cursor_color.setCapability(1);
        float[] ctlCursor = this.getRendererControl().getCursorColor();
        this.cursor_color.setColor(ctlCursor[0], ctlCursor[1], ctlCursor[2]);
        cursor_appearance.setColoringAttributes(this.cursor_color);
        BranchGroup cursor_on = this.getCursorOnBranch();
        LineArray cursor_geometry = new LineArray(4, 1);
        cursor_geometry.setCapability(2);
        cursor_geometry.setCapability(0);
        cursor_geometry.setCapability(8);
        cursor_geometry.setCapability(17);
        cursor_geometry.setCapability(4);
        cursor_geometry.setCapability(6);
        cursor_geometry.setCoordinates(0, cursor_verts);
        Shape3D cursor = new Shape3D((Geometry)cursor_geometry, cursor_appearance);
        cursor.setCapability(12);
        cursor.setCapability(14);
        cursor_on.addChild((Node)cursor);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.mouse.setSchedulingBounds((Bounds)bounds);
        trans.addChild((Node)this.mouse);
        Color3f color = new Color3f(0.6f, 0.6f, 0.6f);
        AmbientLight light = new AmbientLight(color);
        light.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)light);
        Color3f dcolor = new Color3f(0.9f, 0.9f, 0.9f);
        Vector3f direction1 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f direction2 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(true, dcolor, direction1);
        light1.setInfluencingBounds((Bounds)bounds);
        DirectionalLight light2 = new DirectionalLight(true, dcolor, direction2);
        light2.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)light1);
        root.addChild((Node)light2);
        return root;
    }

    public void setBoxAspect(double[] aspect) {
        if (this.not_destroyed == null) {
            return;
        }
        float[] new_verts = new float[box_verts.length];
        for (int i = 0; i < box_verts.length; i += 3) {
            new_verts[i] = (float)((double)box_verts[i] * aspect[0]);
            new_verts[i + 1] = (float)((double)box_verts[i + 1] * aspect[1]);
            new_verts[i + 2] = (float)((double)box_verts[i + 2] * aspect[2]);
        }
        BranchGroup box_on = this.getBoxOnBranch();
        Shape3D box = (Shape3D)box_on.getChild(0);
        LineArray box_geometry = (LineArray)box.getGeometry();
        box_geometry.setCoordinates(0, new_verts);
    }

    public void setLineWidth(float width) {
        this.box_line.setLineWidth(width);
        this.cursor_line.setLineWidth(width);
    }
}

