/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaCholeskyDecomposition
extends Tuple {
    private static final RealType cholesky_row = RealType.getRealType("choleskyL_row");
    private static final RealType cholesky_column = RealType.getRealType("choleskyL_column");
    private static final RealType cholesky_value = RealType.getRealType("choleskyL_value");
    private static final FunctionType choleskyLType = JamaCholeskyDecomposition.constructFunction();
    private static final Class[] classes = JamaCholeskyDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private Object cd = ((JamaMatrix)this.getComponent(0)).getStash();
    private static final Method[] methods = JamaCholeskyDecomposition.constructMethods();
    private static final Method getL = methods[0];
    private static final Method isSPD = methods[1];
    private static final Method solve = methods[2];
    private static final Constructor matrixCholeskyDecomposition = JamaCholeskyDecomposition.constructConstructor();

    private static FunctionType constructFunction() {
        try {
            RealTupleType tuple = new RealTupleType(cholesky_row, cholesky_column);
            FunctionType function = new FunctionType(tuple, cholesky_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] cs = new Class[6];
        try {
            cs[0] = Class.forName("Jama.Matrix");
            cs[1] = Class.forName("Jama.CholeskyDecomposition");
            cs[2] = Class.forName("Jama.EigenvalueDecomposition");
            cs[3] = Class.forName("Jama.LUDecomposition");
            cs[4] = Class.forName("Jama.QRDecomposition");
            cs[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return cs;
    }

    private static Method[] constructMethods() {
        Method[] ms = new Method[3];
        try {
            Class[] param = new Class[]{};
            ms[0] = classCholeskyDecomposition.getMethod("getL", param);
            ms[1] = classCholeskyDecomposition.getMethod("isSPD", param);
            param = new Class[]{classMatrix};
            ms[2] = classCholeskyDecomposition.getMethod("solve", param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return ms;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] param = new Class[]{classMatrix};
            return classCholeskyDecomposition.getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JamaCholeskyDecomposition(JamaMatrix matrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixCholeskyDecomposition.newInstance(matrix.getMatrix()), false);
    }

    JamaCholeskyDecomposition(Object c, boolean copy) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaCholeskyDecomposition.makeDatums(c), copy);
    }

    private static Data[] makeDatums(Object c) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object m = getL.invoke(c, new Object[0]);
        JamaMatrix jm = new JamaMatrix(m, choleskyLType, null, null, null, null, null);
        jm.setStash(c);
        return new Data[]{jm};
    }

    public Object getCholeskyDecomposition() {
        return this.cd;
    }

    public JamaMatrix getL() throws VisADException, RemoteException {
        if (classCholeskyDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public boolean isSPD() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classCholeskyDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        boolean spd = (Boolean)isSPD.invoke(this.cd, new Object[0]);
        return spd;
    }

    public JamaMatrix solve(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classCholeskyDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = solve.invoke(this.cd, B.getMatrix());
        return new JamaMatrix(m);
    }
}

