#include <stdio.h>

#include <list.h>
#include <localio.h>

#include <SDL.h>

SDL_Surface *screen;
const SDL_VideoInfo *info;

int main(int argc, char *argv[]) {
	Local_io *io;
	int i = 0;

	if(SDL_Init(SDL_INIT_VIDEO) == -1) return 1;
	info = SDL_GetVideoInfo();
	screen = SDL_SetVideoMode(200,200,info->vfmt->BitsPerPixel,SDL_DOUBLEBUF);

	printf("Init...\n");
	io = new_local_io(1);
	local_io_register_key(io, SDLK_a, 0, 1);
	local_io_register_key(io, SDLK_q, 0, 2);

	while(i < 1000) {
		SDL_Delay(200);
		local_io_update(io);
		printf("events: %d\n", local_io_get_events(io, 0));
		i++;
	}
	
	printf("Cleanup Local IO...\n");
	del_local_io(io);

	printf("Cleanup SDL...\n");
	SDL_Quit();

	return 0;
}
