  std::cout << ";;;; this file contains an interface to use findent within emacs." << std::endl;
  std::cout << ";;;; the C-M-q command (\"indent function\") is redefined to" << std::endl;
  std::cout << ";;;; indent the whole buffer." << std::endl;
  std::cout << "; how to call findent for a fixed format Fortran source:" << std::endl;
  std::cout << "(defvar fortran-findent-command " << std::endl;
  std::cout << "  \"findent -ifixed -Ia\"" << std::endl;
  std::cout << "  \"findent command for fixed format fortran source\")" << std::endl;
  std::cout << ";" << std::endl;
  std::cout << "; how to call findent for a free format Fortran source:" << std::endl;
  std::cout << "(defvar f90-findent-command " << std::endl;
  std::cout << "  \"findent -ifree -Ia\"" << std::endl;
  std::cout << "  \"findent command for free format fortran source\")" << std::endl;
  std::cout << ";" << std::endl;
  std::cout << ";;;; define function findent-indent-buffer: it calls the program" << std::endl;
  std::cout << ";;;; findent with the whole buffer as input and output" << std::endl;
  std::cout << "(defun findent-indent-buffer()" << std::endl;
  std::cout << "  \" " << std::endl;
  std::cout << "  Function that uses findent to indent the whole buffer." << std::endl;
  std::cout << "  The call to findent must be provided in the string findent-command," << std::endl;
  std::cout << "    for example (setq findent-command \\\"findent -ifixed -Ia\\\")" << std::endl;
  std::cout << "  Findent supports Fortran-2008, free and fixed format;" << std::endl;
  std::cout << "    indents correctly DO statements that share a common label;" << std::endl;
  std::cout << "    is in general not confused by #if, #ifdef or #else preprocessor" << std::endl;
  std::cout << "    statements." << std::endl;
  std::cout << "  \"" << std::endl;
  std::cout << "  (interactive)" << std::endl;
  std::cout << "  (let (" << std::endl;
  std::cout << "	(lines (count-lines (point-min) (point-max)))" << std::endl;
  std::cout << "	(lpos (line-number-at-pos))" << std::endl;
  std::cout << "	(first-window-line)" << std::endl;
  std::cout << "	(offset)" << std::endl;
  std::cout << "	(linelength)" << std::endl;
  std::cout << "	(pos (point))" << std::endl;
  std::cout << "	)" << std::endl;
  std::cout << "    ; this function tries to restore cursor and window" << std::endl;
  std::cout << "    ; position after indenting, hence the extra code." << std::endl;
  std::cout << "    ; If somebody knows something better ..." << std::endl;
  std::cout << "    (beginning-of-line)" << std::endl;
  std::cout << "    (end-of-line)" << std::endl;
  std::cout << "    (skip-chars-backward \"[:blank:]\")" << std::endl;
  std::cout << "    (setq offset (- (point) pos))" << std::endl;
  std::cout << "    (if (< offset 0) (setq offset 0))" << std::endl;
  std::cout << "    (move-to-window-line 0)" << std::endl;
  std::cout << "    (setq first-window-line (line-number-at-pos))" << std::endl;
  std::cout << "    (message \"indenting buffer ...\" )" << std::endl;
  std::cout << "    (shell-command-on-region (point-min) (point-max) findent-command 1 1 )" << std::endl;
  std::cout << "    (goto-line lpos)" << std::endl;
  std::cout << "    (redisplay)" << std::endl;
  std::cout << "    (move-to-window-line 0)" << std::endl;
  std::cout << "    (scroll-down (- (line-number-at-pos) first-window-line))" << std::endl;
  std::cout << "    (goto-line lpos)" << std::endl;
  std::cout << "    (setq pos (point))" << std::endl;
  std::cout << "    (end-of-line)" << std::endl;
  std::cout << "    (setq linelength (- (point) pos))" << std::endl;
  std::cout << "    (if (< offset linelength)" << std::endl;
  std::cout << "      (backward-char offset)" << std::endl;
  std::cout << "      (beginning-of-line))" << std::endl;
  std::cout << "    (message \"indenting buffer ... %d lines indented\" lines)" << std::endl;
  std::cout << "    )" << std::endl;
  std::cout << "  )" << std::endl;
  std::cout << ";" << std::endl;
  std::cout << "(add-hook 'fortran-mode-hook (lambda() (setq findent-command fortran-findent-command)))" << std::endl;
  std::cout << "(add-hook 'f90-mode-hook     (lambda() (setq findent-command f90-findent-command)))" << std::endl;
  std::cout << "(add-hook 'fortran-mode-hook (lambda() (local-set-key \"\\C-\\M-q\" 'findent-indent-buffer)))" << std::endl;
  std::cout << "(add-hook 'f90-mode-hook     (lambda() (local-set-key \"\\C-\\M-q\" 'findent-indent-buffer)))" << std::endl;
