#! /usr/bin/env bash
# This file is part of git-big-picture
#
# Copyright (C) 2021 Sebastian Pipping <sebastian@pipping.org>
#
# git-big-picture is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# git-big-picture is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with git-big-picture.  If not, see <http://www.gnu.org/licenses/>.

set -e
set -o pipefail

_BUILD_MONTH=2024-03  # for reproducible builds; bump when doing releases

sed_args=(
    # Produce familiar section "synopsis"
    -e 's,^\.SH DESCRIPTION,.SH SYNOPSIS,'
    -e 's,^usage: ,,'
    -e 's,^git\\-big\\-picture OPTIONS.*,\0\n.SH DESCRIPTION,'

    # Be robust towards version difference between local help2man and CI help2man
    -e 's,It was generated by help2man .*,It was generated by help2man.,'

    # Fix over-indent of argument group description
    -e 's,^\.IP,.PP,'

    # Put epilog in its own section
    -e 's,^git\\-big\\-picture is software libre.*,.SH EPILOG\n\0,'

    # Format "git-big-picture" in bold everywhere after section "NAME"
    -e 's,\(git\\-big\\-picture\) ,\n.B \1\n,g'
)

SOURCE_DATE_EPOCH="$(date --date="${_BUILD_MONTH}-15" +%s)" \
    help2man --no-info --locale en_US.UTF-8 --name 'Visualize Git repositories' git-big-picture \
    | sed "${sed_args[@]}" \
    > git-big-picture.1
