import glitch, glitch.gtk
from glitch.cairo import Text
from glitch.limbo.blend import Blend
from glitch.PIL import ImageTexture

from PIL import Image
import urllib2, simplejson, StringIO

def get_flickr_photos(tags):
    photo_json = urllib2.urlopen('http://api.flickr.com/services/feeds/photos_public.gne?tags=%s&tagmode=any&format=json' %(tags)).read()
    photo_json = photo_json[len('jsonFlickrFeed('):-1]
    return simplejson.loads(photo_json)['items']

def get_photo_texture(photo):
    im = Image.open(StringIO.StringIO(urllib2.urlopen(photo['media']['m']).read()))
    return ImageTexture(im)

photos = get_flickr_photos('hyggelig,hygge')

# TODO: download images in background?
photo_nodes = [glitch.Translate(x=i, children=[
            glitch.ApplyTexture(get_photo_texture(photo), children=[
                    glitch.TexturedRectangle()])]) for i, photo in enumerate(photos)]

camera = glitch.gtk.GtkMovingCamera(eye=[1.5,0.5,2.5], ref=[1.5,0.5,0], children=[
        Blend(children=photo_nodes + [
                glitch.Translate(y=-0.75,z=0.1,children=[
                        glitch.ApplyTexture(Text('glitch 0.5: hyggelig'),children=[
                                glitch.TexturedRectangle()])])])])
camera.run()
