// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAddInstanceFleet struct {
}

func (*validateOpAddInstanceFleet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddInstanceFleet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddInstanceFleetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddInstanceFleetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddInstanceGroups struct {
}

func (*validateOpAddInstanceGroups) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddInstanceGroups) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddInstanceGroupsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddInstanceGroupsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddJobFlowSteps struct {
}

func (*validateOpAddJobFlowSteps) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddJobFlowSteps) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddJobFlowStepsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddJobFlowStepsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAddTags struct {
}

func (*validateOpAddTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAddTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AddTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAddTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelSteps struct {
}

func (*validateOpCancelSteps) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelSteps) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelStepsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelStepsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateSecurityConfiguration struct {
}

func (*validateOpCreateSecurityConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateSecurityConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateSecurityConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateSecurityConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateStudio struct {
}

func (*validateOpCreateStudio) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateStudio) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateStudioInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateStudioInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateStudioSessionMapping struct {
}

func (*validateOpCreateStudioSessionMapping) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateStudioSessionMapping) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateStudioSessionMappingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateStudioSessionMappingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSecurityConfiguration struct {
}

func (*validateOpDeleteSecurityConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSecurityConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSecurityConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSecurityConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteStudio struct {
}

func (*validateOpDeleteStudio) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteStudio) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteStudioInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteStudioInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteStudioSessionMapping struct {
}

func (*validateOpDeleteStudioSessionMapping) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteStudioSessionMapping) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteStudioSessionMappingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteStudioSessionMappingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeCluster struct {
}

func (*validateOpDescribeCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeNotebookExecution struct {
}

func (*validateOpDescribeNotebookExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeNotebookExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeNotebookExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeNotebookExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeSecurityConfiguration struct {
}

func (*validateOpDescribeSecurityConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeSecurityConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeSecurityConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeSecurityConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeStep struct {
}

func (*validateOpDescribeStep) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeStep) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeStepInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeStepInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeStudio struct {
}

func (*validateOpDescribeStudio) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeStudio) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeStudioInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeStudioInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAutoTerminationPolicy struct {
}

func (*validateOpGetAutoTerminationPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAutoTerminationPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAutoTerminationPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAutoTerminationPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetClusterSessionCredentials struct {
}

func (*validateOpGetClusterSessionCredentials) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetClusterSessionCredentials) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetClusterSessionCredentialsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetClusterSessionCredentialsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetManagedScalingPolicy struct {
}

func (*validateOpGetManagedScalingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetManagedScalingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetManagedScalingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetManagedScalingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetStudioSessionMapping struct {
}

func (*validateOpGetStudioSessionMapping) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetStudioSessionMapping) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetStudioSessionMappingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetStudioSessionMappingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListBootstrapActions struct {
}

func (*validateOpListBootstrapActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListBootstrapActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListBootstrapActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListBootstrapActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInstanceFleets struct {
}

func (*validateOpListInstanceFleets) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInstanceFleets) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInstanceFleetsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInstanceFleetsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInstanceGroups struct {
}

func (*validateOpListInstanceGroups) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInstanceGroups) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInstanceGroupsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInstanceGroupsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInstances struct {
}

func (*validateOpListInstances) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInstances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInstancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInstancesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListSteps struct {
}

func (*validateOpListSteps) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListSteps) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListStepsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListStepsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListSupportedInstanceTypes struct {
}

func (*validateOpListSupportedInstanceTypes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListSupportedInstanceTypes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListSupportedInstanceTypesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListSupportedInstanceTypesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpModifyCluster struct {
}

func (*validateOpModifyCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpModifyCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ModifyClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpModifyClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpModifyInstanceFleet struct {
}

func (*validateOpModifyInstanceFleet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpModifyInstanceFleet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ModifyInstanceFleetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpModifyInstanceFleetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpModifyInstanceGroups struct {
}

func (*validateOpModifyInstanceGroups) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpModifyInstanceGroups) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ModifyInstanceGroupsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpModifyInstanceGroupsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutAutoScalingPolicy struct {
}

func (*validateOpPutAutoScalingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutAutoScalingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutAutoScalingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutAutoScalingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutAutoTerminationPolicy struct {
}

func (*validateOpPutAutoTerminationPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutAutoTerminationPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutAutoTerminationPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutAutoTerminationPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutBlockPublicAccessConfiguration struct {
}

func (*validateOpPutBlockPublicAccessConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutBlockPublicAccessConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutBlockPublicAccessConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutBlockPublicAccessConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutManagedScalingPolicy struct {
}

func (*validateOpPutManagedScalingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutManagedScalingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutManagedScalingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutManagedScalingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveAutoScalingPolicy struct {
}

func (*validateOpRemoveAutoScalingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveAutoScalingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveAutoScalingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveAutoScalingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveAutoTerminationPolicy struct {
}

func (*validateOpRemoveAutoTerminationPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveAutoTerminationPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveAutoTerminationPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveAutoTerminationPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveManagedScalingPolicy struct {
}

func (*validateOpRemoveManagedScalingPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveManagedScalingPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveManagedScalingPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveManagedScalingPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveTags struct {
}

func (*validateOpRemoveTags) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveTags) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveTagsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveTagsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRunJobFlow struct {
}

func (*validateOpRunJobFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRunJobFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RunJobFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRunJobFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetKeepJobFlowAliveWhenNoSteps struct {
}

func (*validateOpSetKeepJobFlowAliveWhenNoSteps) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetKeepJobFlowAliveWhenNoSteps) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetKeepJobFlowAliveWhenNoStepsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetKeepJobFlowAliveWhenNoStepsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetTerminationProtection struct {
}

func (*validateOpSetTerminationProtection) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetTerminationProtection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetTerminationProtectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetTerminationProtectionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetVisibleToAllUsers struct {
}

func (*validateOpSetVisibleToAllUsers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetVisibleToAllUsers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetVisibleToAllUsersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetVisibleToAllUsersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartNotebookExecution struct {
}

func (*validateOpStartNotebookExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartNotebookExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartNotebookExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartNotebookExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopNotebookExecution struct {
}

func (*validateOpStopNotebookExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopNotebookExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopNotebookExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopNotebookExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTerminateJobFlows struct {
}

func (*validateOpTerminateJobFlows) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTerminateJobFlows) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TerminateJobFlowsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTerminateJobFlowsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateStudio struct {
}

func (*validateOpUpdateStudio) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateStudio) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateStudioInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateStudioInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateStudioSessionMapping struct {
}

func (*validateOpUpdateStudioSessionMapping) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateStudioSessionMapping) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateStudioSessionMappingInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateStudioSessionMappingInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAddInstanceFleetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddInstanceFleet{}, middleware.After)
}

func addOpAddInstanceGroupsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddInstanceGroups{}, middleware.After)
}

func addOpAddJobFlowStepsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddJobFlowSteps{}, middleware.After)
}

func addOpAddTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAddTags{}, middleware.After)
}

func addOpCancelStepsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelSteps{}, middleware.After)
}

func addOpCreateSecurityConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateSecurityConfiguration{}, middleware.After)
}

func addOpCreateStudioValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateStudio{}, middleware.After)
}

func addOpCreateStudioSessionMappingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateStudioSessionMapping{}, middleware.After)
}

func addOpDeleteSecurityConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSecurityConfiguration{}, middleware.After)
}

func addOpDeleteStudioValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteStudio{}, middleware.After)
}

func addOpDeleteStudioSessionMappingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteStudioSessionMapping{}, middleware.After)
}

func addOpDescribeClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeCluster{}, middleware.After)
}

func addOpDescribeNotebookExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeNotebookExecution{}, middleware.After)
}

func addOpDescribeSecurityConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeSecurityConfiguration{}, middleware.After)
}

func addOpDescribeStepValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeStep{}, middleware.After)
}

func addOpDescribeStudioValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeStudio{}, middleware.After)
}

func addOpGetAutoTerminationPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAutoTerminationPolicy{}, middleware.After)
}

func addOpGetClusterSessionCredentialsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetClusterSessionCredentials{}, middleware.After)
}

func addOpGetManagedScalingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetManagedScalingPolicy{}, middleware.After)
}

func addOpGetStudioSessionMappingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetStudioSessionMapping{}, middleware.After)
}

func addOpListBootstrapActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListBootstrapActions{}, middleware.After)
}

func addOpListInstanceFleetsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInstanceFleets{}, middleware.After)
}

func addOpListInstanceGroupsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInstanceGroups{}, middleware.After)
}

func addOpListInstancesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInstances{}, middleware.After)
}

func addOpListStepsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListSteps{}, middleware.After)
}

func addOpListSupportedInstanceTypesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListSupportedInstanceTypes{}, middleware.After)
}

func addOpModifyClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpModifyCluster{}, middleware.After)
}

func addOpModifyInstanceFleetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpModifyInstanceFleet{}, middleware.After)
}

func addOpModifyInstanceGroupsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpModifyInstanceGroups{}, middleware.After)
}

func addOpPutAutoScalingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutAutoScalingPolicy{}, middleware.After)
}

func addOpPutAutoTerminationPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutAutoTerminationPolicy{}, middleware.After)
}

func addOpPutBlockPublicAccessConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutBlockPublicAccessConfiguration{}, middleware.After)
}

func addOpPutManagedScalingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutManagedScalingPolicy{}, middleware.After)
}

func addOpRemoveAutoScalingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveAutoScalingPolicy{}, middleware.After)
}

func addOpRemoveAutoTerminationPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveAutoTerminationPolicy{}, middleware.After)
}

func addOpRemoveManagedScalingPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveManagedScalingPolicy{}, middleware.After)
}

func addOpRemoveTagsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveTags{}, middleware.After)
}

func addOpRunJobFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRunJobFlow{}, middleware.After)
}

func addOpSetKeepJobFlowAliveWhenNoStepsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetKeepJobFlowAliveWhenNoSteps{}, middleware.After)
}

func addOpSetTerminationProtectionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetTerminationProtection{}, middleware.After)
}

func addOpSetVisibleToAllUsersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetVisibleToAllUsers{}, middleware.After)
}

func addOpStartNotebookExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartNotebookExecution{}, middleware.After)
}

func addOpStopNotebookExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopNotebookExecution{}, middleware.After)
}

func addOpTerminateJobFlowsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTerminateJobFlows{}, middleware.After)
}

func addOpUpdateStudioValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateStudio{}, middleware.After)
}

func addOpUpdateStudioSessionMappingValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateStudioSessionMapping{}, middleware.After)
}

func validateAutoScalingPolicy(v *types.AutoScalingPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoScalingPolicy"}
	if v.Constraints == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Constraints"))
	} else if v.Constraints != nil {
		if err := validateScalingConstraints(v.Constraints); err != nil {
			invalidParams.AddNested("Constraints", err.(smithy.InvalidParamsError))
		}
	}
	if v.Rules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Rules"))
	} else if v.Rules != nil {
		if err := validateScalingRuleList(v.Rules); err != nil {
			invalidParams.AddNested("Rules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBlockPublicAccessConfiguration(v *types.BlockPublicAccessConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BlockPublicAccessConfiguration"}
	if v.BlockPublicSecurityGroupRules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BlockPublicSecurityGroupRules"))
	}
	if v.PermittedPublicSecurityGroupRuleRanges != nil {
		if err := validatePortRanges(v.PermittedPublicSecurityGroupRuleRanges); err != nil {
			invalidParams.AddNested("PermittedPublicSecurityGroupRuleRanges", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBootstrapActionConfig(v *types.BootstrapActionConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BootstrapActionConfig"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ScriptBootstrapAction == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScriptBootstrapAction"))
	} else if v.ScriptBootstrapAction != nil {
		if err := validateScriptBootstrapActionConfig(v.ScriptBootstrapAction); err != nil {
			invalidParams.AddNested("ScriptBootstrapAction", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBootstrapActionConfigList(v []types.BootstrapActionConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BootstrapActionConfigList"}
	for i := range v {
		if err := validateBootstrapActionConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchAlarmDefinition(v *types.CloudWatchAlarmDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchAlarmDefinition"}
	if len(v.ComparisonOperator) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ComparisonOperator"))
	}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if v.Period == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Period"))
	}
	if v.Threshold == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Threshold"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComputeLimits(v *types.ComputeLimits) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputeLimits"}
	if len(v.UnitType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("UnitType"))
	}
	if v.MinimumCapacityUnits == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinimumCapacityUnits"))
	}
	if v.MaximumCapacityUnits == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaximumCapacityUnits"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEbsBlockDeviceConfig(v *types.EbsBlockDeviceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EbsBlockDeviceConfig"}
	if v.VolumeSpecification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeSpecification"))
	} else if v.VolumeSpecification != nil {
		if err := validateVolumeSpecification(v.VolumeSpecification); err != nil {
			invalidParams.AddNested("VolumeSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEbsBlockDeviceConfigList(v []types.EbsBlockDeviceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EbsBlockDeviceConfigList"}
	for i := range v {
		if err := validateEbsBlockDeviceConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEbsConfiguration(v *types.EbsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EbsConfiguration"}
	if v.EbsBlockDeviceConfigs != nil {
		if err := validateEbsBlockDeviceConfigList(v.EbsBlockDeviceConfigs); err != nil {
			invalidParams.AddNested("EbsBlockDeviceConfigs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExecutionEngineConfig(v *types.ExecutionEngineConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExecutionEngineConfig"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHadoopJarStepConfig(v *types.HadoopJarStepConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HadoopJarStepConfig"}
	if v.Jar == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Jar"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceFleetConfig(v *types.InstanceFleetConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceFleetConfig"}
	if len(v.InstanceFleetType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceFleetType"))
	}
	if v.InstanceTypeConfigs != nil {
		if err := validateInstanceTypeConfigList(v.InstanceTypeConfigs); err != nil {
			invalidParams.AddNested("InstanceTypeConfigs", err.(smithy.InvalidParamsError))
		}
	}
	if v.LaunchSpecifications != nil {
		if err := validateInstanceFleetProvisioningSpecifications(v.LaunchSpecifications); err != nil {
			invalidParams.AddNested("LaunchSpecifications", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResizeSpecifications != nil {
		if err := validateInstanceFleetResizingSpecifications(v.ResizeSpecifications); err != nil {
			invalidParams.AddNested("ResizeSpecifications", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceFleetConfigList(v []types.InstanceFleetConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceFleetConfigList"}
	for i := range v {
		if err := validateInstanceFleetConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceFleetModifyConfig(v *types.InstanceFleetModifyConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceFleetModifyConfig"}
	if v.InstanceFleetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceFleetId"))
	}
	if v.ResizeSpecifications != nil {
		if err := validateInstanceFleetResizingSpecifications(v.ResizeSpecifications); err != nil {
			invalidParams.AddNested("ResizeSpecifications", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceFleetProvisioningSpecifications(v *types.InstanceFleetProvisioningSpecifications) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceFleetProvisioningSpecifications"}
	if v.SpotSpecification != nil {
		if err := validateSpotProvisioningSpecification(v.SpotSpecification); err != nil {
			invalidParams.AddNested("SpotSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if v.OnDemandSpecification != nil {
		if err := validateOnDemandProvisioningSpecification(v.OnDemandSpecification); err != nil {
			invalidParams.AddNested("OnDemandSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceFleetResizingSpecifications(v *types.InstanceFleetResizingSpecifications) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceFleetResizingSpecifications"}
	if v.SpotResizeSpecification != nil {
		if err := validateSpotResizingSpecification(v.SpotResizeSpecification); err != nil {
			invalidParams.AddNested("SpotResizeSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if v.OnDemandResizeSpecification != nil {
		if err := validateOnDemandResizingSpecification(v.OnDemandResizeSpecification); err != nil {
			invalidParams.AddNested("OnDemandResizeSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceGroupConfig(v *types.InstanceGroupConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceGroupConfig"}
	if len(v.InstanceRole) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceRole"))
	}
	if v.InstanceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceType"))
	}
	if v.InstanceCount == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceCount"))
	}
	if v.EbsConfiguration != nil {
		if err := validateEbsConfiguration(v.EbsConfiguration); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.AutoScalingPolicy != nil {
		if err := validateAutoScalingPolicy(v.AutoScalingPolicy); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceGroupConfigList(v []types.InstanceGroupConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceGroupConfigList"}
	for i := range v {
		if err := validateInstanceGroupConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceGroupModifyConfig(v *types.InstanceGroupModifyConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceGroupModifyConfig"}
	if v.InstanceGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceGroupId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceGroupModifyConfigList(v []types.InstanceGroupModifyConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceGroupModifyConfigList"}
	for i := range v {
		if err := validateInstanceGroupModifyConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceTypeConfig(v *types.InstanceTypeConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceTypeConfig"}
	if v.InstanceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceType"))
	}
	if v.EbsConfiguration != nil {
		if err := validateEbsConfiguration(v.EbsConfiguration); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInstanceTypeConfigList(v []types.InstanceTypeConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InstanceTypeConfigList"}
	for i := range v {
		if err := validateInstanceTypeConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateJobFlowInstancesConfig(v *types.JobFlowInstancesConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "JobFlowInstancesConfig"}
	if v.InstanceGroups != nil {
		if err := validateInstanceGroupConfigList(v.InstanceGroups); err != nil {
			invalidParams.AddNested("InstanceGroups", err.(smithy.InvalidParamsError))
		}
	}
	if v.InstanceFleets != nil {
		if err := validateInstanceFleetConfigList(v.InstanceFleets); err != nil {
			invalidParams.AddNested("InstanceFleets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKerberosAttributes(v *types.KerberosAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KerberosAttributes"}
	if v.Realm == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Realm"))
	}
	if v.KdcAdminPassword == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KdcAdminPassword"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateManagedScalingPolicy(v *types.ManagedScalingPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ManagedScalingPolicy"}
	if v.ComputeLimits != nil {
		if err := validateComputeLimits(v.ComputeLimits); err != nil {
			invalidParams.AddNested("ComputeLimits", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOnDemandProvisioningSpecification(v *types.OnDemandProvisioningSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OnDemandProvisioningSpecification"}
	if len(v.AllocationStrategy) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AllocationStrategy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOnDemandResizingSpecification(v *types.OnDemandResizingSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OnDemandResizingSpecification"}
	if v.TimeoutDurationMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeoutDurationMinutes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePlacementGroupConfig(v *types.PlacementGroupConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PlacementGroupConfig"}
	if len(v.InstanceRole) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceRole"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePlacementGroupConfigList(v []types.PlacementGroupConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PlacementGroupConfigList"}
	for i := range v {
		if err := validatePlacementGroupConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePortRange(v *types.PortRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PortRange"}
	if v.MinRange == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinRange"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePortRanges(v []types.PortRange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PortRanges"}
	for i := range v {
		if err := validatePortRange(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScalingAction(v *types.ScalingAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScalingAction"}
	if v.SimpleScalingPolicyConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SimpleScalingPolicyConfiguration"))
	} else if v.SimpleScalingPolicyConfiguration != nil {
		if err := validateSimpleScalingPolicyConfiguration(v.SimpleScalingPolicyConfiguration); err != nil {
			invalidParams.AddNested("SimpleScalingPolicyConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScalingConstraints(v *types.ScalingConstraints) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScalingConstraints"}
	if v.MinCapacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinCapacity"))
	}
	if v.MaxCapacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaxCapacity"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScalingRule(v *types.ScalingRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScalingRule"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateScalingAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.Trigger == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Trigger"))
	} else if v.Trigger != nil {
		if err := validateScalingTrigger(v.Trigger); err != nil {
			invalidParams.AddNested("Trigger", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScalingRuleList(v []types.ScalingRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScalingRuleList"}
	for i := range v {
		if err := validateScalingRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScalingTrigger(v *types.ScalingTrigger) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScalingTrigger"}
	if v.CloudWatchAlarmDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudWatchAlarmDefinition"))
	} else if v.CloudWatchAlarmDefinition != nil {
		if err := validateCloudWatchAlarmDefinition(v.CloudWatchAlarmDefinition); err != nil {
			invalidParams.AddNested("CloudWatchAlarmDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScriptBootstrapActionConfig(v *types.ScriptBootstrapActionConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScriptBootstrapActionConfig"}
	if v.Path == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Path"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSimpleScalingPolicyConfiguration(v *types.SimpleScalingPolicyConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SimpleScalingPolicyConfiguration"}
	if v.ScalingAdjustment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScalingAdjustment"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSpotProvisioningSpecification(v *types.SpotProvisioningSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SpotProvisioningSpecification"}
	if v.TimeoutDurationMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeoutDurationMinutes"))
	}
	if len(v.TimeoutAction) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TimeoutAction"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSpotResizingSpecification(v *types.SpotResizingSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SpotResizingSpecification"}
	if v.TimeoutDurationMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeoutDurationMinutes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStepConfig(v *types.StepConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StepConfig"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.HadoopJarStep == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HadoopJarStep"))
	} else if v.HadoopJarStep != nil {
		if err := validateHadoopJarStepConfig(v.HadoopJarStep); err != nil {
			invalidParams.AddNested("HadoopJarStep", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStepConfigList(v []types.StepConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StepConfigList"}
	for i := range v {
		if err := validateStepConfig(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVolumeSpecification(v *types.VolumeSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VolumeSpecification"}
	if v.VolumeType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeType"))
	}
	if v.SizeInGB == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SizeInGB"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddInstanceFleetInput(v *AddInstanceFleetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddInstanceFleetInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.InstanceFleet == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceFleet"))
	} else if v.InstanceFleet != nil {
		if err := validateInstanceFleetConfig(v.InstanceFleet); err != nil {
			invalidParams.AddNested("InstanceFleet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddInstanceGroupsInput(v *AddInstanceGroupsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddInstanceGroupsInput"}
	if v.InstanceGroups == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceGroups"))
	} else if v.InstanceGroups != nil {
		if err := validateInstanceGroupConfigList(v.InstanceGroups); err != nil {
			invalidParams.AddNested("InstanceGroups", err.(smithy.InvalidParamsError))
		}
	}
	if v.JobFlowId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobFlowId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddJobFlowStepsInput(v *AddJobFlowStepsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddJobFlowStepsInput"}
	if v.JobFlowId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobFlowId"))
	}
	if v.Steps == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Steps"))
	} else if v.Steps != nil {
		if err := validateStepConfigList(v.Steps); err != nil {
			invalidParams.AddNested("Steps", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAddTagsInput(v *AddTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AddTagsInput"}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelStepsInput(v *CancelStepsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelStepsInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.StepIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StepIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateSecurityConfigurationInput(v *CreateSecurityConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSecurityConfigurationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.SecurityConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecurityConfiguration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateStudioInput(v *CreateStudioInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateStudioInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.AuthMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AuthMode"))
	}
	if v.VpcId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcId"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.ServiceRole == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceRole"))
	}
	if v.WorkspaceSecurityGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkspaceSecurityGroupId"))
	}
	if v.EngineSecurityGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EngineSecurityGroupId"))
	}
	if v.DefaultS3Location == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DefaultS3Location"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateStudioSessionMappingInput(v *CreateStudioSessionMappingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateStudioSessionMappingInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if len(v.IdentityType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("IdentityType"))
	}
	if v.SessionPolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionPolicyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSecurityConfigurationInput(v *DeleteSecurityConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSecurityConfigurationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteStudioInput(v *DeleteStudioInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteStudioInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteStudioSessionMappingInput(v *DeleteStudioSessionMappingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteStudioSessionMappingInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if len(v.IdentityType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("IdentityType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeClusterInput(v *DescribeClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeClusterInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeNotebookExecutionInput(v *DescribeNotebookExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeNotebookExecutionInput"}
	if v.NotebookExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NotebookExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeSecurityConfigurationInput(v *DescribeSecurityConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeSecurityConfigurationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeStepInput(v *DescribeStepInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeStepInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.StepId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StepId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeStudioInput(v *DescribeStudioInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeStudioInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAutoTerminationPolicyInput(v *GetAutoTerminationPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAutoTerminationPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetClusterSessionCredentialsInput(v *GetClusterSessionCredentialsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetClusterSessionCredentialsInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetManagedScalingPolicyInput(v *GetManagedScalingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetManagedScalingPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetStudioSessionMappingInput(v *GetStudioSessionMappingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetStudioSessionMappingInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if len(v.IdentityType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("IdentityType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListBootstrapActionsInput(v *ListBootstrapActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListBootstrapActionsInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInstanceFleetsInput(v *ListInstanceFleetsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInstanceFleetsInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInstanceGroupsInput(v *ListInstanceGroupsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInstanceGroupsInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInstancesInput(v *ListInstancesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInstancesInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListStepsInput(v *ListStepsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListStepsInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListSupportedInstanceTypesInput(v *ListSupportedInstanceTypesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListSupportedInstanceTypesInput"}
	if v.ReleaseLabel == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReleaseLabel"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpModifyClusterInput(v *ModifyClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ModifyClusterInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpModifyInstanceFleetInput(v *ModifyInstanceFleetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ModifyInstanceFleetInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.InstanceFleet == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceFleet"))
	} else if v.InstanceFleet != nil {
		if err := validateInstanceFleetModifyConfig(v.InstanceFleet); err != nil {
			invalidParams.AddNested("InstanceFleet", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpModifyInstanceGroupsInput(v *ModifyInstanceGroupsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ModifyInstanceGroupsInput"}
	if v.InstanceGroups != nil {
		if err := validateInstanceGroupModifyConfigList(v.InstanceGroups); err != nil {
			invalidParams.AddNested("InstanceGroups", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutAutoScalingPolicyInput(v *PutAutoScalingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutAutoScalingPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.InstanceGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceGroupId"))
	}
	if v.AutoScalingPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AutoScalingPolicy"))
	} else if v.AutoScalingPolicy != nil {
		if err := validateAutoScalingPolicy(v.AutoScalingPolicy); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutAutoTerminationPolicyInput(v *PutAutoTerminationPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutAutoTerminationPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutBlockPublicAccessConfigurationInput(v *PutBlockPublicAccessConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutBlockPublicAccessConfigurationInput"}
	if v.BlockPublicAccessConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BlockPublicAccessConfiguration"))
	} else if v.BlockPublicAccessConfiguration != nil {
		if err := validateBlockPublicAccessConfiguration(v.BlockPublicAccessConfiguration); err != nil {
			invalidParams.AddNested("BlockPublicAccessConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutManagedScalingPolicyInput(v *PutManagedScalingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutManagedScalingPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.ManagedScalingPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ManagedScalingPolicy"))
	} else if v.ManagedScalingPolicy != nil {
		if err := validateManagedScalingPolicy(v.ManagedScalingPolicy); err != nil {
			invalidParams.AddNested("ManagedScalingPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveAutoScalingPolicyInput(v *RemoveAutoScalingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveAutoScalingPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if v.InstanceGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceGroupId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveAutoTerminationPolicyInput(v *RemoveAutoTerminationPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveAutoTerminationPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveManagedScalingPolicyInput(v *RemoveManagedScalingPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveManagedScalingPolicyInput"}
	if v.ClusterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveTagsInput(v *RemoveTagsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveTagsInput"}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRunJobFlowInput(v *RunJobFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RunJobFlowInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Instances == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Instances"))
	} else if v.Instances != nil {
		if err := validateJobFlowInstancesConfig(v.Instances); err != nil {
			invalidParams.AddNested("Instances", err.(smithy.InvalidParamsError))
		}
	}
	if v.Steps != nil {
		if err := validateStepConfigList(v.Steps); err != nil {
			invalidParams.AddNested("Steps", err.(smithy.InvalidParamsError))
		}
	}
	if v.BootstrapActions != nil {
		if err := validateBootstrapActionConfigList(v.BootstrapActions); err != nil {
			invalidParams.AddNested("BootstrapActions", err.(smithy.InvalidParamsError))
		}
	}
	if v.KerberosAttributes != nil {
		if err := validateKerberosAttributes(v.KerberosAttributes); err != nil {
			invalidParams.AddNested("KerberosAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.ManagedScalingPolicy != nil {
		if err := validateManagedScalingPolicy(v.ManagedScalingPolicy); err != nil {
			invalidParams.AddNested("ManagedScalingPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.PlacementGroupConfigs != nil {
		if err := validatePlacementGroupConfigList(v.PlacementGroupConfigs); err != nil {
			invalidParams.AddNested("PlacementGroupConfigs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetKeepJobFlowAliveWhenNoStepsInput(v *SetKeepJobFlowAliveWhenNoStepsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetKeepJobFlowAliveWhenNoStepsInput"}
	if v.JobFlowIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobFlowIds"))
	}
	if v.KeepJobFlowAliveWhenNoSteps == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeepJobFlowAliveWhenNoSteps"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetTerminationProtectionInput(v *SetTerminationProtectionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetTerminationProtectionInput"}
	if v.JobFlowIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobFlowIds"))
	}
	if v.TerminationProtected == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TerminationProtected"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetVisibleToAllUsersInput(v *SetVisibleToAllUsersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetVisibleToAllUsersInput"}
	if v.JobFlowIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobFlowIds"))
	}
	if v.VisibleToAllUsers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VisibleToAllUsers"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartNotebookExecutionInput(v *StartNotebookExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartNotebookExecutionInput"}
	if v.ExecutionEngine == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExecutionEngine"))
	} else if v.ExecutionEngine != nil {
		if err := validateExecutionEngineConfig(v.ExecutionEngine); err != nil {
			invalidParams.AddNested("ExecutionEngine", err.(smithy.InvalidParamsError))
		}
	}
	if v.ServiceRole == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceRole"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopNotebookExecutionInput(v *StopNotebookExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopNotebookExecutionInput"}
	if v.NotebookExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NotebookExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTerminateJobFlowsInput(v *TerminateJobFlowsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TerminateJobFlowsInput"}
	if v.JobFlowIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobFlowIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateStudioInput(v *UpdateStudioInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateStudioInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateStudioSessionMappingInput(v *UpdateStudioSessionMappingInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateStudioSessionMappingInput"}
	if v.StudioId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StudioId"))
	}
	if len(v.IdentityType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("IdentityType"))
	}
	if v.SessionPolicyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionPolicyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
