// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/admob/v1/admob_resources.proto

package admob

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	date "google.golang.org/genproto/googleapis/type/date"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The sorting order.
type SortOrder int32

const (
	// Default value for an unset field. Do not use.
	SortOrder_SORT_ORDER_UNSPECIFIED SortOrder = 0
	// Sort dimension value or metric value in ascending order.
	SortOrder_ASCENDING SortOrder = 1
	// Sort dimension value or metric value in descending order.
	SortOrder_DESCENDING SortOrder = 2
)

var SortOrder_name = map[int32]string{
	0: "SORT_ORDER_UNSPECIFIED",
	1: "ASCENDING",
	2: "DESCENDING",
}

var SortOrder_value = map[string]int32{
	"SORT_ORDER_UNSPECIFIED": 0,
	"ASCENDING":              1,
	"DESCENDING":             2,
}

func (x SortOrder) String() string {
	return proto.EnumName(SortOrder_name, int32(x))
}

func (SortOrder) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{0}
}

// The dimensions of the network report. Dimensions are data attributes to
// break down or refine the quantitative measurements (metrics) by certain
// attributes, such as the ad format or the platform an ad was viewed on.
type NetworkReportSpec_Dimension int32

const (
	// Default value for an unset field. Do not use.
	NetworkReportSpec_DIMENSION_UNSPECIFIED NetworkReportSpec_Dimension = 0
	// A date in the YYYY-MM-DD format (for example, "2018-12-21"). Requests can
	// specify at most one time dimension.
	NetworkReportSpec_DATE NetworkReportSpec_Dimension = 1
	// A month in the YYYY-MM format (for example, "2018-12"). Requests can
	// specify at most one time dimension.
	NetworkReportSpec_MONTH NetworkReportSpec_Dimension = 2
	// The date of the first day of a week in the YYYY-MM-DD format
	// (for example, "2018-12-21"). Requests can specify at most one time
	// dimension.
	NetworkReportSpec_WEEK NetworkReportSpec_Dimension = 3
	// The unique ID of the ad unit (for example, "ca-app-pub-1234/1234").
	// If AD_UNIT dimension is specified, then APP is included automatically.
	NetworkReportSpec_AD_UNIT NetworkReportSpec_Dimension = 4
	// The unique ID of the mobile application (for example,
	// "ca-app-pub-1234~1234").
	NetworkReportSpec_APP NetworkReportSpec_Dimension = 5
	// CLDR country code of the place where the ad views/clicks occur (for
	// example, "US" or "FR"). This is a geography dimension.
	NetworkReportSpec_COUNTRY NetworkReportSpec_Dimension = 7
	// Format of the ad unit (for example, "banner", "native"), an ad delivery
	// dimension.
	NetworkReportSpec_FORMAT NetworkReportSpec_Dimension = 8
	// Mobile OS platform of the app (for example, "Android" or "iOS").
	NetworkReportSpec_PLATFORM NetworkReportSpec_Dimension = 9
)

var NetworkReportSpec_Dimension_name = map[int32]string{
	0: "DIMENSION_UNSPECIFIED",
	1: "DATE",
	2: "MONTH",
	3: "WEEK",
	4: "AD_UNIT",
	5: "APP",
	7: "COUNTRY",
	8: "FORMAT",
	9: "PLATFORM",
}

var NetworkReportSpec_Dimension_value = map[string]int32{
	"DIMENSION_UNSPECIFIED": 0,
	"DATE":                  1,
	"MONTH":                 2,
	"WEEK":                  3,
	"AD_UNIT":               4,
	"APP":                   5,
	"COUNTRY":               7,
	"FORMAT":                8,
	"PLATFORM":              9,
}

func (x NetworkReportSpec_Dimension) String() string {
	return proto.EnumName(NetworkReportSpec_Dimension_name, int32(x))
}

func (NetworkReportSpec_Dimension) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{1, 0}
}

// The metrics of the network report. Metrics are quantitative measurements
// indicating how the publisher business is performing. They are aggregated
// from the individual ad events and grouped by the report dimensions. The
// metric value is either integer, or decimal (without rounding).
type NetworkReportSpec_Metric int32

const (
	// Default value for an unset field. Do not use.
	NetworkReportSpec_METRIC_UNSPECIFIED NetworkReportSpec_Metric = 0
	// The number of ad requests. The value is an integer.
	NetworkReportSpec_AD_REQUESTS NetworkReportSpec_Metric = 1
	// The number of times a user clicks an ad. The value is an integer.
	NetworkReportSpec_CLICKS NetworkReportSpec_Metric = 2
	// The estimated earnings of the AdMob publisher. The currency unit (USD,
	// EUR, or other) of the earning metrics are determined by the localization
	// setting for currency. The amount is in micros. For example, $6.50 would
	// be represented as 6500000.
	NetworkReportSpec_ESTIMATED_EARNINGS NetworkReportSpec_Metric = 3
	// The total number of ads shown to users. The value is an integer.
	NetworkReportSpec_IMPRESSIONS NetworkReportSpec_Metric = 4
	// The ratio of clicks over impressions. The value is a double precision
	// (approximate) decimal value.
	NetworkReportSpec_IMPRESSION_CTR NetworkReportSpec_Metric = 5
	// The estimated earnings per thousand ad impressions. The value is in
	// micros. For example, $1.03 would be represented as 1030000.
	NetworkReportSpec_IMPRESSION_RPM NetworkReportSpec_Metric = 6
	// The number of times ads are returned in response to a request. The value
	// is an integer.
	NetworkReportSpec_MATCHED_REQUESTS NetworkReportSpec_Metric = 7
	// The ratio of matched ad requests over the total ad requests. The value is
	// a double precision (approximate) decimal value.
	NetworkReportSpec_MATCH_RATE NetworkReportSpec_Metric = 8
	// The ratio of ads that are displayed over ads that are returned, defined
	// as impressions / matched requests. The value is a double precision
	// (approximate) decimal value.
	NetworkReportSpec_SHOW_RATE NetworkReportSpec_Metric = 9
)

var NetworkReportSpec_Metric_name = map[int32]string{
	0: "METRIC_UNSPECIFIED",
	1: "AD_REQUESTS",
	2: "CLICKS",
	3: "ESTIMATED_EARNINGS",
	4: "IMPRESSIONS",
	5: "IMPRESSION_CTR",
	6: "IMPRESSION_RPM",
	7: "MATCHED_REQUESTS",
	8: "MATCH_RATE",
	9: "SHOW_RATE",
}

var NetworkReportSpec_Metric_value = map[string]int32{
	"METRIC_UNSPECIFIED": 0,
	"AD_REQUESTS":        1,
	"CLICKS":             2,
	"ESTIMATED_EARNINGS": 3,
	"IMPRESSIONS":        4,
	"IMPRESSION_CTR":     5,
	"IMPRESSION_RPM":     6,
	"MATCHED_REQUESTS":   7,
	"MATCH_RATE":         8,
	"SHOW_RATE":          9,
}

func (x NetworkReportSpec_Metric) String() string {
	return proto.EnumName(NetworkReportSpec_Metric_name, int32(x))
}

func (NetworkReportSpec_Metric) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{1, 1}
}

// The dimensions of the mediation report. Dimensions are data attributes to
// break down or refine the quantitative measurements (metrics) by certain
// attributes, such as the ad format or the platform an ad was viewed on.
type MediationReportSpec_Dimension int32

const (
	// Default value for an unset field. Do not use.
	MediationReportSpec_DIMENSION_UNSPECIFIED MediationReportSpec_Dimension = 0
	// A date in the YYYY-MM-DD format (for example, "2018-12-21"). Requests can
	// specify at most one time dimension.
	MediationReportSpec_DATE MediationReportSpec_Dimension = 1
	// A month in the YYYY-MM format (for example, "2018-12"). Requests can
	// specify at most one time dimension.
	MediationReportSpec_MONTH MediationReportSpec_Dimension = 2
	// The date of the first day of a week in the YYYY-MM-DD format
	// (for example, "2018-12-21"). Requests can specify at most one time
	// dimension.
	MediationReportSpec_WEEK MediationReportSpec_Dimension = 3
	// The unique ID of the ad source (for example, "5450213213286189855" and
	// "AdMob Network" as label value).
	MediationReportSpec_AD_SOURCE MediationReportSpec_Dimension = 4
	// The unique ID of the ad source instance (for example,
	// "ca-app-pub-1234#5678" and "AdMob (default)" as label value).
	// Warning: The dimension is incompatible with ESTIMATED_EARNINGS and
	// OBSERVED_ECPM metrics.
	MediationReportSpec_AD_SOURCE_INSTANCE MediationReportSpec_Dimension = 5
	// The unique ID of the ad unit (for example, "ca-app-pub-1234/8790").
	// If AD_UNIT dimension is specified, then APP is included automatically.
	MediationReportSpec_AD_UNIT MediationReportSpec_Dimension = 6
	// The unique ID of the mobile application (for example,
	// "ca-app-pub-1234~1234").
	MediationReportSpec_APP MediationReportSpec_Dimension = 7
	// The unique ID of the mediation group (for example,
	// "ca-app-pub-1234:mg:1234" and "AdMob (default)" as label value).
	// Warning: The dimension is incompatible with ESTIMATED_EARNINGS and
	// OBSERVED_ECPM metrics.
	MediationReportSpec_MEDIATION_GROUP MediationReportSpec_Dimension = 11
	// CLDR country code of the place where the ad views/clicks occur (for
	// example, "US" or "FR"). This is a geography dimension.
	MediationReportSpec_COUNTRY MediationReportSpec_Dimension = 8
	// Format of the ad unit (for example, "banner", "native"), an ad delivery
	// dimension.
	MediationReportSpec_FORMAT MediationReportSpec_Dimension = 9
	// Mobile OS platform of the app (for example, "Android" or "iOS").
	MediationReportSpec_PLATFORM MediationReportSpec_Dimension = 10
)

var MediationReportSpec_Dimension_name = map[int32]string{
	0:  "DIMENSION_UNSPECIFIED",
	1:  "DATE",
	2:  "MONTH",
	3:  "WEEK",
	4:  "AD_SOURCE",
	5:  "AD_SOURCE_INSTANCE",
	6:  "AD_UNIT",
	7:  "APP",
	11: "MEDIATION_GROUP",
	8:  "COUNTRY",
	9:  "FORMAT",
	10: "PLATFORM",
}

var MediationReportSpec_Dimension_value = map[string]int32{
	"DIMENSION_UNSPECIFIED": 0,
	"DATE":                  1,
	"MONTH":                 2,
	"WEEK":                  3,
	"AD_SOURCE":             4,
	"AD_SOURCE_INSTANCE":    5,
	"AD_UNIT":               6,
	"APP":                   7,
	"MEDIATION_GROUP":       11,
	"COUNTRY":               8,
	"FORMAT":                9,
	"PLATFORM":              10,
}

func (x MediationReportSpec_Dimension) String() string {
	return proto.EnumName(MediationReportSpec_Dimension_name, int32(x))
}

func (MediationReportSpec_Dimension) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{2, 0}
}

// The metrics of the mediation report. Metrics are quantitative measurements
// indicating how the publisher business is performing. They are aggregated
// from the individual ad events and grouped by the report dimensions. The
// metric value is either integer, or decimal (without rounding).
type MediationReportSpec_Metric int32

const (
	// Default value for an unset field. Do not use.
	MediationReportSpec_METRIC_UNSPECIFIED MediationReportSpec_Metric = 0
	// The number of requests. The value is an integer.
	MediationReportSpec_AD_REQUESTS MediationReportSpec_Metric = 1
	// The number of times a user clicks an ad. The value is an integer.
	MediationReportSpec_CLICKS MediationReportSpec_Metric = 2
	// The estimated earnings of the AdMob publisher. The currency unit (USD,
	// EUR, or other) of the earning metrics are determined by the localization
	// setting for currency. The amount is in micros. For example, $6.50 would
	// be represented as 6500000.
	// Warning: The metric is incompatible with AD_SOURCE_INSTANCE and
	// MEDIATION_GROUP dimensions.
	MediationReportSpec_ESTIMATED_EARNINGS MediationReportSpec_Metric = 3
	// The total number of ads shown to users. The value is an integer.
	MediationReportSpec_IMPRESSIONS MediationReportSpec_Metric = 4
	// The ratio of clicks over impressions. The value is a double precision
	// (approximate) decimal value.
	MediationReportSpec_IMPRESSION_CTR MediationReportSpec_Metric = 5
	// The number of times ads are returned in response to a request. The value
	// is an integer.
	MediationReportSpec_MATCHED_REQUESTS MediationReportSpec_Metric = 6
	// The ratio of matched ad requests over the total ad requests. The value is
	// a double precision (approximate) decimal value.
	MediationReportSpec_MATCH_RATE MediationReportSpec_Metric = 7
	// The third-party ad network's estimated average eCPM. The currency unit
	// (USD, EUR, or other) of the earning metrics are determined by the
	// localization setting for currency. The amount is in micros. For example,
	// $2.30 would be represented as 2300000.
	// Warning: The metric is incompatible with AD_SOURCE_INSTANCE and
	// MEDIATION_GROUP dimensions.
	MediationReportSpec_OBSERVED_ECPM MediationReportSpec_Metric = 8
)

var MediationReportSpec_Metric_name = map[int32]string{
	0: "METRIC_UNSPECIFIED",
	1: "AD_REQUESTS",
	2: "CLICKS",
	3: "ESTIMATED_EARNINGS",
	4: "IMPRESSIONS",
	5: "IMPRESSION_CTR",
	6: "MATCHED_REQUESTS",
	7: "MATCH_RATE",
	8: "OBSERVED_ECPM",
}

var MediationReportSpec_Metric_value = map[string]int32{
	"METRIC_UNSPECIFIED": 0,
	"AD_REQUESTS":        1,
	"CLICKS":             2,
	"ESTIMATED_EARNINGS": 3,
	"IMPRESSIONS":        4,
	"IMPRESSION_CTR":     5,
	"MATCHED_REQUESTS":   6,
	"MATCH_RATE":         7,
	"OBSERVED_ECPM":      8,
}

func (x MediationReportSpec_Metric) String() string {
	return proto.EnumName(MediationReportSpec_Metric_name, int32(x))
}

func (MediationReportSpec_Metric) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{2, 1}
}

// Warning type.
type ReportWarning_Type int32

const (
	// Default value for an unset field. Do not use.
	ReportWarning_TYPE_UNSPECIFIED ReportWarning_Type = 0
	// Some data in this report is aggregated based on a time zone different
	// from the requested time zone. This could happen if a local time-zone
	// report has the start time before the last time this time zone changed.
	// The description field will contain the date of the last time zone
	// change.
	ReportWarning_DATA_BEFORE_ACCOUNT_TIMEZONE_CHANGE ReportWarning_Type = 1
	// There is an unusual delay in processing the source data for the
	// requested date range. The report results might be less up to date than
	// usual. AdMob is aware of the issue and is actively working to resolve
	// it.
	ReportWarning_DATA_DELAYED ReportWarning_Type = 2
	// Warnings that are exposed without a specific type. Useful when new
	// warning types are added but the API is not changed yet.
	ReportWarning_OTHER ReportWarning_Type = 3
	// The currency being requested is not the account currency. The earning
	// metrics will be based on the requested currency, and thus not a good
	// estimation of the final payment anymore, due to the currency rate
	// fluctuation.
	ReportWarning_REPORT_CURRENCY_NOT_ACCOUNT_CURRENCY ReportWarning_Type = 4
)

var ReportWarning_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "DATA_BEFORE_ACCOUNT_TIMEZONE_CHANGE",
	2: "DATA_DELAYED",
	3: "OTHER",
	4: "REPORT_CURRENCY_NOT_ACCOUNT_CURRENCY",
}

var ReportWarning_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":                     0,
	"DATA_BEFORE_ACCOUNT_TIMEZONE_CHANGE":  1,
	"DATA_DELAYED":                         2,
	"OTHER":                                3,
	"REPORT_CURRENCY_NOT_ACCOUNT_CURRENCY": 4,
}

func (x ReportWarning_Type) String() string {
	return proto.EnumName(ReportWarning_Type_name, int32(x))
}

func (ReportWarning_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{4, 0}
}

// A publisher account contains information relevant to the use of this API,
// such as the time zone used for the reports.
type PublisherAccount struct {
	// Resource name of this account.
	// Format is accounts/{publisher_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique ID by which this publisher account can be identified
	// in the API requests (for example, pub-1234567890).
	PublisherId string `protobuf:"bytes,2,opt,name=publisher_id,json=publisherId,proto3" json:"publisher_id,omitempty"`
	// The time zone that is used in reports that are generated for this account.
	// The value is a time-zone ID as specified by the CLDR project,
	// for example, "America/Los_Angeles".
	ReportingTimeZone string `protobuf:"bytes,3,opt,name=reporting_time_zone,json=reportingTimeZone,proto3" json:"reporting_time_zone,omitempty"`
	// Currency code of the earning-related metrics, which is the 3-letter code
	// defined in ISO 4217. The daily average rate is used for the currency
	// conversion.
	CurrencyCode         string   `protobuf:"bytes,4,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublisherAccount) Reset()         { *m = PublisherAccount{} }
func (m *PublisherAccount) String() string { return proto.CompactTextString(m) }
func (*PublisherAccount) ProtoMessage()    {}
func (*PublisherAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{0}
}

func (m *PublisherAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublisherAccount.Unmarshal(m, b)
}
func (m *PublisherAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublisherAccount.Marshal(b, m, deterministic)
}
func (m *PublisherAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublisherAccount.Merge(m, src)
}
func (m *PublisherAccount) XXX_Size() int {
	return xxx_messageInfo_PublisherAccount.Size(m)
}
func (m *PublisherAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_PublisherAccount.DiscardUnknown(m)
}

var xxx_messageInfo_PublisherAccount proto.InternalMessageInfo

func (m *PublisherAccount) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PublisherAccount) GetPublisherId() string {
	if m != nil {
		return m.PublisherId
	}
	return ""
}

func (m *PublisherAccount) GetReportingTimeZone() string {
	if m != nil {
		return m.ReportingTimeZone
	}
	return ""
}

func (m *PublisherAccount) GetCurrencyCode() string {
	if m != nil {
		return m.CurrencyCode
	}
	return ""
}

// The specification for generating an AdMob Network report.
// For example, the specification to get clicks and estimated earnings for only
// the 'US' and 'CN' countries can look like the following example:
//
//     {
//       'date_range': {
//         'start_date': {'year': 2018, 'month': 9, 'day': 1},
//         'end_date': {'year': 2018, 'month': 9, 'day': 30}
//       },
//       'dimensions': ['DATE', 'APP', 'COUNTRY'],
//       'metrics': ['CLICKS', 'ESTIMATED_EARNINGS'],
//       'dimension_filters': [
//         {
//           'dimension': 'COUNTRY',
//           'matches_any': {'values': [{'value': 'US', 'value': 'CN'}]}
//         }
//       ],
//       'sort_conditions': [
//         {'dimension':'APP', order: 'ASCENDING'},
//         {'metric':'CLICKS', order: 'DESCENDING'}
//       ],
//       'localization_settings': {
//         'currency_code': 'USD',
//         'language_code': 'en-US'
//       }
//     }
//
// For a better understanding, you can treat the preceding specification like
// the following pseudo SQL:
//
//     SELECT DATE, APP, COUNTRY, CLICKS, ESTIMATED_EARNINGS
//     FROM NETWORK_REPORT
//     WHERE DATE >= '2018-09-01' AND DATE <= '2018-09-30'
//         AND COUNTRY IN ('US', 'CN')
//     GROUP BY DATE, APP, COUNTRY
//     ORDER BY APP ASC, CLICKS DESC;
type NetworkReportSpec struct {
	// The date range for which the report is generated.
	DateRange *DateRange `protobuf:"bytes,1,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// List of dimensions of the report. The value combination of these dimensions
	// determines the row of the report. If no dimensions are specified, the
	// report returns a single row of requested metrics for the entire account.
	Dimensions []NetworkReportSpec_Dimension `protobuf:"varint,2,rep,packed,name=dimensions,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Dimension" json:"dimensions,omitempty"`
	// List of metrics of the report. A report must specify at least one metric.
	Metrics []NetworkReportSpec_Metric `protobuf:"varint,3,rep,packed,name=metrics,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Metric" json:"metrics,omitempty"`
	// Describes which report rows to match based on their dimension values.
	DimensionFilters []*NetworkReportSpec_DimensionFilter `protobuf:"bytes,4,rep,name=dimension_filters,json=dimensionFilters,proto3" json:"dimension_filters,omitempty"`
	// Describes the sorting of report rows. The order of the condition in the
	// list defines its precedence; the earlier the condition, the higher its
	// precedence. If no sort conditions are specified, the row ordering is
	// undefined.
	SortConditions []*NetworkReportSpec_SortCondition `protobuf:"bytes,5,rep,name=sort_conditions,json=sortConditions,proto3" json:"sort_conditions,omitempty"`
	// Localization settings of the report.
	LocalizationSettings *LocalizationSettings `protobuf:"bytes,6,opt,name=localization_settings,json=localizationSettings,proto3" json:"localization_settings,omitempty"`
	// Maximum number of report data rows to return. If the value is not set, the
	// API returns as many rows as possible, up to 100000. Acceptable values are
	// 1-100000, inclusive. Any other values are treated as 100000.
	MaxReportRows        int32    `protobuf:"varint,7,opt,name=max_report_rows,json=maxReportRows,proto3" json:"max_report_rows,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkReportSpec) Reset()         { *m = NetworkReportSpec{} }
func (m *NetworkReportSpec) String() string { return proto.CompactTextString(m) }
func (*NetworkReportSpec) ProtoMessage()    {}
func (*NetworkReportSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{1}
}

func (m *NetworkReportSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkReportSpec.Unmarshal(m, b)
}
func (m *NetworkReportSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkReportSpec.Marshal(b, m, deterministic)
}
func (m *NetworkReportSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkReportSpec.Merge(m, src)
}
func (m *NetworkReportSpec) XXX_Size() int {
	return xxx_messageInfo_NetworkReportSpec.Size(m)
}
func (m *NetworkReportSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkReportSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkReportSpec proto.InternalMessageInfo

func (m *NetworkReportSpec) GetDateRange() *DateRange {
	if m != nil {
		return m.DateRange
	}
	return nil
}

func (m *NetworkReportSpec) GetDimensions() []NetworkReportSpec_Dimension {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

func (m *NetworkReportSpec) GetMetrics() []NetworkReportSpec_Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *NetworkReportSpec) GetDimensionFilters() []*NetworkReportSpec_DimensionFilter {
	if m != nil {
		return m.DimensionFilters
	}
	return nil
}

func (m *NetworkReportSpec) GetSortConditions() []*NetworkReportSpec_SortCondition {
	if m != nil {
		return m.SortConditions
	}
	return nil
}

func (m *NetworkReportSpec) GetLocalizationSettings() *LocalizationSettings {
	if m != nil {
		return m.LocalizationSettings
	}
	return nil
}

func (m *NetworkReportSpec) GetMaxReportRows() int32 {
	if m != nil {
		return m.MaxReportRows
	}
	return 0
}

// Describes which report rows to match based on their dimension values.
type NetworkReportSpec_DimensionFilter struct {
	// Applies the filter criterion to the specified dimension.
	Dimension NetworkReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Dimension" json:"dimension,omitempty"`
	// Filter operator to be applied.
	//
	// Types that are valid to be assigned to Operator:
	//	*NetworkReportSpec_DimensionFilter_MatchesAny
	Operator             isNetworkReportSpec_DimensionFilter_Operator `protobuf_oneof:"operator"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *NetworkReportSpec_DimensionFilter) Reset()         { *m = NetworkReportSpec_DimensionFilter{} }
func (m *NetworkReportSpec_DimensionFilter) String() string { return proto.CompactTextString(m) }
func (*NetworkReportSpec_DimensionFilter) ProtoMessage()    {}
func (*NetworkReportSpec_DimensionFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{1, 0}
}

func (m *NetworkReportSpec_DimensionFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkReportSpec_DimensionFilter.Unmarshal(m, b)
}
func (m *NetworkReportSpec_DimensionFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkReportSpec_DimensionFilter.Marshal(b, m, deterministic)
}
func (m *NetworkReportSpec_DimensionFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkReportSpec_DimensionFilter.Merge(m, src)
}
func (m *NetworkReportSpec_DimensionFilter) XXX_Size() int {
	return xxx_messageInfo_NetworkReportSpec_DimensionFilter.Size(m)
}
func (m *NetworkReportSpec_DimensionFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkReportSpec_DimensionFilter.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkReportSpec_DimensionFilter proto.InternalMessageInfo

func (m *NetworkReportSpec_DimensionFilter) GetDimension() NetworkReportSpec_Dimension {
	if m != nil {
		return m.Dimension
	}
	return NetworkReportSpec_DIMENSION_UNSPECIFIED
}

type isNetworkReportSpec_DimensionFilter_Operator interface {
	isNetworkReportSpec_DimensionFilter_Operator()
}

type NetworkReportSpec_DimensionFilter_MatchesAny struct {
	MatchesAny *StringList `protobuf:"bytes,2,opt,name=matches_any,json=matchesAny,proto3,oneof"`
}

func (*NetworkReportSpec_DimensionFilter_MatchesAny) isNetworkReportSpec_DimensionFilter_Operator() {}

func (m *NetworkReportSpec_DimensionFilter) GetOperator() isNetworkReportSpec_DimensionFilter_Operator {
	if m != nil {
		return m.Operator
	}
	return nil
}

func (m *NetworkReportSpec_DimensionFilter) GetMatchesAny() *StringList {
	if x, ok := m.GetOperator().(*NetworkReportSpec_DimensionFilter_MatchesAny); ok {
		return x.MatchesAny
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkReportSpec_DimensionFilter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkReportSpec_DimensionFilter_MatchesAny)(nil),
	}
}

// Sorting direction to be applied on a dimension or a metric.
type NetworkReportSpec_SortCondition struct {
	// Identifies which values to sort on.
	//
	// Types that are valid to be assigned to SortOn:
	//	*NetworkReportSpec_SortCondition_Dimension
	//	*NetworkReportSpec_SortCondition_Metric
	SortOn isNetworkReportSpec_SortCondition_SortOn `protobuf_oneof:"sort_on"`
	// Sorting order of the dimension or metric.
	Order                SortOrder `protobuf:"varint,3,opt,name=order,proto3,enum=google.ads.admob.v1.SortOrder" json:"order,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *NetworkReportSpec_SortCondition) Reset()         { *m = NetworkReportSpec_SortCondition{} }
func (m *NetworkReportSpec_SortCondition) String() string { return proto.CompactTextString(m) }
func (*NetworkReportSpec_SortCondition) ProtoMessage()    {}
func (*NetworkReportSpec_SortCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{1, 1}
}

func (m *NetworkReportSpec_SortCondition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkReportSpec_SortCondition.Unmarshal(m, b)
}
func (m *NetworkReportSpec_SortCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkReportSpec_SortCondition.Marshal(b, m, deterministic)
}
func (m *NetworkReportSpec_SortCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkReportSpec_SortCondition.Merge(m, src)
}
func (m *NetworkReportSpec_SortCondition) XXX_Size() int {
	return xxx_messageInfo_NetworkReportSpec_SortCondition.Size(m)
}
func (m *NetworkReportSpec_SortCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkReportSpec_SortCondition.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkReportSpec_SortCondition proto.InternalMessageInfo

type isNetworkReportSpec_SortCondition_SortOn interface {
	isNetworkReportSpec_SortCondition_SortOn()
}

type NetworkReportSpec_SortCondition_Dimension struct {
	Dimension NetworkReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Dimension,oneof"`
}

type NetworkReportSpec_SortCondition_Metric struct {
	Metric NetworkReportSpec_Metric `protobuf:"varint,2,opt,name=metric,proto3,enum=google.ads.admob.v1.NetworkReportSpec_Metric,oneof"`
}

func (*NetworkReportSpec_SortCondition_Dimension) isNetworkReportSpec_SortCondition_SortOn() {}

func (*NetworkReportSpec_SortCondition_Metric) isNetworkReportSpec_SortCondition_SortOn() {}

func (m *NetworkReportSpec_SortCondition) GetSortOn() isNetworkReportSpec_SortCondition_SortOn {
	if m != nil {
		return m.SortOn
	}
	return nil
}

func (m *NetworkReportSpec_SortCondition) GetDimension() NetworkReportSpec_Dimension {
	if x, ok := m.GetSortOn().(*NetworkReportSpec_SortCondition_Dimension); ok {
		return x.Dimension
	}
	return NetworkReportSpec_DIMENSION_UNSPECIFIED
}

func (m *NetworkReportSpec_SortCondition) GetMetric() NetworkReportSpec_Metric {
	if x, ok := m.GetSortOn().(*NetworkReportSpec_SortCondition_Metric); ok {
		return x.Metric
	}
	return NetworkReportSpec_METRIC_UNSPECIFIED
}

func (m *NetworkReportSpec_SortCondition) GetOrder() SortOrder {
	if m != nil {
		return m.Order
	}
	return SortOrder_SORT_ORDER_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NetworkReportSpec_SortCondition) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NetworkReportSpec_SortCondition_Dimension)(nil),
		(*NetworkReportSpec_SortCondition_Metric)(nil),
	}
}

// The specification for generating an AdMob Mediation report.
// For example, the specification to get observed ECPM sliced by ad source and
// app for the 'US' and 'CN' countries can look like the following example:
//
//     {
//       "date_range": {
//         "start_date": {"year": 2018, "month": 9, "day": 1},
//         "end_date": {"year": 2018, "month": 9, "day": 30}
//       },
//       "dimensions": ["AD_SOURCE", "APP", "COUNTRY"],
//       "metrics": ["OBSERVED_ECPM"],
//       "dimension_filters": [
//         {
//           "dimension": "COUNTRY",
//           "matches_any": {"values": [{"value": "US", "value": "CN"}]}
//         }
//       ],
//       "sort_conditions": [
//         {"dimension":"APP", order: "ASCENDING"}
//       ],
//       "localization_settings": {
//         "currency_code": "USD",
//         "language_code": "en-US"
//       }
//     }
//
// For a better understanding, you can treat the preceding specification like
// the following pseudo SQL:
//
//     SELECT AD_SOURCE, APP, COUNTRY, OBSERVED_ECPM
//     FROM MEDIATION_REPORT
//     WHERE DATE >= '2018-09-01' AND DATE <= '2018-09-30'
//         AND COUNTRY IN ('US', 'CN')
//     GROUP BY AD_SOURCE, APP, COUNTRY
//     ORDER BY APP ASC;
type MediationReportSpec struct {
	// The date range for which the report is generated.
	DateRange *DateRange `protobuf:"bytes,1,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// List of dimensions of the report. The value combination of these dimensions
	// determines the row of the report. If no dimensions are specified, the
	// report returns a single row of requested metrics for the entire account.
	Dimensions []MediationReportSpec_Dimension `protobuf:"varint,2,rep,packed,name=dimensions,proto3,enum=google.ads.admob.v1.MediationReportSpec_Dimension" json:"dimensions,omitempty"`
	// List of metrics of the report. A report must specify at least one metric.
	Metrics []MediationReportSpec_Metric `protobuf:"varint,3,rep,packed,name=metrics,proto3,enum=google.ads.admob.v1.MediationReportSpec_Metric" json:"metrics,omitempty"`
	// Describes which report rows to match based on their dimension values.
	DimensionFilters []*MediationReportSpec_DimensionFilter `protobuf:"bytes,4,rep,name=dimension_filters,json=dimensionFilters,proto3" json:"dimension_filters,omitempty"`
	// Describes the sorting of report rows. The order of the condition in the
	// list defines its precedence; the earlier the condition, the higher its
	// precedence. If no sort conditions are specified, the row ordering is
	// undefined.
	SortConditions []*MediationReportSpec_SortCondition `protobuf:"bytes,5,rep,name=sort_conditions,json=sortConditions,proto3" json:"sort_conditions,omitempty"`
	// Localization settings of the report.
	LocalizationSettings *LocalizationSettings `protobuf:"bytes,6,opt,name=localization_settings,json=localizationSettings,proto3" json:"localization_settings,omitempty"`
	// Maximum number of report data rows to return. If the value is not set, the
	// API returns as many rows as possible, up to 100000. Acceptable values are
	// 1-100000, inclusive. Any other values are treated as 100000.
	MaxReportRows        int32    `protobuf:"varint,7,opt,name=max_report_rows,json=maxReportRows,proto3" json:"max_report_rows,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MediationReportSpec) Reset()         { *m = MediationReportSpec{} }
func (m *MediationReportSpec) String() string { return proto.CompactTextString(m) }
func (*MediationReportSpec) ProtoMessage()    {}
func (*MediationReportSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{2}
}

func (m *MediationReportSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediationReportSpec.Unmarshal(m, b)
}
func (m *MediationReportSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediationReportSpec.Marshal(b, m, deterministic)
}
func (m *MediationReportSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediationReportSpec.Merge(m, src)
}
func (m *MediationReportSpec) XXX_Size() int {
	return xxx_messageInfo_MediationReportSpec.Size(m)
}
func (m *MediationReportSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_MediationReportSpec.DiscardUnknown(m)
}

var xxx_messageInfo_MediationReportSpec proto.InternalMessageInfo

func (m *MediationReportSpec) GetDateRange() *DateRange {
	if m != nil {
		return m.DateRange
	}
	return nil
}

func (m *MediationReportSpec) GetDimensions() []MediationReportSpec_Dimension {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

func (m *MediationReportSpec) GetMetrics() []MediationReportSpec_Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *MediationReportSpec) GetDimensionFilters() []*MediationReportSpec_DimensionFilter {
	if m != nil {
		return m.DimensionFilters
	}
	return nil
}

func (m *MediationReportSpec) GetSortConditions() []*MediationReportSpec_SortCondition {
	if m != nil {
		return m.SortConditions
	}
	return nil
}

func (m *MediationReportSpec) GetLocalizationSettings() *LocalizationSettings {
	if m != nil {
		return m.LocalizationSettings
	}
	return nil
}

func (m *MediationReportSpec) GetMaxReportRows() int32 {
	if m != nil {
		return m.MaxReportRows
	}
	return 0
}

// Describes which report rows to match based on their dimension values.
type MediationReportSpec_DimensionFilter struct {
	// Applies the filter criterion to the specified dimension.
	Dimension MediationReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.MediationReportSpec_Dimension" json:"dimension,omitempty"`
	// Filter operator to be applied.
	//
	// Types that are valid to be assigned to Operator:
	//	*MediationReportSpec_DimensionFilter_MatchesAny
	Operator             isMediationReportSpec_DimensionFilter_Operator `protobuf_oneof:"operator"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *MediationReportSpec_DimensionFilter) Reset()         { *m = MediationReportSpec_DimensionFilter{} }
func (m *MediationReportSpec_DimensionFilter) String() string { return proto.CompactTextString(m) }
func (*MediationReportSpec_DimensionFilter) ProtoMessage()    {}
func (*MediationReportSpec_DimensionFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{2, 0}
}

func (m *MediationReportSpec_DimensionFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediationReportSpec_DimensionFilter.Unmarshal(m, b)
}
func (m *MediationReportSpec_DimensionFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediationReportSpec_DimensionFilter.Marshal(b, m, deterministic)
}
func (m *MediationReportSpec_DimensionFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediationReportSpec_DimensionFilter.Merge(m, src)
}
func (m *MediationReportSpec_DimensionFilter) XXX_Size() int {
	return xxx_messageInfo_MediationReportSpec_DimensionFilter.Size(m)
}
func (m *MediationReportSpec_DimensionFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_MediationReportSpec_DimensionFilter.DiscardUnknown(m)
}

var xxx_messageInfo_MediationReportSpec_DimensionFilter proto.InternalMessageInfo

func (m *MediationReportSpec_DimensionFilter) GetDimension() MediationReportSpec_Dimension {
	if m != nil {
		return m.Dimension
	}
	return MediationReportSpec_DIMENSION_UNSPECIFIED
}

type isMediationReportSpec_DimensionFilter_Operator interface {
	isMediationReportSpec_DimensionFilter_Operator()
}

type MediationReportSpec_DimensionFilter_MatchesAny struct {
	MatchesAny *StringList `protobuf:"bytes,2,opt,name=matches_any,json=matchesAny,proto3,oneof"`
}

func (*MediationReportSpec_DimensionFilter_MatchesAny) isMediationReportSpec_DimensionFilter_Operator() {
}

func (m *MediationReportSpec_DimensionFilter) GetOperator() isMediationReportSpec_DimensionFilter_Operator {
	if m != nil {
		return m.Operator
	}
	return nil
}

func (m *MediationReportSpec_DimensionFilter) GetMatchesAny() *StringList {
	if x, ok := m.GetOperator().(*MediationReportSpec_DimensionFilter_MatchesAny); ok {
		return x.MatchesAny
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MediationReportSpec_DimensionFilter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MediationReportSpec_DimensionFilter_MatchesAny)(nil),
	}
}

// Sorting direction to be applied on a dimension or a metric.
type MediationReportSpec_SortCondition struct {
	// Identifies which values to sort on.
	//
	// Types that are valid to be assigned to SortOn:
	//	*MediationReportSpec_SortCondition_Dimension
	//	*MediationReportSpec_SortCondition_Metric
	SortOn isMediationReportSpec_SortCondition_SortOn `protobuf_oneof:"sort_on"`
	// Sorting order of the dimension or metric.
	Order                SortOrder `protobuf:"varint,3,opt,name=order,proto3,enum=google.ads.admob.v1.SortOrder" json:"order,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MediationReportSpec_SortCondition) Reset()         { *m = MediationReportSpec_SortCondition{} }
func (m *MediationReportSpec_SortCondition) String() string { return proto.CompactTextString(m) }
func (*MediationReportSpec_SortCondition) ProtoMessage()    {}
func (*MediationReportSpec_SortCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{2, 1}
}

func (m *MediationReportSpec_SortCondition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediationReportSpec_SortCondition.Unmarshal(m, b)
}
func (m *MediationReportSpec_SortCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediationReportSpec_SortCondition.Marshal(b, m, deterministic)
}
func (m *MediationReportSpec_SortCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediationReportSpec_SortCondition.Merge(m, src)
}
func (m *MediationReportSpec_SortCondition) XXX_Size() int {
	return xxx_messageInfo_MediationReportSpec_SortCondition.Size(m)
}
func (m *MediationReportSpec_SortCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_MediationReportSpec_SortCondition.DiscardUnknown(m)
}

var xxx_messageInfo_MediationReportSpec_SortCondition proto.InternalMessageInfo

type isMediationReportSpec_SortCondition_SortOn interface {
	isMediationReportSpec_SortCondition_SortOn()
}

type MediationReportSpec_SortCondition_Dimension struct {
	Dimension MediationReportSpec_Dimension `protobuf:"varint,1,opt,name=dimension,proto3,enum=google.ads.admob.v1.MediationReportSpec_Dimension,oneof"`
}

type MediationReportSpec_SortCondition_Metric struct {
	Metric MediationReportSpec_Metric `protobuf:"varint,2,opt,name=metric,proto3,enum=google.ads.admob.v1.MediationReportSpec_Metric,oneof"`
}

func (*MediationReportSpec_SortCondition_Dimension) isMediationReportSpec_SortCondition_SortOn() {}

func (*MediationReportSpec_SortCondition_Metric) isMediationReportSpec_SortCondition_SortOn() {}

func (m *MediationReportSpec_SortCondition) GetSortOn() isMediationReportSpec_SortCondition_SortOn {
	if m != nil {
		return m.SortOn
	}
	return nil
}

func (m *MediationReportSpec_SortCondition) GetDimension() MediationReportSpec_Dimension {
	if x, ok := m.GetSortOn().(*MediationReportSpec_SortCondition_Dimension); ok {
		return x.Dimension
	}
	return MediationReportSpec_DIMENSION_UNSPECIFIED
}

func (m *MediationReportSpec_SortCondition) GetMetric() MediationReportSpec_Metric {
	if x, ok := m.GetSortOn().(*MediationReportSpec_SortCondition_Metric); ok {
		return x.Metric
	}
	return MediationReportSpec_METRIC_UNSPECIFIED
}

func (m *MediationReportSpec_SortCondition) GetOrder() SortOrder {
	if m != nil {
		return m.Order
	}
	return SortOrder_SORT_ORDER_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MediationReportSpec_SortCondition) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MediationReportSpec_SortCondition_Dimension)(nil),
		(*MediationReportSpec_SortCondition_Metric)(nil),
	}
}

// A row of the returning report.
type ReportRow struct {
	// Map of dimension values in a row, with keys as enum name of the dimensions.
	DimensionValues map[string]*ReportRow_DimensionValue `protobuf:"bytes,1,rep,name=dimension_values,json=dimensionValues,proto3" json:"dimension_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Map of metric values in a row, with keys as enum name of the metrics. If
	// a metric being requested has no value returned, the map will not include
	// it.
	MetricValues         map[string]*ReportRow_MetricValue `protobuf:"bytes,2,rep,name=metric_values,json=metricValues,proto3" json:"metric_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ReportRow) Reset()         { *m = ReportRow{} }
func (m *ReportRow) String() string { return proto.CompactTextString(m) }
func (*ReportRow) ProtoMessage()    {}
func (*ReportRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{3}
}

func (m *ReportRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportRow.Unmarshal(m, b)
}
func (m *ReportRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportRow.Marshal(b, m, deterministic)
}
func (m *ReportRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportRow.Merge(m, src)
}
func (m *ReportRow) XXX_Size() int {
	return xxx_messageInfo_ReportRow.Size(m)
}
func (m *ReportRow) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportRow.DiscardUnknown(m)
}

var xxx_messageInfo_ReportRow proto.InternalMessageInfo

func (m *ReportRow) GetDimensionValues() map[string]*ReportRow_DimensionValue {
	if m != nil {
		return m.DimensionValues
	}
	return nil
}

func (m *ReportRow) GetMetricValues() map[string]*ReportRow_MetricValue {
	if m != nil {
		return m.MetricValues
	}
	return nil
}

// Representation of a dimension value.
type ReportRow_DimensionValue struct {
	// Dimension value in the format specified in the report's spec Dimension
	// enum.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The localized string representation of the value. If unspecified, the
	// display label should be derived from the value.
	DisplayLabel         string   `protobuf:"bytes,2,opt,name=display_label,json=displayLabel,proto3" json:"display_label,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportRow_DimensionValue) Reset()         { *m = ReportRow_DimensionValue{} }
func (m *ReportRow_DimensionValue) String() string { return proto.CompactTextString(m) }
func (*ReportRow_DimensionValue) ProtoMessage()    {}
func (*ReportRow_DimensionValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{3, 0}
}

func (m *ReportRow_DimensionValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportRow_DimensionValue.Unmarshal(m, b)
}
func (m *ReportRow_DimensionValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportRow_DimensionValue.Marshal(b, m, deterministic)
}
func (m *ReportRow_DimensionValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportRow_DimensionValue.Merge(m, src)
}
func (m *ReportRow_DimensionValue) XXX_Size() int {
	return xxx_messageInfo_ReportRow_DimensionValue.Size(m)
}
func (m *ReportRow_DimensionValue) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportRow_DimensionValue.DiscardUnknown(m)
}

var xxx_messageInfo_ReportRow_DimensionValue proto.InternalMessageInfo

func (m *ReportRow_DimensionValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *ReportRow_DimensionValue) GetDisplayLabel() string {
	if m != nil {
		return m.DisplayLabel
	}
	return ""
}

// Representation of a metric value.
type ReportRow_MetricValue struct {
	// Metric value in the format specified in the report's spec Metric enum
	// name.
	//
	// Types that are valid to be assigned to Value:
	//	*ReportRow_MetricValue_IntegerValue
	//	*ReportRow_MetricValue_DoubleValue
	//	*ReportRow_MetricValue_MicrosValue
	Value                isReportRow_MetricValue_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ReportRow_MetricValue) Reset()         { *m = ReportRow_MetricValue{} }
func (m *ReportRow_MetricValue) String() string { return proto.CompactTextString(m) }
func (*ReportRow_MetricValue) ProtoMessage()    {}
func (*ReportRow_MetricValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{3, 1}
}

func (m *ReportRow_MetricValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportRow_MetricValue.Unmarshal(m, b)
}
func (m *ReportRow_MetricValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportRow_MetricValue.Marshal(b, m, deterministic)
}
func (m *ReportRow_MetricValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportRow_MetricValue.Merge(m, src)
}
func (m *ReportRow_MetricValue) XXX_Size() int {
	return xxx_messageInfo_ReportRow_MetricValue.Size(m)
}
func (m *ReportRow_MetricValue) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportRow_MetricValue.DiscardUnknown(m)
}

var xxx_messageInfo_ReportRow_MetricValue proto.InternalMessageInfo

type isReportRow_MetricValue_Value interface {
	isReportRow_MetricValue_Value()
}

type ReportRow_MetricValue_IntegerValue struct {
	IntegerValue int64 `protobuf:"varint,1,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type ReportRow_MetricValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type ReportRow_MetricValue_MicrosValue struct {
	MicrosValue int64 `protobuf:"varint,3,opt,name=micros_value,json=microsValue,proto3,oneof"`
}

func (*ReportRow_MetricValue_IntegerValue) isReportRow_MetricValue_Value() {}

func (*ReportRow_MetricValue_DoubleValue) isReportRow_MetricValue_Value() {}

func (*ReportRow_MetricValue_MicrosValue) isReportRow_MetricValue_Value() {}

func (m *ReportRow_MetricValue) GetValue() isReportRow_MetricValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ReportRow_MetricValue) GetIntegerValue() int64 {
	if x, ok := m.GetValue().(*ReportRow_MetricValue_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (m *ReportRow_MetricValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*ReportRow_MetricValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *ReportRow_MetricValue) GetMicrosValue() int64 {
	if x, ok := m.GetValue().(*ReportRow_MetricValue_MicrosValue); ok {
		return x.MicrosValue
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportRow_MetricValue) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportRow_MetricValue_IntegerValue)(nil),
		(*ReportRow_MetricValue_DoubleValue)(nil),
		(*ReportRow_MetricValue_MicrosValue)(nil),
	}
}

// Warnings associated with generation of the report.
type ReportWarning struct {
	// Type of the warning.
	Type ReportWarning_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.admob.v1.ReportWarning_Type" json:"type,omitempty"`
	// Describes the details of the warning message, in English.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportWarning) Reset()         { *m = ReportWarning{} }
func (m *ReportWarning) String() string { return proto.CompactTextString(m) }
func (*ReportWarning) ProtoMessage()    {}
func (*ReportWarning) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{4}
}

func (m *ReportWarning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportWarning.Unmarshal(m, b)
}
func (m *ReportWarning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportWarning.Marshal(b, m, deterministic)
}
func (m *ReportWarning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportWarning.Merge(m, src)
}
func (m *ReportWarning) XXX_Size() int {
	return xxx_messageInfo_ReportWarning.Size(m)
}
func (m *ReportWarning) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportWarning.DiscardUnknown(m)
}

var xxx_messageInfo_ReportWarning proto.InternalMessageInfo

func (m *ReportWarning) GetType() ReportWarning_Type {
	if m != nil {
		return m.Type
	}
	return ReportWarning_TYPE_UNSPECIFIED
}

func (m *ReportWarning) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Groups data helps to treat the generated report. Always sent as a first
// message in the stream response.
type ReportHeader struct {
	// The date range for which the report is generated. This is identical to the
	// range specified in the report request.
	DateRange *DateRange `protobuf:"bytes,1,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// Localization settings of the report. This is identical to the settings
	// in the report request.
	LocalizationSettings *LocalizationSettings `protobuf:"bytes,2,opt,name=localization_settings,json=localizationSettings,proto3" json:"localization_settings,omitempty"`
	// The report time zone. The value is a time-zone ID as specified by the CLDR
	// project, for example, "America/Los_Angeles".
	ReportingTimeZone    string   `protobuf:"bytes,3,opt,name=reporting_time_zone,json=reportingTimeZone,proto3" json:"reporting_time_zone,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportHeader) Reset()         { *m = ReportHeader{} }
func (m *ReportHeader) String() string { return proto.CompactTextString(m) }
func (*ReportHeader) ProtoMessage()    {}
func (*ReportHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{5}
}

func (m *ReportHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportHeader.Unmarshal(m, b)
}
func (m *ReportHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportHeader.Marshal(b, m, deterministic)
}
func (m *ReportHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportHeader.Merge(m, src)
}
func (m *ReportHeader) XXX_Size() int {
	return xxx_messageInfo_ReportHeader.Size(m)
}
func (m *ReportHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportHeader.DiscardUnknown(m)
}

var xxx_messageInfo_ReportHeader proto.InternalMessageInfo

func (m *ReportHeader) GetDateRange() *DateRange {
	if m != nil {
		return m.DateRange
	}
	return nil
}

func (m *ReportHeader) GetLocalizationSettings() *LocalizationSettings {
	if m != nil {
		return m.LocalizationSettings
	}
	return nil
}

func (m *ReportHeader) GetReportingTimeZone() string {
	if m != nil {
		return m.ReportingTimeZone
	}
	return ""
}

// Groups data available after report generation, for example, warnings and row
// counts. Always sent as the last message in the stream response.
type ReportFooter struct {
	// Warnings associated with generation of the report.
	Warnings []*ReportWarning `protobuf:"bytes,1,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Total number of rows that did match the request.
	MatchingRowCount     int64    `protobuf:"varint,2,opt,name=matching_row_count,json=matchingRowCount,proto3" json:"matching_row_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportFooter) Reset()         { *m = ReportFooter{} }
func (m *ReportFooter) String() string { return proto.CompactTextString(m) }
func (*ReportFooter) ProtoMessage()    {}
func (*ReportFooter) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{6}
}

func (m *ReportFooter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportFooter.Unmarshal(m, b)
}
func (m *ReportFooter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportFooter.Marshal(b, m, deterministic)
}
func (m *ReportFooter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportFooter.Merge(m, src)
}
func (m *ReportFooter) XXX_Size() int {
	return xxx_messageInfo_ReportFooter.Size(m)
}
func (m *ReportFooter) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportFooter.DiscardUnknown(m)
}

var xxx_messageInfo_ReportFooter proto.InternalMessageInfo

func (m *ReportFooter) GetWarnings() []*ReportWarning {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *ReportFooter) GetMatchingRowCount() int64 {
	if m != nil {
		return m.MatchingRowCount
	}
	return 0
}

// Specification of a single date range. Both dates are inclusive.
type DateRange struct {
	// Start date of the date range, inclusive. Must be less than or equal to the
	// end date.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of the date range, inclusive. Must be greater than or equal to the
	// start date.
	EndDate              *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DateRange) Reset()         { *m = DateRange{} }
func (m *DateRange) String() string { return proto.CompactTextString(m) }
func (*DateRange) ProtoMessage()    {}
func (*DateRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{7}
}

func (m *DateRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DateRange.Unmarshal(m, b)
}
func (m *DateRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DateRange.Marshal(b, m, deterministic)
}
func (m *DateRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DateRange.Merge(m, src)
}
func (m *DateRange) XXX_Size() int {
	return xxx_messageInfo_DateRange.Size(m)
}
func (m *DateRange) XXX_DiscardUnknown() {
	xxx_messageInfo_DateRange.DiscardUnknown(m)
}

var xxx_messageInfo_DateRange proto.InternalMessageInfo

func (m *DateRange) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *DateRange) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

// Localization settings for reports, such as currency and language. It affects
// how metrics are calculated.
type LocalizationSettings struct {
	// Currency code of the earning related metrics, which is the 3-letter code
	// defined in ISO 4217. The daily average rate is used for the currency
	// conversion. Defaults to the account currency code if unspecified.
	CurrencyCode string `protobuf:"bytes,1,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Language used for any localized text, such as some dimension value display
	// labels. The language tag defined in the IETF BCP47. Defaults to 'en-US' if
	// unspecified.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocalizationSettings) Reset()         { *m = LocalizationSettings{} }
func (m *LocalizationSettings) String() string { return proto.CompactTextString(m) }
func (*LocalizationSettings) ProtoMessage()    {}
func (*LocalizationSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{8}
}

func (m *LocalizationSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocalizationSettings.Unmarshal(m, b)
}
func (m *LocalizationSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocalizationSettings.Marshal(b, m, deterministic)
}
func (m *LocalizationSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalizationSettings.Merge(m, src)
}
func (m *LocalizationSettings) XXX_Size() int {
	return xxx_messageInfo_LocalizationSettings.Size(m)
}
func (m *LocalizationSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalizationSettings.DiscardUnknown(m)
}

var xxx_messageInfo_LocalizationSettings proto.InternalMessageInfo

func (m *LocalizationSettings) GetCurrencyCode() string {
	if m != nil {
		return m.CurrencyCode
	}
	return ""
}

func (m *LocalizationSettings) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// List of string values.
type StringList struct {
	// The string values.
	Values               []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringList) Reset()         { *m = StringList{} }
func (m *StringList) String() string { return proto.CompactTextString(m) }
func (*StringList) ProtoMessage()    {}
func (*StringList) Descriptor() ([]byte, []int) {
	return fileDescriptor_18366557740cead4, []int{9}
}

func (m *StringList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringList.Unmarshal(m, b)
}
func (m *StringList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringList.Marshal(b, m, deterministic)
}
func (m *StringList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringList.Merge(m, src)
}
func (m *StringList) XXX_Size() int {
	return xxx_messageInfo_StringList.Size(m)
}
func (m *StringList) XXX_DiscardUnknown() {
	xxx_messageInfo_StringList.DiscardUnknown(m)
}

var xxx_messageInfo_StringList proto.InternalMessageInfo

func (m *StringList) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.ads.admob.v1.SortOrder", SortOrder_name, SortOrder_value)
	proto.RegisterEnum("google.ads.admob.v1.NetworkReportSpec_Dimension", NetworkReportSpec_Dimension_name, NetworkReportSpec_Dimension_value)
	proto.RegisterEnum("google.ads.admob.v1.NetworkReportSpec_Metric", NetworkReportSpec_Metric_name, NetworkReportSpec_Metric_value)
	proto.RegisterEnum("google.ads.admob.v1.MediationReportSpec_Dimension", MediationReportSpec_Dimension_name, MediationReportSpec_Dimension_value)
	proto.RegisterEnum("google.ads.admob.v1.MediationReportSpec_Metric", MediationReportSpec_Metric_name, MediationReportSpec_Metric_value)
	proto.RegisterEnum("google.ads.admob.v1.ReportWarning_Type", ReportWarning_Type_name, ReportWarning_Type_value)
	proto.RegisterType((*PublisherAccount)(nil), "google.ads.admob.v1.PublisherAccount")
	proto.RegisterType((*NetworkReportSpec)(nil), "google.ads.admob.v1.NetworkReportSpec")
	proto.RegisterType((*NetworkReportSpec_DimensionFilter)(nil), "google.ads.admob.v1.NetworkReportSpec.DimensionFilter")
	proto.RegisterType((*NetworkReportSpec_SortCondition)(nil), "google.ads.admob.v1.NetworkReportSpec.SortCondition")
	proto.RegisterType((*MediationReportSpec)(nil), "google.ads.admob.v1.MediationReportSpec")
	proto.RegisterType((*MediationReportSpec_DimensionFilter)(nil), "google.ads.admob.v1.MediationReportSpec.DimensionFilter")
	proto.RegisterType((*MediationReportSpec_SortCondition)(nil), "google.ads.admob.v1.MediationReportSpec.SortCondition")
	proto.RegisterType((*ReportRow)(nil), "google.ads.admob.v1.ReportRow")
	proto.RegisterMapType((map[string]*ReportRow_DimensionValue)(nil), "google.ads.admob.v1.ReportRow.DimensionValuesEntry")
	proto.RegisterMapType((map[string]*ReportRow_MetricValue)(nil), "google.ads.admob.v1.ReportRow.MetricValuesEntry")
	proto.RegisterType((*ReportRow_DimensionValue)(nil), "google.ads.admob.v1.ReportRow.DimensionValue")
	proto.RegisterType((*ReportRow_MetricValue)(nil), "google.ads.admob.v1.ReportRow.MetricValue")
	proto.RegisterType((*ReportWarning)(nil), "google.ads.admob.v1.ReportWarning")
	proto.RegisterType((*ReportHeader)(nil), "google.ads.admob.v1.ReportHeader")
	proto.RegisterType((*ReportFooter)(nil), "google.ads.admob.v1.ReportFooter")
	proto.RegisterType((*DateRange)(nil), "google.ads.admob.v1.DateRange")
	proto.RegisterType((*LocalizationSettings)(nil), "google.ads.admob.v1.LocalizationSettings")
	proto.RegisterType((*StringList)(nil), "google.ads.admob.v1.StringList")
}

func init() {
	proto.RegisterFile("google/ads/admob/v1/admob_resources.proto", fileDescriptor_18366557740cead4)
}

var fileDescriptor_18366557740cead4 = []byte{
	// 1561 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xcf, 0x6f, 0xe3, 0xc6,
	0x15, 0x36, 0x25, 0x59, 0x12, 0x9f, 0x24, 0x9b, 0x9e, 0x75, 0xb6, 0xaa, 0x0f, 0xad, 0xab, 0xa4,
	0x8d, 0x13, 0x24, 0xf2, 0xc6, 0x09, 0x82, 0x45, 0x83, 0x16, 0xa5, 0xc9, 0xb1, 0x45, 0xac, 0x45,
	0xa9, 0x43, 0x7a, 0x17, 0xbb, 0x40, 0x33, 0xa5, 0xc5, 0xa9, 0x42, 0x58, 0xe2, 0xa8, 0x24, 0xbd,
	0x8e, 0x83, 0x9e, 0x7a, 0xe9, 0xa5, 0x7f, 0x43, 0x8f, 0xbd, 0x17, 0xb9, 0xf7, 0xd2, 0xbf, 0xa3,
	0x97, 0x5e, 0x7b, 0xe8, 0xb9, 0x87, 0x02, 0xc5, 0x0c, 0x49, 0x59, 0x92, 0xe9, 0xc6, 0xde, 0xba,
	0x28, 0x72, 0x9b, 0xf9, 0xf8, 0xbd, 0x1f, 0xf3, 0xe6, 0xcd, 0x37, 0x24, 0xe1, 0xbd, 0x31, 0xe7,
	0xe3, 0x09, 0xdb, 0xf7, 0xfc, 0x78, 0xdf, 0xf3, 0xa7, 0xfc, 0x6c, 0xff, 0xf5, 0x47, 0xe9, 0x80,
	0x46, 0x2c, 0xe6, 0x17, 0xd1, 0x88, 0xc5, 0xdd, 0x59, 0xc4, 0x13, 0x8e, 0x1e, 0xa5, 0xd4, 0xae,
	0xe7, 0xc7, 0x5d, 0xc9, 0xe8, 0xbe, 0xfe, 0x68, 0xe7, 0x71, 0x66, 0x9f, 0x5c, 0xcd, 0xd8, 0xbe,
	0xef, 0x25, 0x2c, 0x25, 0x77, 0xfe, 0xa0, 0x80, 0x36, 0xbc, 0x38, 0x9b, 0x04, 0xf1, 0x17, 0x2c,
	0xd2, 0x47, 0x23, 0x7e, 0x11, 0x26, 0x08, 0x41, 0x25, 0xf4, 0xa6, 0xac, 0xad, 0xec, 0x2a, 0x7b,
	0x2a, 0x91, 0x63, 0xf4, 0x03, 0x68, 0xce, 0x72, 0x1e, 0x0d, 0xfc, 0x76, 0x49, 0x3e, 0x6b, 0xcc,
	0x31, 0xcb, 0x47, 0x5d, 0x78, 0x14, 0xb1, 0x19, 0x8f, 0x92, 0x20, 0x1c, 0xd3, 0x24, 0x98, 0x32,
	0xfa, 0x15, 0x0f, 0x59, 0xbb, 0x2c, 0x99, 0x5b, 0xf3, 0x47, 0x6e, 0x30, 0x65, 0xaf, 0x78, 0xc8,
	0xd0, 0xdb, 0xd0, 0x1a, 0x5d, 0x44, 0x11, 0x0b, 0x47, 0x57, 0x74, 0xc4, 0x7d, 0xd6, 0xae, 0x48,
	0x66, 0x33, 0x07, 0x0d, 0xee, 0xb3, 0xce, 0x1f, 0x01, 0xb6, 0x6c, 0x96, 0x5c, 0xf2, 0xe8, 0x9c,
	0x48, 0x0f, 0xce, 0x8c, 0x8d, 0xd0, 0x4f, 0x00, 0xc4, 0x22, 0x68, 0xe4, 0x85, 0xe3, 0x34, 0xcf,
	0xc6, 0xc1, 0xf7, 0xba, 0x05, 0x0b, 0xef, 0x9a, 0x5e, 0xc2, 0x88, 0x60, 0x11, 0xd5, 0xcf, 0x87,
	0x68, 0x08, 0xe0, 0x07, 0x53, 0x16, 0xc6, 0x01, 0x0f, 0xe3, 0x76, 0x69, 0xb7, 0xbc, 0xb7, 0x71,
	0xf0, 0xa4, 0xd0, 0xfc, 0x46, 0xe8, 0xae, 0x99, 0x1b, 0x92, 0x05, 0x1f, 0xe8, 0x18, 0x6a, 0x53,
	0x96, 0x44, 0xc1, 0x28, 0x6e, 0x97, 0xa5, 0xbb, 0x0f, 0xef, 0xe8, 0xae, 0x2f, 0xad, 0x48, 0x6e,
	0x8d, 0x46, 0xb0, 0x35, 0x77, 0x4b, 0x7f, 0x15, 0x4c, 0x12, 0x16, 0xc5, 0xed, 0xca, 0x6e, 0x79,
	0xaf, 0x71, 0xf0, 0xe9, 0x7d, 0x33, 0x3c, 0x92, 0xe6, 0x44, 0xf3, 0x97, 0x81, 0x18, 0xfd, 0x02,
	0x36, 0x63, 0x1e, 0x25, 0x74, 0xc4, 0x43, 0x3f, 0x48, 0x64, 0x11, 0xd6, 0x65, 0x88, 0x4f, 0xee,
	0x18, 0xc2, 0xe1, 0x51, 0x62, 0xe4, 0xc6, 0x64, 0x23, 0x5e, 0x9c, 0xc6, 0xe8, 0x73, 0x78, 0x6b,
	0xc2, 0x47, 0xde, 0x24, 0xf8, 0xca, 0x13, 0x00, 0x8d, 0x59, 0x22, 0x36, 0x3e, 0x6e, 0x57, 0xe5,
	0x46, 0xbd, 0x57, 0x18, 0xe4, 0x64, 0xc1, 0xc2, 0xc9, 0x0c, 0xc8, 0xf6, 0xa4, 0x00, 0x45, 0x3f,
	0x82, 0xcd, 0xa9, 0xf7, 0x25, 0x4d, 0x3b, 0x8a, 0x46, 0xfc, 0x32, 0x6e, 0xd7, 0x76, 0x95, 0xbd,
	0x75, 0xd2, 0x9a, 0x7a, 0x5f, 0xa6, 0x59, 0x12, 0x7e, 0x19, 0xef, 0xfc, 0x49, 0x81, 0xcd, 0x95,
	0x62, 0x20, 0x1b, 0xd4, 0x79, 0x39, 0x64, 0xe3, 0xbc, 0xc9, 0xce, 0x5f, 0xbb, 0x40, 0x87, 0xd0,
	0x98, 0x7a, 0xc9, 0xe8, 0x0b, 0x16, 0x53, 0x2f, 0xbc, 0x92, 0xc7, 0xa2, 0x71, 0xf0, 0xfd, 0x42,
	0x8f, 0x4e, 0x12, 0x05, 0xe1, 0xf8, 0x24, 0x88, 0x93, 0xde, 0x1a, 0x81, 0xcc, 0x4a, 0x0f, 0xaf,
	0x0e, 0x01, 0xea, 0x7c, 0xc6, 0x22, 0x2f, 0xe1, 0xd1, 0xce, 0xdf, 0x15, 0x68, 0x2d, 0x55, 0x17,
	0x0d, 0x1f, 0x20, 0xe3, 0xde, 0xda, 0x62, 0xce, 0xc7, 0x50, 0x4d, 0xdb, 0x4d, 0xa6, 0x7b, 0xdf,
	0x5e, 0xed, 0xad, 0x91, 0xcc, 0x1c, 0x7d, 0x02, 0xeb, 0x3c, 0xf2, 0x59, 0x24, 0xcf, 0xf8, 0xc6,
	0x2d, 0x27, 0x50, 0xac, 0x66, 0x20, 0x58, 0x24, 0x25, 0x1f, 0xaa, 0x50, 0x93, 0xdd, 0xc7, 0xc3,
	0xce, 0x6f, 0x15, 0x50, 0xe7, 0x49, 0xa2, 0xef, 0xc2, 0x5b, 0xa6, 0xd5, 0xc7, 0xb6, 0x63, 0x0d,
	0x6c, 0x7a, 0x6a, 0x3b, 0x43, 0x6c, 0x58, 0x47, 0x16, 0x36, 0xb5, 0x35, 0x54, 0x87, 0x8a, 0xa9,
	0xbb, 0x58, 0x53, 0x90, 0x0a, 0xeb, 0xfd, 0x81, 0xed, 0xf6, 0xb4, 0x92, 0x00, 0x5f, 0x60, 0xfc,
	0x4c, 0x2b, 0xa3, 0x06, 0xd4, 0x74, 0x93, 0x9e, 0xda, 0x96, 0xab, 0x55, 0x50, 0x0d, 0xca, 0xfa,
	0x70, 0xa8, 0xad, 0x0b, 0xd4, 0x18, 0x9c, 0xda, 0x2e, 0x79, 0xa9, 0xd5, 0x10, 0x40, 0xf5, 0x68,
	0x40, 0xfa, 0xba, 0xab, 0xd5, 0x51, 0x13, 0xea, 0xc3, 0x13, 0xdd, 0x15, 0x73, 0x4d, 0xed, 0xfc,
	0x45, 0x81, 0x6a, 0xba, 0x34, 0xf4, 0x18, 0x50, 0x1f, 0xbb, 0xc4, 0x32, 0x56, 0xc2, 0x6f, 0x42,
	0x43, 0x37, 0x29, 0xc1, 0x3f, 0x3f, 0xc5, 0x8e, 0xeb, 0x68, 0x8a, 0xf0, 0x66, 0x9c, 0x58, 0xc6,
	0x33, 0x47, 0x2b, 0x09, 0x23, 0xec, 0xb8, 0x56, 0x5f, 0x77, 0xb1, 0x49, 0xb1, 0x4e, 0x6c, 0xcb,
	0x3e, 0x76, 0xb4, 0xb2, 0x30, 0xb2, 0xfa, 0x43, 0x82, 0x1d, 0xb1, 0x1e, 0x47, 0xab, 0x20, 0x04,
	0x1b, 0xd7, 0x00, 0x35, 0x5c, 0xa2, 0xad, 0xaf, 0x60, 0x64, 0xd8, 0xd7, 0xaa, 0x68, 0x1b, 0xb4,
	0xbe, 0xee, 0x1a, 0x3d, 0xbc, 0x10, 0xb2, 0x86, 0x36, 0x00, 0x24, 0x4a, 0x89, 0x28, 0x44, 0x1d,
	0xb5, 0x40, 0x75, 0x7a, 0x83, 0x17, 0xe9, 0x54, 0xed, 0xfc, 0x0d, 0xe0, 0x51, 0x9f, 0xf9, 0x81,
	0x3c, 0x2a, 0x0f, 0x27, 0x95, 0xa4, 0x40, 0x2a, 0x0f, 0x0a, 0xcd, 0x0b, 0x82, 0xdf, 0x22, 0x96,
	0xd6, 0xaa, 0x58, 0xee, 0xdf, 0xd9, 0xe1, 0xaa, 0x5c, 0xb2, 0xdb, 0xe5, 0xf2, 0xe9, 0xfd, 0xb3,
	0xbc, 0x55, 0x30, 0xe9, 0x6d, 0x82, 0xf9, 0xe9, 0x9d, 0x83, 0x7c, 0x3b, 0x24, 0xf3, 0xeb, 0x02,
	0xc9, 0x2c, 0x10, 0xa0, 0x37, 0xe9, 0x80, 0xff, 0xa1, 0x68, 0xfe, 0xe3, 0x86, 0x68, 0x92, 0x07,
	0xc9, 0x79, 0x59, 0x36, 0xad, 0x15, 0xd9, 0xbc, 0x6f, 0xd7, 0x3e, 0xa4, 0x70, 0xfe, 0xf9, 0x81,
	0x84, 0xb3, 0x05, 0xaa, 0x6e, 0x52, 0x67, 0x70, 0x4a, 0x0c, 0xac, 0x55, 0x84, 0x94, 0xcd, 0xa7,
	0xd4, 0xb2, 0x1d, 0x57, 0xb7, 0x0d, 0x9c, 0x2a, 0x69, 0xae, 0xaf, 0xd5, 0x5c, 0x5f, 0x6b, 0xe8,
	0x11, 0x6c, 0xf6, 0xb1, 0x69, 0xe9, 0xae, 0x08, 0x7b, 0x4c, 0x06, 0xa7, 0x43, 0xad, 0xb1, 0x28,
	0xba, 0xf5, 0x05, 0xd1, 0x55, 0x97, 0x44, 0x17, 0x3a, 0x5f, 0xff, 0x3f, 0x45, 0xb7, 0x48, 0x60,
	0xab, 0x2b, 0x02, 0x5b, 0x43, 0x5b, 0xd0, 0x1a, 0x1c, 0x3a, 0x98, 0x3c, 0x17, 0x11, 0x8c, 0x61,
	0x5f, 0xab, 0x77, 0xfe, 0x59, 0x01, 0x75, 0x7e, 0x5a, 0xd0, 0xe7, 0x70, 0xad, 0x14, 0xf4, 0xb5,
	0x37, 0xb9, 0x60, 0x71, 0x5b, 0x91, 0xb2, 0xf0, 0x71, 0xe1, 0x86, 0xce, 0x2d, 0xaf, 0x3b, 0xec,
	0xb9, 0xb4, 0xc2, 0x61, 0x12, 0x5d, 0x91, 0x4d, 0x7f, 0x19, 0x45, 0xa7, 0xd0, 0x4a, 0xfb, 0x25,
	0x77, 0x5e, 0x92, 0xce, 0x9f, 0x7c, 0x83, 0xf3, 0xb4, 0xac, 0x8b, 0x9e, 0x9b, 0xd3, 0x05, 0x68,
	0xe7, 0x19, 0x6c, 0x2c, 0xc7, 0x47, 0xdb, 0xb0, 0x2e, 0x23, 0x64, 0x6f, 0xfc, 0xe9, 0x44, 0xbc,
	0x9f, 0xfb, 0x41, 0x3c, 0x9b, 0x78, 0x57, 0x74, 0xe2, 0x9d, 0xb1, 0x49, 0xf6, 0xce, 0xdf, 0xcc,
	0xc0, 0x13, 0x81, 0xed, 0xfc, 0x4e, 0x81, 0xc6, 0x42, 0x40, 0xf4, 0x43, 0x68, 0x05, 0x61, 0xc2,
	0xc6, 0x2c, 0xa2, 0xd7, 0x2e, 0xcb, 0xbd, 0x35, 0xd2, 0xcc, 0xe0, 0xe7, 0x99, 0xef, 0xa6, 0xcf,
	0x2f, 0xce, 0x26, 0x2c, 0x63, 0x09, 0xd7, 0x4a, 0x6f, 0x8d, 0x34, 0x52, 0x74, 0x4e, 0x9a, 0x06,
	0xa3, 0x88, 0xc7, 0x19, 0xa9, 0x9c, 0xb9, 0x6a, 0xa4, 0xa8, 0x24, 0x1d, 0xd6, 0xb2, 0xdc, 0x77,
	0x7e, 0x0d, 0xdb, 0x45, 0x65, 0x45, 0x1a, 0x94, 0xcf, 0xd9, 0x55, 0xb6, 0x34, 0x31, 0x44, 0x46,
	0xbe, 0xdc, 0x54, 0x78, 0x3e, 0xbc, 0xd7, 0x66, 0x65, 0xd5, 0xf9, 0x71, 0xe9, 0xa9, 0xb2, 0x73,
	0x0e, 0x5b, 0x37, 0x8a, 0x5d, 0x10, 0xef, 0x67, 0xcb, 0xf1, 0xde, 0xbf, 0xfb, 0xfe, 0x2d, 0x04,
	0xeb, 0xfc, 0x4b, 0x81, 0x56, 0x4a, 0x7a, 0xe1, 0x45, 0x61, 0x10, 0x8e, 0xd1, 0x67, 0x50, 0x11,
	0xdf, 0x73, 0x99, 0xbe, 0xbd, 0xfb, 0x1f, 0xdc, 0x66, 0x16, 0x5d, 0xf7, 0x6a, 0xc6, 0x88, 0x34,
	0x42, 0xbb, 0xd0, 0xf0, 0x59, 0x3c, 0x8a, 0x82, 0x99, 0x10, 0xab, 0xfc, 0x7b, 0x6e, 0x01, 0xea,
	0xfc, 0x5e, 0x81, 0x8a, 0x30, 0x10, 0xc7, 0xc5, 0x7d, 0x39, 0xc4, 0x2b, 0xc7, 0xf3, 0x5d, 0x78,
	0xdb, 0xd4, 0x5d, 0x9d, 0x1e, 0xe2, 0xa3, 0x01, 0xc1, 0x54, 0x37, 0xe4, 0xb1, 0xa7, 0xae, 0xd5,
	0xc7, 0xaf, 0x06, 0x36, 0xa6, 0x46, 0x4f, 0xb7, 0x8f, 0x85, 0xf0, 0x68, 0xd0, 0x94, 0x44, 0x13,
	0x9f, 0xe8, 0x2f, 0xb1, 0xa9, 0x95, 0x84, 0x14, 0x0d, 0xdc, 0x1e, 0x26, 0x5a, 0x19, 0xed, 0xc1,
	0x3b, 0x04, 0x0f, 0x07, 0xc4, 0xa5, 0xc6, 0x29, 0x21, 0xd8, 0x36, 0x5e, 0x52, 0x7b, 0xe0, 0xce,
	0xbd, 0xe5, 0xa0, 0x56, 0xe9, 0xfc, 0x55, 0x81, 0x66, 0xba, 0x9a, 0x1e, 0xf3, 0x7c, 0x16, 0xfd,
	0xb7, 0x6f, 0x36, 0xb7, 0x5e, 0xb9, 0xa5, 0x87, 0xb9, 0x72, 0xef, 0xf9, 0x39, 0xdc, 0xf9, 0x4d,
	0xbe, 0xbc, 0x23, 0xce, 0xc5, 0xb5, 0xfb, 0x53, 0xa8, 0x5f, 0xa6, 0xdb, 0x96, 0xab, 0x4a, 0xe7,
	0x9b, 0x77, 0x98, 0xcc, 0x6d, 0xd0, 0x07, 0x80, 0xe4, 0x75, 0x29, 0xc2, 0x47, 0xfc, 0x92, 0xca,
	0x6f, 0x7b, 0xb9, 0xb8, 0x32, 0xd1, 0xf2, 0x27, 0x84, 0x5f, 0x1a, 0x02, 0xef, 0x9c, 0x83, 0x3a,
	0xaf, 0x12, 0x7a, 0x02, 0x10, 0x27, 0x5e, 0x94, 0x50, 0x51, 0xad, 0xac, 0xb2, 0x5b, 0x79, 0x70,
	0xd1, 0x3d, 0x69, 0x45, 0x55, 0x49, 0x12, 0x43, 0xf4, 0x01, 0xd4, 0x59, 0xe8, 0xa7, 0xfc, 0xd2,
	0x6d, 0xfc, 0x1a, 0x0b, 0x7d, 0x31, 0xe8, 0xfc, 0x12, 0xb6, 0x8b, 0x0a, 0x79, 0xf3, 0x8f, 0x80,
	0x72, 0xf3, 0x8f, 0x80, 0x20, 0x4d, 0xbc, 0x70, 0x7c, 0xe1, 0x8d, 0x59, 0x4a, 0xca, 0x64, 0x29,
	0x07, 0xe5, 0x6f, 0x83, 0x77, 0x00, 0xae, 0xdf, 0x1c, 0xd0, 0x63, 0xa8, 0x2e, 0xc8, 0xb3, 0x4a,
	0xb2, 0xd9, 0xfb, 0x47, 0xa0, 0xce, 0x2f, 0x59, 0xb4, 0x03, 0x8f, 0x1d, 0xd1, 0x87, 0x03, 0x62,
	0x62, 0xb2, 0xd2, 0xeb, 0xe2, 0x9a, 0x74, 0x0c, 0x6c, 0x9b, 0x96, 0x7d, 0xac, 0x29, 0xe2, 0xa6,
	0x30, 0xf1, 0x7c, 0x5e, 0x3a, 0x1c, 0xc3, 0x77, 0x46, 0x7c, 0x5a, 0xb4, 0x3b, 0x87, 0x48, 0xf7,
	0xfb, 0xfc, 0x8c, 0x64, 0xff, 0x68, 0x86, 0x11, 0x4f, 0xf8, 0xab, 0xa7, 0x19, 0x71, 0xcc, 0x45,
	0xce, 0x5d, 0x1e, 0x8d, 0xf7, 0xc7, 0x2c, 0x94, 0x3f, 0x64, 0xf6, 0xd3, 0x47, 0xde, 0x2c, 0x88,
	0x97, 0xfe, 0xf5, 0x7c, 0x26, 0x07, 0x67, 0x55, 0x49, 0xfa, 0xf8, 0xdf, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x11, 0x26, 0xab, 0xc4, 0x0f, 0x12, 0x00, 0x00,
}
